#include        "sw.h"

/*
                        Copyright (C) 1984-2000 David L. Clark.

                        All rights reserved except as specified in the
                        file license.txt.  Distribution of this file
                        without the license.txt file accompanying is
                        prohibited.
*/


char    swbmbsym[BOMBANGS][BOMBBYTES] = {

/*  bomb symbols based on the following template file:
08
. . . . . . . .
. . . . . . . .
1 1 . 1 1 1 1 .
1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1
1 1 . 1 1 1 1 .
. .  .. . . . .
. . . . . . . .
*/
       0x0 , 0x0 , 0x0 , 0x0 , 0x51, 0x54, 0x55, 0x55, 0x55, 0x55,
       0x51, 0x54, 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x54, 0x1 , 0x55, 0x5 , 0x55, 0x11, 0x54,
       0x55, 0x10, 0x15, 0x40, 0x1 , 0x0 ,
       0x1 , 0x40, 0x5 , 0x50, 0x5 , 0x50, 0x5 , 0x50, 0x5 , 0x50,
       0x1 , 0x40, 0x5 , 0x50, 0x5 , 0x50,
       0x0 , 0x0 , 0x15, 0x0 , 0x55, 0x40, 0x55, 0x50, 0x15, 0x44,
       0x4 , 0x55, 0x1 , 0x54, 0x0 , 0x40,
       0x0 , 0x0 , 0x0 , 0x0 , 0x15, 0x45, 0x55, 0x55, 0x55, 0x55,
       0x15, 0x45, 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x40, 0x1 , 0x54, 0x4 , 0x55, 0x15, 0x44, 0x55, 0x50,
       0x55, 0x40, 0x15, 0x0 , 0x0 , 0x0 ,
       0x5 , 0x50, 0x5 , 0x50, 0x1 , 0x40, 0x5 , 0x50, 0x5 , 0x50,
       0x5 , 0x50, 0x5 , 0x50, 0x1 , 0x40,
       0x1 , 0x0 , 0x15, 0x40, 0x55, 0x10, 0x11, 0x54, 0x5 , 0x55,
       0x1 , 0x55, 0x0 , 0x54, 0x0 , 0x0
};

char    swtrgsym[TARGORIENTS][TARGBYTES] = {

/*  target symbols based on the following template files:
16                                    16
. . . . . . . . . . . 2 . . . .       . . . . . . . . . . 2 2 . . 2 2
. . . . . . . . . . . 2 1 1 1 1       . . . . . . . . . . 2 2 . . 2 2
. . . . . . . . . . . 2 1 1 1 1       . . . . . . . . . . 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 1 1 1 1 1 1 1 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 1 1 1 1 1 1 1 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 2 1 2 1 2 1 1 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1       1 1 1 2 1 2 1 2 1 1 1 1 1 1 2 2
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 2 2 2 2 2 2 2 2 2 2 2 1 1       1 1 1 2 1 2 1 2 1 2 1 2 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 2 1 2 1 2 1 2 1 2 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 2 1 2 1 2 1 2 1 2 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2


16                                    16
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . 1 1 1 1 1 1 1 1 1 1 . . .       . . . . . . . . . . . . . . . .
. 1 1 1 1 1 1 1 1 1 1 1 1 1 1 .       . . . . . . . . . . . . . . . .
1 1 1 1 1 1 2 1 2 1 1 1 1 1 1 1       . . . . . 1 1 1 1 1 1 . . . . .
1 1 1 1 1 1 2 2 2 1 1 1 1 1 1 1       . . . . . 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 2 1 2 1 1 1 1 1 1 1       . . . . . 1 1 1 1 1 1 . . . . .
1 1 1 1 1 1 2 2 2 1 1 1 1 1 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
. 1 1 1 1 1 2 1 2 1 1 1 1 1 1 .       1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
. . 1 1 1 1 2 2 2 1 1 1 1 1 . .       1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1
. . 2 2 . . 2 . 2 . . . 2 2 . .       2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2
. . 2 2 . . 2 2 2 . . . 2 2 . .       2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2
. . 2 2 . . 2 . 2 . . . 2 2 . .       . 2 2 2 2 2 2 2 2 2 2 2 2 2 2 .
*/
       0x0 , 0x0 , 0x2 , 0x0 , 0x0 , 0x0 , 0x2 , 0x55, 0x0 , 0x0 ,
       0x2 , 0x55, 0x0 , 0x0 , 0x2 , 0x0 , 0x0 , 0x0 , 0x2 , 0x0 ,
       0x0 , 0x0 , 0x2 , 0x0 , 0x0 , 0x0 , 0x2 , 0x0 , 0x55, 0x55,
       0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xA5,
       0x59, 0x55, 0x55, 0x65, 0x59, 0x55, 0x55, 0x65, 0x59, 0x55,
       0x55, 0x65, 0x59, 0x55, 0x55, 0x65, 0x59, 0x55, 0x55, 0x65,
       0x59, 0x55, 0x55, 0x65,
       0x0 , 0x0 , 0xA , 0xA , 0x0 , 0x0 , 0xA , 0xA , 0x0 , 0x0 ,
       0xA , 0xA , 0x55, 0x55, 0x5A, 0xA , 0x55, 0x55, 0x5A, 0xA ,
       0x56, 0x66, 0x5A, 0xA , 0x55, 0x55, 0x55, 0x5A, 0x56, 0x66,
       0x55, 0x5A, 0x55, 0x55, 0x55, 0x5A, 0x56, 0x66, 0x66, 0x5A,
       0x55, 0x55, 0x55, 0x5A, 0x56, 0x66, 0x66, 0x5A, 0x55, 0x55,
       0x55, 0x5A, 0x56, 0x66, 0x66, 0x5A, 0x55, 0x55, 0x55, 0x5A,
       0x55, 0x55, 0x55, 0x5A,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x1 , 0x55, 0x55, 0x40, 0x15, 0x55, 0x55, 0x54, 0x55, 0x59,
       0x95, 0x55, 0x55, 0x5A, 0x95, 0x55, 0x55, 0x59, 0x95, 0x55,
       0x55, 0x5A, 0x95, 0x55, 0x15, 0x59, 0x95, 0x54, 0x5 , 0x5A,
       0x95, 0x50, 0xA , 0x8 , 0x80, 0xA0, 0xA , 0xA , 0x80, 0xA0,
       0xA , 0x8 , 0x80, 0xA0,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x15,
       0x54, 0x0 , 0x0 , 0x15, 0x55, 0x55, 0x0 , 0x15, 0x54, 0x0 ,
       0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x6A, 0xAA,
       0xAA, 0xA9, 0x95, 0x55, 0x55, 0x56, 0x95, 0x55, 0x55, 0x56,
       0x2A, 0xAA, 0xAA, 0xA8
};

char    swhtrsym[TARGBYTES] = {

/*  hit target symbols based on the following template file:
16
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . 1 .
1 . . . . . . . . . . . . . 1 1
1 1 . . . 1 . . . . . 2 . 1 1 1
1 1 . 1 1 1 . . 1 1 . 2 1 1 1 1
1 1 1 1 2 2 1 1 1 1 2 1 1 1 1 1
1 1 1 1 2 2 1 1 1 2 1 1 1 1 1 1
*/
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x4 , 0x40, 0x0 , 0x0 , 0x5 , 0x50, 0x10,
       0x2 , 0x15, 0x51, 0x50, 0x52, 0x55, 0x55, 0xA5, 0x59, 0x55,
       0x55, 0xA5, 0x65, 0x55
};

char    swexpsym[EXPLSYMS][EXPBYTES] = {

/*  explosion symbols based on the following template files:
08                 08                08                08
1 1 1 . 2 . . .    . . . 1 1 . . .   . . . . . 2 . .   . . . 1 1 . . .
1 1 1 . 2 . . .    . 1 1 1 1 1 1 .   . . . . 2 2 2 .   . . . 1 1 1 . .
1 1 1 2 . . . .    1 1 1 2 2 1 1 1   . . . 2 2 2 2 2   . 1 1 1 1 1 1 .
. . 2 2 2 1 1 1    1 1 2 2 2 2 1 1   . . 2 2 2 2 2 .   1 1 1 1 1 1 1 1
2 2 . 2 1 1 1 1    1 1 2 2 2 2 1 1   . 2 2 2 2 2 . .   1 1 1 1 1 1 1 1
. . . 1 1 . . .    1 1 1 2 2 1 1 1   2 2 2 2 2 . . .   . 1 1 1 1 . 1 .
. . . 1 1 . . .    . 1 1 1 1 1 1 .   . 2 2 2 . . . .   . . 1 1 1 . . .
. . . 1 1 . . .    . . . 1 1 . . .   . . 2 . . . . .   . . . 1 1 . . .

08                 08                08                08
. 1 2 2 2 . . .    1 1 . . . . . .   . . . . . . . .   . . . . . . . .
. 1 1 1 1 1 . .    1 1 . . 1 2 . .   . . . . . . 1 1   . 1 . . . 1 . .
. . 2 2 1 2 1 .    . . . . 2 1 . .   . . . . . . 1 1   . . . 1 . . . .
2 1 1 2 2 2 1 .    . . . . . . . .   . . . 1 1 . . .   . . . . . . 1 .
. . . . . . 1 1    . . . . . 2 2 .   1 2 . 1 1 . . .   1 . 1 . . . . .
. 1 2 . . . 1 2    . 2 2 . . 2 2 .   2 1 . . . . . .   . . . . 1 . . 1
. . 1 1 . . 2 1    . 2 2 . . . . .   . . . . . 2 2 .   . . 1 . . . . .
. . 1 2 . . . 1    . . . . . . . .   . . . . . 2 2 .   . . . . . . 1 .
*/

       0x54, 0x80, 0x54, 0x80, 0x56, 0x0 , 0xA , 0x95, 0xA2, 0x55,
       0x1 , 0x40, 0x1 , 0x40, 0x1 , 0x40,
       0x1 , 0x40, 0x15, 0x54, 0x56, 0x95, 0x5A, 0xA5, 0x5A, 0xA5,
       0x56, 0x95, 0x15, 0x54, 0x1 , 0x40,
       0x0 , 0x20, 0x0 , 0xA8, 0x2 , 0xAA, 0xA , 0xA8, 0x2A, 0xA0,
       0xAA, 0x80, 0x2A, 0x0 , 0x8 , 0x0 ,
       0x1 , 0x40, 0x1 , 0x50, 0x15, 0x54, 0x55, 0x55, 0x55, 0x55,
       0x15, 0x44, 0x5 , 0x40, 0x1 , 0x40,
       0x1A, 0x80, 0x15, 0x50, 0xA , 0x64, 0x96, 0xA4, 0x0 , 0x5 ,
       0x18, 0x6 , 0x5 , 0x9 , 0x6 , 0x1 ,
       0x50, 0x0 , 0x50, 0x60, 0x0 , 0x90, 0x0 , 0x0 , 0x0 , 0x28,
       0x28, 0x28, 0x28, 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x5 , 0x0 , 0x5 , 0x1 , 0x40, 0x61, 0x40,
       0x90, 0x0 , 0x0 , 0x28, 0x0 , 0x28,
       0x0 , 0x0 , 0x10, 0x10, 0x1 , 0x0 , 0x0 , 0x4 , 0x44, 0x0 ,
       0x0 , 0x41, 0x4 , 0x0 , 0x0 , 0x4
};

char    swflksym[FLCKSYMS][FLKBYTES] = {

/*  flock symbols based on the following template files:
16                                16
. 3 . . . . . . . . . . . . . .   3 . 3 . . . . . . . . . . . . .
3 . 3 . . . . . . . . . . . . .   . 3 . . . . . . . . . . . . . .
. . . . . . . 3 . 3 . . . . 3 .   . . . . . . . . 3 . . . . 3 . 3
. . . 3 . . . . 3 . . . . 3 . 3   . . 3 . 3 . . 3 . 3 . . . . 3 .
. . 3 . 3 . . . . . . . . . . .   . . . 3 . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
3 . 3 . . 3 . 3 . . . . 3 . . .   . 3 . . . . 3 . . . . 3 . 3 . .
. 3 . . . . 3 . . . . 3 . 3 . .   3 . 3 . . 3 . 3 . . . . 3 . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . 3 . 3 . . 3 . . . . 3 . 3 .   . . . 3 . . 3 . 3 . . . . 3 . .
. . . 3 . . 3 . 3 . . . . 3 . .   . . 3 . 3 . . 3 . . . . 3 . 3 .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . 3 . . . . . . 3 . . . . .   . . 3 . 3 . . . . 3 . 3 . . . .
. . 3 . 3 . . . . 3 . 3 . . . .   . . . 3 . . . . . . 3 . . . . .
. . . . . . 3 . 3 . . . . . . .   . . . . . . . 3 . . . . . . . .
. . . . . . . 3 . . . . . . . .   . . . . . . 3 . 3 . . . . . . .
*/
       0x30, 0x0 , 0x0 , 0x0 , 0xCC, 0x0 , 0x0 , 0x0 , 0x0 , 0x3 ,
       0x30, 0xC , 0x3 , 0x0 , 0xC0, 0x33, 0xC , 0xC0, 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0xCC, 0x33, 0x0 , 0xC0, 0x30, 0xC ,
       0x3 , 0x30, 0x0 , 0x0 , 0x0 , 0x0 , 0xC , 0xC3, 0x0 , 0xCC,
       0x3 , 0xC , 0xC0, 0x30, 0x0 , 0x0 , 0x0 , 0x0 , 0x3 , 0x0 ,
       0xC , 0x0 , 0xC , 0xC0, 0x33, 0x0 , 0x0 , 0xC , 0xC0, 0x0 ,
       0x0 , 0x3 , 0x0 , 0x0 ,
       0xCC, 0x0 , 0x0 , 0x0 , 0x30, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0xC0, 0x33, 0xC , 0xC3, 0x30, 0xC , 0x3 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x30, 0xC , 0x3 , 0x30, 0xCC, 0x33,
       0x0 , 0xC0, 0x0 , 0x0 , 0x0 , 0x0 , 0x3 , 0xC , 0xC0, 0x30,
       0xC , 0xC3, 0x0 , 0xCC, 0x0 , 0x0 , 0x0 , 0x0 , 0xC , 0xC0,
       0x33, 0x0 , 0x3 , 0x0 , 0xC , 0x0 , 0x0 , 0x3 , 0x0 , 0x0 ,
       0x0 , 0xC , 0xC0, 0x0
};

char    swbrdsym[BIRDSYMS][BRDBYTES] = {

/*  bird symbols based on the following template files:
4         4
. 3 . .   3 . 3 .
3 . 3 .   . 3 . .
*/
       0x30, 0xCC, 0xCC, 0x30
};

char    swoxsym[OXSYMS][OXBYTES] = {

/*  ox symbols based on the following template files:
16                                16
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . 3 . . 3 . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . 3 2 2 2 . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . 2 3 1 3 3 .   . . . . . . . . . . . . . . . .
. . . 2 2 2 2 2 2 3 2 2 3 3 3 .   . . . . . . . . . . . . . . . .
. 2 2 2 2 2 2 2 2 3 2 2 3 3 2 3   . . . . . . . . . . . . . . . .
3 2 2 2 2 2 2 2 2 3 2 2 2 3 3 .   . . . . . . . . . . . . . . . .
3 2 2 2 2 2 2 2 2 2 3 3 . . . .   . . . . . . . . . . . . 3 . . .
3 2 2 2 2 2 2 2 2 2 2 2 . . . .   . . 2 2 2 2 2 2 2 2 . 2 2 2 . .
3 2 2 . 2 2 . . 2 2 . 2 2 . . .   3 2 3 3 2 2 2 2 3 3 2 2 2 3 3 .
. 2 2 . 2 2 . . 2 2   2 2 . . .   3 2 2 2 2 2 2 2 2 2 2 2 2 3 3 .
. 3 3 . 3 3 . . 3 3 . 3 3 . . .   3 2 2 3 3 2 2 3 3 2 . 2 2 3 . .
*/
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0xC , 0x30, 0x0 , 0x0 , 0xE , 0xA0, 0x0 , 0x0 ,
       0xB , 0x7C, 0x2 , 0xAA, 0xBA, 0xFC, 0x2A, 0xAA, 0xBA, 0xFB,
       0xEA, 0xAA, 0xBA, 0xBC, 0xEA, 0xAA, 0xAF, 0x0 , 0xEA, 0xAA,
       0xAA, 0x0 , 0xE8, 0xA0, 0xA2, 0x80, 0x28, 0xA0, 0xA2, 0x80,
       0x3C, 0xF0, 0xF3, 0xC0,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0xC0, 0xA , 0xAA,
       0xA2, 0xA0, 0xEF, 0xAA, 0xFA, 0xBC, 0xEA, 0xAA, 0xAA, 0xBC,
       0xEB, 0xEB, 0xE2, 0xB0
};

char    swghtsym[GHSTBYTES] = {

/*  ghost symbol based on the following template file:
08
0 0 1 1 1 1 0 0
0 1 1 1 1 1 1 0
1 1 2 1 1 2 1 1
1 2 2 2 2 2 2 1
1 1 2 1 1 2 1 1
1 1 1 1 1 1 1 1
1 2 2 2 2 2 2 1
1 1 1 1 1 1 1 1
*/
       0x5 , 0x50, 0x15, 0x54, 0x59, 0x65, 0x6A, 0xA9, 0x59, 0x65,
       0x55, 0x55, 0x6A, 0xA9, 0x55, 0x55
};

char    swshtsym[SHOTBYTES] = {

/*  shot window symbol based on the following template file:
16
. . . . . . . . . . . . . . 1 .
. . . 1 . . . . . . . . 1 1 . .
. . . 1 . . . . . 1 1 1 . . . .
. . . . 1 . . . 1 . . . . . . .
. . . . 1 . . 1 . . 1 1 . . . .
. . . . . 1 1 1 . 1 . . 1 . . .
1 1 1 1 . 1 1 2 1 . . . . 1 1 .
. . . . 1 1 1 2 2 1 . . . . . 1
. . . . 1 1 1 2 1 1 . . . . . .
. . . . . 1 2 2 1 . 1 1 . . . .
. . . . 1 . 1 1 . . . . 1 . . .
. . . 1 . . . 1 . . . . 1 . . .
. . 1 . . . . 1 . . . . 1 . . .
. . 1 . . 1 1 1 . . . 1 . . . .
. . 1 . 1 . . . . . . . 1 . . .
. . . . . 1 1 . . . . . . 1 . .
*/
       0x0 , 0x0 , 0x0 , 0x4 , 0x1 , 0x0 , 0x0 , 0x50, 0x1 , 0x0 ,
       0x15, 0x0 , 0x0 , 0x40, 0x40, 0x0 , 0x0 , 0x41, 0x5 , 0x0 ,
       0x0 , 0x15, 0x10, 0x40, 0x55, 0x16, 0x40, 0x14, 0x0 , 0x56,
       0x90, 0x1 , 0x0 , 0x56, 0x50, 0x0 , 0x0 , 0x1A, 0x45, 0x0 ,
       0x0 , 0x45, 0x0 , 0x40, 0x1 , 0x1 , 0x0 , 0x40, 0x4 , 0x1 ,
       0x0 , 0x40, 0x4 , 0x15, 0x1 , 0x0 , 0x4 , 0x40, 0x0 , 0x40,
       0x0 , 0x14, 0x0 , 0x10
};

char    swsplsym[SPLTBYTES] = {

/*  splatted bird symbol based on the following template file:
32
. . . . . . . . . . . . . . . . . 2 2 2 . . . . . . . . . . . .
. . . . . . . . . . . . . . . . . 2 1 1 2 2 . . . . . . . . . .
. . . 1 . . . . . . . . . . . . . . 2 1 1 1 2 . . . . . . 1 . .
. . 1 1 1 . . . . . . . . . . . . . . 2 1 1 1 2 . . . . . 1 . .
. . . 1 1 . . . . . 1 . . . . . . . . 2 1 1 1 1 2 . . . 1 1 . .
. . . 1 1 . . . . 1 1 1 . . . . . . . 2 1 1 1 1 1 2 . . . . . .
. . . . . . . . . . 1 . . . . 1 . . . 2 1 1 1 1 1 1 2 . . . . .
. . . . . . . . . . . . . . . . . . . 2 1 1 1 1 1 1 1 2 . . . .
. . . . 1 . . . . . . . . . . . . . 2 1 1 1 1 1 1 1 1 2 . . . .
. . . . . . . . . . . . . . . . . 2 1 1 1 1 1 1 1 1 1 2 . . . .
. . . . . . . . . . . . . 1 . . 2 1 1 1 1 1 1 1 1 1 1 2 . . . .
. . 1 . . . . . . . . . . . . 2 1 1 1 1 1 1 1 1 1 1 1 2 . . . .
. . . . . . . 2 2 2 2 2 2 . 2 1 1 1 1 1 1 1 1 1 1 1 2 . . . . .
. . . . . . 2 1 1 1 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 2 . . . . . .
. . . . . 2 1 2 1 1 1 2 1 1 2 1 1 1 1 1 1 1 1 1 2 . . . . 1 1 .
. . . . 2 1 2 . 2 1 2.. 2 1 1 2 1 1 1 1 1 1 1 2 . . . . . . . .
. . . . 2 1 2 . 2 1 2 . 2 1 1 2 2 2 1 1 2 2 2 . . . 1 . . . . .
. . . . 2 1 1 2 1 1 1 2 1 1 1 2 1 1 2 2 . . . . . . . . . . 1 .
. . . . 2 1 1 1 1 1 1 1 1 1 1 2 1 1 1 2 . . . . . . 1 . 1 . . .
. . . . 2 1 2 2 1 2 1 1 1 1 1 2 1 1 1 1 2 . . . . . . . . . . .
. . . . . 2 2 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 . . . . . . . 1 . .
. . . . 2 2 1 2 1 1 1 1 1 2 . 2 1 1 1 1 1 1 2 2 2 2 2 . . . . .
. . . 2 2 1 2 2 2 2 2 2 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 . . . .
. . 2 2 1 2 . . . . . . 2 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 . . .
. . 2 1 2 . . . . . . . 2 . 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 . .
. . . . . . . . . . . . 2 . . 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 .
. . . . . . . . . . . . 2 . . . 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2
. . . . . . . . . . . 2 . . . . . 2 . . . 2 1 1 1 1 1 1 1 1 1 2
. . . 1 . . . . 2 2 2 2 2 . . . . 2 . . . . 2 2 2 2 2 1 1 1 1 2
. 1 1 . . . 1 . . . 2 . . . 2 2 2 2 2 2 . . . . . . . 2 1 1 1 2
1 1 1 . . 1 1 1 . . 2 . . . . . 2 . . . . 1 . . . . . . 2 1 2 .
1 1 . . . . 1 . . . . . . . . 2 . . . . . . . . 1 . . . . 2 . .
*/
       0x0 , 0x0 , 0x0 , 0x0 , 0x2A, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x25, 0xA0, 0x0 , 0x0 , 0x1 , 0x0 , 0x0 , 0x0 ,
       0x9 , 0x58, 0x0 , 0x10, 0x5 , 0x40, 0x0 , 0x0 , 0x2 , 0x56,
       0x0 , 0x10, 0x1 , 0x40, 0x4 , 0x0 , 0x2 , 0x55, 0x80, 0x50,
       0x1 , 0x40, 0x15, 0x0 , 0x2 , 0x55, 0x60, 0x0 , 0x0 , 0x0 ,
       0x4 , 0x1 , 0x2 , 0x55, 0x58, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x2 , 0x55, 0x56, 0x0 , 0x0 , 0x40, 0x0 , 0x0 , 0x9 , 0x55,
       0x56, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x25, 0x55, 0x56, 0x0 ,
       0x0 , 0x0 , 0x0 , 0x10, 0x95, 0x55, 0x56, 0x0 , 0x4 , 0x0 ,
       0x0 , 0x2 , 0x55, 0x55, 0x56, 0x0 , 0x0 , 0x2 , 0xAA, 0x89,
       0x55, 0x55, 0x58, 0x0 , 0x0 , 0x9 , 0x55, 0x65, 0x55, 0x55,
       0x60, 0x0 , 0x0 , 0x26, 0x56, 0x59, 0x55, 0x55, 0x80, 0x14,
       0x0 , 0x98, 0x98, 0x96, 0x55, 0x56, 0x0 , 0x0 , 0x0 , 0x98,
       0x98, 0x96, 0xA5, 0xA8, 0x4 , 0x0 , 0x0 , 0x96, 0x56, 0x56,
       0x5A, 0x0 , 0x0 , 0x4 , 0x0 , 0x95, 0x55, 0x56, 0x56, 0x0 ,
       0x4 , 0x40, 0x0 , 0x9A, 0x65, 0x56, 0x55, 0x80, 0x0 , 0x0 ,
       0x0 , 0x29, 0x95, 0x5A, 0x55, 0x60, 0x0 , 0x10, 0x0 , 0xA6,
       0x55, 0x62, 0x55, 0x5A, 0xA8, 0x0 , 0x2 , 0x9A, 0xAA, 0x80,
       0x95, 0x55, 0x56, 0x0 , 0xA , 0x60, 0x0 , 0xA0, 0x25, 0x55,
       0x55, 0x80, 0x9 , 0x80, 0x0 , 0x88, 0x9 , 0x55, 0x55, 0x60,
       0x0 , 0x0 , 0x0 , 0x82, 0x2 , 0x55, 0x55, 0x58, 0x0 , 0x0 ,
       0x0 , 0x80, 0x80, 0x95, 0x55, 0x56, 0x0 , 0x0 , 0x2 , 0x0 ,
       0x20, 0x25, 0x55, 0x56, 0x1 , 0x0 , 0xAA, 0x80, 0x20, 0xA ,
       0xA9, 0x56, 0x14, 0x4 , 0x8 , 0xA , 0xAA, 0x0 , 0x2 , 0x56,
       0x54, 0x15, 0x8 , 0x0 , 0x80, 0x10, 0x0 , 0x98, 0x50, 0x4 ,
       0x0 , 0x2 , 0x0 , 0x0 , 0x40, 0x20
};

char    swmscsym[MISCANGS][MISCBYTES] = {

/*  bomb symbols based on the following template file:


08                08                08                08
. . . . . . . .   . . . . . . . .   . . . . . . . .   . . . . . . . .
. . . . . . . .   . . . . . . . .   . . . . . 1 1 .   . . . . 1 1 . .
. 1 1 . . . . .   . . . . . 1 1 .   . . . . 1 1 1 .   . . . . 1 1 . .
. 1 1 1 1 1 1 .   . . . 1 1 1 1 .   . . . 1 1 1 . .   . . . 1 1 . . .
. 1 1 1 1 1 1 .   1 1 1 1 1 . . .   . 1 1 1 1 . . .   . . . 1 1 . . .
. 1 1 . . . . .   . 1 1 1 . . . .   . . 1 1 . . . .   . 1 1 1 . . . .
. . . . . . . .   . . 1 1 . . . .   . . . 1 . . . .   . . 1 1 1 . . .
. . . . . . . .   . . . . . . . .   . . . . . . . .   . . . . . . . .
*/
       0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x0 , 0x15, 0x54, 0x15, 0x54,
       0x14, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x1 , 0x54, 0x55, 0x40,
       0x15, 0x0 , 0x5 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x14, 0x0 , 0x54, 0x1 , 0x50, 0x15, 0x40,
       0x5 , 0x0 , 0x1 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x50, 0x0 , 0x50, 0x1 , 0x40, 0x1 , 0x40,
       0x15, 0x0 , 0x5 , 0x40, 0x0 , 0x0 ,
       0x0 , 0x0 , 0x1 , 0x40, 0x1 , 0x40, 0x1 , 0x40, 0x1 , 0x40,
       0x5 , 0x50, 0x5 , 0x50, 0x0 , 0x0 ,
       0x0 , 0x0 , 0x5 , 0x0 , 0x5 , 0x0 , 0x1 , 0x40, 0x1 , 0x54,
       0x0 , 0x54, 0x0 , 0x50, 0x0 , 0x40,
       0x0 , 0x0 , 0x14, 0x0 , 0x15, 0x0 , 0x5 , 0x40, 0x1 , 0x54,
       0x0 , 0x50, 0x0 , 0x40, 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x0 , 0x15, 0x44, 0x1 , 0x54,
       0x0 , 0x14, 0x0 , 0x10, 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x15, 0x54, 0x15, 0x54,
       0x0 , 0x14, 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x50, 0x0 , 0x54, 0x1 , 0x55, 0x15, 0x40,
       0x14, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x40, 0x0 , 0x50, 0x1 , 0x54, 0x5 , 0x40,
       0x15, 0x0 , 0x14, 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x1 , 0x50, 0x0 , 0x54, 0x1 , 0x40, 0x1 , 0x40,
       0x5 , 0x0 , 0x5 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x5 , 0x50, 0x5 , 0x50, 0x1 , 0x40, 0x1 , 0x40,
       0x1 , 0x40, 0x1 , 0x40, 0x0 , 0x0 ,
       0x1 , 0x0 , 0x5 , 0x0 , 0x15, 0x0 , 0x15, 0x40, 0x1 , 0x40,
       0x0 , 0x50, 0x0 , 0x50, 0x0 , 0x0 ,
       0x0 , 0x0 , 0x1 , 0x0 , 0x5 , 0x0 , 0x15, 0x40, 0x1 , 0x50,
       0x0 , 0x54, 0x0 , 0x14, 0x0 , 0x0 ,
       0x0 , 0x0 , 0x4 , 0x0 , 0x14, 0x0 , 0x15, 0x40, 0x11, 0x54,
       0x0 , 0x14, 0x0 , 0x0 , 0x0 , 0x0
};

char    swbstsym[BRSTSYMS][BRSTBYTES] = {


/*  starburst symbols based on the following template file:

08                 08
. . . . 1 . . .    . . . 1 . . 1 .
. 1 . . 1 . 1 .    1 . . 1 . 1 . .
. . 1 . 1 1 . .    . 1 . 1 1 . . .
1 1 1 1 1 . . .    . . 1 1 1 1 1 1
. . . 1 1 1 1 1    1 1 1 1 1 1 . .
. . 1 1 . 1 . .    . . . 1 1 . 1 .
. 1 . 1 . . 1 .    . . 1 . 1 . . 1
. . . 1 . . . .    . 1 . . 1 . . .
*/
       0x0 , 0x40, 0x10, 0x44, 0x4 , 0x50, 0x55, 0x40, 0x1 , 0x55,
       0x5 , 0x10, 0x11, 0x4 , 0x1 , 0x0 ,
       0x1 , 0x4 , 0x41, 0x10, 0x11, 0x40, 0x5 , 0x55, 0x55, 0x50,
       0x1 , 0x44, 0x4 , 0x41, 0x10, 0x40
};
