pkgbase=java11-openjdk
pkgname=('jre11-openjdk-headless' 'jre11-openjdk' 'jdk11-openjdk' 'openjdk11-src' 'openjdk11-doc')
_majorver=11
_minorver=0
_securityver=12
_updatever=7
pkgrel=1
pkgver=${_majorver}.${_minorver}.${_securityver}.u${_updatever}
_git_tag=jdk-${_majorver}.${_minorver}.${_securityver}+${_updatever}
srcdir=$PWD
pkgdir=$PWD/../build

# Borrowed from arch linux and maintainer Levente Polyak <anthraxx[at]archlinux[dot]org>
# and maintainer Guillaume ALAUX <guillaume@archlinux.org>

_JARCH=x86_64
_DOC_ARCH=x86_64

_jvmdir=/usr/lib/jvm/java-${_majorver}-openjdk
_jdkdir=jdk${_majorver}u-${_git_tag//+/-}
_imgdir=${_jdkdir}/build/linux-${_JARCH}-normal-server-release/images

_nonheadless=(lib/libawt_xawt.{so,debuginfo}
  lib/libjawt.{so,debuginfo}
  lib/libjsound.{so,debuginfo}
  lib/libsplashscreen.{so,debuginfo})

cd ${_jdkdir}

NUM_PROC_OPT=''
MAKEFLAG_J=$(echo ${MAKEFLAGS} | sed -En 's/.*-j([0-9]+).*/\1/p')
if [ -n "${MAKEFLAG_J}" ]; then
# http://hg.openjdk.java.net/jdk10/jdk10/file/85e6cb013b98/make/InitSupport.gmk#l105
  echo "Removing '-j${MAKEFLAG_J}' from MAKEFLAGS to prevent build fail. Passing it directly to ./configure."
  export MAKEFLAGS=${MAKEFLAGS/-j${MAKEFLAG_J}/}
  NUM_PROC_OPT="--with-num-cores=${MAKEFLAG_J}"
fi

# Avoid optimization of HotSpot being lowered from O3 to O2
_CFLAGS="${CFLAGS//-O2/-O3} ${CPPFLAGS} -fcommon"
_CXXFLAGS="${CXXFLAGS//-O2/-O3} ${CPPFLAGS} -fcommon"
_LDFLAGS=${LDFLAGS}
if [[ ${CARCH} = i686 ]]; then
  echo "Removing '-fno-plt' from CFLAGS and CXXFLAGS to prevent build fail with this architecture"
  _CFLAGS=${CFLAGS/-fno-plt/}
  _CXXFLAGS=${CXXFLAGS/-fno-plt/}
fi

# CFLAGS, CXXFLAGS and LDFLAGS are ignored as shown by a warning
# in the output of ./configure unless used like such:
#  --with-extra-cflags="${CFLAGS}"
#  --with-extra-cxxflags="${CXXFLAGS}"
#  --with-extra-ldflags="${LDFLAGS}"
# See also paragraph "Configure Control Variables from "jdk${_majorver}-${_git_tag}/common/doc/building.md
unset CFLAGS
unset CXXFLAGS
unset LDFLAGS

bash configure \
  --with-version-build="${_updatever}" \
  --with-version-pre="" \
  --with-version-opt="" \
  --with-stdc++lib=dynamic \
  --with-extra-cflags="${_CFLAGS}" \
  --with-extra-cxxflags="${_CXXFLAGS}" \
  --with-extra-ldflags="${_LDFLAGS}" \
  --with-libjpeg=system \
  --with-giflib=system \
  --with-libpng=system \
  --with-lcms=system \
  --with-zlib=system \
  --with-boot-jdk=${srcdir}/jdk-10.0.2 \
  --with-harfbuzz=system \
  --with-jvm-features=zgc \
  --enable-unlimited-crypto \
  --disable-warnings-as-errors \
  ${NUM_PROC_OPT}
  #--disable-javac-server \

make images legacy-jre-image docs

# https://bugs.openjdk.java.net/browse/JDK-8173610
echo "Updating .so files to add +x flag in ${_imgdir}"
echo ""
echo "Performing..."
find "../${_imgdir}" -iname '*.so' -exec chmod +x {} \;
echo ""
echo "Done."
echo ""

echo "Installing jre..."
echo ""
cd ${srcdir}
#package_jre11-openjdk-headless() {
#pkgdesc="OpenJDK Java ${_majorver} headless runtime environment"
#depends=('java-runtime-common>=3' 'ca-certificates-utils' 'nss' 'libjpeg-turbo' 'libjpeg.so'
#  'lcms2' 'liblcms2.so' 'libnet' 'freetype2' 'libfreetype.so' 'harfbuzz' 'libharfbuzz.so'
#  'glibc' 'gcc-libs')
#  optdepends=('java-rhino: for some JavaScript support')
#  provides=("java-runtime-headless=${_majorver}" "java-runtime-headless-openjdk=${_majorver}" "jre${_majorver}-openjdk-headless=${pkgver}-${pkgrel}")
#  backup=(etc/${pkgbase}/logging.properties
#    etc/${pkgbase}/management/jmxremote.access
#    etc/${pkgbase}/management/jmxremote.password.template
#    etc/${pkgbase}/management/management.properties
#    etc/${pkgbase}/net.properties
#    etc/${pkgbase}/security/java.policy
#    etc/${pkgbase}/security/java.security
#    etc/${pkgbase}/security/policy/README.txt
#    etc/${pkgbase}/security/policy/limited/default_US_export.policy
#    etc/${pkgbase}/security/policy/limited/default_local.policy
#    etc/${pkgbase}/security/policy/limited/exempt_local.policy
#    etc/${pkgbase}/security/policy/unlimited/default_US_export.policy
#    etc/${pkgbase}/security/policy/unlimited/default_local.policy
#    etc/${pkgbase}/sound.properties)
#    install=install_jre-openjdk-headless.sh

cd ${_imgdir}/jre

install -dm 755 "${pkgdir}${_jvmdir}"

cp -a bin lib \
  "${pkgdir}${_jvmdir}"

for f in "${_nonheadless[@]}"; do
  rm "${pkgdir}${_jvmdir}/${f}"
done

cp ../jdk/release "${pkgdir}${_jvmdir}"
cp ../jdk/lib/modules "${pkgdir}${_jvmdir}/lib"

# Conf
install -dm 755 "${pkgdir}/etc"
cp -r conf "${pkgdir}/etc/${pkgbase}"
ln -s /etc/${pkgbase} "${pkgdir}/${_jvmdir}/conf"

# Legal
install -dm 755 "${pkgdir}/usr/share/licenses"
cp -r legal "${pkgdir}/usr/share/licenses/${pkgbase}"
ln -s ${pkgbase} "${pkgdir}/usr/share/licenses/${pkgname}"
ln -s /usr/share/licenses/${pkgbase} "${pkgdir}/${_jvmdir}/legal"

# Man pages
for f in man/man1/* man/ja/man1/*; do
  install -Dm 644 "${f}" "${pkgdir}/usr/share/${f/\.1/-openjdk${_majorver}.1}"
done
ln -s /usr/share/man "${pkgdir}/${_jvmdir}/man"

# Link JKS keystore from ca-certificates-utils
rm -f "${pkgdir}${_jvmdir}/lib/security/cacerts"
ln -sf /etc/ssl/certs/java/cacerts "${pkgdir}${_jvmdir}/lib/security/cacerts"

# OCCAM: create the links
ln -s ${_jvmdir} ${pkgdir}/usr/lib/jvm/default
ln -s ${_jvmdir} ${pkgdir}/usr/lib/jvm/default-runtime

#}

echo ""
echo "Done."
echo ""

echo "Installing jre (x11)..."
echo ""
cd ${srcdir}
pkgdir=$PWD/../build/jre11-openjdk-x11
#package_jre11-openjdk() {
#pkgdesc="OpenJDK Java ${_majorver} full runtime environment"
#depends=("jre${_majorver}-openjdk-headless=${pkgver}-${pkgrel}" 'giflib' 'libgif.so'
#  'glibc' 'gcc-libs' 'libpng')
#  optdepends=('alsa-lib: for basic sound support'
#    'gtk2: for the Gtk+ 2 look and feel - desktop usage'
#    'gtk3: for the Gtk+ 3 look and feel - desktop usage')
#    provides=("java-runtime=${_majorver}" "java-runtime-openjdk=${_majorver}" "jre${_majorver}-openjdk=${pkgver}-${pkgrel}")
#    install=install_jre-openjdk.sh

cd ${_imgdir}/jre

install -dm 755 "${pkgdir}${_jvmdir}"

for f in "${_nonheadless[@]}"; do
  install -Dm 644 ${f} "${pkgdir}${_jvmdir}/${f}"
done

# Licenses
install -dm 755 "${pkgdir}/usr/share/licenses"
ln -s ${pkgbase} "${pkgdir}/usr/share/licenses/${pkgname}"
#}

echo ""
echo "Done."
echo ""

echo "Installing jdk..."
echo ""

cd ${srcdir}
pkgdir=$PWD/../build/jdk11-openjdk
#package_jdk11-openjdk() {
#pkgdesc="OpenJDK Java ${_majorver} development kit"
#depends=("jre${_majorver}-openjdk=${pkgver}-${pkgrel}" 'java-environment-common=3'
#  'hicolor-icon-theme' 'libelf' 'glibc' 'gcc-libs')
#  provides=("java-environment=${_majorver}" "java-environment-openjdk=${_majorver}" "jdk${_majorver}-openjdk=${pkgver}-${pkgrel}")
#  install=install_jdk-openjdk.sh

cd ${_imgdir}/jdk

install -dm 755 "${pkgdir}${_jvmdir}"

cp -a bin demo include jmods lib \
  "${pkgdir}${_jvmdir}"

rm "${pkgdir}${_jvmdir}/lib/src.zip"

# Remove files held by JRE
echo "Removing JRE files..."
pushd ../jre
for d in bin lib; do
  find ${d} ! -type d -exec rm "${pkgdir}${_jvmdir}/{}" \;
done
popd
find "${pkgdir}${_jvmdir}/lib" -type d -empty -delete

# Conf files all belong to JRE

# Legal
echo "Installing jdk licenses..."
install -dm 755 "${pkgdir}/usr/share/licenses"
cp -r legal "${pkgdir}/usr/share/licenses/${pkgbase}"
pushd ../jre/legal
#find . ! -type d -exec rm "${pkgdir}/usr/share/licenses/${pkgbase}/{}" \;
popd
find "${pkgdir}/usr/share/licenses" -type d -empty -delete
ln -s ${pkgbase} "${pkgdir}/usr/share/licenses/${pkgname}"

# Man pages
echo "Installing jdk man pages..."
for f in man/man1/* man/ja/man1/*; do
  if [ ! -e "../jre/${f}" ]; then
    install -Dm 644 "${f}" "${pkgdir}/usr/share/${f/\.1/-openjdk${_majorver}.1}"
  fi
done

# Icons
echo "Installing icons..."
for s in 16 24 32 48; do
  install -Dm 644 \
    "${srcdir}/${_jdkdir}/src/java.desktop/unix/classes/sun/awt/X11/java-icon${s}.png" \
    "${pkgdir}/usr/share/icons/hicolor/${s}x${s}/apps/${pkgbase}.png"
done

# Desktop files
echo "Installing desktop files..."
for f in jconsole java jshell; do
  install -Dm 644 \
    "${srcdir}/freedesktop-${f}.desktop" \
    "${pkgdir}/usr/share/applications/${f}-${pkgbase}.desktop"
done
#}

# OCCAM: create the links
ln -s ${_jvmdir} ${pkgdir}/usr/lib/jvm/default
ln -s ${_jvmdir} ${pkgdir}/usr/lib/jvm/default-runtime

echo ""
echo "Done."
echo ""

echo "Installing jdk src..."
echo ""

cd $srcdir
pkgdir=$PWD/../build/openjdk11-src
#package_openjdk11-src() {
#pkgdesc="OpenJDK Java ${_majorver} sources"
## Depends on JDK to get license files
#depends=("jdk${_majorver}-openjdk=${pkgver}-${pkgrel}")
#provides=("openjdk${_majorver}-src=${pkgver}-${pkgrel}")

install -Dm 644 -t "${pkgdir}${_jvmdir}/lib" ${_imgdir}/jdk/lib/src.zip

install -dm 755 "${pkgdir}/usr/share/licenses"
ln -s ${pkgbase} "${pkgdir}/usr/share/licenses/${pkgname}"
#}

echo ""
echo "Done."
echo ""

echo "Installing jdk doc..."
echo ""

cd $srcdir
pkgdir=$PWD/../build/openjdk11-doc
#package_openjdk11-doc() {
#pkgdesc="OpenJDK Java ${_majorver} documentation"
## Depends on JDK to get license files
#depends=("jdk${_majorver}-openjdk=${pkgver}-${pkgrel}")
#provides=("openjdk${_majorver}-doc=${pkgver}-${pkgrel}")

install -dm 755 "${pkgdir}/usr/share/doc"
cp -r ${_imgdir}/docs "${pkgdir}/usr/share/doc/${pkgbase}"

install -dm 755 "${pkgdir}/usr/share/licenses"
ln -s ${pkgbase} "${pkgdir}/usr/share/licenses/${pkgname}"
#}
