DECLARE SUB SetEax (EaxCode AS INTEGER)
DECLARE SUB SetVolume (MODVol%, SAMVol%, MP3Vol%)
DECLARE SUB CFade (MusicChannel AS INTEGER, FadeStart AS INTEGER, FadeEnd AS INTEGER, FadeSpeed AS INTEGER)
DECLARE SUB LoadMusic (MusicName AS STRING, MusicType AS INTEGER, MusicChannel AS INTEGER, Repeat AS INTEGER, Enable3D AS INTEGER)
DECLARE SUB ShutDownDS4QB ()
DECLARE SUB PlaySample (SFXT%)
DECLARE SUB LoadSample ()
DECLARE SUB InitDS4QB ()
DECLARE SUB WaitforDMA0 ()
DEFINT A-Z
CONST TRUE = 1
CONST FALSE = 0

SUB CFade (MusicChannel AS INTEGER, FadeStart AS INTEGER, FadeEnd AS INTEGER, FadeSpeed AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, FadeStart
PRINT #1, FadeEnd
PRINT #1, FadeSpeed
CLOSE #1
OUT &H0, 10
OUT &H0, 10
WaitforDMA0
END SUB

SUB CPan (MusicChannel AS INTEGER, PanStart AS INTEGER, PanEnd AS INTEGER, PanSpeed AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, PanStart
PRINT #1, PanEnd
PRINT #1, PanSpeed
CLOSE #1
OUT &H0, 9
OUT &H0, 9
WaitforDMA0
END SUB

SUB InitDS4QB
'OUT &H0, 0: OUT &H0, 0
'SHELL "start.exe /m ds4qb2.exe"
END SUB

SUB LoadMusic (MusicName AS STRING, MusicType AS INTEGER, MusicChannel AS INTEGER, Repeat AS INTEGER, Enable3D AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicName
PRINT #1, MusicType
PRINT #1, MusicChannel
PRINT #1, Repeat
PRINT #1, Enable3D
CLOSE #1
OUT &H0, 1
OUT &H0, 1
WaitforDMA0
END SUB

SUB LoadSample
WaitforDMA0
OUT &H0, 3
OUT &H0, 3
WaitforDMA0
END SUB

SUB PauseMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 14
OUT &H0, 14
WaitforDMA0
END SUB

SUB PlaySample (SFXT)
OUT &H0, SFXT + 55
OUT &H0, SFXT + 55
END SUB

SUB RemoveMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 2
OUT &H0, 2
WaitforDMA0
END SUB

SUB ResumeMusic (MusicChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
CLOSE #1
OUT &H0, 15
OUT &H0, 15
WaitforDMA0
END SUB

SUB Set3D (MusicChannel AS INTEGER, PX AS SINGLE, PY AS SINGLE, PZ AS SINGLE, VX AS SINGLE, VY AS SINGLE, VZ AS SINGLE)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, PX
PRINT #1, PY
PRINT #1, PZ
PRINT #1, VX
PRINT #1, VY
PRINT #1, VZ
CLOSE #1
OUT &H0, 7
OUT &H0, 7
WaitforDMA0
END SUB

SUB SetChannel (MusicChannel AS INTEGER, Frequency AS LONG, Volume AS INTEGER, Panning AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MusicChannel
PRINT #1, Frequency
PRINT #1, Volume
PRINT #1, Panning
CLOSE #1
OUT &H0, 8
OUT &H0, 8
WaitforDMA0
END SUB

SUB SetEax (EaxCode AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, EaxCode
CLOSE #1
OUT &H0, 5
OUT &H0, 5
WaitforDMA0
END SUB

SUB SetPos (MusicChannel AS INTEGER, MP3Position AS LONG, MODOrder AS INTEGER, MODRow AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR BINARY AS #1
PUT #1, 1, MusicChannel
PUT #1, 5, MP3Position
PUT #1, 9, MODOrder
PUT #1, 11, MODRow
CLOSE #1
OUT &H0, 13
OUT &H0, 13
WaitforDMA0
END SUB

SUB SetVolume (MODVol, SAMVol, MP3Vol)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, MODVol
PRINT #1, SAMVol
PRINT #1, MP3Vol
CLOSE #1
OUT &H0, 4
OUT &H0, 4
WaitforDMA0
END SUB

SUB ShutDownDS4QB
OUT &H0, 55
END SUB

SUB SoundInterFace (Command, Value1, Value2, Value3, Value4) STATIC
        IF (SoundOn = FALSE) AND (Command <> 0) THEN EXIT SUB
        SELECT CASE Command
        CASE 0
                IF Value1 = FALSE THEN
                        SoundOn = FALSE
                        EXIT SUB
                END IF
                SoundOn = TRUE
        CASE 1
                ShutDownDS4QB
        CASE 2
                PlaySample Value1
        CASE 3
                SELECT CASE Value1
                CASE 1
                        File$ = "tune001.mp3"
                CASE 2
                        File$ = "tune002.mp3"
                CASE 3
                        File$ = "tune003.mp3"
                CASE 4
                        File$ = "tune004.mp3"
                CASE 5
                        File$ = "tune005.mp3"
                CASE 6
                        File$ = "tune006.mp3"
                CASE 7
                        File$ = "tune007.mp3"
                CASE 8
                        File$ = "tune008.mp3"
                CASE 9
                        File$ = "tune009.mp3"
                CASE 10
                        File$ = "tune000.mp3"
                END SELECT
                LoadMusic File$, 2, Value2, 1, 0
        CASE 4
                SetVolume 0, Value1, Value2
        CASE 5
                CFade Value1, 100, 0, -Value2
        CASE 6
                SetEax Value1
        END SELECT
        
END SUB

SUB StopSFX (SFXChannel AS INTEGER)
WaitforDMA0
OPEN "DS4QB2.DAT" FOR OUTPUT AS #1
PRINT #1, SFXChannel
CLOSE #1
OUT &H0, 6
OUT &H0, 6
WaitforDMA0
END SUB

SUB WaitforDMA0
DO: LOOP UNTIL INP(&H0) = 0
END SUB

