#include <stdio.h>
#include <conio.h>
#include <dos.h>

void far draw_view(long far eye_x, long far eye_y, int far heading,
						 int far *sin_tab, int far *cos_tab,
						 int far skyprojection_seg,
						 int far mountainheight_seg, int far terrainlevel_seg,
						 int far offscreen_high, int far offscreen_low,
						 int far bumpmap, int far texturemap,
						 int far sky_texture_toggle, int far star_flags);
void far draw_stars(int far star_layer, int far offscreen_low,
						  int far offscreen_high);
//------------------------------------------------------------------------------
void far sort_polygons(int far source_segment, int far total_polygons);
void far sort_objects(int far source_segment, int far total_objects);
void far radar(int far offscreen, int far blender_map);
void far blend_green(int far offscreen_high, int far offscreen_low,
							int far blender_map);
//------------------------------------------------------------------------------
void far octree_blur(int far offscreen_high, int far offscreen_low);
void far boss_energy(int far offscreen, int far blender_map, int far length);
void far high_sky(int far offscreen_high);

void far draw_view(long far eye_x_l, long far eye_y_l, int far heading,
						 int far *sin_tab, int far *cos_tab,
						 int far skyprojection_seg,
						 int far mountainheight_segment, int far terrainlevel_segment,
						 int far offscreen_high, int far offscreen_low,
						 int far bumpmap, int far texturemap,
						 int far sky_texture_toggle, int far star_flags)
{
	// init locals
	int index_x, index_y, interpolate;
	int angle;
	int sine, cosine;
	char diminish, pxlcolor;
	char colortable[320];
	unsigned yvalues[320];
	unsigned previous_yvalues[320];
	unsigned ysum, colorsum;
	unsigned bump_cell;
	unsigned xx, yy, eye_x, eye_y;
	int multiplier, yheight, ystart;
	eye_x = (unsigned)eye_x_l;
	eye_y = (unsigned)eye_y_l;
	// count start angle
		angle = heading - 160;
		if (angle < 0) angle += 1280;
	// render
	for (index_x = 1; index_x < 319; index_x++)
	{
	// START_SKY
	sine = sin_tab[angle]; cosine = cos_tab[angle];
	if ((sky_texture_toggle != 0) && (star_flags == 0)) {
		xx = eye_x - (sine * 145);
		yy = eye_y - (cosine * 145);
		diminish = 32;
	if (sky_texture_toggle == 1) {
	// draw sky
		asm {
			mov fs, word ptr texturemap
			mov gs, word ptr skyprojection_seg
			mov es, word ptr offscreen_high
			}
		for (index_y = 0; index_y < 104; index_y++)
		{
		// move ray towards eye point
		xx += sine;
		yy += cosine;

		asm {
			mov cx, word ptr xx
			mov dx, word ptr yy
			shr cx, 8
			shr dx, 8
			shl dx, 8
			mov bx, dx
			add bx, cx
			mov al, fs:[bx]
			shr al, 3
			add al, 224
			mov ah, byte ptr diminish
			cmp ah, 0
			je short @ifbreak2:
			sub al, ah
			cmp al, 224
			jae short @ifbreak1:
			mov al, 224
			@ifbreak1:
			dec ah
			mov byte ptr diminish, ah
			@ifbreak2:
			mov byte ptr pxlcolor, al
			mov bx, word ptr index_y
			shl bx, 1
			mov ax, gs:[bx]
			mov bx, 326
			sub bx, ax
			shl bx, 6
			mov cx, bx
			shl bx, 2
			add bx, cx
			add bx, word ptr index_x
			mov al, byte ptr pxlcolor
			mov es:[bx], al
			mov es:[bx+320], al
			mov es:[bx+640], al
			mov es:[bx+960], al
			}
		} // END FOR -> SKY LOOP
		} else {
		asm {
			mov fs, word ptr texturemap
			mov gs, word ptr skyprojection_seg
			mov es, word ptr offscreen_low
			}
		for (index_y = 0; index_y < 104; index_y++)
		{
		xx += sine;
		yy += cosine;

		asm {
			mov cx, word ptr xx
			mov dx, word ptr yy
			shr cx, 8
			shr dx, 8
			shl dx, 8
			mov bx, dx
			add bx, cx
			mov al, fs:[bx]
			shr al, 3
			add al, 226
			mov ah, byte ptr diminish
			cmp ah, 0
			je short @ifbreak3:
			sub al, ah
			cmp al, 224
			jae short @ifbreak4:
			mov al, 224
			@ifbreak3:
			dec ah
			mov byte ptr diminish, ah
			@ifbreak4:
			mov byte ptr pxlcolor, al
			mov bx, word ptr index_y
			shl bx, 1
			mov ax, gs:[bx]
			sub ax, 152
			mov bx, ax
			shl bx, 6
			mov cx, bx
			shl bx, 2
			add bx, cx
			add bx, word ptr index_x
			mov al, byte ptr pxlcolor
			mov es:[bx], al
			mov es:[bx+320], al
			mov es:[bx+640], al
			mov es:[bx+960], al
			}
		} // END FOR -> SKY LOOP
		} // end if sky conditionals
		} // end if sky_toggle
	angle++;
	if (angle == 1280) angle = 0;
}

for (index_x = 1; index_x < 319; index_x++)
{ previous_yvalues[index_x] = 30000; }

multiplier = 0;

for (index_y = 0; index_y < 128; index_y++)
{
angle = heading - 160;
if (angle < 0) angle += 1280;
multiplier++;
for (index_x = 0; index_x < 319; index_x++)
{
		sine = sin_tab[angle]; cosine = cos_tab[angle];
		xx = eye_x - (sine * multiplier);
		yy = eye_y - (cosine * multiplier);
		asm {
			mov fs, word ptr bumpmap
			mov gs, word ptr texturemap
			mov cx, word ptr xx
			mov dx, word ptr yy
			shr cx, 8
			shr dx, 8
			mov bx, dx
			shl bx, 8
			add bx, cx
			xor ah, ah
			mov al, fs:[bx]
			shr al, 1
			mov dx, ax
			mov word ptr bump_cell, dx
			mov cx, word ptr xx
			mov dx, word ptr yy
			cmp cx, 32768
			jl short @offjump6:
			sub cx, 32768
			@offjump6:
			cmp dx, 32768
			jl short @offjump7:
			sub dx, 32768
			@offjump7:
			shr cx, 7
			shr dx, 7
			mov bx, dx
			shl bx, 8
			add bx, cx
			mov al, gs:[bx]
			shr al, 2
			mov bx, word ptr bump_cell
			shr bx, 2
			add al, 160
			sub al, bl
			cmp al, 164
			jg @validTextureColor3:
			mov al, 164
			@validTextureColor3:
			mov byte ptr pxlcolor, al
}
			yvalues[index_x] = bump_cell;
			colortable[index_x] = pxlcolor;
angle++;
if (angle == 1280) angle = 0;
} // end for index_x

	for (interpolate = 2; interpolate < 318; interpolate++)
	{
		ysum = yvalues[interpolate - 1] + yvalues[interpolate + 1];
		yvalues[interpolate] = ysum >> 1;
		colorsum = colortable[interpolate - 1] + colortable[interpolate + 1];
		colortable[interpolate] = colorsum >> 1;
	}

	for (index_x = 1; index_x < 319; index_x++)
	{

	bump_cell = yvalues[index_x]; pxlcolor = colortable[index_x];

			asm {
			mov es, word ptr terrainlevel_segment
			mov bx, 158
			sub bx, word ptr index_y
			shl bx, 1
			mov cx, es:[bx]
			mov es, word ptr mountainheight_segment
			mov bx, 158
			sub bx, word ptr index_y
			shl bx, 7
			mov dx, word ptr bump_cell
			add bx, dx
			xor ah, ah
			mov al, es:[bx]
			add cx, ax
			mov word ptr ystart, cx
	}
if (ystart < previous_yvalues[index_x]) {

			if (previous_yvalues[index_x] < 139) {
				yheight = previous_yvalues[index_x] - ystart + 1;
			} else { yheight = 140 - ystart; }

	previous_yvalues[index_x] = ystart;

	if (ystart < 139) {
	asm {
			mov bx, word ptr ystart
			mov es, word ptr offscreen_low
			shl bx, 6
			mov cx, bx
			shl bx, 2
			add bx, cx
			add bx, word ptr index_x
			mov al, byte ptr pxlcolor
			mov cx, yheight
			@lineLoop:
			mov es:[bx], al
			add bx, 320
			dec cx
			jnz @lineLoop:
		}
	} // end if

} // end if

} // stop rendering plane
} //end for y

multiplier = 136;
for (index_y = 0; index_y < 33; index_y++)
{
angle = heading - 160;
if (angle < 0) angle += 1280;

for (index_x = 1; index_x < 319; index_x++)
{
		sine = sin_tab[angle]; cosine = cos_tab[angle];
		xx = eye_x - (sine * multiplier);
		yy = eye_y - (cosine * multiplier);
		asm {
			mov fs, word ptr bumpmap
			mov gs, word ptr texturemap
			mov cx, word ptr xx
			mov dx, word ptr yy
			shr cx, 8
			shr dx, 8
			mov bx, dx
			shl bx, 8
			add bx, cx
			xor ah, ah
			mov al, fs:[bx]
			shr al, 1
			mov dx, ax
			mov word ptr bump_cell, dx
			mov dx, 32
			sub dx, word ptr index_y
			mov al, dl
			shr al, 3
			add al, 160
			inc al
			mov byte ptr pxlcolor, al
		}
			yvalues[index_x] = bump_cell;
			colortable[index_x] = pxlcolor;
	angle++;
	if (angle == 1280) angle = 0;
} // end for index_x

multiplier += 4;

	for (interpolate = 2; interpolate < 318; interpolate++)
	{
		ysum = yvalues[interpolate - 1] + yvalues[interpolate + 1];
		yvalues[interpolate] = ysum >> 1;
	}

for (index_x = 1; index_x < 319; index_x++)
	{
	bump_cell = yvalues[index_x]; pxlcolor = colortable[index_x];

			asm {
			mov es, word ptr terrainlevel_segment
			mov bx, 32
			sub bx, word ptr index_y
			shl bx, 1
			mov cx, es:[bx]
			mov es, word ptr mountainheight_segment
			mov bx, 32
			sub bx, word ptr index_y
			shl bx, 7
			mov dx, word ptr bump_cell
			add bx, dx
			xor ah, ah
			mov al, es:[bx]
			add cx, ax
			mov word ptr ystart, cx
	}
if (ystart < previous_yvalues[index_x]) {

			if (previous_yvalues[index_x] < 139) {
				yheight = previous_yvalues[index_x] - ystart + 1;
			} else { yheight = 140 - ystart; }

	previous_yvalues[index_x] = ystart;

	if (ystart < 139) {
	asm {
			mov bx, word ptr ystart
			mov es, word ptr offscreen_low
			shl bx, 6
			mov cx, bx
			shl bx, 2
			add bx, cx
			add bx, word ptr index_x
			mov al, byte ptr pxlcolor
			mov cx, yheight
			@FogLineLoop:
			mov es:[bx], al
			add bx, 320
			dec cx
			jnz @FogLineLoop:
		}
	} // end if

} // end if
} // stop rendering plane

} // end for index_y



}

void far draw_stars(int far star_layer, int far offscreen_low, int far offscreen_high)
{
			int index;
			asm {
			mov gs, word ptr star_layer
			mov dx, 499
			@starLayerLoop:
			mov word ptr index, dx
			mov bx, dx
			shl bx, 3
			mov ax, gs:[bx + 2]
			cmp ax, 200
			jl short @isUpper:
			sub ax, 200
			mov es, word ptr offscreen_low
			jmp short @elseSkip:
			@isUpper:
			mov es, word ptr offscreen_high
			@elseSkip:
			shl ax, 6
			mov cx, ax
			shl ax, 2
			add ax, cx
			mov dx, gs:[bx+4]
			add ax, gs:[bx]
			mov bx, ax
			mov cl, es:[bx]
			cmp cl, 160
			jne @doNotDraw:
			mov es:[bx], dl
			@doNotDraw:
			mov dx, word ptr index
			dec dx
			jnz short @starLayerLoop:
			}
}


void far sort_polygons(int far source_segment, int far total_polygons)
{
	int index_2, index;
	int array_offset1, array_offset2, z1, z2;
	long swapbuf11, swapbuf12, swapbuf13, swapbuf14;
	long swapbuf21, swapbuf22, swapbuf23, swapbuf24;

	for (index = 0; index < total_polygons; index++)
	{
		for (index_2 = 0; index_2 < index; index_2++)
		{
				array_offset1 = (index << 5);
				array_offset2 = (index_2 << 5);
				z1 = peek(source_segment, array_offset1 + 14);
				z2 = peek(source_segment, array_offset2 + 14); // lame, but still
																			  // fast with inline
																			  // intrinsic funcs
				if (z2 < z1)
					{

					asm {
						mov es, word ptr source_segment
						mov cx, word ptr array_offset1
						mov dx, word ptr array_offset2
						mov bx, cx
						mov eax, es:[bx]
						mov dword ptr swapbuf11, eax
						mov eax, es:[bx+4]
						mov dword ptr swapbuf12, eax
						mov eax, es:[bx+8]
						mov dword ptr swapbuf13, eax
						mov eax, es:[bx+12]
						mov dword ptr swapbuf14, eax
						mov bx, dx
						mov eax, es:[bx]
						mov dword ptr swapbuf21, eax
						mov eax, es:[bx+4]
						mov dword ptr swapbuf22, eax
						mov eax, es:[bx+8]
						mov dword ptr swapbuf23, eax
						mov eax, es:[bx+12]
						mov dword ptr swapbuf24, eax

						mov eax, dword ptr swapbuf11
						mov es:[bx], eax
						mov eax, dword ptr swapbuf12
						mov es:[bx+4], eax
						mov eax, dword ptr swapbuf13
						mov es:[bx+8], eax
						mov eax, dword ptr swapbuf14
						mov es:[bx+12], eax
						mov bx, cx
						mov eax, dword ptr swapbuf21
						mov es:[bx], eax
						mov eax, dword ptr swapbuf22
						mov es:[bx+4], eax
						mov eax, dword ptr swapbuf23
						mov es:[bx+8], eax
						mov eax, dword ptr swapbuf24
						mov es:[bx+12], eax
					}  // many movs, isn't it?
			}

		}
	}

}

void far sort_objects(int far source_segment, int far total_objects)
{
	int index_2, index;
	int array_offset1, array_offset2, z1, z2;
	long swapbuf11, swapbuf12, swapbuf13, swapbuf14, swapbuf15, swapbuf16,
		  swapbuf17;
	long swapbuf21, swapbuf22, swapbuf23, swapbuf24, swapbuf25, swapbuf26,
		  swapbuf27;

	for (index = 0; index < total_objects; index++)
	{
		for (index_2 = 0; index_2 < index; index_2++)
		{
				array_offset1 = (index << 5);
				array_offset2 = (index_2 << 5);
				z1 = peek(source_segment, array_offset1);
				z2 = peek(source_segment, array_offset2);
				if (z2 < z1)
					{
					asm {
						mov es, word ptr source_segment
						mov cx, word ptr array_offset1
						mov dx, word ptr array_offset2
						mov bx, cx
						mov eax, es:[bx]
						mov dword ptr swapbuf11, eax
						mov eax, es:[bx+4]
						mov dword ptr swapbuf12, eax
						mov eax, es:[bx+8]
						mov dword ptr swapbuf13, eax
						mov eax, es:[bx+12]
						mov dword ptr swapbuf14, eax
						mov eax, es:[bx+16]
						mov dword ptr swapbuf15, eax
						mov eax, es:[bx+20]
						mov dword ptr swapbuf16, eax
						mov eax, es:[bx+24]
						mov dword ptr swapbuf17, eax
						mov bx, dx
						mov eax, es:[bx]
						mov dword ptr swapbuf21, eax
						mov eax, es:[bx+4]
						mov dword ptr swapbuf22, eax
						mov eax, es:[bx+8]
						mov dword ptr swapbuf23, eax
						mov eax, es:[bx+12]
						mov dword ptr swapbuf24, eax
						mov eax, es:[bx+16]
						mov dword ptr swapbuf25, eax
						mov eax, es:[bx+20]
						mov dword ptr swapbuf26, eax
						mov eax, es:[bx+24]
						mov dword ptr swapbuf27, eax

						mov eax, dword ptr swapbuf11
						mov es:[bx], eax
						mov eax, dword ptr swapbuf12
						mov es:[bx+4], eax
						mov eax, dword ptr swapbuf13
						mov es:[bx+8], eax
						mov eax, dword ptr swapbuf14
						mov es:[bx+12], eax
						mov eax, dword ptr swapbuf15
						mov es:[bx+16], eax
						mov eax, dword ptr swapbuf16
						mov es:[bx+20], eax
						mov eax, dword ptr swapbuf17
						mov es:[bx+24], eax
						mov bx, cx
						mov eax, dword ptr swapbuf21
						mov es:[bx], eax
						mov eax, dword ptr swapbuf22
						mov es:[bx+4], eax
						mov eax, dword ptr swapbuf23
						mov es:[bx+8], eax
						mov eax, dword ptr swapbuf24
						mov es:[bx+12], eax
						mov eax, dword ptr swapbuf25
						mov es:[bx+16], eax
						mov eax, dword ptr swapbuf26
						mov es:[bx+20], eax
						mov eax, dword ptr swapbuf27
						mov es:[bx+24], eax
					} // speed costs MOVs...
 			}
		}
	}
}

void far radar(int far offscreen, int far blender_map)
	{
		int loop_y;
		char tempsto;

		asm {
		mov fs, word ptr blender_map
		mov es, word ptr offscreen
		mov word ptr loop_y, 17
		@rectLoop2:
		mov ax, 63
		@rectLoop1:
		mov bx, word ptr loop_y
		shl bx, 6
		mov cx, bx
		shl bx, 2
		add bx, cx
		add bx, ax
		add bx, 254
		mov cl, es:[bx]
		mov dx, bx
		movzx bx, cl
		mov cl, fs:[bx]
		mov bx, dx
		mov es:[bx], cl
		dec ax
		jnz @rectLoop1:
		inc word ptr loop_y
		mov ax, word ptr loop_y
		cmp ax, 144
		jl @rectLoop2:
		mov eax, 0x20202020
		mov cl, 16
		mov ch, 0
		@horizLineLoop:
		mov bx, 16
		shl bx, 6
		mov dx, bx
		shl bx, 2
		add bx, dx
		movzx dx, ch
		add bx, dx
		add bx, 254
		mov es:[bx], eax
		mov es:[bx+5120], eax
		mov es:[bx+10240], eax
		mov es:[bx+15360], eax
		mov es:[bx+20480], eax
		mov es:[bx+25600], eax
		mov es:[bx+30720], eax
		mov es:[bx+35840], eax
		mov es:[bx+40960], eax
		add ch, 4
		dec cl
		jnz @horizLineLoop:
		mov al, 0x21
		mov cl, 5
		mov ch, 0
		@vertiLineLoop:
		mov bx, 16
		shl bx, 6
		mov dx, bx
		shl bx, 2
		add bx, dx
		movzx dx, ch
		add bx, dx
		add bx, 254
		mov byte ptr tempsto, cl
		mov cl, 16
		@innerLineLoop:
		mov es:[bx], al
		mov es:[bx+320], al
		mov es:[bx+640], al
		mov es:[bx+960], al
		mov es:[bx+1280], al
		mov es:[bx+1600], al
		mov es:[bx+1920], al
		mov es:[bx+2240], al
		add bx, 2560
		dec cl
		jnz @innerLineLoop:
		add ch, 16
		mov cl, byte ptr tempsto
		dec cl
		jnz @vertiLineLoop:
		}
	}

void far blend_green(int far offscreen_high, int far offscreen_low,
							int far blender_map)
{
	// alphablending in 8-bit color node... tricky!
	asm {
	mov gs, word ptr blender_map
	mov fs, word ptr offscreen_low
	mov es, word ptr offscreen_high
	mov ax, 64000
	@uppergreenloop:
	mov bx, ax
	mov cl, fs:[bx - 1]
	movzx bx, cl
	mov cl, gs:[bx]
	mov bx, ax
	mov fs:[bx - 1], cl
	dec ax
	jnz @uppergreenloop:
	mov ax, 44800
	@lowergreenloop:
	mov bx, ax
	mov cl, es:[bx - 1]
	movzx bx, cl
	mov cl, gs:[bx]
	mov bx, ax
	mov es:[bx - 1], cl
	dec ax
	jnz @lowergreenloop

	}
}

void far octree_blur(int far offscreen_high, int far offscreen_low)
{
	// toisin sanoen alkeellinen mediaanifiltteri. pits opettaa jo ala-astella
	// (tai taideakatemiassa, hehehehehehe..........)
	int y_pos;
	asm {
		mov ax, 198
		mov es, word ptr offscreen_high
		mov fs, word ptr offscreen_low
		@UpperBlurLoopY:
		mov word ptr y_pos, ax
		mov bx, ax
		mov dx, ax
		shl bx, 8
		shl dx, 6
		add bx, dx
		add bx, 318
		mov cx, 317
		@UpperBlurLoopX:
		xor ax, ax
		mov al, es:[bx - 1]
		movzx dx, al
		mov al, es:[bx + 1]
		add dx, ax
		mov al, es:[bx - 320]
		add dx, ax
		mov al, es:[bx + 320]
		add dx, ax
		shr dx, 2
		mov es:[bx], dl
		dec bx
		dec cx
		cmp cx, 0
		je short @isZero1:
		jmp @UpperBlurLoopX:
		@isZero1:
		mov ax, word ptr y_pos
		dec ax
		cmp ax, 0
		je short @isZero2:
		jmp @UpperBlurLoopY:
		@isZero2:
		mov ax, 140
		@LowerBlurLoopY:
		mov word ptr y_pos, ax
		mov bx, ax
		mov dx, ax
		shl bx, 8
		shl dx, 6
		add bx, dx
		add bx, 318
		mov cx, 317
		@LowerBlurLoopX:
		xor ax, ax
		mov al, fs:[bx - 1]
		movzx dx, al
		mov al, fs:[bx + 1]
		add dx, ax
		mov al, fs:[bx - 320]
		add dx, ax
		mov al, fs:[bx + 320]
		add dx, ax
		shr dx, 2
		cmp dx, 164
		jl @skipPixel:
		mov fs:[bx], dl
		@skipPixel:
		dec bx
		dec cx
		cmp cx, 0
		je short @isZero3:
		jmp @LowerBlurLoopX:
		@isZero3:
		mov ax, word ptr y_pos
		dec ax
		cmp ax, 0
		je short @isZero4:
		jmp @LowerBlurLoopY:
		@isZero4:
	}
}

void far boss_energy(int far offscreen, int far blender_map, int far length)
{
	asm {
	mov es, word ptr offscreen
	mov fs, word ptr blender_map
	mov bx, 38436
	mov dx, word ptr length
	@energyBarLoop:
	mov al, es:[bx]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 16
	mov bx, cx
	mov es:[bx], al
	mov al, es:[bx + 320]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 17
	mov bx, cx
	mov es:[bx + 320], al
	mov al, es:[bx + 640]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 18
	mov bx, cx
	mov es:[bx + 640], al
	mov al, es:[bx + 960]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 19
	mov bx, cx
	mov es:[bx + 960], al
	mov al, es:[bx + 1280]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 20
	mov bx, cx
	mov es:[bx + 1280], al
	mov al, es:[bx + 1600]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 21
	mov bx, cx
	mov es:[bx + 1600], al
	mov al, es:[bx + 1920]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 22
	mov bx, cx
	mov es:[bx + 1920], al
	mov al, es:[bx + 2240]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 23
	mov bx, cx
	mov es:[bx + 2240], al
	mov al, es:[bx + 2560]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 23
	mov bx, cx
	mov es:[bx + 2560], al
	mov al, es:[bx + 2880]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 22
	mov bx, cx
	mov es:[bx +  2880], al
	mov al, es:[bx + 3200]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 21
	mov bx, cx
	mov es:[bx + 3200], al
	mov al, es:[bx + 3520]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 20
	mov bx, cx
	mov es:[bx + 3520], al
	mov al, es:[bx + 3840]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 19
	mov bx, cx
	mov es:[bx + 3840], al
	mov al, es:[bx + 4160]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 18
	mov bx, cx
	mov es:[bx + 4160], al
	mov al, es:[bx + 4480]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 17
	mov bx, cx
	mov es:[bx + 4480], al
	mov al, es:[bx + 4800]
	mov cx, bx
	movzx bx, al
	mov al, fs:[bx]
	add al, 16
	mov bx, cx
	mov es:[bx + 4800], al
	inc bx
	dec dx
	jz @exitBarDraw:
	jmp @energyBarLoop:
	@exitBarDraw:
	}
}

void far high_sky(int far offscreen_high)
{
asm {
	mov es, word ptr offscreen_high
	xor bx, bx
	mov cx, 32
	mov al, 0xff
	@scanLineLoop:
	mov dx, 320
	@innerLineLoop:
	mov es:[bx], al
	mov es:[bx+320], al
	mov es:[bx+640], al
	mov es:[bx+960], al
	inc bx
	dec dx
	jnz short @innerLineLoop:
	add bx, 960
	dec al
	dec cx
	jnz short @scanLineLoop:
}
}
