DECLARE SUB InitBlendMaps (TransBlendMap%())
DECLARE SUB SoundInterFace (Command%, Value1%, Value2%, Value3%, Value4%)
DECLARE SUB FadeOutStep (FadeOutFlag%, FadeStep%)
DECLARE SUB FadeInStep (PalString$, FadeInFlag%, FadeStep%)
DECLARE SUB Briefing8 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB Briefing7 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB Briefing6 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB Briefing5 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB Briefing4 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB Briefing3 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB Briefing2 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB BigNoise (UPPERLAYER&())
DECLARE SUB Noise (LOWERLAYER&())
DECLARE SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x%, y%, TextString$)
DECLARE SUB DisplayBriefingText (UPPERLAYER&(), LOWERLAYER&())
DECLARE SUB Briefing1 (RotatingObject() AS ANY, MissionPosition%, NextStep%, ExitFlags%)
DECLARE SUB Render3DObject (ScaleValue!, XScreenAdd%, YScreenAdd%, XrotAngle%, YrotAngle%, zRotAngle%, ObjectPolyCount%, ObjectMesh() AS ANY, VisibleObjectMesh() AS ANY, TextureMap&(), BlenderMap%(), Sine!(), Cosine!(), UPPERLAYER&(), LOWERLAYER&()) _

DECLARE SUB BlackPalette ()
DECLARE SUB GenerateTexTable (TextureTable&())
DECLARE SUB Disk2XMS (File$, Handle%)
DECLARE SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage%)
DECLARE SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSBackGroundHandle%)
DECLARE SUB GeneratePrimes (ObjectPrime() AS ANY, XMSHandles%)
DECLARE SUB MellowColors (PalString$)
DECLARE SUB AssimilatePalette (PaletteNumber%, FirstIndex%, ColorsToAssimilate%, PalString$)
DECLARE SUB CreateShadow (PalString$)
DECLARE SUB ShowOffscreen (VideoPage%, UPPERLAYER&(), LOWERLAYER&())
DECLARE SUB DrawWindow (UPPERLAYER&(), LOWERLAYER&(), x1%, y1%, x2%, y2%)

DECLARE SUB PPBlendTri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL X3%, BYVAL Y3%, BYVAL BlendMap%)
DECLARE SUB PPProjectVector (BYVAL Vec3DSeg%, BYVAL Vec3DOff&, BYVAL Vec2DSeg%, BYVAL Vec2DOff&, BYVAL ZEye!)
DECLARE SUB SortFaces CDECL ALIAS "_sort_polygons" (BYVAL polylist%, BYVAL PolyCount%)
DECLARE SUB ShadeRectangle CDECL ALIAS "_shade_rectangle" (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL hiview%, BYVAL loview%)
DECLARE SUB Darken CDECL (BYVAL hiview%, BYVAL loview%)


'$INCLUDE: 'slivedcx.bi'
'$INCLUDE: 'modexlib.bi'
'$DYNAMIC

TYPE RotatingObjectType
        ObjectType AS INTEGER
        YScreenAdd AS INTEGER
        Scale AS SINGLE
        Alive AS INTEGER
END TYPE

CONST TRUE = 1
CONST FALSE = 0


TYPE DrawPrimitive
        StartPoint AS LONG
        BytesLong AS LONG
END TYPE

TYPE ObjectPolygon
        x1 AS SINGLE
        y1 AS SINGLE
        Z1 AS SINGLE
        x2 AS SINGLE
        y2 AS SINGLE
        Z2 AS SINGLE
        X3 AS SINGLE
        Y3 AS SINGLE
        Z3 AS SINGLE
        Shade AS INTEGER
        TwoSided AS INTEGER
        FlippedNormals AS INTEGER
END TYPE

TYPE VisiblePolygon
        x1 AS INTEGER
        y1 AS INTEGER
        x2 AS INTEGER
        y2 AS INTEGER
        X3 AS INTEGER
        Y3 AS INTEGER
        Shade AS INTEGER
        AvgZ AS INTEGER
        DummyVar1 AS INTEGER
        DummyVar2 AS LONG
        DummyVar3 AS LONG
        DummyVar4 AS LONG
        DummyVar5 AS INTEGER
END TYPE

DEFINT A-Z
       
REDIM XMSCache&(16384)
REDIM UPPERLAYER&(16000)
REDIM LOWERLAYER&(16000)

REDIM RotatingObject(0) AS RotatingObjectType
REDIM SHARED MissionText(9) AS STRING * 20
REDIM TransBlendMap(128)
REDIM PolyCount(0)
REDIM ObjectPrime(128) AS DrawPrimitive
REDIM ObjectMesh(126) AS ObjectPolygon
REDIM VisibleObjectMesh(126) AS VisiblePolygon
REDIM Sine!(360), Cosine!(360)
REDIM TextureTable&(128)

  FOR i% = 0 TO 360
    Ang! = i% * (3.141592 / 180)
    Sine!(i%) = SIN(Ang!)
    Cosine!(i%) = COS(Ang!)
  NEXT
VideoPage = 1
Pal$ = SPACE$(768)
ExitFlags = FALSE
XMSDetect = CSDetectXMS
IF XMSDetect = 0 THEN END
       
        XMSMeshHandle = CSAllocateXMS(200)
        XMSTextureHandle = CSAllocateXMS(1500)
        XMSBackGroundHandle = CSAllocateXMS(130)
       
        Disk2XMS "briefing.dx", XMSBackGroundHandle
        Disk2XMS "models.dx", XMSMeshHandle
        Disk2XMS "surfaces.dx", XMSTextureHandle
        GOSUB LoadFiles:
        GeneratePrimes ObjectPrime(), XMSMeshHandle
        GenerateTexTable TextureTable&()

Font$ = SPACE$(2048)
OPEN "fontface.db" FOR BINARY AS #1
SEEK #1, 1
GET #1, , Font$
CLOSE #1
CSSetFont Font$
        Rfl = CSLoadPal("palette.dat", Pal$)
        AssimilatePalette 12, 128, 64, Pal$
        CreateShadow Pal$
        MellowColors Pal$
        InitBlendMaps TransBlendMap()
BlackPalette
zRotAngle = 0
XrotAngle = 24
mxFill Page0in320x400&, Full320x400, 0
mxFill Page1in320x400&, Full320x400, 0
MissionPosition = 1
Transition = FALSE
GOSUB PickAppopriateBriefSUB
Timer1Timer = NextStep

CSInstallTimer
CSInstallKeyBoard
CSSetTimer 0, 40
CSSetTimer 1, 1000
CSSetTimer 2, 500
BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSBackGroundHandle
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
KeyFlags = TRUE
FadeInFlag = TRUE
FadeStep = 0
TotalTicksToWait = 0
DO
BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSBackGroundHandle
IF RotatingObject(0).Alive = TRUE AND Transition = FALSE THEN GOSUB DisplayObject3D
IF RotatingObject(0).Alive = -1 OR Transition = TRUE THEN Noise LOWERLAYER&()
IF Transition = FALSE THEN DisplayBriefingText UPPERLAYER&(), LOWERLAYER&() ELSE BigNoise LOWERLAYER&()
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
IF CSElapsedTicks&(0) = 0 THEN CSWaitTimer 0
CSResetTicks 0
IF Transition = FALSE THEN CSResetTicks 2
IF CSElapsedTicks&(1) > TotalTicksToWait THEN GOSUB TimerInterrupt
IF CSElapsedTicks&(2) > 0 THEN GOSUB TransitionOff:

IF ExitFlags = FALSE THEN
        IF CSKey(KEYESC) THEN FadeOutFlag = TRUE: ExitFlags = 1
        IF (CSKey(KEYSPACE) OR CSKey(KEYENTER)) AND KeyFlags = TRUE THEN
                KeyFlags = FALSE
                Timer1Timer = 1
                TotalTicksToWait = -1
        END IF
END IF

IF ExitFlags = 1 THEN FadeOutFlag = TRUE
IF FadeInFlag = TRUE THEN FadeInStep Pal$, FadeInFlag, FadeStep
IF FadeOutFlag = TRUE THEN
        FadeOutStep FadeOutFlag, FadeStep
        ExitFlags = ExitFlags + 1
        IF ExitFlags = 16 THEN EXIT DO
END IF
LOOP
        BlackPalette
        CSRemoveTimer
        CSRemoveKeyBoard
        CSDeallocateXMS XMSMeshHandle
        CSDeallocateXMS XMSTextureHandle
        CSDeallocateXMS XMSBackGroundHandle

IF DS4QBActive = TRUE THEN
        OPEN "prefs.db" FOR BINARY AS FileHandle
        SEEK FileHandle, 1
        IF MusicOn = TRUE THEN DS4QBActive = 2 ELSE DS4QBActive = TRUE
        PUT FileHandle, , DS4QBActive
        CLOSE FileHandle
END IF
       
RUN "scapez01.xbn"
DisplayObject3D:
        YrotAngle = YrotAngle + 4
        IF YrotAngle >= 360 THEN YrotAngle = YrotAngle - 360
        ObjectNumber = RotatingObject(0).ObjectType
        XScreenAdd = 95
        YScreenAdd = RotatingObject(0).YScreenAdd
        ScaleValue! = RotatingObject(0).Scale
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSTextureHandle, TextureTable&(ObjectNumber - 1), 16400
        Start& = ObjectPrime(ObjectNumber - 1).StartPoint
        Length& = ObjectPrime(ObjectNumber - 1).BytesLong
        CSMoveFromXMS VARSEG(PolyCount(0)), VARPTR(PolyCount(0)), XMSMeshHandle, Start&, 2
        CSMoveFromXMS VARSEG(ObjectMesh(0).x1), VARPTR(ObjectMesh(0).x1), XMSMeshHandle, Start& + 2, Length& - 2
        Render3DObject ScaleValue!, XScreenAdd, YScreenAdd, 316, YrotAngle, 0, PolyCount(0), ObjectMesh(), VisibleObjectMesh(), XMSCache&(), TransBlendMap(), Sine!(), Cosine!(), UPPERLAYER&(), LOWERLAYER&()
RETURN

TimerInterrupt:
Timer1Timer = Timer1Timer - 1
        IF Timer1Timer = 0 THEN
        GOSUB PickAppopriateBriefSUB
        Timer1Timer = NextStep
        Transition = TRUE
        CSResetTicks 2
        END IF
CSResetTicks 1
TotalTicksToWait = 0
RETURN
TransitionOff:
CSResetTicks 2
Transition = FALSE
KeyFlags = TRUE
RETURN

PickAppopriateBriefSUB:
        SELECT CASE LevelNum
        CASE 1
        Briefing1 RotatingObject(), MissionPosition, NextStep, ExitFlags
        CASE 2
        Briefing2 RotatingObject(), MissionPosition, NextStep, ExitFlags
        CASE 3
        Briefing3 RotatingObject(), MissionPosition, NextStep, ExitFlags
        CASE 4
        Briefing4 RotatingObject(), MissionPosition, NextStep, ExitFlags
        CASE 5
        Briefing5 RotatingObject(), MissionPosition, NextStep, ExitFlags
        CASE 6
        Briefing6 RotatingObject(), MissionPosition, NextStep, ExitFlags
        CASE 7
        Briefing7 RotatingObject(), MissionPosition, NextStep, ExitFlags
        CASE 8
        Briefing8 RotatingObject(), MissionPosition, NextStep, ExitFlags
        END SELECT
RETURN

LoadFiles:
FileHandle = FREEFILE
OPEN "player.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
GET FileHandle, , LevelNum
GET FileHandle, , Skill
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
CLOSE FileHandle
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
GET FileHandle, , DS4QBActive
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , Dummy
GET FileHandle, , MusicVol
GET FileHandle, , Dummy
CLOSE FileHandle
IF MusicVol > 0 THEN MusicOn = TRUE ELSE MusicOn = FALSE
SoundInterFace 0, DS4QBActive, 0, 0, 0
IF MusicOn = TRUE THEN SoundInterFace 3, LevelNum + 1, 1, 0, 0
RETURN

REM $STATIC
SUB AssimilatePalette (PaletteNumber, FirstIndex, ColorsToAssimilate, PalString$)
FileHandle = FREEFILE
OPEN "coltabs.db" FOR BINARY AS FileHandle
SEEK FileHandle, ((PaletteNumber - 1) * 1536) + 1
PaletteIndex = FirstIndex * 3 + 1
FOR index = 0 TO ColorsToAssimilate - 1
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 1, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 2, 1) = CHR$(ColorComponent)
        PaletteIndex = PaletteIndex + 3
NEXT
CLOSE FileHandle
END SUB

SUB BigNoise (LOWERLAYER&())
        FOR index = 0 TO 2999
        x = 11 + RND * 168
        y = 1 + RND * 169
        c = RND * 15
        CSPset VARSEG(LOWERLAYER&(0)), x, y, c
        NEXT
END SUB

SUB BlackPalette
FOR index = 0 TO 255
        CSSetCol index, 0, 0, 0
NEXT
END SUB

SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSBackGroundHandle)
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSBackGroundHandle, 0, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(UPPERLAYER&(0))
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSBackGroundHandle, 64000, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(LOWERLAYER&(0))
Darken VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 10, 200, 180, 370
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 200, 200, 310, 370
END SUB

SUB Briefing1 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)
        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0

SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 1:"
MissionText(1) = " FROZEN ASHES"
MissionText(3) = "LOCATION:"
MissionText(4) = " NOVAJA ZEMLIJA"
MissionText(5) = " NORTHERN RUSSIA"
NextStep = 6
CASE 2
MissionText(0) = "OUR INTELLIGENCE HAD"
MissionText(1) = "AN INTERESTING BIT"
MissionText(2) = "OF INFORMATION ABOUT"
MissionText(3) = "THE TUPOLEV-ILUSJIN"
MissionText(4) = "CORPORATION."
MissionText(5) = "THEY ARE PLANNING TO"
MissionText(6) = "ASSEMBLE A SUBATOMIC"
MissionText(7) = "NUCLEAR WEAPON."
MissionText(8) = "- THE QUARK BOMB."
NextStep = 10
CASE 3
MissionText(0) = "THE QUARK BOMB IS"
MissionText(1) = "UTTERLY DESTRUCTIVE"
MissionText(2) = "WEAPON OF MASS"
MissionText(3) = "DESTRUCTION."
MissionText(4) = "IT REASSEMBLES THE"
MissionText(5) = "QUARKS OF THE ATOMIC"
MissionText(6) = "STRUCTURE OF A BODY."
MissionText(7) = "BASICALLY IT WIPES"
MissionText(8) = "OUT ALL MATTER WITH-"
MissionText(9) = "IN ITS BLAST RADIUS."
NextStep = 11
CASE 4
MissionText(0) = "IN OPTIMAL"
MissionText(1) = "CIRCUMSTANCES"
MissionText(2) = "THE BOMB CAN WIPE"
MissionText(3) = "OUT AN ENTIRE"
MissionText(4) = "CONTINENT."
MissionText(6) = "NICE, ISN'T IT."
NextStep = 9
CASE 5
MissionText(0) = "DESTROY ALL CRUCIAL"
MissionText(1) = "RESEARCH SITES AND"
MissionText(2) = "ADVANCE TO THE"
MissionText(3) = "ILUSJIN MISSILE"
MissionText(4) = "LAUNCH SILO."
MissionText(6) = "TAKE OUT AS MANY"
MissionText(7) = "ENEMY FORCES AS YOU"
MissionText(8) = "CAN."
NextStep = 11
CASE 6
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 7
MissionText(0) = "ENEMY:"
MissionText(1) = "ILUSJIN ZEPHYR"
MissionText(3) = "ALTHOUGH AN OUTDATED"
MissionText(4) = "MODEL, IT IS STILL"
MissionText(5) = "DANGEROUS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 8
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .55
NextStep = 12
CASE 8
MissionText(0) = "ENEMY:"
MissionText(1) = "ILUSJIN SNOWSTORM"
MissionText(3) = "CAMOUFLAGED FOR"
MissionText(4) = "ARCTIC ENVIRONMENT."
MissionText(5) = "THESE'LL SNEAK UP"
MissionText(6) = "ON YOU."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 9
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 9
MissionText(0) = "VEHICLE:"
MissionText(1) = "BUK M-7"
MissionText(3) = "THESE SURFACE TO AIR"
MissionText(4) = "MISSILE LAUNCHERS"
MissionText(5) = "PROTECT THE RESEARCH"
MissionText(6) = "SITES."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 11
        RotatingObject(0).YScreenAdd = 120
        RotatingObject(0).Scale = .25
NextStep = 12
CASE 10
MissionText(0) = "STRUCTURE:"
MissionText(1) = "ILUSJIN TECH CENTER"
MissionText(3) = "DESTROY ALL OF"
MissionText(4) = "THESE."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 15
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .2
NextStep = 12
CASE 11
MissionText(0) = "STRUCTURE:"
MissionText(1) = "TESLA REACTOR"
MissionText(3) = "THESE PROVIDE ENERGY"
MissionText(4) = "TO THE RESEARCH"
MissionText(5) = "BUILDINGS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 12
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .15
NextStep = 12
CASE 12
MissionText(0) = "STRUCTURE:"
MissionText(1) = "STORAGE BUNKER"
MissionText(3) = "BLOW THESE UP FOR"
MissionText(4) = "WEAPONS AND ENERGY"
MissionText(5) = "CORES."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 13
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .18
NextStep = 12
CASE 13
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1
END SUB

SUB Briefing2 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)
        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0
SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 2:"
MissionText(1) = " REDUCED TO DUST"
MissionText(3) = "LOCATION:"
MissionText(4) = " ALGERIA DESERT"
NextStep = 6
CASE 2
MissionText(0) = "THE OPEC CORPORATION"
MissionText(1) = "CONTROLS ALMOST 80"
MissionText(2) = "PERCENT OF THE "
MissionText(3) = "WORLD'S ENERGY AND"
MissionText(4) = "FUEL PRODUCTION."
MissionText(5) = "THEY ARE THREATING"
MissionText(6) = "TO START MASSIVE"
MissionText(7) = "HOSTILITIES AGAINST"
MissionText(8) = "THE FREE NATIONS."
NextStep = 10
CASE 3
MissionText(0) = "IN ORDER TO PREVENT"
MissionText(1) = "THE HOSTILITIES, WE"
MissionText(2) = "HAVE TO AGREE WITH"
MissionText(3) = "THEIR 300 PERCENT"
MissionText(4) = "RAISE OF PRICES."
MissionText(6) = "THAT'S NOT GOING TO"
MissionText(7) = "HAPPEN..."
NextStep = 11
CASE 4
MissionText(0) = "YOU MUST GIVE THE"
MissionText(1) = "OPEC CORPORATION"
MissionText(2) = "A LESSON."
MissionText(3) = "USE THE ELDEST"
MissionText(4) = "FORM OF DIPLOMACY."
MissionText(5) = "- VIOLENCE."
NextStep = 9
CASE 5
MissionText(0) = "YOUR PRIORISED"
MissionText(1) = "TARGET IS THE OPEC"
MissionText(2) = "PETRONAS TOWER, "
MissionText(3) = "WHICH IS THEIR"
MissionText(4) = "HEADQUARTERS."
MissionText(6) = "YOU CAN ALSO CAUSE"
MissionText(7) = "SOME HAVOC TO THEIR"
MissionText(8) = "REFINERIES AND"
MissionText(9) = "TANKERS."
NextStep = 11
CASE 6
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 7
MissionText(0) = "ENEMY:"
MissionText(1) = "OPEC DUSTDEVIL"
MissionText(3) = "THIS IS THEIR BASIC"
MissionText(4) = "DESERT PATROL"
MissionText(5) = "VEHICLE."
MissionText(6) = "SLOW BUT AGILE."
MissionText(7) = "ARMED WITH TWO ION"
MissionText(8) = "CANNONS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 20
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .55
NextStep = 12
CASE 8
MissionText(0) = "ENEMY:"
MissionText(1) = "OPEC PENETRATOR"
MissionText(3) = "FAST ATTACK FIGHTER"
MissionText(4) = "CRAFT. TOUGH TO"
MissionText(5) = "KILL."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 21
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 9
MissionText(0) = "ENEMY:"
MissionText(1) = "OPEC HIND-B"
MissionText(3) = "THESE HELICOPTERS"
MissionText(4) = "PROTECT OIL TANKERS"
MissionText(5) = "AND REFINERIES."

        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 22
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .45
NextStep = 12
CASE 10
MissionText(0) = "WEAPON:"
MissionText(1) = "AL-SAMOUD LASER"
MissionText(3) = "ARMORED GROUND BASED"
MissionText(4) = "LASER TURRET."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 23
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .25
NextStep = 12
CASE 11
MissionText(0) = "STRUCTURE:"
MissionText(1) = "REFINERY"
MissionText(3) = "DESTROYING THESE"
MissionText(4) = "CAN COMPLETELY"
MissionText(5) = "RUIN THEIR"
MissionText(6) = "INFRASTRUCTURE."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 27
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .17
NextStep = 12
CASE 12
MissionText(0) = "STRUCTURE:"
MissionText(1) = "OPEC POWERSTATION"
MissionText(3) = "THESE BUILDINGS"
MissionText(4) = "EXTRACT GEOTHERMIC"
MissionText(5) = "ENERGY AND CONVERT"
MissionText(6) = "IT TO ELECTRICITY."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 26
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .17
NextStep = 12
CASE 13
MissionText(0) = "VEHICLE:"
MissionText(1) = "OIL TANKER"
MissionText(3) = "THESE ENORMOUS"
MissionText(4) = "VEHICLES FERRY"
MissionText(5) = "OIL LOADS FROM"
MissionText(6) = "REFINERIES TO"
MissionText(7) = "OPEC STOCKS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 24
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .22
NextStep = 12
CASE 14
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1
END SUB

SUB Briefing3 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)
       
        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0
SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 3:"
MissionText(1) = " BIRD OF PREY"
MissionText(3) = "LOCATION:"
MissionText(4) = " ARGENTINA"
NextStep = 6
CASE 2
MissionText(0) = "THE REBEL 'AF'"
MissionText(1) = "MILITARY HAS"
MissionText(2) = "A DEVASTATING"
MissionText(3) = "WARSHIP, CALLED THE"
MissionText(4) = "INTRUDER."
MissionText(5) = "CAPABLE OF CARRYING"
MissionText(6) = "HYDROGEN BOMBS, THIS"
MissionText(7) = "SHIP IS ONE OF THE"
MissionText(8) = "MOST DREADFUL"
MissionText(9) = "BOMBERS EVER MADE."
NextStep = 11
CASE 3
MissionText(0) = "INTELLIGENCE REPORTS"
MissionText(1) = "THAT THE INTRUDER"
MissionText(2) = "IS GOING TO GET"
MissionText(3) = "LAUNCHED AGAINST"
MissionText(4) = "BUENOS AIRES."
NextStep = 11
CASE 4
MissionText(0) = "FIND AND ELIMINATE"
MissionText(1) = "THE INTRUDER AT"
MissionText(2) = "ALL COSTS."
MissionText(3) = "THE LIVES OF THE 50"
MissionText(4) = "MILLION PEOLE LIE"
MissionText(5) = "IN YOUR HANDS."
MissionText(7) = "DON'T FAIL."
NextStep = 10
CASE 5
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 6
MissionText(0) = "ENEMY:"
MissionText(1) = "AF HARPYIA"
MissionText(3) = "BASIC SENTINEL"
MissionText(4) = "FIGHTER."
MissionText(5) = "FAST AND WELL"
MissionText(6) = "ARMED."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 32
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 7
MissionText(0) = "ENEMY:"
MissionText(1) = "AF WRAITH"
MissionText(3) = "SUPERSONIC FIGHTER."
MissionText(4) = "POWERFUL WEAPONS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 33
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 8
MissionText(0) = "WEAPON:"
MissionText(1) = "AF GATLING LASER"
MissionText(3) = "FLAK CANNONS WITH"
MissionText(4) = "HEAVY FIREPOWER."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 34
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .25
NextStep = 12
CASE 9
MissionText(0) = "STRUCTURE:"
MissionText(1) = "AF RADAR DISH"
MissionText(3) = "THESE DEVICES"
MissionText(4) = "ARE USED TO"
MissionText(5) = "SURVEIL OVER THE"
MissionText(6) = "INTRUDER."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 36
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .17
NextStep = 12
CASE 10
MissionText(0) = "STRUCTURE:"
MissionText(1) = "AF HEADQUARTERS"
MissionText(3) = "DESTROY THESE"
MissionText(4) = "TOWERS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 39
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .14
NextStep = 12
CASE 11
MissionText(0) = "STRUCTURE:"
MissionText(1) = "PERSONNEL BARRACKS"
MissionText(3) = "THESE BUILDINGS"
MissionText(4) = "CONTAIN AF GROUND"
MissionText(5) = "FORCES. DESTROY"
MissionText(6) = "THEM."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 37
        RotatingObject(0).YScreenAdd = 120
        RotatingObject(0).Scale = .18
NextStep = 12
CASE 12
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1
END SUB

SUB Briefing4 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)
      
        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0
SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 4:"
MissionText(1) = " LUNAR APOCALYPSE"
MissionText(3) = "LOCATION:"
MissionText(4) = " MOON"
NextStep = 6
CASE 2
MissionText(0) = "THE TEK-LA INC."
MissionText(1) = "HAS ESTABLISHED"
MissionText(2) = "A FORTIFICATION,"
MissionText(3) = "WHICH HAS A MEAN"
MissionText(4) = "TURBOLASER WEAPON."
NextStep = 8
CASE 3
MissionText(0) = "THE TURBOLASER"
MissionText(1) = "BLOCKS ALL SPACE"
MissionText(2) = "TRANSPORTS NEAR"
MissionText(3) = "EARTH AND MOON."
MissionText(4) = "IN ORDER TO MAKE"
MissionText(5) = "THE TRAFFIC RUN, THE"
MissionText(6) = "FORTIFICATION MUST"
MissionText(7) = "BE DESTROYED."
NextStep = 11
CASE 4
MissionText(0) = "A NOTE OF CAUTION:"
MissionText(2) = "IF YOU TRY TO"
MissionText(3) = "APPROACH THE"
MissionText(4) = "FORTIFICATION WHILE"
MissionText(5) = "THE TURBOLASER IS"
MissionText(6) = "ENABLED, YOU ARE"
MissionText(7) = "VAPOR."
NextStep = 10
CASE 5
MissionText(0) = "INTELLIGENCE REPORTS"
MissionText(1) = "THAT THERE ARE"
MissionText(2) = "SEVERAL REACTORS"
MissionText(3) = "WHICH PRODUCE ENERGY"
MissionText(4) = "FOR THE TURBOLASER"
MissionText(6) = "DESTROYING THEM"
MissionText(7) = "RENDERS THE LASER"
MissionText(8) = "USELESS."
NextStep = 10
CASE 6
MissionText(0) = "LOCATE AND DESTROY"
MissionText(1) = "THE REACTORS AND"
MissionText(2) = "PROCEED TO THE"
MissionText(3) = "FORTIFICATION."
MissionText(4) = "ALTHOUGH ITS LASER"
MissionText(5) = "IS NOT FUNCTIONAL,"
MissionText(6) = "IT STILL HAS"
MissionText(7) = "MISSILE LAUNCHERS"
MissionText(8) = "AS A SECONDARY"
MissionText(9) = "WEAPON."
NextStep = 11
CASE 7
MissionText(0) = "AND BY THE WAY..."
MissionText(1) = "WE HAVE PICKED"
MissionText(2) = "SEVERAL WEIRD"
MissionText(3) = "TRANSMISSIONS WHICH"
MissionText(4) = "CONCERN OF SOMETHING"
MissionText(5) = "CALLED 'IRRAH'."
MissionText(6) = "WE HAVE NO DATA"
MissionText(7) = "ABOUT IT, BE WE'LL"
MissionText(8) = "KEEP YOU INFORMED"
MissionText(9) = "AS WE LEARN MORE..."
NextStep = 12
CASE 8
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 9
MissionText(0) = "ENEMY:"
MissionText(1) = "TEK-LA WEDGE FIGHTER"
MissionText(3) = "A MULTIPURPOSE SPACE"
MissionText(4) = "FIGHTER CRAFT."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 42
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 10
MissionText(0) = "ENEMY:"
MissionText(1) = "TEK-LA PIRANHA"
MissionText(3) = "DESTRUCTIVE SPACE"
MissionText(4) = "FIGHTER."
MissionText(5) = "TRIAD LASERS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 43
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .4
NextStep = 12
CASE 11
MissionText(0) = "VEHICLE:"
MissionText(1) = "LUNOHOD ROVER"
MissionText(3) = "THESE ROVERS FERRY"
MissionText(4) = "PERSONNEL AND"
MissionText(5) = "EQUIPMENT BETWEEN"
MissionText(6) = "THE BASES."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 45
        RotatingObject(0).YScreenAdd = 120
        RotatingObject(0).Scale = .35
NextStep = 12
CASE 12
MissionText(0) = "STRUCTURE:"
MissionText(1) = "DELODA BUNKER"
MissionText(3) = "EQUIPPED WITH"
MissionText(4) = "AUTO-TRACKING"
MissionText(5) = "LASERS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 44
        RotatingObject(0).YScreenAdd = 115
        RotatingObject(0).Scale = .24
NextStep = 12
CASE 13
MissionText(0) = "STRUCTURE:"
MissionText(1) = "AGEANESIS REACTOR"
MissionText(3) = "THESE ARE USED TO"
MissionText(4) = "POWER THE"
MissionText(5) = "TURBOLASER."
RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 48
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .17
NextStep = 12
CASE 14
MissionText(0) = "STRUCTURE:"
MissionText(1) = "X-COM ARRAY"
MissionText(3) = "LONG RANGE"
MissionText(4) = "MICROWAVE RADAR."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 50
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .18
NextStep = 12
CASE 15
MissionText(0) = "STRUCTURE:"
MissionText(1) = "TEK-LA HABITAT"
MissionText(3) = "ALL RESEARCH AND"
MissionText(4) = "MAINTENANCE ARE"
MissionText(5) = "DONE INSIDE THESE"
MissionText(6) = "BUILDINGS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 49
        RotatingObject(0).YScreenAdd = 135
        RotatingObject(0).Scale = .16
NextStep = 12
CASE 16
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1

END SUB

SUB Briefing5 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)
     
        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0
SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 5:"
MissionText(1) = " THE SANDS OF MARS"
MissionText(3) = "LOCATION:"
MissionText(4) = " MARS"
NextStep = 6
CASE 2
MissionText(0) = "WE HAVE LOCATED"
MissionText(1) = "A REALLY DEADLY"
MissionText(2) = "DESTROYER CRAFT,"
MissionText(3) = "THE THUNDERBIRD."
MissionText(4) = "IT IS UNDER"
MissionText(5) = "POSSESSION OF THE"
MissionText(6) = "MFC CORPORATION."
NextStep = 11
CASE 3
MissionText(0) = "THE THUNDERBIRD"
MissionText(1) = "CAN OUTMATCH ALL"
MissionText(2) = "INITIATIVE SHIPS"
MissionText(3) = "IN SPACE COMBAT."
MissionText(4) = "BUT IT HAS ONE"
MissionText(5) = "MAJOR WEAKNESS."
MissionText(7) = "LUCKILY."
NextStep = 11
CASE 4
MissionText(0) = "WITHIN ATMOSPHERE"
MissionText(1) = "IT IS MUCH LESS"
MissionText(2) = "MANEUVERABLE THAN"
MissionText(3) = "A REGULAR FIGHTER."
MissionText(4) = "A REALLY GOOD"
MissionText(5) = "PILOT, LIKE YOU,"
MissionText(6) = "CAN DROP IT."
NextStep = 11
CASE 5
MissionText(0) = "LOCATE AND"
MissionText(1) = "DESTROY THE"
MissionText(2) = "THUNDERBIRD."
MissionText(4) = "WARNING:"
MissionText(5) = "OUR PERIMETER"
MissionText(6) = "SCANNERS SHOW"
MissionText(7) = "HEAVY FLEET"
MissionText(8) = "ACTIVITY ON THE"
MissionText(9) = "MARTIAN SURFACE."
NextStep = 12
CASE 6
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 7
MissionText(0) = "ENEMY:"
MissionText(1) = "MFC SCORPION"
MissionText(3) = "A HIT-AND-RUN"
MissionText(4) = "FIGHTER CRAFT."
MissionText(5) = "ARMED WITH BURST"
MissionText(6) = "LASER WEAPON"
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 54
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .55
NextStep = 12
CASE 8
MissionText(0) = "ENEMY:"
MissionText(1) = "MFC SHOCKSTAR"
MissionText(3) = "ALTHOUGH SLOW, THIS"
MissionText(4) = "FIGHTER IS HEAVILY"
MissionText(5) = "ARMORED AND FORCE-"
MissionText(6) = "SHIELDED."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 55
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 9
MissionText(0) = "ENEMY:"
MissionText(1) = "MFC HOVERDYNE"
MissionText(3) = "THESE HOVERCRAFTS"
MissionText(4) = "ARE EQUIPPED WITH"
MissionText(5) = "POWERFUL MISSILE"
MissionText(6) = "LAUNCHERS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 56
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 10
MissionText(0) = "VEHICLE:"
MissionText(1) = "VIPER-6 TANK"
MissionText(3) = "POWERFUL GROUND"
MissionText(4) = "TO AIR LAUNCHERS."
MissionText(5) = "HEAVILY ARMORED."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 57
        RotatingObject(0).YScreenAdd = 115
        RotatingObject(0).Scale = .25
NextStep = 12
CASE 11
MissionText(0) = "STRUCTURE:"
MissionText(1) = "MFC HOVER STATION"
MissionText(3) = "AIRBORNE WATCHDOG"
MissionText(4) = "BUILDING."
RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 58
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .18
NextStep = 12
CASE 12
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1

END SUB

SUB Briefing6 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)
        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0
SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 6:"
MissionText(1) = " INFERNO"
MissionText(3) = "LOCATION:"
MissionText(4) = " IO - JUPITER'S MOON"
NextStep = 6
CASE 2
MissionText(0) = "COVERED BY MOLTEN"
MissionText(1) = "SULPHUR, WITH"
MissionText(2) = "HOTSPOT TEMPERATURES"
MissionText(3) = "EXCEEDING 3600C AND"
MissionText(4) = "RADIATION LEVELS ON"
MissionText(5) = "THE SURFACE, WHICH"
MissionText(6) = "WILL KILL"
MissionText(7) = "UNPROTECTED HUMAN"
MissionText(8) = "IN TWO MINUTES, THE"
MissionText(9) = "IO IS UNHABITABLE."
NextStep = 12
CASE 3
MissionText(0) = "AND STILL WE FOUND"
MissionText(1) = "ACTIVITY DOWN THERE."
MissionText(2) = "THE CROENEXIA"
MissionText(3) = "INDUSTRIES HAS"
MissionText(4) = "FORMED A COMPLEX"
MissionText(5) = "OF BASES ON THE"
MissionText(6) = "SURFACE OF IO."
MissionText(8) = "THEY'RE HIDING"
MissionText(9) = "SOMETHING..."
NextStep = 11
CASE 4
MissionText(0) = "WE HAVE BUGGED"
MissionText(1) = "THEIR TRANSPORT"
MissionText(2) = "SHIPS AND HACKED"
MissionText(3) = "THEIR NETWORKS,"
MissionText(4) = "BUT WE GOT ONLY"
MissionText(5) = "SOME ERRATIC"
MissionText(6) = "INFORMATION."
NextStep = 11
CASE 5
MissionText(0) = "HOWEVER, WE GOT"
MissionText(1) = "SOME BITS OF"
MissionText(2) = "USEFUL DATA."
MissionText(3) = "THERE SEEMS TO BE"
MissionText(4) = "SOMETHING CALLED"
MissionText(5) = "'NEBUKADNESSAR' ON"
MissionText(6) = "THE SURFACE. WE DO"
MissionText(7) = "NOT KNOW WHAT IT IS"
MissionText(8) = "AND WE'LL SEND YOU"
MissionText(9) = "DOWN THERE."
NextStep = 12
CASE 6
MissionText(0) = "OK, THIS IS JUST"
MissionText(1) = "A RECONNAISANCE"
MissionText(2) = "MISSION. BUT BE"
MissionText(3) = "CAUTIONED. THERE'S"
MissionText(4) = "DEFINITELY SOME"
MissionText(5) = "CROENEXIAN FIGHTERS"
MissionText(6) = "WAITING FOR YOU."
NextStep = 10
CASE 7
MissionText(0) = "IT'S STRANGE, BUT WE"
MissionText(1) = "HAVE BUGGED OUT SOME"
MissionText(2) = "ADDITIONAL INFO"
MissionText(3) = "ABOUT THIS 'IRRAH'."
MissionText(4) = "IT SEEMS TO BE"
MissionText(5) = "SOMETHING REALLY"
MissionText(6) = "EXTRAORDINARY."
MissionText(7) = "HOPEFULLY IT ISN'T"
MissionText(8) = "ANYTHING WICCAN OR"
MissionText(9) = "NEW AGE STUFF..."
NextStep = 12
CASE 8
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 9
MissionText(0) = "ENEMY:"
MissionText(1) = "CROENEXIAN APOLLO"
MissionText(3) = "EQUIPPED WITH"
MissionText(4) = "SUPERCOOLED ENGINE"
MissionText(5) = "SYSTEM."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 65
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .55
NextStep = 12
CASE 10
MissionText(0) = "ENEMY:"
MissionText(1) = "CROENEXIAN RAZORFLEX"
MissionText(3) = "FAST SPACE FIGHTER."
MissionText(4) = "HARD TO SPOT DUE TO"
MissionText(5) = "ITS DISTRACTIVE"
MissionText(6) = "MANEUVRES."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 66
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 11
MissionText(0) = "ENEMY:"
MissionText(1) = "SMALL HULK"
MissionText(3) = "PLANETARY EXPLORER"
MissionText(4) = "CRAFT REFITTED WITH"
MissionText(5) = "ION CANNONS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 67
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .55
CASE 12
MissionText(0) = "ENEMY:"
MissionText(1) = "LARGE HULK"
MissionText(3) = "TRANSPORT SHUTTLE"
MissionText(4) = "REFITTED WITH"
MissionText(5) = "PLASMA CANNON."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 68
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .55
CASE 13
MissionText(0) = "ENEMY:"
MissionText(1) = "CR-2 SHELLSHOCK"
MissionText(3) = "WE HAVE ONLY LITTLE"
MissionText(4) = "INFORMATION ABOUT"
MissionText(5) = "THIS HOVERCRAFT."
MissionText(6) = "IT SEEMS TO BE"
MissionText(7) = "ARMED WITH MISSILES."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 69
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .65
CASE 14
MissionText(0) = "STRUCTURE:"
MissionText(1) = "UNKNOWN"
MissionText(3) = "BELIEVED TO BE"
MissionText(4) = "MODERN ART..."
RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 73
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .17
NextStep = 12
CASE 15
MissionText(0) = "STRUCTURE:"
MissionText(1) = "EXCHAUST VENT"
MissionText(3) = "NOT MUCH KNOWN"
MissionText(4) = "ABOUT IT."
RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 72
        RotatingObject(0).YScreenAdd = 120
        RotatingObject(0).Scale = .18
NextStep = 12
CASE 16
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1
END SUB

SUB Briefing7 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)
        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0
SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 7:"
MissionText(1) = " OUTER REGIONS"
MissionText(3) = "LOCATION:"
MissionText(4) = " QUAOAR ASTEROID"
NextStep = 6
CASE 2
MissionText(0) = "BEYOND THE ORBIT"
MissionText(1) = "OF NEPTUNE LIES THIS"
MissionText(2) = "DARK WORLD. IT IS"
MissionText(3) = "ENTIRELY COVERED BY"
MissionText(4) = "FROZEN METHANE."
MissionText(6) = "AND YET, THERE'S"
MissionText(7) = "HUMANS DOWN THERE."
NextStep = 10
CASE 3
MissionText(0) = "HEAVY FLEET ACTIVITY"
MissionText(1) = "AROUND THIS ASTEROID"
MissionText(2) = "SPOTTED OUT OUR"
MissionText(3) = "ATTENTION."
MissionText(4) = "THERE IS A SPECIAL"
MissionText(5) = "MILITARY BASE"
MissionText(6) = "CALLED 'THE IRRAH"
MissionText(7) = "WARDEN'."
NextStep = 12
CASE 4
MissionText(0) = "THE 'IRRAH' SEEMS"
MissionText(1) = "TO BE AN ANCIENT"
MissionText(2) = "ALIEN ARTIFACT."
MissionText(3) = "WE DO NOT KNOW,"
MissionText(4) = "WHY IT'S SO SPECIAL."
MissionText(6) = "BUT THE 'WARDENS'"
MissionText(7) = "RESPECT IT AS A"
MissionText(8) = "REINCARNATION OF"
MissionText(9) = "ALMIGHTY GOD."
NextStep = 12
CASE 5
MissionText(0) = "INTELLIGENCE REPORTS"
MissionText(1) = "THAT THERE'S A"
MissionText(2) = "DISTRESS BEACON ON"
MissionText(3) = "THE SURFACE. IF WE"
MissionText(4) = "- OR TO BE MORE"
MissionText(5) = "PRECISE - YOU, CAN"
MissionText(6) = "DESTROY IT, WEIRD"
MissionText(7) = "THINGS MAY HAPPEN."
MissionText(9) = "THIS GIVES CREEPS."
NextStep = 12
CASE 6
MissionText(0) = "WHATEVER THIS"
MissionText(1) = "'IRRAH' IS, IT MAY"
MissionText(2) = "REVEAL ITSELF IF THE"
MissionText(3) = "DISTRESS BEACON"
MissionText(4) = "IS DESTROYED."
NextStep = 10
CASE 7
MissionText(0) = "YES, WE ARE GOING"
MissionText(1) = "TO TAKE A BIG SCALE"
MissionText(2) = "RISK HERE, BUT WE"
MissionText(3) = "ARE PRETTY SURE THAT"
MissionText(4) = "THOSE RELIGIOUS"
MissionText(5) = "FREAKS WILL KILL"
MissionText(6) = "EVERYONE, EXCEPT"
MissionText(7) = "THE 'IRRAH'"
MissionText(8) = "FOLLOWERS, ANYWAY."
NextStep = 12
CASE 8
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 9
MissionText(0) = "ENEMY:"
MissionText(1) = "IWD SHRIEK FIGHTER"
MissionText(3) = "MADE FOR SPEED."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 77
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 10
MissionText(0) = "ENEMY:"
MissionText(1) = "IWD DARKSTAR"
MissionText(3) = "WITH PITCH-BLACK"
MissionText(4) = "HULL AND EXCESSIVE"
MissionText(5) = "SPEED, THIS FIGHTER"
MissionText(6) = "IS ALMOST IMPOSSIBLE"
MissionText(7) = "TO SEE."
MissionText(8) = "ARMED WITH TRIAD"
MissionText(9) = "LASERS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 78
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .65
NextStep = 12
CASE 11
MissionText(0) = "WEAPON:"
MissionText(1) = "MISSILE TURRET"
MissionText(3) = "THESE TURRETS SPIT"
MissionText(4) = "OUT MISSILES AT"
MissionText(5) = "MASSIVE FIRING"
MissionText(6) = "RATE."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 80
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .25
CASE 12
MissionText(0) = "CRAFT:"
MissionText(1) = "DEEP SPACE TRANSPORT"
MissionText(3) = "THESE SHUTTLES MAY"
MissionText(4) = "CONTAIN USEFUL"
MissionText(5) = "STUFF. BLAST THEM"
MissionText(6) = "OPEN."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 79
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .45
CASE 13
MissionText(0) = "STRUCTURE:"
MissionText(1) = "SUPPLY DUMP"
MissionText(3) = "THESE ARE CRUCIAL"
MissionText(4) = "BUILDINGS IN"
MissionText(5) = "DEEP SPACE."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 81
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .175
NextStep = 12
CASE 14
MissionText(0) = "STRUCTURE:"
MissionText(1) = "DEEP SPACE COM"
MissionText(3) = "THESE RADARS ARE"
MissionText(4) = "USED TO COMMUNICATE"
MissionText(5) = "WITH THE CORPORATES"
MissionText(6) = "ON EARTH."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 83
        RotatingObject(0).YScreenAdd = 120
        RotatingObject(0).Scale = .16
NextStep = 12
CASE 15
MissionText(0) = "ARTIFACT:"
MissionText(1) = "CRYSTAL SHARD"
MissionText(3) = "THESE THINGS"
MissionText(4) = "SUMMON COSMIC"
MissionText(5) = "ENERGIES FOR"
MissionText(6) = "AN UNKNOWN"
MissionText(7) = "PURPOSE."
RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 85
        RotatingObject(0).YScreenAdd = 135
        RotatingObject(0).Scale = .16
NextStep = 12
CASE 16
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1

END SUB

SUB Briefing8 (RotatingObject() AS RotatingObjectType, MissionPosition, NextStep, ExitFlags)

        FOR index = 0 TO 9
        MissionText(index) = SPACE$(20)
        NEXT
        RotatingObject(0).Alive = -1
        RotatingObject(0).ObjectType = 0
        RotatingObject(0).YScreenAdd = 0
        RotatingObject(0).Scale = 0
SELECT CASE MissionPosition
CASE 1
MissionText(0) = "MISSION 8:"
MissionText(1) = " THE EVIL MATRIX"
MissionText(3) = "LOCATION:"
MissionText(4) = " QUAOAR ASTEROID"
NextStep = 6
CASE 2
MissionText(0) = "IT HAS SHOWN UP."
MissionText(2) = "WE'VE FOUND IT."
MissionText(4) = "THE IRRAH IS HERE."
NextStep = 8
CASE 3
MissionText(0) = "WE HAVE DONE SOME"
MissionText(1) = "EXCESSIVE SCANS"
MissionText(2) = "ABOUT THE IRRAH."
MissionText(3) = "IT SEEMS TO BE A"
MissionText(4) = "HUGE SUPERCOMPUTER,"
MissionText(5) = "LIKE AN ELECTRIC"
MissionText(6) = "ORGANISM."
MissionText(7) = "FORTUNATELY IT WAS"
MissionText(8) = "NOT DESIGNED FOR"
MissionText(9) = "OFFENSIVE PURPOSES."
NextStep = 13
CASE 4
MissionText(0) = "WE HAVE FOUND ONE"
MissionText(1) = "MAJOR WEAKNESS IN"
MissionText(2) = "THE IRRAH SYSTEM"
MissionText(3) = "- ITS RELAY HUB."
MissionText(5) = "IF YOU MANAGE TO"
MissionText(6) = "DESTROY IT, THE"
MissionText(7) = "DATA NETWORKS OF"
MissionText(8) = "THE IRRAH ARE"
MissionText(9) = "GOING TO COLLAPSE."
NextStep = 12
CASE 5
MissionText(0) = "DON'T FAIL."
MissionText(1) = "IF THE IRRAH IS GONE"
MissionText(2) = "ITS WORSHIPPERS WILL"
MissionText(3) = "FALL INTO CHAOS, AND"
MissionText(4) = "WE ARE ABLE TO"
MissionText(5) = "FINISH THEM."
MissionText(6) = "IF YOU FAIL, WE'LL"
MissionText(7) = "MEET YOU IN"
MissionText(8) = "AFTERLIFE."
NextStep = 11
CASE 6
MissionText(0) = "STILL, THE IRRAH"
MissionText(1) = "HAS A DEFENSIVE"
MissionText(2) = "SEQUENCE TO KEEP"
MissionText(3) = "OUT INTRUDERS."
MissionText(4) = "IT CAN BE A ONE"
MissionText(5) = "TOUGH COOKIE."
MissionText(7) = "GOOD LUCK."
NextStep = 10
CASE 7
MissionText(1) = "PREPARED TACTICAL"
MissionText(2) = "REPORT:"
NextStep = 2
CASE 8
MissionText(0) = "ENEMY:"
MissionText(1) = "COREGUARD FIGHTER"
MissionText(3) = "TWO OF THESE"
MissionText(4) = "DESTROYED OUR ENTIRE"
MissionText(5) = "RECONNAISANCE"
MissionText(6) = "SQUADRON."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 88
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 9
MissionText(0) = "ENEMY:"
MissionText(1) = "SENTINEL DROID"
MissionText(3) = "NO INFORMATION."
MissionText(4) = "EXTREME CAUTION"
MissionText(5) = "ADVISED."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 89
        RotatingObject(0).YScreenAdd = 90
        RotatingObject(0).Scale = .5
NextStep = 12
CASE 10
MissionText(0) = "WEAPON:"
MissionText(1) = "ANTIMATTER CANNON"
MissionText(3) = "THESE ARE USED TO"
MissionText(4) = "KEEP OUT INTRUDERS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 90
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .25
CASE 11
MissionText(0) = "WEAPON:"
MissionText(1) = "SURFACE TRACKER"
MissionText(3) = "THESE THINGS HAVE"
MissionText(4) = "POWERFUL LASERS."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 91
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .25
CASE 12
MissionText(0) = "STRUCTURE:"
MissionText(1) = "IRRAH RELAY TOWER"
MissionText(3) = "DESTROYING THESE"
MissionText(4) = "WILL PERMANENTLY"
MissionText(5) = "DAMAGE THE"
MissionText(6) = "IRRAHIAN INTERNAL"
MissionText(7) = "NETWORK."
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 92
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .175
NextStep = 12
CASE 13
MissionText(0) = "STRUCTURE:"
MissionText(1) = "IRRAH CPU HUB"
MissionText(3) = "THESE ARE THE"
MissionText(4) = "NERVECELLS OF"
MissionText(5) = "THE IRRAH"
        RotatingObject(0).Alive = TRUE
        RotatingObject(0).ObjectType = 93
        RotatingObject(0).YScreenAdd = 125
        RotatingObject(0).Scale = .16
NextStep = 12
CASE 14
MissionText(0) = "END OF BRIEFING..."
ExitFlags = 1
NextStep = 2500
END SELECT
MissionPosition = MissionPosition + 1
END SUB

SUB CreateShadow (PalString$)
FOR index = 0 TO 63
        PaletteIndex = ((128 + index) * 3) + 1
        RedValue = ASC(MID$(PalString$, PaletteIndex, 1))
        GreenValue = ASC(MID$(PalString$, PaletteIndex + 1, 1))
        BlueValue = ASC(MID$(PalString$, PaletteIndex + 2, 1))
        RedValue = RedValue / 3
        GreenValue = GreenValue / 3
        BlueValue = BlueValue / 3
        PaletteIndex = ((192 + index) * 3) + 1
        MID$(PalString$, PaletteIndex, 1) = CHR$(RedValue)
        MID$(PalString$, PaletteIndex + 1, 1) = CHR$(GreenValue)
        MID$(PalString$, PaletteIndex + 2, 1) = CHR$(BlueValue)
NEXT
END SUB

SUB Disk2XMS (File$, Handle%)
FileHandle = FREEFILE
OPEN File$ FOR BINARY AS FileHandle
  Bytes& = LOF(FileHandle)
  Tmp = Bytes& / 1024
  Times% = FIX(Tmp) - 1
  restof% = Bytes& MOD 1024
  Tmp$ = SPACE$(1024)
  DIM tempvar(512)

FOR i& = 0 TO Times%
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), 1024
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, 1024
NEXT i&

IF NOT restof% = 0 THEN
  Tmp$ = SPACE$(restof%)
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), restof%
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, restof%
END IF
CLOSE FileHandle
END SUB

SUB DisplayBriefingText (UPPERLAYER&(), LOWERLAYER&())
yPos = 208
FOR index = 0 TO 9
yTPos = yPos
ShadowedText UPPERLAYER&(), LOWERLAYER&(), 14, yTPos, MissionText(index)
yPos = yPos + 15
NEXT
END SUB

SUB DrawWindow (UPPERLAYER&(), LOWERLAYER&(), x1, y1, x2, y2)
        ShadeRectangle x1, y1, x2, y2, VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))
IF y1 < 200 THEN
        CSLine VARSEG(UPPERLAYER&(0)), x1, y1, x2, y1, 7
        CSLine VARSEG(UPPERLAYER&(0)), x1, y1, x1, y2, 6
        CSLine VARSEG(UPPERLAYER&(0)), x1, y2, x2, y2, 5
        CSLine VARSEG(UPPERLAYER&(0)), x2, y1, x2, y2, 4
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1, 12
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 1, y1, 11
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1 + 1, 11
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 2, y1, 10
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1 + 2, 10
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 3, y1, 9
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1 + 3, 9
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 4, y1, 8
END IF
IF y2 > 199 THEN
        y1 = y1 - 200
        y2 = y2 - 200
        CSLine VARSEG(LOWERLAYER&(0)), x1, y1, x2, y1, 7
        CSLine VARSEG(LOWERLAYER&(0)), x1, y1, x1, y2, 6
        CSLine VARSEG(LOWERLAYER&(0)), x1, y2, x2, y2, 5
        CSLine VARSEG(LOWERLAYER&(0)), x2, y1, x2, y2, 4
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1, 12
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 1, y1, 11
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1 + 1, 11
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 2, y1, 10
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1 + 2, 10
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 3, y1, 9
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1 + 3, 9
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 4, y1, 8
END IF

END SUB

SUB FadeInStep (PalString$, FadeInFlag, FadeStep)
FOR colorIndex = 0 TO 255
        CSGetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
        TargetRed = ASC(MID$(PalString$, (colorIndex * 3) + 1, 1))
        TargetGreen = ASC(MID$(PalString$, (colorIndex * 3) + 2, 1))
        TargetBlue = ASC(MID$(PalString$, (colorIndex * 3) + 3, 1))
        CurrentRed = CurrentRed + 4
        CurrentGreen = CurrentGreen + 4
        CurrentBlue = CurrentBlue + 4
        IF CurrentRed > TargetRed THEN CurrentRed = TargetRed
        IF CurrentGreen > TargetGreen THEN CurrentGreen = TargetGreen
        IF CurrentBlue > TargetBlue THEN CurrentBlue = TargetBlue
        CSSetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
NEXT
        FadeStep = FadeStep + 1
        IF FadeStep >= 16 THEN FadeStep = 0: FadeInFlag = FALSE
END SUB

SUB FadeOutStep (FadeOutFlag, FadeStep)
FOR colorIndex = 0 TO 255
        CSGetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
        CurrentRed = CurrentRed - 4
        CurrentGreen = CurrentGreen - 4
        CurrentBlue = CurrentBlue - 4
        IF CurrentRed < 0 THEN CurrentRed = 0
        IF CurrentGreen < 0 THEN CurrentGreen = 0
        IF CurrentBlue < 0 THEN CurrentBlue = 0
        CSSetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
NEXT
        FadeStep = FadeStep + 1
        IF FadeStep >= 16 THEN FadeStep = 0: FadeOutFlag = FALSE
END SUB

SUB GeneratePrimes (ObjectPrime() AS DrawPrimitive, XMSHandle)
REDIM WordFromXMS(0)
REDIM DWordFromXMS&(0)
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandle, 0, 2
        XMSPos& = 2
        SP& = 0
        TotalIndexes = WordFromXMS(0)
        TotalMeshes = TotalIndexes
        FOR index = 0 TO TotalIndexes
                ObjectPrime(index).StartPoint = SP&
                CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandle, XMSPos&, 2
                ObjectPrime(index).BytesLong = WordFromXMS(0)
                XMSPos& = XMSPos& + 2
                SP& = SP& + WordFromXMS(0)
        NEXT
       
        FOR index = 0 TO TotalIndexes
        ObjectPrime(index).StartPoint = ObjectPrime(index).StartPoint + XMSPos&
        NEXT
END SUB

SUB GenerateTexTable (TextureTable&())
TexPointer& = 0
TextureTable&(0) = TexPointer&
TexPointer& = TexPointer& + 16400
TextureTable&(1) = TexPointer&
TextureTable&(2) = TexPointer&
TextureTable&(3) = TexPointer&
TextureTable&(4) = TexPointer&
TextureTable&(5) = TexPointer&

FOR index = 6 TO 94
TexPointer& = TexPointer& + 16400
TextureTable&(index) = TexPointer&
NEXT
END SUB

SUB InitBlendMaps (TransBlendMap())
FOR index = 0 TO 255
       
        SELECT CASE index
        CASE 0 TO 15
        cv = index - 6
        IF cv < 0 THEN cv = 0
        CASE 16 TO 31
        cv = index - 6
        IF cv < 16 THEN cv = 16
        CASE 32 TO 47
        cv = index - 6
        IF cv < 32 THEN cv = 32
        CASE 48 TO 63
        cv = index - 6
        IF cv < 48 THEN cv = 48
        cv = index - 6
        IF cv < 0 THEN cv = 0
        CASE 64 TO 71
        cv = index - 3
        IF cv < 64 THEN cv = 64
        CASE 72 TO 79
        cv = index - 3
        IF cv < 72 THEN cv = 72
        CASE 80 TO 95
        cv = index - 6
        IF cv < 80 THEN cv = 80
        CASE 96 TO 103
        cv = index - 3
        IF cv < 96 THEN cv = 96
        CASE 104 TO 111
        cv = index - 3
        IF cv < 104 THEN cv = 104
        CASE 112 TO 127
        cv = index - 6
        IF cv < 112 THEN cv = 112
        CASE IS > 191
        cv = index - 24
        IF cv < 192 THEN cv = 192
        END SELECT
CSPoke VARSEG(TransBlendMap(0)), index, cv
NEXT
END SUB

SUB MellowColors (PalString$)
FOR index = 0 TO 255
Red = ASC(MID$(PalString$, (index * 3) + 1, 1))
Green = ASC(MID$(PalString$, (index * 3) + 2, 1))
Blue = ASC(MID$(PalString$, (index * 3) + 3, 1))
GrayValue = (Red + Green + Blue) / 3
TotalRed = (Red * 1.9 + GrayValue * 1.1) / 3
TotalGreen = (Green * 1.9 + GrayValue * 1.1) / 3
TotalBlue = (Blue * 1.9 + GrayValue * 1.1) / 3
MID$(PalString$, (index * 3) + 1, 1) = CHR$(TotalRed)
MID$(PalString$, (index * 3) + 2, 1) = CHR$(TotalGreen)
MID$(PalString$, (index * 3) + 3, 1) = CHR$(TotalBlue)
NEXT
END SUB

SUB Noise (LOWERLAYER&())
        FOR index = 0 TO 1999
        x = 201 + RND * 108
        y = 1 + RND * 169
        c = RND * 15
        CSPset VARSEG(LOWERLAYER&(0)), x, y, c
        NEXT
END SUB

SUB Render3DObject (ScaleValue!, XScreenAdd, YScreenAdd, XrotAngle, YrotAngle, zRotAngle, ObjectPolyCount, ObjectMesh() AS ObjectPolygon, VisibleObjectMesh() AS VisiblePolygon, TextureMap&(), BlenderMap(), Sine!(), Cosine!(), UPPERLAYER&(),  _
LOWERLAYER&())

ZEye = -750

REDIM TMatrix!(3, 3), Matrix!(3, 3)
REDIM ObjectFaceVector(0) AS Vector3DType
REDIM ObjectPolyFaces(2) AS Vector3DType
REDIM ObjectPolyScreenCoords(2) AS Vector2DType
       
        CSIdentityMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0))
        CSInitScaleMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), ScaleValue!, ScaleValue!, ScaleValue!
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        CSInitRotXMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Cosine!(XrotAngle), Sine!(XrotAngle)
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        CSInitRotYMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Cosine!(YrotAngle), Sine!(YrotAngle)
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        Visibles = 0
                FOR index = 0 TO ObjectPolyCount - 1
                ObjectFaceVector(0).x = ObjectMesh(index).x1
                ObjectFaceVector(0).y = ObjectMesh(index).y1 * 2
                ObjectFaceVector(0).Z = ObjectMesh(index).Z1
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).x), VARPTR(ObjectFaceVector(0).x), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(0).x), VARPTR(ObjectPolyFaces(0).x)
                ObjectFaceVector(0).x = ObjectMesh(index).x2
                ObjectFaceVector(0).y = ObjectMesh(index).y2 * 2
                ObjectFaceVector(0).Z = ObjectMesh(index).Z2
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).x), VARPTR(ObjectFaceVector(0).x), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(1).x), VARPTR(ObjectPolyFaces(1).x)
                ObjectFaceVector(0).x = ObjectMesh(index).X3
                ObjectFaceVector(0).y = ObjectMesh(index).Y3 * 2
                ObjectFaceVector(0).Z = ObjectMesh(index).Z3
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).x), VARPTR(ObjectFaceVector(0).x), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(2).x), VARPTR(ObjectPolyFaces(2).x)
                PPProjectVector VARSEG(ObjectPolyFaces(0).x), VARPTR(ObjectPolyFaces(0).x), VARSEG(ObjectPolyScreenCoords(0).x), VARPTR(ObjectPolyScreenCoords(0).x), -750
                PPProjectVector VARSEG(ObjectPolyFaces(1).x), VARPTR(ObjectPolyFaces(1).x), VARSEG(ObjectPolyScreenCoords(1).x), VARPTR(ObjectPolyScreenCoords(1).x), -750
                PPProjectVector VARSEG(ObjectPolyFaces(2).x), VARPTR(ObjectPolyFaces(2).x), VARSEG(ObjectPolyScreenCoords(2).x), VARPTR(ObjectPolyScreenCoords(2).x), -750
                Visibility = CSPolyFacing(VARSEG(ObjectPolyScreenCoords(0).x), VARPTR(ObjectPolyScreenCoords(0).x), VARSEG(ObjectPolyScreenCoords(1).x), VARPTR(ObjectPolyScreenCoords(1).x), VARSEG(ObjectPolyScreenCoords(2).x), VARPTR( _
ObjectPolyScreenCoords(2).x))
                IF ObjectMesh(index).FlippedNormals THEN Visibility = -Visibility
                IF ObjectMesh(index).TwoSided = 1 THEN Visibility = 1
                IF Visibility > 0 THEN
                VisibleObjectMesh(Visibles).x1 = ObjectPolyScreenCoords(0).x
                VisibleObjectMesh(Visibles).y1 = ObjectPolyScreenCoords(0).y
                VisibleObjectMesh(Visibles).x2 = ObjectPolyScreenCoords(1).x
                VisibleObjectMesh(Visibles).y2 = ObjectPolyScreenCoords(1).y
                VisibleObjectMesh(Visibles).X3 = ObjectPolyScreenCoords(2).x
                VisibleObjectMesh(Visibles).Y3 = ObjectPolyScreenCoords(2).y
                VisibleObjectMesh(Visibles).Shade = ObjectMesh(index).Shade
                VisibleObjectMesh(Visibles).AvgZ = CINT((ObjectPolyFaces(0).Z + ObjectPolyFaces(1).Z + ObjectPolyFaces(2).Z) / 3)
                Visibles = Visibles + 1
                END IF
               
                NEXT

        SortFaces VARSEG(VisibleObjectMesh(0).x1), Visibles
        FOR index = 0 TO Visibles - 1
                        trip1x = VisibleObjectMesh(index).x1 + XScreenAdd
                        trip2x = VisibleObjectMesh(index).x2 + XScreenAdd
                        trip3x = VisibleObjectMesh(index).X3 + XScreenAdd
                        trip1y = VisibleObjectMesh(index).y1 + YScreenAdd
                        trip2y = VisibleObjectMesh(index).y2 + YScreenAdd
                        trip3y = VisibleObjectMesh(index).Y3 + YScreenAdd
                IF VisibleObjectMesh(index).Shade <> 0 THEN
                        IF VisibleObjectMesh(index).Shade > 15 THEN
                                U1% = 0: V1% = 0
                                U2% = 63: V2% = 0
                                U3% = 63: V3% = 63
                                TexturePointer = VisibleObjectMesh(index).Shade - 16
                                ELSE
                                U1% = 0: V1% = 0
                                U2% = 63: V2% = 63
                                U3% = 0: V3% = 63
                                TexturePointer = VisibleObjectMesh(index).Shade - 1
                        END IF
                                                             
                        IF trip1y < 200 AND trip2y < 200 AND trip3y < 200 THEN
                        CSTriT VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        ELSEIF trip1y > 200 AND trip2y > 200 AND trip3y > 200 THEN
                        CSTriT VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        ELSE
                        CSTriT VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        CSTriT VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        END IF
                ELSE
                        IF trip1y < 200 AND trip2y < 200 AND trip3y < 200 THEN
                        PPBlendTri VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, VARSEG(BlenderMap(0))
                        ELSEIF trip1y > 200 AND trip2y > 200 AND trip3y > 200 THEN
                        PPBlendTri VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, VARSEG(BlenderMap(0))
                        ELSE
                        PPBlendTri VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, VARSEG(BlenderMap(0))
                        PPBlendTri VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, VARSEG(BlenderMap(0))
                        END IF
              
                END IF
                NEXT
                
END SUB

SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x, y, TextString$)
        CSPrint VARSEG(UPPERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y, TextString$, 43
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 1, TextString$, 43
        y = y - 200
        CSPrint VARSEG(LOWERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y, TextString$, 43
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 1, TextString$, 43
END SUB

SUB ShowOffscreen (VideoPage, UPPERLAYER&(), LOWERLAYER&())
IF VideoPage = 1 THEN
mxBufferCopy Page2in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page3in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 32000
END IF
IF VideoPage = 2 THEN
mxBufferCopy Page0in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page1in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 0
END IF
END SUB

SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage)
ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
VideoPage = VideoPage + 1
IF VideoPage > 2 THEN VideoPage = 1
END SUB

