DECLARE SUB SoundInterFace (Command%, Value1%, Value2%, Value3%, Value4%)
DECLARE SUB FullFade ()
DECLARE SUB DrawParallax (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, IntroImage() AS ANY, SmallShipType() AS ANY, Layers() AS ANY)
DECLARE SUB DisplayText (UPPERLAYER&(), LOWERLAYER&(), TextNumber%)
DECLARE SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x%, y%, TextString$)
DECLARE SUB FadeInStep (PalString$, FadeInFlag%, FadeStep%)
DECLARE SUB FadeOutStep (FadeOutFlag%, FadeStep%)
DECLARE SUB BlackPalette ()
DECLARE SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage%)
DECLARE SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), BackGroundHandle%, XMSCache&())
DECLARE SUB AssimilateBackGround (XMSHandle%, BackGroundImageHandle%, XMSCache&(), IntroImage() AS ANY, ImageNumber%)
DECLARE SUB MellowColors (PalString$)
DECLARE SUB AssimilatePalette (PaletteNumber%, FirstIndex%, ColorsToAssimilate%, PalString$)
DECLARE SUB GeneratePrime (XMSHandle%, IntroImage() AS ANY)
DECLARE SUB Disk2XMS (File$, Handle%)
DECLARE SUB ShowOffscreen (VideoPage%, UPPERLAYER&(), LOWERLAYER&())

DECLARE SUB Darken CDECL (BYVAL hiview%, BYVAL loview%)

DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'slivedcx.bi'
'$INCLUDE: 'modexlib.bi'

CONST TRUE = 1
CONST FALSE = 0

TYPE IntroImageBitMap
        StartPoint AS LONG
        BytesLong AS LONG
END TYPE

TYPE AnimatedShipType
        x AS INTEGER
        y AS INTEGER
        DrawClass AS INTEGER
        Velocity AS INTEGER
END TYPE


TYPE ParallaxLayerType
        x AS INTEGER
        DrawClass AS INTEGER
        Velocity AS INTEGER
END TYPE

REDIM XMSCache&(16384)
REDIM UPPERLAYER&(16000)
REDIM LOWERLAYER&(16000)
REDIM IntroImage(24) AS IntroImageBitMap
REDIM FontTexture(33)
REDIM SmallShipType(4) AS AnimatedShipType
REDIM Layers(1) AS ParallaxLayerType
        FileHandle = FREEFILE
        OPEN "prefs.db" FOR BINARY AS FileHandle
        SEEK FileHandle, 1
        GET FileHandle, , DS4QBActive
        GET FileHandle, , AntiAlias
        GET FileHandle, , SkyTexture
        GET FileHandle, , ShadowsOn
        GET FileHandle, , MenuFlip
        GET FileHandle, , SFXVol
        GET FileHandle, , MusicVol
        GET FileHandle, , EAXAudio
        CLOSE FileHandle
SoundInterFace 0, DS4QBActive, 0, 0, 0
SoundInterFace 4, SFXVol, MusicVol, 0, 0
IF EAXAudio = TRUE THEN EaxCode = 10 ELSE EaxCode = 0
IF MusicVol > 0 THEN MusicOn = TRUE ELSE MusicOn = FALSE
SoundInterFace 6, EaxCode, 0, 0, 0
        Layers(0).x = 0
        Layers(1).x = 1
        Layers(0).Velocity = -1
        Layers(1).Velocity = -2
        SmallShipType(4).x = -280
        SmallShipType(4).y = 170
        SmallShipType(4).Velocity = 4
        SmallShipType(4).DrawClass = 0
        SmallShipType(1).x = -110
        SmallShipType(1).y = 150
        SmallShipType(1).Velocity = 2
        SmallShipType(1).DrawClass = 1
        SmallShipType(2).x = -80
        SmallShipType(2).y = 190
        SmallShipType(2).Velocity = 2
        SmallShipType(2).DrawClass = 1
        SmallShipType(3).x = -140
        SmallShipType(3).y = 210
        SmallShipType(3).Velocity = 2
        SmallShipType(3).DrawClass = 1
        SmallShipType(0).x = -180
        SmallShipType(0).y = 230
        SmallShipType(0).Velocity = 2
        SmallShipType(0).DrawClass = 1

ParallaxScroll = FALSE
PlayerPortrait = FALSE
DarkFlag = FALSE
TextOn = FALSE
TextNumber = 0
IsMMX = CSDetectMMX
IsXMS = CSDetectXMS
IF IsXMS = 1 THEN
        XMSHandle = CSAllocateXMS(1100)
        BackGroundImageHandle = CSAllocateXMS(130)
ELSE
        END
END IF

Disk2XMS "intro.dx", XMSHandle
GeneratePrime XMSHandle, IntroImage()

Pal$ = SPACE$(768)
InitialPal$ = SPACE$(768)
Font$ = SPACE$(2048)
OPEN "fontface.db" FOR BINARY AS #1
SEEK #1, 1
GET #1, , Font$
CLOSE #1
CSSetFont Font$
Rfl = CSLoadPal("palette.dat", Pal$)
InitialPal$ = Pal$
AssimilatePalette 3, 0, 256, Pal$
MellowColors Pal$
CSInitVGA
mxMode320x400
BlackPalette
mxFill Page0in320x400&, Full320x400, 0
mxFill Page1in320x400&, Full320x400, 0
CSInstallTimer
CSSetTimer 0, 40
CSInstallKeyBoard
        FadeOutFlag = FALSE
        FadeStep = 0: FadeInFlag = TRUE: VideoPage = 2
        NextStep = 4 * 25: ImageNum = 0
        Timer1Timer = NextStep
        AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), 0
        IF MusicOn = TRUE THEN SoundInterFace 3, 10, 1, 0, 0
DO
        GOSUB TimerChunk:
        IF FadeInFlag = TRUE THEN FadeInStep Pal$, FadeInFlag, FadeStep
        IF FadeOutFlag = TRUE THEN FadeOutStep FadeOutFlag, FadeStep
        CSWaitTimer 0
        IF CSKey(KEYESC) THEN GOTO Quit
LOOP
Quit:
IF MusicOn = TRUE THEN SoundInterFace 5, 1, 100, 0, 0
FullFade
CSDeallocateXMS XMSHandle
CSDeallocateXMS BackGroundImageHandle
CSRemoveKeyBoard
CSRemoveTimer
RUN "scapez02.xbn"

TimerChunk:
Timer1Timer = Timer1Timer - 1
        IF Timer1Timer = 0 THEN
                GOSUB AddNewScreen:
        END IF
BlitBackGround UPPERLAYER&(), LOWERLAYER&(), BackGroundImageHandle, XMSCache&()
        IF PlayerPortrait = TRUE THEN
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, IntroImage(11).StartPoint, IntroImage(11).BytesLong
        CSSpriteN VARSEG(UPPERLAYER&(0)), 128, 64, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        CSSpriteN VARSEG(LOWERLAYER&(0)), 128, -136, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        END IF

IF DarkFlag = TRUE THEN Darken VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))
IF ParallaxScroll = TRUE THEN DrawParallax UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, IntroImage(), SmallShipType(), Layers()
IF TextOn = TRUE THEN DisplayText UPPERLAYER&(), LOWERLAYER&(), TextNumber
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
RETURN

AddNewScreen:
ImageNum = ImageNum + 1

        SELECT CASE ImageNum
        CASE 1
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
        CASE 2
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), 1
                AssimilatePalette 4, 0, 256, Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 243
                FadeStep = 0
        CASE 3
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
        CASE 4
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), 2
                Pal$ = InitialPal$
                AssimilatePalette 5, 128, 128, Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 25
                DarkFlag = TRUE
        CASE 5
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 100
        CASE 6
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 140
        CASE 7
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 8
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 9
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 225
        CASE 10
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
                TextOn = FALSE
        CASE 11
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), 6
                Pal$ = InitialPal$
                AssimilatePalette 9, 128, 128, Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 25
                DarkFlag = TRUE
        CASE 12
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 140
        CASE 13
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 140
        CASE 14
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
                TextOn = FALSE
        CASE 15
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), 4
                Pal$ = InitialPal$
                AssimilatePalette 7, 128, 128, Pal$
                MellowColors Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 25
                DarkFlag = TRUE
        CASE 16
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 140
        CASE 17
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 18
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 19
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 130
        CASE 20
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
                TextOn = FALSE
        CASE 21
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), 3
                Pal$ = InitialPal$
                AssimilatePalette 6, 128, 128, Pal$
                MellowColors Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 25
                DarkFlag = TRUE
        CASE 22
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 23
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
                TextOn = FALSE
        CASE 24
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), -1
                Pal$ = InitialPal$
                AssimilatePalette 10, 128, 128, Pal$
                MellowColors Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 250
                DarkFlag = FALSE
                ParallaxScroll = TRUE
        CASE 25
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
                TextOn = FALSE
        CASE 26
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), -1
                Pal$ = InitialPal$
                AssimilatePalette 11, 128, 128, Pal$
                BlackPalette
                FadeInFlag = TRUE
                PlayerPortrait = TRUE
                NextStep = 25
                DarkFlag = TRUE
                ParallaxScroll = FALSE
        CASE 27
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 160
        CASE 28
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 160
        CASE 29
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
                TextOn = FALSE
        CASE 30
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage(), 5
                Pal$ = InitialPal$
                AssimilatePalette 8, 128, 128, Pal$
                MellowColors Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 25
                DarkFlag = TRUE
                PlayerPortrait = FALSE
        CASE 31
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 32
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 160
        CASE 33
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 34
                GOTO Quit
        END SELECT
Timer1Timer = NextStep
RETURN


REM $STATIC
SUB AssimilateBackGround (XMSHandle, BackGroundImageHandle, XMSCache&(), IntroImage() AS IntroImageBitMap, ImageNumber)
IF ImageNumber <> -1 THEN
CSMoveXMS XMSHandle, IntroImage(ImageNumber).StartPoint, BackGroundImageHandle, 0, 128000
ELSE
CSClearMMX VARSEG(XMSCache&(0)), 0
CSMoveToXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), BackGroundImageHandle, 0, 64000
CSMoveToXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), BackGroundImageHandle, 64000, 64000
END IF
END SUB

SUB AssimilatePalette (PaletteNumber, FirstIndex, ColorsToAssimilate, PalString$)
FileHandle = FREEFILE
OPEN "coltabs.db" FOR BINARY AS FileHandle
SEEK FileHandle, ((PaletteNumber - 1) * 1536) + 1
PaletteIndex = FirstIndex * 3 + 1
FOR index = 0 TO ColorsToAssimilate - 1
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 1, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 2, 1) = CHR$(ColorComponent)
        PaletteIndex = PaletteIndex + 3
NEXT
CLOSE FileHandle
END SUB

SUB BlackPalette
FOR index = 0 TO 255
        CSSetCol index, 0, 0, 0
NEXT
END SUB

SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), BackGroundHandle, XMSCache&())
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), BackGroundHandle, 0, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(UPPERLAYER&(0))
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), BackGroundHandle, 64000, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(LOWERLAYER&(0))
END SUB

SUB Disk2XMS (File$, Handle%)
FileHandle = FREEFILE
OPEN File$ FOR BINARY AS FileHandle
  Bytes& = LOF(FileHandle)
  Tmp = Bytes& / 1024
  Times% = FIX(Tmp) - 1
  restof% = Bytes& MOD 1024
  Tmp$ = SPACE$(1024)
  DIM tempvar(512)

FOR i& = 0 TO Times%
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), 1024
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, 1024
NEXT i&

IF NOT restof% = 0 THEN
  Tmp$ = SPACE$(restof%)
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), restof%
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, restof%
END IF
CLOSE FileHandle
END SUB

SUB DisplayText (UPPERLAYER&(), LOWERLAYER&(), TextNumber)
        SELECT CASE TextNumber
        CASE 1
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 60, "2503 a.d."
        CASE 2
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 50, "climate is ruined. the world is"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "entirely covered under the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "dense smog..."
        CASE 3
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 50, "governments were defunct. the people"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "of the world were stuffed in the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "giant metropoles."
        CASE 4
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 60, "the world is under domination of"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "facist corporate armies..."
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 110, "...known as the corporates"
        CASE 5
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 50, "as an attempt to peace,"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "'the initiative' is a"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "global military concordance,"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 110, "which has been formed to police"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 130, "the corporates..."
        CASE 6
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 60, "suddenly the corporates launched"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "a large-scale offense against"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "the initiative."
        CASE 7
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "anti-matter warheads were targeted"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "to the world's largest"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 110, "cities..."
        CASE 8
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "when the attack had been noticed,"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "it was already too late..."
        CASE 9
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "during the dark hour, seven"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "cities had been destroyed."
        CASE 10
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "paris, london, moscow, new york,"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "los angeles, rio de janeiro"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 110, "and shanghai had been reduced"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 130, "to ashes..."
        CASE 11
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "2.3 billion people perished."
        CASE 12
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "the initiative launched their"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 110, "counter-attack..."
        CASE 13
                ShadowedText LOWERLAYER&(), LOWERLAYER&(), CENTERED, 90, "you are shara o'neal, one of the"
                ShadowedText LOWERLAYER&(), LOWERLAYER&(), CENTERED, 110, "initiative's best fighter pilots."
        CASE 14
                ShadowedText LOWERLAYER&(), LOWERLAYER&(), CENTERED, 90, "you fly the state-of-the-art"
                ShadowedText LOWERLAYER&(), LOWERLAYER&(), CENTERED, 110, "fighter, called 'the avatar'."
        CASE 15
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "capable of carrying devastating"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "weaponry, the avatar is the most"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "powerful fighter in the fleet"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "of the initiative."
        CASE 16
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "even with the avatar in your hands,"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "your chances to survive are minimal."
        CASE 17
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 70, "caged in your fighter, you decide"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 90, "to take an extreme risk."
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 110, "to fight the corporates..."
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "...alone"
        END SELECT
END SUB

SUB DrawParallax (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, IntroImage() AS IntroImageBitMap, SmallShipType() AS AnimatedShipType, Layers() AS ParallaxLayerType)
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(1)), XMSHandle, IntroImage(7).StartPoint, 64000
CSPoke16 VARSEG(XMSCache&(0)), 0, 2560
CSPoke16 VARSEG(XMSCache&(0)), 2, 200
CSSpriteN VARSEG(UPPERLAYER&(0)), Layers(0).x, 100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
IF (Layers(0).x + 320) < 320 THEN CSSpriteN VARSEG(UPPERLAYER&(0)), Layers(0).x + 320, 100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSSpriteN VARSEG(LOWERLAYER&(0)), Layers(0).x, -100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
IF (Layers(0).x + 320) < 320 THEN CSSpriteN VARSEG(LOWERLAYER&(0)), Layers(0).x + 320, -100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))

CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(1)), XMSHandle, IntroImage(8).StartPoint, 64000
CSPoke16 VARSEG(XMSCache&(0)), 0, 2560
CSPoke16 VARSEG(XMSCache&(0)), 2, 200
CSSprite VARSEG(UPPERLAYER&(0)), Layers(1).x, 100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
IF (Layers(1).x + 320) < 320 THEN CSSprite VARSEG(UPPERLAYER&(0)), Layers(1).x + 320, 100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSSprite VARSEG(LOWERLAYER&(0)), Layers(1).x, -100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
IF (Layers(1).x + 320) < 320 THEN CSSprite VARSEG(LOWERLAYER&(0)), Layers(1).x + 320, -100, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))

Darken VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))

FOR index = 0 TO 4
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(1)), XMSHandle, IntroImage(9 + SmallShipType(index).DrawClass).StartPoint, IntroImage(9 + SmallShipType(index).DrawClass).BytesLong
        CSSprite VARSEG(UPPERLAYER&(0)), SmallShipType(index).x, SmallShipType(index).y, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        CSSprite VARSEG(LOWERLAYER&(0)), SmallShipType(index).x, SmallShipType(index).y - 200, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
NEXT

FOR index = 0 TO 1
        Layers(index).x = Layers(index).x + Layers(index).Velocity
        IF Layers(index).x < -319 THEN Layers(index).x = Layers(index).x + 320
NEXT
FOR index = 0 TO 4
        SmallShipType(index).x = SmallShipType(index).x + SmallShipType(index).Velocity
NEXT
END SUB

SUB FadeInStep (PalString$, FadeInFlag, FadeStep)

FOR colorIndex = 0 TO 255
        CSGetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
        TargetRed = ASC(MID$(PalString$, (colorIndex * 3) + 1, 1))
        TargetGreen = ASC(MID$(PalString$, (colorIndex * 3) + 2, 1))
        TargetBlue = ASC(MID$(PalString$, (colorIndex * 3) + 3, 1))
        CurrentRed = CurrentRed + 4
        CurrentGreen = CurrentGreen + 4
        CurrentBlue = CurrentBlue + 4
        IF CurrentRed > TargetRed THEN CurrentRed = TargetRed
        IF CurrentGreen > TargetGreen THEN CurrentGreen = TargetGreen
        IF CurrentBlue > TargetBlue THEN CurrentBlue = TargetBlue
        CSSetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
NEXT
        FadeStep = FadeStep + 1
        IF FadeStep >= 16 THEN FadeStep = 0: FadeInFlag = FALSE
END SUB

SUB FadeOutStep (FadeOutFlag, FadeStep)

FOR colorIndex = 0 TO 255
        CSGetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
        CurrentRed = CurrentRed - 4
        CurrentGreen = CurrentGreen - 4
        CurrentBlue = CurrentBlue - 4
        IF CurrentRed < 0 THEN CurrentRed = 0
        IF CurrentGreen < 0 THEN CurrentGreen = 0
        IF CurrentBlue < 0 THEN CurrentBlue = 0
        CSSetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
NEXT
        FadeStep = FadeStep + 1
        IF FadeStep >= 16 THEN FadeStep = 0: FadeOutFlag = FALSE
END SUB

SUB FullFade
        FOR index = 0 TO 63
        CSFadeToStep 0, 255, 0, 0, 0
        IF index MOD 4 = 0 THEN CSWaitTimer 0
        NEXT
END SUB

SUB GeneratePrime (XMSHandle, IntroImage() AS IntroImageBitMap)
REDIM WordFromXMS(0)
REDIM DWordFromXMS&(0)
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandle, 0, 2
        XMSPos& = 2
        SP& = 0
        TotalIndexes = WordFromXMS(0)
        FOR index = 0 TO TotalIndexes
        IntroImage(index).StartPoint = SP&
        CSMoveFromXMS VARSEG(DWordFromXMS&(0)), VARPTR(DWordFromXMS&(0)), XMSHandle, XMSPos&, 4
        IntroImage(index).BytesLong = DWordFromXMS&(0)
        XMSPos& = XMSPos& + 4
        SP& = SP& + DWordFromXMS&(0)
        NEXT
        FOR index = 0 TO TotalIndexes
        IntroImage(index).StartPoint = IntroImage(index).StartPoint + XMSPos&
        NEXT
END SUB

SUB MellowColors (PalString$)
FOR index = 0 TO 255
Red = ASC(MID$(PalString$, (index * 3) + 1, 1))
Green = ASC(MID$(PalString$, (index * 3) + 2, 1))
Blue = ASC(MID$(PalString$, (index * 3) + 3, 1))
GrayValue = (Red + Green + Blue) / 3
TotalRed = (Red * 1.9 + GrayValue * 1.1) / 3
TotalGreen = (Green * 1.9 + GrayValue * 1.1) / 3
TotalBlue = (Blue * 1.9 + GrayValue * 1.1) / 3
MID$(PalString$, (index * 3) + 1, 1) = CHR$(TotalRed)
MID$(PalString$, (index * 3) + 2, 1) = CHR$(TotalGreen)
MID$(PalString$, (index * 3) + 3, 1) = CHR$(TotalBlue)
NEXT
END SUB

SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x, y, TextString$)
        CSPrint VARSEG(UPPERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y, TextString$, 15
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 1, TextString$, 15
        y = y - 200
        CSPrint VARSEG(LOWERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y, TextString$, 15
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 1, TextString$, 15
END SUB

SUB ShowOffscreen (VideoPage, UPPERLAYER&(), LOWERLAYER&())
IF VideoPage = 1 THEN
mxBufferCopy Page2in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page3in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 32000
END IF
IF VideoPage = 2 THEN
mxBufferCopy Page0in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page1in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 0
END IF
END SUB

SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage)
ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
VideoPage = VideoPage + 1
IF VideoPage > 2 THEN VideoPage = 1
END SUB

