SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )

# Copy the source tree
if [[ ! -d MementoDamage ]]; then
  cp -r ${SCRIPT_DIR}/MementoDamage .
fi

# Install node modules from cache
cd MementoDamage
npm install
cd ..

# Link in the input WARC into the source tree
if [[ ! -e MementoDamage/input.warc ]]; then
  ln -s $PWD/../input/*.warc MementoDamage/input.warc
fi

# Get the URL from the metadata of the object metadata
URL=`cat ${PWD}/../input/object.json | python -m json.tool | grep '"url":' | tail -n1 | grep -ohe '"[^"]\+"$' | sed 's;";;g'`

# Run crawler
echo PYTHONPATH=${PWD}/MementoDamage/src python ${PWD}/MementoDamage/src/cli/__init__.py "${URL}" -w http://localhost:8000/input.warc -c cache -i -d
PYTHONPATH=${PWD}/MementoDamage/src python ${PWD}/MementoDamage/src/cli/__init__.py "${URL}" -W ${PWD}/MementoDamage -w input.warc -c cache -i -d

# Copy output
mkdir -p $PWD/../output
mkdir -p $PWD/../output/screenshots
cp ${PWD}/../input/*.warc ${PWD}/../output/.
cp ${PWD}/../input/*.json ${PWD}/../output/.
cp cache/*input.warc*/result.json ${PWD}/../output/.
cp cache/*input.warc*/screenshots/* ${PWD}/../output/screenshots/.

# Add screenshots to original input object
echo
python ${SCRIPT_DIR}/augment.py
