import os
from urllib.parse import urlparse

from flask import Blueprint, request, render_template, redirect


home_bp = Blueprint('home_bp', __name__, url_prefix='',
          template_folder='src/web/pages/home/views',
          static_folder='static')

@home_bp.route('/', methods=['GET'])
@home_bp.route('/memento/', methods=['GET'])
def home_index():
    return render_template("home_index.html")


@home_bp.route('/memento/check/', methods=['GET'])
def home_check():
    url = request.args.get('url')
    fresh = request.args.get('fresh') or 'false'

    if not urlparse(url).scheme:
        redirect('/memento/check?url=http://{url}&type={type}&fresh={fresh}')

    return render_template("home_check.html", url=url, type='uri-m', fresh=fresh)
