pkgname=libcap
pkgver=2.51
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer David Runge <dvzrv@archlinux.org>
# and contributor Bartłomiej Piotrowski <bpiotrowski@archlinux.org>
# and contributor Allan McRae <allan@archlinux.org>
# and contributor Hugo Doria <hugo@archlinux.org>

cd "$pkgname-$pkgver"
# SBINDIR is hardcoded to sbin. set to bin
# add CPPFLAGS
patch -Np1 -i ../"${pkgname}-2.45-makefile.patch"

make KERNEL_HEADERS='/usr/include' lib='lib' prefix='/usr'

make test

make DESTDIR="$pkgdir" RAISE_SETFCAP='no' lib='lib' prefix='/usr' install

# docs
install -vDm 644 {CHANGELOG,README} -t "${pkgdir}/usr/share/doc/${pkgname}/"
install -vDm 644 pam_cap/capability.conf \
  -t "$pkgdir/usr/share/doc/$pkgname/examples/"
