pkgbase=gobject-introspection
pkgname=(gobject-introspection gobject-introspection-runtime)
pkgver=1.68.0
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Jan Alexander Steffens (heftig) <heftig@archlinux.org>
# and contributor Jan de Groot <jgc@archlinux.org>

meson setup \
  --prefix        /usr \
  --libdir        lib \
  --libexecdir    lib \
  --sbindir       bin \
  --buildtype     plain \
  --auto-features enabled \
  --wrap-mode     nodownload \
  -D              b_lto=true \
  -D              b_pie=true \
  $pkgbase build \
  -D gtk_doc=true \
  -D glib_src_dir="$srcdir/glib"
meson compile -C build

meson test -C build

#package_gobject-introspection() {
#depends+=("gobject-introspection-runtime=$pkgver-$pkgrel")

DESTDIR="$pkgdir" meson install -C build

python -m compileall -d /usr/lib/$pkgbase "$pkgdir/usr/lib/$pkgbase"
python -O -m compileall -d /usr/lib/$pkgbase "$pkgdir/usr/lib/$pkgbase"
