# This is based on the arch-linux docbook-xml package PKGBUILD

for ver in 4.2 4.3 4.4 4.5; do
  pushd docbook-xml-${ver}

  mkdir -p $PWD/../../build/usr/share/xml/docbook/xml-dtd-${ver}
  cp -dRf docbook.cat *.dtd ent/ *.mod $PWD/../../build/usr/share/xml/docbook/xml-dtd-${ver}/
  popd
done

pushd docbook-xml-4.1.2
mkdir -p $PWD/../../build/usr/share/xml/docbook/xml-dtd-4.1.2
cp -dRf docbook.cat *.dtd ent/ *.mod $PWD/../../build/usr/share/xml/docbook/xml-dtd-4.1.2/
popd

mkdir -p $PWD/../build/etc/xml
xmlcatalog --noout --create $PWD/../build/etc/xml/docbook-xml

pkgdir=$PWD/../build

# v4.1.2
echo "Adding 4.1.2"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML CALS Table Model V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/calstblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML CALS Table Model V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/calstblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD XML Exchange Table Model 19990315//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/soextblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook XML Information Pool V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/dbpoolx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook XML Document Hierarchy V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/dbhierx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook XML Additional General Entities V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/dbgenent.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook XML Notations V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/dbnotnx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook XML Character Entities V4.1.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.1.2/dbcentx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteSystem" \
  "http://www.oasis-open.org/docbook/xml/4.1.2" \
  "file:///usr/share/xml/docbook/xml-dtd-4.1.2" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteURI" \
  "http://www.oasis-open.org/docbook/xml/4.1.2" \
  "file:///usr/share/xml/docbook/xml-dtd-4.1.2" \
  "${pkgdir}/etc/xml/docbook-xml"

# V4.2
echo "Adding 4.2"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML V4.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook CALS Table Model V4.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/calstblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD XML Exchange Table Model 19990315//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/soextblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook Information Pool V4.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/dbpoolx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook Document Hierarchy V4.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/dbhierx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Additional General Entities V4.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/dbgenent.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Notations V4.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/dbnotnx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Character Entities V4.2//EN" \
  "http://www.oasis-open.org/docbook/xml/4.2/dbcentx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteSystem" \
  "http://www.oasis-open.org/docbook/xml/4.2" \
  "file:///usr/share/xml/docbook/xml-dtd-4.2" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteURI" \
  "http://www.oasis-open.org/docbook/xml/4.2" \
  "file:///usr/share/xml/docbook/xml-dtd-4.2" \
  "${pkgdir}/etc/xml/docbook-xml"

# V4.3
echo "Adding 4.3"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML V4.3//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/docbookx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook CALS Table Model V4.3//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/calstblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD XML Exchange Table Model 19990315//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/soextblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook Information Pool V4.3//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/dbpoolx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook Document Hierarchy V4.3//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/dbhierx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Additional General Entities V4.3//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/dbgenent.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Notations V4.3//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/dbnotnx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Character Entities V4.3//EN" \
  "http://www.oasis-open.org/docbook/xml/4.3/dbcentx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteSystem" \
  "http://www.oasis-open.org/docbook/xml/4.3" \
  "file:///usr/share/xml/docbook/xml-dtd-4.3" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteURI" \
  "http://www.oasis-open.org/docbook/xml/4.3" \
  "file:///usr/share/xml/docbook/xml-dtd-4.3" \
  "${pkgdir}/etc/xml/docbook-xml"

# V4.4
echo "Adding 4.4"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook CALS Table Model V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/calstblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook XML HTML Tables V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/htmltblx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD XML Exchange Table Model 19990315//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/soextblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook Information Pool V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/dbpoolx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook Document Hierarchy V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/dbhierx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Additional General Entities V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/dbgenent.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Notations V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/dbnotnx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook Character Entities V4.4//EN" \
  "http://www.oasis-open.org/docbook/xml/4.4/dbcentx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteSystem" \
  "http://www.oasis-open.org/docbook/xml/4.4" \
  "file:///usr/share/xml/docbook/xml-dtd-4.4" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteURI" \
  "http://www.oasis-open.org/docbook/xml/4.4" \
  "file:///usr/share/xml/docbook/xml-dtd-4.4" \
  "${pkgdir}/etc/xml/docbook-xml"

# V4.5
echo "Adding 4.5"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML V4.5//EN" \
  "http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD DocBook XML CALS Table Model V4.5//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/calstblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//DTD XML Exchange Table Model 19990315//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/soextblx.dtd" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook XML Information Pool V4.5//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/dbpoolx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook XML Document Hierarchy V4.5//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/dbhierx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ELEMENTS DocBook XML HTML Tables V4.5//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/htmltblx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook XML Notations V4.5//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/dbnotnx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook XML Character Entities V4.5//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/dbcentx.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "public" \
  "-//OASIS//ENTITIES DocBook XML Additional General Entities V4.5//EN" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5/dbgenent.mod" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteSystem" \
  "http://www.oasis-open.org/docbook/xml/4.5" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5" \
  "${pkgdir}/etc/xml/docbook-xml"
xmlcatalog --noout --add "rewriteURI" \
  "http://www.oasis-open.org/docbook/xml/4.5" \
  "file:///usr/share/xml/docbook/xml-dtd-4.5" \
  "${pkgdir}/etc/xml/docbook-xml"

if [ ! -e ${pkgdir}/etc/xml/catalog ]; then
  xmlcatalog --noout --create "${pkgdir}/etc/xml/catalog"
fi
xmlcatalog --noout --add "delegatePublic" \
  "-//OASIS//ENTITIES DocBook XML" \
  "file:///etc/xml/docbook-xml" \
  "${pkgdir}/etc/xml/catalog"
xmlcatalog --noout --add "delegatePublic" \
  "-//OASIS//DTD DocBook XML" \
  "file:///etc/xml/docbook-xml" \
  "${pkgdir}/etc/xml/catalog"
xmlcatalog --noout --add "delegateSystem" \
  "http://www.oasis-open.org/docbook/" \
  "file:///etc/xml/docbook-xml" \
  "${pkgdir}/etc/xml/catalog"
xmlcatalog --noout --add "delegateURI" \
  "http://www.oasis-open.org/docbook/" \
  "file:///etc/xml/docbook-xml" \
  "${pkgdir}/etc/xml/catalog"
