{BloxII Engine}
Unit BLX2GAME;

Interface

Uses Dos, Graphics, Crt;

Const
 {Note that increasing the number of enemies/bombs/gates will decrease game performance}
 MaxEnemies = 10; {Maximum active Enemies}
 MaxBombs = 6; {Maximum active/exploding bombs}
 MaxGates = 6; {Maximum of open gates}
 Gametime = 0.45; {Normal game-tics for enemymovement}
 GametimeFast = 0.25; {Fast game-tics for i.e. bomb explosion}

Type
 PlayerType = Record
 x, y, Bombs : Integer;
 Finished : Boolean;
 Delay : Integer;
 Key : Boolean;
 end;

 EnemyType = Record
 Direction : String[5]; {Current direction}
 DirectionLast1 : String[5]; {Last three directions are needed for mouse-movement}
 DirectionLast2 : String[5];
 DirectionLast3 : String[5];
 x, y, Species, Animation : Integer;
 Enabled : Boolean;
 end;

 BombType = Record
 x, y, State : Integer;
 Enabled : Boolean;
 end;
 
 Coordinates = Record
 x, y : Integer;
 Enabled : Boolean;
 end;

var
 Map  : Array [0..11, 0..16] of String[1];
 Player : Array [0..1] of PlayerType;
 Enemy : Array [0..MaxEnemies] of EnemyType;
 Bomb : Array [0..MaxBombs] of BombType;
 Gate : Array [0..MaxGates] of Coordinates; {Keep track of open gates for redraw after enemy passed}
 Gamestate, Diamonds, Level, Lives : Integer;
 s1, s2, parameter : word;
 Palette : colortype;

 {Images}
 EmptyTile, BigWall, BigWallGrass, SmallWall, SmallWallGrass, Key,
 WoodWall, WoodWallKnots, WoodWallWindow, Brick, BrickGrate, BrickBanner,
 BloxiPlayerOne, BloxiPlayerTwo, Diamond, Diamond2, Exit, ExitOpen, Spider, Mouse,
 Mouse2, Mouse3, Shooter, ArrowLeft, ArrowRight, Boulder, Heart, BombItem, BombFuse, BombFuse2, BombFuse3, BombFuse4,
 Explode, Explode2, Grass, Grass2, Cobweb, Demon, PlayerTwoDead, PlayerTwoDead2, PlayerTwoDead3, GateClosed, GateOpen,
 PlayerOneDead, PlayerOneDead2, PlayerOneDead3, SkullWall1, SkullWall2, SkullWall3, Skull, WoodWallKey, MenuKey,
 Bloxinies, MenuLborder, MenuRborder, Menulives, Menulevel, Menubombs, Menuplayer, Chain, ChainPulled,
 MenuRbordergrass, MenuLbordergrass, MenuLBot, MenuBot, MenuRBot, MenuLTop, MenuTop, MenuRTop,
 MenuRbordergrassHalf, MenuLbordergrassHalf, MenuPress, MenuFor, MenuSingle, MenuMulti, MenuToQuit, F1Menu,
 i1, i2, i3, i4, i5, i6, i7, i8, i9, i0, {image 1,2,3 <> 8, 9,0}
 DirectionUp, DirectionRight, DirectionDown, DirectionLeft : ImageType;

 ImagePCX : PictureType;
 Back : PageType;
 Start, Endtime, Endtimefast : real;
 MapTitle : string;
 Noise, SinglePlayer, Debug : Boolean;
 lasttics, tics : integer; {benchmark/tics counter}

Procedure ChangePalette; {Change VGA-palette for correct colors}
Procedure print(x,y,color:integer; const s:string); {write text on screen}
Procedure DestroyApp; {Kills application, reset textmode}
Procedure ResetGame; {clear map, enemies, lives etc}
Function Str2Int(s:string):word;
Function Int2Str(L : LongInt) : string;
Function timer:real; {used for gametics/timer}
Procedure RestartGame;
Procedure RestartLevel;
Procedure EndLevel;
Procedure FlipChain(x,y : Integer); {flip levers (initial idea was pull-chains)}
Procedure OperateGates;
Function CheckMovement(x, y, Number : Integer; Initiator : String) : Boolean; {Checks if player/enemy/boulder can move,
number = playernumber. 9 is enemy}
Procedure BloxiUp(Number : Integer); {draws player up}
Procedure BloxiLeft(Number : Integer);
Procedure BloxiRight(Number : Integer);
Procedure BloxiDown(Number : Integer);
Procedure BombDetonation; {Kaboom!}
Procedure CheckPlayerBombContact(Number : Integer; i : Integer);
Procedure DrawLevel; {redraw level}
Procedure RemoveBomb(Number : Integer);
Procedure ChangeLives(s : string); {add, remove or redraw lives}
Procedure AddBomb(Number : Integer);
Procedure PlayerDead (i : Integer);
Procedure CheckPlayerContact(i, Number : Integer); {checks player contact with enemy}
Procedure Enemymovement; {Decides if an enemy can move or not}
Procedure FastEnemymovement;
Procedure ShowMenu;
Procedure GamestateZeroKeys (Key : char); {Read the pressed keys}
Procedure GamestateOneKeys (Key : char); {Read the pressed keys}
Procedure RefreshScreen; {redraws map, gamestate to zero}
Procedure DrawEmpty(i, j : Integer); {draws empty spot}
Procedure DrawKey(i, j : Integer); {draws wall}
Procedure DrawBigWall(i, j : Integer); {draws wall}
Procedure DrawBoulder(i, j : Integer);
Procedure DrawDiamond(i, j : Integer);
Procedure DrawSpider(i, j : Integer);
Procedure DrawShooter(i, j : Integer);
Procedure DrawPlayerOne(i, j : Integer);
Procedure DrawPlayerTwo(i, j : Integer);
Procedure DrawExit(i, j : Integer);
Procedure DrawExitOpen(i, j : Integer);
Procedure DrawArrowLeft(i, j : Integer); {draws arrow from shooter}
Procedure DrawArrowRight(i, j : Integer);
Procedure DrawMouse(i, j, Number : Integer);
Procedure DrawBomb(i, j : Integer);
Procedure DrawBombFuse(i, j : Integer);
Procedure DrawBombFuse2(i, j : Integer);
Procedure DrawBombFuse3(i, j : Integer);
Procedure DrawBombFuse4(i, j : Integer);
Procedure DrawExplosion(i, j : Integer);
Procedure DrawExplosion2(i, j : Integer);
Procedure DrawWoodWall(i, j : Integer);
Procedure DrawWoodWallWindow(i, j : Integer);
Procedure DrawDirectionUp(i, j : Integer);
Procedure DrawDirectionRight(i, j : Integer);
Procedure DrawDirectionDown(i, j : Integer);
Procedure DrawDirectionLeft(i, j : Integer);
Procedure DrawDemon(i, j : Integer);
Procedure DrawSkull(i, j : Integer);
Procedure DrawWoodWallKey(i, j : Integer);
Procedure DrawGateClosed(i, j : Integer);
Procedure DrawGateOpen(i, j : Integer);
Procedure DrawChain(i, j : Integer);
Procedure DrawChainPulled(i, j : Integer);
Procedure ActivateExit; {initiate DrawExitOpen, resets diamonds to 127}
Procedure DrawObject(i, j : Integer; Obj : string); {chooses which object to be drawn}
Procedure ReadMap(level : Integer); {reads map from levels.dat}
Procedure GenerateObjects; {generate enemies etc.}
Procedure RemoveKeysFromHud;
Procedure DrawMap;
Procedure EndGameSequence;
Procedure DrawStartupMenu;
Procedure DrawHud;
Procedure ReturnEditor (level : Integer);
Procedure GenerateGraphics; {draw graphics in left corner and puts it in pointer}
Procedure DiamondSound;
Procedure HeartSound;
Procedure BoulderSound;
Procedure ExitSound;
Procedure GateSound;
Procedure WebSound;
Procedure BombPickupSound;
Procedure BombTickSound;
Procedure BombExplosionSound;
Procedure PickupKeySound;
Procedure UseKeySound;
Procedure ToggleSound;
Procedure ToggleDebug; {Show gametics during game-play}

Implementation

{Change the default VGA-palette to be able to use certain colors, i.e. brown for wood}
Procedure ChangePalette;
begin
{Wood}
 Palette.Red:=36;
 Palette.Green:=23;
 Palette.Blue:=13;
 SetPalette(211,Palette);
 Palette.Red:=29; 
 Palette.Green:=19;
 Palette.Blue:=10;
 SetPalette(212,Palette);
 Palette.Red:=27;
 Palette.Green:=18;
 Palette.Blue:=9;
 SetPalette(213,Palette);
 Palette.Red:=23;
 Palette.Green:=16;
 Palette.Blue:=8;
 SetPalette(214,Palette);
 Palette.Red:=21;
 Palette.Green:=15;
 Palette.Blue:=7;
 SetPalette(215,Palette);
 Palette.Red:=18; 
 Palette.Green:=14;
 Palette.Blue:=6;
 SetPalette(216,Palette);
 Palette.Red:=14; 
 Palette.Green:=11;
 Palette.Blue:=5;
 SetPalette(218,Palette);
 Palette.Red:=10;
 Palette.Green:=8;
 Palette.Blue:=3;
 SetPalette(219,Palette);

 Palette.Red:=9; 
 Palette.Green:=0;
 Palette.Blue:=0;
 SetPalette(220,Palette);

 Palette.Red:=22;
 Palette.Green:=0;
 Palette.Blue:=0;
 SetPalette(221,Palette);
 Palette.Red:=38;
 Palette.Green:=12;
 Palette.Blue:=12;
 SetPalette(222,Palette);
 Palette.Red:=32;
 Palette.Green:=0;
 Palette.Blue:=0;
 SetPalette(223,Palette);
 Palette.Red:=63;
 Palette.Green:=15;
 Palette.Blue:=15;
 SetPalette(224,Palette);

 Palette.Blue:=6;
 Palette.Red:=52;
 Palette.Green:=0;
 SetPalette(225,Palette);
 Palette.Blue:=9;
 Palette.Red:=0;
 Palette.Green:=58;
 SetPalette(229,Palette);
 Palette.Blue:=0;
 Palette.Red:=63;
 Palette.Green:=54;
 SetPalette(233,Palette);

 Palette.Red:=0;
 Palette.Green:=38;
 Palette.Blue:=54;
 SetPalette(236,Palette);
 Palette.Red:=0;
 Palette.Green:=35;
 Palette.Blue:=58;
 SetPalette(237,Palette);

 Palette.Blue:=6;
 Palette.Red:=47;
 Palette.Green:=6;
 SetPalette(240,Palette);
 Palette.Blue:=0;
 Palette.Red:=40;
 Palette.Green:=20;
 SetPalette(241,Palette);
 Palette.Blue:=0;
 Palette.Red:=40;
 Palette.Green:=26;
 SetPalette(242,Palette);
 Palette.Blue:=0;
 Palette.Red:=40;
 Palette.Green:=23;
 SetPalette(243,Palette);
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=32;
 SetPalette(244,Palette);
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=29;
 SetPalette(245,Palette);
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=26;
 SetPalette(246,Palette);
 
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=23;
 SetPalette(247,Palette);
end;

{Bitmaps for capitol letters; made by Jozsef Laszlo. www.joco.homeserver.hu}
procedure chr6x7_dat; assembler;
asm
  db  $00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$20,$00,$20,$00,$50
  db  $50,$00,$00,$00,$00,$00,$50,$f8,$50,$50,$f8,$50,$00,$20,$f8,$a0
  db  $f8,$28,$f8,$00,$c8,$d0,$20,$20,$58,$98,$00,$40,$a0,$40,$a8,$90
  db  $68,$00,$20,$40,$00,$00,$00,$00,$00,$20,$40,$40,$40,$40,$20,$00
  db  $20,$10,$10,$10,$10,$20,$00,$50,$20,$f8,$20,$50,$00,$00,$20,$20
  db  $f8,$20,$20,$00,$00,$00,$00,$00,$60,$20,$40,$00,$00,$00,$f8,$00
  db  $00,$00,$00,$00,$00,$00,$00,$60,$60,$00,$00,$08,$10,$20,$40,$80
  db  $00,$70,$88,$98,$a8,$c8,$70,$00,$20,$60,$20,$20,$20,$70,$00,$70
  db  $88,$08,$70,$80,$f8,$00,$f8,$10,$30,$08,$88,$70,$00,$20,$40,$90
  db  $90,$f8,$10,$00,$f8,$80,$f0,$08,$88,$70,$00,$70,$80,$f0,$88,$88
  db  $70,$00,$f8,$08,$10,$20,$20,$20,$00,$70,$88,$70,$88,$88,$70,$00
  db  $70,$88,$88,$78,$08,$70,$00,$30,$30,$00,$00,$30,$30,$00,$30,$30
  db  $00,$30,$10,$20,$00,$00,$10,$20,$40,$20,$10,$00,$00,$f8,$00,$f8
  db  $00,$00,$00,$00,$20,$10,$08,$10,$20,$00,$70,$88,$10,$20,$00,$20
  db  $00,$70,$90,$a8,$b8,$80,$70,$00,$70,$88,$88,$f8,$88,$88,$00,$f0
  db  $88,$f0,$88,$88,$f0,$00,$70,$88,$80,$80,$88,$70,$00,$e0,$90,$88
  db  $88,$90,$e0,$00,$f8,$80,$f0,$80,$80,$f8,$00,$f8,$80,$f0,$80,$80
  db  $80,$00,$70,$88,$80,$98,$88,$70,$00,$88,$88,$f8,$88,$88,$88,$00
  db  $70,$20,$20,$20,$20,$70,$00,$10,$10,$10,$10,$90,$60,$00,$90,$a0
  db  $c0,$a0,$90,$88,$00,$80,$80,$80,$80,$80,$f8,$00,$88,$d8,$a8,$88
  db  $88,$88,$00,$88,$c8,$a8,$98,$88,$88,$00,$70,$88,$88,$88,$88,$70
  db  $00,$f0,$88,$88,$f0,$80,$80,$00,$70,$88,$88,$a8,$98,$70,$00,$f0
  db  $88,$88,$f0,$90,$88,$00,$70,$80,$70,$08,$88,$70,$00,$f8,$20,$20
  db  $20,$20,$20,$00,$88,$88,$88,$88,$88,$70,$00,$88,$88,$88,$88,$50
  db  $20,$00,$88,$88,$88,$a8,$a8,$50,$00,$88,$50,$20,$20,$50,$88,$00
  db  $88,$50,$20,$20,$20,$20,$00,$f8,$10,$20,$40,$80,$f8,$00,$60,$40
  db  $40,$40,$40,$60,$00,$00,$80,$40,$20,$10,$08,$00,$30,$10,$10,$10
  db  $10,$30,$00,$20,$50,$88,$00,$00,$00,$00,$00,$00,$00,$00,$00,$f8
  db  $00,$f8,$f8,$f8,$f8,$f8,$f8
end;

{Put character but renamed to avoid conflict with GRAPHICS.TPU}
procedure poetchar; assembler;
asm
   push si              { save registers }
   push di
   push cx

   sub  al,32           { we don't have the 1st 32 ascii chars }
   mov  ah,7
   mul  ah              { character bitmap offset = 7*charcode }

   lea  si,chr6x7_dat
   add  si,ax           { DS:si points to the bitmap }

   mov  cl,7
@l0:
   segCS lodsb          { next byte from the bitmap }
   mov  ch,6
@l1:
   shl  al,1            { shift out 1 bit }
   jnc  @skip
   mov  ES:[di],dl      { show the pixel }
@skip:
   inc  di
   dec  ch              { all pixels in a line }
   jnz  @l1
   add  di,320-6        { next line }
   dec  cl
   jnz  @l0             { all lines }

   pop  cx              { load registers back from the stack }
   pop  di
   pop  si
   retn                 { near return }
end;

{Writes string on screen using Poetchar}
procedure print(x,y,color:integer; const s:string); assembler;
asm
   mov  ES,SegA000      { Screen segment }
   mov  ax,320
   mul  y
   add  ax,x
   mov  di,ax           { Address calculation, store the result in DI }
   cld

   mov  dl,color.byte   { color to the DL }
   mov  bx,DS           { save DS         }
   lds  si,s            { source string   }
   lodsb
   mov  cl,al           { 1st byte : length }
   xor  ch,ch
   jcxz @quit           { quit if it's an empty string }

@chrloop:
   lodsb                { get next charcode }
   call near ptr poetchar{ show the char - near procedure call }
   add  di,6            { next screen position }
   loop @chrloop        { show all chars  }

@quit:
   mov  DS,bx           { restore DS      }
end;

Procedure DestroyApp; {Closes the application}
begin
 CloseGraph;
 TextColor(7);
 TextBackground(0);
 Gotoxy(1,1);
 Writeln('Thank you for playing Bloxinies II.');
end;

Procedure ResetGame; {Resets game variables, clears map}
var
 i, j : Integer;
begin
Gamestate:=127;
 for i:=0 to 12 do
  begin
   for j:=0 to 16 do Map[i,j] :='A';
  end;

 for i:=0 to MaxEnemies do
  begin
   Enemy[i].Direction:='Right';
   Enemy[i].Enabled:=FALSE;
  end;
  
 for i:=0 to MaxBombs do
  begin
   Bomb[i].Enabled:=FALSE;
   Bomb[i].State:=0;
  end;

 {Reset total number of diamonds in map}
 Diamonds:=0;

 {First level}
 Level:=0;
 Lives:=3;
 Player[0].Delay:=0;
 Player[1].Delay:=0;
 Player[0].Bombs:=0;
 Player[1].Bombs:=0;
 Player[0].Finished:=FALSE;
 Player[1].Finished:=FALSE;
 Player[0].Key:=FALSE;
 Player[1].Key:=FALSE;

 Gamestate:=0;
end;

Function Str2Int(s:string):word; {Convert strings to integer}
var
 i, code : word;
begin
 val (s, i, code);
 if code <> 0 then Str2Int:=0 else Str2Int:=i;
end;

Function Int2Str(L : LongInt) : string; {Convert integer to string}
var
 s : string;
begin
 Str(L, S);
 Int2Str:=s;
end;

{Timer to move enemy every second}
Function timer:real;
var
 Hour, Minute, Second, Sec100 : word;
begin
 gettime(hour,minute,second,sec100);
 timer:=(hour*3600.0+minute*60.0+second+sec100/100)
end;

Procedure RestartGame; {Procedures needed to restart the game}
begin
 ResetGame;
 ChangeLives('Redraw');
 ReadMap(Level);
 DrawLevel;
 GenerateObjects;
 DrawMap;
 Gamestate:=0;
end;

Procedure RestartLevel; {Restart the current level}
var
 i : Integer;
begin
 for i:=0 to MaxBombs do
  begin
   Bomb[i].Enabled:=FALSE;
   Bomb[i].State:=0;
  end;
 Player[0].Bombs:=0;
 Player[1].Bombs:=0;
 Player[0].x:=0; {Set coordinates to 0 to avoid processing player data in running loops after a restart has been initiated}
 Player[0].y:=0; {i.e.: both player 0 and player 1 die due a bomb detonation; player 0 will initiate a restart and after}
 Player[1].x:=0; {everything has been redrawn, player 1 would initiate a restart again because the loop was still running}
 Player[1].y:=0;
 ReadMap(Level);
 ChangeLives('Remove');
 GenerateObjects;
 Gamestate:=0;
 DrawMap;
end;

Procedure Endlevel; {Start procedures to load next level}
begin
 Player[0].Finished:=FALSE;
 Player[1].Finished:=FALSE;
 Level:=Level+1;
 ReadMap(Level);
 DrawLevel;
 GenerateObjects;
 DrawMap;
 {Gamestate:=0;}
end;

Procedure FlipChain(x,y : Integer); {Check the map for switches/levers (initially called chains) and switch them}
var
 ChainFlipped : Boolean;
begin
 ChainFlipped:=FALSE;
 {Flip chain on map}
 if ((Map[x-1,y] = '6') and (ChainFlipped = FALSE)) then 
  begin
   ChainFlipped:=TRUE;
   Map[x-1,y] := '7';
   DrawChainPulled(x-1,y);
   if (Noise = TRUE) then GateSound;
  end;
  if ((Map[x+1,y] = '6') and (ChainFlipped = FALSE)) then 
  begin
   ChainFlipped:=TRUE;
   Map[x+1,y] := '7';
   DrawChainPulled(x+1,y);
   if (Noise = TRUE) then GateSound;
  end;
 if ((Map[x,y-1] = '6') and (ChainFlipped = FALSE)) then 
  begin
   ChainFlipped:=TRUE;
   Map[x,y-1] := '7';
   DrawChainPulled(x,y-1);
   if (Noise = TRUE) then GateSound;
  end;
 if ((Map[x,y+1] = '6') and (ChainFlipped = FALSE)) then
  begin 
   ChainFlipped:=TRUE;
   Map[x,y+1] := '7';
   DrawChainPulled(x,y+1);
   if (Noise = TRUE) then GateSound;
  end;
 if ((Map[x-1,y] = '7') and (ChainFlipped = FALSE)) then 
  begin
   ChainFlipped:=TRUE;
   Map[x-1,y] := '6';
   DrawChain(x-1,y);
   if (Noise = TRUE) then GateSound;
  end;
 if ((Map[x+1,y] = '7') and (ChainFlipped = FALSE)) then 
  begin
   ChainFlipped:=TRUE;
   Map[x+1,y] := '6';
   DrawChain(x+1,y);
   if (Noise = TRUE) then GateSound;
  end;
 if ((Map[x,y-1] = '7') and (ChainFlipped = FALSE)) then
  begin
   ChainFlipped:=TRUE;
   Map[x,y-1] := '6';
   DrawChain(x,y-1);
   if (Noise = TRUE) then GateSound;
  end;
 if ((Map[x,y+1] = '7') and (ChainFlipped = FALSE)) then 
  begin
   ChainFlipped:=TRUE;
   Map[x,y+1] := '6';
   DrawChain(x,y+1);
   if (Noise = TRUE) then GateSound;
  end;
end;

Procedure OperateGates; {Scan map and switch all gates to another state (open/closed)}
var
 i, j, k, l : Integer;
begin

for i:=0 to 11 do
 begin
  for j:=0 to 16 do
   begin
    if (Map[i,j] = '4') then
     begin
      Map[i,j] := '5';
      DrawGateOpen(i,j);
      end else
      begin
       if (Map[i,j] = '5') then
       begin
        Map[i,j] := '4';
        DrawGateClosed(i,j);
        if (Player[0].x = i) and (Player[0].y = j) then
         begin
          PlayerDead(0);
         end;
        if (Player[1].x = i) and (Player[1].y = j) then
         begin
          PlayerDead(1);
         end;
       end;
     end;
   end;
 end;

{Check if an enemy is under a gate; crush it!}
 for k:=0 to MaxEnemies do {if (Enemy[k].Enabled = TRUE) and (Enemy[k].y =j)  then }
 begin
  for l:=0 to MaxGates do if ((Enemy[k].x = Gate[l].x) and (Enemy[k].y = Gate[l].y)
  and (Enemy[k].Enabled=TRUE) and (Gate[l].Enabled = TRUE)) then
   begin
    Enemy[k].Enabled:=FALSE;
    Map[Gate[l].x,Gate[l].y] := '4';
    DrawGateClosed(Gate[l].x,Gate[l].y);
  end;
 end;
end;

Procedure CheckChain(x, y : Integer);
begin
{Check if pullchain is touched}
 if (Map[x-1,y] = '6') or (Map[x+1,y] = '6') or (Map[x,y-1] = '6') or (Map[x,y+1] = '6') 
 or (Map[x-1,y] = '7') or (Map[x+1,y] = '7') or (Map[x,y-1] = '7') or (Map[x,y+1] = '7') then 
  begin
   FlipChain(x,y);
   OperateGates;
  end;
end;

{Checks if player, enemy or boulder is allowed to move to a certain area in the map}
{Returns FALSE if no movement is allowed}
Function CheckMovement(x, y, Number : Integer; Initiator : String) : Boolean;
var
 i : integer;
 RunOnce : Boolean;
begin
 CheckMovement:=TRUE;
{Can't move into walls or shooters}
 if (Map[x,y] = 'B') or (Map[x,y] = 'C') or (Map[x,y] = 'D') or
    (Map[x,y] = 'E') or (Map[x,y] = 'J') or (Map[x,y] = 'P') or 
    (Map[x,y] = 'Q') or (Map[x,y] = 'R') or (Map[x,y] = 'T') or
    (Map[x,y] = 'U') or (Map[x,y] = 'V') or (Map[x,y] = 'M') or
    (Map[x,y] = '3') or (Map[x,y] = '4') or (Map[x,y] = '6') or
    (Map[x,y] = '7') or (Map[x,y] = 'F') then CheckMovement:=FALSE;

 {Can't move into other player}
 if (Number = 0) then
  begin
   if (x = Player[1].x) and (y = Player[1].y) then CheckMovement:=FALSE;
  end;
 if (Number = 1) then
  begin
   if (x = Player[0].x) and (y = Player[0].y) then CheckMovement:=FALSE;
  end;

 {Can't move outside level}
 if (x > 11) or (x < 0) or (y < 0) or (y > 16) then CheckMovement:=FALSE;

 {Only move in direction of arrows}
 if (Map[x,y] = 'W') and not (Player[Number].x = x+1) then
  begin
   CheckMovement:=FALSE;
  end;

 if (Map[x,y] = 'X') and not (Player[Number].y = y-1) then
  begin
   CheckMovement:=FALSE;
  end;

 if (Map[x,y] = 'Y') and not (Player[Number].x = x-1) then
  begin
   CheckMovement:=FALSE;
  end;
  
 if (Map[x,y] = 'Z') and not (Player[Number].y = y+1) then
  begin
   CheckMovement:=FALSE;
  end; 

 if (Initiator = 'Human') then
  begin {Player moved}
  
   {Make player stuck if cobweb is hit}
  if (Map[x,y] = '?') or (Map[x,y] = '|') or (Map[x,y] = '/') or (Map[x,y] = '\') then
   begin
    Player[Number].Delay:=1;
    Map[x,y]:= 'A';
    CheckMovement:=TRUE;
    if (Noise=TRUE) then WebSound;
   end;

  if (Map[x,y] = 'F') then {Grab key and add to inventory of player}
   begin
    Player[Number].Key:=TRUE;
    Map[x,y]:='A';
    if Number = 0 then PutImage(MenuKey,32,50);
    if Number = 1 then PutImage(MenuKey,32,74);
    if Noise = TRUE then PickupKeySound;
    CheckMovement:=TRUE;
   end;

  if ((Map[x,y] = '3') and (Player[Number].Key = TRUE)) then
   begin
    CheckMovement:=TRUE;
    Map[x,y]:='A';
    if Noise = TRUE then UseKeySound;
   end;

   {Boulder movement-logic}
   if (Map[x,y] = 'N') then
    begin {Move boulder}
     if (Player[Number].y < y) then
      begin {Player downwards}
       if (CheckMovement(x,y+1,Number,'Boulder') = TRUE) then
        begin {Move boulder}
         if Noise = TRUE then BoulderSound;
         DrawBoulder(x,y+1);
         Map[x,y]:='A';
         Map[x,y+1]:='N';
        end else CheckMovement:=FALSE;
      end;

      if (Player[Number].y > y) then
      begin {Player upwards}
        if (CheckMovement(x,y-1,Number,'Boulder') = TRUE) then
         begin {Move boulder}
          if Noise = TRUE then BoulderSound;
          DrawBoulder(x,y-1);
          Map[x,y]:='A';
          Map[x,y-1]:='N';
         end else CheckMovement:=FALSE;
      end;

      if (Player[Number].x < x) then
      begin {Player down}
        if (CheckMovement(x+1,y,Number,'Boulder') = TRUE) then
         begin {Move boulder}
          if Noise = TRUE then BoulderSound;
          DrawBoulder(x+1,y);
          Map[x,y]:='A';
          Map[x+1,y]:='N';
         end else CheckMovement:=FALSE;
      end;

      if (Player[Number].x > x) then
      begin {Player right}
        if (CheckMovement(x-1,y,Number,'Boulder') = TRUE) then
         begin {Move boulder}
          if Noise = TRUE then BoulderSound;
          DrawBoulder(x-1,y);
          Map[x,y]:='A';
          Map[x-1,y]:='N';
         end else CheckMovement:=FALSE;
      end;
    end;
    {Boulder movement-logic end}

   if (Map[x,y] = 'I') then
    begin {Diamond grabbed}
     Map[x,y] := 'A';
     Diamonds:=Diamonds-1;
     if Noise = TRUE then DiamondSound;
    end;

   if (Map[x,y] = 'O') then
    begin {Heart grabbed}
     Map[x,y] := 'A';
     ChangeLives('Add');
     if Noise = TRUE then HeartSound;
    end;

   if (Map[x,y] = 'S') then
    begin {Bomb grabbed}
     Map[x,y] := 'A';
     AddBomb(Number);
     if Noise = TRUE then BombPickupSound;
    end;

   {Player can move into exit when all diamonds are grabbed}
   if (Map[x,y] = 'J') and (Diamonds = 127) then
    begin
     {Remove player and put it in corner of map to avoid any interaction}
     DrawEmpty(Player[Number].x, Player[Number].y);
     Player[Number].x:=0;
     Player[Number].y:=0;

     {Set player as finished and play sound}
     Player[Number].Finished:=TRUE;
     if (SinglePlayer = TRUE) then Player[1].Finished:=TRUE;
     if Noise=TRUE then ExitSound;

     if (Player[0].Finished = TRUE) and (Player[1].Finished = TRUE) then EndLevel;
    end;

   {Player can't move after finishing}
   if (Player[Number].Finished = TRUE) then CheckMovement:=FALSE;
  end;

 if (Initiator = 'Enemy') then
  begin {Enemy moved}
   if (Map[x,y] = 'N') or (Map[x,y] = 'I') or (Map[x,y] = 'J') or
      (Map[x,y] = 'S') or (Map[x,y] = 'O') {or (Map[x,y] = '5')} then CheckMovement:=FALSE;
   for i:=0 to MaxEnemies do if (Enemy[i].Enabled = TRUE) and (Enemy[i].x = x) and (Enemy[i].y=y) then CheckMovement:=FALSE;
   for i:=0 to MaxBombs do if (Bomb[i].Enabled = TRUE) and (Bomb[i].x = x) and (Bomb[i].y=y) then CheckMovement:=FALSE;
  end;

 if (Initiator = 'Boulder') then
  begin {Boulder moved}
   if (Map[x,y] = 'N') or (Map[x,y] = 'I') or (Map[x,y] = 'S') or
   (Map[x,y] = 'O') or (Map[x,y] = '5') then CheckMovement:=FALSE;
   for i:=0 to MaxEnemies do if (Enemy[i].Enabled = TRUE) and (Enemy[i].x = x) and (Enemy[i].y=y) then CheckMovement:=FALSE;
   for i:=0 to MaxBombs do if (Bomb[i].Enabled = TRUE) and (Bomb[i].x = x) and (Bomb[i].y=y) then CheckMovement:=FALSE;
  end;
  
 if (Initiator = 'Bomb') then
  begin
   RunOnce:=FALSE;
   {Bomb can blow up open gate}
   if Map[x,y] = '5' then CheckMovement:=FALSE;
   
   {Check if coordinates contain a bomb, which will detonate upon other bomb detonation}
   if Map[x,y] = 'S' then
    begin
	 for i:=0 to MaxBombs do
       if (Bomb[i].Enabled = FALSE) and (RunOnce = FALSE) then
	    begin
		 RunOnce := TRUE;
		 Map[x,y] := 'A';
	     Bomb[i].Enabled:=TRUE;
         Bomb[i].x:=x;
         Bomb[i].y:=Y;
         Bomb[i].State:=4; {Bomb will set off}
		end;
	end;
  end;
 
  {CheckMovement:=TRUE; /NoClipping mode}
end;

Procedure BloxiUp(Number : Integer); {Moves Bloxinies up and redraws direction arrows}
var
 i : Integer;
 BombDropped : Boolean;
begin
  if (CheckMovement(Player[Number].x-1, Player[Number].y,Number,'Human') = TRUE) then
  begin { Bloxi can move up}
  if (Player[Number].Delay = 2) then
    begin
    Player[Number].Delay:=0;
    end
    else
    begin
    if Player[Number].Delay=1 then Player[Number].Delay:=2;
   BombDropped:=FALSE;
   for i:=0 to MaxBombs do
    begin
     if (Bomb[i].x=Player[Number].x) and (Bomb[i].y=Player[Number].y) and (Bomb[i].Enabled=TRUE) then BombDropped:=TRUE;
    end;
   if BombDropped=FALSE then DrawEmpty(Player[Number].x,Player[Number].y);
   {Redraw direction arrows}
   if Map[Player[Number].x,Player[Number].y] = 'W' then DrawDirectionUp(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'X' then DrawDirectionRight(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Y' then DrawDirectionDown(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Z' then DrawDirectionLeft(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = '5' then DrawGateOpen(Player[Number].x, Player[Number].y);
   Player[Number].x:=Player[Number].x-1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);
   for i:=0 to MaxEnemies do CheckPlayerContact(i, Number);
   CheckChain(Player[Number].x, Player[Number].y)
  end;
  end;
end;

Procedure BloxiLeft(Number : Integer);
var
 i : Integer;
 BombDropped : Boolean;
begin
  if (CheckMovement(Player[Number].x, Player[Number].y-1,Number, 'Human') = TRUE) then
  begin { Bloxi can move up}
  if (Player[Number].Delay = 2) then
    begin
    Player[Number].Delay:=0;
    end
    else
    begin
    if Player[Number].Delay=1 then Player[Number].Delay:=2;
   BombDropped:=FALSE;
   for i:=0 to MaxBombs do
    begin
     if (Bomb[i].x=Player[Number].x) and (Bomb[i].y=Player[Number].y) and (Bomb[i].Enabled=TRUE) then BombDropped:=TRUE;
    end;
   if BombDropped=FALSE then DrawEmpty(Player[Number].x,Player[Number].y);
   {Redraw direction arrows}
   if Map[Player[Number].x,Player[Number].y] = 'W' then DrawDirectionUp(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'X' then DrawDirectionRight(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Y' then DrawDirectionDown(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Z' then DrawDirectionLeft(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = '5' then DrawGateOpen(Player[Number].x, Player[Number].y);
   Player[Number].y:=Player[Number].y-1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);
   for i:=0 to MaxEnemies do CheckPlayerContact(i, Number);
   CheckChain(Player[Number].x, Player[Number].y)
  end;
  end;
end;

Procedure BloxiRight(Number : Integer);
var
 i : Integer;
 BombDropped : Boolean;
begin
 if (CheckMovement(Player[Number].x, Player[Number].y+1,Number, 'Human') = TRUE) then
  begin { Bloxi can move up}
   if (Player[Number].Delay = 2) then
    begin
    Player[Number].Delay:=0;
    end
    else
    begin
    if Player[Number].Delay=1 then Player[Number].Delay:=2;
   BombDropped:=FALSE;
   for i:=0 to MaxBombs do
    begin
     if (Bomb[i].x=Player[Number].x) and (Bomb[i].y=Player[Number].y) and (Bomb[i].Enabled=TRUE) then BombDropped:=TRUE;
    end;
   if BombDropped=FALSE then DrawEmpty(Player[Number].x,Player[Number].y);
   {Redraw direction arrows}
   if Map[Player[Number].x,Player[Number].y] = 'W' then DrawDirectionUp(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'X' then DrawDirectionRight(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Y' then DrawDirectionDown(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Z' then DrawDirectionLeft(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = '5' then DrawGateOpen(Player[Number].x, Player[Number].y);
   Player[Number].y:=Player[Number].y+1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);
   for i:=0 to MaxEnemies do CheckPlayerContact(i, Number);
   CheckChain(Player[Number].x, Player[Number].y)
  end;
  end;
 end;

Procedure BloxiDown(Number : Integer);
var
 i : Integer;
 BombDropped : Boolean;
begin
  if (CheckMovement(Player[Number].x+1, Player[Number].y,Number, 'Human') = TRUE) then
  begin { Bloxi can move up}
  if (Player[Number].Delay = 2) then
    begin
    Player[Number].Delay:=0;
    end
    else
    begin
    if Player[Number].Delay=1 then Player[Number].Delay:=2;
   BombDropped:=FALSE;
   for i:=0 to MaxBombs do
    begin
     if (Bomb[i].x=Player[Number].x) and (Bomb[i].y=Player[Number].y) and (Bomb[i].Enabled=TRUE) then BombDropped:=TRUE;
    end;
   if BombDropped=FALSE then DrawEmpty(Player[Number].x,Player[Number].y);
   {Redraw direction arrows}
   if Map[Player[Number].x,Player[Number].y] = 'W' then DrawDirectionUp(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'X' then DrawDirectionRight(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Y' then DrawDirectionDown(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = 'Z' then DrawDirectionLeft(Player[Number].x, Player[Number].y);
   if Map[Player[Number].x,Player[Number].y] = '5' then DrawGateOpen(Player[Number].x, Player[Number].y);
   Player[Number].x:=Player[Number].x+1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);
   for i:=0 to MaxEnemies do CheckPlayerContact(i, Number);
   CheckChain(Player[Number].x, Player[Number].y)
  end;
  end;
end;

Procedure BloxiDropBomb(Number : Integer); {Drop a bomb}
var
i : Integer;
RunOnce : Boolean;
begin
 if (Player[Number].Bombs > 0) then
  begin
  RunOnce:=FALSE;
  for i:=0 to MaxBombs do
   begin
    if (Bomb[i].Enabled = FALSE) and (RunOnce=FALSE) then
     begin
      {Draw and register bomb}
      RemoveBomb(Number);
      RunOnce:=TRUE;
      DrawBomb(Player[Number].x, Player[Number].y);
      Bomb[i].x:=Player[Number].x;
      Bomb[i].y:=Player[Number].y;
      Bomb[i].Enabled:=TRUE;
      Bomb[i].State:=0;
     end;
   end;
  end;
end;

Procedure BombDetonation; {Kaboom!}
var
i, j : Integer;
begin
 for i:=0 to MaxBombs do
  begin
   if (Bomb[i].Enabled = TRUE) then
    begin
     if (Bomb[i].State < 4) and (Noise = TRUE) then BombTickSound;
     Case Bomb[i].State of
      0: DrawBombFuse(Bomb[i].x, Bomb[i].y);
      1: DrawBombFuse2(Bomb[i].x, Bomb[i].y);
      2: DrawBombFuse3(Bomb[i].x, Bomb[i].y);
      3: DrawBombFuse4(Bomb[i].x, Bomb[i].y);
      4: DrawExplosion(Bomb[i].x, Bomb[i].y);
      5: DrawExplosion2(Bomb[i].x, Bomb[i].y);
     end;

      if (Bomb[i].State = 4) then
       begin
        {Bomb Explode; kaboom!}
        if Noise = TRUE then BombExplosionSound;
        if (CheckMovement(Bomb[i].x-1, Bomb[i].y,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion(Bomb[i].x-1, Bomb[i].y);
          Map[Bomb[i].x-1,Bomb[i].y] := 'A';
         end;
	if (CheckMovement(Bomb[i].x+1,Bomb[i].y,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion(Bomb[i].x+1, Bomb[i].y);
          Map[Bomb[i].x+1,Bomb[i].y] := 'A';
         end;
	if (CheckMovement(Bomb[i].x, Bomb[i].y-1,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion(Bomb[i].x, Bomb[i].y-1);
          Map[Bomb[i].x,Bomb[i].y-1] := 'A';
         end;
	if (CheckMovement(Bomb[i].x, Bomb[i].y+1,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion(Bomb[i].x, Bomb[i].y+1);
          Map[Bomb[i].x,Bomb[i].y+1] := 'A';
         end;

        for j:=0 to MaxEnemies do
         begin
          if (Enemy[j].x = Bomb[i].x) and (Enemy[j].y = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x-1 = Bomb[i].x) and (Enemy[j].y = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x+1 = Bomb[i].x) and (Enemy[j].y = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x = Bomb[i].x) and (Enemy[j].y-1 = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x = Bomb[i].x) and (Enemy[j].y+1 = Bomb[i].y) then Enemy[j].Enabled := FALSE;
         end;

        {Check if player should die}
	CheckPlayerBombContact(0,i);
	{Player 2 won't die again after player 1 found his/her dead}
	if ((SinglePlayer = FALSE) and not (Player[0].x = 0) and not (Player[0].y = 0)) then CheckPlayerBombContact(1,i);
    end;
      if (Bomb[i].State = 5) then
       begin
        if (CheckMovement(Bomb[i].x-1, Bomb[i].y,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion2(Bomb[i].x-1, Bomb[i].y);
          Map[Bomb[i].x-1,Bomb[i].y] := 'A';
         end;
	if (CheckMovement(Bomb[i].x+1,Bomb[i].y,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion2(Bomb[i].x+1, Bomb[i].y);
          Map[Bomb[i].x+1,Bomb[i].y] := 'A';
         end;
	if (CheckMovement(Bomb[i].x, Bomb[i].y-1,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion2(Bomb[i].x, Bomb[i].y-1);
          Map[Bomb[i].x,Bomb[i].y-1] := 'A';
         end;
	if (CheckMovement(Bomb[i].x, Bomb[i].y+1,127, 'Bomb') = TRUE) then
         begin
          DrawExplosion2(Bomb[i].x, Bomb[i].y+1);
          Map[Bomb[i].x,Bomb[i].y+1] := 'A';
         end;

        for j:=0 to MaxEnemies do
         begin
          if (Enemy[j].x = Bomb[i].x) and (Enemy[j].y = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x-1 = Bomb[i].x) and (Enemy[j].y = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x+1 = Bomb[i].x) and (Enemy[j].y = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x = Bomb[i].x) and (Enemy[j].y-1 = Bomb[i].y) then Enemy[j].Enabled := FALSE;
          if (Enemy[j].x = Bomb[i].x) and (Enemy[j].y+1 = Bomb[i].y) then Enemy[j].Enabled := FALSE;
         end;
		 
	 {Check if player should die}
	 CheckPlayerBombContact(0,i);
	 {Player 2 won't die again after player 1 found his/her dead}
	 if ((SinglePlayer = FALSE) and not (Player[0].x = 0) and not (Player[0].y = 0)) then CheckPlayerBombContact(1,i);
      end;

      if (Bomb[i].State = 6) then
       begin
        DrawEmpty(Bomb[i].x, Bomb[i].y);
        if (CheckMovement(Bomb[i].x-1, Bomb[i].y,127, 'Bomb') = TRUE) then
         begin
          DrawEmpty(Bomb[i].x-1, Bomb[i].y);
          Map[Bomb[i].x-1,Bomb[i].y] := 'A';
         end;
	if (CheckMovement(Bomb[i].x+1,Bomb[i].y,127, 'Bomb') = TRUE) then
         begin
          DrawEmpty(Bomb[i].x+1, Bomb[i].y);
          Map[Bomb[i].x+1,Bomb[i].y] := 'A';
         end;
	if (CheckMovement(Bomb[i].x, Bomb[i].y-1,127, 'Bomb') = TRUE) then
         begin
          DrawEmpty(Bomb[i].x, Bomb[i].y-1);
          Map[Bomb[i].x,Bomb[i].y-1] := 'A';
         end;
	if (CheckMovement(Bomb[i].x, Bomb[i].y+1,127, 'Bomb') = TRUE) then
         begin
          DrawEmpty(Bomb[i].x, Bomb[i].y+1);
          Map[Bomb[i].x,Bomb[i].y+1] := 'A';
         end;
        Map[Bomb[i].x,Bomb[i].y] := 'A';

        Bomb[i].Enabled:=FALSE;
       end;
      end;
      Bomb[i].State:=Bomb[i].State+1;
  end;
end;

Procedure CheckPlayerBombContact(Number : Integer; i : Integer); {Check if a player is being detonated by a bomb}
var
 RestartInitiated : Boolean;

begin
 if (Player[Number].x = Bomb[i].x) and (Player[Number].y = Bomb[i].y) then
  begin
   RestartInitiated:=TRUE;
   PlayerDead(Number);
  end;
 if (Player[Number].x-1 = Bomb[i].x) and (Player[Number].y = Bomb[i].y) then
  begin
   RestartInitiated:=TRUE;
   PlayerDead(Number);
  end;
 if (Player[Number].x+1 = Bomb[i].x) and (Player[Number].y = Bomb[i].y) then
  begin
   RestartInitiated:=TRUE;
   PlayerDead(Number);
  end;
 if (Player[Number].x = Bomb[i].x) and (Player[Number].y-1 = Bomb[i].y) then
  begin
   RestartInitiated:=TRUE;
   PlayerDead(Number);
  end;
 if (Player[Number].x = Bomb[i].x) and (Player[Number].y+1 = Bomb[i].y) then
  begin
   RestartInitiated:=TRUE;
   PlayerDead(Number);
  end;
end;

Procedure DrawNumber(Number : Integer; x, y : Integer); {draws a number, i.e. level-number}
begin
 case Number of
  0: PutImage(i0,x,y);
  1: PutImage(i1,x,y);
  2: PutImage(i2,x,y);
  3: PutImage(i3,x,y);
  4: PutImage(i4,x,y);
  5: PutImage(i5,x,y);
  6: PutImage(i6,x,y);
  7: PutImage(i7,x,y);
  8: PutImage(i8,x,y);
  9: PutImage(i9,x,y);
  10: begin PutImage(i1,x,y); PutImage(i0,x+4,y); end;
  11: begin PutImage(i1,x,y); PutImage(i1,x+4,y); end;
  12: begin PutImage(i1,x,y); PutImage(i2,x+4,y); end;
  13: begin PutImage(i1,x,y); PutImage(i3,x+4,y); end;
  14: begin PutImage(i1,x,y); PutImage(i4,x+4,y); end;
  15: begin PutImage(i1,x,y); PutImage(i5,x+4,y); end;
  16: begin PutImage(i1,x,y); PutImage(i6,x+4,y); end;
  17: begin PutImage(i1,x,y); PutImage(i7,x+4,y); end;
  18: begin PutImage(i1,x,y); PutImage(i8,x+4,y); end;
  19: begin PutImage(i1,x,y); PutImage(i9,x+4,y); end;
  20: begin PutImage(i2,x,y); PutImage(i0,x+4,y); end;
  21: begin PutImage(i2,x,y); PutImage(i1,x+4,y); end;
  22: begin PutImage(i2,x,y); PutImage(i2,x+4,y); end;
  23: begin PutImage(i2,x,y); PutImage(i3,x+4,y); end;
  24: begin PutImage(i2,x,y); PutImage(i4,x+4,y); end;
  25: begin PutImage(i2,x,y); PutImage(i5,x+4,y); end;
  26: begin PutImage(i2,x,y); PutImage(i6,x+4,y); end;
  27: begin PutImage(i2,x,y); PutImage(i7,x+4,y); end;
  28: begin PutImage(i2,x,y); PutImage(i8,x+4,y); end;
  29: begin PutImage(i2,x,y); PutImage(i9,x+4,y); end;
  30: begin PutImage(i3,x,y); PutImage(i0,x+4,y); end;
  31: begin PutImage(i3,x,y); PutImage(i1,x+4,y); end;
  32: begin PutImage(i3,x,y); PutImage(i2,x+4,y); end;
  33: begin PutImage(i3,x,y); PutImage(i3,x+4,y); end;
  34: begin PutImage(i3,x,y); PutImage(i4,x+4,y); end;
  35: begin PutImage(i3,x,y); PutImage(i5,x+4,y); end;
  36: begin PutImage(i3,x,y); PutImage(i6,x+4,y); end;
  37: begin PutImage(i3,x,y); PutImage(i7,x+4,y); end;
  38: begin PutImage(i3,x,y); PutImage(i8,x+4,y); end;
  39: begin PutImage(i3,x,y); PutImage(i9,x+4,y); end;
  40: begin PutImage(i4,x,y); PutImage(i0,x+4,y); end;
  41: begin PutImage(i4,x,y); PutImage(i1,x+4,y); end;
  42: begin PutImage(i4,x,y); PutImage(i2,x+4,y); end;
  43: begin PutImage(i4,x,y); PutImage(i3,x+4,y); end;
  44: begin PutImage(i4,x,y); PutImage(i4,x+4,y); end;
  45: begin PutImage(i4,x,y); PutImage(i5,x+4,y); end;
  46: begin PutImage(i4,x,y); PutImage(i6,x+4,y); end;
  47: begin PutImage(i4,x,y); PutImage(i7,x+4,y); end;
  48: begin PutImage(i4,x,y); PutImage(i8,x+4,y); end;
  49: begin PutImage(i4,x,y); PutImage(i9,x+4,y); end;
  50: begin PutImage(i5,x,y); PutImage(i0,x+5,y); end;
  51: begin PutImage(i5,x,y); PutImage(i1,x+5,y); end;
  52: begin PutImage(i5,x,y); PutImage(i2,x+5,y); end;
  53: begin PutImage(i5,x,y); PutImage(i3,x+5,y); end;
  55: begin PutImage(i5,x,y); PutImage(i4,x+5,y); end;
  55: begin PutImage(i5,x,y); PutImage(i5,x+5,y); end;
  56: begin PutImage(i5,x,y); PutImage(i6,x+5,y); end;
  57: begin PutImage(i5,x,y); PutImage(i7,x+5,y); end;
  58: begin PutImage(i5,x,y); PutImage(i8,x+5,y); end;
  59: begin PutImage(i5,x,y); PutImage(i9,x+5,y); end;
 end;
end;

Procedure DrawLevel; {Draw active level in menu bar}
begin
 SetColor(0);
 Bar(32,24,36,30);
 DrawNumber(Level+1,28,24);
end;

Procedure ChangeLives(s : string); {Redraw number of lives in the menu}
begin
 if not (s = 'Redraw') then
  begin
   if (s = 'Add') then Lives:=Lives+1;
   if (s = 'Remove') then Lives:=Lives-1;
  end;
 DrawNumber(Lives,28,32);
end;

Procedure RemoveBomb(Number : Integer); {Remove a bomb in the menu for the corresponding player.}
begin
 if (Number=0) then
  begin
   Player[Number].Bombs:=Player[Number].Bombs-1;
   DrawNumber(Player[Number].Bombs,28,56);
   {Note: a possible 'bug' is the menu not showing the correct amount of bombs when more than 10
    bombs are picked up; it will show 9 bombs as 90 bombs because it won't remove the 0 from the
	number 10 in the menu. A won't fix; more than 10 bombs is beyond the games' purpose}
  end;

 if (Number=1) then
  begin
   Player[Number].Bombs:=Player[Number].Bombs-1;
   DrawNumber(Player[Number].Bombs,28,80);
  end;
end;

Procedure AddBomb(Number : Integer); {Add a bomb in the menu for the corresponding player}
begin
 if (Number=0) then
  begin
   Player[Number].Bombs:=Player[Number].Bombs+1;
   DrawNumber(Player[Number].Bombs,28,56);
  end;

 if (Number=1) then
  begin
   Player[Number].Bombs:=Player[Number].Bombs+1;
   DrawNumber(Player[Number].Bombs,28,80);
  end;
end;

Procedure PlayerDead(i : Integer);
begin
 {Draw death animation}
 if (i = 0) then
  begin
   PutImage(PlayerOneDead,48+(Player[i].y*16),0+(Player[i].x*16));
   Delay(100);
   PutImage(PlayerOneDead2,48+(Player[i].y*16),0+(Player[i].x*16));
   Delay(100);
   PutImage(PlayerOneDead3,48+(Player[i].y*16),0+(Player[i].x*16));
   Delay(100);
  end;
  
 if (i = 1) then
  begin
   PutImage(PlayerTwoDead,48+(Player[i].y*16),0+(Player[i].x*16));
   Delay(100);
   PutImage(PlayerTwoDead2,48+(Player[i].y*16),0+(Player[i].x*16));
   Delay(100);
   PutImage(PlayerTwoDead3,48+(Player[i].y*16),0+(Player[i].x*16));
   Delay(100);
  end;
 RestartLevel;
end;

Procedure CheckPlayerContact(i, Number : Integer);
var
 j, Step : integer;
 Obstacle : Boolean;
begin
 if (Enemy[i].Enabled = TRUE) then
  begin
  {Demon or Spider or Mouse}
   if (Enemy[i].Species = 6) or (Enemy[i].Species = 7) or (Enemy[i].Species = 9) and (Enemy[i].Enabled = TRUE)
    then
     begin
      if ((Enemy[i].x=Player[Number].x) and (Enemy[i].y=Player[Number].y)) then PlayerDead(Number);
      if ((Enemy[i].x=Player[Number].x+1) and (Enemy[i].y=Player[Number].y)) then PlayerDead(Number);
      if ((Enemy[i].x=Player[Number].x-1) and (Enemy[i].y=Player[Number].y)) then PlayerDead(Number);
      if ((Enemy[i].x=Player[Number].x) and (Enemy[i].y=Player[Number].y+1)) then PlayerDead(Number);
      if ((Enemy[i].x=Player[Number].x) and (Enemy[i].y=Player[Number].y-1)) then PlayerDead(Number);
     end;

 {Check shooter contact}
 if (Enemy[i].Species = 8) and (Enemy[i].Enabled = TRUE) then
  begin
   if ((Enemy[i].x = Player[Number].x) and (Enemy[i].y < Player[Number].y)) then
    begin
     Obstacle:=FALSE;
     for j:=Enemy[i].y to Player[Number].y do
      begin
       if (Map[Enemy[i].x,j] = 'B') or (Map[Enemy[i].x,j] = 'C') or (Map[Enemy[i].x,j] = 'D') or
          (Map[Enemy[i].x,j] = 'N') or (Map[Enemy[i].x,j] = 'I') or (Map[Enemy[i].x,j] = 'J') or
          (Map[Enemy[i].x,j] = 'K') or (Map[Enemy[i].x,j] = 'O') or (Map[Enemy[i].x,j] = 'P') or
          (Map[Enemy[i].x,j] = 'Q') or (Map[Enemy[i].x,j] = 'R') or (Map[Enemy[i].x,j] = 'L') or
          (Map[Enemy[i].x,j] = 'S') or (Map[Enemy[i].x,j] = 'T') or (Map[Enemy[i].x,j] = 'U') or 
	  (Map[Enemy[i].x,j] = 'V') or (Map[Enemy[i].x,j] = '1') or (Map[Enemy[i].x,j] = '3') or
	  (Map[Enemy[i].x,j] = '4') then Obstacle:=TRUE;
       end;
     if Obstacle=FALSE then
      begin
       Step:=0;
       for j:=Enemy[i].y+1 to Player[Number].y do
        begin
         DrawArrowRight(Enemy[i].x,j);
         if Noise = TRUE then
          begin
           Sound(50*Step);
           Inc(Step);
          end;
         Delay(35+(2*Step));
         NoSound;
         DrawEmpty(Enemy[i].x,j);
        end;
       PlayerDead(Number);
      end;
    end;

   if (Enemy[i].x = Player[Number].x) and (Enemy[i].y > Player[Number].y) then
    begin
     Obstacle:=FALSE;
     for j:=Player[Number].y to Enemy[i].y do
      begin
       if (Map[Enemy[i].x,j] = 'B') or (Map[Enemy[i].x,j] = 'C') or (Map[Enemy[i].x,j] = 'D') or
          (Map[Enemy[i].x,j] = 'N') or (Map[Enemy[i].x,j] = 'I') or (Map[Enemy[i].x,j] = 'J') or
          (Map[Enemy[i].x,j] = 'K') or (Map[Enemy[i].x,j] = 'O') or (Map[Enemy[i].x,j] = 'P') or
          (Map[Enemy[i].x,j] = 'Q') or (Map[Enemy[i].x,j] = 'R') or (Map[Enemy[i].x,j] = 'L') or
          (Map[Enemy[i].x,j] = 'S') or (Map[Enemy[i].x,j] = 'T') or (Map[Enemy[i].x,j] = 'U') or
	  (Map[Enemy[i].x,j] = 'V') or (Map[Enemy[i].x,j] = '1') or (Map[Enemy[i].x,j] = '3') or
	  (Map[Enemy[i].x,j] = '4') then Obstacle:=TRUE;
       end;
     if Obstacle=FALSE then
      begin
       Step:=0;
       j:=Enemy[i].y-1;
       Repeat
         DrawArrowLeft(Enemy[i].x,j);
         if Noise = TRUE then
          begin
           Sound(50*Step);
           Inc(Step);
          end;
         Delay(35+(2*Step));
         NoSound;
         DrawEmpty(Enemy[i].x,j);
        j:=j-1;
       until j=Player[Number].y-1;
       PlayerDead(Number);
      end;
    end;
  end;
end;

{Check skull wall contact}
 if (Enemy[i].Species = 5) and (Enemy[i].Enabled = TRUE) then
  begin
  
   if ((Enemy[i].x = Player[Number].x) and (Enemy[i].y < Player[Number].y)) then
    begin {left to right}
     Obstacle:=FALSE;
     for j:=Enemy[i].y to Player[Number].y do 
      begin
       if (Map[Enemy[i].x,j] = 'B') or (Map[Enemy[i].x,j] = 'C') or (Map[Enemy[i].x,j] = 'D') or
          (Map[Enemy[i].x,j] = 'N') or (Map[Enemy[i].x,j] = 'I') or (Map[Enemy[i].x,j] = 'J') or
          (Map[Enemy[i].x,j] = 'K') or (Map[Enemy[i].x,j] = 'O') or (Map[Enemy[i].x,j] = 'P') or
          (Map[Enemy[i].x,j] = 'Q') or (Map[Enemy[i].x,j] = 'R') or (Map[Enemy[i].x,j] = 'L') or
          (Map[Enemy[i].x,j] = 'S') or (Map[Enemy[i].x,j] = 'T') or (Map[Enemy[i].x,j] = 'U') or 
	  (Map[Enemy[i].x,j] = 'V') or (Map[Enemy[i].x,j] = '1') or (Map[Enemy[i].x,j] = '3') or
	  (Map[Enemy[i].x,j] = '4') then Obstacle:=TRUE;
       end;
     if Obstacle=FALSE then
      begin
       Step:=0;
       for j:=Enemy[i].y+1 to Player[Number].y-1 do
        begin
         DrawSkull(Enemy[i].x,j);
         if Noise = TRUE then
          begin
           Sound(50*Step);
           Inc(Step);
          end;
         Delay(45+(2*Step));
         NoSound;
         DrawEmpty(Enemy[i].x,j);
        end;
       PlayerDead(Number);
      end;
    end;

 if ((Enemy[i].x = Player[Number].x) and (Enemy[i].y > Player[Number].y)) then
    begin {right to left}
     Obstacle:=FALSE;
     for j:=Player[Number].y to Enemy[i].y do
      begin
       if (Map[Enemy[i].x,j] = 'B') or (Map[Enemy[i].x,j] = 'C') or (Map[Enemy[i].x,j] = 'D') or
          (Map[Enemy[i].x,j] = 'N') or (Map[Enemy[i].x,j] = 'I') or (Map[Enemy[i].x,j] = 'J') or
          (Map[Enemy[i].x,j] = 'K') or (Map[Enemy[i].x,j] = 'O') or (Map[Enemy[i].x,j] = 'P') or
          (Map[Enemy[i].x,j] = 'Q') or (Map[Enemy[i].x,j] = 'R') or (Map[Enemy[i].x,j] = 'L') or
          (Map[Enemy[i].x,j] = 'S') or (Map[Enemy[i].x,j] = 'T') or (Map[Enemy[i].x,j] = 'U') or
	  (Map[Enemy[i].x,j] = 'V') or (Map[Enemy[i].x,j] = '1') or (Map[Enemy[i].x,j] = '3') or
	  (Map[Enemy[i].x,j] = '4') then Obstacle:=TRUE;
       end;
     if Obstacle=FALSE then
      begin
       Step:=0;
       for j:=Enemy[i].y-1 downto Player[Number].y+1 do
        begin
         DrawSkull(Enemy[i].x,j);
         if Noise = TRUE then
          begin
           Sound(50*Step);
           Inc(Step);
          end;
         Delay(45+(2*Step));
         NoSound;
         DrawEmpty(Enemy[i].x,j);
        end;
       PlayerDead(Number);
      end;
    end;

   if ((Enemy[i].y = Player[Number].y) and (Enemy[i].x > Player[Number].x)) then
    begin {Down to up}
     Obstacle:=FALSE; 
     for j:=Player[Number].x to Enemy[i].x do
      begin
       if (Map[j,Enemy[i].y] = 'B') or (Map[j,Enemy[i].y] = 'C') or (Map[j,Enemy[i].y] = 'D') or
          (Map[j,Enemy[i].y] = 'N') or (Map[j,Enemy[i].y] = 'I') or (Map[j,Enemy[i].y] = 'J') or
          (Map[j,Enemy[i].y] = 'K') or (Map[j,Enemy[i].y] = 'O') or (Map[j,Enemy[i].y] = 'P') or
          (Map[j,Enemy[i].y] = 'Q') or (Map[j,Enemy[i].y] = 'R') or (Map[j,Enemy[i].y] = 'L') or
          (Map[j,Enemy[i].y] = 'S') or (Map[j,Enemy[i].y] = 'T') or (Map[j,Enemy[i].y] = 'U') or
	  (Map[j,Enemy[i].y] = 'V') or (Map[j,Enemy[i].y] = '1') or (Map[j,Enemy[i].y] = '3') or
	  (Map[j,Enemy[i].y] = '4') then Obstacle:=TRUE;
       end;
     if Obstacle=FALSE then
      begin
       Step:=0;
       j:=Enemy[i].x-1;
       Repeat
         DrawSkull(j, Enemy[i].y);
         if Noise = TRUE then
          begin
           Sound(50*Step);
           Inc(Step);
          end;
         Delay(45+(2*Step));
         NoSound;
         DrawEmpty(j,Enemy[i].y);
        j:=j-1;
       until j=Player[Number].x-1;
       PlayerDead(Number);
      end;
    end;

if ((Enemy[i].y = Player[Number].y) and (Enemy[i].x < Player[Number].x)) then
    begin {Up to Down}
     Obstacle:=FALSE;
     for j:=Player[Number].x downto Enemy[i].x do
      begin
       if (Map[j,Enemy[i].y] = 'B') or (Map[j,Enemy[i].y] = 'C') or (Map[j,Enemy[i].y] = 'D') or
          (Map[j,Enemy[i].y] = 'N') or (Map[j,Enemy[i].y] = 'I') or (Map[j,Enemy[i].y] = 'J') or
          (Map[j,Enemy[i].y] = 'K') or (Map[j,Enemy[i].y] = 'O') or (Map[j,Enemy[i].y] = 'P') or
          (Map[j,Enemy[i].y] = 'Q') or (Map[j,Enemy[i].y] = 'R') or (Map[j,Enemy[i].y] = 'L') or
          (Map[j,Enemy[i].y] = 'S') or (Map[j,Enemy[i].y] = 'T') or (Map[j,Enemy[i].y] = 'U') or
	  (Map[j,Enemy[i].y] = 'V') or (Map[j,Enemy[i].y] = '1') or (Map[j,Enemy[i].y] = '3') or
	  (Map[j,Enemy[i].y] = '4') then Obstacle:=TRUE;
       end;
     if Obstacle=FALSE then
      begin
       Step:=0;
       j:=Enemy[i].x+1;
       Repeat
         DrawSkull(j, Enemy[i].y);
         if Noise = TRUE then
          begin
           Sound(50*Step);
           Inc(Step);
          end;
         Delay(45+(2*Step));
         NoSound;
         DrawEmpty(j,Enemy[i].y);
        j:=j+1;
       until j>Player[Number].x;
       PlayerDead(Number);
      end;
    end;	
{end check skull wall}
 end;
end;

Procedure MoveEnemyRight(i, species : integer);
var
 j, k : Integer;
 GateDrawed : Boolean;
begin
 GateDrawed:=FALSE;
 For j:=0 to MaxGates do
  begin
   if ((Gate[j].Enabled = TRUE) and (GateDrawed = FALSE)) then
    begin
	 if ((Gate[j].x = Enemy[i].x) and (Gate[j].y = Enemy[i].y)) then
	  begin
	   Map[Enemy[i].x,Enemy[i].y]:='5';
       DrawGateOpen(Enemy[i].x, Enemy[i].y);
	   GateDrawed:=TRUE;
	  end;
	end;
  end;
  
 if (GateDrawed = FALSE) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='A';
   DrawEmpty(Enemy[i].x, Enemy[i].y);
  end;
  
 Enemy[i].y:=Enemy[i].y+1;
 if (Species = 6) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='1';
   DrawDemon(Enemy[i].x, Enemy[i].y);
  end;
 if (Species = 7) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='K';
   DrawSpider(Enemy[i].x, Enemy[i].y);
  end;
 if (Species = 9) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='L';
   DrawMouse(Enemy[i].x, Enemy[i].y,i);
  end;
 CheckChain(Enemy[i].x, Enemy[i].y);
 CheckPlayerContact(i, 0); {Player 0}
 CheckPlayerContact(i, 1); {Player 1}
end;

Procedure MoveEnemyUp(i, species : integer);
var
 j, k : Integer;
 GateDrawed : Boolean;
begin
 GateDrawed:=FALSE;
 For j:=0 to MaxGates do
  begin
   if ((Gate[j].Enabled = TRUE) and (GateDrawed = FALSE)) then
    begin
	 if ((Gate[j].x = Enemy[i].x) and (Gate[j].y = Enemy[i].y)) then
	  begin
	   Map[Enemy[i].x,Enemy[i].y]:='5';
       DrawGateOpen(Enemy[i].x, Enemy[i].y);
	   GateDrawed:=TRUE;
	  end;
	end;
  end;

 if (GateDrawed = FALSE) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='A';
   DrawEmpty(Enemy[i].x, Enemy[i].y);
  end;  
 
 Enemy[i].x:=Enemy[i].x-1;
 if (Species = 6) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='1';
   DrawDemon(Enemy[i].x, Enemy[i].y);
  end;
 if (Species = 7) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='K';
   DrawSpider(Enemy[i].x, Enemy[i].y);
  end;
 if (Species = 9) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='L';
   DrawMouse(Enemy[i].x, Enemy[i].y,i);
  end;
 CheckChain(Enemy[i].x, Enemy[i].y);
 CheckPlayerContact(i, 0); {Player 0}
 CheckPlayerContact(i, 1); {Player 1}
end;

Procedure MoveEnemyLeft(i, species : integer);
var
 j, k : Integer;
 GateDrawed : Boolean;
begin
 GateDrawed:=FALSE;
 For j:=0 to MaxGates do
  begin
   if ((Gate[j].Enabled = TRUE) and (GateDrawed = FALSE)) then
    begin
	 if ((Gate[j].x = Enemy[i].x) and (Gate[j].y = Enemy[i].y)) then
	  begin
	   Map[Enemy[i].x,Enemy[i].y]:='5';
       DrawGateOpen(Enemy[i].x, Enemy[i].y);
	   GateDrawed:=TRUE;
	  end;
	end;
  end;
  
 if (GateDrawed = FALSE) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='A';
   DrawEmpty(Enemy[i].x, Enemy[i].y);
  end;
 
 Enemy[i].y:=Enemy[i].y-1;
 if (Species = 6) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='1';
   DrawDemon(Enemy[i].x, Enemy[i].y);
  end;
 if (Species = 7) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='K';
   DrawSpider(Enemy[i].x, Enemy[i].y);
  end;
  if (Species = 9) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='L';
   DrawMouse(Enemy[i].x, Enemy[i].y,i);
  end;
 CheckChain(Enemy[i].x, Enemy[i].y);
 CheckPlayerContact(i, 0); {Player 0}
 CheckPlayerContact(i, 1); {Player 1}
end;

Procedure MoveEnemyDown(i, species : integer);
var
 j, k : Integer;
 GateDrawed : Boolean;
begin
 GateDrawed:=FALSE;
 For j:=0 to MaxGates do
  begin
   if ((Gate[j].Enabled = TRUE) and (GateDrawed = FALSE)) then
    begin
	 if ((Gate[j].x = Enemy[i].x) and (Gate[j].y = Enemy[i].y)) then
	  begin
	   Map[Enemy[i].x,Enemy[i].y]:='5';
       DrawGateOpen(Enemy[i].x, Enemy[i].y);
	   GateDrawed:=TRUE;
	  end;
	end;
  end;
  
 if (GateDrawed = FALSE) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='A';
   DrawEmpty(Enemy[i].x, Enemy[i].y);
  end; 
  
 Enemy[i].x:=Enemy[i].x+1;
 if (Species = 6) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='1';
   DrawDemon(Enemy[i].x, Enemy[i].y);
  end;
 if (Species = 7) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='K';
   DrawSpider(Enemy[i].x, Enemy[i].y);
  end;
 if (Species = 9) then
  begin
   Map[Enemy[i].x,Enemy[i].y]:='L';
   DrawMouse(Enemy[i].x, Enemy[i].y,i);
  end;
 CheckChain(Enemy[i].x, Enemy[i].y);
 CheckPlayerContact(i, 0); {Player 0}
 CheckPlayerContact(i, 1); {Player 1}
end;

Procedure DropBombBlast(Number, x, y : Integer);
var
 j : Integer;
 RunOnce : Boolean;
begin
 if (CheckMovement(x,y,9, 'Enemy') = TRUE) then
  begin
   RunOnce:=FALSE;
   for j:=0 to MaxBombs do
    begin
     if (Bomb[j].Enabled = FALSE) and (RunOnce=FALSE) then
      begin
       {Draw and register bomb}
       RunOnce:=TRUE;
{       DrawBomb(x, y);}
       Bomb[j].x:=x;
       Bomb[j].y:=y;
       Bomb[j].Enabled:=TRUE;
       Bomb[j].State:=4;
       Enemy[Number].Animation:=Enemy[Number].Animation+1;
      end;
    end;
  end;
end;

Procedure Enemymovement;
var
j, i, Number, Distance0, Distance1, ClosestPlayer : Integer;
RunOnce, CheckDirection : Boolean;
begin

for i:=0 to MaxEnemies do
 begin

  {Species 6 = demon; walks randomly but into direction of player}
  if (Enemy[i].Enabled = TRUE) and (Enemy[i].Species = 6) then
   begin
   RunOnce:=FALSE;
   {Determine which player is closest to Demon for x-axis. Don't calculate if singleplayer}
   if (SinglePlayer = FALSE) then
    begin
     if (Player[0].x >= Enemy[i].x) then
      Distance0:=Player[0].x - Enemy[i].x else
      Distance0:=Enemy[i].x - Player[0].x;
     if (Player[1].x >= Enemy[i].x) then
      Distance1:=Player[1].x - Enemy[i].x else
      Distance1:=Enemy[i].x - Player[1].x;
    end else ClosestPlayer:=0;
	
   {Determine which player is closest to Demon for y-axis. Don't calculate if singleplayer}
   if (SinglePlayer = FALSE) then
    begin
     if (Player[0].y >= Enemy[i].y) then
      Distance0:=Distance0 + Player[0].y - Enemy[i].y else
      Distance0:=Distance0 + Enemy[i].y - Player[0].y;
     if (Player[1].y >= Enemy[i].y) then
      Distance1:=Distance1 + Player[1].y - Enemy[i].y else
      Distance1:=Distance1 + Enemy[i].y - Player[1].y;
     if Distance1 > Distance0 then ClosestPlayer:=0 else ClosestPlayer:=1;
    end else ClosestPlayer:=0;

   if (Enemy[i].y < Player[ClosestPlayer].y) then
    begin
     if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then
      begin
       MoveEnemyRight(i, 6);
       RunOnce:=TRUE;
      end;
    end;

   if (Enemy[i].y > Player[ClosestPlayer].y) then
    begin
     if (CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) then
      begin
       MoveEnemyLeft(i, 6);
       RunOnce:=TRUE;
      end;
    end;
	
if (Enemy[i].x < Player[ClosestPlayer].x) then
    begin
     if (CheckMovement(Enemy[i].x+1,Enemy[i].y,9, 'Enemy') = TRUE) then
      begin
       MoveEnemyDown(i, 6);
       RunOnce:=TRUE;
      end;
    end;

   if (Enemy[i].x > Player[ClosestPlayer].x) then
    begin
     if (CheckMovement(Enemy[i].x-1,Enemy[i].y,9, 'Enemy') = TRUE) then
      begin
       MoveEnemyUp(i, 6);
       RunOnce:=TRUE;
      end;
    end;

    if RunOnce=FALSE then {Demon didn't move; try random panic move to get un-stuck}
    begin
     Distance0:=Random(4);
     Case Distance0 of
      0: if (CheckMovement(Enemy[i].x+1,Enemy[i].y,9, 'Enemy') = TRUE) then MoveEnemyDown(i, 6);
      1: if (CheckMovement(Enemy[i].x-1,Enemy[i].y,9, 'Enemy') = TRUE) then MoveEnemyUp(i, 6);
      2: if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then MoveEnemyRight(i, 6);
      3: if (CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) then MoveEnemyLeft(i, 6);
     end;
    end;

  end;
 
  {Species 7 = spider; walks forward and turns right if stuck}
  if (Enemy[i].Enabled = TRUE) and (Enemy[i].Species = 7) then
   begin
    if (Enemy[i].Direction = 'Right') then
     begin
      if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then
       begin
        MoveEnemyRight(i, 7);
       end else Enemy[i].Direction := 'Up';
     end;
   end;

  if (Enemy[i].Enabled = TRUE) and (Enemy[i].Species = 7) then
   begin
    if (Enemy[i].Direction = 'Up') then
     begin
      if (CheckMovement(Enemy[i].x-1,Enemy[i].y,9, 'Enemy') = TRUE) then
       begin
        MoveEnemyUp(i, 7);
       end else Enemy[i].Direction := 'Left';
     end;
   end;

  if (Enemy[i].Enabled = TRUE) and (Enemy[i].Species = 7) then
   begin
    if (Enemy[i].Direction = 'Left') then
     begin
      if (CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) then
       begin
        MoveEnemyLeft(i, 7);
       end else Enemy[i].Direction := 'Down';
     end;
   end;

  if (Enemy[i].Enabled = TRUE) and (Enemy[i].Species = 7) then
   begin
    if (Enemy[i].Direction = 'Down') then
     begin
      if (CheckMovement(Enemy[i].x+1,Enemy[i].y,9, 'Enemy') = TRUE) then
       begin
        MoveEnemyDown(i, 7);
       end else
        begin {Move enemy to the right to avoid cycle-delay}
         Enemy[i].Direction := 'Right';
         if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then
          begin
           MoveEnemyRight(i, 7);
          end;
        end;
     end;
   end;

 if (Enemy[i].Enabled = TRUE) and (Enemy[i].Species = 9) then
  begin

 RunOnce:=FALSE;
 if (Enemy[i].Direction = 'Up') and (RunOnce=FALSE) then
  begin
   if (CheckMovement(Enemy[i].x-1,Enemy[i].y,9, 'Enemy') = TRUE) then
    begin
     RunOnce:=TRUE;
     MoveEnemyUp(i, 9);
     Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
     Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
     Enemy[i].DirectionLast1:=Enemy[i].Direction;
     Enemy[i].Direction:='Left';
    end else
    begin
     if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then
      begin
       RunOnce:=TRUE;
       MoveEnemyRight(i, 9);
       Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
       Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
       Enemy[i].DirectionLast1:=Enemy[i].Direction;
      end else
      begin
       if (CheckMovement(Enemy[i].x+1,Enemy[i].y,9, 'Enemy') = TRUE) then
        begin
         RunOnce:=TRUE;
         MoveEnemyDown(i, 9);
         Enemy[i].Direction:='Right';
        end else
        begin
         if (CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) then
          begin
           RunOnce:=TRUE;
           MoveEnemyLeft(i, 9);
           Enemy[i].Direction:='Down';
          end;
        end;
      end;
   end;
 end;

 if (Enemy[i].Direction = 'Left') and (RunOnce=FALSE) then
  begin
   if (CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) then
    begin
     RunOnce:=TRUE;
     MoveEnemyLeft(i, 9);
     Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
     Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
     Enemy[i].DirectionLast1:=Enemy[i].Direction;
     Enemy[i].Direction:='Down';
    end else
    begin
     if (CheckMovement(Enemy[i].x-1,Enemy[i].y,9, 'Enemy') = TRUE) then
      begin
       RunOnce:=TRUE;
       MoveEnemyUp(i, 9);
       Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
       Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
       Enemy[i].DirectionLast1:=Enemy[i].Direction;
      end else
      begin
       if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then
        begin
         RunOnce:=TRUE;
         MoveEnemyRight(i, 9);
         Enemy[i].Direction:='Up';
        end else
        begin
         if (CheckMovement(Enemy[i].x+1,Enemy[i].y,9, 'Enemy') = TRUE) then
          begin
           RunOnce:=TRUE;
           MoveEnemyDown(i, 9);
           Enemy[i].Direction:='Right';
          end;
       end;
     end;
    end;
  end;

 if (Enemy[i].Direction = 'Down') and (RunOnce=FALSE) then
  begin
   if (CheckMovement(Enemy[i].x+1,Enemy[i].y,9, 'Enemy') = TRUE) then
    begin
     RunOnce:=TRUE;
     MoveEnemyDown(i, 9);
     Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
     Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
     Enemy[i].DirectionLast1:=Enemy[i].Direction;
     Enemy[i].Direction:='Right';
    end else
    begin
     if (CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) then
      begin
       RunOnce:=TRUE;
       MoveEnemyLeft(i, 9);
       Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
       Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
       Enemy[i].DirectionLast1:=Enemy[i].Direction;
      end else
      begin
       if (CheckMovement(Enemy[i].x-1,Enemy[i].y,9, 'Enemy') = TRUE) then
        begin
         RunOnce:=TRUE;
         MoveEnemyUp(i, 9);
         Enemy[i].Direction:='Left';
        end else
        begin
         if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then
          begin
           RunOnce:=TRUE;
           MoveEnemyRight(i, 9);
           Enemy[i].Direction:='Up';
          end;
        end;
      end;
   end;
 end;

 if (Enemy[i].Direction = 'Right') and (RunOnce=FALSE) then
  begin
   if (CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) then
    begin
     RunOnce:=TRUE;
     MoveEnemyRight(i, 9);
     Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
     Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
     Enemy[i].DirectionLast1:=Enemy[i].Direction;
     Enemy[i].Direction:='Up';
    end else
    begin
     if (CheckMovement(Enemy[i].x+1,Enemy[i].y,9, 'Enemy') = TRUE) then
      begin
       RunOnce:=TRUE;
       MoveEnemyDown(i, 9);
       Enemy[i].DirectionLast3:=Enemy[i].DirectionLast2;
       Enemy[i].DirectionLast2:=Enemy[i].DirectionLast1;
       Enemy[i].DirectionLast1:=Enemy[i].Direction;
      end else
      begin
       if (CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) then
        begin
         RunOnce:=TRUE;
         MoveEnemyLeft(i, 9);
         Enemy[i].Direction:='Down';
        end else
        begin
         if (CheckMovement(Enemy[i].x-1,Enemy[i].y,9, 'Enemy') = TRUE) then
          begin
           RunOnce:=TRUE;
           MoveEnemyUp(i, 9);
           Enemy[i].Direction:='Left';
          end;
        end;
      end;
    end;
  end;

  if ((Enemy[i].Direction='Up') and
     (Enemy[i].DirectionLast1='Right') and
     (Enemy[i].DirectionLast2='Down') and
     (Enemy[i].DirectionLast3='Left')) then
      begin
       RunOnce:=FALSE;
       if ((CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = TRUE) and (RunOnce=FALSE)) then
        begin
         RunOnce:=TRUE;
         Enemy[i].Direction:='Up';
        end;
       if ((CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = TRUE) and (RunOnce=FALSE)) then
        begin
         RunOnce:=TRUE;
         Enemy[i].Direction:='Down';
        end;
       if ((CheckMovement(Enemy[i].x,Enemy[i].y-1,9, 'Enemy') = FALSE) and (RunOnce=FALSE)) then
        begin
         RunOnce:=TRUE;
         Enemy[i].Direction:='Left'; {Left}
        end;
       if ((CheckMovement(Enemy[i].x,Enemy[i].y+1,9, 'Enemy') = FALSE) and (RunOnce=FALSE)) then
        begin
         RunOnce:=TRUE;
         Enemy[i].Direction:='Right';
        end;
       {Mouse panic-move to avoid circling around}
      end;
     end;
  end;
end;

Procedure FastEnemymovement;
var
i : Integer;
RunOnce: Boolean;
begin

for i:=0 to MaxEnemies do
 begin
 {Skull wall}
 if (Enemy[i].Enabled = TRUE) and (Enemy[i].Species = 5) then
    begin
     RunOnce:=FALSE;
     if (Enemy[i].Animation = 1) and (RunOnce=FALSE) then
      begin
       PutImage(Skullwall1,48+(Enemy[i].y*16),0+(Enemy[i].x*16));
       RunOnce:=TRUE;
      end;
     if (Enemy[i].Animation = 2) and (RunOnce=FALSE) then
      begin
       PutImage(Skullwall2,48+(Enemy[i].y*16),0+(Enemy[i].x*16));
       RunOnce:=TRUE;
      end;
     if (Enemy[i].Animation = 3) and (RunOnce=FALSE) then
      begin
       PutImage(Skullwall3,48+(Enemy[i].y*16),0+(Enemy[i].x*16));
       RunOnce:=TRUE;
      end;
     if (Enemy[i].Animation = 4) and (RunOnce=FALSE) then
      begin
       PutImage(Skullwall2,48+(Enemy[i].y*16),0+(Enemy[i].x*16));
       RunOnce:=TRUE;
      end;
     Enemy[i].Animation:=Enemy[i].Animation+1;
     if (Enemy[i].Animation = 5) then Enemy[i].Animation:=1;
    end;
 end;
end;

Procedure ShowMenu; {Shows the in-game menu when F1 is pressed}
var
i : Integer;
begin
 GameState:=1;
 InitPage(Back);
 SetActivePage(Back);
 DrawHud;
 SetColor(0);
 Bar(78,48,256,152);
 PutImage(MenuLTop,80,48);
 PutImage(MenuRTop,256,48);
 PutImage(MenuLBot,80,144);
 PutImage(MenuRBot,256,144);
 for i:=6 to 15 do
  begin
   PutImage(MenuTop,16*i,48);
   PutImage(MenuBot,16*i,144);
  end;

  for i:=4 to 8 do
   begin
    PutImage(MenuLBorder,80,16*i);
    PutImage(MenuRBorder,256,16*i);
    if i=6 then PutImage(MenuLBordergrass,80,16*i);
    if i=6 then PutImage(MenuRBordergrass,256,16*i);
   end;
   CopyPageToVGA(Back);
  SetActivePage(TheScreen);
  KillPage(Back);
 Print(120,55,10,'BLOXINIES II MENU');
 Print(95,70,30,'   F1: THIS MENU');
 Print(95,80,30,'   F2: RESTART LEVEL');
 Print(95,90,30,'   F3: START NEW GAME');
 Print(95,100,30,'   F4: TOGGLE SOUND');
 Print(95,110,30,'   F8: BACK TO GAME');
 Print(95,135,30,'ESQ/Q: BACK TO MENU');

end;

Procedure GamestateZeroKeys (Key : char); {Read the pressed keys}
begin
 case Key of
  'H': BloxiUp(0);
  'K': BloxiLeft(0);
  'M': BloxiRight(0);
  'P': BloxiDown(0);
  #82: BloxiDropBomb(0);
  #32: BloxiDropBomb(0);
  'w': BloxiUp(1);
  'a': BloxiLeft(1);
  'd': BloxiRight(1);
  's': BloxiDown(1);
  'g': BloxiDropBomb(1);
  'W': BloxiUp(1);
  'A': BloxiLeft(1);
  'D': BloxiRight(1);
  'S': BloxiDown(1);
  'G': BloxiDropBomb(1);
  '+': EndLevel;
  ';': ShowMenu;
  't': ReturnEditor(level);
  'T': ReturnEditor(level);
  #59: ShowMenu;
  #60: RestartLevel;
  #61: RestartGame;
  #62: ToggleSound;
  #27: ShowMenu;
  end;
end;

Procedure GamestateOneKeys (Key : char); {Read the pressed keys}
begin
 case Key of
 #60: RestartLevel;
 #61: RestartGame;
 #62: ToggleSound;
 #66: RefreshScreen;
 #68: ToggleDebug;
 #27: DrawStartupMenu;
 'q': DrawStartupMenu;
 'Q': DrawStartupMenu;
 end;
end;

Procedure RefreshScreen;
begin
 DrawMap; {Redraw the map}
 Gamestate:=0; {Play the game}

 {Reactivate exit if all diamonds are grabbed}
 if Diamonds = 127 then ActivateExit;
 
 {Redraw player on coordinates if player is not finished}
 if not (Player[0].Finished=True) then PutImage(BloxiPlayerOne,48+(Player[0].y*16),0+(Player[0].x*16));
  {Redraw second player}
 if ((Singleplayer=FALSE) and not (Player[1].Finished=True))
 then PutImage(BloxiPlayerTwo,48+(Player[1].y*16),0+(Player[1].x*16));
end;

Procedure DrawEmpty(i, j : Integer);
begin
 PutImage(EmptyTile,48+(j*16),0+(i*16));
end;

Procedure DrawBigWall(i, j : Integer);
begin
 PutImage(BigWall,48+(j*16),0+(i*16));
end;

Procedure DrawBigWallGrass(i, j : Integer);
begin
 PutImage(BigWallGrass,48+(j*16),0+(i*16));
end;

Procedure DrawSmallWall(i, j : Integer);
begin
 PutImage(SmallWall,48+(j*16),0+(i*16));
end;

Procedure DrawSmallWallGrass(i, j : Integer);
begin
 PutImage(SmallWallGrass,48+(j*16),0+(i*16));
end;

Procedure DrawKey(i, j : Integer);
begin
 PutImage(Key,48+(j*16),0+(i*16));
end;

Procedure DrawPlayerOne(i, j : Integer);
begin
{Draw Empty tile is game is not running. Using this the player won't be drawn when leaving the ingame menu}
 if Gamestate = 0 then
  begin
   PutImage(BloxiPlayerOne,48+(j*16),0+(i*16));
   Player[0].x:=i;
   Player[0].y:=j;
  end else
   begin
    PutImage(EmptyTile,48+(j*16),0+(i*16));
   end;
end;

Procedure DrawPlayerTwo(i, j : Integer);
begin
 if Gamestate = 0 then
  begin
   PutImage(BloxiPlayerTwo,48+(j*16),0+(i*16));
   Player[1].x:=i;
   Player[1].y:=j;
  end else
   begin
    PutImage(EmptyTile,48+(j*16),0+(i*16));
   end;
end;

Procedure DrawDiamond(i, j : Integer);
var
 Number : Integer;
begin
 Number:=(Random(20));
 if Number < 10 then PutImage(Diamond,48+(j*16),0+(i*16)) else
 PutImage(Diamond2,48+(j*16),0+(i*16));
end;

Procedure DrawExit(i, j : Integer);
begin
 PutImage(Exit,48+(j*16),0+(i*16));
end;

Procedure DrawExitOpen(i, j : Integer);
begin
 PutImage(ExitOpen,48+(j*16),0+(i*16));
end;

Procedure DrawSpider(i, j : Integer);
begin
 PutImage(Spider,48+(j*16),0+(i*16));
end;

Procedure DrawMouse(i, j, Number : Integer);
begin
 if Enemy[Number].Animation = 0 then PutImage(Mouse,48+(j*16),0+(i*16));
 if Enemy[Number].Animation = 1 then PutImage(Mouse2,48+(j*16),0+(i*16));
 if Enemy[Number].Animation = 2 then PutImage(Mouse3,48+(j*16),0+(i*16));
 if Enemy[Number].Animation = 3 then PutImage(Mouse2,48+(j*16),0+(i*16));
 Enemy[Number].Animation:=Enemy[Number].Animation+1;
 if Enemy[Number].Animation > 3 then Enemy[Number].Animation:=0;
end;

Procedure DrawShooter(i, j : Integer);
begin
 PutImage(Shooter,48+(j*16),0+(i*16));
end;

Procedure DrawBoulder(i, j : Integer);
begin
 PutImage(Boulder,48+(j*16),0+(i*16));
end;

Procedure DrawArrowLeft(i, j : Integer);
begin
 PutImage(ArrowLeft,48+(j*16),0+(i*16));
end;

Procedure DrawArrowRight(i, j : Integer);
begin
 PutImage(ArrowRight,48+(j*16),0+(i*16));
end;

Procedure DrawHeart(i, j : Integer);
begin
 PutImage(Heart,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWall(i, j : Integer);
begin
 PutImage(WoodWall,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWallKnots(i, j : Integer);
begin
 PutImage(WoodWallKnots,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWallWindow(i, j : Integer);
begin
 PutImage(WoodWallWindow,48+(j*16),0+(i*16));
end;

Procedure DrawBomb(i, j : Integer);
begin
 PutImage(BombItem,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse(i, j : Integer);
begin
 PutImage(BombFuse,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse2(i, j : Integer);
begin
 PutImage(BombFuse2,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse3(i, j : Integer);
begin
 PutImage(BombFuse3,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse4(i, j : Integer);
begin
 PutImage(BombFuse4,48+(j*16),0+(i*16));
end;

Procedure DrawExplosion(i, j : Integer);
begin
 PutImage(Explode,48+(j*16),0+(i*16));
end;

Procedure DrawExplosion2(i, j : Integer);
begin
 PutImage(Explode2,48+(j*16),0+(i*16));
end;

Procedure DrawBrick(i, j : Integer);
begin
 PutImage(Brick,48+(j*16),0+(i*16));
end;

Procedure DrawBrickGrate(i, j : Integer);
begin
 PutImage(BrickGrate,48+(j*16),0+(i*16));
end;

Procedure DrawBrickBanner(i, j : Integer);
begin
 PutImage(BrickBanner,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionUp(i, j : Integer);
begin
 PutImage(DirectionUp,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionRight(i, j : Integer);
begin
 PutImage(DirectionRight,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionDown(i, j : Integer);
begin
 PutImage(DirectionDown,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionLeft(i, j : Integer);
begin
 PutImage(DirectionLeft,48+(j*16),0+(i*16));
end;

Procedure DrawDemon(i, j : Integer);
begin
 PutImage(Demon,48+(j*16),0+(i*16));
end;

Procedure DrawSkullwall(i, j : Integer);
begin
 PutImage(Skullwall1,48+(j*16),0+(i*16));
end;

Procedure DrawSkull(i, j : Integer);
begin
 PutImage(Skull,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWallKey(i, j : Integer);
begin
 PutImage(WoodWallKey,48+(j*16),0+(i*16));
end;

Procedure DrawGateClosed(i, j : Integer);
begin
 PutImage(GateClosed,48+(j*16),0+(i*16));
end;

Procedure DrawGateOpen(i, j : Integer);
begin
 PutImage(GateOpen,48+(j*16),0+(i*16));
end;

Procedure DrawChain(i, j : Integer);
begin
 PutImage(Chain,48+(j*16),0+(i*16));
end;

Procedure DrawChainPulled(i, j : Integer);
begin
 PutImage(ChainPulled,48+(j*16),0+(i*16));
end;

Procedure DrawCobwebDR(i, j : Integer);
begin {Down right}
 MirrorImage(Cobweb);
 PutImage(Cobweb,48+(j*16),0+(i*16));
 MirrorImage(Cobweb);
end;

Procedure DrawCobwebDL(i, j : Integer);
begin {Down left}
 PutImage(Cobweb,48+(j*16),0+(i*16));
end;

Procedure DrawCobwebUR(i, j : Integer);
begin {Up right}
 MirrorImage(Cobweb);
 FlipImage(Cobweb);
 PutImage(Cobweb,48+(j*16),0+(i*16));
 FlipImage(Cobweb);
 MirrorImage(Cobweb);
end;

Procedure DrawCobwebUL(i, j : Integer);
begin {Up left}
 FlipImage(Cobweb);
 PutImage(Cobweb,48+(j*16),0+(i*16));
 FlipImage(Cobweb);
end;

Procedure ActivateExit; {Opens the exit door}
var
 i, j : integer;
begin
for i:=0 to 11 do
 begin
  for j:=0 to 16 do
   begin
    if (Map[i,j] = 'J') then
     begin
      DrawExitOpen(i,j);
      Diamonds:=127;
     end;
   end;
 end;
end;

Procedure DrawObject(i, j : Integer; Obj : string); {Draws the object found on the map-file}
begin
 if Obj = 'A' then DrawEmpty(i,j);
 if Obj = 'B' then DrawBigWall(i,j);
 if Obj = 'C' then DrawBigWallGrass(i,j);
 if Obj = 'D' then DrawSmallWall(i,j);
 if Obj = 'E' then DrawSmallWallGrass(i,j);
 if Obj = 'F' then DrawKey(i,j);
 if Obj = 'G' then DrawPlayerOne(i,j);
 if Obj = 'H' then DrawPlayerTwo(i,j);
 if Obj = 'I' then DrawDiamond(i,j);
 if Obj = 'J' then DrawExit(i,j);
 if Obj = 'K' then DrawSpider(i,j);
 if Obj = 'L' then DrawMouse(i,j,127);
 if Obj = 'M' then DrawShooter(i,j);
 if Obj = 'N' then DrawBoulder(i,j);
 if Obj = 'O' then DrawHeart(i,j);
 if Obj = 'P' then DrawWoodWall(i,j);
 if Obj = 'Q' then DrawWoodWallKnots(i,j);
 if Obj = 'R' then DrawWoodWallWindow(i,j);
 if Obj = 'S' then DrawBomb(i,j);
 if Obj = 'T' then DrawBrick(i,j);
 if Obj = 'U' then DrawBrickGrate(i,j);
 if Obj = 'V' then DrawBrickBanner(i,j);
 if Obj = 'W' then DrawDirectionUp(i,j);
 if Obj = 'X' then DrawDirectionRight(i,j);
 if Obj = 'Y' then DrawDirectionDown(i,j);
 if Obj = 'Z' then DrawDirectionLeft(i,j);
 if Obj = '1' then DrawDemon(i,j);
 if Obj = '2' then DrawSkullwall(i,j);
 if Obj = '3' then DrawWoodWallKey(i,j);
 if Obj = '4' then DrawGateClosed(i,j);
 if Obj = '5' then DrawGateOpen(i,j);
 if Obj = '6' then DrawChain(i,j);
 if Obj = '7' then DrawChainPulled(i,j);
 if Obj = '/' then DrawCobwebDR(i,j);
 if Obj = '\' then DrawCobwebDL(i,j);
 if Obj = '?' then DrawCobwebUL(i,j);
 if Obj = '|' then DrawCobwebUR(i,j);
end;

Procedure ReadMap(level : Integer); {Read a map, param1 for singleplayer maps, param2 for multiplayer maps}
var
 Row, SingleMaps, MultiMaps : string;
 f : text;
 i,j,k : Integer;
begin
 for i:=0 to MaxGates do
  begin
   Gate[i].Enabled:=FALSE;
  end;
  
 SingleMaps:='LEVSINGLE.DAT';
 MultiMaps:='LEVMULTI.DAT';
 if not (ParamStr(1) = '') then SingleMaps:=ParamStr(1);
 if not (ParamStr(2) = '') then MultiMaps:=ParamStr(2);
 if (SinglePlayer=TRUE) then Assign(f,SingleMaps) else Assign(f,MultiMaps);
 Reset(f);
 for j:=0 to level*13 do
  begin {Read ahead on file to select correct level}
   Readln(f,MapTitle);
   if (MapTitle = '') then Gamestate:=4;
  end;
 j:=0;
 Repeat
 Readln(f,Row);
  for i:=0 to 16 do
   begin
    Map[j,i]:=Copy(Row,i+1,1);
   end;
 Inc(j);
 Until j=13;
 Player[0].Bombs:=0; {The ReadMap code seems to add one bomb/delay for players}
 Player[1].Bombs:=0; {Can't find out why it does that so just set it back to 0 manually}
 DrawNumber(Player[0].Bombs,28,56);
 if (SinglePlayer = FALSE) then DrawNumber(Player[1].Bombs,28,80);
 Player[0].Delay:=0;
 Player[1].Delay:=0;
 Player[0].Finished:=FALSE;
 Player[1].Finished:=FALSE;
 Player[0].Key:=FALSE;
 Player[1].Key:=FALSE;
 Close(f);
end;

Procedure GenerateObjects; {Checks map for enemies and puts them in the enemy-array}
var
 i, j, k : Integer;
 RunOnce : Boolean;
begin
 {Reset enemies and diamonds}
 i:=0;
 for i:=0 to MaxEnemies do
  begin
   Enemy[i].DirectionLast3:=''; {Last is needed for mouse panic-move}
   Enemy[i].DirectionLast2:='';
   Enemy[i].DirectionLast1:='';
   Enemy[i].Direction:='Up';
   Enemy[i].Enabled:=FALSE;
   Enemy[i].Species:=0;
   Enemy[i].Animation:=0;
  end;

 i:=0;
 for i:=0 to MaxBombs do
  begin
   Bomb[i].Enabled:=FALSE;
  end;
i:=0;
Diamonds:=0;

for i:=0 to 11 do
 begin
  for j:=0 to 16 do
   begin

   if ((Map[i,j] = '5') or (Map[i,j] = '4')) then
	 begin
	 RunOnce:=FALSE;
	  for k:=0 to MaxGates do
	   begin
	    if ((Gate[k].Enabled = FALSE) and (RunOnce = FALSE)) then 
		 begin
		  RunOnce:=TRUE;
		  Gate[k].x:=i;
		  Gate[k].y:=j;
		  Gate[k].Enabled:=TRUE;
		 end;
	   end;
	 end;   
   
     if (Map[i,j] = 'I') then
      begin {Diamond}
       Diamonds:=Diamonds+1;
      end;

     if (Map[i,j] = 'K') then
      begin {Spider}
       RunOnce:=FALSE;
       for k:=0 to MaxEnemies do
        begin
         if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
          begin
	   RunOnce:=TRUE;
           Enemy[k].x:=i;
           Enemy[k].y:=j;
           Enemy[k].Enabled:=TRUE;
           Enemy[k].Species:=7;
           Enemy[k].Direction:='Right';
           {Map[i,j]:='K';}
          end;
        end;
      end; {Spider end}

     if (Map[i,j] = 'L') then
      begin {Mouse}
       RunOnce:=FALSE;
       for k:=0 to MaxEnemies do
        begin
         if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
          begin
	   RunOnce:=TRUE;
           Enemy[k].x:=i;
           Enemy[k].y:=j;
           Enemy[k].Enabled:=TRUE;
           Enemy[k].Species:=9;
           Enemy[k].Direction:='Up';
           {Map[i,j]:='A';}
          end;
        end;
      end; {Mouse end}

      if (Map[i,j] = 'M') then
	begin {Shooter}
        RunOnce:=FALSE;
	 for k:=0 to MaxEnemies do
	  begin
	   if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
	    begin
             RunOnce:=TRUE;
             Enemy[k].x:=i;
             Enemy[k].y:=j;
             Enemy[k].Enabled:=TRUE;
             Enemy[k].Species:=8;
            end;
	  end;
         end; {Shooter end}

       if (Map[i,j] = '1') then
	begin {Demon}
        RunOnce:=FALSE;
	 for k:=0 to MaxEnemies do
	  begin
	   if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
	    begin
             RunOnce:=TRUE;
             Enemy[k].x:=i;
             Enemy[k].y:=j;
             Enemy[k].Enabled:=TRUE;
             Enemy[k].Species:=6;
            end;
	  end;
         end; {Demon end}

      if (Map[i,j] = '2') then
	begin {Skullwall}
        RunOnce:=FALSE;
	 for k:=0 to MaxEnemies do
	  begin
	   if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
	    begin
             RunOnce:=TRUE;
             Enemy[k].x:=i;
             Enemy[k].y:=j;
             Enemy[k].Enabled:=TRUE;
             Enemy[k].Species:=5;
	     Enemy[k].Animation:=1;
            end;
	  end;
         end; {Skullwall end}
   end;
 end;
end;

Procedure RemoveKeysFromHud; {Removes the key image from the HUD}
begin
 SetColor(0);
 Bar(32,50,42,55);
 Bar(32,74,42,79);
end;

Procedure DrawMap;
var
 i, j : Integer;
begin
for i:=0 to 11 do
 begin
  for j:=0 to 16 do
   begin
    DrawObject(i,j,Map[i,j]);
   end;
 end;
 
{Remove the keys after a map has been redrawn}
RemoveKeysFromHud;
end;

Procedure DrawStorySoFar;
begin
ClearScreen;
Print(90,0,10,'BLOXINIES II STORY SO FAR');
Print(1,10,25,'AFTER BLOXINIES FOUND HIS WAY THROUGH THE PURPLE');
Print(1,20,25,'PUZZLE WORLD, HE WENT HOME AND SAT DOWN TO TALK');
Print(1,30,25,'TO HIS FRIEND BLOXI.');
Print(1,50,25,'THE CHATTER BETWEEN THE TWO PIXELATED FRIENDS');
Print(1,60,25,'QUICKLY LEAD TO THE QUESTION WHAT WOULD HAPPEN');
Print(1,70,25,'IF THEY ENTER THE GATE AGAIN ...');
Print(1,90,25,'ITS UP TO YOU TO DECIDE WHETHER THEY ENTER');
Print(1,100,25,'TOGETHER OR NOT.');
Repeat
 if timer >= endtimefast then {Normal tic-cycle}
  begin
   start:=timer;
   endtimefast:=start+gametimefast;
  end;
until KeyPressed;
While KeyPressed do Readkey;
{DrawStartupMenu;}
end;

Procedure DrawInstructions;
var
i : Integer;
begin
{Instructions I}
ClearScreen;
Print(90,0,10,'BLOXINIES II INSTRUCTIONS');
Print(1,10,29,'PLAYER-MOVEMENT');
Print(1,20,25,'BLOXINIES CAN MOVE AROUND USING THE ARROW KEYS AND');
Print(1,30,25,'DROP BOMBS WITH <CTRL>. BLOXIE, PLAYER 2, RESPONDS');
Print(1,40,25,'TO A, W, S AND D AND DROPS BOMBS BY PRESSING G.');
PutImage(BloxiPlayerTwo,303,20);

Print(1,60,29,'WALLS');
Print(1,70,25,'THERE IS NO WAY TO CROSS OR JUMP OVER WALLS.');

Print(1,90,29,'BOMBS');
Print(1,100,25,'EACH PLAYER CAN COLLECT BOMBS. AFTER A BOMB IS');
Print(1,110,25,'DROPPED THEY WILL EXPLODE IN A MATTER OF SECONDS');
Print(1,120,25,'ENEMIES, BOULDERS, AND MORE WILL BE DESTROYED.');
PutImage(BombFuse,288,84);

Print(1,140,29,'HEARTS');
Print(1,150,25,'A HEART GIVES YOU AN EXTRA LIFE.');
PutImage(Heart,303,144);

Print(1,170,29,'ARROWS');
Print(1,180,25,'YOU CAN ONLY MOVE INTO THE DIRECTION OF THE ARROW.');
PutImage(DirectionLeft,305,176);

Print(1,190,10,'PRESS ENTER TO CONTINUE...');

Repeat
 if timer >= endtimefast then {Normal tic-cycle}
  begin
   start:=timer;
   endtimefast:=start+gametimefast;
   i:=i+1;
   if i = 1 then PutImage(BombFuse,288,84);
   if i = 2 then PutImage(BombFuse2,288,84);
   if i = 3 then PutImage(BombFuse3,288,84);
   if i = 4 then PutImage(BombFuse4,288,84);
   if i = 5 then PutImage(Explode,288,84);
   if i = 5 then PutImage(Explode,288,100);
   if i = 5 then PutImage(Explode,288,68);
   if i = 5 then PutImage(Explode,304,84);
   if i = 5 then PutImage(Explode,272,84);
   if i = 6 then PutImage(Explode2,288,84);
   if i = 6 then PutImage(Explode2,288,100);
   if i = 6 then PutImage(Explode2,288,68);
   if i = 6 then PutImage(Explode2,304,84);
   if i = 6 then PutImage(Explode2,272,84);
   if i = 7 then PutImage(EmptyTile,288,84);
   if i = 7 then PutImage(EmptyTile,288,100);
   if i = 7 then PutImage(EmptyTile,288,68);
   if i = 7 then PutImage(EmptyTile,304,84);
   if i = 7 then PutImage(EmptyTile,272,84);
   if i > 8 then i:=0;
  end;
until KeyPressed;
While KeyPressed do Readkey;
{Instructions II}
ClearScreen;
Print(90,0,10,'BLOXINIES II INSTRUCTIONS');
Print(1,10,29,'BOULDERS');
Print(1,20,25,'BOULDERS CAN BE PUSHED AROUND TO BLOCK ENEMIES OR');
Print(1,30,25,'TO BLOCK SHOOTERS. BOULDERS CAN BE DESTROYED BY BOMBS');

Print(1,50,29,'ENEMIES');
Print(1,60,25,'BLOXINIES WILL BE KILLED WHEN BEING TOUCHED BY AN');
Print(1,70,25,'ENEMY. DONT GET TO CLOSE!');
Print(1,90,25,'SPIDER: MOVES AND TURNS RIGHT IF HE CANT MOVE FURTHER');
Print(1,100,25,'MOUSE: THIS TAIL SWIPING MOUSE MOVES AROUND AN OBJECT');
Print(1,110,25,'DEMON: DANGEROUS! THE DEMON MOVES TOWARDS THE PLAYER');
Print(1,120,25,'SHOOTER & SKULLWALL: DOESNT MOVE BUT SHOOTS ARROWS');
Print(1,130,25,'WHEN A PLAYER TRIES TO PASS HIS PATH. TRY BLOCKING');
Print(1,140,25,'HIM USING BOULDERS, BOMBS OR OTHER ENEMIES.');

Print(1,160,25,'SPIDER  MOUSE  DEMON  SHOOTER  SKULLWALL');
Print(1,190,10,'PRESS ENTER TO CONTINUE...');
PutImage(Spider,10,170);
PutImage(Mouse,55,170);
PutImage(Demon,97,170);
PutImage(Shooter,145,170);
PutImage(SkullWall1,205,170);

i:=0;
Repeat
 if timer >= endtimefast then {Normal tic-cycle}
  begin
   start:=timer;
   endtimefast:=start+gametimefast;
   i:=i+1;
   if i = 1 then PutImage(Mouse,55,170);
   if i = 1 then PutImage(SkullWall1,205,170);
   if i = 2 then PutImage(Mouse2,55,170);
   if i = 2 then PutImage(SkullWall2,205,170);
   if i = 3 then PutImage(Mouse3,55,170);
   if i = 3 then PutImage(SkullWall3,205,170);
   if i = 4 then PutImage(Mouse2,55,170);
   if i = 4 then PutImage(SkullWall2,205,170); 
   if i = 4 then i:=0;
  end;
until KeyPressed;
While KeyPressed do Readkey;
{Instructions III}
ClearScreen;
Print(90,0,10,'BLOXINIES II INSTRUCTIONS');
Print(1,10,29,'GATES');
Print(1,20,25,'GATES CAN BE OPENED AND CLOSED BY LEVERS. BE');
Print(1,30,25,'CAREFULL NOT TO WALK UNDER A CLOSING GATE! ');
Print(1,40,25,'BOULDERS ARE TOO BIG TO BE PUSHED THROUGH OPEN');
Print(1,50,25,'GATES AND ENEMIES WONT PASS OPEN GATES AS WELL.');
Print(1,60,25,'BOTH PLAYERS AND ENEMIES CAN SWITCH LEVERS');
PutImage(Chain,290,15);
PutImage(GateClosed,290,35);

Print(1,80,29,'KEYS');
Print(1,90,25,'YOU CAN PICK UP KEYS TO OPEN DOORS. A KEY WILL');
Print(1,100,25,'FIT ON EVERY DOOR. YOU WONT LOSE YOUR KEY AFTER');
Print(1,110,25,'USING IT.');
PutImage(Key,290,85);
PutImage(WoodWallKey,290,105);

Print(1,130,29,'DIAMONDS');
Print(1,140,25,'IN ORDER TO FINISH A LEVEL YOU HAVE TO WALK');
Print(1,150,25,'THROUGH THE DOOR. THE DOOR WILL OPEN ONCE YOU');
Print(1,160,25,'HAVE COLLECTED ALL THE DIAMONDS.');
PutImage(Exit,290,140);
PutImage(Diamond,280,160);
PutImage(Diamond2,300,160);

Print(1,180,29,'COBWEB');
Print(1,190,25,'COBWEB IS HARMLESS, BUT YOU WILL GET STUCK IN IT.');
PutImage(Cobweb,300,180);

i:=0;
Repeat
 if timer >= endtimefast then {Normal tic-cycle}
  begin
   start:=timer;
   endtimefast:=start+gametimefast;
   i:=i+1;
   if i = 1 then PutImage(Chain,290,15);
   if i = 3 then PutImage(ChainPulled,290,15);
   if i = 1 then PutImage(GateClosed,290,35);
   if i = 3 then PutImage(GateOpen,290,35);
   if i = 4 then i:=0;
  end;
until KeyPressed;
end;

Procedure EndGameSequence;
var
 i,j : Integer;
begin
 ClearScreen;
 {Draw 'lines'}
 for i:=1 to 18 do
  begin
   DrawBigWall(11,i-3);
   DrawBigWall(1,i-3);
   if i < 10 then
    begin
     DrawBigWall(i+1,9);
    end;
  end;

 {Animation}
 i:=1;
  repeat
  
  {Fast animation for falling bricks}
  if timer >= endtimefast then
    begin
     start:=timer;
     endtimefast:=start+gametimefast;
	 
   if j mod 2 = 0 then PutImage(Grass,96,0) else PutImage(Grass2,96,0);
   if j mod 2 = 0 then PutImage(Grass,256,160) else PutImage(Grass2,256,160);
   
   j:=j+1;
   if j > 9 then j:=0;
	
   if i < 11 then
    begin
     DrawBigWall(i,1);
     DrawEmpty(i-1,1);
    end;

   if ((i > 3) and (i < 14)) then
    begin
     DrawBigWall(i-3,7);
     DrawEmpty(i-4,7);
     DrawBigWall(i-3,8);
     DrawEmpty(i-4,8);
    end;

   if ((i >6) and (i < 14)) then
    begin
     PutImage(EmptyTile,8+16*(i-8),80);
     PutImage(BloxiPlayerOne,8+16*(i-7),80);
    end;

  i:=i+1;
 end;
until i=15;

PRINT(10,40,65,'WAIT A MINUTE!');
PRINT(10,50,65,'THIS IS NOT HOW THE GAME GOES!');
PRINT(10,60,65,'LETS GET BACK TO THE MENU!');
{use gametics for delay}
i:=0;
repeat
if timer >= endtime then
 begin
  start:=timer;
  endtime:=start+gametime;
  i:=i+1;
 end;
until i=3;
PRINT(10,110,65,'THANK YOU FOR PLAYING');
{use gametics for delay}
i:=0;
repeat
if timer >= endtime then
 begin
  start:=timer;
  endtime:=start+gametime;
  i:=i+1;
 end;
until i=3;
PRINT(10,140,65,'PRESS ENTER TO RETURN');
PRINT(10,150,65,'TO THE MENU.');
Readkey;
Gamestate:=2;
end;

Procedure DrawStartupMenu;
var
 i, j : Integer;
begin
ResetGame; {Clears map and removes any left-over player data when accessing menu after playing}
Gamestate:=0;
While KeyPressed do Readkey;
ClearScreen;
InitPage(Back);	{paging}
SetActivePage(Back);	{paging}
 for i:=4 to 10 do
  begin
   PutImage(MenuLborder,80,8+16*i);
   PutImage(MenuRborder,224,8+16*i);
   PutImage(MenuTop,48+(16*i),56);
   if (i=6) or (i=9) then PutImage(MenuLbordergrassHalf,80,8+16*i);
   if (i=6) or (i=9) then PutImage(MenuRbordergrassHalf,224,8+16*i);
   PutImage(BigWall, 32,16*i+8);
   PutImage(BigWall, 272,16*i+8);
  end;

PutImage(BigWallGrass,32,56);
PutImage(BigWall,16,56);
PutImage(BigWall,48,56);
PutImage(BigWall,272,56);
PutImage(BigWall,256,56);
PutImage(BigWall,288,56);
PutImage(MenuTop,96,56);
PutImage(MenuLTop,80,56);
PutImage(MenuRTop,224,56);

for i:=0 to 19 do
 begin
  PutImage(BigWall,16*i,184);
  if (i=4) or (i=13) then PutImage(BigWallGrass,16*i,184);
 end;

PutImage(Cobweb,288,169);
FlipImage(Cobweb);
PutImage(Cobweb,48,72);
{Flipping the cobweb back later}

DrawPlayerOne(11,3);
DrawEmpty(11,4);
DrawEmpty(11,5);
DrawEmpty(11,6);
DrawEmpty(11,7);
DrawEmpty(11,8);
DrawEmpty(11,9);
DrawEmpty(11,10);


PutImage(Bloxinies,140,4);
PutImage(BigWall,120,0);
PutImage(BigWall,128,16);
PutImage(BigWall,144,16);
PutImage(BigWallGrass,160,16);
PutImage(BigWall,176,16);
PutImage(BigWall,184,0);
PutImage(Grass,32,40);
PutImage(Grass,256,168);

CopyPageToVGA(Back);	{paging}
SetActivePage(TheScreen);	{paging}
Print(96,96,28,'S'); Print(102,96,21,'INGLEPLAYER');
Print(96,104,28,'M'); Print(102,104,21,'ULTIPLAYER');
Print(96,112,28,'I'); Print(102,112,21,'NSTRUCTIONS');
Print(96,120,21,'STORY SO FAR'); Print(150,120,28,'F');
Print(96,128,28,'Q'); Print(102,128,21,'UIT');
KillPage(Back);	{paging}

{Define player coordinates for moving player}
Player[0].y:=3;
Player[0].x:=11;
i:=0;
j:=0;
FlipImage(Cobweb); {Flip it back to original}
Repeat
 if timer >= endtime then {Normal tic-cycle}
  begin
   start:=timer;
   endtime:=start+gametime;
   if (Player[0].y > 9) then i:=1;
   if (Player[0].y < 4) then i:=0;
   if i=1 then BloxiLeft(0) else BloxiRight(0);
  end;

 if timer >= endtimefast then {fast tic-cycle}
  begin
   start:=timer;
   endtimefast:=start+gametimefast;
   if j mod 2 = 0 then PutImage(Grass,32,40) else PutImage(Grass2,32,40);
   if j mod 2 = 0 then PutImage(Grass,256,168) else PutImage(Grass2,256,168);
   j:=j+1;
   if j > 9 then j:=0;
  end;

  until Keypressed;
 case Readkey of
'S' : SinglePlayer:=TRUE;
'M' : SinglePlayer:=FALSE;
'm' : SinglePlayer:=FALSE;
's' : SinglePlayer:=TRUE;
'I' : begin DrawInstructions; Gamestate:=2; end; {Set gamestate=1 to avoid double clearscreen/resetgame}
'i' : begin DrawInstructions; Gamestate:=2; end;
'F' : begin DrawStorySoFar; Gamestate:=2; end;
'f' : begin DrawStorySoFar; Gamestate:=2; end;
'Q' : Gamestate:=3;
'q' : Gamestate:=3;
#27 : Gamestate:=3;
#13 : Gamestate:=2;
End;

 if (Gamestate = 0) then
  begin {Only start loading game when gamestate is 0. StartupMenu can define
  gamestate as 3 disabling the need to load up the game and immediately quit }
   ClearScreen;
   ResetGame;
   ReadMap(Level);
   GenerateObjects;
   DrawHud;
   DrawMap;
  end;
  
 if (Gamestate = 3) then
  begin
   {Kills application; exit is unclean thus using halt to clear everything}
   DestroyApp;
   Halt;
  end;
end;

Procedure DrawHud;
var
 i : Integer;
begin
 PutImage(MenuLTop,0,0);
 PutImage(MenuTop,16,0);
 PutImage(MenuRTop,32,0);
 PutImage(Bloxinies,3,5);
 for i:=1 to 10 do
  begin
   PutImage(MenuLborder,0,16*i);
   PutImage(MenuRborder,32,16*i);
   if (i=4) or (i=5) then PutImage(MenuLbordergrass,0,16*i);
   if (i=4) or (i=5) then PutImage(MenuRbordergrass,32,16*i);
   if (i=6) or (i=9) then PutImage(MenuLbordergrassHalf,0,16*i);
   if (i=6) or (i=9) then PutImage(MenuRbordergrassHalf,32,16*i);
  end;
 PutImage(Menulevel,4,24);
 DrawLevel;
 PutImage(Menulives,4,32);
 PutImage(Menubombs,4,56);
 PutImage(Menuplayer,4,48);
 DrawNumber(1,28,48);
 DrawNumber(Player[0].Bombs,28,56);

 if SinglePlayer=FALSE then
  begin
   PutImage(Menuplayer,4,72);
   DrawNumber(2,28,72);
   PutImage(Menubombs,4,80);
   DrawNumber(Player[1].Bombs,28,80);
  end;
 ChangeLives('Redraw');
 PutImage(MenuLBot,0,176);
 PutImage(MenuBot,16,176);
 PutImage(MenuRBot,32,176);
 PutImage(F1Menu,5,180);
end;

Procedure ReturnEditor (level : Integer);
var
f : text;
SingleMaps, MultiMaps, PCXFile : String;

begin
 if (ParamStr(6) = 'Editor') then
  begin
  {Exit Bloxinies II and write the returning batch }
 {Determine single or multiplayer map parameters}
 SingleMaps:='LEVSINGLE.DAT';
 MultiMaps:='LEVMULTI.DAT';
 if not (ParamStr(1) = '') then SingleMaps:=ParamStr(1);
 if not (ParamStr(2) = '') then MultiMaps:=ParamStr(2);
 
 {Determine specified graphics file}
 if not (ParamStr(3) = '') then PCXFile:=ParamStr(3) else PCXFile:='BLOXII.GFX';
 
 assign(f,'RETBATCH.BAT'); rewrite(f);
 if SinglePlayer=TRUE then writeln(f, '@BLOXEDIT.EXE '+SingleMaps+' '+MultiMaps+' '+PCXFile+' '+Int2Str(level))
 else writeln(f, '@BLOXEDIT.EXE '+SingleMaps+' '+MultiMaps+' '+PCXFile+' 0 '+Int2Str(level));
 close(f);
 
 DestroyApp;
 Halt;
  end;
end;

Procedure GenerateGraphics;
begin
InitPage(Back);
SetActivePage(Back);
if not (ParamStr(3) = '') then LoadPCX(ImagePCX,ParamStr(3)) else LoadPCX(ImagePCX,'BLOXII.GFX');
DrawPicture(0,0,ImagePCX,0,0);
GetImage(EmptyTile,0,0,15,15);
GetImage(BigWall,16,0,31,15);
GetImage(BigWallGrass,32,0,47,15);
GetImage(SmallWall,48,0,63,15);
GetImage(SmallWallGrass,64,0,79,15);
GetImage(Key,80,0,95,15);
GetImage(BloxiPlayerOne,96,0,111,15);
GetImage(BloxiPlayerTwo,112,0,127,15);
GetImage(Diamond,128,0,143,15);
GetImage(Diamond2,128,16,143,31);
GetImage(BombItem,144,16,159,31);
GetImage(BombFuse,160,16,175,31);
GetImage(BombFuse2,176,16,191,31);
GetImage(BombFuse3,192,16,207,31);
GetImage(BombFuse4,208,16,223,31);
GetImage(Explode,224,16,239,31);
GetImage(Explode2,240,16,255,31);
GetImage(Grass,256,16,271,31);
GetImage(Grass2,272,16,287,31);
GetImage(Cobweb,192,32,207,47);
GetImage(PlayerOneDead,224,32,239,47);
GetImage(PlayerOneDead2,240,32,255,47);
GetImage(PlayerOneDead3,256,32,271,47);
GetImage(GateClosed,272,32,287,47);
GetImage(GateOpen,288,32,303,47);
GetImage(Chain,272,48,287,63);
GetImage(ChainPulled,288,48,303,63);
GetImage(PlayerTwoDead,224,48,239,63);
GetImage(PlayerTwoDead2,240,48,255,63);
GetImage(PlayerTwoDead3,256,48,271,63);
MirrorImage(Cobweb);
GetImage(DirectionRight,304,16,319,31);
MirrorImage(DirectionRight);
GetImage(DirectionUp,288,16,303,31);
FlipImage(DirectionUp);
GetImage(DirectionDown,288,16,303,31);
GetImage(DirectionLeft,304,16,319,31);
GetImage(Exit,144,0,159,15);
GetImage(ExitOpen,160,0,175,15);
GetImage(Spider,176,0,191,15);
GetImage(Mouse,192,0,207,15);
GetImage(Shooter,208,0,223,15);
GetImage(ArrowLeft,224,0,239,15);
GetImage(ArrowRight,240,0,255,15);
SetActivePage(TheScreen);
Print(1,0,25,'STARTING BLOXINIES II [...]');
SetActivePage(Back);
GetImage(Boulder,256,0,271,15);
GetImage(Heart,272,0,287,15);
GetImage(Mouse2,288,0,303,15);
GetImage(Mouse3,304,0,319,15);
GetImage(WoodWall,0,16,15,31);
GetImage(WoodWallKnots,16,16,31,31);
GetImage(WoodWallWindow,32,16,47,31);
GetImage(Brick,48,16,63,31);
GetImage(BrickGrate,64,16,79,31);
GetImage(BrickBanner,80,16,95,31);
GetImage(Demon,96,16,111,31);
GetImage(Bloxinies,3,36,44,47);
GetImage(MenuLBot,0,64,15,79);
GetImage(MenuBot,16,64,31,79);
GetImage(MenuRBot,32,64,47,79);
GetImage(MenuLborder,48,32,63,47);
GetImage(MenuRborder,64,32,79,47);
GetImage(MenuLbordergrass,80,32,95,47);
GetImage(MenuRbordergrass,96,32,111,47);
GetImage(SkullWall3,48,48,63,63);
GetImage(SkullWall2,64,48,79,63);
GetImage(SkullWall1,80,48,95,63);
GetImage(Skull,96,48,111,63);
GetImage(WoodWallKey,112,48,127,63);
GetImage(MenuLbordergrassHalf,112,32,127,47);
GetImage(MenuRbordergrassHalf,128,32,143,47);
GetImage(MenuLTop,144,32,159,47);
GetImage(MenuTop,160,32,175,47);
GetImage(MenuRTop,176,32,191,47);
GetImage(MenuLives,42,82,57,88);
GetImage(MenuLevel,58,82,73,88);
GetImage(MenuBombs,74,82,95,88);
GetImage(MenuPlayer,97,82,118,88);
GetImage(MenuPress,119,82,138,88);
GetImage(MenuFor,140,82,152,88);
GetImage(MenuSingle,153,82,174,88);
GetImage(MenuMulti,175,82,193,88);
GetImage(MenuToQuit,194,82,222,88);
GetImage(F1Menu,223,82,255,88);
GetImage(MenuKey,255,82,265,88);
GetImage(i1,0,82,3,88);
GetImage(i2,4,82,7,88);
GetImage(i3,8,82,11,88);
GetImage(i4,12,82,15,88);
GetImage(i5,16,82,19,88);
GetImage(i6,20,82,23,88);
GetImage(i7,24,82,27,88);
GetImage(i8,28,82,31,88);
GetImage(i9,32,82,35,88);
GetImage(i0,36,82,39,88);
SetActivePage(TheScreen);
CopyPageToVGA(TheScreen);
KillPage(Back);
end;

Procedure DiamondSound;
begin
 Sound(350);
 Delay(10);
 Sound(1250);
 Delay(10);
 Sound(150);
 Delay(10);
 NoSound;
end;

Procedure HeartSound;
begin
 Sound(250);
 Delay(10);
 Sound(400);
 Delay(25);
 Sound(550);
 Delay(30);
 NoSound;
end;

Procedure BoulderSound;
begin
 Sound(150);
 Delay(20);
 Sound(200);
 Delay(20);
 NoSound;
end;

Procedure ExitSound;
begin
 Sound(400);
 Delay(50);
 Sound(300);
 Delay(25);
 Sound(350);
 Delay(25);
 Sound(450);
 Delay(25);
 NoSound;
end;

Procedure GateSound;
begin
 Sound(300);
 Delay(10);
 Sound(200);
 Delay(20);
 Sound(100);
 Delay(30);
 NoSound;
end;

Procedure WebSound;
var
i : Integer;
begin
 for i:=75 downto 60 do
  begin
   Sound(i);
   delay(9);
  end;
 NoSound;
end;

Procedure BombPickupSound;
begin
 Sound(500);
 Delay(15);
 NoSound;
 Delay(10);
 Sound(300);
 Delay(25);
 Sound(100);
 Delay(25);
 NoSound;
end;

Procedure BombTickSound;
begin
 Sound(150);
 Delay(20);
 NoSound;
 Sound(100);
 Delay(10);
 NoSound;
end;

Procedure BombExplosionSound;
begin
 Sound(600);
 Delay(20);
 Sound(500);
 Delay(20);
 Sound(400);
 Delay(20);
 Sound(300);
 Delay(20);
 Sound(100);
 Delay(50);
 NoSound;
end;

Procedure PickupKeySound;
begin
 Sound(600);
 Delay(20);
 NoSound;
end;

Procedure UseKeySound;
begin
 Sound(600);
 Delay(20);
 NoSound;
end;

Procedure ToggleDebug;
begin
 if Debug=TRUE then
  begin
   Debug:=FALSE;
   print(1,192,0,Int2Str(lasttics));
  end else Debug:=TRUE;
end;

Procedure ToggleSound;
begin
 if (Noise = FALSE) then Noise := TRUE else Noise := FALSE;
 Sound(100);
 Delay(50);
 NoSound;
end;

begin
end.