{BloxII Edit Engine}
Unit BLX2EDIT;

Interface

Uses Dos, Graphics, Crt;

Const
 MaxEnemies = 10; {Maximum active Enemies}
 MaxBombs = 3; {Maximum active/exploding bombs}
 Gametime = 0.45; {Normal game-tics for enemymovement}
 GametimeFast = 0.25; {Fast game-tics for i.e. bomb explosion}

Type
 PlayerType = Record
 x, y, Bombs : Integer;
 Finished : Boolean;
 Delay : Integer;
 Key : Boolean;
 end;

 EnemyType = Record
 Direction : String[5]; {Current direction}
 DirectionLast1 : String[5]; {Last three directions are needed for mouse-movement}
 DirectionLast2 : String[5];
 DirectionLast3 : String[5];
 x, y, Species, Animation : Integer;
 Enabled : Boolean;
 end;

 BombType = Record
 x, y, State : Integer;
 Enabled : Boolean;
 end;

var
 ActiveObject : String[1];
 ActiveObjectNumber : Integer;
 Map  : Array [0..11, 0..16] of String[1];
 MapCopy  : Array [0..11, 0..16] of String[1];
 Player : Array [0..1] of PlayerType;
 Enemy : Array [0..MaxEnemies] of EnemyType;
 Bomb : Array [0..MaxBombs] of BombType;
 Gamestate, Diamonds, Level, Lives : Integer;
 s1, s2, parameter : word;
 Palette : colortype;

 {Images}
 EmptyTile, BigWall, BigWallGrass, SmallWall, SmallWallGrass, Key,
 WoodWall, WoodWallKnots, WoodWallWindow, Brick, BrickGrate, BrickBanner,
 BloxiPlayerOne, BloxiPlayerTwo, Diamond, Diamond2, Exit, ExitOpen, Spider, Mouse,
 Mouse2, Mouse3, Shooter, ArrowLeft, ArrowRight, Boulder, Heart, BombItem, BombFuse, BombFuse2, BombFuse3, BombFuse4,
 Explode, Explode2, Grass, Grass2, Cobweb, Demon, PlayerTwoDead, PlayerTwoDead2, PlayerTwoDead3, GateClosed, GateOpen,
 PlayerOneDead, PlayerOneDead2, PlayerOneDead3, SkullWall1, SkullWall2, SkullWall3, Skull, WoodWallKey, MenuKey,
 Bloxinies, MenuLborder, MenuRborder, Menulives, Menulevel, Menubombs, Menuplayer, Chain, ChainPulled,
 MenuRbordergrass, MenuLbordergrass, MenuLBot, MenuBot, MenuRBot, MenuLTop, MenuTop, MenuRTop,
 MenuRbordergrassHalf, MenuLbordergrassHalf, MenuPress, MenuFor, MenuSingle, MenuMulti, MenuToQuit, F1Menu,
 i1, i2, i3, i4, i5, i6, i7, i8, i9, i0, {image 1,2,3 <> 8, 9,0}
 DirectionUp, DirectionRight, DirectionDown, DirectionLeft, Editor : ImageType;

 ImagePCX : PictureType;
 Back : PageType;
 Start, Endtime, Endtimefast : real;
 MapTitle : string;
 Noise, SinglePlayer, Debug : Boolean;
 lasttics, tics : integer; {benchmark/tics counter}

Procedure CycleObject(Direction : String);
Procedure AddObject;
Procedure ChangePalette;
Procedure print(x,y,color:integer; const s:string); {write text on screen}
Procedure DestroyApp; {Kills application, reset textmode}
Procedure ResetGame; {clear map, enemies, lives etc}
Function Str2Int(s:string):word;
Function Int2Str(L : LongInt) : string;
Function timer:real; {used for gametics/timer}
Procedure RestartGame;
Procedure RestartLevel;
Procedure EndLevel;
Function CheckMovement(x, y, Number : Integer; Initiator : String) : Boolean; {Checks if player/enemy/boulder can move,
number = playernumber. 9 is enemy}
Procedure BloxiUp(Number : Integer); {draws player up}
Procedure BloxiLeft(Number : Integer);
Procedure BloxiRight(Number : Integer);
Procedure BloxiDown(Number : Integer);
Procedure DrawLevel; {redraw level}
Procedure ChangeLives(s : string); {add, remove or redraw lives}
Procedure ShowMenu;
Procedure GamestateZeroKeys (Key : char); {Read the pressed keys}
Procedure GamestateOneKeys (Key : char); {Read the pressed keys}
Procedure RefreshScreen; {redraws map, gamestate to zero}
Procedure DrawEmpty(i, j : Integer); {draws empty spot}
Procedure DrawKey(i, j : Integer); {draws wall}
Procedure DrawBigWall(i, j : Integer); {draws wall}
Procedure DrawBigWallGrass(i, j : Integer);
Procedure DrawSmallWall(i, j : Integer); 
Procedure DrawSmallWallGrass(i, j : Integer); 
Procedure DrawBrick(i, j : Integer); 
Procedure DrawBrickGrate(i, j : Integer); 
Procedure DrawBrickBanner(i, j : Integer); 
Procedure DrawSkullWall(i, j : Integer); 
Procedure DrawCobwebDR(i, j : Integer); 
Procedure DrawCobwebDL(i, j : Integer); 
Procedure DrawCobwebUL(i, j : Integer); 
Procedure DrawCobwebUR(i, j : Integer); 
Procedure DrawHeart(i, j : Integer);
Procedure DrawBoulder(i, j : Integer);
Procedure DrawDiamond(i, j : Integer);
Procedure DrawSpider(i, j : Integer);
Procedure DrawShooter(i, j : Integer);
Procedure DrawPlayer(i, j : Integer);
Procedure DrawPlayerOne(i, j : Integer);
Procedure DrawPlayerTwo(i, j : Integer);
Procedure DrawExit(i, j : Integer);
Procedure DrawExitOpen(i, j : Integer);
Procedure DrawArrowLeft(i, j : Integer); {draws arrow from shooter}
Procedure DrawArrowRight(i, j : Integer);
Procedure DrawMouse(i, j, Number : Integer);
Procedure DrawBomb(i, j : Integer);
Procedure DrawBombFuse(i, j : Integer);
Procedure DrawBombFuse2(i, j : Integer);
Procedure DrawBombFuse3(i, j : Integer);
Procedure DrawBombFuse4(i, j : Integer);
Procedure DrawExplosion(i, j : Integer);
Procedure DrawExplosion2(i, j : Integer);
Procedure DrawWoodWall(i, j : Integer);
Procedure DrawWoodWallWindow(i, j : Integer);
Procedure DrawWoodWallKnots(i, j : Integer);
Procedure DrawDirectionUp(i, j : Integer);
Procedure DrawDirectionRight(i, j : Integer);
Procedure DrawDirectionDown(i, j : Integer);
Procedure DrawDirectionLeft(i, j : Integer);
Procedure DrawDemon(i, j : Integer);
Procedure DrawSkull(i, j : Integer);
Procedure DrawWoodWallKey(i, j : Integer);
Procedure DrawGateClosed(i, j : Integer);
Procedure DrawGateOpen(i, j : Integer);
Procedure DrawChain(i, j : Integer);
Procedure DrawChainPulled(i, j : Integer);
Procedure DrawObject(i, j : integer; Obj : string); {chooses which object to be drawn}
Procedure ReadMap(level : integer); {reads map from levels.dat}
Procedure GenerateObjects; {generate enemies etc.}
Procedure RemoveKeysFromHud;
Procedure DrawMap;
Procedure EndGameSequence;
Procedure DrawStartupMenu;
Procedure DrawHud;
Procedure TestMap(level : integer);
Procedure WriteMap(level : integer);
Procedure GenerateGraphics; {draw graphics in left corner and puts it in pointer}
Procedure ToggleSound;
Procedure ToggleDebug;
Procedure CycleSound;

Implementation

{Change the default VGA-palette to be able to use certain colors, i.e. brown for wood}
Procedure ChangePalette;
begin
{Wood}
 Palette.Red:=36;
 Palette.Green:=23;
 Palette.Blue:=13;
 SetPalette(211,Palette);
 Palette.Red:=29; 
 Palette.Green:=19;
 Palette.Blue:=10;
 SetPalette(212,Palette);
 Palette.Red:=27;
 Palette.Green:=18;
 Palette.Blue:=9;
 SetPalette(213,Palette);
 Palette.Red:=23;
 Palette.Green:=16;
 Palette.Blue:=8;
 SetPalette(214,Palette);
 Palette.Red:=21;
 Palette.Green:=15;
 Palette.Blue:=7;
 SetPalette(215,Palette);
 Palette.Red:=18;
 Palette.Green:=14;
 Palette.Blue:=6;
 SetPalette(216,Palette);
 Palette.Red:=14; 
 Palette.Green:=11;
 Palette.Blue:=5;
 SetPalette(218,Palette);
 Palette.Red:=10;
 Palette.Green:=8;
 Palette.Blue:=3;
 SetPalette(219,Palette);

 Palette.Red:=9; 
 Palette.Green:=0;
 Palette.Blue:=0;
 SetPalette(220,Palette);

 Palette.Red:=22;
 Palette.Green:=0;
 Palette.Blue:=0;
 SetPalette(221,Palette);
 Palette.Red:=38;
 Palette.Green:=12;
 Palette.Blue:=12;
 SetPalette(222,Palette);
 Palette.Red:=32;
 Palette.Green:=0;
 Palette.Blue:=0;
 SetPalette(223,Palette);
 Palette.Red:=63;
 Palette.Green:=15;
 Palette.Blue:=15;
 SetPalette(224,Palette);

 Palette.Blue:=6;
 Palette.Red:=52;
 Palette.Green:=0;
 SetPalette(225,Palette);
 Palette.Blue:=9;
 Palette.Red:=0;
 Palette.Green:=58;
 SetPalette(229,Palette);
 Palette.Blue:=0;
 Palette.Red:=63;
 Palette.Green:=54;
 SetPalette(233,Palette);

 Palette.Red:=0;
 Palette.Green:=38;
 Palette.Blue:=54;
 SetPalette(236,Palette);
 Palette.Red:=0;
 Palette.Green:=35;
 Palette.Blue:=58;
 SetPalette(237,Palette);

 Palette.Blue:=6;
 Palette.Red:=47;
 Palette.Green:=6;
 SetPalette(240,Palette);
 Palette.Blue:=0;
 Palette.Red:=40;
 Palette.Green:=20;
 SetPalette(241,Palette);
 Palette.Blue:=0;
 Palette.Red:=40;
 Palette.Green:=26;
 SetPalette(242,Palette);
 Palette.Blue:=0;
 Palette.Red:=40;
 Palette.Green:=23;
 SetPalette(243,Palette);
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=32;
 SetPalette(244,Palette);
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=29;
 SetPalette(245,Palette);
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=26;
 SetPalette(246,Palette);
 
 Palette.Blue:=0;
 Palette.Red:=45;
 Palette.Green:=23;
 SetPalette(247,Palette);
end;

{Bitmaps for capitol letters; made by Jozsef Laszlo. www.joco.homeserver.hu}
procedure chr6x7_dat; assembler;
asm
  db  $00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$20,$00,$20,$00,$50
  db  $50,$00,$00,$00,$00,$00,$50,$f8,$50,$50,$f8,$50,$00,$20,$f8,$a0
  db  $f8,$28,$f8,$00,$c8,$d0,$20,$20,$58,$98,$00,$40,$a0,$40,$a8,$90
  db  $68,$00,$20,$40,$00,$00,$00,$00,$00,$20,$40,$40,$40,$40,$20,$00
  db  $20,$10,$10,$10,$10,$20,$00,$50,$20,$f8,$20,$50,$00,$00,$20,$20
  db  $f8,$20,$20,$00,$00,$00,$00,$00,$60,$20,$40,$00,$00,$00,$f8,$00
  db  $00,$00,$00,$00,$00,$00,$00,$60,$60,$00,$00,$08,$10,$20,$40,$80
  db  $00,$70,$88,$98,$a8,$c8,$70,$00,$20,$60,$20,$20,$20,$70,$00,$70
  db  $88,$08,$70,$80,$f8,$00,$f8,$10,$30,$08,$88,$70,$00,$20,$40,$90
  db  $90,$f8,$10,$00,$f8,$80,$f0,$08,$88,$70,$00,$70,$80,$f0,$88,$88
  db  $70,$00,$f8,$08,$10,$20,$20,$20,$00,$70,$88,$70,$88,$88,$70,$00
  db  $70,$88,$88,$78,$08,$70,$00,$30,$30,$00,$00,$30,$30,$00,$30,$30
  db  $00,$30,$10,$20,$00,$00,$10,$20,$40,$20,$10,$00,$00,$f8,$00,$f8
  db  $00,$00,$00,$00,$20,$10,$08,$10,$20,$00,$70,$88,$10,$20,$00,$20
  db  $00,$70,$90,$a8,$b8,$80,$70,$00,$70,$88,$88,$f8,$88,$88,$00,$f0
  db  $88,$f0,$88,$88,$f0,$00,$70,$88,$80,$80,$88,$70,$00,$e0,$90,$88
  db  $88,$90,$e0,$00,$f8,$80,$f0,$80,$80,$f8,$00,$f8,$80,$f0,$80,$80
  db  $80,$00,$70,$88,$80,$98,$88,$70,$00,$88,$88,$f8,$88,$88,$88,$00
  db  $70,$20,$20,$20,$20,$70,$00,$10,$10,$10,$10,$90,$60,$00,$90,$a0
  db  $c0,$a0,$90,$88,$00,$80,$80,$80,$80,$80,$f8,$00,$88,$d8,$a8,$88
  db  $88,$88,$00,$88,$c8,$a8,$98,$88,$88,$00,$70,$88,$88,$88,$88,$70
  db  $00,$f0,$88,$88,$f0,$80,$80,$00,$70,$88,$88,$a8,$98,$70,$00,$f0
  db  $88,$88,$f0,$90,$88,$00,$70,$80,$70,$08,$88,$70,$00,$f8,$20,$20
  db  $20,$20,$20,$00,$88,$88,$88,$88,$88,$70,$00,$88,$88,$88,$88,$50
  db  $20,$00,$88,$88,$88,$a8,$a8,$50,$00,$88,$50,$20,$20,$50,$88,$00
  db  $88,$50,$20,$20,$20,$20,$00,$f8,$10,$20,$40,$80,$f8,$00,$60,$40
  db  $40,$40,$40,$60,$00,$00,$80,$40,$20,$10,$08,$00,$30,$10,$10,$10
  db  $10,$30,$00,$20,$50,$88,$00,$00,$00,$00,$00,$00,$00,$00,$00,$f8
  db  $00,$f8,$f8,$f8,$f8,$f8,$f8
end;

{Put character but renamed to avoid conflict with GRAPHICS.TPU}
procedure poetchar; assembler;
asm
   push si              { save registers }
   push di
   push cx

   sub  al,32           { we don't have the 1st 32 ascii chars }
   mov  ah,7
   mul  ah              { character bitmap offset = 7*charcode }

   lea  si,chr6x7_dat
   add  si,ax           { DS:si points to the bitmap }

   mov  cl,7
@l0:
   segCS lodsb          { next byte from the bitmap }
   mov  ch,6
@l1:
   shl  al,1            { shift out 1 bit }
   jnc  @skip
   mov  ES:[di],dl      { show the pixel }
@skip:
   inc  di
   dec  ch              { all pixels in a line }
   jnz  @l1
   add  di,320-6        { next line }
   dec  cl
   jnz  @l0             { all lines }

   pop  cx              { load registers back from the stack }
   pop  di
   pop  si
   retn                 { near return }
end;

{Writes string on screen using Poetchar}
procedure print(x,y,color:integer; const s:string); assembler;
asm
   mov  ES,SegA000      { Screen segment }
   mov  ax,320
   mul  y
   add  ax,x
   mov  di,ax           { Address calculation, store the result in DI }
   cld

   mov  dl,color.byte   { color to the DL }
   mov  bx,DS           { save DS         }
   lds  si,s            { source string   }
   lodsb
   mov  cl,al           { 1st byte : length }
   xor  ch,ch
   jcxz @quit           { quit if it's an empty string }

@chrloop:
   lodsb                { get next charcode }
   call near ptr poetchar{ show the char - near procedure call }
   add  di,6            { next screen position }
   loop @chrloop        { show all chars  }

@quit:
   mov  DS,bx           { restore DS      }
end;

Procedure DestroyApp; {Closes the application}
begin
 CloseGraph;
 TextColor(7);
 TextBackground(0);
 Gotoxy(1,1);
 Writeln('Thank you for playing Bloxinies II.');
end;

Procedure ResetGame; {Resets game variables, clears map}
var
 i, j : integer;
begin
Gamestate:=4;
 for i:=0 to 11 do
  begin
   for j:=0 to 16 do Map[i,j] :='A';
  end;

 for i:=0 to MaxEnemies do
  begin
   Enemy[i].Direction:='Right';
   Enemy[i].Enabled:=FALSE;
  end;

 for i:=0 to MaxBombs do
  begin
   Bomb[i].Enabled:=FALSE;
   Bomb[i].State:=0;
  end;

 {Reset total number of diamonds in map}
 Diamonds:=0;

 {First level}
 Level:=0;
 Lives:=3;
 Player[0].Delay:=0;
 Player[1].Delay:=0;
 Player[0].Bombs:=0;
 Player[1].Bombs:=0;
 Player[0].Finished:=FALSE;
 Player[1].Finished:=FALSE;
 Player[0].Key:=FALSE;
 Player[1].Key:=FALSE;

 Gamestate:=0;
end;

Function Str2Int(s:string):word; {Convert strings to integer}
var
 i, code : word;
begin
 val (s, i, code);
 if code <> 0 then Str2Int:=0 else Str2Int:=i;
end;

Function Int2Str(L : LongInt) : string; {Convert integer to string}
var
 s : string;
begin
 Str(L, S);
 Int2Str:=s;
end;

{Timer to move enemy every second}
Function timer:real;
var
 Hour, Minute, Second, Sec100 : word;
begin
 gettime(hour,minute,second,sec100);
 timer:=(hour*3600.0+minute*60.0+second+sec100/100)
end;

Procedure RestartGame; {Procedures needed to restart the game}
begin
 ResetGame;
 ChangeLives('Redraw');
 ReadMap(Level);
 DrawLevel;
 GenerateObjects;
 DrawMap;

 Gamestate:=0;
end;

Procedure RestartLevel; {Restart the current level}
var
 i : Integer;
begin
 for i:=0 to MaxBombs do
  begin
   Bomb[i].Enabled:=FALSE;
   Bomb[i].State:=0;
  end;
 Player[0].Bombs:=0;
 Player[1].Bombs:=0;
 Player[0].x:=0; {Set coordinates to 0 to avoid processing player data in running loops after a restart has been initiated}
 Player[0].y:=0; {i.e.: both player 0 and player 1 die due a bomb detonation; player 0 will initiate a restart and after}
 Player[1].x:=0; {everything has been redrawn, player 1 would initiate a restart again because the loop was still running}
 Player[1].y:=0;
 ReadMap(Level);
 ChangeLives('Remove');
 GenerateObjects;
 DrawMap;
 Gamestate:=0;
end;

Procedure Endlevel; {Start procedures to load next level}
begin
 Player[0].Finished:=FALSE;
 Player[1].Finished:=FALSE;
 Level:=Level+1;
 ReadMap(Level);
 DrawLevel;
 GenerateObjects;
 DrawMap;
 {Gamestate:=0;}
end;

{Checks if player, enemy or boulder is allowed to move to a certain area in the map}
{Returns FALSE if no movement is allowed}
Function CheckMovement(x, y, Number : Integer; Initiator : String) : Boolean;
var
 i : integer;
begin
 CheckMovement:=TRUE;
 {Can't move outside level}
 if (x > 11) or (x < 0) or (y < 0) or (y > 16) then CheckMovement:=FALSE;
end;

Procedure RedrawTiles(Number : Integer);
begin {Redraw Tiles after walking over them}
 if Map[Player[Number].x,Player[Number].y] = 'A' then DrawEmpty(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'B' then DrawBigWall(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'C' then DrawBigWallGrass(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'D' then DrawSmallWall(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'E' then DrawSmallWallGrass(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'F' then DrawKey(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'G' then DrawPlayer(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'H' then DrawPlayerTwo(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'I' then DrawDiamond(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'J' then DrawExit(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'K' then DrawSpider(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'L' then DrawMouse(Player[Number].x, Player[Number].y,127);
 if Map[Player[Number].x,Player[Number].y] = 'M' then DrawShooter(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'N' then DrawBoulder(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'O' then DrawHeart(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'P' then DrawWoodWall(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'Q' then DrawWoodWallKnots(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'R' then DrawWoodWallWindow(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'S' then DrawBomb(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'T' then DrawBrick(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'U' then DrawBrickGrate(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'V' then DrawBrickBanner(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'W' then DrawDirectionUp(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'X' then DrawDirectionRight(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'Y' then DrawDirectionDown(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = 'Z' then DrawDirectionLeft(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '1' then DrawDemon(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '2' then DrawSkullwall(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '3' then DrawWoodWallKey(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '4' then DrawGateClosed(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '5' then DrawGateOpen(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '6' then DrawChain(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '7' then DrawChainPulled(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '/' then DrawCobwebDR(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '\' then DrawCobwebDL(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '?' then DrawCobwebUL(Player[Number].x, Player[Number].y);
 if Map[Player[Number].x,Player[Number].y] = '|' then DrawCobwebUR(Player[Number].x, Player[Number].y);
end;

Procedure BloxiUp(Number : Integer); {Moves Bloxinies up and redraws direction arrows}
var
 i : Integer;
 BombDropped : Boolean;
begin
  if (CheckMovement(Player[Number].x-1, Player[Number].y,Number,'Human') = TRUE) then
  begin { Bloxi can move up}
   RedrawTiles(Number);

   Player[Number].x:=Player[Number].x-1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);

  end;
end;

Procedure BloxiLeft(Number : Integer);
var
 i : Integer;
 BombDropped : Boolean;
begin
  if (CheckMovement(Player[Number].x, Player[Number].y-1,Number, 'Human') = TRUE) then
  begin { Bloxi can move up}
   RedrawTiles(Number);   

   Player[Number].y:=Player[Number].y-1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);
   
  end;
end;

Procedure BloxiRight(Number : Integer);
var
 i : Integer;
 BombDropped : Boolean;
begin
 if (CheckMovement(Player[Number].x, Player[Number].y+1,Number, 'Human') = TRUE) then
  begin { Bloxi can move up}
   RedrawTiles(Number);
   Player[Number].y:=Player[Number].y+1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);
  
  end;
 end;

Procedure BloxiDown(Number : Integer);
var
 i : Integer;
 BombDropped : Boolean;
begin
  if (CheckMovement(Player[Number].x+1, Player[Number].y,Number, 'Human') = TRUE) then
  begin { Bloxi can move up}
   RedrawTiles(Number);
   Player[Number].x:=Player[Number].x+1;
   if Number = 0 then DrawPlayerOne(Player[Number].x,Player[Number].y)
    else DrawPlayerTwo(Player[Number].x,Player[Number].y);
   end;
end;

Procedure DrawNumber(Number : Integer; x, y : Integer); {draws a number, i.e. level-number}
begin
 case Number of
  0: PutImage(i0,x,y);
  1: PutImage(i1,x,y);
  2: PutImage(i2,x,y);
  3: PutImage(i3,x,y);
  4: PutImage(i4,x,y);
  5: PutImage(i5,x,y);
  6: PutImage(i6,x,y);
  7: PutImage(i7,x,y);
  8: PutImage(i8,x,y);
  9: PutImage(i9,x,y);
  10: begin PutImage(i1,x,y); PutImage(i0,x+4,y); end;
  11: begin PutImage(i1,x,y); PutImage(i1,x+4,y); end;
  12: begin PutImage(i1,x,y); PutImage(i2,x+4,y); end;
  13: begin PutImage(i1,x,y); PutImage(i3,x+4,y); end;
  14: begin PutImage(i1,x,y); PutImage(i4,x+4,y); end;
  15: begin PutImage(i1,x,y); PutImage(i5,x+4,y); end;
  16: begin PutImage(i1,x,y); PutImage(i6,x+4,y); end;
  17: begin PutImage(i1,x,y); PutImage(i7,x+4,y); end;
  18: begin PutImage(i1,x,y); PutImage(i8,x+4,y); end;
  19: begin PutImage(i1,x,y); PutImage(i9,x+4,y); end;
  20: begin PutImage(i2,x,y); PutImage(i0,x+4,y); end;
  21: begin PutImage(i2,x,y); PutImage(i1,x+4,y); end;
  22: begin PutImage(i2,x,y); PutImage(i2,x+4,y); end;
  23: begin PutImage(i2,x,y); PutImage(i3,x+4,y); end;
  24: begin PutImage(i2,x,y); PutImage(i4,x+4,y); end;
  25: begin PutImage(i2,x,y); PutImage(i5,x+4,y); end;
  26: begin PutImage(i2,x,y); PutImage(i6,x+4,y); end;
  27: begin PutImage(i2,x,y); PutImage(i7,x+4,y); end;
  28: begin PutImage(i2,x,y); PutImage(i8,x+4,y); end;
  29: begin PutImage(i2,x,y); PutImage(i9,x+4,y); end;
  30: begin PutImage(i3,x,y); PutImage(i0,x+4,y); end;
  31: begin PutImage(i3,x,y); PutImage(i1,x+4,y); end;
  32: begin PutImage(i3,x,y); PutImage(i2,x+4,y); end;
  33: begin PutImage(i3,x,y); PutImage(i3,x+4,y); end;
  34: begin PutImage(i3,x,y); PutImage(i4,x+4,y); end;
  35: begin PutImage(i3,x,y); PutImage(i5,x+4,y); end;
  36: begin PutImage(i3,x,y); PutImage(i6,x+4,y); end;
  37: begin PutImage(i3,x,y); PutImage(i7,x+4,y); end;
  38: begin PutImage(i3,x,y); PutImage(i8,x+4,y); end;
  39: begin PutImage(i3,x,y); PutImage(i9,x+4,y); end;
  40: begin PutImage(i4,x,y); PutImage(i0,x+4,y); end;
  41: begin PutImage(i4,x,y); PutImage(i1,x+4,y); end;
  42: begin PutImage(i4,x,y); PutImage(i2,x+4,y); end;
  43: begin PutImage(i4,x,y); PutImage(i3,x+4,y); end;
  44: begin PutImage(i4,x,y); PutImage(i4,x+4,y); end;
  45: begin PutImage(i4,x,y); PutImage(i5,x+4,y); end;
  46: begin PutImage(i4,x,y); PutImage(i6,x+4,y); end;
  47: begin PutImage(i4,x,y); PutImage(i7,x+4,y); end;
  48: begin PutImage(i4,x,y); PutImage(i8,x+4,y); end;
  49: begin PutImage(i4,x,y); PutImage(i9,x+4,y); end;
  50: begin PutImage(i5,x,y); PutImage(i0,x+5,y); end;
  51: begin PutImage(i5,x,y); PutImage(i1,x+5,y); end;
  52: begin PutImage(i5,x,y); PutImage(i2,x+5,y); end;
  53: begin PutImage(i5,x,y); PutImage(i3,x+5,y); end;
  55: begin PutImage(i5,x,y); PutImage(i4,x+5,y); end;
  55: begin PutImage(i5,x,y); PutImage(i5,x+5,y); end;
  56: begin PutImage(i5,x,y); PutImage(i6,x+5,y); end;
  57: begin PutImage(i5,x,y); PutImage(i7,x+5,y); end;
  58: begin PutImage(i5,x,y); PutImage(i8,x+5,y); end;
  59: begin PutImage(i5,x,y); PutImage(i9,x+5,y); end;
 end;
end;

Procedure DrawLevel; {Draw active level in menu bar}
begin
 SetColor(0);
 Bar(32,24,36,30);
 DrawNumber(Level+1,28,24);
end;

Procedure ChangeLives(s : string); {Redraw number of lives in the menu}
begin
 if not (s = 'Redraw') then
  begin
   if (s = 'Add') then Lives:=Lives+1;
   if (s = 'Remove') then Lives:=Lives-1;
  end;
 DrawNumber(Lives,28,32);
end;

Procedure ShowMenu; {Shows the in-game menu when F1 is pressed}
var
i : Integer;
begin
 GameState:=1;
 InitPage(Back);
 SetActivePage(Back);
 DrawHud;
 SetColor(0);
 Bar(78,48,256,152);
 PutImage(MenuLTop,80,48);
 PutImage(MenuRTop,256,48);
 PutImage(MenuLBot,80,144);
 PutImage(MenuRBot,256,144);
 for i:=6 to 15 do
  begin
   PutImage(MenuTop,16*i,48);
   PutImage(MenuBot,16*i,144);
  end;

  for i:=4 to 8 do
   begin
    PutImage(MenuLBorder,80,16*i);
    PutImage(MenuRBorder,256,16*i);
    if i=6 then PutImage(MenuLBordergrass,80,16*i);
    if i=6 then PutImage(MenuRBordergrass,256,16*i);
   end;
   CopyPageToVGA(Back);
  SetActivePage(TheScreen);
  KillPage(Back);
 Print(120,55,10,'BLOXINIES II MENU');
 Print(95,70,30,'   F1: THIS MENU');
 Print(95,80,30,'   F2: RESTART LEVEL');
 Print(95,90,30,'   F3: START NEW GAME');
 Print(95,100,30,'   F4: TOGGLE SOUND');
 Print(95,110,30,'   F8: BACK TO GAME');
 Print(95,135,30,'ESQ/Q: BACK TO MENU');

end;

Procedure GamestateZeroKeys (Key : char); {Read the pressed keys}
begin
 case Key of
  'H': BloxiUp(0);
  'K': BloxiLeft(0);
  'M': BloxiRight(0);
  'P': BloxiDown(0);
  {'w': BloxiUp(1);
  'a': BloxiLeft(1);
  'd': BloxiRight(1);
  's': BloxiDown(1);
  'W': BloxiUp(1);
  'A': BloxiLeft(1);
  'D': BloxiRight(1);
  'S': BloxiDown(1);}
  #32: AddObject;
  'D': Map[Player[0].x, Player[0].y] := 'A';
  'd': Map[Player[0].x, Player[0].y] := 'A';
  '[': CycleObject('Left');
  ']': CycleObject('Right');
  '+': EndLevel;
  ';': ShowMenu;
  #59: ShowMenu;
  #60: RestartLevel;
  #61: RestartGame;
  #62: ToggleSound;
  #27: ShowMenu;
  's': WriteMap(Level);
  'S': WriteMap(Level);
  't': TestMap(Level);
  'T': TestMap(Level);
  end;
end;

Procedure CycleObject(Direction : String);
var
Objects : Array [0..36] of String[1];
begin
 Objects[0]:='A';
 Objects[1]:='B';
 Objects[2]:='C';
 Objects[3]:='D';
 Objects[4]:='E';
 Objects[5]:='F';
 Objects[6]:='G';
 Objects[7]:='H';
 Objects[8]:='I';
 Objects[9]:='J';
 Objects[10]:='K';
 Objects[11]:='L';
 Objects[12]:='M';
 Objects[13]:='N';
 Objects[14]:='O';
 Objects[15]:='P';
 Objects[16]:='Q';
 Objects[17]:='R';
 Objects[18]:='S';
 Objects[19]:='T';
 Objects[20]:='U';
 Objects[21]:='V';
 Objects[22]:='W';
 Objects[23]:='X';
 Objects[24]:='Y';
 Objects[25]:='Z';
 Objects[26]:='1';
 Objects[27]:='2';
 Objects[28]:='3';
 Objects[29]:='4';
 Objects[30]:='5';
 Objects[31]:='6';
 Objects[32]:='7';
 Objects[33]:='/';
 Objects[34]:='\';
 Objects[35]:='?';
 Objects[36]:='|';

 
 if (Direction = 'Right') then
  begin
   if Noise = TRUE then CycleSound;
   if ActiveObjectNumber >= 0 then ActiveObjectNumber:=ActiveObjectNumber-1;
   if ActiveObjectNumber < 0 then ActiveObjectNumber:=36;
   ActiveObject:=Objects[ActiveObjectNumber];
   if ActiveObjectNumber = 0 then
    begin
     DrawObject(8,-1,Objects[ActiveObjectNumber+35]);
    end
    else
    begin
     DrawObject(8,-1,Objects[ActiveObjectNumber-1]);
    end;
   DrawObject(8,-2,Objects[ActiveObjectNumber]);
   DrawObject(8,-3,Objects[ActiveObjectNumber+1]);
  end;
  
 if (Direction = 'Left') then
  begin
   if Noise = TRUE then CycleSound;
   if ActiveObjectNumber < 36 then ActiveObjectNumber:=ActiveObjectNumber+1;
   if ActiveObjectNumber = 36 then ActiveObjectNumber:=0;
   ActiveObject:=Objects[ActiveObjectNumber];
   if ActiveObjectNumber = 0 then
    begin
     DrawObject(8,-1,Objects[ActiveObjectNumber+35]);
    end
    else
    begin
     DrawObject(8,-1,Objects[ActiveObjectNumber-1]);
    end;
   DrawObject(8,-2,Objects[ActiveObjectNumber]);
   DrawObject(8,-3,Objects[ActiveObjectNumber+1]);
  end;
  
 if (Direction = 'Center') then
  begin
  ActiveObject:=Objects[ActiveObjectNumber];
   if ActiveObjectNumber = 0 then
    begin
     DrawObject(8,-1,Objects[ActiveObjectNumber+35]);
    end
    else
    begin
     DrawObject(8,-1,Objects[ActiveObjectNumber-1]);
    end;
   DrawObject(8,-2,Objects[ActiveObjectNumber]);
   DrawObject(8,-3,Objects[ActiveObjectNumber+1]);
  end; 
end;

Procedure AddObject;
begin
 Map[Player[0].x, Player[0].y]:=ActiveObject;
end;

Procedure GamestateOneKeys (Key : char); {Read the pressed keys}
begin
 case Key of
 #62: ToggleSound;
 #66: RefreshScreen;
 #68: ToggleDebug;
 #27: DrawStartupMenu;
 'q': DrawStartupMenu;
 'Q': DrawStartupMenu;
 end;
end;

Procedure RefreshScreen;
begin
 DrawMap; {Redraw the map}
 Gamestate:=0; {Play the game}
 
 {Draw map editor lines}
 SetColor(10);
 Line(16,126,32,126);
 Line(16,145,32,145);
 Print(1,116,25,'TILE:[]');
 CycleObject('Center');
 
 {Redraw player on coordinates if player is not finished}
 if not (Player[0].Finished=True) then PutImage(BloxiPlayerOne,48+(Player[0].y*16),0+(Player[0].x*16));
  {Redraw second player}
 if ((Singleplayer=FALSE) and not (Player[1].Finished=True))
 then PutImage(BloxiPlayerTwo,48+(Player[1].y*16),0+(Player[1].x*16));
end;

Procedure DrawEmpty(i, j : Integer);
begin
 PutImage(EmptyTile,48+(j*16),0+(i*16));
end;

Procedure DrawBigWall(i, j : Integer);
begin
 PutImage(BigWall,48+(j*16),0+(i*16));
end;

Procedure DrawBigWallGrass(i, j : Integer);
begin
 PutImage(BigWallGrass,48+(j*16),0+(i*16));
end;

Procedure DrawSmallWall(i, j : Integer);
begin
 PutImage(SmallWall,48+(j*16),0+(i*16));
end;

Procedure DrawSmallWallGrass(i, j : Integer);
begin
 PutImage(SmallWallGrass,48+(j*16),0+(i*16));
end;

Procedure DrawKey(i, j : Integer);
begin
 PutImage(Key,48+(j*16),0+(i*16));
end;

Procedure DrawPlayer(i, j : Integer);
begin
{Draw Empty tile is game is not running. Using this the player won't be drawn when leaving the ingame menu}
 if Gamestate = 0 then
  begin
   PutImage(BloxiPlayerOne,48+(j*16),0+(i*16));
   {Player[0].x:=i;
   Player[0].y:=j;}
  end else
   begin
    PutImage(EmptyTile,48+(j*16),0+(i*16));
   end;
end;

Procedure DrawPlayerOne(i, j : Integer);
begin
{Draw Empty tile is game is not running. Using this the player won't be drawn when leaving the ingame menu}
 if Gamestate = 0 then
  begin
   PutImage(Editor,48+(j*16),0+(i*16));
   {Player[0].x:=i;
   Player[0].y:=j;}
  end else
   begin
    PutImage(EmptyTile,48+(j*16),0+(i*16));
   end;
end;

Procedure DrawPlayerTwo(i, j : Integer);
begin
 if Gamestate = 0 then
  begin
   PutImage(BloxiPlayerTwo,48+(j*16),0+(i*16));
   {Player[1].x:=i;
   Player[1].y:=j;}
  end else
   begin
    PutImage(EmptyTile,48+(j*16),0+(i*16));
   end;
end;

Procedure DrawDiamond(i, j : Integer);
var
 Number : Integer;
begin
 Number:=(Random(20));
 if Number < 10 then PutImage(Diamond,48+(j*16),0+(i*16)) else
 PutImage(Diamond2,48+(j*16),0+(i*16));
end;

Procedure DrawExit(i, j : Integer);
begin
 PutImage(Exit,48+(j*16),0+(i*16));
end;

Procedure DrawExitOpen(i, j : Integer);
begin
 PutImage(ExitOpen,48+(j*16),0+(i*16));
end;

Procedure DrawSpider(i, j : Integer);
begin
 PutImage(Spider,48+(j*16),0+(i*16));
end;

Procedure DrawMouse(i, j, Number : Integer);
begin
 if Enemy[Number].Animation = 0 then PutImage(Mouse,48+(j*16),0+(i*16));
 if Enemy[Number].Animation = 1 then PutImage(Mouse2,48+(j*16),0+(i*16));
 if Enemy[Number].Animation = 2 then PutImage(Mouse3,48+(j*16),0+(i*16));
 if Enemy[Number].Animation = 3 then PutImage(Mouse2,48+(j*16),0+(i*16));
 Enemy[Number].Animation:=Enemy[Number].Animation+1;
 if Enemy[Number].Animation > 3 then Enemy[Number].Animation:=0;
end;

Procedure DrawShooter(i, j : Integer);
begin
 PutImage(Shooter,48+(j*16),0+(i*16));
end;

Procedure DrawBoulder(i, j : Integer);
begin
 PutImage(Boulder,48+(j*16),0+(i*16));
end;

Procedure DrawArrowLeft(i, j : Integer);
begin
 PutImage(ArrowLeft,48+(j*16),0+(i*16));
end;

Procedure DrawArrowRight(i, j : Integer);
begin
 PutImage(ArrowRight,48+(j*16),0+(i*16));
end;

Procedure DrawHeart(i, j : Integer);
begin
 PutImage(Heart,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWall(i, j : Integer);
begin
 PutImage(WoodWall,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWallKnots(i, j : Integer);
begin
 PutImage(WoodWallKnots,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWallWindow(i, j : Integer);
begin
 PutImage(WoodWallWindow,48+(j*16),0+(i*16));
end;

Procedure DrawBomb(i, j : Integer);
begin
 PutImage(BombItem,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse(i, j : Integer);
begin
 PutImage(BombFuse,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse2(i, j : Integer);
begin
 PutImage(BombFuse2,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse3(i, j : Integer);
begin
 PutImage(BombFuse3,48+(j*16),0+(i*16));
end;

Procedure DrawBombFuse4(i, j : Integer);
begin
 PutImage(BombFuse4,48+(j*16),0+(i*16));
end;

Procedure DrawExplosion(i, j : Integer);
begin
 PutImage(Explode,48+(j*16),0+(i*16));
end;

Procedure DrawExplosion2(i, j : Integer);
begin
 PutImage(Explode2,48+(j*16),0+(i*16));
end;

Procedure DrawBrick(i, j : Integer);
begin
 PutImage(Brick,48+(j*16),0+(i*16));
end;

Procedure DrawBrickGrate(i, j : Integer);
begin
 PutImage(BrickGrate,48+(j*16),0+(i*16));
end;

Procedure DrawBrickBanner(i, j : Integer);
begin
 PutImage(BrickBanner,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionUp(i, j : Integer);
begin
 PutImage(DirectionUp,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionRight(i, j : Integer);
begin
 PutImage(DirectionRight,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionDown(i, j : Integer);
begin
 PutImage(DirectionDown,48+(j*16),0+(i*16));
end;

Procedure DrawDirectionLeft(i, j : Integer);
begin
 PutImage(DirectionLeft,48+(j*16),0+(i*16));
end;

Procedure DrawDemon(i, j : Integer);
begin
 PutImage(Demon,48+(j*16),0+(i*16));
end;

Procedure DrawSkullwall(i, j : Integer);
begin
 PutImage(Skullwall1,48+(j*16),0+(i*16));
end;

Procedure DrawSkull(i, j : Integer);
begin
 PutImage(Skull,48+(j*16),0+(i*16));
end;

Procedure DrawWoodWallKey(i, j : Integer);
begin
 PutImage(WoodWallKey,48+(j*16),0+(i*16));
end;

Procedure DrawGateClosed(i, j : Integer);
begin
 PutImage(GateClosed,48+(j*16),0+(i*16));
end;

Procedure DrawGateOpen(i, j : Integer);
begin
 PutImage(GateOpen,48+(j*16),0+(i*16));
end;

Procedure DrawChain(i, j : Integer);
begin
 PutImage(Chain,48+(j*16),0+(i*16));
end;

Procedure DrawChainPulled(i, j : Integer);
begin
 PutImage(ChainPulled,48+(j*16),0+(i*16));
end;

Procedure DrawCobwebDR(i, j : Integer);
begin {Down right}
 MirrorImage(Cobweb);
 PutImage(Cobweb,48+(j*16),0+(i*16));
 MirrorImage(Cobweb);
end;

Procedure DrawCobwebDL(i, j : Integer);
begin {Down left}
 PutImage(Cobweb,48+(j*16),0+(i*16));
end;

Procedure DrawCobwebUR(i, j : Integer);
begin {Up right}
 MirrorImage(Cobweb);
 FlipImage(Cobweb);
 PutImage(Cobweb,48+(j*16),0+(i*16));
 FlipImage(Cobweb);
 MirrorImage(Cobweb);
end;

Procedure DrawCobwebUL(i, j : Integer);
begin {Up left}
 FlipImage(Cobweb);
 PutImage(Cobweb,48+(j*16),0+(i*16));
 FlipImage(Cobweb);
end;

Procedure DrawObject(i, j : integer; Obj : string); {Draws the object found on the map-file}
begin
 if Obj = 'A' then DrawEmpty(i,j);
 if Obj = 'B' then DrawBigWall(i,j);
 if Obj = 'C' then DrawBigWallGrass(i,j);
 if Obj = 'D' then DrawSmallWall(i,j);
 if Obj = 'E' then DrawSmallWallGrass(i,j);
 if Obj = 'F' then DrawKey(i,j);
 if Obj = 'G' then DrawPlayer(i,j);
 if Obj = 'H' then DrawPlayerTwo(i,j);
 if Obj = 'I' then DrawDiamond(i,j);
 if Obj = 'J' then DrawExit(i,j);
 if Obj = 'K' then DrawSpider(i,j);
 if Obj = 'L' then DrawMouse(i,j,127);
 if Obj = 'M' then DrawShooter(i,j);
 if Obj = 'N' then DrawBoulder(i,j);
 if Obj = 'O' then DrawHeart(i,j);
 if Obj = 'P' then DrawWoodWall(i,j);
 if Obj = 'Q' then DrawWoodWallKnots(i,j);
 if Obj = 'R' then DrawWoodWallWindow(i,j);
 if Obj = 'S' then DrawBomb(i,j);
 if Obj = 'T' then DrawBrick(i,j);
 if Obj = 'U' then DrawBrickGrate(i,j);
 if Obj = 'V' then DrawBrickBanner(i,j);
 if Obj = 'W' then DrawDirectionUp(i,j);
 if Obj = 'X' then DrawDirectionRight(i,j);
 if Obj = 'Y' then DrawDirectionDown(i,j);
 if Obj = 'Z' then DrawDirectionLeft(i,j);
 if Obj = '1' then DrawDemon(i,j);
 if Obj = '2' then DrawSkullwall(i,j);
 if Obj = '3' then DrawWoodWallKey(i,j);
 if Obj = '4' then DrawGateClosed(i,j);
 if Obj = '5' then DrawGateOpen(i,j);
 if Obj = '6' then DrawChain(i,j);
 if Obj = '7' then DrawChainPulled(i,j);
 if Obj = '/' then DrawCobwebDR(i,j);
 if Obj = '\' then DrawCobwebDL(i,j);
 if Obj = '?' then DrawCobwebUL(i,j);
 if Obj = '|' then DrawCobwebUR(i,j);
end;

Procedure ReadMap(level : integer); {Read a map, param1 for singleplayer maps, param2 for multiplayer maps}
var
 Row, SingleMaps, MultiMaps : string;
 f : text;
 i,j : integer;
begin
 SingleMaps:='LEVSINGLE.DAT';
 MultiMaps:='LEVMULTI.DAT';
 if not (ParamStr(1) = '') then SingleMaps:=ParamStr(1);
 if not (ParamStr(2) = '') then MultiMaps:=ParamStr(2);
 if (SinglePlayer=TRUE) then Assign(f,SingleMaps) else Assign(f,MultiMaps);
 Reset(f);
 for j:=0 to level*13 do
  begin {Read ahead on file to select correct level}
   Readln(f,MapTitle);
   if (MapTitle = '') then Gamestate:=4;
  end;
 j:=0;
 Repeat
 Readln(f,Row);
  for i:=0 to 16 do
   begin
    Map[j,i]:=Copy(Row,i+1,1);
   end;
 Inc(j);
 Until j=13;
 ActiveObject:='A';
 Player[0].Bombs:=0; {The ReadMap code seems to add one bomb/delay for players}
 Player[1].Bombs:=0; {Can't find out why it does that so just set it back to 0 manually}
 DrawNumber(Player[0].Bombs,28,56);
 if (SinglePlayer = FALSE) then DrawNumber(Player[1].Bombs,28,80);
 Player[0].Delay:=0;
 Player[1].Delay:=0;
 Player[0].Finished:=FALSE;
 Player[1].Finished:=FALSE;
 Player[0].Key:=FALSE;
 Player[1].Key:=FALSE;
 Player[0].x:=0; {force coordinates for editor-movement}
 Player[0].y:=0;
 Close(f);
end;

Procedure WriteMap(level : integer);
var
 Row, SingleMaps, MultiMaps : string;
 f : text;
 i, j : integer;
 Readlevel, Readmap : Integer;
 Color : Integer;
 NoMoreLevels : Boolean;
begin
 {Write the current map to file}
 {This function will read the existing map file and write it back to file,
  except for the current level which will be written from memory.}
 
 {Clear temp map}
 Color:=10;
 Print(1,192,Color,'SAVING MAP');
 
 assign(f,'BLOXTEMP.MAP'); rewrite(f);
 close(f);
 
 NoMoreLevels:=FALSE;
 SingleMaps:='LEVSINGLE.DAT';
 MultiMaps:='LEVMULTI.DAT';
 if not (ParamStr(1) = '') then SingleMaps:=ParamStr(1);
 if not (ParamStr(2) = '') then MultiMaps:=ParamStr(2);
 if (SinglePlayer=TRUE) then Assign(f,SingleMaps) else Assign(f,MultiMaps);
 Readlevel:=0;
 
 {Read map in file, until file ends}
 
 repeat
 If Color > 240 then Color:=5;
 Color:=Color+10;
 Print(1,192,Color,'SAVING MAP');
 
 if (SinglePlayer=TRUE) then Assign(f,SingleMaps) else Assign(f,MultiMaps);
 Reset(f);
 for j:=0 to Readlevel*13 do
  begin {Read ahead on file to select correct level}
   Readln(f,MapTitle);
   if (MapTitle = '') then Gamestate:=4;
  end;
 j:=0;
 Repeat
 Readln(f,Row);
  for i:=0 to 16 do
   begin
    MapCopy[j,i]:=Copy(Row,i+1,1);
   end;
 Inc(j);
 Until j=13;
 Close(f);
  
 if ((Readlevel = Level) and (Gamestate=0)) then
  begin
  {readlevel is gelijk aan actieve level dus custom map-data writen}
  assign(f,'BLOXTEMP.MAP'); append(f);
   writeln(f,'Level ',+readlevel+1);
   j:=0;
   Repeat
   for i:=0 to 16 do
    begin
     if not (i=16) then write(f,Map[j,i]) else writeln(f,Map[j,i]);
    end;
    Inc(j);
    Until j=12;
 close(f);
  end;
  
if not (Readlevel = Level) and (Gamestate=0) then
  begin
  {readlevel is niet gelijk dus level inlezen uit file en schrijven}
  
 {schrijven}
 assign(f,'BLOXTEMP.MAP'); append(f);
   writeln(f,'Level ',+readlevel+1);
   j:=0;
   Repeat
   for i:=0 to 16 do
    begin
     if not (i=16) then write(f,MapCopy[j,i]) else writeln(f,MapCopy[j,i]);
    end;
    Inc(j);
    Until j=12;
 close(f);
 end;

 Readlevel:=Readlevel+1;
 until Gamestate=4;

{Erase current map file}
if (SinglePlayer=TRUE) then Assign(f,SingleMaps) else Assign(f,MultiMaps);
Erase(f);
Assign(f, 'BLOXTEMP.MAP');
if (SinglePlayer=TRUE) then Rename(f, SingleMaps) else Rename(f, MultiMaps);
Gamestate:=4;
end;

Procedure TestMap(level : integer);
var
 f : text;
 SingleMaps, MultiMaps, PCXFile : string;
begin
 {Write the map}
 WriteMap(Level);
 
 {Exit Bloxinies II editor and write the continuing batch }
 {Determine single or multiplayer map parameters}
 SingleMaps:='LEVSINGLE.DAT';
 MultiMaps:='LEVMULTI.DAT';
 if not (ParamStr(1) = '') then SingleMaps:=ParamStr(1);
 if not (ParamStr(2) = '') then MultiMaps:=ParamStr(2);
 
 {Determine specified graphics file}
 if not (ParamStr(3) = '') then PCXFile:=ParamStr(3) else PCXFile:='BLOXII.GFX';
 
 assign(f,'APPBATCH.BAT'); rewrite(f);
 if SinglePlayer=TRUE then writeln(f, '@BLOXII '+SingleMaps+' '+MultiMaps+' '+PCXFile+' '+Int2Str(level)+' X Editor')
 else writeln(f, '@BLOXII '+SingleMaps+' '+MultiMaps+' '+PCXFile+' 0 '+Int2Str(level)+' Editor');
 close(f);
 
 DestroyApp;
 Halt;
end;

Procedure GenerateObjects; {Checks map for enemies and puts them in the enemy-array}
var
 i, j, k : integer;
 RunOnce : Boolean;
begin
 {Reset enemies and diamonds}
 i:=0;
 for i:=0 to MaxEnemies do
  begin
   Enemy[i].DirectionLast3:=''; {Last is needed for mouse panic-move}
   Enemy[i].DirectionLast2:='';
   Enemy[i].DirectionLast1:='';
   Enemy[i].Direction:='Up';
   Enemy[i].Enabled:=FALSE;
   Enemy[i].Species:=0;
   Enemy[i].Animation:=0;
  end;

 i:=0;
 for i:=0 to MaxBombs do
  begin
   Bomb[i].Enabled:=FALSE;
  end;
i:=0;
Diamonds:=0;

for i:=0 to 11 do
 begin
  for j:=0 to 16 do
   begin
     if (Map[i,j] = 'I') then
      begin {Diamond}
       Diamonds:=Diamonds+1;
      end;

     if (Map[i,j] = 'K') then
      begin {Spider}
       RunOnce:=FALSE;
       for k:=0 to MaxEnemies do
        begin
         if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
          begin
	   RunOnce:=TRUE;
           Enemy[k].x:=i;
           Enemy[k].y:=j;
           Enemy[k].Enabled:=TRUE;
           Enemy[k].Species:=7;
           Enemy[k].Direction:='Right';
           {Map[i,j]:='K';}
          end;
        end;
      end; {Spider end}

     if (Map[i,j] = 'L') then
      begin {Mouse}
       RunOnce:=FALSE;
       for k:=0 to MaxEnemies do
        begin
         if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
          begin
	   RunOnce:=TRUE;
           Enemy[k].x:=i;
           Enemy[k].y:=j;
           Enemy[k].Enabled:=TRUE;
           Enemy[k].Species:=9;
           Enemy[k].Direction:='Up';
           {Map[i,j]:='A';}
          end;
        end;
      end; {Mouse end}

      if (Map[i,j] = 'M') then
	begin {Shooter}
        RunOnce:=FALSE;
	 for k:=0 to MaxEnemies do
	  begin
	   if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
	    begin
             RunOnce:=TRUE;
             Enemy[k].x:=i;
             Enemy[k].y:=j;
             Enemy[k].Enabled:=TRUE;
             Enemy[k].Species:=8;
            end;
	  end;
         end; {Shooter end}

       if (Map[i,j] = '1') then
	begin {Demon}
        RunOnce:=FALSE;
	 for k:=0 to MaxEnemies do
	  begin
	   if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
	    begin
             RunOnce:=TRUE;
             Enemy[k].x:=i;
             Enemy[k].y:=j;
             Enemy[k].Enabled:=TRUE;
             Enemy[k].Species:=6;
            end;
	  end;
         end; {Demon end}

      if (Map[i,j] = '2') then
	begin {Skullwall}
        RunOnce:=FALSE;
	 for k:=0 to MaxEnemies do
	  begin
	   if (Enemy[k].Enabled = FALSE) and (RunOnce = FALSE) then
	    begin
             RunOnce:=TRUE;
             Enemy[k].x:=i;
             Enemy[k].y:=j;
             Enemy[k].Enabled:=TRUE;
             Enemy[k].Species:=5;
	     Enemy[k].Animation:=1;
            end;
	  end;
         end; {Skullwall end}
   end;
 end;
end;

Procedure RemoveKeysFromHud; {Removes the key image from the HUD}
begin
 SetColor(0);
 Bar(32,50,42,55);
 Bar(32,74,42,79);
end;

Procedure DrawMap;
var
 i, j : integer;
begin
for i:=0 to 11 do
 begin
  for j:=0 to 16 do
   begin
    DrawObject(i,j,Map[i,j]);
   end;
 end;
 
{Remove the keys after a map has been redrawn}
RemoveKeysFromHud;
DrawPlayerOne(Player[0].x, Player[0].y); {Draw editor-movement}
end;

Procedure DrawInstructions;
var
i : Integer;
begin
{Instructions I}
ClearScreen;
Print(70,0,10,'BLOXINIES II EDITOR INSTRUCTIONS');
Print(1,10,29,'EDITOR-MOVEMENT');
Print(1,20,25,'THE EDITOR BLOCK CAN MOVE AROUND USING THE ARROW KEYS');
PutImage(Editor,303,30);

Print(1,40,29,'OBJECT SELECTION');
Print(1,50,25,'USE THE [ AND ] KEY TO SELECT OBJECTS. ');

Print(1,70,29,'OBJECT PLACEMENT');
Print(1,80,25,'BY PRESSING SPACEBAR YOU CAN PLACE THE SELECTED OBJECT');
Print(1,90,25,'ONTO THE MAP. TO REMOVE AN OBJECT YOU HAVE TO PLACE AN');
Print(1,100,25,'EMPTY OBJECT ON THE MAP OR PRESS D.');

Print(1,120,29,'SAVE AND/OR TEST THE MAP');
Print(1,130,25,'PRESS S TO SAVE THE MAP.');
Print(1,140,25,'PRESS T TO SAVE AND TEST THE MAP.');

Print(1,160,29,'MAP SELECTION');
Print(1,170,25,'PRESS + TO SKIP TO THE NEXT MAP. PRESS = TO RETURN');
Print(1,180,25,'TO THE FIRST MAP.');

{Print(1,190,10,'PRESS ENTER TO CONTINUE...');}

Repeat

until KeyPressed;

end;

Procedure EndGameSequence;

begin
 
Gamestate:=2;
end;

Procedure DrawStartupMenu;
var
 i, j : integer;
begin
ResetGame; {Clears map and removes any left-over player data when accessing menu after playing}
Gamestate:=0;
While KeyPressed do Readkey;
ClearScreen;
InitPage(Back);	{paging}
SetActivePage(Back);	{paging}
 for i:=4 to 10 do
  begin
   PutImage(MenuLborder,80,8+16*i);
   PutImage(MenuRborder,224,8+16*i);
   PutImage(MenuTop,48+(16*i),56);
   if (i=6) or (i=9) then PutImage(MenuLbordergrassHalf,80,8+16*i);
   if (i=6) or (i=9) then PutImage(MenuRbordergrassHalf,224,8+16*i);
   PutImage(BigWall, 32,16*i+8);
   PutImage(BigWall, 272,16*i+8);
  end;

PutImage(BigWallGrass,32,56);
PutImage(BigWall,16,56);
PutImage(BigWall,48,56);
PutImage(BigWall,272,56);
PutImage(BigWall,256,56);
PutImage(BigWall,288,56);
PutImage(MenuTop,96,56);
PutImage(MenuLTop,80,56);
PutImage(MenuRTop,224,56);

for i:=0 to 19 do
 begin
  PutImage(BigWall,16*i,184);
  if (i=4) or (i=13) then PutImage(BigWallGrass,16*i,184);
 end;

PutImage(Cobweb,288,169);
FlipImage(Cobweb);
PutImage(Cobweb,48,72);
{Flipping the cobweb back later}

DrawPlayerTwo(11,3);
DrawEmpty(11,4);
DrawEmpty(11,5);
DrawEmpty(11,6);
DrawEmpty(11,7);
DrawEmpty(11,8);
DrawEmpty(11,9);
DrawEmpty(11,10);


PutImage(Bloxinies,140,4);
PutImage(BigWall,120,0);
PutImage(BigWall,128,16);
PutImage(BigWall,144,16);
PutImage(BigWallGrass,160,16);
PutImage(BigWall,176,16);
PutImage(BigWall,184,0);
PutImage(Grass,32,40);
PutImage(Grass,256,168);

CopyPageToVGA(Back);	{paging}
SetActivePage(TheScreen);	{paging}
Print(96,88,21,'BLOXINIES II EDITOR');
Print(96,104,28,'S'); Print(102,104,21,'INGLEPLAYER MAPS');
Print(96,112,28,'M'); Print(102,112,21,'ULTIPLAYER MAPS');
Print(96,120,28,'I'); Print(102,120,21,'NSTRUCTIONS');
Print(96,128,28,'Q'); Print(102,128,21,'UIT');
KillPage(Back);	{paging}

{Define player coordinates for moving player}
Player[1].y:=3;
Player[1].x:=11;
i:=0;
j:=0;
FlipImage(Cobweb); {Flip it back to original}
Repeat
 if timer >= endtime then {Normal tic-cycle}
  begin
   start:=timer;
   endtime:=start+gametime;
   if (Player[1].y > 9) then i:=1;
   if (Player[1].y < 4) then i:=0;
   if i=1 then BloxiLeft(1) else BloxiRight(1);
  end;

 if timer >= endtimefast then {fast tic-cycle}
  begin
   start:=timer;
   endtimefast:=start+gametimefast;
   if j mod 2 = 0 then PutImage(Grass,32,40) else PutImage(Grass2,32,40);
   if j mod 2 = 0 then PutImage(Grass,256,168) else PutImage(Grass2,256,168);
   j:=j+1;
   if j > 9 then j:=0;
  end;

  until Keypressed;
 case Readkey of
'S' : SinglePlayer:=TRUE;
'M' : SinglePlayer:=FALSE;
'm' : SinglePlayer:=FALSE;
's' : SinglePlayer:=TRUE;
'I' : begin DrawInstructions; Gamestate:=2; end; {Set gamestate=1 to avoid double clearscreen/resetgame}
'i' : begin DrawInstructions; Gamestate:=2; end;
'Q' : Gamestate:=3;
'q' : Gamestate:=3;
#27 : Gamestate:=3;
#13 : Gamestate:=2;
End;

 if (Gamestate = 0) then
  begin {Only start loading game when gamestate is 0. StartupMenu can define
  gamestate as 3 disabling the need to load up the game and immediately quit }
   ClearScreen;
   ResetGame;
   ReadMap(Level);
   GenerateObjects;
   DrawHud;
   DrawMap;
  end;
  
 if (Gamestate = 3) then
  begin
   {Kills application; exit is unclean thus using halt to clear everything}
   DestroyApp;
   Halt;
  end;
end;

Procedure DrawHud;
var
 i : integer;
begin
 PutImage(MenuLTop,0,0);
 PutImage(MenuTop,16,0);
 PutImage(MenuRTop,32,0);
 PutImage(Bloxinies,3,5);
 for i:=1 to 5 do
  begin
   PutImage(MenuLborder,0,16*i);
   PutImage(MenuRborder,32,16*i);
   if (i=4) or (i=5) then PutImage(MenuLbordergrass,0,16*i);
   if (i=4) or (i=5) then PutImage(MenuRbordergrass,32,16*i);
  end;
 PutImage(Menulevel,4,24);
 DrawLevel;
 PutImage(Menulives,4,32);
 PutImage(Menubombs,4,56);
 PutImage(Menuplayer,4,48);
 DrawNumber(1,28,48);
 DrawNumber(Player[0].Bombs,28,56);

 if SinglePlayer=FALSE then
  begin
   PutImage(Menuplayer,4,72);
   DrawNumber(2,28,72);
   PutImage(Menubombs,4,80);
   DrawNumber(Player[1].Bombs,28,80);
  end;
 ChangeLives('Redraw');
 PutImage(MenuLBot,0,96);
 PutImage(MenuBot,16,96);
 PutImage(MenuRBot,32,96);
 PutImage(F1Menu,5,100);
 if Gamestate = 0 then
  begin
   SetColor(10);
   Line(16,126,32,126);
   Line(16,145,32,145);
   Print(1,116,25,'TILE:[]');
   CycleObject('Center');
   Print(1,148,25,'SAVE:S');
  end;
end;

Procedure GenerateGraphics;
begin
InitPage(Back);
SetActivePage(Back);
if not (ParamStr(3) = '') then LoadPCX(ImagePCX,ParamStr(3)) else LoadPCX(ImagePCX,'BLOXII.GFX');
DrawPicture(0,0,ImagePCX,0,0);
GetImage(EmptyTile,0,0,15,15);
GetImage(BigWall,16,0,31,15);
GetImage(BigWallGrass,32,0,47,15);
GetImage(SmallWall,48,0,63,15);
GetImage(SmallWallGrass,64,0,79,15);
GetImage(Key,80,0,95,15);
GetImage(BloxiPlayerOne,96,0,111,15);
GetImage(BloxiPlayerTwo,112,0,127,15);
GetImage(Diamond,128,0,143,15);
GetImage(Diamond2,128,16,143,31);
GetImage(BombItem,144,16,159,31);
GetImage(BombFuse,160,16,175,31);
GetImage(BombFuse2,176,16,191,31);
GetImage(BombFuse3,192,16,207,31);
GetImage(BombFuse4,208,16,223,31);
GetImage(Explode,224,16,239,31);
GetImage(Explode2,240,16,255,31);
GetImage(Grass,256,16,271,31);
GetImage(Grass2,272,16,287,31);
GetImage(Cobweb,192,32,207,47);
GetImage(PlayerOneDead,224,32,239,47);
GetImage(PlayerOneDead2,240,32,255,47);
GetImage(PlayerOneDead3,256,32,271,47);
GetImage(GateClosed,272,32,287,47);
GetImage(GateOpen,288,32,303,47);
GetImage(Chain,272,48,287,63);
GetImage(ChainPulled,288,48,303,63);
GetImage(PlayerTwoDead,224,48,239,63);
GetImage(PlayerTwoDead2,240,48,255,63);
GetImage(PlayerTwoDead3,256,48,271,63);
GetImage(Editor,208,48,223,63);
MirrorImage(Cobweb);
GetImage(DirectionRight,304,16,319,31);
MirrorImage(DirectionRight);
GetImage(DirectionUp,288,16,303,31);
FlipImage(DirectionUp);
GetImage(DirectionDown,288,16,303,31);
GetImage(DirectionLeft,304,16,319,31);
GetImage(Exit,144,0,159,15);
GetImage(ExitOpen,160,0,175,15);
GetImage(Spider,176,0,191,15);
GetImage(Mouse,192,0,207,15);
GetImage(Shooter,208,0,223,15);
GetImage(ArrowLeft,224,0,239,15);
GetImage(ArrowRight,240,0,255,15);
SetActivePage(TheScreen);
Print(1,0,25,'STARTING BLOXINIES II EDITOR [...]');
SetActivePage(Back);
GetImage(Boulder,256,0,271,15);
GetImage(Heart,272,0,287,15);
GetImage(Mouse2,288,0,303,15);
GetImage(Mouse3,304,0,319,15);
GetImage(WoodWall,0,16,15,31);
GetImage(WoodWallKnots,16,16,31,31);
GetImage(WoodWallWindow,32,16,47,31);
GetImage(Brick,48,16,63,31);
GetImage(BrickGrate,64,16,79,31);
GetImage(BrickBanner,80,16,95,31);
GetImage(Demon,96,16,111,31);
GetImage(Bloxinies,3,36,44,47);
GetImage(MenuLBot,0,64,15,79);
GetImage(MenuBot,16,64,31,79);
GetImage(MenuRBot,32,64,47,79);
GetImage(MenuLborder,48,32,63,47);
GetImage(MenuRborder,64,32,79,47);
GetImage(MenuLbordergrass,80,32,95,47);
GetImage(MenuRbordergrass,96,32,111,47);
GetImage(SkullWall3,48,48,63,63);
GetImage(SkullWall2,64,48,79,63);
GetImage(SkullWall1,80,48,95,63);
GetImage(Skull,96,48,111,63);
GetImage(WoodWallKey,112,48,127,63);
GetImage(MenuLbordergrassHalf,112,32,127,47);
GetImage(MenuRbordergrassHalf,128,32,143,47);
GetImage(MenuLTop,144,32,159,47);
GetImage(MenuTop,160,32,175,47);
GetImage(MenuRTop,176,32,191,47);
GetImage(MenuLives,42,82,57,88);
GetImage(MenuLevel,58,82,73,88);
GetImage(MenuBombs,74,82,95,88);
GetImage(MenuPlayer,97,82,118,88);
GetImage(MenuPress,119,82,138,88);
GetImage(MenuFor,140,82,152,88);
GetImage(MenuSingle,153,82,174,88);
GetImage(MenuMulti,175,82,193,88);
GetImage(MenuToQuit,194,82,222,88);
GetImage(F1Menu,223,82,255,88);
GetImage(MenuKey,255,82,265,88);
GetImage(i1,0,82,3,88);
GetImage(i2,4,82,7,88);
GetImage(i3,8,82,11,88);
GetImage(i4,12,82,15,88);
GetImage(i5,16,82,19,88);
GetImage(i6,20,82,23,88);
GetImage(i7,24,82,27,88);
GetImage(i8,28,82,31,88);
GetImage(i9,32,82,35,88);
GetImage(i0,36,82,39,88);
SetActivePage(TheScreen);
CopyPageToVGA(TheScreen);
KillPage(Back);
end;

Procedure ToggleDebug;
begin
 if Debug=TRUE then
  begin
   Debug:=FALSE;
   print(1,192,0,Int2Str(lasttics));
  end else Debug:=TRUE;
end;

Procedure ToggleSound;
begin
 if (Noise = FALSE) then Noise := TRUE else Noise := FALSE;
 Sound(100);
 Delay(50);
 NoSound;
end;

Procedure CycleSound;
begin
  Sound(100);
  Delay(25);
  NoSound;
end;

begin
end.