Unit Windows;

 INTERFACE
   uses Crt;


Type
  ScreenImage = array [0..1999] of word;
  FrameRec  =  record
        UpperLeft     :  word;
        LowerRight    :  word;
        ScreenMemory  :  ScreenImage;
      end;


Var
 SnapShot       : ^ScreenImage;
 FrameStore     : array [1..5] of ^FrameRec;
 WindowNumber   : byte;

Procedure WindowStartUp;
Procedure OpenWindow (x,y,x2,y2,color,bcolor : integer; title : string);
Procedure DrawWindow (x,y,x2,y2,color,bcolor : integer; title : string);
Procedure CloseWindow;
Procedure CloseAllWindows;
Procedure DeleteWindow;
Procedure DeleteAllWindows;
Procedure ScrollPage (bkcolor : integer; s : integer);

IMPLEMENTATION


Procedure WindowStartUp;
 begin
  WindowNumber := 0;
  SnapShot := Ptr ($B800,$0000);
 end;

Procedure OpenWindow (x,y,x2,y2,color,bcolor : integer; title : string); { background, border color }
   var   loop : integer;
 begin
  inc(windownumber);
  New (FrameStore[windownumber]);
  with FrameStore[windownumber]^ do
   begin
    ScreenMemory := SnapShot^;
    UpperLeft := Windmin;
    LowerRight := Windmax;
   end;
  window (x,y,x2,y2);  { this window is from Crt }
  textbackground (color);
  clrscr;
  window (x,y,x2+1,y2);  { this window is from Crt }
  TextColor (bcolor);
  gotoxy (1,1);
  write (#201);
  gotoxy (1,y2-y+1);
  write (#200);
  gotoxy (x2-x+1,y2-y+1);
  write (#188);
  gotoxy (x2-x+1,1);
  write (#187);
  for loop := 1 to x2-x-1 do
   begin
    gotoxy (loop+1,1);
    write (#205);
    gotoxy (loop+1,y2-y+1);
    write (#205);
   end;
  for loop := 1 to y2-y-1 do
   begin
    gotoxy (1,loop+1);
    write (#186);
    gotoxy (x2-x+1,loop+1);
    write (#186);
   end;
  window (x,y,x2,y);
  gotoxy (((x2-x) div 2) - (length (title) div 2),1);
  write (title);
  window (x+1,y+1,x2-1,y2-1);  { this window is from Crt }
 end;

Procedure DrawWindow (x,y,x2,y2,color,bcolor : integer; title : string); { background, border color }
   var   loop : integer;                                 { draw but don't put in memory }
 begin
  textbackground (color);
  window (x,y,x2,y);
  clrscr;
  window (x,y,x2+1,y2);
  TextColor (bcolor);
  gotoxy (1,1);
  write (#201);
  gotoxy (1,y2-y+1);
  write (#200);
  gotoxy (x2-x+1,y2-y+1);
  write (#188);
  gotoxy (x2-x+1,1);
  write (#187);
  for loop := 1 to x2-x-1 do
   begin
    gotoxy (loop+1,1);
    write (#205);
    gotoxy (loop+1,y2-y+1);
    write (#205);
   end;
  for loop := 1 to y2-y-1 do
   begin
    gotoxy (1,loop+1);
    write (#186);
    gotoxy (x2-x+1,loop+1);
    write (#186);
   end;
  gotoxy (((x2-x) div 2) - (length (title) div 2),1);
  write (title);

  if windownumber > 0 then
   with FrameStore[windownumber]^ do
    Window ( (lo(upperleft)+1),(hi(UpperLeft)+1),
             (Lo(lowerRight)+1),(hi(lowerright)+1) )
   else window (1,1,80,25);

 end;

Procedure CloseWindow;
 begin
  with FrameStore[windownumber]^ do
   begin
    SnapShot^ := ScreenMemory;
    Window ( (lo(upperleft)+1),(hi(UpperLeft)+1),
             (Lo(lowerRight)+1),(hi(lowerright)+1) );
   end;
  Dispose (FrameStore[windownumber]);
  dec(windownumber);
 end;

Procedure DeleteWindow;
 begin
  with FrameStore[windownumber]^ do
    Window ( (lo(upperleft)+1),(hi(UpperLeft)+1),
             (Lo(lowerRight)+1),(hi(lowerright)+1) );
  Dispose (FrameStore[windownumber]);
  dec(windownumber);
 end;

Procedure CloseAllWindows;
  var loop : integer;
 begin
  for loop := 1 to windownumber do
   CloseWindow;
 end;

Procedure DeleteAllWindows;
  var loop : integer;
 begin
  for loop := 1 to windownumber do
   DeleteWindow;
 end;

Procedure ScrollPage (bkcolor : integer; s : integer);
   var loop : integer;
 begin
  DeleteAllWindows;
  gotoxy (1,25);
  TextBackGround (bkcolor);
  for loop := 1 to 25 do
   begin
    writeln;
    sound (s*(50+loop*35));
   end;
  nosound;
 end;


End.