Unit Mouse;

INTERFACE
 uses Crt,Dos;
  Function MousePresent:boolean;
  Function GetButtonStatus : integer;
  Function LeftKeyPressed : boolean;
  Function RightKeyPressed : boolean;
  Function BothKeyPressed : boolean;
  Function MouseX : word;
  Function MouseY : word;
  Procedure ShowMouse;
  Procedure HideMouse;
  Procedure ReadMotion(var xcount,ycount : word);
  Procedure SetMousePos (x, y : word);

IMPLEMENTATION
 Var
  regs : registers;

Function MousePresent:boolean;
  begin
   regs.ax := 0;
   intr($33,regs);
   if regs.ax > 0 then MousePresent := true
    else MousePresent := false;
  end;

Function MouseX : word;
 begin
  regs.ax := 3;
  Intr($33,regs);
  MouseX := regs.CX;
 end;

Function MouseY : word;
 begin
  regs.ax := 3;
  Intr($33,regs);
  MouseY := regs.DX;
 end;

Function GetButtonStatus : integer; { if regs.bx = 0 none, 1 left, 2 right, 3 both }
 begin
  regs.ax := 3;
  intr($33,regs);
  GetButtonStatus := regs.bx;
 end;
Function LeftKeyPressed : boolean;
 begin
  if GetButtonStatus = 1 then LeftKeyPressed := true
   else LeftKeyPressed := false;
 end;
Function RightKeyPressed : boolean;
 begin
  if GetButtonStatus = 2 then RightKeyPressed := true
   else RightKeyPressed := false;
 end;
Function BothKeyPressed : boolean;
 begin
  if GetButtonStatus = 3 then BothKeyPressed := true
   else BothKeyPressed := false;
 end;
Procedure ShowMouse;
 begin
  Regs.ax := 1;
  Intr($33,regs);
 end;
Procedure HideMouse;
 begin
  Regs.ax := 2;
  Intr($33,regs);
 end;
Procedure ReadMotion(var xcount,ycount : word);
 begin
  regs.ax := 11;
  intr ($33,regs);
  xcount := regs.cx;
  ycount := regs.dx;
 end;
Procedure SetMousePos (x, y : word);
 begin
  regs.ax := 4;
  regs.cx := x;
  regs.dx := y;
  intr($33,regs);
 end;

end.