pkgbase=mariadb
pkgname=('mariadb-libs' 'mariadb-clients' 'mariadb' 'mytop')
pkgdesc='Fast SQL database server, derived from MySQL'
pkgver=10.6.3
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Bartłomiej Piotrowski <bpiotrowski@archlinux.org>
# and maintainer Christian Hesse <mail@eworm.de>

cd $pkgbase-$pkgver/

# Arch Linux specific patches:
#  * enable PrivateTmp for a little bit more security
#  * force preloading jemalloc for memory management
#  * make systemd-tmpfiles create MYSQL_DATADIR
patch -Np1 < ../0001-arch-specific.patch
cd ..

_cmake_options=(
  # build options
  -DCOMPILATION_COMMENT="Arch Linux"
  -DCMAKE_BUILD_TYPE=RelWithDebInfo
  -Wno-dev

  # file paths
  # /etc
  -DINSTALL_SYSCONFDIR=/etc
  -DINSTALL_SYSCONF2DIR=/etc/my.cnf.d
  # /run
  -DINSTALL_UNIX_ADDRDIR=/run/mysqld/mysqld.sock
  # /usr
  -DCMAKE_INSTALL_PREFIX=/usr
  -DCMAKE_INSTALL_LIBDIR=lib
  # /usr/bin /usr/include
  -DINSTALL_SCRIPTDIR=bin
  -DINSTALL_INCLUDEDIR=include/mysql
  # /usr/lib
  -DINSTALL_PLUGINDIR=lib/mysql/plugin
  -DINSTALL_SYSTEMD_UNITDIR=/usr/lib/systemd/system/
  -DINSTALL_SYSTEMD_SYSUSERSDIR=/usr/lib/sysusers.d/
  -DINSTALL_SYSTEMD_TMPFILESDIR=/usr/lib/tmpfiles.d/
  # /usr/share
  -DINSTALL_SHAREDIR=share
  -DINSTALL_SUPPORTFILESDIR=share/mysql
  -DINSTALL_MYSQLSHAREDIR=share/mysql
  -DINSTALL_DOCREADMEDIR=share/doc/mariadb
  -DINSTALL_DOCDIR=share/doc/mariadb
  -DINSTALL_MANDIR=share/man
  # /var
  -DMYSQL_DATADIR=/var/lib/mysql

  # default settings
  -DDEFAULT_CHARSET=utf8mb4
  -DDEFAULT_COLLATION=utf8mb4_unicode_ci

  # features
  -DENABLED_LOCAL_INFILE=ON
  -DPLUGIN_EXAMPLE=NO
  -DPLUGIN_FEDERATED=NO
  -DPLUGIN_FEEDBACK=NO
  -DWITH_EMBEDDED_SERVER=ON
  -DWITH_EXTRA_CHARSETS=complex
  -DWITH_JEMALLOC=ON
  -DWITH_LIBWRAP=OFF
  -DWITH_PCRE=bundled
  -DWITH_READLINE=ON
  -DWITH_SSL=system
  -DWITH_SYSTEMD=yes
  -DWITH_UNIT_TESTS=OFF
  -DWITH_ZLIB=system
)

mkdir -p build/extra/pcre2/src

mv pcre2-10.36.zip build/extra/pcre2/src/.

cd build

cmake ../"$pkgbase-$pkgver" "${_cmake_options[@]}"

make

cd ..

# CHECK
#cd build/mysql-test

# Takes *really* long, so disabled by default.
#./mtr --parallel=5 --mem --force --max-test-fail=0

#package_mariadb-libs() {
#pkgdesc='MariaDB libraries'
#depends=('bzip2' 'libaio' 'libxcrypt' 'libcrypt.so' 'lz4' 'lzo' 'openssl' 'xz' 'zlib')
#optdepends=('krb5: for gssapi authentication')
#conflicts=('libmysqlclient' 'libmariadbclient' 'mariadb-connector-c')
#provides=('libmariadbclient' 'mariadb-connector-c' 'libmariadb.so' 'libmariadbd.so')
#replaces=('libmariadbclient')
pkgdir=$srcdir/../build/mariadb-libs

cd build

for dir in libmariadb libmysqld libservices include; do
  make -C "$dir" DESTDIR="$pkgdir" install
done

ln -s mariadb_config "$pkgdir"/usr/bin/mariadb-config
ln -s mariadb_config "$pkgdir"/usr/bin/mysql_config
install -D -m0644 "$srcdir"/"$pkgbase-$pkgver"/man/mysql_config.1 "$pkgdir"/usr/share/man/man1/mysql_config.1

install -D -m0644 support-files/mariadb.pc "$pkgdir"/usr/share/pkgconfig/mariadb.pc
install -D -m0644 "$srcdir"/"$pkgbase-$pkgver"/support-files/mysql.m4 "$pkgdir"/usr/share/aclocal/mysql.m4

cd "$pkgdir"

# remove static libraries
rm usr/lib/*.a

# remove man pages
rm -r usr/share/man

cd "$srcdir"

#package_mariadb-clients() {
#pkgdesc='MariaDB client tools'
#depends=("mariadb-libs=${pkgver}" 'jemalloc')
#conflicts=('mysql-clients')
#provides=("mysql-clients=$pkgver")
pkgdir=$srcdir/../build/mariadb-clients

cd build

make -C client DESTDIR="$pkgdir" install

# install man pages
for man in mysql mysql_plugin mysql_upgrade mysqladmin mysqlbinlog mysqlcheck mysqldump mysqlimport mysqlshow mysqlslap mysqltest; do
  install -D -m0644 "$srcdir"/"$pkgbase-$pkgver"/man/"$man.1" "$pkgdir"/usr/share/man/man1/"$man.1"
done

cd "$srcdir"

#package_mariadb() {
#  pkgdesc='Fast SQL database server, derived from MySQL'
#  backup=('etc/my.cnf'
#    'etc/my.cnf.d/client.cnf'
#    'etc/my.cnf.d/enable_encryption.preset'
#    'etc/my.cnf.d/mysql-clients.cnf'
#    'etc/my.cnf.d/server.cnf'
#    'etc/my.cnf.d/s3.cnf'
#    'etc/my.cnf.d/spider.cnf'
#    'etc/security/user_map.conf')
#    install=mariadb.install
#    depends=("mariadb-clients=${pkgver}" 'systemd-libs' 'libxml2' 'zstd')
#    optdepends=('cracklib: for cracklib plugin'
#      'curl: for ha_s3 plugin'
#      'galera: for MariaDB cluster with Galera WSREP'
#      'python-mysqlclient: for myrocks_hotbackup'
#      'perl-dbd-mariadb: for mariadb-hotcopy, mariadb-convert-table-format and mariadb-setpermission')
#      conflicts=('mysql')
#      provides=("mysql=$pkgver")
#      options=('emptydirs')
pkgdir=$srcdir/../build

cd build

make DESTDIR="$pkgdir" install

cd "$pkgdir"

# no SysV init, please!
rm -r etc/logrotate.d
rm usr/bin/rcmysql
rm usr/share/mysql/{binary-configure,mysql{,d_multi}.server}

# move to proper licenses directories
install -d usr/share/licenses/mariadb
mv usr/share/doc/mariadb/COPYING* usr/share/licenses/mariadb/

# move it where one might look for it
mv usr/share/{groonga{,-normalizer-mysql},doc/mariadb/}

# move to pam directories
install -d {etc,usr/lib}/security
mv usr/share/user_map.conf etc/security/
mv usr/share/pam_user_map.so usr/lib/security/

# already installed to real systemd unit directory or useless
rm -r usr/share/mysql/systemd/
rm -r usr/lib/systemd/system/mariadb@bootstrap.service.d

# provided by mariadb-libs
rm usr/bin/{mariadb{_,-},mysql_}config
rm -r usr/include/
rm usr/share/man/man1/mysql_config.1
rm -r usr/share/aclocal
rm usr/lib/lib*
rm -r usr/lib/pkgconfig
rm usr/lib/mysql/plugin/{auth_gssapi_client,caching_sha2_password,client_ed25519,dialog,mysql_clear_password,sha256_password}.so

# provided by mariadb-clients
rm usr/bin/mysql{,_plugin,_upgrade,admin,binlog,check,dump,import,show,slap,test}
rm usr/bin/mariadb{,-{admin,binlog,check,conv,dump,import,plugin,show,slap,test,upgrade}}
rm usr/share/man/man1/mysql{,_plugin,_upgrade,admin,binlog,check,dump,import,show,slap,test}.1

# provided by mytop
rm usr/bin/mytop

# not needed
rm -r usr/{mysql-test,sql-bench}
rm usr/share/man/man1/mysql-test-run.pl.1

# Update configuration to use home dir for creating databases
cd "$pkgdir"
sed "s;\[mysqld\];[mysqld]\ndatadir=/home/occam/db/mysql\nsocket=/home/occam/db/mysql/mysql.sock;" -i etc/my.cnf.d/server.cnf
sed "s;\[client\];[client]\nsocket=/home/occam/db/mysql/mysql.sock;" -i etc/my.cnf.d/client.cnf

cd "$srcdir"

#package_mytop() {
#  pkgdesc='Top clone for MariaDB'
#  depends=('perl' 'perl-dbd-mariadb' 'perl-term-readkey')
pkgdir=$srcdir/../build/mytop

install -D -m0755 build/scripts/mytop "$pkgdir"/usr/bin/mytop
