pkgname=systemd
pkgver=249
pkgdir=$PWD/../build
srcdir=$PWD

cd systemd-249

sed -i -e 's/GROUP="render"/GROUP="video"/' \
  -e 's/GROUP="sgx", //' rules.d/50-udev-default.rules.in

mkdir -p build
cd       build

LANG=en_US.UTF-8 meson setup \
  --prefix         /usr \
  --bindir         /usr/bin \
  --libdir         /usr/lib \
  --libexecdir     /usr/lib \
  --sbindir        /usr/bin \
  --sysconfdir     /etc \
  --localstatedir  /var \
  --buildtype      release \
  -D               split-bin=false \
  -D               rootprefix=/usr \
  -D               blkid=true \
  -D               default-dnssec=no \
  -D               firstboot=false \
  -D               install-tests=false \
  -D               ldconfig=false \
  -D               sysusers=false \
  -D               b_lto=false \
  -D               rpmmacrosdir=no \
  -D               homed=false \
  -D               userdb=false \
  -D               man=false \
  -D               libidn2=true \
  -D               lz4=true \
  -D               mode=release \
  -D               b_lto=true \
  -D               b_pie=true \
  -D               docdir=/usr/share/doc/systemd-249 \
  ..

LANG=en_US.UTF-8 ninja
DESTDIR="${pkgdir}" LANG=en_US.UTF-8 ninja install

rm -rf ${pkgdir}/usr/lib/pam.d

# move libnss_systemd libraries to their own place.
mkdir ${pkgdir}/nss-systemd/usr/lib -p
mv ${pkgdir}/usr/lib/libnss_systemd* ${pkgdir}/nss-systemd/usr/lib/.
