pkgname=alsa-lib
pkgver=1.2.5.1
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer David Runge <dvzrv@archlinux.org>
# and contributor Judd <jvinet@zeroflux.org>

cd "$pkgname-$pkgver"
autoreconf -vfi

./configure --prefix=/usr \
  --without-debug
make

export LD_LIBRARY_PATH="${PWD}/src/.libs/:${LD_LIBRARY_PATH}"
make -k check

make DESTDIR="$pkgdir" install
make DESTDIR="$pkgdir" install -C doc
install -vDm 644 {MEMORY-LEAK,TODO,NOTES,ChangeLog,doc/asoundrc.txt} \
  -t "${pkgdir}/usr/share/doc/${pkgname}"

cd ${srcdir}
pkgname=alsa-topology-conf
cd "${pkgname}-${pkgver}"
for dir in topology/*; do
  install -vDm 644 "${dir}"/*.conf -t "$pkgdir/usr/share/alsa/topology/$(basename $dir)"
done
install -vDm 644 LICENSE -t "$pkgdir/usr/share/licenses/$pkgname"
install -vDm 644 README.md -t "$pkgdir/usr/share/doc/$pkgname"

cd ${srcdir}
pkgname=alsa-ucm-conf
cd "${pkgname}-${pkgver}"
find ucm2 -type f -iname "*.conf" -exec install -vDm 644 {} "${pkgdir}/usr/share/alsa/"{} \;
find ucm2 -type l -iname "*.conf" -exec cp -dv {} "${pkgdir}/usr/share/alsa/"{} \;
install -vDm 644 LICENSE -t "$pkgdir/usr/share/licenses/$pkgname"
install -vDm 644 README.md -t "$pkgdir/usr/share/doc/$pkgname"
install -vDm 644 ucm2/README.md -t "$pkgdir/usr/share/doc/$pkgname/ucm2"
