/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// VGATools v3.0 - (C)1997  NicoSot (Valentini Domenico)

// non serve ma...
#include "std.hpp"
#include "vgatool3.hpp"

char far *_pal = new char[768];

void waitvsync() {
asm {
	MOV DX, 0x3da
	MOV AH, 8
} end_vr: asm {
	IN AL, DX
	TEST AL, AH
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	TEST AL, AH
	JZ start_vr
}}

void setpal(PPal pal, word fromcol, word numcol) {
asm {
	LDS SI, pal
	MOV DX, 0x3c8
	MOV AX, fromcol
	OUT DX, AL
	SHL AX, 1
	ADD AX, fromcol
	ADD SI, AX
	MOV CX, numcol
	SHL CX, 1
	ADD CX, numcol
	CLD
// aspetta inizio sincr. vert.
	MOV DX, 0x3da
} end_vr: asm {
	IN AL, DX
	AND AL, 8
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	AND AL, 8
	JZ start_vr
	MOV DL, 0xc9
	REP OUTSB
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void palfilter(PPal pal, byte r, byte g, byte b) {
asm {
	LDS SI, pal
	LES DI, pal
	MOV CX, 256
} ciclo: asm {
	LODSB
	ADD AL, r
	SHR AL, 1
	STOSB
	LODSB
	ADD AL, g
	SHR AL, 1
	STOSB
	LODSB
	ADD AL, b
	SHR AL, 1
	STOSB
	LOOP ciclo
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void fadein(PPal pal, word fromcol, word numcol, word numcicli) {
word rgbfrom;
asm {
	MOV AX, fromcol
	SHL AX, 1
	ADD AX, fromcol
	MOV rgbfrom, AX
	MOV AX, numcol
	SHL AX, 1
	ADD numcol, AX
	CLD
	MOV BX, 1
} cic1: asm {
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
	LES DI, _pal
	LDS SI, pal
	ADD SI, rgbfrom
	ADD DI, rgbfrom
	MOV DL, BYTE PTR numcicli
	MOV CX, numcol
} cic2: asm {
	LODSB
	MUL BL
	DIV DL
	STOSB
	LOOP cic2

	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
	LDS SI, _pal
	MOV DX, 0x3c8
	MOV AL, BYTE PTR fromcol
	OUT DX, AL
	MOV CX, numcol
// aspetta inizio sincr. vert.
	MOV DL, 0xda
} end_vr: asm {
	IN AL, DX
	AND AL, 8
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	AND AL, 8
	JZ start_vr
	MOV DL, 0xc9
	REP OUTSB

	MOV AX, numcicli
	INC BX
	CMP BX, AX
	JLE cic1

	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
}}

void fadeout(PPal pal, word fromcol, word numcol, word numcicli) {
word rgbfrom;
asm {
	MOV AX, fromcol
	SHL AX, 1
	ADD AX, fromcol
	MOV rgbfrom, AX
	MOV AX, numcol
	SHL AX, 1
	ADD numcol, AX
	CLD
	MOV BX, numcicli
	DEC BX
} cic1: asm {
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
	LES DI, _pal
	LDS SI, pal
	ADD SI, rgbfrom
	ADD DI, rgbfrom
	MOV DL, BYTE PTR numcicli
	MOV CX, numcol
} cic2: asm {
	LODSB
	MUL BL
	DIV DL
	STOSB
	LOOP cic2

	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
	LDS SI, _pal
	MOV DX, 0x3c8
	MOV AL, BYTE PTR fromcol
	OUT DX, AL
	MOV CX, numcol
// aspetta inizio sincr. vert.
	MOV DL, 0xda
} end_vr: asm {
	IN AL, DX
	AND AL, 8
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	AND AL, 8
	JZ start_vr
	MOV DL, 0xc9
	REP OUTSB

	MOV AX, numcicli
	DEC BX
	JGE cic1

	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void palmorph(PPal initpal, PPal endpal,
			  word fromcol, word numcol, word numcicli) {
	word rgbfrom;
	byte cnt;
asm {
	CLD
	MOV AX, fromcol
	SHL AX, 1
	ADD AX, fromcol
	MOV rgbfrom, AX
	MOV AX, numcol
	SHL AX, 1
	ADD numcol, AX
	MOV cnt, 1		//	parte subito !
} cic1: asm {
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
	LES DI, _pal
	MOV BX, rgbfrom
	ADD DI, BX
	MOV DL, BYTE PTR numcicli
	MOV CX, numcol
} cic2: asm {
	LDS SI, endpal
	MOV AL, [SI+BX]
	LDS SI, initpal
	MOV DH, [SI+BX]
	SUB AL, DH
	JNS pos
	NEG AL
	MUL cnt
	DIV DL
	NEG AL
	JMP goon
} pos: asm {
	MUL cnt
	DIV DL
} goon: asm {
	ADD AL, DH
	STOSB
	INC BX
	LOOP cic2

	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
	LDS SI, _pal
	MOV DX, 0x3c8
	MOV AL, BYTE PTR fromcol
	OUT DX, AL
	MOV CX, numcol
// aspetta inizio sincr. vert.
	MOV DL, 0xda
} end_vr: asm {
	IN AL, DX
	AND AL, 8
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	AND AL, 8
	JZ start_vr
	MOV DL, 0xc9
	REP OUTSB

	INC cnt
	MOV AL, cnt
	XOR AH, AH
	MOV BX, numcicli
	CMP AX, BX
	JLE cic1

	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void fadeinpart(PPal pal, word fromcol, word numcol,
				word ciclo, word numcicli) {
word rgbfrom;
asm {
	MOV AX, fromcol
	SHL AX, 1
	ADD AX, fromcol
	MOV rgbfrom, AX
	MOV AX, numcol
	SHL AX, 1
	ADD numcol, AX
	CLD
	MOV BX, ciclo
	LES DI, _pal
	LDS SI, pal
	ADD SI, rgbfrom
	ADD DI, rgbfrom
	MOV DL, BYTE PTR numcicli
	MOV CX, numcol
} cic2: asm {
	LODSB
	MUL BL
	DIV DL
	STOSB
	LOOP cic2

	LDS SI, _pal
	MOV DX, 0x3c8
	MOV AL, BYTE PTR fromcol
	OUT DX, AL
	MOV CX, numcol
// aspetta inizio sincr. vert.
	MOV DL, 0xda
} end_vr: asm {
	IN AL, DX
	AND AL, 8
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	AND AL, 8
	JZ start_vr
	MOV DL, 0xc9
	REP OUTSB

	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
}}

void fadeoutpart(PPal pal, word fromcol, word numcol,
				 word ciclo, word numcicli) {
word rgbfrom;
asm {
	MOV AX, fromcol
	SHL AX, 1
	ADD AX, fromcol
	MOV rgbfrom, AX
	MOV AX, numcol
	SHL AX, 1
	ADD numcol, AX
	CLD
	MOV BX, numcicli
	SUB BX, ciclo
	LES DI, _pal
	LDS SI, pal
	ADD SI, rgbfrom
	ADD DI, rgbfrom
	MOV DL, BYTE PTR numcicli
	MOV CX, numcol
} cic2: asm {
	LODSB
	MUL BL
	DIV DL
	STOSB
	LOOP cic2

	LDS SI, _pal
	MOV DX, 0x3c8
	MOV AL, BYTE PTR fromcol
	OUT DX, AL
	MOV CX, numcol
// aspetta inizio sincr. vert.
	MOV DL, 0xda
} end_vr: asm {
	IN AL, DX
	AND AL, 8
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	AND AL, 8
	JZ start_vr
	MOV DL, 0xc9
	REP OUTSB

	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void palmorphpart(PPal initpal, PPal endpal,
			  word fromcol, word numcol, word ciclo, word numcicli) {
	word rgbfrom;
	byte cnt;
asm {
	CLD
	MOV AX, fromcol
	SHL AX, 1
	ADD AX, fromcol
	MOV rgbfrom, AX
	MOV AX, numcol
	SHL AX, 1
	ADD numcol, AX
	MOV AX, ciclo
	MOV cnt, AL
	LES DI, _pal
	MOV BX, rgbfrom
	ADD DI, BX
	MOV DL, BYTE PTR numcicli
	MOV CX, numcol
} cic2: asm {
	LDS SI, endpal
	MOV AL, [SI+BX]
	LDS SI, initpal
	MOV DH, [SI+BX]
	SUB AL, DH
	JNS pos
	NEG AL
	MUL cnt
	DIV DL
	NEG AL
	JMP goon
} pos: asm {
	MUL cnt
	DIV DL
} goon: asm {
	ADD AL, DH
	STOSB
	INC BX
	LOOP cic2

	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
	LDS SI, _pal
	MOV DX, 0x3c8
	MOV AL, BYTE PTR fromcol
	OUT DX, AL
	MOV CX, numcol
// aspetta inizio sincr. vert.
	MOV DL, 0xda
} end_vr: asm {
	IN AL, DX
	AND AL, 8
	JNZ end_vr
} start_vr: asm {
	IN AL, DX
	AND AL, 8
	JZ start_vr
	MOV DL, 0xc9
	REP OUTSB

	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
}}