/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// StrList  -  String List Manager  -  (C)1997  Valentini Domenico

#include "std.hpp"
#include "fastmem.hpp"
#include "mm4.hpp"
#include "strlist.hpp"
#include <io.h>
#include <fcntl.h>

#define	ENDCHAR		''

// ---- String List managment ----
#ifndef __DATAFILE__
int sl_convert(const char *slfile) {
	int handle;
	word size = 0;
	char c;
	char far *p, far *app;
	if ((handle = _open(slfile,O_RDONLY|O_BINARY))>=0) {
		app = p = (char *)mm_reserve(filelength(handle));
		do {
			_read(handle,&c,1);
			if (c==10) continue; else	// LF jump
			if (c==13) c=0;				// CR -> 0 (end of string)
			*(app++) = c;
			size++;
			if (c==ENDCHAR) break;			// ENDCHAR = end of list
		} while (!eof(handle));
		if (c!=ENDCHAR) {	// l'ho aggiunto in caso di distrazione
			*(app++) = ENDCHAR;
			size++;
		}
		_close(handle);

		handle = mm_alloc(size);
		fdmove(mm_recall(handle),p,size);
		delete p;
		return handle;
	}
	error("sl_convert","can't convert");
	return -1;
}
#endif

#pragma warn -rvl
void far *sl_find(void far *list, int n) {	// n=1: successivo
// un alto livello di integrazione... WOW !
asm {
	LDS SI, list
	MOV BL, ENDCHAR		// 'ENDCHAR'	// fine lista
	MOV CX, n
	CLD
	JCXZ end
} next: asm {
	LODSB
	CMP AL, BL
	JE error
	OR AL, AL
	JNZ next
	LOOP next
} end: asm {
	MOV DX, DS
	MOV AX, SI
	MOV BH, [SI]	// controlla se  ENDCHAR
	CMP BH, BL
	JNE via
} error: asm {
	XOR AX, AX
	XOR DX, DX
} via: asm {
	// !SS==DS!
	MOV BX, SS
	MOV DS, BX
}}
#pragma warn +rvl
// ----
