/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// STD - Nicosot'97 STANDARD - (C)1997  Nicosot (Valentini Domenico)

#include <stdlib.h>
#include <conio.h>
#include "std.hpp"

#define	ID_LEN	32		// deve essere pari
//const char NicMark[ID_LEN+1] = "Programmed by VALENTINI DOMENICO";
//const word EvenCRC = 1344, OddCRC = 1281;
const char NicMark[ID_LEN+1] = "Programmed by DOMENICO VALENTINI";
const unsigned long SerialNo = 0x00000000l;
const word NMEvenCRC = 1339, NMOddCRC = 1286;
const word SNEvenCRC = 0,  SNOddCRC = 0;
char ShutDown = 0;

void error(const char *err_fnc, const char *err_on) {
	asm { MOV AH, 0x0f
		  INT 0x10
		  CMP AL, 0x03
		  JE goon
		  MOV AX, 3
		  INT 0x10
	} goon:
	cputs("error: ");
	cputs(err_fnc);
	cputs("() - ");
	cputs(err_on);
	ShutDown = 1;
	exit(EXIT_FAILURE);
}

void near CMP_CRC(const byte *code, int count, word even, word odd) {
	register word evencrc = 0, oddcrc = 0;
	for (count>>=1;count--;) {
		oddcrc += *(code++);
		evencrc += *(code++);
	}
	if ((evencrc != even) || (oddcrc != odd))
		error("SYSTEM","Programmer HALT");
		/*
		asm { MOV AX,3; INT 0x10 }
		printf("%d - %d",evencrc,oddcrc);
		ShutDown = 1;
		exit(EXIT_FAILURE);
		*/
}

void CheckCRC(void) {
	CMP_CRC((byte *)NicMark,ID_LEN,NMEvenCRC,NMOddCRC);
	CMP_CRC((byte *)&SerialNo,4,SNEvenCRC,SNOddCRC);
}

#pragma	startup	CheckCRC	64