/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

#ifndef __OBJECTS__
#define __OBJECTS__

#define OFL_SEEN		0x01
#define	OFL_ONESEEN		0x02
#define	OFL_ISACTOR		0x04
#define	OFL_TAKEABLE  	0x08
#define	OFL_REVERSE  	0x10
#define	OFL_ISLIGHT		0x20
#define	OFL_HASLIGHT	0x40

#define MVT_0	0	// Single square placer
#define MVT_1 	1	// Single square mover
#define MVT_2   2   // Double   "      "
//#define	MVT_3	3	// Walls follower

#define	MAXARMS			6
#define	ARMCHGSPEED		36
// Arm Flags
#define AFL_ASCIA		0x01
#define AFL_PISTOLA		0x02
#define AFL_FUCILE		0x04
#define AFL_MITRA		0x08
#define AFL_BAZOOKA		0x10
#define AFL_BOMB		0x20
//#define AFL_FIREBALL	0x40	// ???

// Arm recharge bullets values
#define	ARM_ADDPISTOLA	20
#define ARM_ADDFUCILE	4
#define	ARM_ADDMITRA	24
#define ARM_ADDBAZOOKA	2
#define	ARM_ADDBOMB		1

typedef	struct {
			byte flag, power, chargetime;
			int pre_ammo, max_ammo;
		} TArm;
extern TArm ArmList[MAXARMS];

//class Object;

class Mover
{
	protected:
		friend Object;
		byte mover_type;
		void enqueue(int idx, int &undr);
		void dequeue(int idx, int undr);
	public:
		int id;
		int flags;
		int index;
		int under;
		char shdim;
		fixed x, y, z;
		int angle;
		Mover(fixed _x=0l, fixed _y=0l, fixed _z=0l, int _shdim=5,
			  word _flags=OMF_STANDARD) :
			  x(_x), y(_y), z(_z), id(0), shdim(_shdim), flags(_flags),
			  mover_type(MVT_0) {};
		Mover(int handle);
		virtual void save(int handle);
		void setid(int the_id) {
			if (!id) id = the_id;
			else error("Object::setid","multiple IDs");
		}
		virtual char canmove(fixed nx, fixed ny);
		virtual void place();
		virtual void remove();
		virtual int underq(int idx) {return under;};
		virtual void correctq(int idx, int undid);
		virtual char move(int ang, int lshift);
		virtual char fluidmove(int ang, fixed mult);
};

class Mover1 : public Mover
{
	public:
		Mover1(fixed _x=0l, fixed _y=0l, fixed _z=0l, int _shdim=5,
			  word _flags=OMF_STANDARD) :
			  Mover(_x,_y,_z,_shdim,_flags) {mover_type=MVT_1;};
		Mover1(int handle):Mover(handle) {};
		virtual char move(int ang, int lshift);
		virtual char fluidmove(int ang, fixed mult);
};

class Mover2 : public Mover1	// ... !!!
{
	protected:
		int index1;
		int under1;
	public:
		Mover2(fixed _x=0l, fixed _y=0l, fixed _z=0l, int _shdim=5,
			  word _flags=OMF_STANDARD)
			  :Mover1(_x,_y,_z,_shdim,_flags) {mover_type=MVT_2;};
		Mover2(int handle);
		virtual void save(int handle);
		virtual void place();
		virtual void remove();
		virtual int underq(int idx);
		virtual void correctq(int idx, int undid);
		//virtual char move(int lshift);
		//virtual char fluidmove(fixed mult);
};

/*
class Mover3 : public Mover2
{
	public:
		Mover3(fixed _x=0l, fixed _y=0l, fixed _z=0l, int _shdim=5,
			  word _flags=OMF_STANDARD)
			  :Mover2(_x,_y,_z,_shdim,_flags) {mover_type=MVT_3;};
		virtual char canmove(fixed nx, fixed ny);
};
*/

class Object
{
		char doblood(int angle);
	protected:
		byte object_type;
		friend ObjectsList;	// per setid
		virtual void setid(int _id) {mover->setid(_id);};
	public:
		Mover *mover;
		char oflags, selflight;
		int figstart;
		char fignum;
		Object(fixed px, fixed py, int startfig = 0,
			   char numfig = 1, byte movertype = MVT_0);
		Object(int handle); // Load Constructor
		virtual void save(int handle);
		virtual ~Object();
		int getid()	{return mover->id;};
		//void setshdim(char dim)	{mover->shdim = dim;};
		void changefig(int startfig, char numfig);
		virtual int getviewfig(int ang);	// !!!! New Reverse Mode !!!!
		virtual void place() {mover->place();};
		virtual void remove() {mover->remove();};
		virtual void handle_event(TEvent &event);

		char have_seen()	{return (oflags & OFL_SEEN);};
		char had_seen()		{return (oflags & OFL_ONESEEN);};
		void seen() 		{oflags |= OFL_SEEN | OFL_ONESEEN;};
		void reset()		{oflags &= ~OFL_SEEN;};

		byte get_type() 	{return object_type;};
};

class Actor : public Object
{
	protected:
		int animcount;
		virtual void setid(int the_id);
		virtual char makeActor();
		virtual char makeObject();
		char nearPlayer(fixed maxdist);
	public:
		int health;
		Actor(fixed px, fixed py, int startfig = 0, char numfig = 1,
			  byte movertype = MVT_0)
			:Object(px,py,startfig,numfig,movertype),
			animcount(0), health(1) {object_type=OBJT_ACTOR;};
		Actor(int handle); // Constructor Load
		virtual void save(int handle);
		virtual ~Actor();
		virtual int getviewfig(int ang);
		virtual void animate() {};
		virtual void draw(int vidx, int vidy, char &cd, char &fd);
		virtual void virtualdraw();
		virtual void transf(int vidx, int vidy);
		// virtual void handle_event(Event &event);
};

class LightActor : public Actor
{
	protected:
		char lightrange;
		void lights();
		void unlights();
	public:
		fixed lightz;
		char lightpow;
		LightActor(fixed px, fixed py, int startfig = 0, char numfig = 1,
				   char lr = 0, char self = 0, byte movertype = MVT_0) :
				Actor(px,py,startfig,numfig,movertype),
				lightrange(lr) {
					selflight=self;
					object_type=OBJT_LIGHTACTOR;
					lightz = 0;
					lightpow = 0;
					SETFLAG(oflags,OFL_HASLIGHT);
				};
		LightActor(int handle); // Constructor Load
		virtual void save(int handle);
		~LightActor();
		virtual void place();
		virtual void remove();
		virtual int getlightfig() { return -1; };
};

class CanFireActor : public LightActor
{
	protected:
		word armflag;
		byte oldarm, curarm, armcharge, armchanging;
		int Armbull[MAXARMS-1];
		virtual char setarm(byte armtype);
		virtual char fire(int angle);
	public:
		CanFireActor(fixed px, fixed py, int startfig = 0,
					 char numfig = 1, byte movertype = MVT_0);
			/*
			:LightActor(px,py,startfig,numfig,0,0,movertype),
			 curarm(0), oldarm(0), armcharge(0), armchanging(0), armflag(0)
			 {object_type=OBJT_CANFIREACTOR;};
			*/
		CanFireActor(int handle); // Constructor Load
		virtual void save(int handle);
		virtual void animate();
		virtual char takearm(byte armtype);
		virtual char takeammo(byte armtype, int ammo);
};

class ObjectsList
{
		friend ActorsList;
		Object *objlist[MAXOBJECTS];
		int objnum;
	public:
		ObjectsList();
		~ObjectsList();
		void loadobj(Object *object, byte objtype); // !!!
		void save(int handle);
		void put(Object *object);
		Object *get(int objidx);
		void erase(int objidx);
		void eraseall();
		void handle_event(TEvent &event);
		void preloadall();
};

class ActorsList
{
		int actorslist[MAXACTORS];
		int actorsnum;
	public:
		ActorsList() : actorsnum(0) {};
		void add(int objidx);
		void erase(int objidx);
		void eraseall();
		void animate();
		void handle_event(TEvent &event);
		void reset();
};

class DrawList
{
		int drawlist[MAXDRAWING];
		fixed distlist[MAXDRAWING];
		byte drawnum;
	public:
		DrawList() : drawnum(0) {};
		char not_empty() {return drawnum;};
		void flush() {drawnum=0;};
		void add(int objidx, fixed objdist);
		int get(fixed &objdist);
};

extern ObjectsList objectslist;
extern ActorsList actorslist;

#endif 	// __OBJECTS__