/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// OBJECTS - (C)1997  Nicosot (Valentini Domenico)

#include "std.hpp"
#include "fastmem.hpp"
#include "fixed.h"
#include "events.hpp"
#include "doors.hpp"
#include "3dengine.hpp"
#include "mm4.hpp"
#include "crcio.hpp"
#include "kaos.hpp"
#include "objects.hpp"
#include "lgraph.hpp"

#include "infobar.hpp"	// !!!!

TArm ArmList[MAXARMS] = {
	{AFL_ASCIA,		8, 36, -1, -1},
	{AFL_PISTOLA, 	7, 18, 20,100},
	{AFL_FUCILE,  	8, 36, 10, 80},
	{AFL_MITRA,   	6,  5, 48,200},
	{AFL_BAZOOKA,  20, 30,  2, 20},
	{AFL_BOMB,	   20, 30,  1, 20}
};

Mover::Mover(int handle) {	// Constructor Load
	// don't load the type (loaded by the object for dispatching)
	  // Questo metodo fa veramente schifo, sono sicuro che ce n'
	  // uno migliore...
	CRC_read(handle,&id,sizeof(id));
	CRC_read(handle,&x,sizeof(x));
	CRC_read(handle,&y,sizeof(y));
	CRC_read(handle,&z,sizeof(z));
	CRC_read(handle,&angle,sizeof(angle));
	CRC_read(handle,&shdim,sizeof(shdim));
	CRC_read(handle,&flags,sizeof(flags));
	CRC_read(handle,&index,sizeof(index));
	CRC_read(handle,&under,sizeof(under));
}

void Mover::save(int handle) {
	CRC_write(handle,&mover_type,sizeof(mover_type));
	CRC_write(handle,&id,sizeof(id));
	CRC_write(handle,&x,sizeof(x));
	CRC_write(handle,&y,sizeof(y));
	CRC_write(handle,&z,sizeof(z));
	CRC_write(handle,&angle,sizeof(angle));
	CRC_write(handle,&shdim,sizeof(shdim));
	CRC_write(handle,&flags,sizeof(flags));
	CRC_write(handle,&index,sizeof(index));
	CRC_write(handle,&under,sizeof(under));
}

void Mover::enqueue(int idx, int &undr) {
	undr = IDMap[idx];
	IDMap[idx] = id;
	objmap[idx] += flags;
}

void Mover::dequeue(int idx, int undr) {
	int top;

	if ((top = IDMap[idx]) == id)
		IDMap[idx] = undr;
	else {
		Mover *mvr;
		while ((top = (mvr = objectslist.get(top)->mover)->underq(idx)) != id);
		mvr->correctq(idx,undr);
	}
	objmap[idx] -= flags;
}

#pragma warn -par
void Mover::correctq(int idx, int undid) {
	under = undid;
}
#pragma warn +par

void Mover::place() {
	enqueue(index = xytoidx(x,y), under);
}

void Mover::remove() {
	dequeue(index, under);
}

char Mover::canmove(fixed nx, fixed ny) {
	int idx, top;
	Mover *mvr;
	fixed dist;
			// !!! si possono togliere i margini !?
	if ((nx >= (32l<<FIXSHIFT)) && (nx <= LMAX_X-(32l<<FIXSHIFT)) &&
		(ny >= (32l<<FIXSHIFT)) && (ny <= LMAX_Y-(32l<<FIXSHIFT))) {
		if (!ObjMap[idx = xytoidx(nx,ny)].unwalkable) return 1;
		if (map[idx]) return 0;
		top = IDMap[idx];
		while (top>=0) {
			mvr = objectslist.get(top)->mover;
			if (mvr->flags & OMM_UNWALKABLE) {
				dist = (FIXONE<<shdim)+(FIXONE<<mvr->shdim);
				/*
				if (LABS(mvr->x-nx) <= dist ||
					LABS(mvr->y-ny) <= dist) return 0;
				*/
				//if (fixdist(mvr->x-nx,mvr->y-ny) <= dist) return 0;
				if (LABS(mvr->x-nx)+LABS(mvr->y-ny) <= dist) return 0; // !!!!!
			}
			top = mvr->underq(idx);
		}
		return 1;
	}
	return 0;
}

char Mover::move(int ang, int lshift) {
	fixed nx = x + (costab[ang]<<lshift),
		  ny = y + (sintab[ang]<<lshift);
	if (canmove(nx,ny)) {
		x = nx;
		y = ny;
		return 1;
	}
	return 0;
}

char Mover::fluidmove(int ang, fixed mult) {
	fixed nx = x + fixmul(costab[ang],mult),
		  ny = y + fixmul(sintab[ang],mult);
	if (canmove(nx,ny)) {
		x = nx;
		y = ny;
		return 1;
	}
	return 0;
}

char Mover1::move(int ang, int lshift) {
	fixed ca = costab[ang],
		  sa = sintab[ang],
		  nx = x + (ca<<lshift),
		  ny = y + (sa<<lshift),
		  dim = (FIXONE<<shdim),
		  vdim = dim-(FIXONE<<2);
	char moved = 0;
	if (ca>0) {if (canmove(nx+dim,y-vdim) && canmove(nx+dim,y+vdim)) {x=nx;moved++;}} else
	 if (ca<0) {if (canmove(nx-dim,y-vdim) && canmove(nx-dim,y+vdim)) {x=nx;moved++;}}
	if (sa>0) {if (canmove(x-vdim,ny+dim) && canmove(x+vdim,ny+dim)) {y=ny;moved++;}} else
	 if (sa<0) {if (canmove(x-vdim,ny-dim) && canmove(x+vdim,ny-dim)) {y=ny;moved++;}}
	if (moved && (!ca || !sa)) moved++;
	return moved; //(moved==2);
	/*
		  ax = sa<<shdim,//(shdim-1),
		  ay = ca<<shdim,//(shdim-1),
		  dim = FIXONE<<shdim;
	char moved=0;
	if (!ca) moved++; else
	if (ca>0l) {if (canmove(nx+dim,y-ay) && canmove(nx+dim,y+ay)) {x=nx;moved++;}}
		else if (canmove(nx-dim,y-ay) && canmove(nx-dim,y+ay)) {x=nx;moved++;}
	if (!sa) moved++; else
	if (sa>0l) {if (canmove(x-ax,ny+dim) && canmove(x+ax,ny+dim)) {y=ny;moved++;}}
		else if (canmove(x-ax,ny-dim) && canmove(x+ax,ny-dim)) {y=ny;moved++;}
	return (moved==2);
	*/
}

char Mover1::fluidmove(int ang, fixed mult) {
	fixed ca = costab[ang],
		  sa = sintab[ang],
		  nx = x + fixmul(ca,mult),
		  ny = y + fixmul(sa,mult),
		  dim = (FIXONE<<shdim),
		  vdim = dim-(FIXONE<<2);
	char moved=0;
	if (ca>0) {if (canmove(nx+dim,y-vdim) && canmove(nx+dim,y+vdim)) {x=nx;moved++;}} else
	 if (ca<0) {if (canmove(nx-dim,y-vdim) && canmove(nx-dim,y+vdim)) {x=nx;moved++;}}
	if (sa>0) {if (canmove(x-vdim,ny+dim) && canmove(x+vdim,ny+dim)) {y=ny;moved++;}} else
	 if (sa<0) {if (canmove(x-vdim,ny-dim) && canmove(x+vdim,ny-dim)) {y=ny;moved++;}}
	if (moved && (!ca || !sa)) moved++;
	return moved; //(moved==2);
	/*
	if (!ca) moved++; else
	if (ca>0l) {if (canmove(nx+dim,y-vdim) && canmove(nx+dim,y+vdim)) {x=nx;moved++;}}
		else if (canmove(nx-dim,y-vdim) && canmove(nx-dim,y+vdim)) {x=nx;moved++;}
	if (!sa) moved++; else
	if (sa>0l) {if (canmove(x-vdim,ny+dim) && canmove(x+vdim,ny+dim)) {y=ny;moved++;}}
		else if (canmove(x-vdim,ny-dim) && canmove(x+vdim,ny-dim)) {y=ny;moved++;}
	return (moved==2);
	*/
		 /*

		  ax = sa<<shdim, //(shdim-1),
		  ay = ca<<shdim, //(shdim-1),
		  dim = FIXONE<<shdim;
	char moved=0;
	if (!ca) moved++; else
	if (ca>0l) {if (canmove(nx+dim,y-ay) && canmove(nx+dim,y+ay)) {x=nx;moved++;}}
		else if (canmove(nx-dim,y-ay) && canmove(nx-dim,y+ay)) {x=nx;moved++;}
	if (!sa) moved++; else
	if (sa>0l) {if (canmove(x-ax,ny+dim) && canmove(x+ax,ny+dim)) {y=ny;moved++;}}
		else if (canmove(x-ax,ny-dim) && canmove(x+ax,ny-dim)) {y=ny;moved++;}
	return (moved==2);
	 */
	/*
	if (!ca) moved++; else
	if (ca>0l) {if (canmove(nx+(FIXONE<<shdim),y)) {x=nx;moved++;}}
		else if (canmove(nx-(FIXONE<<shdim),y)) {x=nx;moved++;}
	if (!sa) moved++; else
	if (sa>0l) {if (canmove(x,ny+(FIXONE<<shdim))) {y=ny;moved++;}}
		else if (canmove(x,ny-(FIXONE<<shdim))) {y=ny;moved++;}
	return (moved==2);
	*/
}

Mover2::Mover2(int handle)
	   :Mover1(handle) {
	CRC_read(handle,&index1,sizeof(index1));
	CRC_read(handle,&under1,sizeof(under1));
}

void Mover2::save(int handle) {
	Mover::save(handle);
	CRC_write(handle,&index1,sizeof(index1));
	CRC_write(handle,&under1,sizeof(under1));
}

void Mover2::place() {
	long cd = costab[angle]<<shdim,
		 sd = sintab[angle]<<shdim;
	index = xytoidx(x+cd,y+sd);
	index1 = xytoidx(x-cd,y-sd);
	enqueue(index,under);
	if (index1!=index) enqueue(index1,under1);
}

void Mover2::remove() {
	dequeue(index,under);
	if (index1!=index) dequeue(index1,under1);
}

int Mover2::underq(int idx) {
	if (idx == index) return under;
				 else return under1;
}

void Mover2::correctq(int idx, int undid) {
	if (idx == index) under = undid;
				 else under1 = undid;
}

/*
char Mover2::move(int lshift) {
	fixed ca = costab[angle],
		  sa = sintab[angle],
		  nx = x + (ca<<lshift),
		  ny = y + (sa<<lshift);
	char moved=0;
	if (!ca) moved++; else
	if (ca>0l) {if (canmove(nx+(FIXONE<<shdim),y)) {x=nx;moved++;}}
		else if (canmove(nx-(FIXONE<<shdim),y)) {x=nx;moved++;}
	if (!sa) moved++; else
	if (sa>0l) {if (canmove(x,ny+(FIXONE<<shdim))) {y=ny;moved++;}}
		else if (canmove(x,ny-(FIXONE<<shdim))) {y=ny;moved++;}
	return (moved==2);
}

char Mover2::fluidmove(fixed mult) {
	fixed ca = costab[angle],
		  sa = sintab[angle],
		  nx = x + fixmul(ca,mult),
		  ny = y + fixmul(sa,mult);
	char moved;
	if (!ca) moved++; else
	if (ca>0l) {if (canmove(nx+(FIXONE<<shdim),y)) {x=nx;moved++;}}
		else if (canmove(nx-(FIXONE<<shdim),y)) {x=nx;moved++;}
	if (!sa) moved++; else
	if (sa>0l) {if (canmove(x,ny+(FIXONE<<shdim))) {y=ny;moved++;}}
		else if (canmove(x,ny-(FIXONE<<shdim))) {y=ny;moved++;}
	return (moved==2);
}
*/

/*
char Mover3::canmove(fixed nx, fixed ny) {
	int idx, top;
	Mover *mvr;
	fixed dist;
			// !!! si possono togliere i margini !?
	if ((nx >= (32l<<FIXSHIFT)) && (nx <= LMAX_X-(32l<<FIXSHIFT)) &&
		(ny >= (32l<<FIXSHIFT)) && (ny <= LMAX_Y-(32l<<FIXSHIFT))) {
		if (!ObjMap[idx = xytoidx(nx,ny)].unwalkable) return 1;
		else {
			if (map[idx]) {
			top = (Map[xytoidx(x,y)].shape != Map[idx].shape);
			switch(Map[idx].shape) {
				case MSH_SQUARE:
				case MSH_DOOR:
					return 0;
				case MSH_VERT:
					if (((lshr16(x)>>5) & 1 == (lshr16(nx)>>5) & 1) &&
						((lshr16(nx)>>5) & 1) ^ ((lshr16(x)>>5) & 1))
						return 0;
					break;
				case MSH_HORIZ:
					if (((lshr16(y)>>5) & 1 == (lshr16(ny)>>5) & 1) &&
						((lshr16(ny)>>5) & 1) ^ ((lshr16(y)>>5) & 1))
						return 0;
					break;
				case MSH_DIAG1:
					if (((lshr16(x)>>6)+(lshr16(y)>>6) & 1) ^
						 ((lshr16(nx)>>6)+(lshr16(ny)>>6) & 1) &&
						((lshr16(LMAX_X-1-nx+ny)>>6) & 1) ^
						 ((lshr16(LMAX_Y-1-x+y)>>6) & 1))
						return 0;
					break;
				case MSH_DIAG2:
					if (((lshr16(x)>>6)+(lshr16(y)>>6) & 1) ^
						 ((lshr16(nx)>>6)+(lshr16(ny)>>6) & 1) &&
						((lshr16(nx+ny)>>6) & 1) ^
						 ((lshr16(x+y)>>6) & 1))
						return 0;
					break;
			}
			}
			top = IDMap[idx];
			while (top) {
				mvr = objectslist.get(top-1)->mover;
				if (mvr->flags & OMM_UNWALKABLE) {
					dist = (FIXONE<<shdim)+(FIXONE<<mvr->shdim);

				//if (LABS(mvr->x-nx) <= dist ||
				//	LABS(mvr->y-ny) <= dist) return 0;
				//if (fixdist(mvr->x-nx,mvr->y-ny) <= dist) return 0;
					if (LABS(mvr->x-nx)+LABS(mvr->y-ny) <= dist) return 0; // !!!!!
				}
				top = mvr->underq(idx);
			}
			return 1;
		}
	}
	return 0;
}
*/
/*
char Mover3::canmove(fixed nx, fixed ny) {
	char candoit;
	int id, idx, xang, yang;
	Mover *mvr;
	fixed cx,cy,alt,dist,basedist;
	basedist = FIXONE<<shdim;

			// !!! si possono togliere i margini !?
	if ((nx >= (32l<<FIXSHIFT)) && (nx <= LMAX_X-(32l<<FIXSHIFT)) &&
		(ny >= (32l<<FIXSHIFT)) && (ny <= LMAX_Y-(32l<<FIXSHIFT))) {
		if (nx>x) xang=ANG0; else xang=ANG180;
		cx=x;cy=y;
		id = fireray(cx,cy,xang,dist,alt,id);
		candoit = (dist>=basedist) || (id<-1);
		//if (dist<basedist) nx=fixmul(basedist,costab[xang]);
		if (ny>y) yang=ANG90; else yang=ANG270;
		cx=x;cy=y;
		id = fireray(cx,cy,yang,dist,alt,id);
		candoit = candoit && ((dist>=basedist) || (id<-1));
		if (xang==ANG0)
			if (yang==ANG90) xang=ANG45;
						else xang=ANG270+ANG45;
		else
			if (yang==ANG90) xang=ANG90+ANG45;
						else xang=ANG180+ANG45;
		cx=x;cy=y;
		id = fireray(cx,cy,xang,dist,alt,id);
		candoit = candoit && ((dist>=basedist) || (id<-1));
		return candoit;
	}
	return 0;
}
*/
Object::Object(fixed px, fixed py, int startfig,
			   char numfig, byte movertype) {
	switch (movertype) {
		case MVT_0:
			delete mm_reserve(sizeof(Mover));
			mover = new Mover;
			break;
		case MVT_1:
			delete mm_reserve(sizeof(Mover1));
			mover = new Mover1;
			break;
		case MVT_2:
			delete mm_reserve(sizeof(Mover2));
			mover = new Mover2;
			break;
		/*
		case MVT_3:
			delete mm_reserve(sizeof(Mover3));
			mover = new Mover3;
			break;
		*/
		default: error("Object","invalid Mover");
	}
	if (mover == NULL) error("Object","no Mover");
	mover->x = px;
	mover->y = py;
	mover->z = 0l;
	//mover->flags = OMF_UNWALKABLE | OMF_VISIBLE | OMF_HITABLE | OMF_SOUNDABLE;
	mover->angle = 0;
	mover->shdim = 4;
	oflags = 0;
	selflight = 0;
	changefig(startfig,numfig);
	object_type = OBJT_OBJECT;
}

Object::Object(int handle) {// Constructor Load
	byte movertype;

	CRC_read(handle,&movertype,sizeof(movertype));
	switch (movertype) {
		case MVT_0:
			delete mm_reserve(sizeof(Mover));
			mover = new Mover(handle);
			break;
		case MVT_1:
			delete mm_reserve(sizeof(Mover1));
			mover = new Mover1(handle);
			break;
		case MVT_2:
			delete mm_reserve(sizeof(Mover2));
			mover = new Mover2(handle);
			break;
		/*
		case MVT_3:
			delete mm_reserve(sizeof(Mover3));
			mover = new Mover3(handle);
			break;
		*/
		default: error("Object","invalid Mover");
	}
	if (mover == NULL) error("Object","no Mover");
	mover->mover_type = movertype;	// Lo informo IO !
	CRC_read(handle,&oflags,sizeof(oflags));
	CRC_read(handle,&selflight,sizeof(selflight));
	CRC_read(handle,&figstart,sizeof(figstart));
	CRC_read(handle,&fignum,sizeof(fignum));
}

void Object::save(int handle) {
	CRC_write(handle,&object_type,sizeof(object_type));
	mover->save(handle); //saves also the Mover Type
	CRC_write(handle,&oflags,sizeof(oflags));
	CRC_write(handle,&selflight,sizeof(selflight));
	CRC_write(handle,&figstart,sizeof(figstart));
	CRC_write(handle,&fignum,sizeof(fignum));
}

void Object::changefig(int startfig, char numfig) {
	if (startfig+numfig-1 < MAXFIGURES) {
	  if (numfig<0) {
		oflags |= OFL_REVERSE;
		numfig = -numfig;
	  } else oflags &= ~OFL_REVERSE;
	  if ((numfig==16) || (numfig==8) ||
		  (numfig==4) || (numfig==2) || (numfig<=1)) {
		figstart = startfig;
		fignum = numfig;
	  } else error("Object::changefig","views must be powers of 2");
	} else error("Object::changefig","out of range");
}

int Object::getviewfig(int ang) {
	int displ = ANG360 / fignum;
	if (fignum > 1) {
		int myfig = (ang-mover->angle+(displ >> 1));
		if (myfig<ANG0) myfig+=ANG360; else
		 if (myfig>=ANG360) myfig-=ANG360;
		if (oflags & OFL_REVERSE) {
			if ((myfig = (myfig/displ)&(fignum-1))>(fignum>>1)) {
				myfig |= 0x4000;
				myfig = fignum-myfig;
			}
			return figstart+myfig;
		} else return figstart+((myfig/displ)&(fignum-1));
	} else
		return figstart;
}

void Object::handle_event(TEvent &event) {
int arctan[8][8] = {
{ANG45,ANG30,ANG30, ANG0, ANG0, ANG0, ANG0, ANG0},
{ANG60,ANG45,ANG30,ANG30,ANG30, ANG0, ANG0, ANG0},
{ANG60,ANG60,ANG45,ANG45,ANG30,ANG30,ANG30, ANG0},
{ANG90,ANG60,ANG45,ANG45,ANG45,ANG30,ANG30,ANG30},
{ANG90,ANG60,ANG60,ANG45,ANG45,ANG45,ANG45,ANG30},
{ANG90,ANG90,ANG60,ANG60,ANG45,ANG45,ANG45,ANG45},
{ANG90,ANG90,ANG60,ANG60,ANG45,ANG45,ANG45,ANG45},
{ANG90,ANG90,ANG60,ANG60,ANG60,ANG45,ANG45,ANG45}};
	switch (event.what) {
		case EV_GOT: eventmanager.sendcom(EV_KILL,mover->id); break;
		case EV_BOOM:
			fixed fdx, fdy;
			int dx = lshr16(fdx = mover->x-event.data.pos.x),
				dy = lshr16(fdy = mover->y-event.data.pos.y),
				//power = (ABS(dx)+ABS(dy))/28,
				ang = 0;
			int power = fixdiv(fixdist(fdx,fdy),20l<<16);
			if (power) power = event.data.pos.z/power;
				  else power = event.data.pos.z;
			// if (power<4) break;
			if (power<4 || lookray(mover->x,mover->y,
						event.data.pos.x,event.data.pos.y,OMM_SOUNDABLE)) break;
			// SOUNDABLE perch le grate non devono bloccare !!!
			if (!dx) if (dy>=0) ang=ANG90; else ang=ANG270; else
			if (!dy) if (dx>=0) ang=ANG0; else ang=ANG180; else {
				int d1x = dx, d1y = dy;
				if (dx>0) {if (--dx>7) dx=7;} else
						  {if (++dx<-7) dx=-7;}
				if (dy>0) {if (--dy>7) dy=7;} else
						  {if (++dy<-7) dy=-7;}
				ang = arctan[ABS(dy)][ABS(dx)];
				if (d1x<0) ang=ANG180-ang;
				if (d1y<0) ang=ANG360-ang;
				if (ang<ANG0) ang+=ANG360; else
				 if (ang>=ANG360) ang-=ANG360;
			}
			eventmanager.senddirect(EV_HIT,event.source,mover->id,ang,power);
			eventmanager.senddirect(EV_ADDSTAT,mover->id,event.source,
									STT_TECNO,1);
			if (GETFLAG(gameflags,GFL_SHOWBLOOD)) {
				Object *obj;
				if (doblood(ang))
					eventmanager.senddirect(EV_ADDSTAT,mover->id,event.source,
											STT_BLOOD,5);
				doblood(angleadd(ang,ANG45));
				doblood(anglesub(ang,ANG45));
				doblood(angleadd(ang,ANG45+ANG90));
				doblood(anglesub(ang,ANG45+ANG90));
			}
			break;
	}
}

Object::~Object() {
	if (!ShutDown) mover->remove();
	delete mover;
}

Actor::Actor(int handle)
	  :Object(handle) { // Load Constructor
	CRC_read(handle,&animcount,sizeof(animcount));
	CRC_read(handle,&health,sizeof(health));
}

void Actor::save(int handle) {
	Object::save(handle);
	CRC_write(handle,&animcount,sizeof(animcount));
	CRC_write(handle,&health,sizeof(health));
}

void Actor::setid(int the_id) {
	Object::setid(the_id);
	makeActor();
};

char Actor::makeActor() {
	if (!(oflags & OFL_ISACTOR)) {
		actorslist.add(mover->id);
		oflags |= OFL_ISACTOR;
		return 1;
	}
	return 0;
}

char Actor::makeObject() {
	//actorslist.erase(mover->id);
	if (oflags & OFL_ISACTOR) {
		if (eventmanager.sendcom(EV_ERASEACT,mover->id)) {
			oflags &= ~OFL_ISACTOR;
			return 1;
		}
	}
	return 0;
}

char Actor::nearPlayer(fixed maxdist) {
	return (is_nearPlayer(mover->x,mover->y,maxdist) >= 0);
}

/*
byte Actor::getviewfig(int ang) {
	int displ = ANG360 / fignum;
	if (fignum > 0)
	 return figstart+(animcount*fignum)+(((ang-mover->angle+(displ >> 1)+ANG360) % ANG360)/displ) % fignum;
	else
	 return figstart;  ??? ma siamo sicuri che era cos ?
}
*/
int Actor::getviewfig(int ang) {
	int displ = ANG360 / fignum;
	if (fignum > 1) {
		int myfig = (ang-mover->angle+(displ >> 1));
		if (myfig<ANG0) myfig+=ANG360; else
		 if (myfig>=ANG360) myfig-=ANG360;
		if (oflags & OFL_REVERSE) {
			if ((myfig = (myfig/displ)&(fignum-1))>(fignum>>1)) {
				myfig |= 0x4000;
				myfig = fignum-myfig;
			}
			return figstart+(animcount*((fignum>>1)+1))+myfig;
		} else return figstart+(animcount*fignum)+((myfig/displ)&(fignum-1));
	} else
		return figstart+animcount;
}

/*
void Actor::handle_event(Event &event) {
	// Object::handle_event(event);
	if (event.what == EV_HIT &&
		(event.x == index1 || event.x == index2)) {
		if ((health-=event.y) <= 0)
			eventmanager.send(EV_KILL,id,0,0);
	}
}
*/

void Actor::draw(int vidx, int vidy, char &cd, char &fd) {
	drawview(vidx,vidy,mover->x,mover->y,mover->z,
			 mover->angle,0,mover->id,cd,fd,0);
}

void Actor::virtualdraw() {
	virtualview(mover->x,mover->y,mover->angle,mover->id);
}

void Actor::transf(int vidx, int vidy) {
	/*
	if (viewwidth==320) ftransfarea(0,168,VMEMPTR); // !!!
	else
	*/
	ftransfblock(vidx-halfwidth,vidy-halfheight,viewwidth,viewheight,VMEMPTR);
}

Actor::~Actor() {
	if (!ShutDown) actorslist.erase(mover->id);
	//Object::~Object();
}

LightActor::LightActor(int handle)
		   :Actor(handle) {	 // Constructor Load
	CRC_read(handle,&lightrange,sizeof(lightrange));
	if (GETFLAG(oflags,OFL_HASLIGHT)) {
		CRC_read(handle,&lightz,sizeof(lightz));
		CRC_read(handle,&lightpow,sizeof(lightpow));
	}
}

void LightActor::save(int handle) {
	Actor::save(handle);
	CRC_write(handle,&lightrange,sizeof(lightrange));
	if (GETFLAG(oflags,OFL_HASLIGHT)) {
		CRC_write(handle,&lightz,sizeof(lightz));
		CRC_write(handle,&lightpow,sizeof(lightpow));
	}
}

void LightActor::lights() {
	if (!lightrange) return;

	int i,j,k;
	int bx = lshr16(mover->x) >> 6,
		by = lshr16(mover->y) >> 6,
		lr2 = (lightrange<<1)-1;
	char *map1 = &(LightMap[bxytoidx(bx-lightrange,by-lightrange)]),
		 *map2;

	for (i=-lightrange;i<=lightrange;i++,map1+=MAP_DX)
	  if ((bx+i) >= 0 && (bx+i) < MAP_DX )
		for (j=-lightrange,map2=map1;j<=lightrange;j++,map2++)
		  if ((by+j) >= 0 && (by+j) < MAP_DY )
			if ((k = lr2-(ABS(i)+ABS(j))) > 0) *map2 += k;
}

void LightActor::unlights() {
	if (!lightrange) return;

	int i,j,k;
	int bx = lshr16(mover->x) >> 6,
		by = lshr16(mover->y) >> 6,
		lr2 = (lightrange<<1)-1;
	char *map1 = &(LightMap[bxytoidx(bx-lightrange,by-lightrange)]),
		 *map2;

	for (i=-lightrange;i<=lightrange;i++,map1+=MAP_DX)
	  if ((bx+i) >= 0 && (bx+i) < MAP_DX )
		for (j=-lightrange,map2=map1;j<=lightrange;j++,map2++)
		  if ((by+j) >= 0 && (by+j) < MAP_DY )
			if ((k = lr2-(ABS(i)+ABS(j))) > 0) *map2 -= k;
}

void LightActor::place() {
	mover->place();
	lights();
}

void LightActor::remove() {
	mover->remove();
	unlights();
}

LightActor::~LightActor() {
	if (!ShutDown) unlights();
}

char CanFireActor::setarm(byte armtype) {
	if (armtype == curarm) return 1;
	if (GETFLAG(armflag,ArmList[armtype].flag) && !armcharge) {
		if (armchanging<(ARMCHGSPEED/2)) {
			oldarm = curarm;
			armchanging = ARMCHGSPEED-armchanging;
		}
		curarm = armtype;
		return 1;
	}
	return 0;
}

//#pragma warn -par
char CanFireActor::fire(int angle) {
	if (!armcharge && !armchanging &&
		(!curarm || Armbull[curarm-1]>0)) {
		armcharge = ArmList[curarm].chargetime;
		if (curarm) Armbull[curarm-1]--;
		return 1;
	}
	return 0;
}
//#pragma warn +par

CanFireActor::CanFireActor(fixed px, fixed py, int startfig,
							char numfig, byte movertype)
			 :LightActor(px,py,startfig,numfig,0,0,movertype),
			  curarm(0), oldarm(0),
			  armcharge(0), armchanging(0), armflag(0)
{	object_type=OBJT_CANFIREACTOR;
	fwfill(Armbull,0,sizeof(Armbull));
}

CanFireActor::CanFireActor(int handle)
			 :LightActor(handle) { // Constructor Load
	CRC_read(handle,&armflag,sizeof(armflag));
	CRC_read(handle,&curarm,sizeof(curarm));
	CRC_read(handle,&armcharge,sizeof(armcharge));
	CRC_read(handle,Armbull,sizeof(Armbull));
	armchanging=0; //oldarm=curarm;
}

void CanFireActor::save(int handle) {
	LightActor::save(handle);
	CRC_write(handle,&armflag,sizeof(armflag));
	CRC_write(handle,&curarm,sizeof(curarm));
	CRC_write(handle,&armcharge,sizeof(armcharge));
	CRC_write(handle,Armbull,sizeof(Armbull));
}

void CanFireActor::animate() {
	// Object::animate();
	if (armchanging) {
		armchanging--;
	} else {
		// Warning!  It doesn't remove & place !
		if (curarm) {
			lightrange = (armcharge+8)>>4;	// !!!
			if (!armcharge && !Armbull[curarm-1]) {
				byte old = curarm;
				byte app = curarm;
				do {
					while (app && !Armbull[app-1]) app--;
				} while (!setarm(app--));
				// ! WARNING !  Non tutti dovrebbero farlo !
				// A questo punto era meglio nel setarm() !!!
				if (old!=curarm)
					eventmanager.sendshort(EV_UPDATEBAR,mover->id,0,IBR_ARMS,0);
			}
		}
		if (armcharge) armcharge--;
	  }
}

char CanFireActor::takearm(byte armtype) {
	TArm &arm = ArmList[armtype];
	byte token = 0;
	if (!GETFLAG(armflag,arm.flag)) {
		SETFLAG(armflag,arm.flag);
		token |= 2;
		// anche se non vengono prese le munizioni
		if (curarm<armtype) setarm(armtype);
	}
	token |= takeammo(armtype,arm.pre_ammo);
	return token;
}

char CanFireActor::takeammo(byte armtype, int ammo) {
	TArm &arm = ArmList[armtype];
	if (Armbull[armtype-1] < arm.max_ammo) {
		if ((Armbull[armtype-1] += ammo) > arm.max_ammo)
			Armbull[armtype-1] = arm.max_ammo;
		if (/*Armbull[armtype-1]==ammo &&*/curarm<armtype) setarm(armtype);
		return 1;
	}
	return 0;
}

ObjectsList::ObjectsList() {
	objnum = 0;
	fdfill(&objectslist,0l,MAXOBJECTS * sizeof(Object *));
}

void ObjectsList::loadobj(Object *object,byte objtype) {
	objlist[object->mover->id]=object;
	if ((object->oflags & OFL_ISACTOR) == OFL_ISACTOR)
		actorslist.add(object->mover->id);
	object->object_type=objtype;	// !!! lo informo io...
	objnum++;
}

void ObjectsList::save(int handle) {
	int objid=0, num=objnum;
	while (num) {
		if (objlist[objid] != NULL) {
			objlist[objid]->save(handle);
			num--;
		}
		objid++;
	}
	objid = OBJT_END;
	CRC_write(handle,&objid,1);	// !!! attenzione 1 - sizeof(objtype)==1 !!!
}

void ObjectsList::put(Object *object) {
	if (object == NULL) error("ObjectsList::put","no Object");
	if (objnum < MAXOBJECTS) {
		int i = 0;
		while (objlist[i] != NULL) i++;
		objlist[i] = object;
		object->setid(i);
		object->place();	// !!!
		objnum++;
	} else delete object;	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//error("ObjectList::put","too many Objects");
}

Object *ObjectsList::get(int objidx) {
	if (objidx < MAXOBJECTS)
		return objlist[objidx];
	return NULL;
}

void ObjectsList::erase(int objidx) {
	if (objidx < MAXOBJECTS)
		if (objlist[objidx] != NULL) {
			delete objlist[objidx];
			objlist[objidx] = NULL;
			objnum--;
		}
}

void ObjectsList::eraseall() {
	int objidx=0;
	while (objnum) {
		if (objlist[objidx] != NULL) {
			delete objlist[objidx];
			objlist[objidx] = NULL;
			objnum--;
		}
		objidx++;
	}
}

/*
void ObjectsList::reset() {
	for (int i=0, j=0; j<objnum, i<MAXOBJECTS; i++)
		if (objlist[i] != NULL) {
			objlist[i]->reset();
			j++;
		}
}
*/

void ObjectsList::handle_event(TEvent &event) {
	for (int i=0, j=0; j<objnum, i<MAXOBJECTS; i++)
		if (objlist[i] != NULL) {
			objlist[i]->handle_event(event);
			j++;
		}
}

void ObjectsList::preloadall() {
	int k;
	for (int i=0, j=0; j<objnum, i<MAXOBJECTS; i++)
		if (objlist[i] != NULL) {
			Object &obj = *objlist[i];
			if (obj.fignum>0) k=obj.fignum;
			 else k=(obj.fignum>>1)+1;
			for(;k--;) mm_recall(FigList[obj.figstart+k].memidx);
			j++;
		}
}

ObjectsList::~ObjectsList() {
	int i=0;
	while (objnum) {
		while (!objlist[i]) i++;
		erase(i++);
	}
}

void ActorsList::add(int objidx) {
	register int i;
	if (actorsnum < MAXACTORS) {
		i=0;
		while ((i<actorsnum) && (actorslist[i] != objidx)) i++;
		if (i == actorsnum)
			actorslist[actorsnum++] = objidx;
		// else error("ActorsList::add - actor already exists");  		// !!!
	} else error("ActorList::add","too many Actors");
	/*  Versione senza controllo doppie
	if (actorsnum < MAXACTORS) {
		actorslist[actorsnum++] = objidx;
	} else abort();
	*/
}

void ActorsList::erase(int objidx) {
	for (int i=0; i<actorsnum; i++)
		if (actorslist[i] == objidx) {
			actorslist[i] = actorslist[--actorsnum];
			return;
		}
}

void ActorsList::eraseall() {
	actorsnum=0;
}

void ActorsList::animate() {
	for (int i=0; i<actorsnum; i++)
		((Actor *)objectslist.get(actorslist[i]))->animate();
}

void ActorsList::handle_event(TEvent &event) {
	for (int i=0; i<actorsnum; i++)
		objectslist.get(actorslist[i])->handle_event(event);
}

void ActorsList::reset() {
	// Must be fast !
	for (register int i=0;i<actorsnum;i++)
		objectslist.objlist[actorslist[i]]->reset();
}

void DrawList::add(int objid, long objdist) {
	int i;
	if (drawnum < MAXDRAWING) {
		i = drawnum++;
		while (i && distlist[i-1]>objdist) i--;
		if (drawnum-i > 1) {
			fodmove(&drawlist[i+1],&drawlist[i],(drawnum-i-1)*sizeof(objid));
			fodmove(&distlist[i+1],&distlist[i],(drawnum-i-1)*sizeof(objdist));
		}
		/*
		while (i && distlist[i-1]>objdist) {
			drawlist[i] = drawlist[i-1];
			distlist[i] = distlist[i-1];
			i--;
		}
		*/
		drawlist[i] = objid;
		distlist[i] = objdist;
	} //else error("DrawList::add - too many Objects"); !!!
}

int DrawList::get(fixed &objdist) {
	if (drawnum) {
		objdist = distlist[--drawnum];
		return drawlist[drawnum];
	} else return 0xffff;
}