/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

#define	VMEMPTR		((void _seg *)0xA000+(void near *)0x0000)

#define MakeID(d,c,b,a) ((unsigned long)(a)<<24 | (unsigned long)(b)<<16 | (unsigned long)(c)<<8 | (unsigned long)(d))
#define CK_FORM 	MakeID('F','O','R','M')
#define ID_PBM  	MakeID('P','B','M',' ')
#define ID_ILBM 	MakeID('I','L','B','M')
#define ID_BMHD 	MakeID('B','M','H','D')
#define ID_CMAP 	MakeID('C','M','A','P')
#define ID_BODY 	MakeID('B','O','D','Y')

typedef struct {
			long  ID_type;
			long  cksize;
			long  ID_subtype;
		} form_chunk;
typedef struct {
			long  ID_chunk;
			long  cksize;
		} chunk_header;
typedef struct {
	unsigned 		width, height;  // raster width & height in pixels
	unsigned		x, y;         	// position for this image
	unsigned char	nPlanes;      	// # source bitplanes
	unsigned char	masking;    	// masking technique
	unsigned char 	compression;  	// compression algorithm
	unsigned char	no;         	// <UNUSED> (0)
	unsigned 		transparent;	// transparent "color number"
	unsigned char 	x_aspect, y_aspect; // aspect ratio, x/y
	unsigned  		p_width, p_height;  // source "page" size in pixels
} bitmap_header;

extern void far *vbuff;

extern word xytodisp(word x, word y);
extern void setvrect(int x, int y, int dx, int dy);
extern void initL();
extern void doneL();
extern void setvbuff(void far *buff);
extern void putpix(word x, word y, byte col);
extern byte getpix(word x, word y);
extern void ffillscreen(long col);
extern void ffillarea(word y, word dey, long col);
extern void ftransfscreen(void far *dest);
extern void ftransfarea(word y, word dey, void far *dest);
extern void fcopyarea(word y, word y1, word dey, void far *dest);
extern void ffillblock(word x, word y, word dex, word dey, long col);
extern void ftransfblock(word x, word y, word dex, word dey, void far *dest);
extern void fcopyblock(word x, word y, word x1, word y1,
				word dex, word dey, void far *dest);
extern void getlfig(word x, word y, word dex, word dey, void far *data);
extern void getrfig(word x, word y, word dex, word dey, void far *data);
extern void storelfig(word x, word y, word dex, word dey, void far *data);
extern void storerfig(word x, word y, word dex, word dey, void far *data);
extern void putlfig(word x, word y, word dex, word dey, void far *data);
extern void putrfig(word x, word y, word dex, word dey, void far *data);
extern void putlchar(word x, word y, word dex, word dey,
				byte col1, byte col2, void far *data);
extern void putlschar(word x, word y, word dex, word dey,
				byte addcol, void far *data);
extern void getlvfig(int x, int y, word dex, word dey, void far *data);
extern void storelcfig(int x, int y, word dex, word dey, void far *data);
extern void putlcfig(int x, int y, word dex, word dey, void far *data);
extern void putlcchar(int x, int y, word dex, word dey,
				byte col1, byte col2, void far *data);
extern void scalerscfig(int x, int y, word dex, word dey,
				int vdx, int vdy, char shade, void far *rfig);
extern void storelmfig(word x, word y, word dex, word dey,
				void far *mask, void far *data);
extern char loadLBM(const char *filename, void far *pal);