/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// 3D_Sound - (C)1997  Nicosot (Valentini Domenico)

// #include <dos.h>

#include "std.hpp"
#include "errorstr.hpp"
#include "fastmem.hpp"
#include "fixed.h"
#include "mm4.hpp"
#include "3dsdriv.hpp"
#include "3dsound.hpp"

#include "events.hpp"
#include "kaos.hpp"
#include "objects.hpp"
#include "3dengine.hpp"	// sound ray-casting

#include <io.h>
#include <fcntl.h>

#include <stdlib.h> 	// per getenv()

//#define FIRMRIFF	((long)'R'+((long)'I'<<8)+((long)'F'<<16)+((long)'F'<<24))
//#define FIRMWAVE	((long)'W'+((long)'A'<<8)+((long)'V'<<16)+((long)'E'<<24))
//#define FIRMfmt 	((long)'f'+((long)'m'<<8)+((long)'t'<<16)+((long)' '<<24))
#define FIRMdata	((unsigned long)'d'+((unsigned long)'a'<<8)+((unsigned long)'t'<<16)+((unsigned long)'a'<<24))

char synctab[17][9] = {
//  0   +1   +2   +3   +4   +5   +6   +7   +8
{   0,   0,   1,   2,   3,   4,   5,   5,   5},
{   0,   0,   1,   2,   3,   4,   5,   5,   6},
{   0,   0,   2,   3,   4,   5,   5,   6,   7},
{   0,   0,   3,   4,   4,   5,   5,   6,   7},
{   0,   1,   3,   4,   5,   6,   6,   7,   8},
{   0,   1,   4,   5,   6,   7,   7,   9,   9},
{   0,   2,   5,   8,   9,   9,   9,   9,   9},
{   0,   5,   8,   9,   9,  10,  10,  10,  10},
{   0,  10,  10,  10,  10,  10,  10,  10,  10},
{   0,  60,   8,  10,  10,  10,  10,  10,  10},
{   0,  80,  50,  20,  15,  15,  12,  12,  12},
{   0, 100,  70,  50,  30,  20,  15,  15,  15},
{   0, 110,  90,  60,  50,  30,  25,  20,  20},
{   0, 115, 100,  70,  55,  50,  40,  30,  25},
{   0, 120, 110,  80,  65,  55,  50,  40,  40},
{   0, 127, 120,  90,  70,  60,  55,  50,  45},
{   0, 127, 127, 100,  80,  65,  60,  55,  50}};

typedef struct {
	int id;				// 2
	int ownerid;		// 2
	int memidx;			// 2
	unsigned size; 		// 2
	unsigned curpos;  	// 2
	fixed x, y;         // 8
	byte lvol, rvol;    // 2
	char desync;		// 1
	byte flags;         // 1
	char fadespeed;     // 1
	byte fadecount;     // 1
} TSound;               // = 24 bytes

typedef struct {
	int memidx;
	word size;
} TSoundData;

int sm_soundnum = 0,
	idcnt = 0,
	sm_soundvol = SM_NORMVOL;
char bufferhigh = 0,
	 bufferready = 0,
	 playing = 0,
	 sm_lrinverted = 0,
	 sm_soundok = 0,
	 snd_dma_off = 1;
int *appbuf;
TSound soundlist[MAXSOUNDS];
TSoundData *sounddata = new TSoundData[MAXSNDDATA];

void far interrupt soundISR(...) {
	sb_ackDMA();
	if ((playing = --bufferready) != 0) {
		if (sb_type < SBT_SB16) sb_enableDMA();
	} else
		if (sb_type >= SBT_SB16) sb_stopDMA();
	asm {
		MOV AL, 0x20
		OUT 0x20, AL
	}
}

void near resetbuffer() {
asm {
	LES DI, appbuf
	DB 0x66; MOV AX, 0x0080; DW 0x0080 	// MOV EAX, 0x00800080
	MOV CX, DMAbuffer_size
	SHR CX, 1					// solo diviso 2 perch di INT
	CLD
	REP
	  DB 0x66; STOSW	// REP STOSD
}}

void adjsample(char far *sample, unsigned len) {
asm {
	MOV CX, len
	LES DI, sample
	LDS SI, sample
	MOV BL, -128
	CLD
} c1: asm {
	LODSB
	ADD AL, BL
	STOSB
	LOOP c1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void near adjstorebuffer(byte far *buffer) {
asm {
	//PUSH DS
	MOV CX, DMAbuffer_size
	LES DI, buffer
	LDS SI, appbuf
	MOV DX, 255
	// MOV BX, 128
	CLD
} c1: asm {
	LODSW		// Int INPUT
	// ADD AX, BX
	OR AX, AX
	JNS over
	XOR AL, AL
	JMP store
} over: asm {
	CMP AX, DX
	JLE store
	MOV AL, DL
} store: asm {
	STOSB		// Byte OUTPUT
	LOOP c1
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
} end:; }

// !!!
void near delsound(int indx) {
	TSound &sound = soundlist[indx];
	//mm_unlock(sound.memidx); //!!!!!
	if (sound.ownerid!=SYSOWN)
		eventmanager.senddirect(EV_ENDSOUND,sound.id,sound.ownerid,0,0);
	else
		eventmanager.sendshort(EV_ENDSOUND,sound.id,SYSOWN,0,0);
	sound = soundlist[--sm_soundnum];
}

char near sm_mixmonosound(TSound &sound, char *data, int vol) {
	register int curpos, i;
	register char *sorg;
	register int *dest;
	int size;

	sorg = data + (curpos = sound.curpos);
	dest = appbuf;
	size = sound.size;
	for (i = DMAbuffer_size>>1; i--;) {
		*(dest++) += *(sorg++) * vol >> SM_VOLSHIFT;
		if (++curpos >= size)
			if (GETFLAG(sound.flags,SFL_CONTINUE)) {
				sorg = data;
				curpos = 0;
			} else return 0;
	}
	sound.curpos = curpos;
	return 1;
}

char near sm_mixstereosound(TSound &sound, char *data, int lvol, int rvol) {
	register int curpos, i;
	register char *sorg;
	register int *dest;
	int sample,size;

	sorg = data + (curpos = sound.curpos);
	dest = appbuf;
	size = sound.size;
	for (i = DMAbuffer_size>>1; i--;) {
		*(dest++) += (sample = *(sorg++)) * lvol >> SM_VOLSHIFT;	// L
		*(dest++) += sample * rvol >> SM_VOLSHIFT;			    	// R
		if (++curpos >= size) {
			if (GETFLAG(sound.flags,SFL_CONTINUE)) {
				sorg = data;
				curpos = 0;
			} else return 0;
		}
	}
	sound.curpos = curpos;
	return 1;
}

char near sm_mix3Dsound(TSound &sound, char *data,
						int lvol, int rvol, char desync) {
	register int lpos, rpos, i;
	char *lsorg, *rsorg;
	char sample, ldrive;
	int *dest;
	int size;

	lpos = rpos = (int)sound.curpos;
	ldrive = (desync<0);
	size = sound.size;
	if (ldrive) {
		rpos += desync;
		if (rpos<0)
			if (GETFLAG(sound.flags,SFL_CONTINUE))
				rpos += size;
	} else {
		lpos -= desync;
		if (lpos<0)
			if (GETFLAG(sound.flags,SFL_CONTINUE))
				lpos += size;
	  }
	lsorg = data + lpos;
	rsorg = data + rpos;
	dest = appbuf;
	if (ldrive) {
		for (i=DMAbuffer_size>>1; i--;) {
			// Left
			//if (lpos>=0)
				*(dest++) += ((int)*(lsorg++)) * lvol >> SM_VOLSHIFT;
			//else {dest++;lsorg++;}
			// Right
			if (rpos>=0)
				*(dest++) += ((int)*(rsorg++)) * rvol >> SM_VOLSHIFT;
			else {dest++;rsorg++;}
			if (++lpos >= size) {
				if (GETFLAG(sound.flags,SFL_CONTINUE)) {
					lsorg = data;
					lpos = 0;
				} else return 0;
				//lpos = -32000;
			}
			if (++rpos >= size) {
				if (GETFLAG(sound.flags,SFL_CONTINUE)) {
					rsorg = data;
					rpos = 0;
				} // else return 0;
			}
		}
		//if (lpos<0) return 0;
		sound.curpos = lpos;
	} else {
		for (i=DMAbuffer_size>>1; i--;) {
			// Left
			if (lpos>=0)
				*(dest++) += ((int)*(lsorg++)) * lvol >> SM_VOLSHIFT;
			else {dest++;lsorg++;}
			// Right
			//if (rpos>=0)
				*(dest++) += ((int)*(rsorg++)) * rvol >> SM_VOLSHIFT;
			//else {dest++;rsorg++;}
			if (++rpos >= size) {
				if (GETFLAG(sound.flags,SFL_CONTINUE)) {
					rsorg = data;
					rpos = 0;
				} else return 0;
				//else rpos = -32000;
			}
			if (++lpos >= size) {
				if (GETFLAG(sound.flags,SFL_CONTINUE)) {
					lsorg = data;
					lpos = 0;
				} // else return 0;
			}
		}
		//if (rpos<0) return 0;
		sound.curpos = rpos;
	  }
	return 1;
}

void soundmanager(fixed cx, fixed cy, int angle) {
	register int i, lk, rk;
	int rv, lv, obstacles, vdr, vdl;
	char desync, play;
	fixed x,y,viewcos, viewsin;
	char far *data;

	if (!sm_soundok || !sm_soundnum || bufferready==2) return;

	viewcos = costab[angle];
	viewsin = sintab[angle];

	resetbuffer();
	for (i=0; i<sm_soundnum; i++) {
		TSound &sound = soundlist[i];
		if (GETFLAG(sound.flags,SFL_FADE)) {
			if (sound.fadespeed>0)
				if (sound.fadecount < sound.lvol) {
					if ((sound.fadecount += 2) > sound.lvol)
						sound.fadecount = sound.lvol;
				} else sound.fadespeed=0;
			else
			if (sound.fadespeed<0)
				if (sound.fadecount > 0) {
					if (sound.fadecount < 2)
						sound.fadecount = 0;
					else
						sound.fadecount -= 2;
				} else { 	//sound.fadespeed=0;
					delsound(i--);
					continue;
				  }
			lv = rv = sound.fadecount;
		} else {
			lv = sound.lvol;
			rv = sound.rvol;
		  }
		if (GETFLAG(sound.flags,SFL_3D) && cx>=0) {
			if (GETFLAG(sound.flags,SFL_FOLLOW)) {
				Object *obj;
				if ((obj = objectslist.get(sound.ownerid)) != NULL) {
					x = sound.x + obj->mover->x;
					y = sound.y + obj->mover->y;
				} //else continue;
			} else {
				x = sound.x;
				y = sound.y;
			  }
			// lk = y = dist
			lk = lshr16(fixmul(x-cx,viewcos) + fixmul(y-cy,viewsin))>>4;
			// rk = x = displ
			rk = lshr16(fixmul(y-cy,viewcos) - fixmul(x-cx,viewsin))>>4;
			vdl = intdist(lk,rk+1);  // distanza aumenta se rk>0
			vdr = intdist(lk,rk-1);  // distanza aumenta se rk<0
			if (rk>1) vdl+=rk-1;
			if (rk<-1) vdr-=rk+1;
			if (lk<0) {vdl+=4;vdr+=4;}
			lv -= vdl;
			rv -= vdr;
			/*
			lv -= intdist(lk,rk-1);
			rv -= intdist(lk,rk+1);
			if (lk<0) {lv-=2;rv-=2;}
			*/

			if (GETFLAG(sound.flags,SFL_RAY)) {
				obstacles = lookray(x,y,cx,cy,OMM_SOUNDABLE)<<2;
				lv-=obstacles;
				rv-=obstacles;
				/*
				char far *ptr = (char _seg *)0xAD20 + (char near *)0;
				for (i=0;i<30;i++)
				 if (i<obstacles) *(ptr++)=0; else *(ptr++)=112;
				*/
			}

			if (lv<0) lv=0;
			if (rv<0) rv=0;
			if (!lv && !rv) {
				if (GETFLAG(sound.flags,SFL_CONTINUE)) {
					sound.curpos += DMAbuffer_size>>1;
					if (sound.curpos >= sound.size)
						sound.curpos -= sound.size;
				} else delsound(i--);
				continue;
			}
			if (sb_type >= SBT_SBPRO) {
				while (ABS(lk)>8 || ABS(rk)>8) {lk>>=1;rk>>=1;}
				if (rk>=0) desync =  synctab[8-lk][ rk];
					  else desync = -synctab[8-lk][-rk];

			} else desync = 0;
		} else {
			if (sb_type>=SBT_SBPRO) desync = sound.desync;
							   else desync = 0;
		  }
		//size = sound.size;
		if (!(data = (char *)mm_recall(sound.memidx))) {
			delsound(i--);
			continue;
		}
		if (sm_lrinverted) {
			asm {
				MOV AX, lv
				XCHG rv, AX
				MOV lv, AX
			}
			desync = -desync;
		}
		if (!desync)
		  if (sb_type>=SBT_SBPRO)
			play = sm_mixstereosound(sound,data,
						lv*sm_soundvol>>SM_VOLSHIFT,rv*sm_soundvol>>SM_VOLSHIFT);
		  else
			play = sm_mixmonosound(sound,data,lv*sm_soundvol>>SM_VOLSHIFT);
		else
			play = sm_mix3Dsound(sound,data,
						lv*sm_soundvol>>SM_VOLSHIFT,rv*sm_soundvol>>SM_VOLSHIFT,desync);
		if (!play) delsound(i--);
	}
	if (bufferhigh) {
		adjstorebuffer(DMAbufhalf);
		bufferhigh--;
	} else {
		adjstorebuffer(DMAbuffer);
		bufferhigh++;
	  }
	bufferready++;
	if (!playing) {
		if (sb_type < SBT_SB16 || snd_dma_off) {
			sb_enableDMA();
			snd_dma_off=0;
		} else sb_continueDMA();
		playing++;
	}
}

void loadsound(int sndnum, const char *wavname) {
	TSoundData &snd = sounddata[sndnum];
	int handle;
	unsigned long i;
	char far *ptr;

	if (snd.memidx) error("loadsound","multiple assign");

#ifndef __DATAFILE__
	if (!sm_soundok) return;
	if ((handle = _open(wavname,O_RDONLY|O_BINARY)) != -1) {
		lseek(handle,0x10,SEEK_SET);	// cut cut
		do {
			_read(handle,&i,4);
			lseek(handle,i,SEEK_CUR);
			_read(handle,&i,4);
		} while (i != FIRMdata);
		_read(handle,&i,4);
		snd.size = (unsigned)i-2;
		ptr = (char far *)mm_recall(snd.memidx = mm_alloc(snd.size));
		_read(handle,ptr,snd.size);
		_close(handle);
		adjsample(ptr,snd.size);
	} else error("loadsound",err_filenotfound);
#else
	//if (sb_soundok) {
	snd.memidx = mm_alloc(0);	// automatic size detection
	snd.size = mm_getblocksize(snd.memidx);
	/*
	} else {
		mm_alloc(2,snd.memidx);
		snd.size = 2;
	  }
	*/
#endif
	mm_unload(snd.memidx);	// il suono  inutile...
}

// !!!
int near getownsound(int owner, char all) {
	int i;
	if (owner!=SYSOWN)
		for(i=0;i<sm_soundnum;i++)
			if (soundlist[i].ownerid == owner &&
				(all || GETFLAG(soundlist[i].flags,SFL_OVERSOUND))) return i;
	return -1;
}

int play3Dsound(fixed x, fixed y, int sndnum, byte vol,
				int owner, byte flags) {
	if (sm_soundok && sndnum<MAXSNDDATA) {
		int indx = getownsound(owner,0);
		if (sm_soundnum<MAXSOUNDS || indx>=0) {
			TSoundData &snd = sounddata[sndnum];
			if (mm_recall(snd.memidx) == NULL) return -1;
			if (indx<0 || !GETFLAG(flags,SFL_OVERSOUND))
				indx = sm_soundnum;
			TSound &sound = soundlist[indx];
			sound.id = idcnt;
			idcnt = (idcnt+1) & 0x7fff;
			// bisognerebbe controllare se gi c' quest'ID !!!
			sound.ownerid = owner;
			sound.memidx = snd.memidx;
			//if ((sound.data = (char far *)mm_recall(snd.memidx)) == NULL)
			//	return -1;
			//mm_lock(snd.memidx); //!!!!!
			sound.size = snd.size;
			sound.curpos = 0;
			sound.x = x;
			sound.y = y;
			sound.flags = flags;
			sound.desync = 0;
			if (vol) {
				sound.rvol = sound.lvol = vol;
			} else {
				sound.rvol = sound.lvol = SM_MAXVOL;
			  }
			if (GETFLAG(flags,SFL_FADE)) {
				sound.fadespeed = 1;
				sound.fadecount = 0;
			}
			if (indx==sm_soundnum) sm_soundnum++;
			return sound.id;


			/*
			if (indx>=0 && GETFLAG(flags,SFL_OVERSOUND)) {
				TSound &sound = soundlist[indx];
				sound.memidx = snd.memidx;
				//mm_lock(snd.memidx); //!!!!!
				sound.size = snd.size;
				sound.curpos = 0;
				sound.x = x;
				sound.y = y;
				sound.flags = flags;
				sound.desync = 0;
				if (vol) {
					sound.rvol = sound.lvol = vol; //(int)vol*SM_MAXVOL>>5;

					// sound.lvol = lv;
					// sound.rvol = rv;

				} else {
					sound.rvol = sound.lvol = SM_MAXVOL;
				  }

				if (GETFLAG(flags,SFL_FADE)) {
					sound.fadespeed = 1;
					sound.fadecount = 0;
				}

				return sound.id;
			} else {
				TSound &sound = soundlist[sm_soundnum];
				sound.id = idcnt;
				sound.ownerid = owner;
				sound.memidx = snd.memidx;
			//sound.data = (char far *)mm_recall(snd.memidx);
			//if ((sound.data = (char far *)mm_recall(snd.memidx)) == NULL)
			//	return -1;
				if (mm_recall(snd.memidx) == NULL) return -1;
				//mm_lock(snd.memidx); //!!!!!
				sound.size = snd.size;
				sound.curpos = 0;
				sound.x = x;
				sound.y = y;
				sound.flags = flags;
				sound.desync = 0;
				if (vol) {
					sound.rvol = sound.lvol = vol; //(int)vol*SM_MAXVOL>>5;
					//sound.rvol = (int)rv*SM_MAXVOL>>5; !!!
				} else {
					sound.rvol = sound.lvol = SM_MAXVOL;
				  }
				idcnt = (idcnt+1) & 0x7fff;
			// bisognerebbe controllare se gi c' quest'ID !!!
				sm_soundnum++;

				if (GETFLAG(flags,SFL_FADE)) {
					sound.fadespeed = 1;
					sound.fadecount = 0;
				}

				return sound.id;
			}
			*/
		}
	}
	return -1;
}

int playsound(int sndnum, byte lvol, byte rvol, char desync, int owner, byte flags) {
	if (sm_soundok && sndnum<MAXSNDDATA) {
		int indx = getownsound(owner,0);
		if (sm_soundnum<MAXSOUNDS || indx>=0) {
			TSoundData &snd = sounddata[sndnum];
			if (mm_recall(snd.memidx) == NULL) return -1;
			//if (indx>=0 && GETFLAG(flags,SFL_OVERSOUND)) {
			if (indx<0 || !GETFLAG(flags,SFL_OVERSOUND))
				indx = sm_soundnum;
			TSound &sound = soundlist[indx];
			sound.id = idcnt;
			idcnt = (idcnt+1) & 0x7fff;
			// bisognerebbe controllare se gi c' quest'ID !!!
			sound.ownerid = owner;
			sound.memidx = snd.memidx;
			//if ((sound.data = (char far *)mm_recall(snd.memidx)) == NULL)
			//	return -1;
			//mm_lock(snd.memidx); //!!!!!
			sound.size = snd.size;
			sound.curpos = 0;
			sound.flags = flags;
			sound.desync = desync;
			if (lvol) {
				sound.lvol = lvol;
				sound.rvol = rvol;
			} else {
				sound.rvol = sound.lvol = SM_MAXVOL;
			  }
			if (GETFLAG(flags,SFL_FADE)) {
				sound.fadespeed = 1;
				sound.fadecount = 0;
			}
			if (indx==sm_soundnum) sm_soundnum++;
			return sound.id;
		}
	}
	return -1;
}

void ownerdead(int owner) {
	int indx;

	if (!sm_soundok) return;
	while ((indx = getownsound(owner,1)) >= 0) {
		TSound &sound = soundlist[indx];
		if (GETFLAG(sound.flags,SFL_AUTOSTOP)) {
			// stop sound now !
			delsound(indx);
		} else
		if (GETFLAG(sound.flags,SFL_CONTINUE)) {
			// sound will stop...
			CLRFLAG(sound.flags,SFL_CONTINUE);
			//sound.flags & ~SFL_CONTINUE;
		}
	}
}

char stopsound(int id) {
	if (!sm_soundok) return 0;
	for (int i=0; i<sm_soundnum; i++)
		if (soundlist[i].id==id) {
			if (GETFLAG(soundlist[i].flags,SFL_FADE)) {
				soundlist[i].fadespeed = -1;
				return 2;
			}
			delsound(i);
			return 1;
		}
	//error("Debug: no sound to stop"); // !!!
	return 0;
}

void stopallsounds() {
	int i, k, end = sm_soundnum;
	for (i=k=0;i<end;i++)
		if (stopsound(soundlist[k].id) == 2) k++;
	// si poteva fare meglio... ma non sarebbe stato evidente (e sicuro)
}

void findblasterenv(int &dmalo, int &dmahi, int &irq) {
	char *value = getenv("BLASTER");
	char letter;
	int number;
	if (value!=NULL) {
		while ((letter=*(value++)) != 0) {
			if (*value==':') value++;
			number = *(value++)-'0';
			switch(letter) {
				case 'D': dmalo=number; break;
				case 'H': dmahi=number; break;	//inutile
				case 'I':
					if (*value>='0' && *value<='9')
						irq = number*10 + (*(value++)-'0');
					break;
				default: value--;	// mmm, non  molto efficiente...
									// ...ma  corto.
			}
		}
		if (dmalo!=1 && dmalo!=0 && dmalo!=3) dmalo=1;
		if (dmahi!=5 && dmahi!=6 && dmahi!=7) dmahi=dmalo;
		if (irq!=5 && irq!=7 && irq!=2 && irq!=10) irq=5;
	}
}

void initsounds() {
	int _dmalo=1,_dmahi=1,_irq=5;
	sm_soundok = 0;
	fdfill(sounddata,0l,sizeof(TSoundData)*MAXSNDDATA);
	findblasterenv(_dmalo,_dmahi,_irq);
	if (sb_init(_dmalo,_dmahi,_irq)) { 	// !!!
		if ((appbuf = new int[DMAbuffer_size]) == NULL) {
			donesounds();
			return;
		}
		if (sb_type == SBT_SBPRO) sm_lrinverted=1;
		sm_soundok = 1;
	} //else sb_ioaddr = 0; automatico
	//error("initsounds - No sound card detected");
}

void donesounds() {
	if (sm_soundok) {
		sb_stopDMA();
		sb_done();
		sb_ioaddr = 0;
	}
}

#pragma exit donesounds 120