/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// Nicosoft's 3DEngine for KAOS - (C)1996 Valentini Domenico

// MAXSHADE: deve essere potenza di 2 !
#define	MAXSHADE	16

#define HISHMASK	(0xFF-MAXSHADE+1)
#define LOSHMASK    (MAXSHADE-1)

// #include "3dengine.hpp"

int linex,		// colonna video
	liney,     // riga video
	lineh,		// MURI = altezza muro; PAVIMENTO/SOFFITTO = riga corrente
	column;	// MURI = colonna texture (muri); P/S = colonna corrente
unsigned long wstep, woffs;
void far *texture;	// TEXTURE da disegnare
#ifdef __DOUBLEWALLS__
void far *htexture;	// higher TEXTURE da disegnare
#endif
void far *vpage = (void far *)(new char[64000]);//VMEMPTR; //(void far *)(new char[64000]);
word *coldist = new word[MAXVIEWWIDTH];

fixed curx, cury, curincx, curincy;
char shade;
int maxcolumn;
int viewtop, viewbottom, viewleft, viewright;
int mskx, msky;

void far *hid;
unsigned fcdest;
fixed txt_indx, indincx;

fixed backx, backy1, backy2;
/*
void drawwall(char shader) {
	unsigned lostep;
asm {
	PUSH DS
	LES DI, vpage
	ADD DI, linex
	MOV AX, liney
	XCHG AL, AH
	ADD DI, AX
	SHR AX, 2
	ADD DI, AX

	CLD
	MOV CX, lineh
	MOV AX, WORD PTR wstep
	MOV lostep, AX
	MOV BX, WORD PTR wstep[2]
	MOV DX, WORD PTR woffs
	MOV AX, column
	SHL AX, 6
	ADD AX, WORD PTR woffs[2]
	LDS SI, texture
	ADD SI, AX
} c1: asm {
	MOV AL, [SI]

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
	ADD DI, 320
	ADD DX, lostep
	ADC SI, BX
	LOOP c1
	POP DS
} }
*/
/*
void drawwall2(char shader) {
	unsigned lostep, histep;
	int cnt;
asm {
	LES DI, vpage
	ADD DI, linex
	MOV AX, liney
	XCHG AL, AH
	ADD DI, AX
	SHR AX, 2
	ADD DI, AX

	//CLD
	MOV AX, lineh
	MOV cnt, AX
	MOV AX, WORD PTR wstep
	MOV lostep, AX
	MOV CX, WORD PTR wstep[2]
	//MOV histep, AX
	MOV DX, WORD PTR woffs
	MOV BX, WORD PTR woffs[2]
	MOV AX, column
	SHL AX, 6
	LDS SI, texture
	ADD SI, AX
} c1: asm {
	MOV AL, [SI+BX]

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
	ADD DI, 320
	ADD DX, lostep
	ADC BX, CX
	AND BX, 0x003f
	DEC cnt
	JNZ c1
	// ASSUME SS==DS
	MOV AX, SS
	MOV DS, AX
} }
*/
/*
void near drawwallHP(char shader) {
	unsigned lostep, histep, stdinc;
asm {
	MOV AX, WORD PTR vpage[2]
	MOV ES, AX
	MOV AX, linex
	MOV BX, liney
	XCHG BL, BH
	ADD AX, BX
	SHR BX, 2
	ADD AX, BX
	ADD AX, WORD PTR vpage
	MOV DI, AX

	CLD
	MOV CX, lineh
	MOV AX, WORD PTR wstep
	MOV lostep, AX
	MOV AX, WORD PTR wstep[2]
	MOV BX, AX
	AND AX, 0x000F
	MOV histep, AX
	AND BX, 0xFFF0
	MOV stdinc, BX
	MOV BX, WORD PTR woffs[2]
	MOV DX, BX
	SHR DX, 4
	MOV AX, column
	SHL AX, 6
	ADD AX, DX
	MOV DX, WORD PTR woffs
	LDS SI, texture
	ADD SI, AX
} c1: asm {
	MOV AL, [SI]

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
	ADD DI, 320
	AND BX, 0x000F
	OR BX, stdinc
	ADD DX, lostep
	ADC BX, histep
	MOV AX, BX
	SHR AX, 4
	ADD SI, AX
	LOOP c1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
} }
*/
#ifndef __DOUBLEWALLS__
void near drawwallHP(char shader) {
	unsigned lostep, histep; //, stdinc
	int cnt;
asm {
	MOV AX, WORD PTR vpage[2]
	MOV ES, AX
	MOV AX, linex
	MOV BX, liney
	XCHG BL, BH
	ADD AX, BX
	SHR BX, 2
	ADD AX, BX
	ADD AX, WORD PTR vpage
	MOV DI, AX

	// CLD     non ci sono LODS
	MOV AX, lineh
	MOV cnt, AX
	MOV AX, WORD PTR wstep
	MOV lostep, AX
	MOV AX, WORD PTR wstep[2]
	MOV histep, AX
	MOV CX, WORD PTR woffs[2]
	AND CX, 0x03ff
	MOV BX, CX
	SHR BX, 4
	MOV AX, column
	SHL AX, 6
	MOV DX, WORD PTR woffs
	LDS SI, texture
	ADD SI, AX

} c1: asm {
	MOV AL, [SI+BX]

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AH, AL
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
	ADD DI, 320
	ADD DX, lostep
	ADC CX, histep
	AND CX, 0x03ff
	MOV BX, CX
	SHR BX, 4
	DEC cnt
	JNZ c1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
} }
#else

void near drawwallHP(char shader) {
	unsigned lostep, histep;
	int cnt;
asm {
	MOV AX, WORD PTR vpage[2]
	MOV ES, AX
	MOV AX, linex
	MOV BX, liney
	XCHG BL, BH
	ADD AX, BX
	SHR BX, 2
	ADD AX, BX
	ADD AX, WORD PTR vpage
	MOV DI, AX

	// CLD  no LODS
	MOV CX, lineh
	MOV cnt, CX
	MOV AX, WORD PTR wstep
	MOV lostep, AX
	MOV AX, WORD PTR wstep[2]
	MOV BX, AX
	MOV histep, AX
	MOV CX, WORD PTR woffs[2]
	AND CX, 0x03ff
	MOV BX, CX
	SHR BX, 4
	MOV AX, column
	SHL AX, 6
	MOV DX, WORD PTR woffs
	LDS SI, texture
	ADD SI, AX
} c1: asm {
	MOV AL, [SI+BX]

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
	ADD DI, 320
	ADD DX, lostep
	ADC CX, histep
	AND CX, 0x03ff
	MOV AX, CX
	SHR AX, 4
	MOV BX, AX
	DEC cnt
	JNZ c1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
} }

void near drawwallHP2(char shader) {
	unsigned lostep, histep;
	int cnt;
	void far *nexttext = texture;
	int disp;
asm {
   MOV AX, WORD PTR texture
   SUB AX, WORD PTR htexture
   MOV disp, AX

	MOV AX, WORD PTR vpage[2]
	MOV ES, AX
	MOV AX, linex
	MOV BX, liney
	XCHG BL, BH
	ADD AX, BX
	SHR BX, 2
	ADD AX, BX
	ADD AX, WORD PTR vpage
	MOV DI, AX

	// CLD  no LODS
	MOV CX, lineh
	MOV cnt, CX
	MOV AX, WORD PTR wstep
	MOV lostep, AX
	MOV AX, WORD PTR wstep[2]
	MOV BX, AX
	MOV histep, AX
	MOV CX, WORD PTR woffs[2]
	MOV SI, CX
	AND CX, 0x03ff
	MOV BX, CX
	SHR BX, 4
	MOV AX, column
	SHL AX, 6
	MOV DX, WORD PTR woffs
   TEST SI, 0xfc00
   JNZ lowwall
   LDS SI, htexture
   ADD SI, AX
   ADD disp, AX
   JMP c1
} lowwall: asm {
	LDS SI, texture
	ADD SI, AX
	//XOR AX, AX
	MOV disp, AX
} c1: asm {
	MOV AL, [SI+BX]

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
	ADD DI, 320
	ADD DX, lostep
	ADC CX, histep
   TEST CX, 0xfc00
   JZ pass
   LDS SI, nexttext
   ADD SI, disp
} pass: asm {
	AND CX, 0x03ff
	MOV AX, CX
	SHR AX, 4
	MOV BX, AX
	DEC cnt
	JNZ c1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
} }

#endif

void near vline(byte col) {
asm { 	// No zero check
	MOV CX, lineh
	MOV DX, linex
	MOV AX, liney
	XCHG AH, AL
	LDS SI, vpage
	ADD SI, DX
	ADD SI, AX
	SHR AX, 2
	ADD SI, AX

	MOV AL, col
	MOV DX, 320
	// CLD  no LODS
} c1: asm {
	MOV [SI], AL
	ADD SI, DX
	LOOP c1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void near init_fc() {
asm {
	MOV AX, linex
	MOV BX, liney
	XCHG BH, BL
	ADD AX, BX
	SHR BX, 2
	ADD AX, BX
	ADD AX, WORD PTR vpage
	MOV fcdest, AX

	DB 0x66; MOV AX, WORD PTR curincx
	DB 0x66; SHL AX, 6 // !!!!!!! SHL non cambia ?!
	DB 0x66; MOV WORD PTR indincx, AX

	DB 0x66; MOV AX, WORD PTR curx
	DB 0x66; AND AX, 0xffff; DW 0x003f
	DB 0x66; SHL AX, 6
	DB 0x66; MOV WORD PTR txt_indx, AX

	MOV AX, WORD PTR curx[2]
	AND AX, 0xffc0
	MOV mskx, AX
	MOV AX, WORD PTR cury[2]
	AND AX, 0xffc0
	MOV msky, AX
} }

int near fast_drawfc() {
asm {
	MOV DI, fcdest
	DB 0x66; MOV DX, WORD PTR indincx

	MOV CX, column
	LES SI, hid
	MOV AX, CX
	SHL AX, 1
	ADD SI, AX
	// CLD  no LODS
} cic1: asm {
	MOV AX, WORD PTR ES:[SI]
	CMP lineh, AX
	JGE nodraw

	MOV AX, WORD PTR txt_indx[2]
	AND AX, 0x0fc0
	MOV BX, WORD PTR cury[2]
	AND BX, 0x003f
	ADD AX, BX
	//PUSH DS
	MOV BX, SI
	LDS SI, texture
	ADD SI, AX
	MOV AL, [SI]
	MOV SI, BX
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS

	// Shader (C)Nicosoft
	MOV AH, AL
	ADD AL, shade
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV BX, ES
	MOV ES, WORD PTR vpage[2]
	MOV ES:[DI], AL
	MOV ES, BX
} nodraw: asm {
	INC CX
	INC DI
	//ADD SI, 2
	INC SI
	INC SI

	DB 0x66; ADD WORD PTR txt_indx, DX
	DB 0x66; MOV AX, WORD PTR curincx
	DB 0x66; ADD WORD PTR curx, AX
	DB 0x66; MOV AX, WORD PTR curincy
	DB 0x66; ADD WORD PTR cury, AX

	MOV AX, WORD PTR curx[2]	// best time
	AND AX, 0xffc0
	MOV BX, WORD PTR cury[2]
	AND BX, 0xffc0
	CMP AX, mskx
	JNE end1
	CMP BX, msky
	JNE end1

	CMP CX, maxcolumn
	JGE end2
	JMP cic1
	//JL cic1				// !!!

} end1: asm {
	MOV mskx, AX
	MOV msky, BX
	MOV fcdest, DI
	SHR BX, 6
	ADD AX, BX
} end2: asm {
	MOV column, CX
} }

int near fast_drawtfc(byte col) {
asm {
	MOV DI, fcdest
	DB 0x66; MOV DX, WORD PTR indincx

	MOV CX, column
	LES SI, hid
	MOV AX, CX
	SHL AX, 1
	ADD SI, AX
	// CLD  no LODS
} cic1: asm {
	MOV AX, WORD PTR ES:[SI]
	CMP lineh, AX
	JGE nodraw

	MOV AX, WORD PTR txt_indx[2]
	AND AX, 0x0fc0
	MOV BX, WORD PTR cury[2]
	AND BX, 0x003f
	ADD AX, BX
	//PUSH DS
	MOV BX, SI
	LDS SI, texture
	ADD SI, AX
	MOV AL, [SI]
	MOV SI, BX
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
	OR AL, AL
	JNZ shdal
	OR AL, col
	JZ nodraw
	JMP store

} shdal: asm {
	// Shader (C)Nicosoft
	MOV AH, AL
	ADD AL, shade
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV BX, ES
	MOV ES, WORD PTR vpage[2]
	MOV ES:[DI], AL
	MOV ES, BX
} nodraw: asm {
	INC CX
	INC DI
	INC SI
	INC SI

	DB 0x66; ADD WORD PTR txt_indx, DX
	DB 0x66; MOV AX, WORD PTR curincx
	DB 0x66; ADD WORD PTR curx, AX
	DB 0x66; MOV AX, WORD PTR curincy
	DB 0x66; ADD WORD PTR cury, AX

	MOV AX, WORD PTR curx[2]	// best time
	AND AX, 0xffc0
	MOV BX, WORD PTR cury[2]
	AND BX, 0xffc0
	CMP AX, mskx
	JNE end1
	CMP BX, msky
	JNE end1

	CMP CX, maxcolumn
	JGE end2
	JMP cic1
	//JL cic1				// !!!

} end1: asm {
	MOV mskx, AX
	MOV msky, BX
	MOV fcdest, DI
	SHR BX, 6
	ADD AX, BX
} end2: asm {
	MOV column, CX
} }

int near fast_drawfcblack(byte black) {
asm {
	MOV DI, fcdest
	DB 0x66; MOV DX, WORD PTR indincx

	MOV CX, column
	LES SI, hid
	MOV AX, CX
	SHL AX, 1
	ADD SI, AX
	// CLD  no LODS
} cic1: asm {
	MOV BX, WORD PTR ES:[SI]
	CMP lineh, BX
	JL draw
} pass: asm {
	INC CX
	INC DI
	INC SI
	INC SI

	DB 0x66; ADD WORD PTR txt_indx, DX
	DB 0x66; MOV BX, WORD PTR curincx
	DB 0x66; ADD WORD PTR curx, BX
	DB 0x66; MOV BX, WORD PTR curincy
	DB 0x66; ADD WORD PTR cury, BX

	MOV AX, WORD PTR curx[2]	// best time
	AND AX, 0xffc0
	MOV BX, WORD PTR cury[2]
	AND BX, 0xffc0
	CMP AX, mskx
	JNE end1
	CMP BX, msky
	JNE end1

	CMP CX, maxcolumn
	JL cic1				// !!!
	JMP end2
	//JGE end2 	// !!!!?
	//JMP cic1
} draw: asm {
	MOV BX, ES
	MOV ES, WORD PTR vpage[2]
	//XOR AL, AL
	MOV AL, black //127	// Nero shadable
	MOV ES:[DI], AL
	MOV ES, BX
	JMP pass
} end1: asm {
	MOV mskx, AX
	MOV msky, BX
	MOV fcdest, DI
	SHR BX, 6
	ADD AX, BX
} end2: asm {
	MOV column, CX
} }

int near fast_passfc() {
asm {
	DB 0x66; MOV DX, WORD PTR indincx
	DB 0x66; MOV BX, WORD PTR curincx
	DB 0x66; MOV SI, WORD PTR curincy

	MOV CX, column
	// CLD  no LODS
} cic1: asm {
	INC CX
	INC fcdest

	DB 0x66; ADD WORD PTR txt_indx, DX
	DB 0x66; ADD WORD PTR curx, BX
	DB 0x66; ADD WORD PTR cury, SI

	CMP CX, maxcolumn
	JGE end2

	MOV AX, WORD PTR curx[2]	// best time
	AND AX, 0xffc0
	MOV DI, WORD PTR cury[2]
	AND DI, 0xffc0
	CMP AX, mskx
	JNE end1
	CMP DI, msky
	JE cic1
} end1: asm {
	MOV mskx, AX
	MOV msky, DI
	SHR DI, 6
	ADD AX, DI
	TEST AX, 0xf000
	JNZ cic1
} end2: asm {
	MOV column, CX
} }

void near drawcobjHP(int x, int y, word dex, word dey,
					 int vdx, int vdy, word dist, char shader,
					 void far *rfig) {
	word savedi, cnt, totresx;
	fixed adjy, adjx, adjo;
	word *coldistptr = coldist;
	int rdy = vdy;

	//if (!rfig) return;

asm {
	XOR AX, AX
	MOV WORD PTR adjy, AX
	MOV WORD PTR adjx, AX
	MOV AX, dey
	MOV WORD PTR adjy[2], AX
	MOV AX, dex
	MOV WORD PTR adjx[2], AX
}
	adjy = fixdiv(adjy,vdy);
	adjx = fixdiv(adjx,vdx);
/*
	adjo = (lshl16(dex)-(adjx*vdx))>>1; // x
asm {
	MOV AX, WORD PTR adjo
	MOV totresx, AX
}
*/
	//adjy = fixdiv(lshl16(dey),vdy);
	//adjx = fixdiv(lshl16(dex),vdx);
	if (y < viewtop) {
		adjo = adjy * (viewtop-y); 	// !!!
		rdy -= viewtop-y;
		y = viewtop;
	} else adjo = 0l;
	if (y+rdy > viewbottom) rdy = viewbottom-y;
	if (rdy<=0) return;		// !!! serve ?
asm {
	//PUSH DS
	MOV totresx, 0

	MOV AX, WORD PTR adjx[2]
	OR AX, AX
	JZ nomul
	MOV BX, dey
	MUL BX
	MOV WORD PTR adjx[2], AX
} nomul: asm {
	LES DI, vpage
	MOV AX, y
	XCHG AH, AL
	ADD DI, AX
	SHR AX, 2
	ADD DI, AX
	MOV BX, x
	ADD DI, BX

	SUB BX, viewleft
	SAL BX, 1
	MOV cnt, BX

	// CLD  no LODS
	MOV CX, vdx
	JCXZ end			// !!! serve ?
	MOV savedi, DI
} ini: asm {
	PUSH CX

	MOV BX, x
	CMP BX, viewleft
	// JL clipx
	JGE gomax
	JMP clipx
} gomax: asm {
	CMP BX, viewright
	// JG hardend
	JL gomask		// only LESS
	JMP hardend
} gomask: asm {
	MOV BX, cnt
	LES DI, coldistptr
	MOV AX, WORD PTR ES:[DI+BX]
	CMP AX, dist
	JL clipx

	MOV AX, WORD PTR vpage[2]
	MOV ES, AX

	MOV DI, savedi

	//PUSH DS
	LDS SI, rfig

	MOV CX, rdy
	ADD SI, WORD PTR adjo[2]
	MOV DX, WORD PTR adjo
	MOV BX, WORD PTR adjy[2]
} draw: asm {
	MOV AL, [SI]
	OR AL, AL
	JZ noplot

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
} noplot: asm {
	ADD DI, 320
	ADD DX, WORD PTR adjy
	ADC SI, BX
	LOOP draw

	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS

} clipx: asm {
	MOV AX, WORD PTR adjx[2]
	ADD WORD PTR rfig, AX
	MOV AX, WORD PTR adjx
	ADD totresx, AX
	JNC nocar
	MOV AX, dey
	ADD WORD PTR rfig, AX
} nocar: asm {
	ADD WORD PTR cnt, 2
	INC x
	INC savedi
	POP CX
	DEC CX
	JZ end
	JMP ini
} hardend: asm {
	POP CX
} end: asm {
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
} }

void near drawrcobjHP(int x, int y, word dex, word dey,
					  int vdx, int vdy, word dist, char shader,
					  void far *rfig) {
	word savedi, cnt, totresx;
	fixed adjy, adjx, adjo;
	word *coldistptr = coldist;
	int rdy = vdy;

	//if (!rfig) return;

asm {
	XOR AX, AX
	MOV WORD PTR adjy, AX
	MOV WORD PTR adjx, AX
	MOV AX, dey
	MOV WORD PTR adjy[2], AX
	MOV AX, dex
	MOV WORD PTR adjx[2], AX
}
	adjy = fixdiv(adjy,vdy);
	adjx = fixdiv(adjx,vdx);
	//adjy /= vdy;
	//adjx /= vdx;
	//adjy = fixdiv(lshl16(dey),vdy);
	//adjx = fixdiv(lshl16(dex),vdx);
	if (y < viewtop) {
		adjo = adjy * (viewtop-y); 	// !!!
		rdy -= viewtop-y;
		y = viewtop;
	} else adjo = 0l;
	if (y+rdy > viewbottom) rdy = viewbottom-y;
	if (rdy<=0) return;		// !!! serve ?
asm {
	//PUSH DS
	MOV totresx, 0

	MOV AX, WORD PTR adjx[2]
	OR AX, AX
	JZ nomul
	MOV BX, dey
	MUL BX
	MOV WORD PTR adjx[2], AX
} nomul: asm {
	LES DI, vpage
	MOV AX, y
	XCHG AH, AL
	ADD DI, AX
	SHR AX, 2
	ADD DI, AX
	MOV BX, x
	ADD BX, vdx
	DEC BX
	MOV x, BX
	ADD DI, BX
	SUB BX, viewleft
	SAL BX, 1
	MOV cnt, BX

	// CLD  no LODS
	MOV CX, vdx
	JCXZ end			// !!! serve ?
	MOV savedi, DI
} ini: asm {
	PUSH CX

	MOV BX, x
	CMP BX, viewright
	JL gomax
	JMP clipx
} gomax: asm {
	CMP BX, viewleft
	JGE gomask		// only LESS
	JMP hardend
} gomask: asm {
	MOV BX, cnt
	LES DI, coldistptr
	MOV AX, WORD PTR ES:[DI+BX]
	CMP AX, dist
	JL clipx

	MOV AX, WORD PTR vpage[2]
	MOV ES, AX

	MOV DI, savedi

	//PUSH DS
	LDS SI, rfig

	MOV CX, rdy
	ADD SI, WORD PTR adjo[2]
	MOV DX, WORD PTR adjo
	MOV BX, WORD PTR adjy[2]
} draw: asm {
	MOV AL, [SI]
	OR AL, AL
	JZ noplot

	// Shader
	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH
	OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
} noplot: asm {
	ADD DI, 320
	ADD DX, WORD PTR adjy
	ADC SI, BX
	LOOP draw

	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS

} clipx: asm {
	MOV AX, WORD PTR adjx[2]
	ADD WORD PTR rfig, AX
	MOV AX, WORD PTR adjx
	ADD totresx, AX
	JNC nocar
	MOV AX, dey
	ADD WORD PTR rfig, AX
} nocar: asm {
	SUB WORD PTR cnt, 2
	DEC x
	DEC savedi
	POP CX
	DEC CX
	JZ end
	JMP ini
} hardend: asm {
	POP CX
} end: asm {
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
} }

void drawbackground(int startcol, int y) {
	if (y<=viewtop-halfheight || y>=viewbottom) return;
fixed startx = backx*startcol, starty, lhx, lhy;
int cnt, vieww = viewwidth-startcol,
	toty, savedi, height;
	if (y<viewtop) {
		height = halfheight-(toty = viewtop-y);
		starty = backy1*toty;
		y = viewtop;
	} else {
		starty = 0l;
		if (y>viewtop+halfheight) height = viewbottom-y;
							 else height = halfheight;
	  }
asm {
	LES DI, vpage
	MOV AX, y
	XCHG AH, AL
	ADD DI, AX
	SHR AX, 2
	ADD DI, AX
	ADD DI, viewleft
	MOV savedi, DI
	DB 0x66; MOV AX, WORD PTR backx
	DB 0x66; MOV WORD PTR lhx, AX
	DB 0x66; MOV AX, WORD PTR backy2
	DB 0x66; MOV WORD PTR lhy, AX
	MOV AX, height
	MOV cnt, AX
	LDS SI, texture
	MOV AX, WORD PTR starty[2]
	XCHG AH, AL	// Parte alta * 320
	ADD SI, AX
	SHR AX, 2
	ADD SI, AX
	MOV AX, WORD PTR starty // Parte bassa no
	MOV toty, AX
	CLD
} cic1: asm {
	MOV BX, WORD PTR startx[2]
	MOV DX, WORD PTR startx
	MOV DI, savedi
	MOV CX, vieww
} cic21: asm { // Draw from startcol to viewright
	MOV AL, [SI+BX]
	STOSB
	ADD DX, WORD PTR lhx
	ADC BX, WORD PTR lhx[2]
	LOOP cic21

	XOR BX, BX
	MOV CX, startcol
	JCXZ hop
} cic22: asm { // Draw from viewleft to startcol
	MOV AL, [SI+BX]
	STOSB
	ADD DX, WORD PTR lhx
	ADC BX, WORD PTR lhx[2]
	LOOP cic22

} hop: asm {
	MOV AX, WORD PTR lhy[2]
	MOV BX, WORD PTR lhy
	ADD toty, BX
	JNC okcarry
	ADD AX, 320
} okcarry: asm {
	ADD SI, AX
	ADD savedi, 320
	DEC cnt
	JNZ cic1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void near drawclightHP(int x, int y, word dex, word dey,
					   int vdx, int vdy, word dist, char shader,
					   void far *rfig) {
	word savedi, cnt, totresx;
	fixed adjy, adjx, adjo;
	word *coldistptr = coldist;
	int rdy = vdy;

	//if (!rfig) return;

asm {
	XOR AX, AX
	MOV WORD PTR adjy, AX
	MOV WORD PTR adjx, AX
	MOV AX, dey
	MOV WORD PTR adjy[2], AX
	MOV AX, dex
	MOV WORD PTR adjx[2], AX
}
	adjy = fixdiv(adjy,vdy);
	adjx = fixdiv(adjx,vdx);
	if (y < viewtop) {
		adjo = adjy * (viewtop-y); 	// !!!
		rdy -= viewtop-y;
		y = viewtop;
	} else adjo = 0l;
	if (y+rdy > viewbottom) rdy = viewbottom-y;
	if (rdy<=0) return;		// !!! serve ?
asm {
	//PUSH DS
	MOV totresx, 0

	MOV AX, WORD PTR adjx[2]
	OR AX, AX
	JZ nomul
	MOV BX, dey
	MUL BX
	MOV WORD PTR adjx[2], AX
} nomul: asm {
	LES DI, vpage
	MOV AX, y
	XCHG AH, AL
	ADD DI, AX
	SHR AX, 2
	ADD DI, AX
	MOV BX, x
	ADD DI, BX

	SUB BX, viewleft
	SAL BX, 1
	MOV cnt, BX

	// CLD  no LODS
	MOV CX, vdx
	JCXZ end			// !!! serve ?
	MOV savedi, DI
} ini: asm {
	PUSH CX

	MOV BX, x
	CMP BX, viewleft
	// JL clipx
	JGE gomax
	JMP clipx
} gomax: asm {
	CMP BX, viewright
	// JG hardend
	JL gomask		// only LESS
	JMP hardend
} gomask: asm {
	MOV BX, cnt
	LES DI, coldistptr
	MOV AX, WORD PTR ES:[DI+BX]
	CMP AX, dist
	JL clipx

	MOV AX, WORD PTR vpage[2]
	MOV ES, AX

	MOV DI, savedi

	//PUSH DS
	LDS SI, rfig

	MOV CX, rdy
	ADD SI, WORD PTR adjo[2]
	MOV DX, WORD PTR adjo
	MOV BX, WORD PTR adjy[2]
} draw: asm {
	MOV AL, ES:[DI]

	// Lighter
	MOV AH, [SI]
	OR AH, AH
	JZ noplot
	CMP shader, AH
	JGE noplot
	MOV AH, AL
	ADD AL, shader
	SUB AL, [SI]
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AL, AH		// clipping
	AND AL, HISHMASK
	//OR AL, LOSHMASK

} store: asm {
	MOV ES:[DI], AL
} noplot: asm {
	ADD DI, 320
	ADD DX, WORD PTR adjy
	ADC SI, BX
	LOOP draw

	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS

} clipx: asm {
	MOV AX, WORD PTR adjx[2]
	ADD WORD PTR rfig, AX
	MOV AX, WORD PTR adjx
	ADD totresx, AX
	JNC nocar
	MOV AX, dey
	ADD WORD PTR rfig, AX
} nocar: asm {
	ADD WORD PTR cnt, 2
	INC x
	INC savedi
	POP CX
	DEC CX
	JZ end
	JMP ini
} hardend: asm {
	POP CX
} end: asm {
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
} }
