/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// 3D-ngine V2.3 - (C)1997  Nicosot (Valentini Domenico)

// ATTENZIONE A MAXVIEWHEIGHT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#define __DOUBLEWALLS__

//#define HVIEWRANGE	(ANG60-(ANGLVL<<3))
#define HVIEWRANGE	ANG90
// int HVIEWRANGE = ANG60;
#define VVIEWRANGE	ANG60

#define VIEWGLOBAL		(64l<<FIXSHIFT)
#define MINDIST			(8l<<FIXSHIFT)
// #define	FOCALLENGHT		(3632005l-MINDIST)		// (55.42*65536.0)
// #define	FOCALLENGHT		((32l<<16)-MINDIST)		// (64*65536.0)
#define	VIEWWIDTH		256
#define	VIEWHEIGHT		144
#define MAXVIEWWIDTH	320
#define MAXVIEWHEIGHT	200		// !!!!!

#ifdef __DOUBLEWALLS__
#define	WALLSHEIGHT		(128l<<FIXSHIFT)
#else
#define	WALLSHEIGHT		(128l<<FIXSHIFT)
#endif

#define ITORAD		(3.141592657/ANG180)
#define RADTOI		ANG180/3.141592657

#define MAXRAIN		64

#define COL_WALL	79
#define	COL_ROCK1	127
#define COL_WOOD	47
#define	COL_MUFFA	111
#define	COL_ROCK2	191

#include "std.hpp"
#include "fastmem.hpp"
#include "fixed.h"
#include "mm4.hpp"
#include "lgraph.hpp"
#include "3dengine.hpp"
#include "kaos.hpp"
#include "events.hpp"	// per objects & doors
#include "doors.hpp"
#include "objects.hpp"
#include "3drflat.cpp"
#include <math.h>

#include <stdlib.h> // per random() in RAIN
//#include <dos.h>	// per sound()

fixed *sintab = new fixed[ANG360],
	  *costab = new fixed[ANG360],
	  *tantab = new fixed[ANG90+1],
	  *invcostab = new fixed[ANG90+1];
int *angtab = new int[MAXVIEWWIDTH];
int viewwidth, viewheight, halfwidth, halfheight;
fixed heightnumerator;
int viewangle, rayangle;
fixed viewx, viewy, viewz;
fixed viewcos, viewsin;

int *ceilhid = new int[MAXVIEWWIDTH],
	*floorhid = new int[MAXVIEWWIDTH];
int minceilrow, minfloorrow;
fixed facedist, objscale;
fixed distadj;	// per pav/soff.

// uso xdist e ydist per leftcos e leftsin, per risparmiare

// ray
fixed xpos, ypos, xposinc, yposinc;
fixed xinters, yinters, xintinc, yintinc;
fixed dist, xdist, ydist, xdistinc, ydistinc;
int idx;
char isxray,isdiag,isnowall;
word raymask;	// affects ehnray()
int noid,		// Don't draw this object (DRAWER)
	textind, otextind;	// memory indexes

word *map;
word *objmap;
char seenmap[4096];
char mapsquare[25];	// quadrato mappa
byte *floormap = new byte[4096];
byte *ceilmap = new byte[4096];
DrawList dobjlist;
// Agenti atmosferici
char raindraw = 1; //, rainspeed = 8;
//struct { int x,y; } rain_info[MAXRAIN];
typedef struct { fixed x,y; } TRainInfo;
TRainInfo rain_info[MAXRAIN];
fixed rain_speed[MAXRAIN];
int thunderdraw = -1, thunderang, thunderz, underblack = 0;

#ifdef __DOUBLEWALLS__
byte HighWall[MAXTEXTURES] = {
T_WALL1/*T_WALL1*/		,T_WALL1M/*T_WALL1M*/,
T_WALL1/*T_WALL1S*/		,T_WALL1M/*T_WALL1MS*/,
T_WALL1/*T_WALL1SS*/	,T_WALL1M/*T_WALL1MSS*/,
T_WALL1/*T_TAP*/		,T_WALL1M/*T_TAPM*/,
T_WALL1/*T_TAPS*/		,T_WALL1M/*T_TAPMS*/,
T_WALL1/*T_TAPSS*/		,T_WALL1M/*T_TAPMSS*/,
T_WALL1/*T_SCUDO*/		,T_WALL1M/*T_SCUDOM*/,
T_WALL1/*T_SCUDOS*/		,T_WALL1M/*T_SCUDOMS*/,
T_WALL1/*T_SCUDOSS*/	,T_WALL1M/*T_SCUDOMSS*/,
T_ARC/*T_ARC*/			,T_ARCM/*T_ARCM*/,
T_PIETR1/*T_PIETR1*/	,T_PIETR1M/*T_PIETR1M*/,
T_PIETR1/*T_PIETR1S*/	,T_PIETR1M/*T_PIETR1MS*/,
T_PIETR1/*T_PIETR1SS*/	,T_PIETR1M/*T_PIETR1MSS*/,
T_PIETR1/*T_ASCE*/		,T_PIETR1M/*T_ASCEM*/,
T_PIETR1/*T_ASCES*/		,T_PIETR1M/*T_ASCEMS*/,
T_PIETR1/*T_ASCESS*/	,T_PIETR1M/*T_ASCEMSS*/,
T_ROCK/*T_ROCK*/		,T_ROCK/*T_ROCKS*/,
T_ROCK/*T_ROCKSS*/		,
T_WOOD1/*T_WOOD1*/		,T_WOOD1/*T_WOOD1S*/,
T_WOOD1/*T_WOOD1SS*/	,
T_WBOX/*T_WBOX*/		,T_WBOX/*T_WBOXS*/,
T_WBOX/*T_WBOXSS*/		,
T_OVERDOOR/*T_DOOR1*/	,T_OVERDOOR/*T_DOOR1S*/,
T_OVERDOOR/*T_DOOR2*/	,T_OVERDOOR/*T_DOOR2S*/,
T_OVERDOOR/*T_DOORY*/	,T_OVERDOOR/*T_DOORYS*/,
T_OVERDOOR/*T_DOORR*/	,T_OVERDOOR/*T_DOORRS*/,
T_WOOD2/*T_WOOD2*/		,T_WOOD2/*T_WOOD2S*/,
T_WOOD2/*T_WOOD2SS*/	,
T_SBARRE/*T_SBARRE*/	,T_SBARRE/*T_SBARRES*/,
T_WOOD1/*T_SWITCHU*/	,

T_WALL1,T_WALL1M,T_PIETR1,T_PIETR1M,T_ROCK,T_WOOD1,T_WBOX,T_WOOD2,
T_WALL2/*T_WALL2*/		,T_WALL2M/*T_WALL2M*/,
T_WALL2/*T_WALL2Z*/		,T_WALL2M/*T_WALL2MZ*/,
T_PIETR2/*T_PIETR2*/	,T_PIETR2M/*T_PIETR2M*/,
T_PIETR2/*T_PIETR2Z*/	,T_PIETR2M/*T_PIETR2MZ*/,
T_EARTH/*T_EARTH*/		,T_EARTH/*T_EARTHZ*/,
T_SOFT/*T_SOFT*/		,T_SOFTM/*T_SOFTM*/,
T_SOFT/*T_SOFTZ*/		,T_SOFTM/*T_SOFTMZ*/,

T_DRAGON  ,T_DRAGON+1,T_DRAGON+2,T_DRAGON+3,T_DRAGON+4,
T_DRAGON+5,T_DRAGON+6,T_DRAGON+7,T_DRAGON+8,

T_GRATAW/*T_GRATAW*/	,T_GRATAW/*T_GRATAWZ*/,
T_GRATAB/*T_GRATAB*/	,T_GRATAB/*T_GRATABZ*/,
T_FLROCK/*T_FLROCK*/	,T_FLROCK/*T_FLROCKZ*/,
//T_GRIGLIA
T_OVERDOOR,T_DOORSLOT,T_WOOD1/*T_SWITCHD*/
	};
#endif

// colore di lontananza
byte LastCol[MAXTEXTURES] = {
COL_WALL/*T_WALL1*/		,COL_MUFFA/*T_WALL1M*/,
COL_WALL/*T_WALL1S*/	,COL_MUFFA/*T_WALL1MS*/,
COL_WALL/*T_WALL1SS*/	,COL_MUFFA/*T_WALL1MSS*/,
COL_WALL/*T_TAP*/		,COL_MUFFA/*T_TAPM*/,
COL_WALL/*T_TAPS*/		,COL_MUFFA/*T_TAPMS*/,
COL_WALL/*T_TAPSS*/		,COL_MUFFA/*T_TAPMSS*/,
COL_WALL/*T_SCUDO*/		,COL_MUFFA/*T_SCUDOM*/,
COL_WALL/*T_SCUDOS*/	,COL_MUFFA/*T_SCUDOMS*/,
COL_WALL/*T_SCUDOSS*/	,COL_MUFFA/*T_SCUDOMSS*/,
COL_WALL/*T_ARC*/		,COL_MUFFA/*T_ARCM*/,
COL_ROCK1/*T_PIETR1*/	,COL_MUFFA/*T_PIETR1M*/,
COL_ROCK1/*T_PIETR1S*/	,COL_MUFFA/*T_PIETR1MS*/,
COL_ROCK1/*T_PIETR1SS*/	,COL_MUFFA/*T_PIETR1MSS*/,
COL_ROCK1/*T_ASCE*/		,COL_MUFFA/*T_ASCEM*/,
COL_ROCK1/*T_ASCES*/	,COL_MUFFA/*T_ASCEMS*/,
COL_ROCK1/*T_ASCESS*/	,COL_MUFFA/*T_ASCEMSS*/,
COL_ROCK1/*T_ROCK*/		,COL_ROCK1/*T_ROCKS*/,
COL_ROCK1/*T_ROCKSS*/	,
COL_WOOD/*T_WOOD1*/		,COL_WOOD/*T_WOOD1S*/,
COL_WOOD/*T_WOOD1SS*/	,
COL_WOOD/*T_WBOX*/		,COL_WOOD/*T_WBOXS*/,
COL_WOOD/*T_WBOXSS*/	,
COL_WOOD/*T_DOOR1*/		,COL_WOOD/*T_DOOR1S*/,
COL_WOOD/*T_DOOR2*/		,COL_WOOD/*T_DOOR2S*/,
COL_WOOD/*T_DOORY*/		,COL_WOOD/*T_DOORYS*/,
COL_WOOD/*T_DOORR*/		,COL_WOOD/*T_DOORRS*/,
COL_WOOD/*T_WOOD2*/		,COL_WOOD/*T_WOOD2S*/,
COL_WOOD/*T_WOOD2SS*/	,
COL_ROCK1/*T_SBARRE*/	,COL_ROCK1/*T_SBARRES*/,
COL_WOOD/*T_SWITCHU*/	,

COL_WALL,COL_MUFFA,COL_ROCK1,COL_MUFFA,COL_ROCK1,COL_WOOD,COL_WOOD,COL_WOOD,
COL_WALL/*T_WALL2*/		,COL_MUFFA/*T_WALL2M*/,
COL_WALL/*T_WALL2Z*/	,COL_MUFFA/*T_WALL2MZ*/,
COL_ROCK2/*T_PIETR2*/	,COL_MUFFA/*T_PIETR2M*/,
COL_ROCK2/*T_PIETR2Z*/	,COL_MUFFA/*T_PIETR2MZ*/,
COL_WALL/*T_EARTH*/		,COL_WALL/*T_EARTHZ*/,
COL_WALL/*T_SOFT*/		,COL_MUFFA/*T_SOFTM*/,
COL_WALL/*T_SOFTZ*/		,COL_WALL/*T_SOFTMZ*/,

COL_WALL,COL_WALL,COL_WALL,COL_WALL,COL_WALL,
COL_WALL,COL_WALL,COL_WALL,COL_WALL,

COL_WOOD/*T_GRATAW*/	,COL_WOOD/*T_GRATAWZ*/,
COL_ROCK2/*T_GRATAB*/	,COL_ROCK2/*T_GRATABZ*/,
COL_ROCK1/*T_FLROCK*/	,COL_ROCK1/*T_FLROCKZ*/,
//T_GRIGLIA
COL_WOOD,COL_WOOD,COL_WOOD/*T_SWITCHD*/
	};

//inline
#pragma warn -rvl
int angleadd(int a, int b) {
asm {
	MOV AX, a
	ADD AX, b
	CMP AX, ANG360
	JL end
	SUB AX, ANG360
} end:;
/*
	if ((a+=b) >= ANG360) return a-ANG360;
	return a;
*/
}

//inline
int anglesub(int a, int b) {
asm {
	MOV AX, a
	SUB AX, b
	JNS end
	ADD AX, ANG360
} end:;
/*
	if ((a-=b) < 0) return a+ANG360;
	return a;
*/
}
#pragma warn +rvl

void calctables() {
	int i;
	float angle;
	double dtan;
	fixed v;

	sintab[ANG0] = sintab[ANG180] = costab[ANG90] = costab[ANG270] = 0l;
	sintab[ANG90] = costab[ANG0] = (FIXONE/*-1l*/);
	sintab[ANG270] = costab[ANG180] = -(FIXONE/*-1l*/);
	tantab[ANG0] = 0l;
	invcostab[ANG0] = (FIXONE/*-1l*/);
	for (i=1;i<ANG90;i++) {
		angle = ITORAD*i;
		v = floor(sin(angle)*(FIXONE/*-1l*/)/*+0.5*/);
		costab[ANG270+i] = costab[ANG90-i] = sintab[i] = sintab[ANG180-i] = v;
		costab[ANG90+i] = costab[ANG270-i] = sintab[ANG360-i] = sintab[ANG180+i] = -v;
		v = floor((FIXONE/*-1l*/)/sin(angle)/*+0.5*/);
		if (v>(511l<<FIXSHIFT)) v = 511l<<FIXSHIFT; else
		 if (v<(-511l<<FIXSHIFT)) v = -511l<<FIXSHIFT;
		invcostab[ANG90-i] = v;
		v = floor(tan(angle)*FIXONE+0.5);
		if (v>(511l<<FIXSHIFT)) v = 511l<<FIXSHIFT;
		tantab[i] = v;
	}
	tantab[ANG90] = tantab[ANG90-1];
	invcostab[ANG90] = invcostab[ANG90-1];
}

void calcproject(long focal) {
	int i;
	float angfact;
	int angle;

	facedist = focal/*+MINDIST*/;
	objscale = viewwidth*facedist/VIEWGLOBAL;

	//heightnumerator = ((long)viewwidth*ANG60/(HVIEWRANGE-ANG30)*6/12);
	heightnumerator = ((long)viewwidth*ANG60/(HVIEWRANGE-ANG30) >> 1);
				// ((long)viewheight*ANG30/(HVIEWRANGE-ANG30));

	float tang;
	for (i=0;i<halfwidth;i++) {
		tang = ((float)i+0.5)*VIEWGLOBAL/viewwidth/facedist;
		angle = atan(tang)*RADTOI+0.5; // -+0.5; // ???
		angtab[halfwidth+i] = angle;
		// angtab[halfwidth-i/*-1*/] = anglesub(ANG0,angle);    // !!! -1
		angtab[halfwidth-i-1] = anglesub(ANG0,angle);
	}
	// Questa  solo una prova... per funziona meglio del -1 sopra
	//angtab[0]=anglesub(ANG0,atan(((float)halfwidth+0.5)*VIEWGLOBAL/viewwidth/facedist)*RADTOI-0.5);
	distadj = invcostab[ANG360-angtab[0]];	// per pavimenti/soffitti
}

void setviewsize(int width, int height) {
	viewwidth = width;
	viewheight = height &= 0x7ffe;
	halfwidth = width >> 1;
	halfheight = height >> 1;
	calcproject(fixdiv64(0,32,tantab[HVIEWRANGE>>1])/*-MINDIST*/); // !!!
	backx = fixdiv(320l<<16,width);
	backy1 = fixdiv(200l<<16,height); // == 100 / halfheight
	backy2 = backy1;
	asm {
		MOV AX, WORD PTR backy2[2]	// *320 (solo la parte alta) per backy2
		XCHG AH, AL
		MOV BX, AX
		SHR AX, 2
		ADD BX, AX
		MOV WORD PTR backy2[2], BX
	}
	// Reset rain
	int rainspeed = width/80;
	for (int i=0; i<MAXRAIN; i++) {
		rain_info[i].x = lshl16(random(width+4)-2);
		rain_info[i].y = lshl16(random(height+4)-2);
		rain_speed[i] = lshl16(rainspeed)+lshl8(random(256));
	}
}

void near initray() {
	fixed xp, yp;
	fixed raytan, rayinvtan;
	// Versione 2.3 - parte da davanti
	xpos = viewx & 0x7fc00000l;
	ypos = viewy & 0x7fc00000l;

	//if (rayangle==ANG45 || rayangle==(ANG90+ANG45) ||
	//	rayangle==(ANG180+ANG45) || rayangle==(ANG270+ANG45)) rayangle++;

	if (rayangle<ANG90) {
		yposinc = xposinc = (64l<<FIXSHIFT);
		xpos+=xposinc; ypos+=yposinc;
		yintinc = lshl6(raytan = tantab[rayangle]);
		xintinc = lshl6(rayinvtan = tantab[ANG90-rayangle]); // !!! -1 no
		xdistinc = invcostab[rayangle];
		ydistinc = invcostab[ANG90-rayangle];
	} else
	if (rayangle<ANG180) {
		xposinc = -(yposinc = (64l<<FIXSHIFT));
		xpos--; ypos+=yposinc;
		yintinc = -lshl6(raytan = -tantab[ANG180-rayangle]);
		xintinc = lshl6(rayinvtan = -tantab[rayangle-ANG90]);
		xdistinc = -invcostab[ANG180-rayangle];
		ydistinc = invcostab[rayangle-ANG90];
	} else
	if (rayangle<ANG270) {
		yposinc = xposinc = -(64l<<FIXSHIFT);
		xpos--; ypos--;
		yintinc = -lshl6(raytan = tantab[rayangle-ANG180]);
		xintinc = -lshl6(rayinvtan = tantab[ANG270-rayangle]); // !!! -1 no
		xdistinc = -invcostab[rayangle-ANG180];
		ydistinc = -invcostab[ANG270-rayangle];
	} else {
		yposinc = -(xposinc = (64l<<FIXSHIFT));
		ypos--; xpos+=xposinc;
		yintinc = lshl6(raytan = -tantab[ANG360-rayangle]);
		xintinc = -lshl6(rayinvtan = -tantab[rayangle-ANG270]);
		xdistinc = invcostab[ANG360-rayangle];
		ydistinc = -invcostab[rayangle-ANG270];
	  }
	yinters = viewy+fixmul(raytan,xp = xpos-viewx);
	xinters = viewx+fixmul(rayinvtan,yp = ypos-viewy);
	if (rayangle != ANG90 && rayangle != ANG270) {
		xdist = fixmul(xdistinc,xp);
		xdistinc = lshl6(LABS(xdistinc));
	} else xdist = 2000000000l;
	if (rayangle != ANG0 && rayangle != ANG180) {
		ydist = fixmul(ydistinc,yp);
		ydistinc = lshl6(LABS(ydistinc));
	} else ydist = 2000000000l;
}

/*
void near initray() {
	fixed xp, yp;
	fixed raytan, rayinvtan;
	// Versione 3.0 - parte da dietro
	xpos = viewx & 0x7fc00000l;
	ypos = viewy & 0x7fc00000l;
	if (rayangle<ANG90) {
		yposinc = xposinc = (64l<<FIXSHIFT);
		yintinc = lshl6(raytan = tantab[rayangle]);
		xintinc = lshl6(rayinvtan = tantab[ANG90-rayangle]); // !!! -1 no
		xdistinc = invcostab[rayangle];
		ydistinc = invcostab[ANG90-rayangle];
	} else
	if (rayangle<ANG180) {
		xposinc = -(yposinc = (64l<<FIXSHIFT));
		xpos-=xposinc+1;	// !!!
		yintinc = -lshl6(raytan = -tantab[ANG180-rayangle]);
		xintinc = lshl6(rayinvtan = -tantab[rayangle-ANG90]);
		xdistinc = -invcostab[ANG180-rayangle];
		ydistinc = invcostab[rayangle-ANG90];
	} else
	if (rayangle<ANG270) {
		yposinc = xposinc = -(64l<<FIXSHIFT);
		xpos-=xposinc+1; ypos-=yposinc+1;	// !!!
		yintinc = -lshl6(raytan = tantab[rayangle-ANG180]);
		xintinc = -lshl6(rayinvtan = tantab[ANG270-rayangle]); // !!! -1 no
		xdistinc = -invcostab[rayangle-ANG180];
		ydistinc = -invcostab[ANG270-rayangle];
	} else {
		yposinc = -(xposinc = (64l<<FIXSHIFT));
		ypos-=yposinc+1;
		yintinc = lshl6(raytan = -tantab[ANG360-rayangle]);
		xintinc = -lshl6(rayinvtan = -tantab[rayangle-ANG270]);
		xdistinc = invcostab[ANG360-rayangle];
		ydistinc = -invcostab[rayangle-ANG270];
	  }
	yinters = viewy+fixmul(raytan,xp = xpos-viewx);
	xinters = viewx+fixmul(rayinvtan,yp = ypos-viewy);
	if (rayangle != ANG90 && rayangle != ANG270) {
		xdist = fixmul(xdistinc,xp);
		xdistinc = lshl6(LABS(xdistinc));
	} else xdist = 2000000000l;
	if (rayangle != ANG0 && rayangle != ANG180) {
		ydist = fixmul(ydistinc,yp);
		ydistinc = lshl6(LABS(ydistinc));
	} else ydist = 2000000000l;
}
*/

#pragma warn -rvl
// MOSTRUOSAMENTE Veloce - (C)1997 Nicosot
// ritorna l' idx !
int near ray() {
asm {
	LES DI, objmap
	DB 0x66; MOV CX, WORD PTR xdist
	DB 0x66; MOV DX, WORD PTR ydist
} cic: asm {
	DB 0x66; CMP CX, DX
	JG rayy
// rayx
	MOV BX, WORD PTR xpos[2]
	TEST BX, 0xf000
	JNZ error1

	MOV AX, WORD PTR yinters[2]
	TEST AX, 0xf000
	JNZ error1

	AND BX, 0x0fc0
	SHR AX, 6
	ADD BX, AX

	MOV AL, seenmap[BX]
	AND AL, 1
	JNZ passx
	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	SHR BX, 1
	AND AX, OMM_VISIBLE
	JNZ stopx
	INC BYTE PTR seenmap[BX]
} passx: asm {
	DB 0x66; MOV AX, WORD PTR xposinc
	DB 0x66; ADD WORD PTR xpos, AX
	DB 0x66; MOV AX, WORD PTR yintinc
	DB 0x66; ADD WORD PTR yinters, AX
	DB 0x66; ADD CX, WORD PTR xdistinc
	JMP cic

} error1: asm {
	MOV AX, -1
	JMP fine

} stopx: asm {
	DB 0x66; MOV WORD PTR dist, CX
	// AL == 0 perch OMM_VISIBLE == 0x0F00
	MOV BYTE PTR isxray, 1
	JMP end
} rayy: asm {
	MOV BX, WORD PTR xinters[2]
	TEST BX, 0xf000
	JNZ error2

	MOV AX, WORD PTR ypos[2]
	TEST AX, 0xf000
	JNZ error2

	AND BX, 0x0fc0
	SHR AX, 6
	ADD BX, AX

	MOV AL, seenmap[BX]
	AND AL, 1
	JNZ passy
	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	SHR BX, 1
	AND AX, OMM_VISIBLE
	JNZ stopy
	INC BYTE PTR seenmap[BX]
} passy: asm {
	DB 0x66; MOV AX, WORD PTR yposinc
	DB 0x66; ADD WORD PTR ypos, AX
	DB 0x66; MOV AX, WORD PTR xintinc
	DB 0x66; ADD WORD PTR xinters, AX
	DB 0x66; ADD DX, WORD PTR ydistinc
	JMP cic

} error2: asm {
	MOV AX, -1
	JMP fine

} stopy: asm {
	DB 0x66; MOV WORD PTR dist, DX
	// AL == 0
	MOV isxray, AL
	//MOV BYTE PTR isxray, 0
} end: asm {
	DB 0x66; MOV WORD PTR xdist, CX		// !
	DB 0x66; MOV WORD PTR ydist, DX		// !
	MOV AX, BX
} fine: }
#pragma warn +rvl

/*
#pragma warn -rvl
// MOSTRUOSAMENTE Veloce - (C)1997 Nicosot
// ritorna l' idx !
int near ray() {
asm {
	LES DI, objmap
	DB 0x66; MOV CX, WORD PTR xdist
	DB 0x66; MOV DX, WORD PTR ydist
} cic: asm {
	DB 0x66; CMP CX, DX
	JG rayy
// } rayx: asm {
	MOV BX, WORD PTR xpos[2]
	TEST BX, 0xf000
	JNZ error1

	MOV AX, WORD PTR yinters[2]
	TEST AX, 0xf000
	JNZ error1

	AND BX, 0x0fc0
	SHR AX, 6
	ADD BX, AX

	MOV AL, seenmap[BX]
	AND AL, 1
	JNZ passx
	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	SHR BX, 1
	AND AX, OMM_VISIBLE
	JNZ stopx
	INC BYTE PTR seenmap[BX]
} passx: asm {
	DB 0x66; MOV AX, WORD PTR xposinc
	DB 0x66; ADD WORD PTR xpos, AX
	DB 0x66; MOV AX, WORD PTR yintinc
	DB 0x66; ADD WORD PTR yinters, AX
	DB 0x66; ADD CX, WORD PTR xdistinc
	JMP cic

} error1: asm {
	DB 0x66; OR CX, CX
	JLE passx
	MOV AX, -1
	JMP fine

} stopx: asm {
	DB 0x66; MOV WORD PTR dist, CX
	// AL == 0 perch OMM_VISIBLE == 0x0F00
	MOV BYTE PTR isxray, 1
	JMP end
} rayy: asm {
	MOV BX, WORD PTR xinters[2]
	TEST BX, 0xf000
	JNZ error2

	MOV AX, WORD PTR ypos[2]
	TEST AX, 0xf000
	JNZ error2

	AND BX, 0x0fc0
	SHR AX, 6
	ADD BX, AX

	MOV AL, seenmap[BX]
	AND AL, 1
	JNZ passy
	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	SHR BX, 1
	AND AX, OMM_VISIBLE
	JNZ stopy
	INC BYTE PTR seenmap[BX]
} passy: asm {
	DB 0x66; MOV AX, WORD PTR yposinc
	DB 0x66; ADD WORD PTR ypos, AX
	DB 0x66; MOV AX, WORD PTR xintinc
	DB 0x66; ADD WORD PTR xinters, AX
	DB 0x66; ADD DX, WORD PTR ydistinc
	JMP cic

} error2: asm {
	DB 0x66; OR DX, DX
	JLE passy
	MOV AX, -1
	JMP fine

} stopy: asm {
	DB 0x66; MOV WORD PTR dist, DX

	// AL == 0
	MOV isxray, AL
	//MOV BYTE PTR isxray, 0
} end: asm {
	DB 0x66; MOV WORD PTR xdist, CX		// !
	DB 0x66; MOV WORD PTR ydist, DX		// !
	MOV AX, BX
} fine: }
#pragma warn +rvl
*/

void near raynext() {
asm {
	DB 0x66; MOV CX, WORD PTR xdist
	DB 0x66; MOV DX, WORD PTR ydist
	DB 0x66; CMP CX, DX
	JG rayy
	DB 0x66; MOV AX, WORD PTR xposinc
	DB 0x66; ADD WORD PTR xpos, AX
	DB 0x66; MOV AX, WORD PTR yintinc
	DB 0x66; ADD WORD PTR yinters, AX
	DB 0x66; ADD CX, WORD PTR xdistinc
	DB 0x66; MOV WORD PTR xdist, CX
	JMP end
} rayy: asm {
	DB 0x66; MOV AX, WORD PTR yposinc
	DB 0x66; ADD WORD PTR ypos, AX
	DB 0x66; MOV AX, WORD PTR xintinc
	DB 0x66; ADD WORD PTR xinters, AX
	DB 0x66; ADD DX, WORD PTR ydistinc
	DB 0x66; MOV WORD PTR ydist, DX
} end: ; }

/*
void near raynext() {
asm {
	DB 0x66; MOV CX, WORD PTR xdist
	DB 0x66; MOV DX, WORD PTR ydist
	DB 0x66; CMP CX, DX
	JG rayy
	DB 0x66; MOV AX, WORD PTR xposinc
	DB 0x66; ADD WORD PTR xpos, AX
	DB 0x66; MOV AX, WORD PTR yintinc
	DB 0x66; ADD WORD PTR yinters, AX
	DB 0x66; ADD CX, WORD PTR xdistinc
	DB 0x66; MOV WORD PTR xdist, CX
	JMP end
} rayy: asm {
	DB 0x66; MOV AX, WORD PTR yposinc
	DB 0x66; ADD WORD PTR ypos, AX
	DB 0x66; MOV AX, WORD PTR xintinc
	DB 0x66; ADD WORD PTR xinters, AX
	DB 0x66; ADD DX, WORD PTR ydistinc
	DB 0x66; MOV WORD PTR ydist, DX
} end: ; }
*/

char near raycast() {
	TMapInfo mapinf;
	int li, ls, k;
	char ok,fast;
	fixed num,den;
	Object *obj;
	// Globals backup
	fixed _xinters, _yinters;
	//static int oidx = -1;
	char checknowall;//, vcount;

	ok = 0;
	isnowall = 0;
	checknowall = 1;
	for(;;) {
#ifdef __DEBUGMODE__
		if ((idx = ray())<0) return 0;
		//error("rayer error");
		if (idx<0 || idx>4095) error("!!???!!?!?!?!?");
#else
		if ((idx = ray())<0) return 0;
#endif
		mapinf = Map[idx];
		if (!seenmap[idx]) {
		  seenmap[idx] |= 2;
		  if ((k = IDMap[idx]) >= 0) {
			//vcount = mapinf.objmap[idx].visible;
			if (!mapinf.stop) seenmap[idx]++;
			// se un mostro passa in una porta, allora questa  aperta (?)
			do {
				obj = objectslist.get(k);
				if (k != noid && GETFLAG(obj->mover->flags,OMF_VISIBLE)) { // !!!!
					//vcount--;
					den = fixmul(obj->mover->x-viewx,viewcos)+
						  fixmul(obj->mover->y-viewy,viewsin);
					if (den>=MINDIST) {
						obj->seen();
						dobjlist.add(k,den);
					}
				}
			} while ((k = obj->mover->underq(idx)) >= 0);
		  }
		}

	   if (mapinf.stop/* && vcount>0*/) {
		// Shape analisys
		switch (mapinf.shape) {
			case MSH_SQUARE:
				if (isxray) {
					//if (xdist<0) break;	// !!!?!!!
					if (xposinc>=0l) column = lshr16(yinters) & 63;
								else column = ~lshr16(yinters) & 63;
				} else {
					//if (ydist<0) break;	// !!!?!!!
					if (yposinc>=0l) column = ~lshr16(xinters) & 63;
								else column = lshr16(xinters) & 63;
				  }
				ok++;
				isdiag=0;
				break;
			case MSH_VERT:
				//if (idx!=oidx) seenmap[idx] |= 0x2;
				if (isxray) {
					ls = (li = lshr16(yinters) & 0x7fc0) + 64;
					k = lshr16(_yinters = yinters + (yintinc>>1));
					if (k<li || k>=ls) break;
					dist = xdist + (xdistinc>>1);
					//if (dist<0) break;	// !!!?!!!
					if (xposinc>=0l) column = k & 63;
								else column = ~k & 63;
				} else {
					// invece gestisco l'X-ray !
					if (yposinc>0l) ls = (li = lshr16(ypos)) + 64;
							   else li = (ls = lshr16(ypos)+1) - 64;
					k = lshr16(_yinters = yinters-(yintinc>>1));
					if (k<li || k>=ls) break;
					dist = xdist - (xdistinc>>1);
					//if (dist<0) break;	// !!!?!!!
					if (xposinc>=0l) column = k & 63;
								else column = ~k & 63;
					isxray = 1;	// !!!
				  }
				ok++;
				isdiag=0;
				break;
			case MSH_HORIZ:
				//if (idx!=oidx) seenmap[idx] |= 0x2;
				if (isxray) {
					// invece gestisco l'Y-ray !
					if (xposinc>0l) ls = (li = lshr16(xpos)) + 64;
							   else li = (ls = lshr16(xpos)+1) - 64;
					k = lshr16(_xinters = xinters-(xintinc>>1));
					if (k<li || k>=ls) break;
					dist = ydist - (ydistinc>>1);
					//if (dist<0) break;	// !!!?!!!
					if (yposinc>=0l) column = ~k & 63;
								else column = k & 63;
					isxray = 0; // !!!
				} else {
					ls = (li = lshr16(xinters) & 0x7fc0) + 64;
					k = lshr16(_xinters = xinters + (xintinc>>1));
					if (k<li || k>=ls) break;
					dist = ydist + (ydistinc>>1);
					//if (dist<0) break;	// !!!?!!!
					if (yposinc>=0l) column = ~k & 63;
								else column = k & 63;
				  }
				ok++;
				isdiag=0;
				break;
			case MSH_DIAG1:
				//if (idx!=oidx) seenmap[idx] |= 0x2;
				if (isxray) {
					if (xposinc>0l) {
						if ((num = yinters & 0x003fffffl) != 0l) {
							den = xposinc-yintinc;
							if (den>=num) {
								fast = 1;
								ok++;
							}
						} else {
							fast = 0;
							ok++;
						  }
					} else {
						if ((num = ~yinters & 0x003fffffl) != 0l) {
							den = yintinc-xposinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast = 0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_yinters = yinters+fixmuldiv64(yintinc,num,den);
							dist = xdist+fixmuldiv64(xdistinc,num,den);
						} else {
							_yinters = yinters;
							dist = ydist;
						  }
						//if (dist<0) {ok--;break;}	// !!!?!!!
						if (xposinc>=0l) column = lshr16(_yinters) & 63;
									else column = ~lshr16(_yinters) & 63;
					}
				} else {
					if (yposinc>0l) {
						if ((num = xinters & 0x003fffffl) != 0l) {
							den = yposinc-xintinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					} else {
						if ((num = ~xinters & 0x003fffffl) != 0l) {
							den = xintinc-yposinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_xinters = xinters + fixmuldiv64(xintinc,num,den);
							dist = ydist + fixmuldiv64(ydistinc,num,den);
						} else {
							_xinters = xinters;
							dist = ydist;
						  }
						//if (dist<0) {ok--;break;}	// !!!?!!!
						if (yposinc>=0l) column = ~lshr16(_xinters) & 63;
									else column = lshr16(_xinters) & 63;
					}
				  }
				isdiag=1;
				break;
			case MSH_DIAG2:
				//if (idx!=oidx) seenmap[idx] |= 0x2;
				if (isxray) {
					if (xposinc>0l) {
						if ((num = ~yinters & 0x003fffffl) != 0l) {
							den = xposinc+yintinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					} else {
						if ((num = yinters & 0x003fffffl) != 0l) {
							den = -(yintinc+xposinc);
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_yinters = yinters + fixmuldiv64(yintinc,num,den);
							dist = xdist + fixmuldiv64(xdistinc,num,den);
						} else {
							_yinters = yinters;
							dist = xdist;
						  }
						//if (dist<0) {ok--;break;}	// !!!?!!!
						if (xposinc>=0l) column = lshr16(_yinters) & 63;
									else column = ~lshr16(_yinters) & 63;
					}
				} else {
					if (yposinc>0l) {
						if ((num = ~xinters & 0x003fffffl) != 0l) {
							den = yposinc+xintinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					} else {
						if ((num = xinters & 0x003fffffl) != 0l) {
							den = -(xintinc+yposinc);
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_xinters = xinters + fixmuldiv64(xintinc,num,den);
							dist = ydist + fixmuldiv64(ydistinc,num,den);
						} else {
							_xinters = xinters;
							dist = ydist;
						  }
						//if (dist<0) {ok--;break;}	// !!!?!!!
						if (yposinc>=0l) column = ~lshr16(_xinters) & 63;
									else column = lshr16(_xinters) & 63;
					}
				  }
				isdiag=2;
				break;
			case MSH_DOOR:
				//if (idx!=oidx) seenmap[idx] |= 0x2;
				if (isxray) {
					ls = (li = lshr16(yinters) & 0x7fc0) + 64;
					k = lshr16(_yinters = yinters + (yintinc>>1));
					if (k<li || k>=ls) break;
					dist = xdist + (xdistinc>>1);
					//if (dist<0) break;	// !!!?!!!
					column = k & 63;
					/*
					if (xposinc>=0) column = k & 63;
							   else column = ~k & 63;
					*/
				} else {
					ls = (li = lshr16(xinters) & 0x7fc0) + 64;
					k = lshr16(_xinters = xinters + (xintinc>>1));
					if (k<li || k>=ls) break;
					dist = ydist + (ydistinc>>1);
					//if (dist<0) break;	// !!!?!!!
					column = ~k & 63;
					/*
					if (yposinc>=0) column = ~k & 63;
							   else column = k & 63;
					*/
				  }
				ok++;
				isdiag=0;
				break;
		}
		if (ok) {
			switch (mapinf.type) {
				case MTP_WALL:
					/*
					if (mapinf.data == T_NULL) {
						isnowall = 1;
						break;
					}
					*/
					textind = mapinf.data;
					break;
				case MTP_SLOT:
					if (isxray)
						if (xposinc>0) k = idx-64;
									else k = idx+64;
					else
						if (yposinc>0) k = idx-1;
									else k = idx+1;
					if (Map[k].shape == MSH_DOOR) {
						textind = T_DOORSLOT;
						checknowall = 0;
					} else
						textind = mapinf.data;
					break;
				case MTP_DOOR1:
				case MTP_DOOR2:
					if ((k=doormanager.doorpos(mapinf.data))==64) {
						seenmap[idx]|=3;
						ok--;
						break;
					}
					if (mapinf.type == MTP_DOOR1) {
						ls=0;
						if (isdiag==1) {
							if (isxray) {if (xposinc<0l) ls=1;}
								   else {if (yposinc>0l) ls=1;}
						} else	// ???
						if (mapinf.shape != MSH_DOOR)
							if (isxray) {if (xposinc<0l) ls=1;}
								   else {if (yposinc<0l) ls=1;}
						if (ls) {
							if (column>63-k) {
								ok--;
								break;
							}
							column+=k;
						} else {
							if (column<k) {
								ok--;
								break;
							}
							column-=k;
						  }
					} else {
						k>>=1;
						if (column>=32) {
							if (column-32<k) {
								ok--;
								break;
							}
							column-=k;
						} else {
							if (31-column<k) {
								ok--;
								break;
							}
							column+=k;
						  }
					  }
					  textind = doormanager.doortype[mapinf.data];
					break;
				case MTP_GRID1:
					if (mapinf.shape != MSH_SQUARE) {
						if (isxray) k = lshr16(_yinters);
							   else k = lshr16(_xinters);
					} else
						if (isxray) k = lshr16(yinters);
							   else k = lshr16(xinters);
					/*
					if (isxray) {if (xposinc<0l) column = 63-column;}
						   else {if (yposinc<0l) column = 63-column;}
					*/
					if (k%12 >= 4) {
						ok--;
						break;
					}
					/*
					if (isxray) {if (xposinc<0l) column = 63-column;}
						   else {if (yposinc<0l) column = 63-column;}
					*/
					textind = mapinf.data;
					break;
			}
			//oidx = idx; !!!
		}
	   }
		if (ok) break; //else checknowall=1;
		raynext();
	}
	if (checknowall) {
		isnowall = (textind == T_NULL);
	}
	// oidx = idx;
	return 1;
}

#pragma warn -rvl
int lookray(fixed x1,fixed y1,fixed x2,fixed y2,word mask) {
int dex, dey, d1, d2, obstacles = 0;
char xdir = 1, ydir = 1;
int dx1,dx2,dy1,dy2;
asm {
	MOV AX, WORD PTR x1[2]
	AND AX, 0xffc0
	MOV BX, AX
	SHR AX, 6
	MOV CX, AX
	MOV AX, WORD PTR y1[2]
	SHR AX, 6
	ADD BX, AX	// BX = bidx
	MOV DX, AX
	MOV AX, WORD PTR x2[2]
	AND AX, 0xffc0
	MOV SI, AX
	SHR AX, 6
	SUB AX, CX
	JNS dxpos
	DEC xdir
	NEG AX
} dxpos: asm {
	MOV dex, AX
	MOV AX, WORD PTR y2[2]
	SHR AX, 6
	ADD SI, AX	// SI = eidx
	SUB AX, DX
	JNS dypos
	DEC ydir
	NEG AX
} dypos: asm {
	MOV dey, AX
	CMP BX, SI
	//JE end
	JNE nonul
	JMP end
} nonul: asm {
	CMP dex, AX
	JL yindip
	MOV CX, dex
	SHL AX, 1
	MOV d1, AX
	SUB AX, CX
	MOV DX, AX
	SUB AX, CX
	MOV d2, AX
	XOR AX, AX
	MOV dy1, AX
	INC AX
	INC AX
	MOV dy2, AX
	ADD AL, 126
	MOV dx1, AX
	MOV dx2, AX
	JMP goon
} yindip: asm {
	MOV CX, AX
	MOV AX, dex
	SHL AX, 1
	MOV d1, AX
	SUB AX, CX
	MOV DX, AX
	SUB AX, CX
	MOV d2, AX
	XOR AX, AX
	MOV dx1, AX
	INC AX
	INC AX
	MOV dy1, AX
	MOV dy2, AX
	ADD AL, 126
	MOV dx2, AX
} goon: asm {
	CMP xdir, 0
	JNE x1max2
	NEG dx1
	NEG dx2
} x1max2: asm {
	CMP ydir, 0
	JNE ploop
	NEG dy1
	NEG dy2
} ploop: asm {
	//PUSH DS
	LDS SI, objmap
	SHL BX, 1
	ADD SI, BX
	MOV BX, dx1
	ADD BX, dy1
	MOV DI, dx2
	ADD DI, dy2
	DEC CX			// toglie partenza (e arrivo) !
	JZ eloop		// !!!!!!!
	OR DX, DX
} mloop: asm {
	JNS mode2
	ADD SI, BX
	MOV AX, WORD PTR [SI]
	AND AX, mask
	JZ go1
	INC obstacles
} go1: asm {
	ADD DX, d1
	LOOP mloop
	JMP eloop
} mode2: asm {
	ADD SI, DI
	MOV AX, WORD PTR [SI]
	AND AX, mask
	JZ go2
	INC obstacles
} go2: asm {
	ADD DX, d2
	LOOP mloop
} eloop: asm {
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
} end: asm {
	MOV AX, obstacles
} }
#pragma warn +rvl

#pragma warn -rvl
// MOSTRUOSAMENTE Veloce++ - (C)1997 Nicosot
// ritorna l' idx !
int near enhray() {
asm {
	LES DI, objmap
	DB 0x66; MOV CX, WORD PTR xdist
	DB 0x66; MOV DX, WORD PTR ydist
} cic: asm {
	DB 0x66; CMP CX, DX
	JG rayy
	MOV BX, WORD PTR xpos[2]
	TEST BX, 0xf000
	JNZ error1

	MOV AX, WORD PTR yinters[2]
	TEST AX, 0xf000
	JNZ error1

	AND BX, 0x0fc0
	SHR AX, 6
	ADD BX, AX

	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	AND AX, raymask
	JNZ stopx
} passx: asm {
	DB 0x66; MOV AX, WORD PTR xposinc
	DB 0x66; ADD WORD PTR xpos, AX
	DB 0x66; MOV AX, WORD PTR yintinc
	DB 0x66; ADD WORD PTR yinters, AX
	DB 0x66; ADD CX, WORD PTR xdistinc
	JMP cic
} stopx: asm {
	// DB 0x66; MOV WORD PTR dist, CX
	MOV isxray, 1
	JMP end

} error1: asm {
	MOV AX, -1
	JMP fine

} rayy: asm {
	MOV BX, WORD PTR xinters[2]
	TEST BX, 0xf000
	JNZ error2

	MOV AX, WORD PTR ypos[2]
	TEST AX, 0xf000
	JNZ error2

	AND BX, 0x7fc0
	SHR AX, 6
	ADD BX, AX

	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	AND AX, raymask
	JNZ stopy
} passy: asm {
	DB 0x66; MOV AX, WORD PTR yposinc
	DB 0x66; ADD WORD PTR ypos, AX
	DB 0x66; MOV AX, WORD PTR xintinc
	DB 0x66; ADD WORD PTR xinters, AX
	DB 0x66; ADD DX, WORD PTR ydistinc
	JMP cic
} stopy: asm {
	// DB 0x66; MOV WORD PTR dist, DX
	MOV isxray, 0
	JMP end

} error2: asm {
	MOV AX, -1
	JMP fine

} end: asm {
	DB 0x66; MOV WORD PTR xdist, CX
	DB 0x66; MOV WORD PTR ydist, DX
	MOV AX, BX
	SHR AX, 1
} fine:;}
#pragma warn +rvl

/*
#pragma warn -rvl
// MOSTRUOSAMENTE Veloce++ - (C)1997 Nicosot
// ritorna l' idx !
int near enhray() {
asm {
	LES DI, objmap
	DB 0x66; MOV CX, WORD PTR xdist
	DB 0x66; MOV DX, WORD PTR ydist
} cic: asm {
	DB 0x66; CMP CX, DX
	JG rayy
	MOV BX, WORD PTR xpos[2]
	TEST BX, 0xf000
	JNZ error1

	MOV AX, WORD PTR yinters[2]
	TEST AX, 0xf000
	JNZ error1

	AND BX, 0x0fc0
	SHR AX, 6
	ADD BX, AX

	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	AND AX, raymask
	JNZ stopx
} passx: asm {
	DB 0x66; MOV AX, WORD PTR xposinc
	DB 0x66; ADD WORD PTR xpos, AX
	DB 0x66; MOV AX, WORD PTR yintinc
	DB 0x66; ADD WORD PTR yinters, AX
	DB 0x66; ADD CX, WORD PTR xdistinc
	JMP cic
} stopx: asm {
	// DB 0x66; MOV WORD PTR dist, CX
	MOV isxray, 1
	JMP end

} error1: asm {
	MOV AX, -1
	JMP fine

} rayy: asm {
	MOV BX, WORD PTR xinters[2]
	TEST BX, 0xf000
	JNZ error2

	MOV AX, WORD PTR ypos[2]
	TEST AX, 0xf000
	JNZ error2

	AND BX, 0x7fc0
	SHR AX, 6
	ADD BX, AX

	SHL BX, 1
	MOV AX, WORD PTR ES:[DI+BX]
	AND AX, raymask
	JNZ stopy
} passy: asm {
	DB 0x66; MOV AX, WORD PTR yposinc
	DB 0x66; ADD WORD PTR ypos, AX
	DB 0x66; MOV AX, WORD PTR xintinc
	DB 0x66; ADD WORD PTR xinters, AX
	DB 0x66; ADD DX, WORD PTR ydistinc
	JMP cic
} stopy: asm {
	// DB 0x66; MOV WORD PTR dist, DX
	MOV isxray, 0
	JMP end

} error2: asm {
	MOV AX, -1
	JMP fine

} end: asm {
	DB 0x66; MOV WORD PTR xdist, CX
	DB 0x66; MOV WORD PTR ydist, DX
	MOV AX, BX
	SHR AX, 1
} fine: }
#pragma warn +rvl
*/

int fireray(fixed &x, fixed &y, int angle, int vangle, // !!!
			 fixed &_dist, fixed &z, int _noid) {
	TMapInfo mapinf;
	int li, ls, k;
	char ok, buffered, fast;
	fixed num, den, alfa;
	Object *obj;
	// Globals backup
	fixed _xinters, _yinters,
			eorx,eory,eorz,maxdist;	// !!!
	int eor = -1;	// End Of Ray = FLOOR/CEILING

	// 3D
	if (!vangle) {
		maxdist=4096l<<FIXSHIFT;
		z = 32l<<FIXSHIFT;
	} else {
	  if (vangle<ANG90)
		maxdist=fixdiv64shl16(WALLSHEIGHT-z,tantab[vangle]);
	  else
		maxdist=fixdiv64shl16(z,tantab[ANG360-vangle]);
	  // floor/ceil end of ray
	  eorx = x+fixmul(maxdist,costab[angle]);
	  if (eorx>=0 && eorx<(4096l<<FIXSHIFT)) {
		eory = y+fixmul(maxdist,sintab[angle]);
		if (eory>=0 && eory<(4096l<<FIXSHIFT))
			k = xytoidx(eorx,eory);
		else k=-1;
	  } else k=-1;
	  if (k>=0) {
		if (vangle<ANG90) {	// on the ceiling
			eor = ceilmap[k]<T_TRANSP ? -1 : -2;
			eorz = WALLSHEIGHT;
		} else {	// on the floor
			eor = floormap[k]<T_TRANSP ? -1 : -2;
			eorz = 0;
		  }
	  } else eor = -2;
	  maxdist += FIXONE<<4;	// perch la distanza di raggio  maggiore !!!
	}

	// Sparo un p pi in qua perch altrimenti non colpisco le cose vicine !!!
	//  Questo  un puntiglio: se non ve ne frega niente, toglietelo ed
	//							eliminate tutti i "(FIXONE<<4)".
	viewx = x-(costab[angle]<<4); // !!! cos la distanza risulta maggiore !!!
	viewy = y-(sintab[angle]<<4);
	rayangle = angle;
	noid = _noid;
	raymask = OMM_HITABLE;

	initray();

	ok = 0;
	for(;;) {
		buffered = 0;
		if ((idx = enhray())<0) return -2;
		/*
		if (vangle)
		  if ((isxray && xdist>maxdist) ||
			(!isxray && ydist>maxdist)) {
			x = fixmul(maxdist,costab[angle]);
			y = fixmul(maxdist,sintab[angle]);
			_dist = maxdist;
			if (vangle>ANG270) {
				z=64l<<FIXSHIFT;
				if ((k = ceilmap[xytoidx(x,y)])==T_SLOT || k>=T_TRANS)
					return -3;
			} else {
				z=0l;
			  }
			return -2;
		  }
		*/
		mapinf = Map[idx];
		if ((k = IDMap[idx]) >= 0) {
			do {
				obj = objectslist.get(k);
				if (k != noid && (obj->mover->flags & OMF_HITABLE)) {
					if (isxray) {
						_xinters = obj->mover->x;
						alfa = LABS(fixdiv(_xinters-xpos,lshr16(xposinc)));
						_yinters = yinters + fixmul(yintinc,alfa);
					} else {
						_yinters = obj->mover->y;
						alfa = LABS(fixdiv(_yinters-ypos,lshr16(yposinc)));
						_xinters = xinters + fixmul(xintinc,alfa);
					  }
					den = FIXONE<<obj->mover->shdim;
					if (LABS(obj->mover->x-_xinters)+
						LABS(obj->mover->y-_yinters)<=den) {
						_dist = fixmul(obj->mover->x-viewx,costab[angle])+
								fixmul(obj->mover->y-viewy,sintab[angle])-
								den;
						if (_dist>maxdist) {
							x=eorx; y=eory; z=eorz; _dist=maxdist-(FIXONE<<4);
							return eor;
						}

						if (vangle<ANG90)
							num = z+fixmul(_dist,tantab[vangle]);
						else
							num = z-fixmul(_dist,tantab[ANG360-vangle]);
						/*
						TFigure &fig = FigList[obj->getviewfig(angle) & 0x3fff];
						den = lshl16(fig.dy+(fig.dy>>2));
						if (num-obj->mover->z-lshl16(fig.height) >=0 &&
							num-obj->mover->z-lshl16(fig.height) <= den) {
							x = _xinters;//-(costab[angle]<<(obj->mover->shdim-2));
						//obj->mover->x-costab[angle]<<obj->mover->shdim;
							y = _yinters;//-(sintab[angle]<<(obj->mover->shdim-2));
						//obj->mover->y-sintab[angle]<<obj->mover->shdim;
							//z = obj->mover->z;
							z = num;
							return k;
						}
						*/
						if (LABS(num-obj->mover->z) <= den) {
							x = _xinters;
							y = _yinters;
							z = num;
							return k;
						}
					}
				}
				k = obj->mover->underq(idx);
			} while (k>=0);
		}
		if (mapinf.stop) {

		/*
		// 3D-fire
		if (isxray) {
			if (xdist>maxdist) {
				x=eorx; y=eory; z=eorz; _dist=maxdist;
				return eor;
			}
		} else {
			if (ydist>maxdist) {
				x=eorx; y=eory; z=eorz; _dist=maxdist;
				return eor;
			}
		  }
		*/
		// Shape analisys
		switch (mapinf.shape) {
			case MSH_SQUARE:
				if (isxray) {
					if (xposinc>=0l) column = lshr16(yinters) & 63;
								else column = ~lshr16(yinters) & 63;
					_dist = xdist;
				} else {
					if (yposinc>=0l) column = ~lshr16(xinters) & 63;
								else column = lshr16(xinters) & 63;
					_dist = ydist;
				  }
				ok++;
				break;
			case MSH_VERT:
				if (isxray) {
					ls = (li = lshr16(yinters) & 0x7fc0) + 64;
					k = lshr16(_yinters = yinters + (yintinc>>1));
					if (k<li || k>ls) break;
					_xinters = xpos + (xposinc>>1);
					_dist = xdist + (xdistinc>>1);
					buffered++;
					if (xposinc>=0l) column = k & 63;
								else column = ~k & 63;
				} else {
					// invece gestisco l'X-ray !
					if (yposinc>0l) ls = (li = lshr16(ypos)) + 64;
							   else li = (ls = lshr16(ypos)+1) - 64; // !!!
					k = lshr16(_yinters = yinters-(yintinc>>1));
					if (k<li || k>ls) break;
					_xinters = xpos - (xposinc>>1);
					_dist = xdist - (xdistinc>>1);
					buffered++;
					isxray = 1;
					if (xposinc>=0l) column = k & 63;
								else column = ~k & 63;
				  }
				ok++;
				break;
			case MSH_HORIZ:
				if (isxray) {
					// invece gestisco l'Y-ray !
					if (xposinc>0l) ls = (li = lshr16(xpos)) + 64;
							   else li = (ls = lshr16(xpos)+1) - 64; // !!!
					k = lshr16(_xinters = xinters-(xintinc>>1));
					if (k<li || k>ls) break;
					_yinters = ypos - (yposinc>>1);
					_dist = ydist - (ydistinc>>1);
					buffered++;
					isxray = 0;
					if (yposinc>=0l) column = ~k & 63;
								else column = k & 63;
				} else {
					ls = (li = lshr16(xinters) & 0x7fc0) + 64;
					k = lshr16(_xinters = xinters + (xintinc>>1));
					if (k<li || k>ls) break;
					_yinters = ypos + (yposinc>>1);
					_dist = ydist + (ydistinc>>1);
					buffered++;
					if (yposinc>=0l) column = ~k & 63;
								else column = k & 63;
				  }
				ok++;
				break;
			case MSH_DIAG1:
				if (isxray) {
					if (xposinc>0l) {
						if ((num = yinters & 0x003fffffl) != 0l) {
							den = xposinc-yintinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					} else {
						if ((num = ~yinters & 0x003fffffl) != 0l) {
							den = yintinc-xposinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_xinters = xpos+fixmuldiv64(xposinc,num,den);
							_yinters = yinters + fixmuldiv64(yintinc,num,den);
							_dist = xdist + fixmuldiv64(xdistinc,num,den);
						} else {
							_xinters = xpos;
							_yinters = yinters;
							_dist = xdist;
						  }
						buffered++;
						if (xposinc>=0l) column = lshr16(_yinters) & 63;
									else column = ~lshr16(_yinters) & 63;
					}
				} else {
					if (yposinc>0l) {
						if ((num = xinters & 0x003fffffl) != 0l) {
							den = yposinc-xintinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					} else {
						if ((num = ~xinters & 0x003fffffl) != 0l) {
							den = xintinc-yposinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_yinters = ypos+fixmuldiv64(yposinc,num,den);
							_xinters = xinters+fixmuldiv64(xintinc,num,den);
							_dist = ydist+fixmuldiv64(ydistinc,num,den);
						} else {
							_yinters = ypos;
							_xinters = xinters;
							_dist = ydist;
						  }
						buffered++;
						if (yposinc>=0l) column = ~lshr16(_xinters) & 63;
									else column = lshr16(_xinters) & 63;
					}
				  }
				break;
			case MSH_DIAG2:
				if (isxray) {
					if (xposinc>0l) {
						if ((num = ~yinters & 0x003fffffl) != 0l) {
							den = xposinc+yintinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					} else {
						if ((num = yinters & 0x003fffffl) != 0l) {
							den = -(yintinc+xposinc);
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_xinters = xpos+fixmuldiv64(xposinc,num,den);
							_yinters = yinters + fixmuldiv64(yintinc,num,den);
							_dist = xdist + fixmuldiv64(xdistinc,num,den);
						} else {
							_xinters = xpos;
							_yinters = yinters;
							_dist = xdist;
						  }
						buffered++;
						if (xposinc>=0l) column = lshr16(_yinters) & 63;
									else column = ~lshr16(_yinters) & 63;
					}
				} else {
					if (yposinc>0l) {
						if ((num = ~xinters & 0x003fffffl) != 0l) {
							den = yposinc+xintinc;
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					} else {
						if ((num = xinters & 0x003fffffl) != 0l) {
							den = -(xintinc+yposinc);
							if (den>=num) {
								fast=1;
								ok++;
							}
						} else {
							fast=0;
							ok++;
						  }
					  }
					if (ok) {
						if (fast) {
							_yinters = ypos+fixmuldiv64(yposinc,num,den);
							_xinters = xinters + fixmuldiv64(xintinc,num,den);
							_dist = ydist + fixmuldiv64(ydistinc,num,den);
						} else {
							_yinters = ypos;
							_xinters = xinters;
							_dist = ydist;
						  }
						buffered++;
						if (yposinc>=0l) column = ~lshr16(_xinters) & 63;
									else column = lshr16(_xinters) & 63;
					}
				  }
				break;
			case MSH_DOOR:
				if (isxray) {
					ls = (li = lshr16(yinters) & 0x7fc0) + 64;
					k = lshr16(_yinters = yinters + (yintinc>>1));
					if (k<li || k>=ls) break;
					_xinters = xpos + (xposinc>>1);
					_dist = xdist + (xdistinc>>1);
					buffered++;
					if (xposinc>=0l) column = k & 63;
								else column = ~k & 63;
				} else {
					ls = (li = lshr16(xinters) & 0x7fc0) + 64;
					k = lshr16(_xinters = xinters + (xintinc>>1));
					if (k<li || k>=ls) break;
					_yinters = ypos + (yposinc>>1);
					_dist = ydist + (ydistinc>>1);
					buffered++;
					if (yposinc>=0l) column = ~k & 63;
								else column = k & 63;
				  }
				ok++;
				break;
		}
		if (ok) {
			switch (mapinf.type) {
				case MTP_WALL:
				case MTP_SLOT:	break;
				case MTP_DOOR1:
				case MTP_DOOR2:
					if ((k=doormanager.doorpos(mapinf.data))==64) {
						ok--;
						break;
					}
					if (mapinf.type == MTP_DOOR1) {
						ls=0;
						if (isdiag==1) {
							if (isxray) {if (xposinc<0l) ls++;}
								   else {if (yposinc>0l) ls++;}
						} else
						if (mapinf.shape != MSH_DOOR)
							if (isxray) {if (xposinc<0l) ls++;}
								   else {if (yposinc<0l) ls++;}
						if (ls) {
							if (column>63-k) {
								ok--;
								break;
							}
							column+=k;
						} else {
							if (column<k) {
								ok--;
								break;
							}
							column-=k;
						  }
					} else {
						k>>=1;
						if (column>=32) {
							if (column-32<k) {
								ok--;
								break;
							}
							column-=k;
						} else {
							if (31-column<k) {
								ok--;
								break;
							}
							column+=k;
						  }
					  }
					break;
				case MTP_GRID1:
					if (buffered)
						if (isxray) k = lshr16(_yinters);
							   else k = lshr16(_xinters);
					else
						if (isxray) k = lshr16(yinters);
							   else k = lshr16(xinters);
					if (isxray) {if (xposinc<0l) column = 63-column;}
						   else {if (yposinc<0l) column = 63-column;}
					if ((k % 12) >= 4) {
						ok--;
						break;
					}
					break;
			}
		}
		}

		if (ok) {
			if (_dist>maxdist) {
				x=eorx; y=eory; z=eorz; _dist=maxdist-(FIXONE<<4);
				return eor;
			}
			break;
		} else
		if (isxray) {
			if (xdist>maxdist) {
				x=eorx; y=eory; z=eorz; _dist=maxdist-(FIXONE<<4);
				return eor;
			}
		} else {
			if (ydist>maxdist) {
				x=eorx; y=eory; z=eorz; _dist=maxdist-(FIXONE<<4);
				return eor;
			}
		  }
		//if (ok) break;
		raynext();
	}
	if (buffered) {
		y = _yinters;
		x = _xinters;
	} else {
		if (isxray) {
			x = xpos;
			y = yinters;
		} else {
			x = xinters;
			y = ypos;
		  }
	  }
	//x -= costab[angle]<<2;//<<3; // WARNING !!!
	//y -= sintab[angle]<<2;//<<3;
	_dist-=FIXONE<<4;
	if (vangle) {
		if (vangle<ANG90)
			z = z+fixmul(_dist,tantab[vangle]);
		else
			z = z-fixmul(_dist,tantab[ANG360-vangle]);
	} else z = 32l<<FIXSHIFT;
	//if (mapinf.data==T_SLOT && mapinf.shape!=MSH_DOOR) return -2;
	return -1;
}

/*
void near calc_fcincrements() {
asm {
	DB 0x66; CWD
	DB 0x66; IDIV BX
	DB 0x66; MOV WORD PTR dist, AX
	DB 0x66; MOV CX, 0x8000; DW 0x0000
	DB 0x66; MOV BX, WORD PTR distadj
	DB 0x66; IMUL BX
	DB 0x66; ADD AX, CX
			 ADC DX, 0
	DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
	DB 0x66; MOV BX, AX //Non modifica dist !!!!

	DB 0x66; MOV AX, WORD PTR leftcos
	DB 0x66; IMUL BX
	DB 0x66; ADD AX, CX
			 ADC DX, 0
	DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
	DB 0x66; MOV CX, AX		// CX = desty
	DB 0x66; ADD AX, WORD PTR viewx
	DB 0x66; MOV WORD PTR curx, AX

	DB 0x66; MOV AX, WORD PTR leftsin
	DB 0x66; IMUL BX
	DB 0x66; ADD AX, 0x8000; DW 0x0000
			 ADC DX, 0
	DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
	DB 0x66; MOV BX, AX		// BX = destx
	DB 0x66; ADD AX, WORD PTR viewy
	DB 0x66; MOV WORD PTR cury, AX

	DB 0x66; NEG BX					// BX = -BX = -destx
	DB 0x66; ADD BX, WORD PTR viewx
		   //DB 0x66; MOV WORD PTR destx, BX
	DB 0x66; MOV AX, CX				// AX = desty
	DB 0x66; MOV CX, BX				// CX = destx
	DB 0x66; ADD AX, WORD PTR viewy
		   //DB 0x66; MOV WORD PTR desty, AX
	DB 0x66; XOR BX, BX
			 MOV BX, viewwidth
	DB 0x66; SUB AX, WORD PTR cury
	DB 0x66; CWD
	DB 0x66; IDIV BX
	DB 0x66; MOV WORD PTR curincy, AX
	DB 0x66; MOV AX, CX
	DB 0x66; SUB AX, WORD PTR curx
	DB 0x66; CWD
	DB 0x66; IDIV BX
	DB 0x66; MOV WORD PTR curincx, AX
}}
*/

void drawview(int cx, int cy, fixed x, fixed y, fixed z,
			  int hang, int vang, int _noid,
			  char &backceildraw, char &backfloordraw, char fixshade) {
	const int quakesh[8]  = { 1, 2, 0,-3,-1, 1,-1, 0};
	const int quakeshz[8] = { 0, 1,-2, 0,-1, 3, 1,-1};
	int i, j;
	int *angptr, angrel;
	int height, startrow, endrow;
	long lstart, lend;
	int shade1;
	int horizont;
	word *coldistptr = coldist;
	Object *obj;
	int objid;
	char rain_near;
	byte oldlast;

	// Have to draw rain near ???
	rain_near = (i = ceilmap[xytoidx(x,y)])==T_DOORSLOT || i>=T_TRANSP;

	viewtop = cy-halfheight;
	viewbottom = cy+halfheight;
	viewleft = cx-halfwidth;
	viewright = cx+halfwidth;

	viewangle = hang;
	viewcos = costab[viewangle];
	viewsin = sintab[viewangle];

	// Quake effect
	if (quake) {
		x += fixmul(-viewsin,(long)quakesh[quake & 7]<<(FIXSHIFT-1));
		y += fixmul( viewcos,(long)quakesh[quake & 7]<<(FIXSHIFT-1));
		z += (long)quakeshz[quake & 7]<<(FIXSHIFT-2);
	}

	viewx = x; viewy = y; viewz = z;

	noid = _noid;

	if (vang) {
		if (vang<ANG90) {
			horizont = cy+fixmul(heightnumerator,tantab[vang]);
		}
/*
	else if (vang<ANG180)
		horizont = cy+fixmul(heightnumerator,-tantab[ANG180-vang]);
	else if (vang<ANG270)
		horizont = cy+fixmul(heightnumerator,tantab[vang-ANG180]);
*/
		else
			horizont = cy+fixmul(heightnumerator,-tantab[ANG360-vang]);
	} else horizont = cy;

#ifdef __DEBUGMODE__
	backceildraw=0;
	backfloordraw=0;
#else
	i = -1;
	if ((oldlast = backceildraw) != 0) {	// non  questo l'uso di oldlast !!!
	  if ((texture = mm_recall(cbackg0)) != NULL) {
		drawbackground(i = (int)fixdiv((long)hang*viewwidth,ANG90) % viewwidth,
					   horizont-halfheight);
		if (horizont>cy)
		  if ((texture = mm_recall(cbackg1)) != NULL)
			drawbackground(i,horizont-viewheight);
	  } else
		if (horizont>viewtop)
		  ffillblock(viewleft,viewtop,viewwidth,horizont-viewtop,0x7f7f7f7fl);
		  // 127 = 0x7f = shadable black
	  if (raindraw && !rain_near && !underblack) {
		drawrain();
		oldlast = 0;	// non ... !!!
	  }
	  if (thunderdraw!=-1 &&
		  (texture = mm_recall(thunderdraw)) != NULL) {
		if (thunderz+128>viewtop &&
			(j = cx+(viewwidth*4/360)*(thunderang-hang)/ANGLVL) >= viewleft-80 &&
			 j<=viewright) {
			/*
			drawcobjHP(j,horizont-thunderz,80,128,
					   (80l*viewwidth)/320,(128l*viewwidth)/320,
					   0,fixshade,texture);
			*/
			setvrect(viewleft,viewtop,viewwidth,viewheight);
			scalerscfig(j,horizont-thunderz,80,128,
						(80l*viewwidth)/320,(128l*viewwidth)/320,
						fixshade,texture);
		}
	  }
	  backceildraw=0;
	}
	if (backfloordraw) {
	  if ((texture = mm_recall(fbackg0)) != NULL) {
		if (i<0)
			drawbackground(i = (int)fixdiv((long)hang*viewwidth,ANG90) % viewwidth,
						   horizont);
		else
			drawbackground(i,horizont);
		if (horizont<cy)
		  if ((texture = mm_recall(fbackg1)) != NULL)
			drawbackground(i,horizont+halfheight);
	  } else
		if (horizont<viewbottom)
		  ffillblock(viewleft,horizont,viewwidth,viewbottom-horizont,0x7f7f7f7fl);
	  backfloordraw=0;
	}
	if (oldlast && raindraw && !rain_near) drawrain();
#endif

	angptr = angtab;

	fdfill(seenmap,0l,4096); // 4096 = sizeof seenmap;

	minceilrow = viewtop;
	minfloorrow = viewbottom;

	fixed prez  = z*heightnumerator,
#ifndef __DOUBLEWALLS__
		  preiz = (4194304l-z)*heightnumerator,
#else
		  preiz = ((4194304l<<1)-z)*heightnumerator,
#endif
		  prehoriz = lshl16(horizont);

	int *chid = ceilhid,
		*fhid = floorhid;

	otextind = -1;	// old texture memory index
	oldlast = COL_ROCK1;

	for (linex=viewleft; linex<viewright; linex++,chid++,fhid++,coldistptr++) {
		if ((rayangle = hang + (angrel = *(angptr++))) >= ANG360) rayangle -= ANG360;
		initray();
		if (raycast()) {
			/*
			while(isnowall==1) {
				//backfloordraw = backceildraw = 1;
				//seenmap[idx] |= 3;
				raynext();
				if (!raycast()) {isnowall=2;break;}
			}
			*/
			//if (isnowall) continue;
			/*
			{
				isnowall=0;
				continue;
			} */

			//dist = fixmul(xinters-viewx,viewcos)+
			//	   fixmul(yinters-viewy,viewsin);
			dist = fixmul(dist,costab[angrel]);
			if (dist<MINDIST) dist = MINDIST;

			*coldistptr = lshr16(dist);
			/* MASTERPLAN
			lstart = prehoriz-fixdiv64shl16(preiz,dist);
			liney = lshr16(lstart);
			lstart -= FIXONE-1;	// aggiusta tutto
			*/
			lstart = prehoriz-fixdiv64shl16(preiz,dist);
			liney = lshr16(lstart+FIXONE-1);
			lend = prehoriz+fixdiv64shl16(prez,dist);
			endrow = lshr16(lend);
			lineh = endrow-liney;	// height
			/*
			if (lineh<2) {
				minceilrow = horizont-1;	// !!!
				minfloorrow = horizont;//+1;
				//*fhid = *chid = halfheight;
				*chid = horizont-viewtop;
				*fhid = viewbottom-horizont;
				lineh=1; vline(127); // Nero shadable
				continue;
			}
			*/
			/*
			if (lineh<=2) {
				liney = horizont-1;
				minceilrow = horizont-2;
				minfloorrow = horizont+1;
				*chid = minceilrow-viewtop;
				*fhid = viewbottom-minfloorrow;
				lineh=2; vline(127); // Nero shadable
				continue;
			}
			*/

			if (liney<viewtop) {
				lineh += liney-viewtop; // negativo
				liney = viewtop;
			}
			if (endrow>viewbottom) {
				endrow = viewbottom;
				lineh = viewbottom-liney;
			}

			if (lineh<=2) {
				//minceilrow = horizont-1;  // !!!
				//minfloorrow = horizont;//+1;
				liney = horizont-1;
				minceilrow = horizont-2;
				minfloorrow = horizont+1;
				*chid = minceilrow-viewtop;
				*fhid = viewbottom-minfloorrow;
				lineh=2; //vline(127); // Nero shadable
				vline(oldlast = LastCol[textind]);
				continue;
			}
#ifndef __DOUBLEWALLS__
			wstep = fixdiv64(0l,1024l,lend-lstart);
#else
			wstep = fixdiv64(0l,2048l,lend-lstart);
#endif
			/* LASCIARE !!!
			// elimina l'effetto "spike" a meta texture
			if ((curx = lshl16(liney)-lstart) != 0l) curx--;
			woffs = fixmul(wstep,curx);
			*/
			/* MASTERPLAN
			woffs = fixmul(wstep,lshl16(liney)-lstart);
			*/
			if ((curx = lshl16(liney)-lstart) != 0l) curx--;
			woffs = fixmul(wstep,curx);
			if (liney>minceilrow) minceilrow = liney-1;
			if (endrow<minfloorrow) minfloorrow = endrow;
			*chid = liney-viewtop;
			*fhid = viewbottom-endrow;

			if (isnowall) {
				backfloordraw = backceildraw = 1;
				continue;
			}

			shade = ((lshr16(dist)-16)>>5)+2-LightMap[idx]+fixshade;
			if (isxray)
				switch(isdiag) {
					case 0: shade -= ((LABS(costab[rayangle])-1)>>14); break;
					case 1: shade -= ((LABS(costab[angleadd(rayangle,ANG45)])-1)>>14); break;
					case 2: shade -= ((LABS(costab[anglesub(rayangle,ANG45)])-1)>>14); break;
				}
			else
				switch(isdiag) {
					case 0: shade -= ((LABS(sintab[rayangle])-1)>>14); break;
					case 1: shade -= ((LABS(sintab[anglesub(rayangle,ANG45)])-1)>>14); break;
					case 2: shade -= ((LABS(sintab[angleadd(rayangle,ANG45)])-1)>>14); break;
				}
			if (dist<24l<<FIXSHIFT)		// !!!shade
				shade += lshr16((24l<<FIXSHIFT)-dist)>>1;
			if (shade<0) shade=0; else
			 if (shade>MAXSHADE) {
				shade = MAXSHADE;
#ifdef __DEBUGMODE__
				vline(128-10);
#else
				//vline(127); // Nero shadable
				vline(oldlast = LastCol[textind]);
#endif
				continue;
			 }
			if (textind != otextind) {
#ifdef __DOUBLEWALLS__
				// Che si sappia: NON VOLEVO METTERCELO, ma sono stato
				//				  costretto con la forza !
				// se togliete questo ricordatevi di togliere
				// anche "j" e sostituirlo pi sotto con "textind"
				 if (textind==T_ARC) {
					texture = mm_recall(j = T_WALL1);
					otextind=textind;
				 } else
				 if (textind==T_ARCM) {
					texture = mm_recall(j = T_WALL1M);
					otextind=textind;
				 } else
#endif
				texture = mm_recall(otextind = j = textind);
#ifdef __DOUBLEWALLS__
				i = HighWall[textind];
				if (i != j/*textind*/) {
					mm_lock(j/*textind*/);
					htexture = mm_recall(i);
					mm_unlock(j/*textind*/);
				}
#endif
			}
#ifdef __DOUBLEWALLS__
			if (i == j/*textind*/) drawwallHP(shade);
							  else drawwallHP2(shade);
#else
			drawwallHP(shade);
#endif
			//drawwall2(shade);
			//drawwall(shade);
		} else {
			//*fhid = *chid = halfheight;
			//*chid = -1;//horizont-viewtop;  !!!!!
			//*fhid = -1;//viewbottom-horizont;    !!!
			*fhid = *chid = 0;
			*coldistptr = 0l; //4096l<<FIXSHIFT;
		  }
	}

	idx = xytoidx(x,y);
	seenmap[idx]|=3;
	objid = IDMap[idx];
	while (objid>=0) {
		obj = objectslist.get(objid);
		if (objid != noid) {
			dist = fixmul(obj->mover->x-viewx,viewcos)+
				   fixmul(obj->mover->y-viewy,viewsin);
			if (dist>MINDIST) {
				obj->seen();
				dobjlist.add(objid,dist);
			}
		}
		objid = obj->mover->underq(idx);
	}

#ifndef __DEBUGMODE__
	 //if (minceilrow>=horizont) minceilrow=horizont-1;
	if (minceilrow>=viewbottom) minceilrow=viewbottom-1;
	 //if (minfloorrow<horizont) minfloorrow=horizont;
	if (minfloorrow<viewtop) minfloorrow=viewtop;

	hang = angleadd(viewangle,angtab[0]);
	fixed leftcos = costab[hang],
		  leftsin = sintab[hang];
	maxcolumn = viewwidth;
	hid = floorhid;
	otextind = -1;	// necessario per il soffitto;
	// occhio al -1 !!!
	for (liney=minfloorrow, lineh=viewbottom-minfloorrow-1; liney<viewbottom; liney++, lineh--) {
	 //if ((liney-horizont+1)<=0) error("<=0 floor");
		//dist = fixdiv(prez,liney-horizont+1); // LABS
		asm {
			DB 0x66; XOR BX, BX
					 MOV BX, liney
					 SUB BX, horizont
					 INC BX	// !!!
			DB 0x66; MOV AX, WORD PTR prez
			DB 0x66; CWD
			DB 0x66; IDIV BX
			DB 0x66; MOV WORD PTR dist, AX
			DB 0x66; MOV CX, 0x8000; DW 0x0000
			DB 0x66; MOV BX, WORD PTR distadj
			DB 0x66; IMUL BX
			DB 0x66; ADD AX, CX
					 ADC DX, 0
			DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
			DB 0x66; MOV BX, AX //Non modifica dist !!!!

			DB 0x66; MOV AX, WORD PTR leftcos
			DB 0x66; IMUL BX
			DB 0x66; ADD AX, CX
					 ADC DX, 0
			DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
		   DB 0x66; MOV CX, AX		// CX = desty
			DB 0x66; ADD AX, WORD PTR viewx
			DB 0x66; MOV WORD PTR curx, AX

			DB 0x66; MOV AX, WORD PTR leftsin
			DB 0x66; IMUL BX
		   DB 0x66; ADD AX, 0x8000; DW 0x0000
					 ADC DX, 0
			DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
		   DB 0x66; MOV BX, AX		// BX = destx
			DB 0x66; ADD AX, WORD PTR viewy
			DB 0x66; MOV WORD PTR cury, AX

		   DB 0x66; NEG BX					// BX = -BX = -destx
		   DB 0x66; ADD BX, WORD PTR viewx
		   DB 0x66; MOV AX, CX				// AX = desty
		   DB 0x66; MOV CX, BX				// CX = destx
		   DB 0x66; ADD AX, WORD PTR viewy
			DB 0x66; XOR BX, BX
					 MOV BX, viewwidth
			DB 0x66; SUB AX, WORD PTR cury
			DB 0x66; CWD
			DB 0x66; IDIV BX
			DB 0x66; MOV WORD PTR curincy, AX
			DB 0x66; MOV AX, CX
			DB 0x66; SUB AX, WORD PTR curx
			DB 0x66; CWD
			DB 0x66; IDIV BX
			DB 0x66; MOV WORD PTR curincx, AX
		}
		shade1 = ((lshr16(dist)-16)>>5)-1+fixshade;
		/*
		dist = fixdiv(prez,liney-horizont+1); // LABS
		shade1 = ((lshr16(dist)-16)>>5)-1+fixshade;
		dist = fixmul(dist,distadj);
		curx = viewx+(desty=fixmul(dist,leftcos));
		cury = viewy+(destx=fixmul(dist,leftsin));
		//destx = viewx+fixmul(dist,rightcos);
		//desty = viewy+fixmul(dist,rightsin);
		destx = -destx+viewx;
		desty = desty+viewy;
		curincx = fixdiv(destx-curx,viewwidth);
		curincy = fixdiv(desty-cury,viewwidth);
		*/
		column = 0;
		linex = viewleft;
		init_fc();
		idx = xytoidx(curx,cury);
		while (column<maxcolumn) {
			/*
			if ((idx & 0xf000) || !seenmap[idx]) {
				idx = fast_passfc();
				continue;
			} else if (seenmap[idx]==2) {
				idx = fast_drawfcblack();
				continue;
			  }
			*/
			if ((idx & 0xf000)!=0 || !seenmap[idx]) {
				idx = fast_passfc();
				continue;
			}

			if ((textind=floormap[idx])!=otextind)
				if (textind >= T_NULL) {
					idx = fast_passfc();
					backfloordraw = 1;
					continue;
				} else texture = mm_recall(otextind=textind);
			shade = shade1-LightMap[idx];
			if (shade<0) shade=0; else
			 if (shade>MAXSHADE) {
				idx = fast_drawfcblack(oldlast);
				continue;
			 }
			if (textind<T_TRANSP)
				idx = fast_drawfc();
			else {
				if (underblack && textind<T_FLROCK)
					idx = fast_drawtfc(127);
				else {
					idx = fast_drawtfc(0);
					backfloordraw = 1;
				  }
			}
		}
	}

	if (otextind==T_DOORSLOT) otextind = -1;	// necessario per il soffitto;
	hid = ceilhid;
	for (liney=minceilrow, lineh=minceilrow-viewtop; liney>=viewtop; liney--, lineh--) {
	   //if ((horizont-liney)<=0) error("<=0 ceil");
		//dist = fixdiv(preiz,horizont-liney);
		asm {
			DB 0x66; XOR BX, BX
					 MOV BX, horizont
					 SUB BX, liney
			DB 0x66; MOV AX, WORD PTR preiz
			DB 0x66; CWD
			DB 0x66; IDIV BX
			DB 0x66; MOV WORD PTR dist, AX
			DB 0x66; MOV CX, 0x8000; DW 0x0000
			DB 0x66; MOV BX, WORD PTR distadj
			DB 0x66; IMUL BX
			DB 0x66; ADD AX, CX
					 ADC DX, 0
			DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
			DB 0x66; MOV BX, AX //Non modifica dist !!!!

			DB 0x66; MOV AX, WORD PTR leftcos
			DB 0x66; IMUL BX
			DB 0x66; ADD AX, CX
					 ADC DX, 0
			DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
		   DB 0x66; MOV CX, AX		// CX = desty
			DB 0x66; ADD AX, WORD PTR viewx
			DB 0x66; MOV WORD PTR curx, AX

			DB 0x66; MOV AX, WORD PTR leftsin
			DB 0x66; IMUL BX
		   DB 0x66; ADD AX, 0x8000; DW 0x0000
					 ADC DX, 0
			DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
		   DB 0x66; MOV BX, AX		// BX = destx
			DB 0x66; ADD AX, WORD PTR viewy
			DB 0x66; MOV WORD PTR cury, AX

		   DB 0x66; NEG BX					// BX = -BX = -destx
		   DB 0x66; ADD BX, WORD PTR viewx
		   DB 0x66; MOV AX, CX				// AX = desty
		   DB 0x66; MOV CX, BX				// CX = destx
		   DB 0x66; ADD AX, WORD PTR viewy
			DB 0x66; XOR BX, BX
					 MOV BX, viewwidth
			DB 0x66; SUB AX, WORD PTR cury
			DB 0x66; CWD
			DB 0x66; IDIV BX
			DB 0x66; MOV WORD PTR curincy, AX
			DB 0x66; MOV AX, CX
			DB 0x66; SUB AX, WORD PTR curx
			DB 0x66; CWD
			DB 0x66; IDIV BX
			DB 0x66; MOV WORD PTR curincx, AX
		}
		shade1 = ((lshr16(dist)-16)>>5)-1+fixshade;
		column = 0;
		linex = viewleft;
		init_fc();
		idx = xytoidx(curx,cury);
		while (column<maxcolumn) {
			/*
			if (idx & 0xf000) {
				idx = fast_passfc();
				continue;
			} else if (!seenmap[idx]) {
				idx = fast_drawfcblack();
				continue;
			  }
			*/

			if ((idx & 0xf000)!=0 || !seenmap[idx]) {
				idx = fast_passfc();
				continue;
			}

			if ((textind = ceilmap[idx])!=otextind)
				if (textind>=T_NULL) {
					otextind=-1;
					idx = fast_passfc();
					backceildraw = 1;
					continue;
				} else texture = mm_recall(otextind=textind);
			shade = shade1-LightMap[idx];
			if (shade<0) shade=0; else
			 if (shade>MAXSHADE) {
				idx = fast_drawfcblack(oldlast);
				continue;
			 }
			if (textind<T_TRANSP)
				idx = fast_drawtfc(127);
			else {
				idx = fast_drawtfc(0);
				backceildraw = 1;
			}
		}
	}
#endif

#ifndef __DEBUGMODE__
	// Draws Objects - DRAWOBJ
	int app, vx, ovx, idist;
	fixed destx, desty;
	while ((objid = dobjlist.get(dist))>=0) {
			obj = objectslist.get(objid);

			shade = (((idist = lshr16(dist))-16)>>5)-1-obj->selflight-
					LightMap[xytoidx(obj->mover->x,obj->mover->y)]+fixshade;
			if (dist<24l<<FIXSHIFT)		// !!!shade
				shade += lshr16((24l<<FIXSHIFT)-dist)>>1;
			if (shade<0) shade=0; else
				if (shade>MAXSHADE)
					//shade=MAXSHADE;
					continue; // !!! NOOO! cos si elimina l'effetto Hitckoc

			destx = fixmul(obj->mover->y-y,viewcos)-
					fixmul(obj->mover->x-x,viewsin);
			ovx = vx = cx+(app = (int)fixdiv((destx>>2)*objscale,dist>>2));
			app += halfwidth;
			if (app<0) app=0; else
			 if (app>=viewwidth) app=viewwidth-1;
			app = viewangle+angtab[app];
			if (app<0) app+=ANG360; else
			 if (app>=ANG360) app-=ANG360;

			//TFigure &fig = FigList[(byte)(i = obj->getviewfig(app))]; // !!!
			TFigure &fig = FigList[(i = obj->getviewfig(app)) & 0x3fff]; // !!!
			texture = mm_recall(fig.memidx);

			//relative base height
			destx = z - obj->mover->z - lshl16(fig.height);
			lend = prehoriz+fixdiv64shl16(destx*heightnumerator,dist);
			lstart = prehoriz+fixdiv64shl16((destx-lshl16(fig.dy))*heightnumerator,dist);
			if (lshr16(lstart)>=viewbottom || lshr16(lend)<viewtop) continue;
			height = lshr16(lend-lstart);
			if (height<=0) continue;
		   //	j = (int)(((long)height*fig.dx*15/fig.dy)>>4);
			j = ((long)height*fig.dx*15/fig.dy)>>4;
			if (j<=0) continue;
			vx -= j>>1;
			if (vx+j<viewleft || vx>=viewright) continue;

			if (i & 0x4000)	// mirrored ?
				drawrcobjHP(vx,lshr16(lstart),fig.dx,fig.dy,
					   j,height,idist-(1<<(obj->mover->shdim-1)),shade,texture);
			else {
				if (GETFLAG(obj->oflags,OFL_ISLIGHT)) {
					shade = (7-shade-((LightActor *)obj)->lightpow);
					if (shade<-1) shade=-1;
					drawclightHP(vx,lshr16(lstart),fig.dx,fig.dy,
					   j,height,idist-(1<<(obj->mover->shdim-1)),shade,texture);
					break;
				} else
					drawcobjHP(vx,lshr16(lstart),fig.dx,fig.dy,
					   j,height,idist-(1<<(obj->mover->shdim-1)),shade,texture);

				if (GETFLAG(obj->oflags,OFL_HASLIGHT)) {
				 i = ((LightActor *)obj)->getlightfig();
				 if (i > -1) {
				  shade = (((idist = lshr16(dist))-16)>>4)-1- //obj->selflight-
						LightMap[xytoidx(obj->mover->x,obj->mover->y)]+fixshade;
				  if (shade<0) shade=0; else
					if (shade>MAXSHADE) shade=MAXSHADE;
				  TFigure &lightfig = FigList[i]; // !!!
				  texture = mm_recall(lightfig.memidx);
				  destx = z - ((LightActor *)obj)->lightz - lshl16(lightfig.height);
				  lend = prehoriz+fixdiv64shl16(destx*heightnumerator,dist);
				  lstart = prehoriz+fixdiv64shl16((destx-lshl16(lightfig.dy))*heightnumerator,dist);
				  if (lshr16(lstart)>=viewbottom || lshr16(lend)<viewtop) continue;
				  height = lshr16(lend-lstart);
				  j = ((long)height*lightfig.dx*15/lightfig.dy) >> 4;
				  ovx -= j >> 1;
				  shade = (7-shade);
				  if (shade <= 0) shade = ((-shade) >> 2) + 1;
				  shade -= ((LightActor *)obj)->lightpow;
				  if (shade<-1) shade=-1;
				  drawclightHP(ovx,lshr16(lstart),lightfig.dx,lightfig.dy,
					   j,height,idist-(lightfig.dx >> 1),shade,texture);
				 }
				}
			}
	}
#else
	dobjlist.flush();
#endif
	if (raindraw && rain_near) drawrain();
}

void invpix(int x, int y, char shader) {
asm {
	LES DI, vpage
	MOV AX, y
	XCHG AH, AL
	ADD DI, AX
	SHR AX, 2
	ADD DI, AX
	ADD DI, x
	MOV AL, ES:[DI]
	//AND AL, 0x0f
	SUB AL, 15
	NEG AL
	AND AL, 0x0f
	OR AL, 0xe0

	MOV AH, AL
	ADD AL, shader
	XOR AH, AL
	AND AH, HISHMASK
	JZ store
	XOR AH, AL
	OR AL, LOSHMASK
} store: asm {
	MOV ES:[DI], AL
}}

void drawrain() {
	byte col;
	int sx = viewleft, sy = viewtop;
	int i,j,k,ix,iy,
		app = viewwidth>>7;
	fixed x,rs,dex;
	for (i=0; i<MAXRAIN; i++) {
		TRainInfo &ri = rain_info[i];
		x = ri.x; iy = lshr16(ri.y);
		k = fixmul(app,(rs = rain_speed[i])>>1);
		dex = fixmul(rs>>4,viewsin);
		for (j=0,col=k;j<k;j++,iy++,col--) {
			ix = lshr16(x); x += dex;
			if (ix>=0 && ix<viewwidth && iy>=0 && iy<viewheight)
				invpix(ix+sx,iy+sy,col);
				//putpix(ix+sx,iy+sy,col);
				/*
				asm {
					LES DI, vpage
					MOV AX, iy
					ADD AX, sy
					XCHG AH, AL
					ADD DI, AX
					SHR AX, 2
					ADD DI, AX
					ADD DI, ix
					ADD DI, sx
					MOV AL, col
					MOV ES:[DI], AL
				}
				*/
		}
	}
}

/*
void drawrain() {
	// Draw rain
	if (viewwidth>=212) {
		asm {	// Draw long rain
			MOV DX, viewtop
			PUSH BP		// !!! Ma sei impazzito !?
			MOV BP, viewleft
			LES DI, vpage
			LEA SI, rain_info
			MOV CX, MAXRAIN
			CLD
		} c1: asm {
			LODSW
			ADD AX, BP
			MOV BX, AX
			LODSW
			ADD AX, DX
			XCHG AH, AL
			ADD BX, AX
			SHR AX, 2
			ADD BX, AX
			MOV AL, 226
			MOV ES:[DI+BX], AL
			ADD BX, 319
			DEC AL
			DEC AL
			MOV ES:[DI+BX], AL
			LOOP c1
			POP BP
			// !!! SS==DS
			MOV AX, SS
			MOV DS, AX
		}
	  } else {
		asm {	// Draw short rain
			MOV DX, viewtop
			PUSH BP			// !!!
			MOV BP, viewleft
			LES DI, vpage
			LEA SI, rain_info
			MOV CX, MAXRAIN
			CLD
		} c2: asm {
			LODSW
			ADD AX, BP
			MOV BX, AX
			LODSW
			ADD AX, DX
			XCHG AH, AL
			ADD BX, AX
			SHR AX, 2
			ADD BX, AX
			MOV AL, 225
			MOV ES:[DI+BX], AL
			LOOP c2
			POP BP
			// !!! SS==DS
			MOV AX, SS
			MOV DS, AX
		}
		}
}

void anim_rain() {
	// Animate rain (separate for frame skipping)
	int i, sx=rainspeed>>1, sy=rainspeed;
	for (i=0; i<MAXRAIN>>1; i++) {
		if ((rain_info[i].x-=sx)<=1) rain_info[i].x = viewwidth-1;
		if ((rain_info[i].y+=sy)>=viewheight-1) rain_info[i].y = 0;
	}
	//sx++;
	sy++;
	for (i=MAXRAIN>>1; i<MAXRAIN; i++) {
		if ((rain_info[i].x-=sx)<=1) rain_info[i].x = viewwidth-1;
		if ((rain_info[i].y+=sy)>=viewheight-1) rain_info[i].y = 0;
	}
}
*/

void anim_rain() {
	int i;
	fixed rb = lshl16(viewwidth+2),
		  bb = lshl16(viewheight+2),
		  spd = lshl16(viewwidth/80),
		  app;
	//int randlim = viewheight/3;
	for (i=0; i<MAXRAIN; i++) {
		TRainInfo &ri = rain_info[i];
		ri.x += fixmul((app = rain_speed[i])>>1,viewsin);
		ri.y += app;
		rain_speed[i] += app>>4 /*16384l*/;
		if (ri.x < -2l<<FIXSHIFT) ri.x = rb; else
			if (ri.x > rb) ri.x = -2l<<FIXSHIFT;
		if (ri.y > bb) {
			ri.y = -2l<<FIXSHIFT;
			ri.x = lshl16(random(viewwidth+4)-2);
			rain_speed[i] = spd-16384l+lshl8(random(2048));
		}
	}
}

void drawhand(int handmidx, int dx, int dy, int hotx, int hoty,
			  int jmph, int angle, char shade) {
#ifndef	__DEBUGMODE__
	int real_dx,real_dy,real_hotx,real_hoty;
	fixed presin = sintab[angle]>>2;
	real_dx = ((long)dx*viewwidth)/320;
	real_dy = ((long)dy*viewwidth)/320;
	real_hotx = ((long)hotx*viewwidth)/320;
	real_hoty = ((long)(dy+hoty)*viewwidth)/320;
	jmph = ((long)jmph*halfwidth)/320;
	setvrect(viewleft,viewtop,viewwidth,viewheight);
	scalerscfig(viewleft+halfwidth-real_hotx+fixmul(jmph,presin>>1),
				viewbottom-real_hoty+(jmph>>2)+fixmul(jmph,presin)+1,
				dx,dy,real_dx,real_dy,shade,mm_recall(handmidx));
	/*
	drawcobjHP(viewleft+halfwidth-real_hotx+fixmul(jmph,presin>>1),
			   viewbottom-real_hoty+(jmph>>2)+fixmul(jmph,presin)+1,
			   dx,dy,real_dx,real_dy,0,shade,mm_recall(handmidx));
	*/
#endif
}

void virtualview(fixed x, fixed y, int angle, int _noid) {
	viewx = x; viewy = y;
	viewangle = angle;
	viewcos = costab[viewangle];
	viewsin = sintab[viewangle];
	noid = _noid;
	int *angptr = angtab;
	fdfill(seenmap,0l,4096); // 4096 = sizeof seenmap;
	for (linex=viewwidth;linex--;) {
		if ((rayangle = angle + *(angptr++)) >= ANG360) rayangle -= ANG360;
		initray();
		raycast();
	}
	dobjlist.flush();
	//int objid;
	//while ((objid = dobjlist.get(dist))>=0);
}

void drawmap(int cx, int cy, fixed x, fixed y, int ang, char *sm) {
	int i,j,k,l,curx,cury,bx,by,bdx,bdy,sqrdim;
	byte col;
	setvrect(cx-halfwidth,cy-halfheight,viewwidth,viewheight);
	//if ((sqrdim = (viewwidth+32)>>6)<1) sqrdim=1;
	sqrdim = (viewwidth+32)>>6;
	bdx = (viewwidth+((sqrdim-1)<<1))/sqrdim;
	bdy = (viewheight+((sqrdim-1)<<1))/sqrdim;
	if ((bx=(lshr16(x)>>6)-(bdx>>1))<0) {bdx+=bx;bx=0;}
	if ((by=(lshr16(y)>>6)-(bdy>>1))<0) {bdy+=by;by=0;}
	if (bx+bdx>64) bdx=64-bx;
	if (by+bdy>64) bdy=64-by;
	//curx = cx-bx*sqrdim-(((lshr16(x) & 63)*sqrdim)>>6);
	//cury = cy-by*sqrdim-(((lshr16(y) & 63)*sqrdim)>>6);
	curx = cx-((int)fixmul(sqrdim,x-lshl16(bx<<6))>>6);
	cury = cy-((int)fixmul(sqrdim,y-lshl16(by<<6))>>6);
	bx<<=6;
	ffillblock(cx-halfwidth,cy-halfheight,
			   viewwidth,viewheight,0x7f7f7f7fl); // 127 = 7fh black sh.
	if (GETFLAG(gameflags,GFL_TOTALMAP)) {
	for (i=bdx;i--;bx+=64,curx+=sqrdim)
	  for (j=bdy,k=by,l=cury;j--;k++,l+=sqrdim) {
		TMapInfo &mapinf = Map[bx+k];
		if (mapinf.stop)
			if (mapinf.shape==MSH_DOOR) {
				if (doormanager.doorpos(mapinf.data)==64) col=3; else
				if (doormanager.doortype[mapinf.data]==T_DOORY) col=132; else
				if (doormanager.doortype[mapinf.data]==T_DOORR) col=82; else
					col = 232;
			} else
			if (mapinf.type==MTP_DOOR1 || mapinf.type==MTP_DOOR2) {
				if (doormanager.doorpos(mapinf.data)==64) col=3;
													 else col=118;
			} else
			if (mapinf.data==T_SWITCHU) col=160;
			else col=118;
		else
		if (IDMap[bx+k]>=0) col=126; //col=136;
					   else col=3;
		putlcchar(curx,l,sqrdim,sqrdim,col,0,mapsquare);
	  }
	} else {
	for (i=bdx;i--;bx+=64,curx+=sqrdim)
	  for (j=bdy,k=by,l=cury;j--;k++,l+=sqrdim)
		if (sm[bx+k]) {
		  TMapInfo &mapinf = Map[bx+k];
		  if (mapinf.stop)
			if (mapinf.shape==MSH_DOOR) {
				if (doormanager.doorpos(mapinf.data)==64) col=6; else
				if (doormanager.doortype[mapinf.data]==T_DOORY) col=132; else
				if (doormanager.doortype[mapinf.data]==T_DOORR) col=82; else
					col = 232;
			} else
			if (mapinf.type==MTP_DOOR1 || mapinf.type==MTP_DOOR2) {
				if (doormanager.doorpos(mapinf.data)==64) col=6;
													 else col=118;
			} else
			if (mapinf.data==T_SWITCHU) col=160;
			else col=118;
		  else col=6;
			//if (seenmap[bx+k]) col=1; else col=6;
		  putlcchar(curx,l,sqrdim,sqrdim,col,0,mapsquare);
		}
	}
	putpix(cx+fixmul(1,costab[ang]),cy+fixmul(1,sintab[ang]),113);
	putpix(cx+fixmul(2,costab[ang]),cy+fixmul(2,sintab[ang]),112);
	putpix(cx,cy,114);
}

void updatemap(void far *sm) {
asm {
	LES DI, sm
	LEA SI, seenmap
	MOV CX, 1024
	CLD
} c1: asm {
	DB 0x66; LODSW
	DB 0x66; OR WORD PTR ES:[DI], AX
	ADD DI, 4
	LOOP c1
	// !SS==DS!
	MOV AX, SS
	MOV DS, AX
}}

void init3DEngine() {
	map = (word *)Map;
	objmap = (word *)ObjMap;
	fwfill(mapsquare,0x01010101l,25);
	//vpage = new char[64000];	// !!!!!!!!
	setvbuff(vpage);	// LGRAPH
	calctables();
	//setviewsize(320-10,200-32);	// ???
	setviewsize(320,200-32);
	//drawview(160,100,x,y,z,angle,vangle<0 ? vangle+ANG360 : vangle);
}
