/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// XMS - Low Level Routines - (C)1997  Nicosot (Valentini Domenico)

#include "std.hpp"
#include "xms.hpp"

char XMSok;
static void (far *XMSControl)(void);

char XMSinstalled() {
asm {
	MOV AX, 0x4300
	INT 0x2f
	CMP AL, 0x80
	MOV AL, 0
	JNE end
	MOV AX, 0x4310
	INT 0x2f
	MOV WORD PTR XMSControl, BX
	MOV WORD PTR XMSControl[2], ES
	MOV AL, 1
} end: return XMSok=_AL; }

int XMSgetver() {
	if (!XMSok) return 0;
asm XOR AX, AX;
	XMSControl();
	return _AX;
}

int XMSgetrev() {
	if (!XMSok) return 0;
asm XOR AX, AX;
	XMSControl();
	return _BX;
}

word XMSmemfree() {
	if (!XMSok) return 0;
	_AX = 0x0800;
	XMSControl();
	return _AX;
}

word XMSblockfree() {
	if (!XMSok) return 0;
	_AX = 0x0800;
	XMSControl();
	return _DX;
}

word XMSnew(word size) {
	if (!XMSok) return 0;
	_DX = size;
	_AX = 0x0900;
	XMSControl();
	if (_AX) return _DX;
		else return 0;
}

char XMSdelete(word handle) {
	if (!XMSok) return 0;
	_DX = handle;
	_AX = 0x0a00;
	XMSControl();
	return _AL;
}

#pragma warn -rvl
char XMSmove(TXMSMoveStruct far *movestruct) {
	if (!XMSok) return 0;
asm {
	LDS SI, DWORD PTR movestruct
	MOV AX, 0x0b00
	CALL DWORD PTR XMSControl
	// !!! SS==DS !!!
	MOV DX, SS
	MOV DS, DX
}}
#pragma warn +rvl

/*
char XMSgetinfo(word handle, unsigned long &offset, word &size) {
	unsigned long _off = 0;
	word _siz = 0;

	if (!XMSok) return 0;
asm {	MOV AX, 0x0e00
		MOV DX, handle
		PUSH BP
}
		XMSControl();
asm	{	POP BP
		OR AX, AX
		JZ erend
		MOV _siz, DX
		MOV AX, 0x0c00
		MOV DX, handle
		PUSH BP
}
		XMSControl();
asm	{	POP BP
		OR AX, AX
		JZ erend
		MOV WORD PTR _off, BX
		MOV WORD PTR _off[2], DX
		MOV AX, 0x0d00
		MOV DX, handle
}
		XMSControl();
asm	{	OR AX, AX
		JZ erend
} end:  offset = _off;
		size = _siz;
		return 1;
erend: 	return 0; }
*/

char XMSgetsize(word handle, word &size) {
	word _siz;
	if (!XMSok) return 0;
asm {
		MOV AX, 0x0e00
		MOV DX, handle
		PUSH BP
		CALL DWORD PTR XMSControl;
		POP BP
		OR AX, AX
		JZ erend
		MOV _siz, DX
} end:  size = _siz;
		return 1;
erend: 	return 0; }