/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// MM - MemoryManager - (C)1997  Nicosot (Valentini Domenico)
// Tutti i diritti sono strettamente riservati !

// +Packer

// V3.3 - DISK SWAPPING & NO DEALLOCATION CAPABILITY

#define	__PACKED_BDF__

#include "std.hpp"
#include "errorstr.hpp"
#include "xms.hpp"
#include "mm4.hpp"
#include "fastmem.hpp"
#include <alloc.h>
#include <io.h>
#include <fcntl.h>

#include <stdio.h>
#include <process.h>
#include "lgraph.hpp"

#define	MM_MAXRESETCNT	8

#define	CMPM_EVAL	0
#define	CMPM_PACK	1
#define	CMPM_STORE	2

//#include <stdio.h>
//#include <stdlib.h>
//#include <dos.h>

typedef struct {
			pointer addr;	// 0
			word size;  	// 4
			byte flag;    	// 6
			byte lock;    	// 7
		} TBlock;					// size 8 !!!
#define	SIZE_B		8

typedef struct {
			int id;    			// 0
			pointer addr;     	// 2
			unsigned long size;	// 6
		} TXMSBlock;				// size 10 !!!
#define	SIZE_XMSB	10

const char idBDF[9] = "NICbdf\x7\x1a";

TBlock *mm_BlockList;
TXMSBlock *mm_XMSList;
int mm_maxmemblocks = MAXMEMBLOCKS,
	mm_memblocks, mm_xmsblocks;
word mm_xmshandle;
unsigned long mm_xmsfree, mm_allocvol, mm_allocfree;
#ifdef __MAINCHECK__
long mm_mainmem;
#endif
#ifdef __DATAFILE__
long *mm_DiskOfs;
#ifdef __PACKED_BDF__
word *mm_BlkSize;
#endif
int mm_datafile;
#endif
static char mm_resetcnt;
/*
#pragma warn -rvl
void far *alignptr(void far *pntr) {
asm {
	MOV AX, WORD PTR pntr
	MOV DX, WORD PTR pntr[2]
	MOV BX, AX
	SHR BX, 4
	ADD DX, BX
	AND AX, 0x000f
}}
#pragma warn +rvl
*/

//void mm_visualize(); 	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// Non voglio che gli hacker pensino che sono stupido...
// ...ma queste routines sono veramente controproducenti !

void near encrypt(void far *pntr, word size) {
asm {
	//LES DI, pntr
	LDS SI, pntr
	MOV CX, size
	SHR CX, 1	// se  dispari chissene frega
	// CLD no LODS !!!
} c1: asm {
	ADD [SI], CL
	INC SI
	ADD [SI], CL
	INC SI
	/*
	LODSW
	ADD AX, CX
	STOSW
	*/
	LOOP c1
	// ! SS==DS !
	MOV AX, SS
	MOV DS, AX
}}

void near decrypt(void far *pntr, word size) {
asm {
	//LES DI, pntr
	LDS SI, pntr
	MOV CX, size
	SHR CX, 1	// se  dispari chissene frega
	// CLD  no LODS !!!
} c1: asm {
	SUB [SI], CL
	INC SI
	SUB [SI], CL
	INC SI
	/*
	LODSW
	SUB AX, CX
	STOSW
	*/
	LOOP c1
	// ! SS==DS !
	MOV AX, SS
	MOV DS, AX
}}

#ifdef __PACKED_BDF__
word near mm_compress(void far *source, void far *destin, word size) {
	word cmpsize = 0;
	signed char count;
	byte oldb, newb, mode = CMPM_EVAL;
	byte far *app,
		far *dest = (byte *)destin,
		far *mark;

	oldb = *(app = (byte *)source);
	app++;
	size--;
	while (size--) {
		// Fetch
		newb = *(app++);
		switch(mode) {
		case CMPM_STORE:
			if (newb==oldb) {
				if (size && *app==newb) {
					// Mem
					*(dest++) = count+1; // count NON viene incrementato !
					fwmove(dest,app+count-2,-count);
					dest -= count;
					cmpsize += (int)(-count)+1;
					// Change Mode/Auto prefetch
					mode = CMPM_PACK;
					count=1; // o meglio count=2; app++;
					break;
				}
			}
			if (--count == -128) {
				// Mem
				*(dest++) = -128;
				fwmove(dest,app-129,129);
				dest += 129;
				cmpsize += 130;
				//dest -= count;
				// Change Mode/Prefetch
				mode = CMPM_EVAL;
				if (!size--) return cmpsize;
				newb = *(app++);
			}
			break;
		case CMPM_PACK:
			if (newb!=oldb) {
				// Mem
				*(dest++) = count;
				*(dest++) = oldb;
				cmpsize += 2;
				// Change Mode
				mode = CMPM_EVAL;
			} else {
				if (++count == 127) {
					// Mem
					*(dest++) = 127;
					*(dest++) = oldb;
					cmpsize += 2;
					// Change Mode/Prefetch
					mode = CMPM_EVAL;
					if (!size--) return cmpsize;
					newb = *(app++);
				}
			  }
			break;
		case CMPM_EVAL:
			if (newb==oldb) {
				mode = CMPM_PACK;
				count = 1;
			} else {
				mode = CMPM_STORE;
				count = -1;
			  }
			break;
		}
		oldb = newb;
	}
	switch(mode) {
	case CMPM_PACK:
		*(dest++) = count;
		*dest = oldb;
		cmpsize += 2;
		break;
	case CMPM_STORE:
		*(dest++) = count;
		fwmove(dest,app+count-1,(int)(-count)+1);
		cmpsize += (int)(-count)+2;
		break;
	case CMPM_EVAL:
		*(dest++) = 0;	// store one
		*dest = oldb;
		cmpsize += 2;
		break;
	}
	return cmpsize;
}

void near mm_uncompress(void far *source, void far *dest, word cmpsize) {
asm {
	LDS SI, source
	LES DI, dest
	MOV DX, cmpsize
} c1: asm {
	LODSB
	CBW
	MOV CX, AX
	OR AX, AX
	JS store
	DEC DX
	LODSB
	STOSB
	REP STOSB	// se CX==0 non fa niente
	DEC DX
	JNZ c1
	JMP end
} store: asm {
	NEG CX
	ADD DX, AX //SUB DX, CX
	DEC DX
	MOVSB
	REP MOVSB
	DEC DX
	JNZ c1
} end: asm {
	// ! SS==DS !
	MOV AX, SS
	MOV DS, AX
} }
#endif

int mm_newblock() {
	if (mm_memblocks<mm_maxmemblocks) {
		TBlock &block = mm_BlockList[mm_memblocks];
		block.flag = 0;
		block.lock = 0;
		block.addr.ofs = 0l;
		return mm_memblocks; // NON INCREMENTARE !!!!!
	}
	return -1;
}

#pragma warn -rvl
int near mm_findxmsidx(int id) {
asm {
	MOV BX, id
	MOV CX, mm_xmsblocks
	LDS SI, mm_XMSList
	MOV DX, SIZE_XMSB
	XOR AX, AX
} l1: asm {
	CMP [SI], BX
	JE found
	ADD SI, DX
	INC AX
	LOOP l1
	MOV AX, -1
} found: asm {
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
}}
#pragma warn +rvl

void near mm_swapblock(int id) {
	int i, j;
	TBlock &Block = mm_BlockList[id];
	TXMSMoveStruct mvdata;
#ifdef __DATAFILE__
	word bestsize = 0; // 0xffff;
	int bestid = -1;
#endif

	//sound(100);delay(5);nosound();
	for (i=0; i<mm_xmsblocks; i++) {
		TXMSBlock &XMSBlock = mm_XMSList[i];
		if (XMSBlock.id == -1 && XMSBlock.size >= Block.size) {
			if (XMSBlock.size > Block.size) {
				// split the block if possible
				if (mm_xmsblocks<MAXXMSBLOCKS) {
					mm_xmsblocks++;
					if (i+2 < mm_xmsblocks)
						fodmove(&mm_XMSList[i+2],&mm_XMSList[i+1],
								sizeof(TXMSBlock)*(mm_xmsblocks-i-2));
					mm_XMSList[i+1].id = -1;
					mm_XMSList[i+1].size = XMSBlock.size-Block.size;
					mm_XMSList[i+1].addr.ofs = XMSBlock.addr.ofs+Block.size;
					XMSBlock.size = Block.size;
				} else continue;	// don't take it !
				// else take it as well (without splitting it)
				/*
				else {
					   continue; // finally throw it on disk (virtually)
								 // IF DISK IS ACTIVE IT DOESN'T FAIL
					   error("No XMS rooms");
				  }
				*/
			}
			mvdata.size = Block.size;	// Moves only used data
			mvdata.shandle = 0;
			mvdata.sptr = Block.addr;
			mvdata.dhandle = mm_xmshandle;
			mvdata.dptr = XMSBlock.addr;
			if (!XMSmove(&mvdata)) error("mm_swapblock()","move");
#ifdef __MAINCHECK__
			if (!(Block.flag & (BLF_XMS|BLF_DISK)))
				mm_mainmem -= Block.size;
#endif
			Block.flag = BLF_XMS|BLF_USED;
			XMSBlock.id = id;
			//mm_XMSList[i].size = Block.size; ???!!! why ?
			mm_xmsfree -= XMSBlock.size;
			mm_allocfree += Block.size;	// !!! duplicate !!!!
			delete Block.addr.ptr;
			Block.addr = XMSBlock.addr;
			return;
		}
#ifdef __DATAFILE__
		  else {
			// estabilishes the best allocated unused XMS block
			// Il Best  quello con pi spreco
			j = XMSBlock.id;
			if (j>=0 && !(mm_BlockList[j].flag & BLF_USED) &&
				XMSBlock.size>=Block.size &&
				XMSBlock.size<bestsize) {
				//(XMSBlock.size-mm_BlockList[j].size)>=bestsize) {  // >= !
				bestsize = XMSBlock.size-mm_BlockList[j].size;
				bestid = i;	// e non "j" !
			}
		  }
#endif
	}
#ifdef __DATAFILE__
	// last beach: the unused XMS block !
//#ifndef __DEBUGMODE__
	if (bestid>=0) {
		// NON SPLITTO I BLOCCHI ! (per scelta)
		// Throw old Block out
		TXMSBlock &XMSBlock = mm_XMSList[bestid];
		//mm_xmsfree += XMSBlock.size; no, tanto lo rioccupo subito
		//mm_allocfree += mm_BlockList[XMSBlock.id].size;	// !!! duplicate !!!!
		mm_BlockList[XMSBlock.id].flag = BLF_DISK;
		// Replace the space with newer block
		mvdata.size = Block.size;	// Moves only used data
		mvdata.shandle = 0;
		mvdata.sptr = Block.addr;
		mvdata.dhandle = mm_xmshandle;
		mvdata.dptr = XMSBlock.addr;
		if (!XMSmove(&mvdata)) error("mm_swapblock()","move");
		Block.flag = BLF_XMS|BLF_USED;
		XMSBlock.id = id;
		//mm_XMSList[i].size = Block.size; ???!!! why ?
		//mm_xmsfree -= XMSBlock.size;
		mm_allocfree += Block.size;	// !!! duplicate !!!!
#ifdef __MAINCHECK__
		mm_mainmem -= Block.size;
#endif
		delete Block.addr.ptr;
		Block.addr = XMSBlock.addr;
		//sound(1000);delay(5);nosound();
	} else {
//#endif
		// I'll not fail (using the disk)
		//mm_xmsfree -= Block.size; NO non si libera XMS !
		mm_allocfree += Block.size;	// !!! duplicate !!!!
#ifdef __MAINCHECK__
		mm_mainmem -= Block.size;
#endif
		Block.flag = BLF_DISK;
		delete Block.addr.ptr;
//#ifndef __DEBUGMODE__
	}
//#endif
#else
	error("mm_swapblock","fail");
#endif
}

/* ...and where everybody fall,
		  where the known can't help,
		  where C++ can do nothing,
		  where the computer reclaims its born,
		  it, "The Wizard", solve any problem.
*/
void far * near mm_wizard(word size) {
// This verion of The Wizard do NOT uses FORCED_FIRST_FIT method.
	//register
	int i, j;
	//register
	TBlock *Block;
	int bestfit = -1;
	word bestsize = 0xffff;
	byte f;
	void far *ptr;

	// if (!mm_memblocks) return NULL; ???!!!

	for (i=0,Block=mm_BlockList; i<mm_memblocks; i++,Block++) {
		if (!(Block->flag & (BLF_UNREADY|BLF_USED|BLF_LOCKED)) &&
			Block->size>=size && Block->size<bestsize) {
				bestfit=i;
				bestsize=Block->size;
		}
	}

	if (bestfit>=0) {
		mm_swapblock(bestfit);
		if ((ptr = new char[size]) != NULL) return ptr;
	}
	bestsize = 0xffff;
	bestfit = -1;

	// Swap UNUSED, UNLOCKED conventional blocks
	for (i=0, Block = mm_BlockList; i<mm_memblocks; i++, Block++)
		if (!((f = Block->flag) & (BLF_UNREADY | BLF_USED | BLF_LOCKED))) {
			mm_swapblock(i);
			if ((ptr = new char[size]) != NULL) return ptr;
		} else
		if (!(f & (BLF_UNREADY | BLF_LOCKED)) &&
			Block->size>=size && Block->size<bestsize) {
				bestfit=i;
				bestsize=Block->size;
		}

	// Swap best USED, UNLOCKED coventional block
	if (bestfit>=0) {
		mm_swapblock(bestfit);
		if ((ptr = new char[size]) != NULL) return ptr;
	}

	// Swap UNLOCKED conventional blocks
	for (i=0, Block = mm_BlockList; i<mm_memblocks; i++, Block++)
		if (!(Block->flag & (BLF_UNREADY | BLF_LOCKED))) {
			mm_swapblock(i);
			if ((ptr = new char[size]) != NULL) return ptr;
		}

	if ((ptr = new char[size]) != NULL) return ptr;
								   else return NULL; 	// Sorry, I failed.
}

void far * near mm_sysalloc(word size) {
	void far *ptr;
	size = (size+1) & 0xfffe;
	if (!(ptr = new char[size]))
		ptr = mm_wizard(size);
	return ptr;
}

// ---- USER ----
//#pragma warn -rvl
void far *mm_reserve(word size) {
	void far *ptr;
	if ((ptr = mm_sysalloc(size)) == NULL)
		error("mm_reserve","fail"); // return NULL;
	return ptr;
}

/*
void far *mm_alloc(word size, int &id) {
	if ((id = mm_newblock()) == -1)
		error("mm_alloc - No rooms");
#ifdef __DATAFILE__
	if (!size) size = (word)(mm_DiskOfs[id+1]-mm_DiskOfs[id]);
	else
#endif
	  size = (size+1) & 0xfffe;
	mm_BlockList[id].size = size;
	mm_BlockList[id].flag = 0;
	if (!(mm_BlockList[id].addr.ptr = new char[size]))
		if (!(mm_BlockList[id].addr.ptr = mm_wizard(size)))
			error("mm_alloc - No memory");
	mm_allocvol += size;
	mm_memblocks++;
#ifdef __DATAFILE__
	if (tell(mm_datafile) != mm_DiskOfs[id])
		lseek(mm_datafile,mm_DiskOfs[id],SEEK_SET);
	// potrei confidare nel fatto che siano allineate
	// le chiamate alla funzione... (ma non credo proprio)
	_read(mm_datafile,mm_BlockList[id].addr.ptr,size);
#endif
	return mm_BlockList[id].addr.ptr;
}
*/

int mm_alloc(word size) {
	int id;
	if ((id = mm_newblock())<0)
		error("mm_alloc","no rooms");
#ifdef __DATAFILE__
#ifdef __PACKED_BDF__
	if (!size) size = mm_BlkSize[id];
#else
	if (!size) size = (word)(mm_DiskOfs[id+1]-mm_DiskOfs[id]);
#endif
	else
#endif
	  size = (size+1) & 0xfffe;
	mm_BlockList[id].size = size;
#ifdef __DATAFILE__
	mm_BlockList[id].flag = BLF_DISK;
#else
	mm_BlockList[id].flag = 0;
	if (!(mm_BlockList[id].addr.ptr = new char[size]))
		if (!(mm_BlockList[id].addr.ptr = mm_wizard(size)))
			error("mm_alloc",err_notenoughmemory);
#ifdef __MAINCHECK__
	mm_mainmem += size;
#endif
#endif
	mm_allocvol += size;
	mm_memblocks++;
	return id;
}

/*
void mm_pass_alloc(word size) {
	lseek(mm_
}
*/
//#pragma warn +rvl

word mm_getblocksize(int id) {
	return mm_BlockList[id].size;
}

void far *mm_recall(int id) {
	if (id<0 || id>=mm_memblocks) error("Recall","ID out of range");

	void far *ptr;
	TBlock &Block = mm_BlockList[id];
	TXMSMoveStruct mvdata;
	int idx;
#ifdef __PACKED_BDF__
	void far *cmpptr;
	word cmpsize;
#endif

	//if (!mm_check()) error("Before Recall");
	if (Block.flag & BLF_UNREADY) {
		if ((ptr = mm_sysalloc(Block.size)) != NULL) {
#ifdef __MAINCHECK__
			mm_mainmem += Block.size;
#endif
#ifdef __DATAFILE__
			if (Block.flag & BLF_XMS) {
#endif
				//if (!(Block.flag & BLF_XMS)) error("Disk mapper error!");
				mvdata.size = Block.size;	// moves only used data
				mvdata.shandle = mm_xmshandle;
				mvdata.sptr = Block.addr;
				mvdata.dhandle = 0;
				mvdata.dptr.ptr = ptr;
				if (!XMSmove(&mvdata)) //error("mm_recall","move");

				if ((idx = mm_findxmsidx(id)) != -1)
				 if (mm_XMSList[idx].addr.ofs == Block.addr.ofs)
				 { asm {MOV AX,3;INT 0x10}
				  printf("Recall Error #%d (%lu = %p)",_BL,Block.addr.ofs,Block.addr.ptr);
				  exit(1);
				 } else error("Recall","Uncongruent data");
				else error("Recall","Data corrupt");

				Block.addr.ptr = ptr;
				Block.flag = 0;
				if ((idx = mm_findxmsidx(id)) != -1) {
					mm_xmsfree += mm_XMSList[idx].size;
					mm_allocfree -= Block.size;	// !!! duplicate !!!
					// Merges with the previous block if free
					if (idx>0 && mm_XMSList[idx-1].id == -1) {
						mm_XMSList[idx-1].size += mm_XMSList[idx].size;
							// It's forward !
						fdmove(&mm_XMSList[idx],&mm_XMSList[idx+1],
							   sizeof(TXMSBlock) * (--mm_xmsblocks - idx));
						idx--;
					} else mm_XMSList[idx].id = -1;
					// Merges with the successive block if free
					if (idx+1 < mm_xmsblocks && mm_XMSList[idx+1].id == -1) {
						mm_XMSList[idx].size += mm_XMSList[idx+1].size;
							// It's forward !
						fdmove(&mm_XMSList[idx+1],&mm_XMSList[idx+2],
							   sizeof(TXMSBlock) * (--mm_xmsblocks - idx-1));
					}
				} else error("mm_recall","no block");
#ifdef __DATAFILE__
			} else {
				Block.addr.ptr = ptr;
				Block.flag = 0;
				lseek(mm_datafile,mm_DiskOfs[id],SEEK_SET);
#ifdef __PACKED_BDF__
				//sound(500); delay(5); nosound();
				mm_lock(id);
				if ((cmpptr = mm_sysalloc(cmpsize = (word)(mm_DiskOfs[id+1]-mm_DiskOfs[id]))) == NULL) {
					/*
					mm_unlock(id);
					mm_swapblock(id);
					mm_recall(id);	// !!!!!!!!!!!!!!!!!
					mm_lock(id);
					*/
					if ((cmpptr = mm_sysalloc(cmpsize)) == NULL) {
						mm_unlock(id);
						Block.flag = BLF_DISK;
						delete ptr;
#ifdef __MAINCHECK__
						mm_mainmem -= Block.size;
#endif
						return NULL;
					}
						//error("mm_recall","can't unpack");
				}
				/*
				{
					doneL();
					printf("mm_recall - Can't unpack %d bytes into %d.",Block.size,cmpsize);
					exit(0);
				}
				*/
				_read(mm_datafile,cmpptr,cmpsize);
				decrypt(cmpptr,cmpsize);	// EEEeeeh, e che  ?!!!
				mm_uncompress(cmpptr,ptr,cmpsize);
				delete cmpptr;
				mm_unlock(id);
#else
				_read(mm_datafile,ptr,Block.size);
				decrypt(ptr,Block.size);
#endif
				mm_allocfree -= Block.size;
			  }
#endif
		} else return NULL;
	}
	//if (!mm_check()) error("After Recall");

	//mm_visualize();
	Block.flag |= BLF_USED;
	return Block.addr.ptr;
}

void mm_unload(int id) {
	TBlock &Block = mm_BlockList[id];
	if (!(Block.flag & BLF_UNREADY)) mm_swapblock(id);
}

byte mm_lock(int id) {
	TBlock &block = mm_BlockList[id];
	block.flag |= BLF_LOCKED;
	return ++block.lock;
}

byte mm_unlock(int id) {
	byte lckval;
	TBlock &block = mm_BlockList[id];
	if (!(lckval = --block.lock)) block.flag &= ~BLF_LOCKED;
	return lckval;
}

unsigned long mm_memavail() {
	return coreleft()+mm_xmsfree;
}

unsigned long mm_totalloc() {
	return mm_allocvol;
}

unsigned long mm_freealloc() {
	return mm_allocfree;
}

void mm_reset() {
if (++mm_resetcnt>MM_MAXRESETCNT) {
	mm_resetall();
	return;
}
// resets only conventional blocks
asm {
	MOV CX, mm_memblocks
	LDS SI, mm_BlockList
	ADD SI, 6		// !!!! indice di flag
	MOV BX, SIZE_B
	MOV AL, BLF_UNUSED
	// CLD  no LODS
} l1: asm {
	MOV DL, [SI]
	TEST DL, (BLF_XMS+BLF_DISK)
	JNZ goon
	AND DL, AL
	MOV [SI], DL
} goon: asm {
	ADD SI, BX
	LOOP l1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void mm_resetall() {
	mm_resetcnt = 0;
asm {
	MOV CX, mm_memblocks
	LDS SI, mm_BlockList
	ADD SI, 6		// !!!! indice di flag
	MOV BX, SIZE_B
	MOV AL, BLF_UNUSED
	// CLD  no LODS
} l1: asm {
	AND [SI], AL
	ADD SI, BX
	LOOP l1
	// !!! SS==DS !!!
	MOV AX, SS
	MOV DS, AX
}}

void mm_flushall() {
	mm_resetall();
	TBlock *Block;
	int id;
	for (id=0,Block=mm_BlockList;id<mm_memblocks;id++,Block++) {
		if (!(Block->flag & (BLF_UNREADY|BLF_LOCKED)))
			mm_swapblock(id);
	}
}

void mm_init() {
	word size, check;
	mm_resetcnt = 0;
#ifdef __DATAFILE__
	char id[9] = "........";
	if ((mm_datafile = _open(DATAFILENAME,O_RDONLY|O_BINARY)) != -1) {
		_read(mm_datafile,id,8);
		if (!fwcomp(id,(void *)&idBDF,8))
			error("mm_init",err_invalidformat);
		// Loads data addresses
		_read(mm_datafile,&mm_maxmemblocks,sizeof(mm_maxmemblocks));
		if (!(mm_DiskOfs = new long[mm_maxmemblocks+1])
#ifdef __PACKED_BDF__
			|| !(mm_BlkSize = new word[mm_maxmemblocks])
#endif
			)
			error("mm_init",err_notenoughmemory);
#ifdef __PACKED_BDF__
		_read(mm_datafile,mm_BlkSize,mm_maxmemblocks*sizeof(word));
#endif
		int i;
		long part = 0l,
#ifdef __PACKED_BDF__
			 totofs = 10l+(4l*mm_maxmemblocks);	// 8(ID)+2(maxblocks)+(2+2)*max...+sizes...
#else
			 totofs = 10l+(2l*mm_maxmemblocks);	// 8(ID)+2(maxblocks)+2*max...+sizes...
#endif
		for (i=0;i<mm_maxmemblocks;i++) {
			mm_DiskOfs[i]=totofs;
			_read(mm_datafile,&part,sizeof(word)); // int!!!
			totofs+=part;
		}
		mm_DiskOfs[i]=totofs;
	} else error("mm_init",err_filenotfound);
#endif
	if (!(mm_BlockList = new TBlock[mm_maxmemblocks]))
		error("mm_init",err_notenoughmemory);
	fdfill(mm_BlockList,0l,sizeof(TBlock)*mm_maxmemblocks);
	mm_memblocks = 0;
	mm_xmsblocks = 0;
	mm_xmshandle = 0;
	mm_allocvol  = 0;
	mm_allocfree = 0;	// !!! duplicate !!!!
#ifdef __MAINCHECK__
	mm_mainmem = 0;
#endif
	if (XMSinstalled()) {
		if (!(mm_XMSList = new TXMSBlock[MAXXMSBLOCKS]))
			error("mm_init",err_notenoughmemory);
		if ((size = XMSblockfree()) > 0) {
			if (size>MM_MAXALLOC) size = MM_MAXALLOC;
		} else size = MM_MAXALLOC;
		// ...so I steal & fuck it !
		if ((mm_xmshandle = XMSnew(size)) != 0 &&
			XMSgetsize(mm_xmshandle,check)) {
			if (check != size) size = check;
			mm_xmsfree = (long)size << 10;
			mm_XMSList[0].id = -1;
			mm_XMSList[0].addr.ofs = 0l;
			mm_XMSList[0].size = mm_xmsfree;
			mm_xmsblocks = 1;
			return;
		}
	}
	mm_xmsfree = 0;
}

void mm_done() {
	if (mm_xmshandle) {
		XMSdelete(mm_xmshandle);
		mm_xmshandle = 0;
#ifdef __DATAFILE__
		_close(mm_datafile);
#endif
		int i;
		TBlock *Block;
		for(i=0,Block=mm_BlockList;i<mm_memblocks;i++,Block++)
		 if (!(Block->flag & BLF_UNREADY))
			delete Block->addr.ptr;
	}
}

#ifdef __VISUALIZE__
void mm_visualize() {
	int i, j;
	void far *p;
	char far *vp = (char _seg *)0xA000+(char near *)0, far *app;
	char col;
	TBlock *Block = mm_BlockList;
	app = vp;
	//for (i=640;i--;) *(vp++)=0;
	vp = app += 320*168;
	for (i=mm_memblocks;i--;) *(vp++)=0;
	for (i=0;i<mm_memblocks;i++,Block++) {
	 if (!(Block->flag & BLF_UNREADY)) {
		p = Block->addr.ptr;
		asm {
			MOV AX, WORD PTR p
			MOV BX, WORD PTR p[2]
			SHR AX, 5
			SHR BX, 1
			ADD AX, BX
			MOV WORD PTR vp, AX  // !!!
		}
		if (Block->flag & BLF_LOCKED) col = 128; else
		 if (Block->flag & BLF_USED) col = 112; else col = 1;
		for (j=Block->size>>5;j--;) *(vp++) = col;
	 } else col=0;
	 if (Block->flag & BLF_XMS) /*col=118;*/ col = 96;
	 *(app+i) = col;
	}
}
#endif

/*
char mm_check() {
	int idx;
	TBlock *Block = mm_BlockList;
	for (int i=0; i<mm_memblocks; i++,Block++)
	 if ((Block->flag & BLF_XMS) && (idx=mm_findxmsidx(i))!=-1 &&
		 (Block->addr.ofs != mm_XMSList[idx].addr.ofs))
	   return 0;
	return 1;
}
*/

#ifdef __MAKEDATA__
#ifndef __DATAFILE__
void mm_makedatafile() {
	int datafile, i;
	//long filepos;
	TBlock *Block;
	void far *ptr;
#ifdef __PACKED_BDF__
	void far *cmpptr;
	word cmpsize;
#endif

	mm_resetall();

	if ((datafile = _creat(DATAFILENAME,0x20/*FA_ARCH*/)) >= 0) {
		_write(datafile,&idBDF,8);
		_write(datafile,&mm_memblocks,sizeof(mm_memblocks));
		//filepos = 8l+sizeof(mm_memblocks)+(((long)mm_memblocks+1)*sizeof(long));
		/*
		for (i=0,Block=mm_BlockList;i<mm_memblocks;i++,Block++) {
			_write(datafile,&filepos,sizeof(long));
			filepos += Block->size;
		}
		_write(datafile,&filepos,sizeof(long));
		*/
		for (i=0,Block=mm_BlockList;i<mm_memblocks;i++,Block++)
			_write(datafile,&Block->size,sizeof(word));
#ifdef __PACKED_BDF__
		_write(datafile,mm_BlockList,mm_memblocks*sizeof(word));
		// Warning! Ho solo lasciato lo spazio! La scrittura vera avverr
		// in seguito...
#endif
		for (i=0,Block=mm_BlockList;i<mm_memblocks;i++,Block++)
			if ((ptr = mm_recall(i)) != NULL) {
#ifdef __PACKED_BDF__
				mm_lock(i);
				if ((cmpptr = mm_sysalloc(Block->size<<1)) == NULL) // double size (!)
					error("mm_makedatafile","can't pack");

				cmpsize = mm_compress(ptr,cmpptr,Block->size);
				lseek(datafile,8l+sizeof(mm_memblocks)+
								mm_memblocks*sizeof(word)+(i<<1),SEEK_SET);
				_write(datafile,&cmpsize,sizeof(word));
				lseek(datafile,0,SEEK_END);	// aggiunge
				encrypt(cmpptr,cmpsize);	// EEEEeeeeeh, e che  ?!!!
				_write(datafile,cmpptr,cmpsize);
				delete cmpptr;
				mm_unlock(i);
#else
				encrypt(ptr,Block->size);
				_write(datafile,ptr,Block->size);
				decrypt(ptr,Block->size);
#endif
			} else error("mm_makedatafile","can't recall");
		_close(datafile);
	} else error("mm_makedatafile","can't create");
}
#endif
#endif
// !!!
#pragma exit mm_done 64
