pkgname=docbook-xsl
pkgver=1.79.2
pkgdir=$PWD/../build
srcdir=$PWD

cd $pkgname-$pkgver
patch -Np2 -i ../765567_non-recursive_string_subst.patch

cd ../$pkgname-nons-$pkgver
patch -Np2 -i ../765567_non-recursive_string_subst.patch
cd ..

for ns in -nons ''; do
  pkgroot="$pkgdir/usr/share/xml/docbook/xsl-stylesheets-$pkgver$ns"
  dir=$pkgname$ns-$pkgver

  install -Dt "$pkgroot" -m644 $dir/VERSION{,.xsl}

  (
    shopt -s nullglob  # ignore missing files
    for fn in assembly common eclipse epub epub3 fo highlighting html \
      htmlhelp javahelp lib manpages params profiling roundtrip template \
      website xhtml xhtml-1_1 xhtml5
    do
      install -Dt "$pkgroot/$fn" -m644 $dir/$fn/*.{xml,xsl,dtd,ent}
    done
  )
done

install -d "$pkgdir/etc/xml"
install -Dt "$pkgdir/usr/share/licenses/$pkgname" -m644 $dir/COPYING

cp /etc/xml/docbook-xml ${pkgdir}/etc/xml/docbook-xsl

new=1.79.2

for ver in $new current; do
  for x in rewriteSystem rewriteURI; do
    xmlcatalog --noout --add $x http://cdn.docbook.org/release/xsl/$ver \
      /usr/share/xml/docbook/xsl-stylesheets-$new \
      ${pkgdir}/etc/xml/docbook-xsl

    xmlcatalog --noout --add $x http://cdn.docbook.org/release/xsl-nons/$ver \
      /usr/share/xml/docbook/xsl-stylesheets-$new-nons \
      ${pkgdir}/etc/xml/docbook-xsl

    xmlcatalog --noout --add $x http://docbook.sourceforge.net/release/xsl-ns/$ver \
      /usr/share/xml/docbook/xsl-stylesheets-$new \
      ${pkgdir}/etc/xml/docbook-xsl

    xmlcatalog --noout --add $x http://docbook.sourceforge.net/release/xsl/$ver \
      /usr/share/xml/docbook/xsl-stylesheets-$new-nons \
      ${pkgdir}/etc/xml/docbook-xsl
  done
done

cp "${pkgdir}/etc/xml/docbook-xsl" "${pkgdir}/etc/xml/catalog"
