# Borrowing from Arch Linux
pkgver=10.3.0
_islver=0.21
pkgdir=$PWD/../build
srcdir=$PWD 

# using -pipe causes spurious test-suite failures
# http://gcc.gnu.org/bugzilla/show_bug.cgi?id=48565
CFLAGS=${CFLAGS/-pipe/}
CXXFLAGS=${CXXFLAGS/-pipe/}

cd gcc-${pkgver}

# link isl for in-tree build
ln -s ../isl-${_islver} isl

# Do not run fixincludes
sed -i 's@\./fixinc\.sh@-c true@' gcc/Makefile.in

# Arch Linux installs x86_64 libraries /lib (and so do we)
sed -i '/m64=/s/lib64/lib/' gcc/config/i386/t-linux64

# hack! - some configure tests for header files using "$CPP $CPPFLAGS"
sed -i "/ac_cpp=/s/\$CPPFLAGS/\$CPPFLAGS -O2/" {libiberty,gcc}/configure

# Turn off SSP for nostdlib|nodefaultlibs|ffreestanding
# https://bugs.archlinux.org/task/64270
patch -p1 -i "$srcdir/fs64270.patch"

# Fix a crash in mpv when mesa 20.2 is compiled with LTO
# https://gitlab.freedesktop.org/mesa/mesa/-/issues/3239
# https://gcc.gnu.org/bugzilla/show_bug.cgi?id=96482
patch -Np1 -i ../ipa-fix-bit-CPP-when-combined-with-IPA-bit-CP.patch
patch -Np1 -i ../ipa-fix-ICE-in-get_default_value.patch

cd ..

mkdir gcc-obj -p
cd gcc-obj
../gcc-${pkgver}/configure \
  --prefix=/usr \
  --libdir=/usr/lib \
  --libexecdir=/usr/lib \
  --mandir=/usr/share/man \
  --infodir=/usr/share/info \
  --with-bugurl=https://bugs.archlinux.org/ \
  --enable-languages=c,c++,lto \
  --with-isl \
  --with-linker-hash-style=gnu \
  --with-system-zlib \
  --enable-__cxa_atexit \
  --enable-cet=auto \
  --enable-checking=release \
  --enable-clocale=gnu \
  --enable-default-pie \
  --enable-default-ssp \
  --enable-gnu-indirect-function \
  --enable-gnu-unique-object \
  --enable-install-libiberty \
  --enable-linker-build-id \
  --enable-lto \
  --disable-multilib \
  --enable-plugin \
  --enable-shared \
  --enable-threads=posix \
  --disable-libssp \
  --disable-libstdcxx-pch \
  --disable-libunwind-exceptions \
  --disable-werror
DESTDIR=${pkgdir} make          -j4 || exit -1
DESTDIR=${pkgdir} make -k check -j4 || true
DESTDIR=${pkgdir} make install  -j4 || exit -1

# Separate g++ package and leave only gcc as the core install
cd ../../build
mkdir -p g++
mkdir -p g++/bin
ln -s ../usr/include g++/include
ln -s ../usr/lib g++/lib

# Create g++ path for g++ specific stuff
mv usr/bin/g++ g++/bin
mv usr/bin/c++ g++/bin
mv usr/bin/cpp g++/bin
mv usr/bin/x86_64-pc-linux-gnu-g++ g++/bin
mv usr/bin/x86_64-pc-linux-gnu-c++ g++/bin

# libstdc++.so
mkdir -p stdc++
mv usr/lib/libstdc++* stdc++/.
