// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: info.c,v 1.2 2000-08-12 21:29:25 fraggle Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// DESCRIPTION:
//  Thing frame/state LUT,
//  generated by multigen utilitiy.
//  This one is the original DOOM version, preserved.
//  BOOM changes include commenting and addition of predefined lumps
//  for providing things that aren't in the IWAD without sending a
//  separate must-use wad file around with the EXE.
//
//-----------------------------------------------------------------------------

static const char
rcsid[] = "$Id: info.c,v 1.2 2000-08-12 21:29:25 fraggle Exp $";

#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "doomdef.h"
#include "sounds.h"
#include "m_fixed.h"
#include "p_mobj.h"
#include "w_wad.h"
#include "info.h"


// ********************************************************************
// Sprite names
// ********************************************************************
// This is the list of sprite 4-character prefixes.  They are searched
// through, with a NULL entry terminating the list.  In DOOM originally
// this NULL entry was missing, and coincidentally the next thing in
// memory was the dummy state_t[] entry that started with zero bytes.
// killough 1/17/98: add an explicit NULL entry.
// NUMSPRITES is an enum from info.h where all these are listed
// as SPR_xxxx

char *sprnames[NUMSPRITES+1] = {
  "TROO","SHTG","PUNG","PISG","PISF","SHTF","SHT2","CHGG","CHGF","MISG",
  "MISF","SAWG","PLSG","PLSF","BFGG","BFGF","BLUD","PUFF","BAL1","BAL2",
  "PLSS","PLSE","MISL","BFS1","BFE1","BFE2","TFOG","IFOG","PLAY","POSS",
  "SPOS","VILE","FIRE","FATB","FBXP","SKEL","MANF","FATT","CPOS","SARG",
  "HEAD","BAL7","BOSS","BOS2","SKUL","SPID","BSPI","APLS","APBX","CYBR",
  "PAIN","SSWV","KEEN","BBRN","BOSF","ARM1","ARM2","BAR1","BEXP","FCAN",
  "BON1","BON2","BKEY","RKEY","YKEY","BSKU","RSKU","YSKU","STIM","MEDI",
  "SOUL","PINV","PSTR","PINS","MEGA","SUIT","PMAP","PVIS","CLIP","AMMO",
  "ROCK","BROK","CELL","CELP","SHEL","SBOX","BPAK","BFUG","MGUN","CSAW",
  "LAUN","PLAS","SHOT","SGN2","COLU","SMT2","GOR1","POL2","POL5","POL4",
  "POL3","POL1","POL6","GOR2","GOR3","GOR4","GOR5","SMIT","COL1","COL2",
  "COL3","COL4","CAND","CBRA","COL6","TRE1","TRE2","ELEC","CEYE","FSKU",
  "COL5","TBLU","TGRN","TRED","SMBT","SMGT","SMRT","HDB1","HDB2","HDB3",
  "HDB4","HDB5","HDB6","POB1","POB2","BRS1","TLMP","TLP2",
  "TNT1", // invisible sprite                                 phares 3/9/98

#ifdef DOGS
  "DOGS", // killough 7/19/98: Marine's best friend :)
#endif

#ifdef BETA
  "PLS1", // killough 7/19/98: first  of two plasma fireballs in the beta
  "PLS2", // killough 7/19/98: second of two plasma fireballs in the beta
  "BON3", // killough 7/11/98: evil sceptre in the beta version
  "BON4", // killough 7/11/98: unholy bible in the beta version
#endif

  NULL
};

// ********************************************************************
// Function addresses or Code Pointers
// ********************************************************************
// These function addresses are the Code Pointers that have been
// modified for years by Dehacked enthusiasts.  The new BEX format
// allows more extensive changes (see d_deh.c)

// Doesn't work with g++, needs actionf_p1
void A_Light0();
void A_WeaponReady();
void A_Lower();
void A_Raise();
void A_Punch();
void A_ReFire();
void A_FirePistol();
void A_Light1();
void A_FireShotgun();
void A_Light2();
void A_FireShotgun2();
void A_CheckReload();
void A_OpenShotgun2();
void A_LoadShotgun2();
void A_CloseShotgun2();
void A_FireCGun();
void A_GunFlash();
void A_FireMissile();
void A_Saw();
void A_FirePlasma();
void A_BFGsound();
void A_FireBFG();
void A_BFGSpray();
void A_Explode();
void A_Pain();
void A_PlayerScream();
void A_Fall();
void A_Stop();
void A_XScream();
void A_Look();
void A_Chase();
void A_FaceTarget();
void A_PosAttack();
void A_Scream();
void A_Die();
void A_SPosAttack();
void A_VileChase();
void A_VileStart();
void A_VileTarget();
void A_VileAttack();
void A_StartFire();
void A_Fire();
void A_FireCrackle();
void A_Tracer();
void A_SkelWhoosh();
void A_SkelFist();
void A_SkelMissile();
void A_FatRaise();
void A_FatAttack1();
void A_FatAttack2();
void A_FatAttack3();
void A_BossDeath();
void A_CPosAttack();
void A_CPosRefire();
void A_TroopAttack();
void A_SargAttack();
void A_HeadAttack();
void A_BruisAttack();
void A_SkullAttack();
void A_Metal();
void A_SpidRefire();
void A_BabyMetal();
void A_BspiAttack();
void A_Hoof();
void A_CyberAttack();
void A_PainAttack();
void A_PainDie();
void A_KeenDie();
void A_BrainPain();
void A_BrainScream();
void A_BrainDie();
void A_BrainAwake();
void A_BrainSpit();
void A_SpawnSound();
void A_SpawnFly();
void A_BrainExplode();
void A_FireOldBFG();      // killough 7/19/98: classic BFG firing function
void A_Detonate();        // killough 8/9/98: detonate a bomb or other device
void A_Mushroom();        // killough 10/98: mushroom effect
void A_BetaSkullAttack(); // killough 10/98: beta lost souls attacked different

// ********************************************************************
// State or "frame" information
// ********************************************************************
// Each of the states, otherwise known as "frames", is outlined
// here.  The data in each element of the array is the way it is
// initialized, with sprite names identified by their enumerator
// value such as SPR_SHTG.  These correlate to the above sprite
// array so don't change them around unless you understand what
// you're doing.
//
// The commented name beginning with S_ at the end of each line
// is there to help figure out where the next-frame pointer is
// pointing.  These are also additionally identified in info.h
// as enumerated values.  From a change-and-recompile point of
// view this is fairly workable, but it adds a lot to the effort
// when trying to change things externally.  See also the d_deh.c
// parts where frame rewiring is done for more details and the
// extended way a BEX file can handle this.
//
// killough 11/98: cleaned up, since we don't need to accomodate C++

state_t states[NUMSTATES] = {
  {SPR_TROO,0,-1,NULL,S_NULL},  // S_NULL
  {SPR_SHTG,4,0,A_Light0,S_NULL}, // S_LIGHTDONE
  {SPR_PUNG,0,1,A_WeaponReady,S_PUNCH}, // S_PUNCH
  {SPR_PUNG,0,1,A_Lower,S_PUNCHDOWN}, // S_PUNCHDOWN
  {SPR_PUNG,0,1,A_Raise,S_PUNCHUP}, // S_PUNCHUP
  {SPR_PUNG,1,4,NULL,S_PUNCH2},   // S_PUNCH1
  {SPR_PUNG,2,4,A_Punch,S_PUNCH3},  // S_PUNCH2
  {SPR_PUNG,3,5,NULL,S_PUNCH4},   // S_PUNCH3
  {SPR_PUNG,2,4,NULL,S_PUNCH5},   // S_PUNCH4
  {SPR_PUNG,1,5,A_ReFire,S_PUNCH},  // S_PUNCH5
  {SPR_PISG,0,1,A_WeaponReady,S_PISTOL},// S_PISTOL
  {SPR_PISG,0,1,A_Lower,S_PISTOLDOWN},  // S_PISTOLDOWN
  {SPR_PISG,0,1,A_Raise,S_PISTOLUP},  // S_PISTOLUP
  {SPR_PISG,0,4,NULL,S_PISTOL2},  // S_PISTOL1
  {SPR_PISG,1,6,A_FirePistol,S_PISTOL3},// S_PISTOL2
  {SPR_PISG,2,4,NULL,S_PISTOL4},  // S_PISTOL3
  {SPR_PISG,1,5,A_ReFire,S_PISTOL}, // S_PISTOL4
  {SPR_PISF,32768,7,A_Light1,S_LIGHTDONE},  // S_PISTOLFLASH
  {SPR_SHTG,0,1,A_WeaponReady,S_SGUN},  // S_SGUN
  {SPR_SHTG,0,1,A_Lower,S_SGUNDOWN},  // S_SGUNDOWN
  {SPR_SHTG,0,1,A_Raise,S_SGUNUP},  // S_SGUNUP
  {SPR_SHTG,0,3,NULL,S_SGUN2},  // S_SGUN1
  {SPR_SHTG,0,7,A_FireShotgun,S_SGUN3}, // S_SGUN2
  {SPR_SHTG,1,5,NULL,S_SGUN4},  // S_SGUN3
  {SPR_SHTG,2,5,NULL,S_SGUN5},  // S_SGUN4
  {SPR_SHTG,3,4,NULL,S_SGUN6},  // S_SGUN5
  {SPR_SHTG,2,5,NULL,S_SGUN7},  // S_SGUN6
  {SPR_SHTG,1,5,NULL,S_SGUN8},  // S_SGUN7
  {SPR_SHTG,0,3,NULL,S_SGUN9},  // S_SGUN8
  {SPR_SHTG,0,7,A_ReFire,S_SGUN}, // S_SGUN9
  {SPR_SHTF,32768,4,A_Light1,S_SGUNFLASH2}, // S_SGUNFLASH1
  {SPR_SHTF,32769,3,A_Light2,S_LIGHTDONE},  // S_SGUNFLASH2
  {SPR_SHT2,0,1,A_WeaponReady,S_DSGUN}, // S_DSGUN
  {SPR_SHT2,0,1,A_Lower,S_DSGUNDOWN}, // S_DSGUNDOWN
  {SPR_SHT2,0,1,A_Raise,S_DSGUNUP}, // S_DSGUNUP
  {SPR_SHT2,0,3,NULL,S_DSGUN2}, // S_DSGUN1

  // killough 9/5/98: make SSG lighting flash more uniform along super shotgun:

  {SPR_SHT2, 32768 /* killough */,7,A_FireShotgun2,S_DSGUN3}, // S_DSGUN2
  {SPR_SHT2,1,7,NULL,S_DSGUN4}, // S_DSGUN3
  {SPR_SHT2,2,7,A_CheckReload,S_DSGUN5},  // S_DSGUN4
  {SPR_SHT2,3,7,A_OpenShotgun2,S_DSGUN6}, // S_DSGUN5
  {SPR_SHT2,4,7,NULL,S_DSGUN7}, // S_DSGUN6
  {SPR_SHT2,5,7,A_LoadShotgun2,S_DSGUN8}, // S_DSGUN7
  {SPR_SHT2,6,6,NULL,S_DSGUN9}, // S_DSGUN8
  {SPR_SHT2,7,6,A_CloseShotgun2,S_DSGUN10}, // S_DSGUN9
  {SPR_SHT2,0,5,A_ReFire,S_DSGUN},  // S_DSGUN10
  {SPR_SHT2,1,7,NULL,S_DSNR2},  // S_DSNR1
  {SPR_SHT2,0,3,NULL,S_DSGUNDOWN},  // S_DSNR2

  // killough 8/20/98: reduce first SSG flash frame one tic, to fix
  // Doom II SSG flash bug, in which SSG raises before flash finishes

  {SPR_SHT2,32776,4/*killough*/,A_Light1,S_DSGUNFLASH2}, // S_DSGUNFLASH1
  {SPR_SHT2,32777,4,A_Light2,S_LIGHTDONE},  // S_DSGUNFLASH2
  {SPR_CHGG,0,1,A_WeaponReady,S_CHAIN}, // S_CHAIN
  {SPR_CHGG,0,1,A_Lower,S_CHAINDOWN}, // S_CHAINDOWN
  {SPR_CHGG,0,1,A_Raise,S_CHAINUP}, // S_CHAINUP
  {SPR_CHGG,0,4,A_FireCGun,S_CHAIN2}, // S_CHAIN1
  {SPR_CHGG,1,4,A_FireCGun,S_CHAIN3}, // S_CHAIN2
  {SPR_CHGG,1,0,A_ReFire,S_CHAIN},  // S_CHAIN3
  {SPR_CHGF,32768,5,A_Light1,S_LIGHTDONE},  // S_CHAINFLASH1
  {SPR_CHGF,32769,5,A_Light2,S_LIGHTDONE},  // S_CHAINFLASH2
  {SPR_MISG,0,1,A_WeaponReady,S_MISSILE}, // S_MISSILE
  {SPR_MISG,0,1,A_Lower,S_MISSILEDOWN}, // S_MISSILEDOWN
  {SPR_MISG,0,1,A_Raise,S_MISSILEUP}, // S_MISSILEUP
  {SPR_MISG,1,8,A_GunFlash,S_MISSILE2}, // S_MISSILE1
  {SPR_MISG,1,12,A_FireMissile,S_MISSILE3}, // S_MISSILE2
  {SPR_MISG,1,0,A_ReFire,S_MISSILE},  // S_MISSILE3
  {SPR_MISF,32768,3,A_Light1,S_MISSILEFLASH2},  // S_MISSILEFLASH1
  {SPR_MISF,32769,4,NULL,S_MISSILEFLASH3},  // S_MISSILEFLASH2
  {SPR_MISF,32770,4,A_Light2,S_MISSILEFLASH4},  // S_MISSILEFLASH3
  {SPR_MISF,32771,4,A_Light2,S_LIGHTDONE},  // S_MISSILEFLASH4
  {SPR_SAWG,2,4,A_WeaponReady,S_SAWB},  // S_SAW
  {SPR_SAWG,3,4,A_WeaponReady,S_SAW}, // S_SAWB
  {SPR_SAWG,2,1,A_Lower,S_SAWDOWN}, // S_SAWDOWN
  {SPR_SAWG,2,1,A_Raise,S_SAWUP}, // S_SAWUP
  {SPR_SAWG,0,4,A_Saw,S_SAW2}, // S_SAW1
  {SPR_SAWG,1,4,A_Saw,S_SAW3},  // S_SAW2
  {SPR_SAWG,1,0,A_ReFire,S_SAW},  // S_SAW3
  {SPR_PLSG,0,1,A_WeaponReady,S_PLASMA},  // S_PLASMA
  {SPR_PLSG,0,1,A_Lower,S_PLASMADOWN},  // S_PLASMADOWN
  {SPR_PLSG,0,1,A_Raise,S_PLASMAUP},  // S_PLASMAUP
  {SPR_PLSG,0,3,A_FirePlasma,S_PLASMA2},  // S_PLASMA1
  {SPR_PLSG,1,20,A_ReFire,S_PLASMA},  // S_PLASMA2
  {SPR_PLSF,32768,4,A_Light1,S_LIGHTDONE},  // S_PLASMAFLASH1
  {SPR_PLSF,32769,4,A_Light1,S_LIGHTDONE},  // S_PLASMAFLASH2
  {SPR_BFGG,0,1,A_WeaponReady,S_BFG}, // S_BFG
  {SPR_BFGG,0,1,A_Lower,S_BFGDOWN}, // S_BFGDOWN
  {SPR_BFGG,0,1,A_Raise,S_BFGUP}, // S_BFGUP
  {SPR_BFGG,0,20,A_BFGsound,S_BFG2},  // S_BFG1
  {SPR_BFGG,1,10,A_GunFlash,S_BFG3},  // S_BFG2
  {SPR_BFGG,1,10,A_FireBFG,S_BFG4}, // S_BFG3
  {SPR_BFGG,1,20,A_ReFire,S_BFG}, // S_BFG4
  {SPR_BFGF,32768,11,A_Light1,S_BFGFLASH2}, // S_BFGFLASH1
  {SPR_BFGF,32769,6,A_Light2,S_LIGHTDONE},  // S_BFGFLASH2
  {SPR_BLUD,2,8,NULL,S_BLOOD2}, // S_BLOOD1
  {SPR_BLUD,1,8,NULL,S_BLOOD3}, // S_BLOOD2
  {SPR_BLUD,0,8,NULL,S_NULL}, // S_BLOOD3
  {SPR_PUFF,32768,4,NULL,S_PUFF2},  // S_PUFF1
  {SPR_PUFF,1,4,NULL,S_PUFF3},  // S_PUFF2
  {SPR_PUFF,2,4,NULL,S_PUFF4},  // S_PUFF3
  {SPR_PUFF,3,4,NULL,S_NULL}, // S_PUFF4
  {SPR_BAL1,32768,4,NULL,S_TBALL2}, // S_TBALL1
  {SPR_BAL1,32769,4,NULL,S_TBALL1}, // S_TBALL2
  {SPR_BAL1,32770,6,NULL,S_TBALLX2},  // S_TBALLX1
  {SPR_BAL1,32771,6,NULL,S_TBALLX3},  // S_TBALLX2
  {SPR_BAL1,32772,6,NULL,S_NULL}, // S_TBALLX3
  {SPR_BAL2,32768,4,NULL,S_RBALL2}, // S_RBALL1
  {SPR_BAL2,32769,4,NULL,S_RBALL1}, // S_RBALL2
  {SPR_BAL2,32770,6,NULL,S_RBALLX2},  // S_RBALLX1
  {SPR_BAL2,32771,6,NULL,S_RBALLX3},  // S_RBALLX2
  {SPR_BAL2,32772,6,NULL,S_NULL}, // S_RBALLX3
  {SPR_PLSS,32768,6,NULL,S_PLASBALL2},  // S_PLASBALL
  {SPR_PLSS,32769,6,NULL,S_PLASBALL}, // S_PLASBALL2
  {SPR_PLSE,32768,4,NULL,S_PLASEXP2}, // S_PLASEXP
  {SPR_PLSE,32769,4,NULL,S_PLASEXP3}, // S_PLASEXP2
  {SPR_PLSE,32770,4,NULL,S_PLASEXP4}, // S_PLASEXP3
  {SPR_PLSE,32771,4,NULL,S_PLASEXP5}, // S_PLASEXP4
  {SPR_PLSE,32772,4,NULL,S_NULL}, // S_PLASEXP5
  {SPR_MISL,32768,1,NULL,S_ROCKET}, // S_ROCKET
  {SPR_BFS1,32768,4,NULL,S_BFGSHOT2}, // S_BFGSHOT
  {SPR_BFS1,32769,4,NULL,S_BFGSHOT},  // S_BFGSHOT2
  {SPR_BFE1,32768,8,NULL,S_BFGLAND2}, // S_BFGLAND
  {SPR_BFE1,32769,8,NULL,S_BFGLAND3}, // S_BFGLAND2
  {SPR_BFE1,32770,8,A_BFGSpray,S_BFGLAND4}, // S_BFGLAND3
  {SPR_BFE1,32771,8,NULL,S_BFGLAND5}, // S_BFGLAND4
  {SPR_BFE1,32772,8,NULL,S_BFGLAND6}, // S_BFGLAND5
  {SPR_BFE1,32773,8,NULL,S_NULL}, // S_BFGLAND6
  {SPR_BFE2,32768,8,NULL,S_BFGEXP2},  // S_BFGEXP
  {SPR_BFE2,32769,8,NULL,S_BFGEXP3},  // S_BFGEXP2
  {SPR_BFE2,32770,8,NULL,S_BFGEXP4},  // S_BFGEXP3
  {SPR_BFE2,32771,8,NULL,S_NULL}, // S_BFGEXP4
  {SPR_MISL,32769,8,A_Explode,S_EXPLODE2},  // S_EXPLODE1
  {SPR_MISL,32770,6,NULL,S_EXPLODE3}, // S_EXPLODE2
  {SPR_MISL,32771,4,NULL,S_NULL}, // S_EXPLODE3
  {SPR_TFOG,32768,6,NULL,S_TFOG01}, // S_TFOG
  {SPR_TFOG,32769,6,NULL,S_TFOG02}, // S_TFOG01
  {SPR_TFOG,32768,6,NULL,S_TFOG2},  // S_TFOG02
  {SPR_TFOG,32769,6,NULL,S_TFOG3},  // S_TFOG2
  {SPR_TFOG,32770,6,NULL,S_TFOG4},  // S_TFOG3
  {SPR_TFOG,32771,6,NULL,S_TFOG5},  // S_TFOG4
  {SPR_TFOG,32772,6,NULL,S_TFOG6},  // S_TFOG5
  {SPR_TFOG,32773,6,NULL,S_TFOG7},  // S_TFOG6
  {SPR_TFOG,32774,6,NULL,S_TFOG8},  // S_TFOG7
  {SPR_TFOG,32775,6,NULL,S_TFOG9},  // S_TFOG8
  {SPR_TFOG,32776,6,NULL,S_TFOG10}, // S_TFOG9
  {SPR_TFOG,32777,6,NULL,S_NULL}, // S_TFOG10
  {SPR_IFOG,32768,6,NULL,S_IFOG01}, // S_IFOG
  {SPR_IFOG,32769,6,NULL,S_IFOG02}, // S_IFOG01
  {SPR_IFOG,32768,6,NULL,S_IFOG2},  // S_IFOG02
  {SPR_IFOG,32769,6,NULL,S_IFOG3},  // S_IFOG2
  {SPR_IFOG,32770,6,NULL,S_IFOG4},  // S_IFOG3
  {SPR_IFOG,32771,6,NULL,S_IFOG5},  // S_IFOG4
  {SPR_IFOG,32772,6,NULL,S_NULL}, // S_IFOG5
  {SPR_PLAY,0,-1,NULL,S_NULL},  // S_PLAY
  {SPR_PLAY,0,4,NULL,S_PLAY_RUN2},  // S_PLAY_RUN1
  {SPR_PLAY,1,4,NULL,S_PLAY_RUN3},  // S_PLAY_RUN2
  {SPR_PLAY,2,4,NULL,S_PLAY_RUN4},  // S_PLAY_RUN3
  {SPR_PLAY,3,4,NULL,S_PLAY_RUN1},  // S_PLAY_RUN4
  {SPR_PLAY,4,12,NULL,S_PLAY},  // S_PLAY_ATK1
  {SPR_PLAY,32773,6,NULL,S_PLAY_ATK1},  // S_PLAY_ATK2
  {SPR_PLAY,6,4,NULL,S_PLAY_PAIN2}, // S_PLAY_PAIN
  {SPR_PLAY,6,4,A_Pain,S_PLAY}, // S_PLAY_PAIN2
  {SPR_PLAY,7,10,NULL,S_PLAY_DIE2}, // S_PLAY_DIE1
  {SPR_PLAY,8,10,A_PlayerScream,S_PLAY_DIE3}, // S_PLAY_DIE2
  {SPR_PLAY,9,10,A_Fall,S_PLAY_DIE4}, // S_PLAY_DIE3
  {SPR_PLAY,10,10,NULL,S_PLAY_DIE5},  // S_PLAY_DIE4
  {SPR_PLAY,11,10,NULL,S_PLAY_DIE6},  // S_PLAY_DIE5
  {SPR_PLAY,12,10,NULL,S_PLAY_DIE7},  // S_PLAY_DIE6
  {SPR_PLAY,13,-1,NULL,S_NULL}, // S_PLAY_DIE7
  {SPR_PLAY,14,5,NULL,S_PLAY_XDIE2},  // S_PLAY_XDIE1
  {SPR_PLAY,15,5,A_XScream,S_PLAY_XDIE3}, // S_PLAY_XDIE2
  {SPR_PLAY,16,5,A_Fall,S_PLAY_XDIE4},  // S_PLAY_XDIE3
  {SPR_PLAY,17,5,NULL,S_PLAY_XDIE5},  // S_PLAY_XDIE4
  {SPR_PLAY,18,5,NULL,S_PLAY_XDIE6},  // S_PLAY_XDIE5
  {SPR_PLAY,19,5,NULL,S_PLAY_XDIE7},  // S_PLAY_XDIE6
  {SPR_PLAY,20,5,NULL,S_PLAY_XDIE8},  // S_PLAY_XDIE7
  {SPR_PLAY,21,5,NULL,S_PLAY_XDIE9},  // S_PLAY_XDIE8
  {SPR_PLAY,22,-1,NULL,S_NULL}, // S_PLAY_XDIE9
  {SPR_POSS,0,10,A_Look,S_POSS_STND2},  // S_POSS_STND
  {SPR_POSS,1,10,A_Look,S_POSS_STND}, // S_POSS_STND2
  {SPR_POSS,0,4,A_Chase,S_POSS_RUN2}, // S_POSS_RUN1
  {SPR_POSS,0,4,A_Chase,S_POSS_RUN3}, // S_POSS_RUN2
  {SPR_POSS,1,4,A_Chase,S_POSS_RUN4}, // S_POSS_RUN3
  {SPR_POSS,1,4,A_Chase,S_POSS_RUN5}, // S_POSS_RUN4
  {SPR_POSS,2,4,A_Chase,S_POSS_RUN6}, // S_POSS_RUN5
  {SPR_POSS,2,4,A_Chase,S_POSS_RUN7}, // S_POSS_RUN6
  {SPR_POSS,3,4,A_Chase,S_POSS_RUN8}, // S_POSS_RUN7
  {SPR_POSS,3,4,A_Chase,S_POSS_RUN1}, // S_POSS_RUN8
  {SPR_POSS,4,10,A_FaceTarget,S_POSS_ATK2}, // S_POSS_ATK1
  {SPR_POSS,5,8,A_PosAttack,S_POSS_ATK3}, // S_POSS_ATK2
  {SPR_POSS,4,8,NULL,S_POSS_RUN1},  // S_POSS_ATK3
  {SPR_POSS,6,3,NULL,S_POSS_PAIN2}, // S_POSS_PAIN
  {SPR_POSS,6,3,A_Pain,S_POSS_RUN1},  // S_POSS_PAIN2
  {SPR_POSS,7,5,NULL,S_POSS_DIE2},  // S_POSS_DIE1
  {SPR_POSS,8,5,A_Scream,S_POSS_DIE3},  // S_POSS_DIE2
  {SPR_POSS,9,5,A_Fall,S_POSS_DIE4},  // S_POSS_DIE3
  {SPR_POSS,10,5,NULL,S_POSS_DIE5}, // S_POSS_DIE4
  {SPR_POSS,11,-1,NULL,S_NULL}, // S_POSS_DIE5
  {SPR_POSS,12,5,NULL,S_POSS_XDIE2},  // S_POSS_XDIE1
  {SPR_POSS,13,5,A_XScream,S_POSS_XDIE3}, // S_POSS_XDIE2
  {SPR_POSS,14,5,A_Fall,S_POSS_XDIE4},  // S_POSS_XDIE3
  {SPR_POSS,15,5,NULL,S_POSS_XDIE5},  // S_POSS_XDIE4
  {SPR_POSS,16,5,NULL,S_POSS_XDIE6},  // S_POSS_XDIE5
  {SPR_POSS,17,5,NULL,S_POSS_XDIE7},  // S_POSS_XDIE6
  {SPR_POSS,18,5,NULL,S_POSS_XDIE8},  // S_POSS_XDIE7
  {SPR_POSS,19,5,NULL,S_POSS_XDIE9},  // S_POSS_XDIE8
  {SPR_POSS,20,-1,NULL,S_NULL}, // S_POSS_XDIE9
  {SPR_POSS,10,5,NULL,S_POSS_RAISE2}, // S_POSS_RAISE1
  {SPR_POSS,9,5,NULL,S_POSS_RAISE3},  // S_POSS_RAISE2
  {SPR_POSS,8,5,NULL,S_POSS_RAISE4},  // S_POSS_RAISE3
  {SPR_POSS,7,5,NULL,S_POSS_RUN1},  // S_POSS_RAISE4
  {SPR_SPOS,0,10,A_Look,S_SPOS_STND2},  // S_SPOS_STND
  {SPR_SPOS,1,10,A_Look,S_SPOS_STND}, // S_SPOS_STND2
  {SPR_SPOS,0,3,A_Chase,S_SPOS_RUN2}, // S_SPOS_RUN1
  {SPR_SPOS,0,3,A_Chase,S_SPOS_RUN3}, // S_SPOS_RUN2
  {SPR_SPOS,1,3,A_Chase,S_SPOS_RUN4}, // S_SPOS_RUN3
  {SPR_SPOS,1,3,A_Chase,S_SPOS_RUN5}, // S_SPOS_RUN4
  {SPR_SPOS,2,3,A_Chase,S_SPOS_RUN6}, // S_SPOS_RUN5
  {SPR_SPOS,2,3,A_Chase,S_SPOS_RUN7}, // S_SPOS_RUN6
  {SPR_SPOS,3,3,A_Chase,S_SPOS_RUN8}, // S_SPOS_RUN7
  {SPR_SPOS,3,3,A_Chase,S_SPOS_RUN1}, // S_SPOS_RUN8
  {SPR_SPOS,4,10,A_FaceTarget,S_SPOS_ATK2}, // S_SPOS_ATK1
  {SPR_SPOS,32773,10,A_SPosAttack,S_SPOS_ATK3}, // S_SPOS_ATK2
  {SPR_SPOS,4,10,NULL,S_SPOS_RUN1}, // S_SPOS_ATK3
  {SPR_SPOS,6,3,NULL,S_SPOS_PAIN2}, // S_SPOS_PAIN
  {SPR_SPOS,6,3,A_Pain,S_SPOS_RUN1},  // S_SPOS_PAIN2
  {SPR_SPOS,7,5,NULL,S_SPOS_DIE2},  // S_SPOS_DIE1
  {SPR_SPOS,8,5,A_Scream,S_SPOS_DIE3},  // S_SPOS_DIE2
  {SPR_SPOS,9,5,A_Fall,S_SPOS_DIE4},  // S_SPOS_DIE3
  {SPR_SPOS,10,5,NULL,S_SPOS_DIE5}, // S_SPOS_DIE4
  {SPR_SPOS,11,-1,NULL,S_NULL}, // S_SPOS_DIE5
  {SPR_SPOS,12,5,NULL,S_SPOS_XDIE2},  // S_SPOS_XDIE1
  {SPR_SPOS,13,5,A_XScream,S_SPOS_XDIE3}, // S_SPOS_XDIE2
  {SPR_SPOS,14,5,A_Fall,S_SPOS_XDIE4},  // S_SPOS_XDIE3
  {SPR_SPOS,15,5,NULL,S_SPOS_XDIE5},  // S_SPOS_XDIE4
  {SPR_SPOS,16,5,NULL,S_SPOS_XDIE6},  // S_SPOS_XDIE5
  {SPR_SPOS,17,5,NULL,S_SPOS_XDIE7},  // S_SPOS_XDIE6
  {SPR_SPOS,18,5,NULL,S_SPOS_XDIE8},  // S_SPOS_XDIE7
  {SPR_SPOS,19,5,NULL,S_SPOS_XDIE9},  // S_SPOS_XDIE8
  {SPR_SPOS,20,-1,NULL,S_NULL}, // S_SPOS_XDIE9
  {SPR_SPOS,11,5,NULL,S_SPOS_RAISE2}, // S_SPOS_RAISE1
  {SPR_SPOS,10,5,NULL,S_SPOS_RAISE3}, // S_SPOS_RAISE2
  {SPR_SPOS,9,5,NULL,S_SPOS_RAISE4},  // S_SPOS_RAISE3
  {SPR_SPOS,8,5,NULL,S_SPOS_RAISE5},  // S_SPOS_RAISE4
  {SPR_SPOS,7,5,NULL,S_SPOS_RUN1},  // S_SPOS_RAISE5
  {SPR_VILE,0,10,A_Look,S_VILE_STND2},  // S_VILE_STND
  {SPR_VILE,1,10,A_Look,S_VILE_STND}, // S_VILE_STND2
  {SPR_VILE,0,2,A_VileChase,S_VILE_RUN2}, // S_VILE_RUN1
  {SPR_VILE,0,2,A_VileChase,S_VILE_RUN3}, // S_VILE_RUN2
  {SPR_VILE,1,2,A_VileChase,S_VILE_RUN4}, // S_VILE_RUN3
  {SPR_VILE,1,2,A_VileChase,S_VILE_RUN5}, // S_VILE_RUN4
  {SPR_VILE,2,2,A_VileChase,S_VILE_RUN6}, // S_VILE_RUN5
  {SPR_VILE,2,2,A_VileChase,S_VILE_RUN7}, // S_VILE_RUN6
  {SPR_VILE,3,2,A_VileChase,S_VILE_RUN8}, // S_VILE_RUN7
  {SPR_VILE,3,2,A_VileChase,S_VILE_RUN9}, // S_VILE_RUN8
  {SPR_VILE,4,2,A_VileChase,S_VILE_RUN10},  // S_VILE_RUN9
  {SPR_VILE,4,2,A_VileChase,S_VILE_RUN11},  // S_VILE_RUN10
  {SPR_VILE,5,2,A_VileChase,S_VILE_RUN12},  // S_VILE_RUN11
  {SPR_VILE,5,2,A_VileChase,S_VILE_RUN1}, // S_VILE_RUN12
  {SPR_VILE,32774,0,A_VileStart,S_VILE_ATK2}, // S_VILE_ATK1
  {SPR_VILE,32774,10,A_FaceTarget,S_VILE_ATK3}, // S_VILE_ATK2
  {SPR_VILE,32775,8,A_VileTarget,S_VILE_ATK4},  // S_VILE_ATK3
  {SPR_VILE,32776,8,A_FaceTarget,S_VILE_ATK5},  // S_VILE_ATK4
  {SPR_VILE,32777,8,A_FaceTarget,S_VILE_ATK6},  // S_VILE_ATK5
  {SPR_VILE,32778,8,A_FaceTarget,S_VILE_ATK7},  // S_VILE_ATK6
  {SPR_VILE,32779,8,A_FaceTarget,S_VILE_ATK8},  // S_VILE_ATK7
  {SPR_VILE,32780,8,A_FaceTarget,S_VILE_ATK9},  // S_VILE_ATK8
  {SPR_VILE,32781,8,A_FaceTarget,S_VILE_ATK10}, // S_VILE_ATK9
  {SPR_VILE,32782,8,A_VileAttack,S_VILE_ATK11}, // S_VILE_ATK10
  {SPR_VILE,32783,20,NULL,S_VILE_RUN1}, // S_VILE_ATK11
  {SPR_VILE,32794,10,NULL,S_VILE_HEAL2},  // S_VILE_HEAL1
  {SPR_VILE,32795,10,NULL,S_VILE_HEAL3},  // S_VILE_HEAL2
  {SPR_VILE,32796,10,NULL,S_VILE_RUN1}, // S_VILE_HEAL3
  {SPR_VILE,16,5,NULL,S_VILE_PAIN2},  // S_VILE_PAIN
  {SPR_VILE,16,5,A_Pain,S_VILE_RUN1}, // S_VILE_PAIN2
  {SPR_VILE,16,7,NULL,S_VILE_DIE2}, // S_VILE_DIE1
  {SPR_VILE,17,7,A_Scream,S_VILE_DIE3},  // S_VILE_DIE2
  {SPR_VILE,18,7,A_Fall,S_VILE_DIE4}, // S_VILE_DIE3
  {SPR_VILE,19,7,NULL,S_VILE_DIE5}, // S_VILE_DIE4
  {SPR_VILE,20,7,NULL,S_VILE_DIE6}, // S_VILE_DIE5
  {SPR_VILE,21,7,NULL,S_VILE_DIE7}, // S_VILE_DIE6
  {SPR_VILE,22,7,NULL,S_VILE_DIE8}, // S_VILE_DIE7
  {SPR_VILE,23,5,NULL,S_VILE_DIE9}, // S_VILE_DIE8
  {SPR_VILE,24,5,NULL,S_VILE_DIE10},  // S_VILE_DIE9
  {SPR_VILE,25,-1,NULL,S_NULL}, // S_VILE_DIE10
  {SPR_FIRE,32768,2,A_StartFire,S_FIRE2}, // S_FIRE1
  {SPR_FIRE,32769,2,A_Fire,S_FIRE3},  // S_FIRE2
  {SPR_FIRE,32768,2,A_Fire,S_FIRE4},  // S_FIRE3
  {SPR_FIRE,32769,2,A_Fire,S_FIRE5},  // S_FIRE4
  {SPR_FIRE,32770,2,A_FireCrackle,S_FIRE6}, // S_FIRE5
  {SPR_FIRE,32769,2,A_Fire,S_FIRE7},  // S_FIRE6
  {SPR_FIRE,32770,2,A_Fire,S_FIRE8},  // S_FIRE7
  {SPR_FIRE,32769,2,A_Fire,S_FIRE9},  // S_FIRE8
  {SPR_FIRE,32770,2,A_Fire,S_FIRE10}, // S_FIRE9
  {SPR_FIRE,32771,2,A_Fire,S_FIRE11}, // S_FIRE10
  {SPR_FIRE,32770,2,A_Fire,S_FIRE12}, // S_FIRE11
  {SPR_FIRE,32771,2,A_Fire,S_FIRE13}, // S_FIRE12
  {SPR_FIRE,32770,2,A_Fire,S_FIRE14}, // S_FIRE13
  {SPR_FIRE,32771,2,A_Fire,S_FIRE15}, // S_FIRE14
  {SPR_FIRE,32772,2,A_Fire,S_FIRE16}, // S_FIRE15
  {SPR_FIRE,32771,2,A_Fire,S_FIRE17}, // S_FIRE16
  {SPR_FIRE,32772,2,A_Fire,S_FIRE18}, // S_FIRE17
  {SPR_FIRE,32771,2,A_Fire,S_FIRE19}, // S_FIRE18
  {SPR_FIRE,32772,2,A_FireCrackle,S_FIRE20},  // S_FIRE19
  {SPR_FIRE,32773,2,A_Fire,S_FIRE21}, // S_FIRE20
  {SPR_FIRE,32772,2,A_Fire,S_FIRE22}, // S_FIRE21
  {SPR_FIRE,32773,2,A_Fire,S_FIRE23}, // S_FIRE22
  {SPR_FIRE,32772,2,A_Fire,S_FIRE24}, // S_FIRE23
  {SPR_FIRE,32773,2,A_Fire,S_FIRE25}, // S_FIRE24
  {SPR_FIRE,32774,2,A_Fire,S_FIRE26}, // S_FIRE25
  {SPR_FIRE,32775,2,A_Fire,S_FIRE27}, // S_FIRE26
  {SPR_FIRE,32774,2,A_Fire,S_FIRE28}, // S_FIRE27
  {SPR_FIRE,32775,2,A_Fire,S_FIRE29}, // S_FIRE28
  {SPR_FIRE,32774,2,A_Fire,S_FIRE30}, // S_FIRE29
  {SPR_FIRE,32775,2,A_Fire,S_NULL}, // S_FIRE30
  {SPR_PUFF,1,4,NULL,S_SMOKE2}, // S_SMOKE1
  {SPR_PUFF,2,4,NULL,S_SMOKE3}, // S_SMOKE2
  {SPR_PUFF,1,4,NULL,S_SMOKE4}, // S_SMOKE3
  {SPR_PUFF,2,4,NULL,S_SMOKE5}, // S_SMOKE4
  {SPR_PUFF,3,4,NULL,S_NULL}, // S_SMOKE5
  {SPR_FATB,32768,2,A_Tracer,S_TRACER2},  // S_TRACER
  {SPR_FATB,32769,2,A_Tracer,S_TRACER}, // S_TRACER2
  {SPR_FBXP,32768,8,NULL,S_TRACEEXP2},  // S_TRACEEXP1
  {SPR_FBXP,32769,6,NULL,S_TRACEEXP3},  // S_TRACEEXP2
  {SPR_FBXP,32770,4,NULL,S_NULL}, // S_TRACEEXP3
  {SPR_SKEL,0,10,A_Look,S_SKEL_STND2},  // S_SKEL_STND
  {SPR_SKEL,1,10,A_Look,S_SKEL_STND}, // S_SKEL_STND2
  {SPR_SKEL,0,2,A_Chase,S_SKEL_RUN2}, // S_SKEL_RUN1
  {SPR_SKEL,0,2,A_Chase,S_SKEL_RUN3}, // S_SKEL_RUN2
  {SPR_SKEL,1,2,A_Chase,S_SKEL_RUN4}, // S_SKEL_RUN3
  {SPR_SKEL,1,2,A_Chase,S_SKEL_RUN5}, // S_SKEL_RUN4
  {SPR_SKEL,2,2,A_Chase,S_SKEL_RUN6}, // S_SKEL_RUN5
  {SPR_SKEL,2,2,A_Chase,S_SKEL_RUN7}, // S_SKEL_RUN6
  {SPR_SKEL,3,2,A_Chase,S_SKEL_RUN8}, // S_SKEL_RUN7
  {SPR_SKEL,3,2,A_Chase,S_SKEL_RUN9}, // S_SKEL_RUN8
  {SPR_SKEL,4,2,A_Chase,S_SKEL_RUN10},  // S_SKEL_RUN9
  {SPR_SKEL,4,2,A_Chase,S_SKEL_RUN11},  // S_SKEL_RUN10
  {SPR_SKEL,5,2,A_Chase,S_SKEL_RUN12},  // S_SKEL_RUN11
  {SPR_SKEL,5,2,A_Chase,S_SKEL_RUN1}, // S_SKEL_RUN12
  {SPR_SKEL,6,0,A_FaceTarget,S_SKEL_FIST2}, // S_SKEL_FIST1
  {SPR_SKEL,6,6,A_SkelWhoosh,S_SKEL_FIST3}, // S_SKEL_FIST2
  {SPR_SKEL,7,6,A_FaceTarget,S_SKEL_FIST4}, // S_SKEL_FIST3
  {SPR_SKEL,8,6,A_SkelFist,S_SKEL_RUN1},  // S_SKEL_FIST4
  {SPR_SKEL,32777,0,A_FaceTarget,S_SKEL_MISS2}, // S_SKEL_MISS1
  {SPR_SKEL,32777,10,A_FaceTarget,S_SKEL_MISS3},  // S_SKEL_MISS2
  {SPR_SKEL,10,10,A_SkelMissile,S_SKEL_MISS4},  // S_SKEL_MISS3
  {SPR_SKEL,10,10,A_FaceTarget,S_SKEL_RUN1},  // S_SKEL_MISS4
  {SPR_SKEL,11,5,NULL,S_SKEL_PAIN2},  // S_SKEL_PAIN
  {SPR_SKEL,11,5,A_Pain,S_SKEL_RUN1}, // S_SKEL_PAIN2
  {SPR_SKEL,11,7,NULL,S_SKEL_DIE2}, // S_SKEL_DIE1
  {SPR_SKEL,12,7,NULL,S_SKEL_DIE3}, // S_SKEL_DIE2
  {SPR_SKEL,13,7,A_Scream,S_SKEL_DIE4}, // S_SKEL_DIE3
  {SPR_SKEL,14,7,A_Fall,S_SKEL_DIE5}, // S_SKEL_DIE4
  {SPR_SKEL,15,7,NULL,S_SKEL_DIE6}, // S_SKEL_DIE5
  {SPR_SKEL,16,-1,NULL,S_NULL}, // S_SKEL_DIE6
  {SPR_SKEL,16,5,NULL,S_SKEL_RAISE2}, // S_SKEL_RAISE1
  {SPR_SKEL,15,5,NULL,S_SKEL_RAISE3}, // S_SKEL_RAISE2
  {SPR_SKEL,14,5,NULL,S_SKEL_RAISE4}, // S_SKEL_RAISE3
  {SPR_SKEL,13,5,NULL,S_SKEL_RAISE5}, // S_SKEL_RAISE4
  {SPR_SKEL,12,5,NULL,S_SKEL_RAISE6}, // S_SKEL_RAISE5
  {SPR_SKEL,11,5,NULL,S_SKEL_RUN1}, // S_SKEL_RAISE6
  {SPR_MANF,32768,4,NULL,S_FATSHOT2}, // S_FATSHOT1
  {SPR_MANF,32769,4,NULL,S_FATSHOT1}, // S_FATSHOT2
  {SPR_MISL,32769,8,NULL,S_FATSHOTX2},  // S_FATSHOTX1
  {SPR_MISL,32770,6,NULL,S_FATSHOTX3},  // S_FATSHOTX2
  {SPR_MISL,32771,4,NULL,S_NULL}, // S_FATSHOTX3
  {SPR_FATT,0,15,A_Look,S_FATT_STND2},  // S_FATT_STND
  {SPR_FATT,1,15,A_Look,S_FATT_STND}, // S_FATT_STND2
  {SPR_FATT,0,4,A_Chase,S_FATT_RUN2}, // S_FATT_RUN1
  {SPR_FATT,0,4,A_Chase,S_FATT_RUN3}, // S_FATT_RUN2
  {SPR_FATT,1,4,A_Chase,S_FATT_RUN4}, // S_FATT_RUN3
  {SPR_FATT,1,4,A_Chase,S_FATT_RUN5}, // S_FATT_RUN4
  {SPR_FATT,2,4,A_Chase,S_FATT_RUN6}, // S_FATT_RUN5
  {SPR_FATT,2,4,A_Chase,S_FATT_RUN7}, // S_FATT_RUN6
  {SPR_FATT,3,4,A_Chase,S_FATT_RUN8}, // S_FATT_RUN7
  {SPR_FATT,3,4,A_Chase,S_FATT_RUN9}, // S_FATT_RUN8
  {SPR_FATT,4,4,A_Chase,S_FATT_RUN10},  // S_FATT_RUN9
  {SPR_FATT,4,4,A_Chase,S_FATT_RUN11},  // S_FATT_RUN10
  {SPR_FATT,5,4,A_Chase,S_FATT_RUN12},  // S_FATT_RUN11
  {SPR_FATT,5,4,A_Chase,S_FATT_RUN1}, // S_FATT_RUN12
  {SPR_FATT,6,20,A_FatRaise,S_FATT_ATK2}, // S_FATT_ATK1
  {SPR_FATT,32775,10,A_FatAttack1,S_FATT_ATK3}, // S_FATT_ATK2
  {SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK4},  // S_FATT_ATK3
  {SPR_FATT,6,5,A_FaceTarget,S_FATT_ATK5},  // S_FATT_ATK4
  {SPR_FATT,32775,10,A_FatAttack2,S_FATT_ATK6}, // S_FATT_ATK5
  {SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK7},  // S_FATT_ATK6
  {SPR_FATT,6,5,A_FaceTarget,S_FATT_ATK8},  // S_FATT_ATK7
  {SPR_FATT,32775,10,A_FatAttack3,S_FATT_ATK9}, // S_FATT_ATK8
  {SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK10}, // S_FATT_ATK9
  {SPR_FATT,6,5,A_FaceTarget,S_FATT_RUN1},  // S_FATT_ATK10
  {SPR_FATT,9,3,NULL,S_FATT_PAIN2}, // S_FATT_PAIN
  {SPR_FATT,9,3,A_Pain,S_FATT_RUN1},  // S_FATT_PAIN2
  {SPR_FATT,10,6,NULL,S_FATT_DIE2}, // S_FATT_DIE1
  {SPR_FATT,11,6,A_Scream,S_FATT_DIE3}, // S_FATT_DIE2
  {SPR_FATT,12,6,A_Fall,S_FATT_DIE4}, // S_FATT_DIE3
  {SPR_FATT,13,6,NULL,S_FATT_DIE5}, // S_FATT_DIE4
  {SPR_FATT,14,6,NULL,S_FATT_DIE6}, // S_FATT_DIE5
  {SPR_FATT,15,6,NULL,S_FATT_DIE7}, // S_FATT_DIE6
  {SPR_FATT,16,6,NULL,S_FATT_DIE8}, // S_FATT_DIE7
  {SPR_FATT,17,6,NULL,S_FATT_DIE9}, // S_FATT_DIE8
  {SPR_FATT,18,6,NULL,S_FATT_DIE10},  // S_FATT_DIE9
  {SPR_FATT,19,-1,A_BossDeath,S_NULL},  // S_FATT_DIE10
  {SPR_FATT,17,5,NULL,S_FATT_RAISE2}, // S_FATT_RAISE1
  {SPR_FATT,16,5,NULL,S_FATT_RAISE3}, // S_FATT_RAISE2
  {SPR_FATT,15,5,NULL,S_FATT_RAISE4}, // S_FATT_RAISE3
  {SPR_FATT,14,5,NULL,S_FATT_RAISE5}, // S_FATT_RAISE4
  {SPR_FATT,13,5,NULL,S_FATT_RAISE6}, // S_FATT_RAISE5
  {SPR_FATT,12,5,NULL,S_FATT_RAISE7}, // S_FATT_RAISE6
  {SPR_FATT,11,5,NULL,S_FATT_RAISE8}, // S_FATT_RAISE7
  {SPR_FATT,10,5,NULL,S_FATT_RUN1}, // S_FATT_RAISE8
  {SPR_CPOS,0,10,A_Look,S_CPOS_STND2},  // S_CPOS_STND
  {SPR_CPOS,1,10,A_Look,S_CPOS_STND}, // S_CPOS_STND2
  {SPR_CPOS,0,3,A_Chase,S_CPOS_RUN2}, // S_CPOS_RUN1
  {SPR_CPOS,0,3,A_Chase,S_CPOS_RUN3}, // S_CPOS_RUN2
  {SPR_CPOS,1,3,A_Chase,S_CPOS_RUN4}, // S_CPOS_RUN3
  {SPR_CPOS,1,3,A_Chase,S_CPOS_RUN5}, // S_CPOS_RUN4
  {SPR_CPOS,2,3,A_Chase,S_CPOS_RUN6}, // S_CPOS_RUN5
  {SPR_CPOS,2,3,A_Chase,S_CPOS_RUN7}, // S_CPOS_RUN6
  {SPR_CPOS,3,3,A_Chase,S_CPOS_RUN8}, // S_CPOS_RUN7
  {SPR_CPOS,3,3,A_Chase,S_CPOS_RUN1}, // S_CPOS_RUN8
  {SPR_CPOS,4,10,A_FaceTarget,S_CPOS_ATK2}, // S_CPOS_ATK1
  {SPR_CPOS,32773,4,A_CPosAttack,S_CPOS_ATK3},  // S_CPOS_ATK2
  {SPR_CPOS,32772,4,A_CPosAttack,S_CPOS_ATK4},  // S_CPOS_ATK3
  {SPR_CPOS,5,1,A_CPosRefire,S_CPOS_ATK2},  // S_CPOS_ATK4
  {SPR_CPOS,6,3,NULL,S_CPOS_PAIN2}, // S_CPOS_PAIN
  {SPR_CPOS,6,3,A_Pain,S_CPOS_RUN1},  // S_CPOS_PAIN2
  {SPR_CPOS,7,5,NULL,S_CPOS_DIE2},  // S_CPOS_DIE1
  {SPR_CPOS,8,5,A_Scream,S_CPOS_DIE3},  // S_CPOS_DIE2
  {SPR_CPOS,9,5,A_Fall,S_CPOS_DIE4},  // S_CPOS_DIE3
  {SPR_CPOS,10,5,NULL,S_CPOS_DIE5}, // S_CPOS_DIE4
  {SPR_CPOS,11,5,NULL,S_CPOS_DIE6}, // S_CPOS_DIE5
  {SPR_CPOS,12,5,NULL,S_CPOS_DIE7}, // S_CPOS_DIE6
  {SPR_CPOS,13,-1,NULL,S_NULL}, // S_CPOS_DIE7
  {SPR_CPOS,14,5,NULL,S_CPOS_XDIE2},  // S_CPOS_XDIE1
  {SPR_CPOS,15,5,A_XScream,S_CPOS_XDIE3}, // S_CPOS_XDIE2
  {SPR_CPOS,16,5,A_Fall,S_CPOS_XDIE4},  // S_CPOS_XDIE3
  {SPR_CPOS,17,5,NULL,S_CPOS_XDIE5},  // S_CPOS_XDIE4
  {SPR_CPOS,18,5,NULL,S_CPOS_XDIE6},  // S_CPOS_XDIE5
  {SPR_CPOS,19,-1,NULL,S_NULL}, // S_CPOS_XDIE6
  {SPR_CPOS,13,5,NULL,S_CPOS_RAISE2}, // S_CPOS_RAISE1
  {SPR_CPOS,12,5,NULL,S_CPOS_RAISE3}, // S_CPOS_RAISE2
  {SPR_CPOS,11,5,NULL,S_CPOS_RAISE4}, // S_CPOS_RAISE3
  {SPR_CPOS,10,5,NULL,S_CPOS_RAISE5}, // S_CPOS_RAISE4
  {SPR_CPOS,9,5,NULL,S_CPOS_RAISE6},  // S_CPOS_RAISE5
  {SPR_CPOS,8,5,NULL,S_CPOS_RAISE7},  // S_CPOS_RAISE6
  {SPR_CPOS,7,5,NULL,S_CPOS_RUN1},  // S_CPOS_RAISE7
  {SPR_TROO,0,10,A_Look,S_TROO_STND2},  // S_TROO_STND
  {SPR_TROO,1,10,A_Look,S_TROO_STND}, // S_TROO_STND2
  {SPR_TROO,0,3,A_Chase,S_TROO_RUN2}, // S_TROO_RUN1
  {SPR_TROO,0,3,A_Chase,S_TROO_RUN3}, // S_TROO_RUN2
  {SPR_TROO,1,3,A_Chase,S_TROO_RUN4}, // S_TROO_RUN3
  {SPR_TROO,1,3,A_Chase,S_TROO_RUN5}, // S_TROO_RUN4
  {SPR_TROO,2,3,A_Chase,S_TROO_RUN6}, // S_TROO_RUN5
  {SPR_TROO,2,3,A_Chase,S_TROO_RUN7}, // S_TROO_RUN6
  {SPR_TROO,3,3,A_Chase,S_TROO_RUN8}, // S_TROO_RUN7
  {SPR_TROO,3,3,A_Chase,S_TROO_RUN1}, // S_TROO_RUN8
  {SPR_TROO,4,8,A_FaceTarget,S_TROO_ATK2},  // S_TROO_ATK1
  {SPR_TROO,5,8,A_FaceTarget,S_TROO_ATK3},  // S_TROO_ATK2
  {SPR_TROO,6,6,A_TroopAttack,S_TROO_RUN1}, // S_TROO_ATK3
  {SPR_TROO,7,2,NULL,S_TROO_PAIN2}, // S_TROO_PAIN
  {SPR_TROO,7,2,A_Pain,S_TROO_RUN1},  // S_TROO_PAIN2
  {SPR_TROO,8,8,NULL,S_TROO_DIE2},  // S_TROO_DIE1
  {SPR_TROO,9,8,A_Scream,S_TROO_DIE3},  // S_TROO_DIE2
  {SPR_TROO,10,6,NULL,S_TROO_DIE4}, // S_TROO_DIE3
  {SPR_TROO,11,6,A_Fall,S_TROO_DIE5}, // S_TROO_DIE4
  {SPR_TROO,12,-1,NULL,S_NULL}, // S_TROO_DIE5
  {SPR_TROO,13,5,NULL,S_TROO_XDIE2},  // S_TROO_XDIE1
  {SPR_TROO,14,5,A_XScream,S_TROO_XDIE3}, // S_TROO_XDIE2
  {SPR_TROO,15,5,NULL,S_TROO_XDIE4},  // S_TROO_XDIE3
  {SPR_TROO,16,5,A_Fall,S_TROO_XDIE5},  // S_TROO_XDIE4
  {SPR_TROO,17,5,NULL,S_TROO_XDIE6},  // S_TROO_XDIE5
  {SPR_TROO,18,5,NULL,S_TROO_XDIE7},  // S_TROO_XDIE6
  {SPR_TROO,19,5,NULL,S_TROO_XDIE8},  // S_TROO_XDIE7
  {SPR_TROO,20,-1,NULL,S_NULL}, // S_TROO_XDIE8
  {SPR_TROO,12,8,NULL,S_TROO_RAISE2}, // S_TROO_RAISE1
  {SPR_TROO,11,8,NULL,S_TROO_RAISE3}, // S_TROO_RAISE2
  {SPR_TROO,10,6,NULL,S_TROO_RAISE4}, // S_TROO_RAISE3
  {SPR_TROO,9,6,NULL,S_TROO_RAISE5},  // S_TROO_RAISE4
  {SPR_TROO,8,6,NULL,S_TROO_RUN1},  // S_TROO_RAISE5
  {SPR_SARG,0,10,A_Look,S_SARG_STND2},  // S_SARG_STND
  {SPR_SARG,1,10,A_Look,S_SARG_STND}, // S_SARG_STND2
  {SPR_SARG,0,2,A_Chase,S_SARG_RUN2}, // S_SARG_RUN1
  {SPR_SARG,0,2,A_Chase,S_SARG_RUN3}, // S_SARG_RUN2
  {SPR_SARG,1,2,A_Chase,S_SARG_RUN4}, // S_SARG_RUN3
  {SPR_SARG,1,2,A_Chase,S_SARG_RUN5}, // S_SARG_RUN4
  {SPR_SARG,2,2,A_Chase,S_SARG_RUN6}, // S_SARG_RUN5
  {SPR_SARG,2,2,A_Chase,S_SARG_RUN7}, // S_SARG_RUN6
  {SPR_SARG,3,2,A_Chase,S_SARG_RUN8}, // S_SARG_RUN7
  {SPR_SARG,3,2,A_Chase,S_SARG_RUN1}, // S_SARG_RUN8
  {SPR_SARG,4,8,A_FaceTarget,S_SARG_ATK2},  // S_SARG_ATK1
  {SPR_SARG,5,8,A_FaceTarget,S_SARG_ATK3},  // S_SARG_ATK2
  {SPR_SARG,6,8,A_SargAttack,S_SARG_RUN1},  // S_SARG_ATK3
  {SPR_SARG,7,2,NULL,S_SARG_PAIN2}, // S_SARG_PAIN
  {SPR_SARG,7,2,A_Pain,S_SARG_RUN1},  // S_SARG_PAIN2
  {SPR_SARG,8,8,NULL,S_SARG_DIE2},  // S_SARG_DIE1
  {SPR_SARG,9,8,A_Scream,S_SARG_DIE3},  // S_SARG_DIE2
  {SPR_SARG,10,4,NULL,S_SARG_DIE4}, // S_SARG_DIE3
  {SPR_SARG,11,4,A_Fall,S_SARG_DIE5}, // S_SARG_DIE4
  {SPR_SARG,12,4,NULL,S_SARG_DIE6}, // S_SARG_DIE5
  {SPR_SARG,13,-1,NULL,S_NULL}, // S_SARG_DIE6
  {SPR_SARG,13,5,NULL,S_SARG_RAISE2}, // S_SARG_RAISE1
  {SPR_SARG,12,5,NULL,S_SARG_RAISE3}, // S_SARG_RAISE2
  {SPR_SARG,11,5,NULL,S_SARG_RAISE4}, // S_SARG_RAISE3
  {SPR_SARG,10,5,NULL,S_SARG_RAISE5}, // S_SARG_RAISE4
  {SPR_SARG,9,5,NULL,S_SARG_RAISE6},  // S_SARG_RAISE5
  {SPR_SARG,8,5,NULL,S_SARG_RUN1},  // S_SARG_RAISE6
  {SPR_HEAD,0,10,A_Look,S_HEAD_STND}, // S_HEAD_STND
  {SPR_HEAD,0,3,A_Chase,S_HEAD_RUN1}, // S_HEAD_RUN1
  {SPR_HEAD,1,5,A_FaceTarget,S_HEAD_ATK2},  // S_HEAD_ATK1
  {SPR_HEAD,2,5,A_FaceTarget,S_HEAD_ATK3},  // S_HEAD_ATK2
  {SPR_HEAD,32771,5,A_HeadAttack,S_HEAD_RUN1},  // S_HEAD_ATK3
  {SPR_HEAD,4,3,NULL,S_HEAD_PAIN2}, // S_HEAD_PAIN
  {SPR_HEAD,4,3,A_Pain,S_HEAD_PAIN3}, // S_HEAD_PAIN2
  {SPR_HEAD,5,6,NULL,S_HEAD_RUN1},  // S_HEAD_PAIN3
  {SPR_HEAD,6,8,NULL,S_HEAD_DIE2},  // S_HEAD_DIE1
  {SPR_HEAD,7,8,A_Scream,S_HEAD_DIE3},  // S_HEAD_DIE2
  {SPR_HEAD,8,8,NULL,S_HEAD_DIE4},  // S_HEAD_DIE3
  {SPR_HEAD,9,8,NULL,S_HEAD_DIE5},  // S_HEAD_DIE4
  {SPR_HEAD,10,8,A_Fall,S_HEAD_DIE6}, // S_HEAD_DIE5
  {SPR_HEAD,11,-1,NULL,S_NULL}, // S_HEAD_DIE6
  {SPR_HEAD,11,8,NULL,S_HEAD_RAISE2}, // S_HEAD_RAISE1
  {SPR_HEAD,10,8,NULL,S_HEAD_RAISE3}, // S_HEAD_RAISE2
  {SPR_HEAD,9,8,NULL,S_HEAD_RAISE4},  // S_HEAD_RAISE3
  {SPR_HEAD,8,8,NULL,S_HEAD_RAISE5},  // S_HEAD_RAISE4
  {SPR_HEAD,7,8,NULL,S_HEAD_RAISE6},  // S_HEAD_RAISE5
  {SPR_HEAD,6,8,NULL,S_HEAD_RUN1},  // S_HEAD_RAISE6
  {SPR_BAL7,32768,4,NULL,S_BRBALL2},  // S_BRBALL1
  {SPR_BAL7,32769,4,NULL,S_BRBALL1},  // S_BRBALL2
  {SPR_BAL7,32770,6,NULL,S_BRBALLX2}, // S_BRBALLX1
  {SPR_BAL7,32771,6,NULL,S_BRBALLX3}, // S_BRBALLX2
  {SPR_BAL7,32772,6,NULL,S_NULL}, // S_BRBALLX3
  {SPR_BOSS,0,10,A_Look,S_BOSS_STND2},  // S_BOSS_STND
  {SPR_BOSS,1,10,A_Look,S_BOSS_STND}, // S_BOSS_STND2
  {SPR_BOSS,0,3,A_Chase,S_BOSS_RUN2}, // S_BOSS_RUN1
  {SPR_BOSS,0,3,A_Chase,S_BOSS_RUN3}, // S_BOSS_RUN2
  {SPR_BOSS,1,3,A_Chase,S_BOSS_RUN4}, // S_BOSS_RUN3
  {SPR_BOSS,1,3,A_Chase,S_BOSS_RUN5}, // S_BOSS_RUN4
  {SPR_BOSS,2,3,A_Chase,S_BOSS_RUN6}, // S_BOSS_RUN5
  {SPR_BOSS,2,3,A_Chase,S_BOSS_RUN7}, // S_BOSS_RUN6
  {SPR_BOSS,3,3,A_Chase,S_BOSS_RUN8}, // S_BOSS_RUN7
  {SPR_BOSS,3,3,A_Chase,S_BOSS_RUN1}, // S_BOSS_RUN8
  {SPR_BOSS,4,8,A_FaceTarget,S_BOSS_ATK2},  // S_BOSS_ATK1
  {SPR_BOSS,5,8,A_FaceTarget,S_BOSS_ATK3},  // S_BOSS_ATK2
  {SPR_BOSS,6,8,A_BruisAttack,S_BOSS_RUN1}, // S_BOSS_ATK3
  {SPR_BOSS,7,2,NULL,S_BOSS_PAIN2}, // S_BOSS_PAIN
  {SPR_BOSS,7,2,A_Pain,S_BOSS_RUN1},  // S_BOSS_PAIN2
  {SPR_BOSS,8,8,NULL,S_BOSS_DIE2},  // S_BOSS_DIE1
  {SPR_BOSS,9,8,A_Scream,S_BOSS_DIE3},  // S_BOSS_DIE2
  {SPR_BOSS,10,8,NULL,S_BOSS_DIE4}, // S_BOSS_DIE3
  {SPR_BOSS,11,8,A_Fall,S_BOSS_DIE5}, // S_BOSS_DIE4
  {SPR_BOSS,12,8,NULL,S_BOSS_DIE6}, // S_BOSS_DIE5
  {SPR_BOSS,13,8,NULL,S_BOSS_DIE7}, // S_BOSS_DIE6
  {SPR_BOSS,14,-1,A_BossDeath,S_NULL},  // S_BOSS_DIE7
  {SPR_BOSS,14,8,NULL,S_BOSS_RAISE2}, // S_BOSS_RAISE1
  {SPR_BOSS,13,8,NULL,S_BOSS_RAISE3}, // S_BOSS_RAISE2
  {SPR_BOSS,12,8,NULL,S_BOSS_RAISE4}, // S_BOSS_RAISE3
  {SPR_BOSS,11,8,NULL,S_BOSS_RAISE5}, // S_BOSS_RAISE4
  {SPR_BOSS,10,8,NULL,S_BOSS_RAISE6}, // S_BOSS_RAISE5
  {SPR_BOSS,9,8,NULL,S_BOSS_RAISE7},  // S_BOSS_RAISE6
  {SPR_BOSS,8,8,NULL,S_BOSS_RUN1},  // S_BOSS_RAISE7
  {SPR_BOS2,0,10,A_Look,S_BOS2_STND2},  // S_BOS2_STND
  {SPR_BOS2,1,10,A_Look,S_BOS2_STND}, // S_BOS2_STND2
  {SPR_BOS2,0,3,A_Chase,S_BOS2_RUN2}, // S_BOS2_RUN1
  {SPR_BOS2,0,3,A_Chase,S_BOS2_RUN3}, // S_BOS2_RUN2
  {SPR_BOS2,1,3,A_Chase,S_BOS2_RUN4}, // S_BOS2_RUN3
  {SPR_BOS2,1,3,A_Chase,S_BOS2_RUN5}, // S_BOS2_RUN4
  {SPR_BOS2,2,3,A_Chase,S_BOS2_RUN6}, // S_BOS2_RUN5
  {SPR_BOS2,2,3,A_Chase,S_BOS2_RUN7}, // S_BOS2_RUN6
  {SPR_BOS2,3,3,A_Chase,S_BOS2_RUN8}, // S_BOS2_RUN7
  {SPR_BOS2,3,3,A_Chase,S_BOS2_RUN1}, // S_BOS2_RUN8
  {SPR_BOS2,4,8,A_FaceTarget,S_BOS2_ATK2},  // S_BOS2_ATK1
  {SPR_BOS2,5,8,A_FaceTarget,S_BOS2_ATK3},  // S_BOS2_ATK2
  {SPR_BOS2,6,8,A_BruisAttack,S_BOS2_RUN1}, // S_BOS2_ATK3
  {SPR_BOS2,7,2,NULL,S_BOS2_PAIN2}, // S_BOS2_PAIN
  {SPR_BOS2,7,2,A_Pain,S_BOS2_RUN1},  // S_BOS2_PAIN2
  {SPR_BOS2,8,8,NULL,S_BOS2_DIE2},  // S_BOS2_DIE1
  {SPR_BOS2,9,8,A_Scream,S_BOS2_DIE3},  // S_BOS2_DIE2
  {SPR_BOS2,10,8,NULL,S_BOS2_DIE4}, // S_BOS2_DIE3
  {SPR_BOS2,11,8,A_Fall,S_BOS2_DIE5}, // S_BOS2_DIE4
  {SPR_BOS2,12,8,NULL,S_BOS2_DIE6}, // S_BOS2_DIE5
  {SPR_BOS2,13,8,NULL,S_BOS2_DIE7}, // S_BOS2_DIE6
  {SPR_BOS2,14,-1,NULL,S_NULL}, // S_BOS2_DIE7
  {SPR_BOS2,14,8,NULL,S_BOS2_RAISE2}, // S_BOS2_RAISE1
  {SPR_BOS2,13,8,NULL,S_BOS2_RAISE3}, // S_BOS2_RAISE2
  {SPR_BOS2,12,8,NULL,S_BOS2_RAISE4}, // S_BOS2_RAISE3
  {SPR_BOS2,11,8,NULL,S_BOS2_RAISE5}, // S_BOS2_RAISE4
  {SPR_BOS2,10,8,NULL,S_BOS2_RAISE6}, // S_BOS2_RAISE5
  {SPR_BOS2,9,8,NULL,S_BOS2_RAISE7},  // S_BOS2_RAISE6
  {SPR_BOS2,8,8,NULL,S_BOS2_RUN1},  // S_BOS2_RAISE7
  {SPR_SKUL,32768,10,A_Look,S_SKULL_STND2}, // S_SKULL_STND
  {SPR_SKUL,32769,10,A_Look,S_SKULL_STND},  // S_SKULL_STND2
  {SPR_SKUL,32768,6,A_Chase,S_SKULL_RUN2},  // S_SKULL_RUN1
  {SPR_SKUL,32769,6,A_Chase,S_SKULL_RUN1},  // S_SKULL_RUN2
  {SPR_SKUL,32770,10,A_FaceTarget,S_SKULL_ATK2},  // S_SKULL_ATK1
  {SPR_SKUL,32771,4,A_SkullAttack,S_SKULL_ATK3},  // S_SKULL_ATK2
  {SPR_SKUL,32770,4,NULL,S_SKULL_ATK4}, // S_SKULL_ATK3
  {SPR_SKUL,32771,4,NULL,S_SKULL_ATK3}, // S_SKULL_ATK4
  {SPR_SKUL,32772,3,NULL,S_SKULL_PAIN2},  // S_SKULL_PAIN
  {SPR_SKUL,32772,3,A_Pain,S_SKULL_RUN1}, // S_SKULL_PAIN2
  {SPR_SKUL,32773,6,NULL,S_SKULL_DIE2}, // S_SKULL_DIE1
  {SPR_SKUL,32774,6,A_Scream,S_SKULL_DIE3}, // S_SKULL_DIE2
  {SPR_SKUL,32775,6,NULL,S_SKULL_DIE4}, // S_SKULL_DIE3
  {SPR_SKUL,32776,6,A_Fall,S_SKULL_DIE5}, // S_SKULL_DIE4
  {SPR_SKUL,9,6,NULL,S_SKULL_DIE6}, // S_SKULL_DIE5
  {SPR_SKUL,10,6,NULL,S_NULL},  // S_SKULL_DIE6
  {SPR_SPID,0,10,A_Look,S_SPID_STND2},  // S_SPID_STND
  {SPR_SPID,1,10,A_Look,S_SPID_STND}, // S_SPID_STND2
  {SPR_SPID,0,3,A_Metal,S_SPID_RUN2}, // S_SPID_RUN1
  {SPR_SPID,0,3,A_Chase,S_SPID_RUN3}, // S_SPID_RUN2
  {SPR_SPID,1,3,A_Chase,S_SPID_RUN4}, // S_SPID_RUN3
  {SPR_SPID,1,3,A_Chase,S_SPID_RUN5}, // S_SPID_RUN4
  {SPR_SPID,2,3,A_Metal,S_SPID_RUN6}, // S_SPID_RUN5
  {SPR_SPID,2,3,A_Chase,S_SPID_RUN7}, // S_SPID_RUN6
  {SPR_SPID,3,3,A_Chase,S_SPID_RUN8}, // S_SPID_RUN7
  {SPR_SPID,3,3,A_Chase,S_SPID_RUN9}, // S_SPID_RUN8
  {SPR_SPID,4,3,A_Metal,S_SPID_RUN10},  // S_SPID_RUN9
  {SPR_SPID,4,3,A_Chase,S_SPID_RUN11},  // S_SPID_RUN10
  {SPR_SPID,5,3,A_Chase,S_SPID_RUN12},  // S_SPID_RUN11
  {SPR_SPID,5,3,A_Chase,S_SPID_RUN1}, // S_SPID_RUN12
  {SPR_SPID,32768,20,A_FaceTarget,S_SPID_ATK2}, // S_SPID_ATK1
  {SPR_SPID,32774,4,A_SPosAttack,S_SPID_ATK3},  // S_SPID_ATK2
  {SPR_SPID,32775,4,A_SPosAttack,S_SPID_ATK4},  // S_SPID_ATK3
  {SPR_SPID,32775,1,A_SpidRefire,S_SPID_ATK2},  // S_SPID_ATK4
  {SPR_SPID,8,3,NULL,S_SPID_PAIN2}, // S_SPID_PAIN
  {SPR_SPID,8,3,A_Pain,S_SPID_RUN1},  // S_SPID_PAIN2
  {SPR_SPID,9,20,A_Scream,S_SPID_DIE2}, // S_SPID_DIE1
  {SPR_SPID,10,10,A_Fall,S_SPID_DIE3},  // S_SPID_DIE2
  {SPR_SPID,11,10,NULL,S_SPID_DIE4},  // S_SPID_DIE3
  {SPR_SPID,12,10,NULL,S_SPID_DIE5},  // S_SPID_DIE4
  {SPR_SPID,13,10,NULL,S_SPID_DIE6},  // S_SPID_DIE5
  {SPR_SPID,14,10,NULL,S_SPID_DIE7},  // S_SPID_DIE6
  {SPR_SPID,15,10,NULL,S_SPID_DIE8},  // S_SPID_DIE7
  {SPR_SPID,16,10,NULL,S_SPID_DIE9},  // S_SPID_DIE8
  {SPR_SPID,17,10,NULL,S_SPID_DIE10}, // S_SPID_DIE9
  {SPR_SPID,18,30,NULL,S_SPID_DIE11}, // S_SPID_DIE10
  {SPR_SPID,18,-1,A_BossDeath,S_NULL},  // S_SPID_DIE11
  {SPR_BSPI,0,10,A_Look,S_BSPI_STND2},  // S_BSPI_STND
  {SPR_BSPI,1,10,A_Look,S_BSPI_STND}, // S_BSPI_STND2
  {SPR_BSPI,0,20,NULL,S_BSPI_RUN1}, // S_BSPI_SIGHT
  {SPR_BSPI,0,3,A_BabyMetal,S_BSPI_RUN2}, // S_BSPI_RUN1
  {SPR_BSPI,0,3,A_Chase,S_BSPI_RUN3}, // S_BSPI_RUN2
  {SPR_BSPI,1,3,A_Chase,S_BSPI_RUN4}, // S_BSPI_RUN3
  {SPR_BSPI,1,3,A_Chase,S_BSPI_RUN5}, // S_BSPI_RUN4
  {SPR_BSPI,2,3,A_Chase,S_BSPI_RUN6}, // S_BSPI_RUN5
  {SPR_BSPI,2,3,A_Chase,S_BSPI_RUN7}, // S_BSPI_RUN6
  {SPR_BSPI,3,3,A_BabyMetal,S_BSPI_RUN8}, // S_BSPI_RUN7
  {SPR_BSPI,3,3,A_Chase,S_BSPI_RUN9}, // S_BSPI_RUN8
  {SPR_BSPI,4,3,A_Chase,S_BSPI_RUN10},  // S_BSPI_RUN9
  {SPR_BSPI,4,3,A_Chase,S_BSPI_RUN11},  // S_BSPI_RUN10
  {SPR_BSPI,5,3,A_Chase,S_BSPI_RUN12},  // S_BSPI_RUN11
  {SPR_BSPI,5,3,A_Chase,S_BSPI_RUN1}, // S_BSPI_RUN12
  {SPR_BSPI,32768,20,A_FaceTarget,S_BSPI_ATK2}, // S_BSPI_ATK1
  {SPR_BSPI,32774,4,A_BspiAttack,S_BSPI_ATK3},  // S_BSPI_ATK2
  {SPR_BSPI,32775,4,NULL,S_BSPI_ATK4},  // S_BSPI_ATK3
  {SPR_BSPI,32775,1,A_SpidRefire,S_BSPI_ATK2},  // S_BSPI_ATK4
  {SPR_BSPI,8,3,NULL,S_BSPI_PAIN2}, // S_BSPI_PAIN
  {SPR_BSPI,8,3,A_Pain,S_BSPI_RUN1},  // S_BSPI_PAIN2
  {SPR_BSPI,9,20,A_Scream,S_BSPI_DIE2}, // S_BSPI_DIE1
  {SPR_BSPI,10,7,A_Fall,S_BSPI_DIE3}, // S_BSPI_DIE2
  {SPR_BSPI,11,7,NULL,S_BSPI_DIE4}, // S_BSPI_DIE3
  {SPR_BSPI,12,7,NULL,S_BSPI_DIE5}, // S_BSPI_DIE4
  {SPR_BSPI,13,7,NULL,S_BSPI_DIE6}, // S_BSPI_DIE5
  {SPR_BSPI,14,7,NULL,S_BSPI_DIE7}, // S_BSPI_DIE6
  {SPR_BSPI,15,-1,A_BossDeath,S_NULL},  // S_BSPI_DIE7
  {SPR_BSPI,15,5,NULL,S_BSPI_RAISE2}, // S_BSPI_RAISE1
  {SPR_BSPI,14,5,NULL,S_BSPI_RAISE3}, // S_BSPI_RAISE2
  {SPR_BSPI,13,5,NULL,S_BSPI_RAISE4}, // S_BSPI_RAISE3
  {SPR_BSPI,12,5,NULL,S_BSPI_RAISE5}, // S_BSPI_RAISE4
  {SPR_BSPI,11,5,NULL,S_BSPI_RAISE6}, // S_BSPI_RAISE5
  {SPR_BSPI,10,5,NULL,S_BSPI_RAISE7}, // S_BSPI_RAISE6
  {SPR_BSPI,9,5,NULL,S_BSPI_RUN1},  // S_BSPI_RAISE7
  {SPR_APLS,32768,5,NULL,S_ARACH_PLAZ2},  // S_ARACH_PLAZ
  {SPR_APLS,32769,5,NULL,S_ARACH_PLAZ}, // S_ARACH_PLAZ2
  {SPR_APBX,32768,5,NULL,S_ARACH_PLEX2},  // S_ARACH_PLEX
  {SPR_APBX,32769,5,NULL,S_ARACH_PLEX3},  // S_ARACH_PLEX2
  {SPR_APBX,32770,5,NULL,S_ARACH_PLEX4},  // S_ARACH_PLEX3
  {SPR_APBX,32771,5,NULL,S_ARACH_PLEX5},  // S_ARACH_PLEX4
  {SPR_APBX,32772,5,NULL,S_NULL}, // S_ARACH_PLEX5
  {SPR_CYBR,0,10,A_Look,S_CYBER_STND2}, // S_CYBER_STND
  {SPR_CYBR,1,10,A_Look,S_CYBER_STND},  // S_CYBER_STND2
  {SPR_CYBR,0,3,A_Hoof,S_CYBER_RUN2}, // S_CYBER_RUN1
  {SPR_CYBR,0,3,A_Chase,S_CYBER_RUN3},  // S_CYBER_RUN2
  {SPR_CYBR,1,3,A_Chase,S_CYBER_RUN4},  // S_CYBER_RUN3
  {SPR_CYBR,1,3,A_Chase,S_CYBER_RUN5},  // S_CYBER_RUN4
  {SPR_CYBR,2,3,A_Chase,S_CYBER_RUN6},  // S_CYBER_RUN5
  {SPR_CYBR,2,3,A_Chase,S_CYBER_RUN7},  // S_CYBER_RUN6
  {SPR_CYBR,3,3,A_Metal,S_CYBER_RUN8},  // S_CYBER_RUN7
  {SPR_CYBR,3,3,A_Chase,S_CYBER_RUN1},  // S_CYBER_RUN8
  {SPR_CYBR,4,6,A_FaceTarget,S_CYBER_ATK2}, // S_CYBER_ATK1
  {SPR_CYBR,5,12,A_CyberAttack,S_CYBER_ATK3}, // S_CYBER_ATK2
  {SPR_CYBR,4,12,A_FaceTarget,S_CYBER_ATK4},  // S_CYBER_ATK3
  {SPR_CYBR,5,12,A_CyberAttack,S_CYBER_ATK5}, // S_CYBER_ATK4
  {SPR_CYBR,4,12,A_FaceTarget,S_CYBER_ATK6},  // S_CYBER_ATK5
  {SPR_CYBR,5,12,A_CyberAttack,S_CYBER_RUN1}, // S_CYBER_ATK6
  {SPR_CYBR,6,10,A_Pain,S_CYBER_RUN1},  // S_CYBER_PAIN
  {SPR_CYBR,7,10,NULL,S_CYBER_DIE2},  // S_CYBER_DIE1
  {SPR_CYBR,8,10,A_Scream,S_CYBER_DIE3},  // S_CYBER_DIE2
  {SPR_CYBR,9,10,NULL,S_CYBER_DIE4},  // S_CYBER_DIE3
  {SPR_CYBR,10,10,NULL,S_CYBER_DIE5}, // S_CYBER_DIE4
  {SPR_CYBR,11,10,NULL,S_CYBER_DIE6}, // S_CYBER_DIE5
  {SPR_CYBR,12,10,A_Fall,S_CYBER_DIE7}, // S_CYBER_DIE6
  {SPR_CYBR,13,10,NULL,S_CYBER_DIE8}, // S_CYBER_DIE7
  {SPR_CYBR,14,10,NULL,S_CYBER_DIE9}, // S_CYBER_DIE8
  {SPR_CYBR,15,30,NULL,S_CYBER_DIE10},  // S_CYBER_DIE9
  {SPR_CYBR,15,-1,A_BossDeath,S_NULL},  // S_CYBER_DIE10
  {SPR_PAIN,0,10,A_Look,S_PAIN_STND}, // S_PAIN_STND
  {SPR_PAIN,0,3,A_Chase,S_PAIN_RUN2}, // S_PAIN_RUN1
  {SPR_PAIN,0,3,A_Chase,S_PAIN_RUN3}, // S_PAIN_RUN2
  {SPR_PAIN,1,3,A_Chase,S_PAIN_RUN4}, // S_PAIN_RUN3
  {SPR_PAIN,1,3,A_Chase,S_PAIN_RUN5}, // S_PAIN_RUN4
  {SPR_PAIN,2,3,A_Chase,S_PAIN_RUN6}, // S_PAIN_RUN5
  {SPR_PAIN,2,3,A_Chase,S_PAIN_RUN1}, // S_PAIN_RUN6
  {SPR_PAIN,3,5,A_FaceTarget,S_PAIN_ATK2},  // S_PAIN_ATK1
  {SPR_PAIN,4,5,A_FaceTarget,S_PAIN_ATK3},  // S_PAIN_ATK2
  {SPR_PAIN,32773,5,A_FaceTarget,S_PAIN_ATK4},  // S_PAIN_ATK3
  {SPR_PAIN,32773,0,A_PainAttack,S_PAIN_RUN1},  // S_PAIN_ATK4
  {SPR_PAIN,6,6,NULL,S_PAIN_PAIN2}, // S_PAIN_PAIN
  {SPR_PAIN,6,6,A_Pain,S_PAIN_RUN1},  // S_PAIN_PAIN2
  {SPR_PAIN,32775,8,NULL,S_PAIN_DIE2},  // S_PAIN_DIE1
  {SPR_PAIN,32776,8,A_Scream,S_PAIN_DIE3},  // S_PAIN_DIE2
  {SPR_PAIN,32777,8,NULL,S_PAIN_DIE4},  // S_PAIN_DIE3
  {SPR_PAIN,32778,8,NULL,S_PAIN_DIE5},  // S_PAIN_DIE4
  {SPR_PAIN,32779,8,A_PainDie,S_PAIN_DIE6}, // S_PAIN_DIE5
  {SPR_PAIN,32780,8,NULL,S_NULL}, // S_PAIN_DIE6
  {SPR_PAIN,12,8,NULL,S_PAIN_RAISE2}, // S_PAIN_RAISE1
  {SPR_PAIN,11,8,NULL,S_PAIN_RAISE3}, // S_PAIN_RAISE2
  {SPR_PAIN,10,8,NULL,S_PAIN_RAISE4}, // S_PAIN_RAISE3
  {SPR_PAIN,9,8,NULL,S_PAIN_RAISE5},  // S_PAIN_RAISE4
  {SPR_PAIN,8,8,NULL,S_PAIN_RAISE6},  // S_PAIN_RAISE5
  {SPR_PAIN,7,8,NULL,S_PAIN_RUN1},  // S_PAIN_RAISE6
  {SPR_SSWV,0,10,A_Look,S_SSWV_STND2},  // S_SSWV_STND
  {SPR_SSWV,1,10,A_Look,S_SSWV_STND}, // S_SSWV_STND2
  {SPR_SSWV,0,3,A_Chase,S_SSWV_RUN2}, // S_SSWV_RUN1
  {SPR_SSWV,0,3,A_Chase,S_SSWV_RUN3}, // S_SSWV_RUN2
  {SPR_SSWV,1,3,A_Chase,S_SSWV_RUN4}, // S_SSWV_RUN3
  {SPR_SSWV,1,3,A_Chase,S_SSWV_RUN5}, // S_SSWV_RUN4
  {SPR_SSWV,2,3,A_Chase,S_SSWV_RUN6}, // S_SSWV_RUN5
  {SPR_SSWV,2,3,A_Chase,S_SSWV_RUN7}, // S_SSWV_RUN6
  {SPR_SSWV,3,3,A_Chase,S_SSWV_RUN8}, // S_SSWV_RUN7
  {SPR_SSWV,3,3,A_Chase,S_SSWV_RUN1}, // S_SSWV_RUN8
  {SPR_SSWV,4,10,A_FaceTarget,S_SSWV_ATK2}, // S_SSWV_ATK1
  {SPR_SSWV,5,10,A_FaceTarget,S_SSWV_ATK3}, // S_SSWV_ATK2
  {SPR_SSWV,32774,4,A_CPosAttack,S_SSWV_ATK4},  // S_SSWV_ATK3
  {SPR_SSWV,5,6,A_FaceTarget,S_SSWV_ATK5},  // S_SSWV_ATK4
  {SPR_SSWV,32774,4,A_CPosAttack,S_SSWV_ATK6},  // S_SSWV_ATK5
  {SPR_SSWV,5,1,A_CPosRefire,S_SSWV_ATK2},  // S_SSWV_ATK6
  {SPR_SSWV,7,3,NULL,S_SSWV_PAIN2}, // S_SSWV_PAIN
  {SPR_SSWV,7,3,A_Pain,S_SSWV_RUN1},  // S_SSWV_PAIN2
  {SPR_SSWV,8,5,NULL,S_SSWV_DIE2},  // S_SSWV_DIE1
  {SPR_SSWV,9,5,A_Scream,S_SSWV_DIE3},  // S_SSWV_DIE2
  {SPR_SSWV,10,5,A_Fall,S_SSWV_DIE4}, // S_SSWV_DIE3
  {SPR_SSWV,11,5,NULL,S_SSWV_DIE5}, // S_SSWV_DIE4
  {SPR_SSWV,12,-1,NULL,S_NULL}, // S_SSWV_DIE5
  {SPR_SSWV,13,5,NULL,S_SSWV_XDIE2},  // S_SSWV_XDIE1
  {SPR_SSWV,14,5,A_XScream,S_SSWV_XDIE3}, // S_SSWV_XDIE2
  {SPR_SSWV,15,5,A_Fall,S_SSWV_XDIE4},  // S_SSWV_XDIE3
  {SPR_SSWV,16,5,NULL,S_SSWV_XDIE5},  // S_SSWV_XDIE4
  {SPR_SSWV,17,5,NULL,S_SSWV_XDIE6},  // S_SSWV_XDIE5
  {SPR_SSWV,18,5,NULL,S_SSWV_XDIE7},  // S_SSWV_XDIE6
  {SPR_SSWV,19,5,NULL,S_SSWV_XDIE8},  // S_SSWV_XDIE7
  {SPR_SSWV,20,5,NULL,S_SSWV_XDIE9},  // S_SSWV_XDIE8
  {SPR_SSWV,21,-1,NULL,S_NULL}, // S_SSWV_XDIE9
  {SPR_SSWV,12,5,NULL,S_SSWV_RAISE2}, // S_SSWV_RAISE1
  {SPR_SSWV,11,5,NULL,S_SSWV_RAISE3}, // S_SSWV_RAISE2
  {SPR_SSWV,10,5,NULL,S_SSWV_RAISE4}, // S_SSWV_RAISE3
  {SPR_SSWV,9,5,NULL,S_SSWV_RAISE5},  // S_SSWV_RAISE4
  {SPR_SSWV,8,5,NULL,S_SSWV_RUN1},  // S_SSWV_RAISE5
  {SPR_KEEN,0,-1,NULL,S_KEENSTND},  // S_KEENSTND
  {SPR_KEEN,0,6,NULL,S_COMMKEEN2},  // S_COMMKEEN
  {SPR_KEEN,1,6,NULL,S_COMMKEEN3},  // S_COMMKEEN2
  {SPR_KEEN,2,6,A_Scream,S_COMMKEEN4},  // S_COMMKEEN3
  {SPR_KEEN,3,6,NULL,S_COMMKEEN5},  // S_COMMKEEN4
  {SPR_KEEN,4,6,NULL,S_COMMKEEN6},  // S_COMMKEEN5
  {SPR_KEEN,5,6,NULL,S_COMMKEEN7},  // S_COMMKEEN6
  {SPR_KEEN,6,6,NULL,S_COMMKEEN8},  // S_COMMKEEN7
  {SPR_KEEN,7,6,NULL,S_COMMKEEN9},  // S_COMMKEEN8
  {SPR_KEEN,8,6,NULL,S_COMMKEEN10}, // S_COMMKEEN9
  {SPR_KEEN,9,6,NULL,S_COMMKEEN11}, // S_COMMKEEN10
  {SPR_KEEN,10,6,A_KeenDie,S_COMMKEEN12},// S_COMMKEEN11
  {SPR_KEEN,11,-1,NULL,S_NULL},   // S_COMMKEEN12
  {SPR_KEEN,12,4,NULL,S_KEENPAIN2}, // S_KEENPAIN
  {SPR_KEEN,12,8,A_Pain,S_KEENSTND},  // S_KEENPAIN2
  {SPR_BBRN,0,-1,NULL,S_NULL},    // S_BRAIN
  {SPR_BBRN,1,36,A_BrainPain,S_BRAIN},  // S_BRAIN_PAIN
  {SPR_BBRN,0,100,A_BrainScream,S_BRAIN_DIE2},  // S_BRAIN_DIE1
  {SPR_BBRN,0,10,NULL,S_BRAIN_DIE3},  // S_BRAIN_DIE2
  {SPR_BBRN,0,10,NULL,S_BRAIN_DIE4},  // S_BRAIN_DIE3
  {SPR_BBRN,0,-1,A_BrainDie,S_NULL},  // S_BRAIN_DIE4
  {SPR_SSWV,0,10,A_Look,S_BRAINEYE},  // S_BRAINEYE
  {SPR_SSWV,0,181,A_BrainAwake,S_BRAINEYE1},  // S_BRAINEYESEE
  {SPR_SSWV,0,150,A_BrainSpit,S_BRAINEYE1}, // S_BRAINEYE1
  {SPR_BOSF,32768,3,A_SpawnSound,S_SPAWN2}, // S_SPAWN1
  {SPR_BOSF,32769,3,A_SpawnFly,S_SPAWN3}, // S_SPAWN2
  {SPR_BOSF,32770,3,A_SpawnFly,S_SPAWN4}, // S_SPAWN3
  {SPR_BOSF,32771,3,A_SpawnFly,S_SPAWN1}, // S_SPAWN4
  {SPR_FIRE,32768,4,A_Fire,S_SPAWNFIRE2}, // S_SPAWNFIRE1
  {SPR_FIRE,32769,4,A_Fire,S_SPAWNFIRE3}, // S_SPAWNFIRE2
  {SPR_FIRE,32770,4,A_Fire,S_SPAWNFIRE4}, // S_SPAWNFIRE3
  {SPR_FIRE,32771,4,A_Fire,S_SPAWNFIRE5}, // S_SPAWNFIRE4
  {SPR_FIRE,32772,4,A_Fire,S_SPAWNFIRE6}, // S_SPAWNFIRE5
  {SPR_FIRE,32773,4,A_Fire,S_SPAWNFIRE7}, // S_SPAWNFIRE6
  {SPR_FIRE,32774,4,A_Fire,S_SPAWNFIRE8}, // S_SPAWNFIRE7
  {SPR_FIRE,32775,4,A_Fire,S_NULL},   // S_SPAWNFIRE8
  {SPR_MISL,32769,10,NULL,S_BRAINEXPLODE2}, // S_BRAINEXPLODE1
  {SPR_MISL,32770,10,NULL,S_BRAINEXPLODE3}, // S_BRAINEXPLODE2
  {SPR_MISL,32771,10,A_BrainExplode,S_NULL},  // S_BRAINEXPLODE3
  {SPR_ARM1,0,6,NULL,S_ARM1A},  // S_ARM1
  {SPR_ARM1,32769,7,NULL,S_ARM1}, // S_ARM1A
  {SPR_ARM2,0,6,NULL,S_ARM2A},  // S_ARM2
  {SPR_ARM2,32769,6,NULL,S_ARM2}, // S_ARM2A
  {SPR_BAR1,0,6,NULL,S_BAR2}, // S_BAR1
  {SPR_BAR1,1,6,NULL,S_BAR1}, // S_BAR2
  {SPR_BEXP,32768,5,NULL,S_BEXP2},  // S_BEXP
  {SPR_BEXP,32769,5,A_Scream,S_BEXP3},  // S_BEXP2
  {SPR_BEXP,32770,5,NULL,S_BEXP4},  // S_BEXP3
  {SPR_BEXP,32771,10,A_Explode,S_BEXP5},  // S_BEXP4
  {SPR_BEXP,32772,10,NULL,S_NULL},  // S_BEXP5
  {SPR_FCAN,32768,4,NULL,S_BBAR2},  // S_BBAR1
  {SPR_FCAN,32769,4,NULL,S_BBAR3},  // S_BBAR2
  {SPR_FCAN,32770,4,NULL,S_BBAR1},  // S_BBAR3
  {SPR_BON1,0,6,NULL,S_BON1A},  // S_BON1
  {SPR_BON1,1,6,NULL,S_BON1B},  // S_BON1A
  {SPR_BON1,2,6,NULL,S_BON1C},  // S_BON1B
  {SPR_BON1,3,6,NULL,S_BON1D},  // S_BON1C
  {SPR_BON1,2,6,NULL,S_BON1E},  // S_BON1D
  {SPR_BON1,1,6,NULL,S_BON1}, // S_BON1E
  {SPR_BON2,0,6,NULL,S_BON2A},  // S_BON2
  {SPR_BON2,1,6,NULL,S_BON2B},  // S_BON2A
  {SPR_BON2,2,6,NULL,S_BON2C},  // S_BON2B
  {SPR_BON2,3,6,NULL,S_BON2D},  // S_BON2C
  {SPR_BON2,2,6,NULL,S_BON2E},  // S_BON2D
  {SPR_BON2,1,6,NULL,S_BON2}, // S_BON2E
  {SPR_BKEY,0,10,NULL,S_BKEY2}, // S_BKEY
  {SPR_BKEY,32769,10,NULL,S_BKEY},  // S_BKEY2
  {SPR_RKEY,0,10,NULL,S_RKEY2}, // S_RKEY
  {SPR_RKEY,32769,10,NULL,S_RKEY},  // S_RKEY2
  {SPR_YKEY,0,10,NULL,S_YKEY2}, // S_YKEY
  {SPR_YKEY,32769,10,NULL,S_YKEY},  // S_YKEY2
  {SPR_BSKU,0,10,NULL,S_BSKULL2}, // S_BSKULL
  {SPR_BSKU,32769,10,NULL,S_BSKULL},  // S_BSKULL2
  {SPR_RSKU,0,10,NULL,S_RSKULL2}, // S_RSKULL
  {SPR_RSKU,32769,10,NULL,S_RSKULL},  // S_RSKULL2
  {SPR_YSKU,0,10,NULL,S_YSKULL2}, // S_YSKULL
  {SPR_YSKU,32769,10,NULL,S_YSKULL},  // S_YSKULL2
  {SPR_STIM,0,-1,NULL,S_NULL},  // S_STIM
  {SPR_MEDI,0,-1,NULL,S_NULL},  // S_MEDI
  {SPR_SOUL,32768,6,NULL,S_SOUL2},  // S_SOUL
  {SPR_SOUL,32769,6,NULL,S_SOUL3},  // S_SOUL2
  {SPR_SOUL,32770,6,NULL,S_SOUL4},  // S_SOUL3
  {SPR_SOUL,32771,6,NULL,S_SOUL5},  // S_SOUL4
  {SPR_SOUL,32770,6,NULL,S_SOUL6},  // S_SOUL5
  {SPR_SOUL,32769,6,NULL,S_SOUL}, // S_SOUL6
  {SPR_PINV,32768,6,NULL,S_PINV2},  // S_PINV
  {SPR_PINV,32769,6,NULL,S_PINV3},  // S_PINV2
  {SPR_PINV,32770,6,NULL,S_PINV4},  // S_PINV3
  {SPR_PINV,32771,6,NULL,S_PINV}, // S_PINV4
  {SPR_PSTR,32768,-1,NULL,S_NULL},  // S_PSTR
  {SPR_PINS,32768,6,NULL,S_PINS2},  // S_PINS
  {SPR_PINS,32769,6,NULL,S_PINS3},  // S_PINS2
  {SPR_PINS,32770,6,NULL,S_PINS4},  // S_PINS3
  {SPR_PINS,32771,6,NULL,S_PINS}, // S_PINS4
  {SPR_MEGA,32768,6,NULL,S_MEGA2},  // S_MEGA
  {SPR_MEGA,32769,6,NULL,S_MEGA3},  // S_MEGA2
  {SPR_MEGA,32770,6,NULL,S_MEGA4},  // S_MEGA3
  {SPR_MEGA,32771,6,NULL,S_MEGA}, // S_MEGA4
  {SPR_SUIT,32768,-1,NULL,S_NULL},  // S_SUIT
  {SPR_PMAP,32768,6,NULL,S_PMAP2},  // S_PMAP
  {SPR_PMAP,32769,6,NULL,S_PMAP3},  // S_PMAP2
  {SPR_PMAP,32770,6,NULL,S_PMAP4},  // S_PMAP3
  {SPR_PMAP,32771,6,NULL,S_PMAP5},  // S_PMAP4
  {SPR_PMAP,32770,6,NULL,S_PMAP6},  // S_PMAP5
  {SPR_PMAP,32769,6,NULL,S_PMAP}, // S_PMAP6
  {SPR_PVIS,32768,6,NULL,S_PVIS2},  // S_PVIS
  {SPR_PVIS,1,6,NULL,S_PVIS}, // S_PVIS2
  {SPR_CLIP,0,-1,NULL,S_NULL},  // S_CLIP
  {SPR_AMMO,0,-1,NULL,S_NULL},  // S_AMMO
  {SPR_ROCK,0,-1,NULL,S_NULL},  // S_ROCK
  {SPR_BROK,0,-1,NULL,S_NULL},  // S_BROK
  {SPR_CELL,0,-1,NULL,S_NULL},  // S_CELL
  {SPR_CELP,0,-1,NULL,S_NULL},  // S_CELP
  {SPR_SHEL,0,-1,NULL,S_NULL},  // S_SHEL
  {SPR_SBOX,0,-1,NULL,S_NULL},  // S_SBOX
  {SPR_BPAK,0,-1,NULL,S_NULL},  // S_BPAK
  {SPR_BFUG,0,-1,NULL,S_NULL},  // S_BFUG
  {SPR_MGUN,0,-1,NULL,S_NULL},  // S_MGUN
  {SPR_CSAW,0,-1,NULL,S_NULL},  // S_CSAW
  {SPR_LAUN,0,-1,NULL,S_NULL},  // S_LAUN
  {SPR_PLAS,0,-1,NULL,S_NULL},  // S_PLAS
  {SPR_SHOT,0,-1,NULL,S_NULL},  // S_SHOT
  {SPR_SGN2,0,-1,NULL,S_NULL},  // S_SHOT2
  {SPR_COLU,32768,-1,NULL,S_NULL},  // S_COLU
  {SPR_SMT2,0,-1,NULL,S_NULL},  // S_STALAG
  {SPR_GOR1,0,10,NULL,S_BLOODYTWITCH2}, // S_BLOODYTWITCH
  {SPR_GOR1,1,15,NULL,S_BLOODYTWITCH3}, // S_BLOODYTWITCH2
  {SPR_GOR1,2,8,NULL,S_BLOODYTWITCH4},  // S_BLOODYTWITCH3
  {SPR_GOR1,1,6,NULL,S_BLOODYTWITCH}, // S_BLOODYTWITCH4
  {SPR_PLAY,13,-1,NULL,S_NULL}, // S_DEADTORSO
  {SPR_PLAY,18,-1,NULL,S_NULL}, // S_DEADBOTTOM
  {SPR_POL2,0,-1,NULL,S_NULL},  // S_HEADSONSTICK
  {SPR_POL5,0,-1,NULL,S_NULL},  // S_GIBS
  {SPR_POL4,0,-1,NULL,S_NULL},  // S_HEADONASTICK
  {SPR_POL3,32768,6,NULL,S_HEADCANDLES2}, // S_HEADCANDLES
  {SPR_POL3,32769,6,NULL,S_HEADCANDLES},  // S_HEADCANDLES2
  {SPR_POL1,0,-1,NULL,S_NULL},  // S_DEADSTICK
  {SPR_POL6,0,6,NULL,S_LIVESTICK2}, // S_LIVESTICK
  {SPR_POL6,1,8,NULL,S_LIVESTICK},  // S_LIVESTICK2
  {SPR_GOR2,0,-1,NULL,S_NULL},  // S_MEAT2
  {SPR_GOR3,0,-1,NULL,S_NULL},  // S_MEAT3
  {SPR_GOR4,0,-1,NULL,S_NULL},  // S_MEAT4
  {SPR_GOR5,0,-1,NULL,S_NULL},  // S_MEAT5
  {SPR_SMIT,0,-1,NULL,S_NULL},  // S_STALAGTITE
  {SPR_COL1,0,-1,NULL,S_NULL},  // S_TALLGRNCOL
  {SPR_COL2,0,-1,NULL,S_NULL},  // S_SHRTGRNCOL
  {SPR_COL3,0,-1,NULL,S_NULL},  // S_TALLREDCOL
  {SPR_COL4,0,-1,NULL,S_NULL},  // S_SHRTREDCOL
  {SPR_CAND,32768,-1,NULL,S_NULL},  // S_CANDLESTIK
  {SPR_CBRA,32768,-1,NULL,S_NULL},  // S_CANDELABRA
  {SPR_COL6,0,-1,NULL,S_NULL},  // S_SKULLCOL
  {SPR_TRE1,0,-1,NULL,S_NULL},  // S_TORCHTREE
  {SPR_TRE2,0,-1,NULL,S_NULL},  // S_BIGTREE
  {SPR_ELEC,0,-1,NULL,S_NULL},  // S_TECHPILLAR
  {SPR_CEYE,32768,6,NULL,S_EVILEYE2}, // S_EVILEYE
  {SPR_CEYE,32769,6,NULL,S_EVILEYE3}, // S_EVILEYE2
  {SPR_CEYE,32770,6,NULL,S_EVILEYE4}, // S_EVILEYE3
  {SPR_CEYE,32769,6,NULL,S_EVILEYE},  // S_EVILEYE4
  {SPR_FSKU,32768,6,NULL,S_FLOATSKULL2},  // S_FLOATSKULL
  {SPR_FSKU,32769,6,NULL,S_FLOATSKULL3},  // S_FLOATSKULL2
  {SPR_FSKU,32770,6,NULL,S_FLOATSKULL}, // S_FLOATSKULL3
  {SPR_COL5,0,14,NULL,S_HEARTCOL2}, // S_HEARTCOL
  {SPR_COL5,1,14,NULL,S_HEARTCOL},  // S_HEARTCOL2
  {SPR_TBLU,32768,4,NULL,S_BLUETORCH2}, // S_BLUETORCH
  {SPR_TBLU,32769,4,NULL,S_BLUETORCH3}, // S_BLUETORCH2
  {SPR_TBLU,32770,4,NULL,S_BLUETORCH4}, // S_BLUETORCH3
  {SPR_TBLU,32771,4,NULL,S_BLUETORCH},  // S_BLUETORCH4
  {SPR_TGRN,32768,4,NULL,S_GREENTORCH2},  // S_GREENTORCH
  {SPR_TGRN,32769,4,NULL,S_GREENTORCH3},  // S_GREENTORCH2
  {SPR_TGRN,32770,4,NULL,S_GREENTORCH4},  // S_GREENTORCH3
  {SPR_TGRN,32771,4,NULL,S_GREENTORCH}, // S_GREENTORCH4
  {SPR_TRED,32768,4,NULL,S_REDTORCH2},  // S_REDTORCH
  {SPR_TRED,32769,4,NULL,S_REDTORCH3},  // S_REDTORCH2
  {SPR_TRED,32770,4,NULL,S_REDTORCH4},  // S_REDTORCH3
  {SPR_TRED,32771,4,NULL,S_REDTORCH}, // S_REDTORCH4
  {SPR_SMBT,32768,4,NULL,S_BTORCHSHRT2},  // S_BTORCHSHRT
  {SPR_SMBT,32769,4,NULL,S_BTORCHSHRT3},  // S_BTORCHSHRT2
  {SPR_SMBT,32770,4,NULL,S_BTORCHSHRT4},  // S_BTORCHSHRT3
  {SPR_SMBT,32771,4,NULL,S_BTORCHSHRT}, // S_BTORCHSHRT4
  {SPR_SMGT,32768,4,NULL,S_GTORCHSHRT2},  // S_GTORCHSHRT
  {SPR_SMGT,32769,4,NULL,S_GTORCHSHRT3},  // S_GTORCHSHRT2
  {SPR_SMGT,32770,4,NULL,S_GTORCHSHRT4},  // S_GTORCHSHRT3
  {SPR_SMGT,32771,4,NULL,S_GTORCHSHRT}, // S_GTORCHSHRT4
  {SPR_SMRT,32768,4,NULL,S_RTORCHSHRT2},  // S_RTORCHSHRT
  {SPR_SMRT,32769,4,NULL,S_RTORCHSHRT3},  // S_RTORCHSHRT2
  {SPR_SMRT,32770,4,NULL,S_RTORCHSHRT4},  // S_RTORCHSHRT3
  {SPR_SMRT,32771,4,NULL,S_RTORCHSHRT}, // S_RTORCHSHRT4
  {SPR_HDB1,0,-1,NULL,S_NULL},  // S_HANGNOGUTS
  {SPR_HDB2,0,-1,NULL,S_NULL},  // S_HANGBNOBRAIN
  {SPR_HDB3,0,-1,NULL,S_NULL},  // S_HANGTLOOKDN
  {SPR_HDB4,0,-1,NULL,S_NULL},  // S_HANGTSKULL
  {SPR_HDB5,0,-1,NULL,S_NULL},  // S_HANGTLOOKUP
  {SPR_HDB6,0,-1,NULL,S_NULL},  // S_HANGTNOBRAIN
  {SPR_POB1,0,-1,NULL,S_NULL},  // S_COLONGIBS
  {SPR_POB2,0,-1,NULL,S_NULL},  // S_SMALLPOOL
  {SPR_BRS1,0,-1,NULL,S_NULL},    // S_BRAINSTEM
  {SPR_TLMP,32768,4,NULL,S_TECHLAMP2},  // S_TECHLAMP
  {SPR_TLMP,32769,4,NULL,S_TECHLAMP3},  // S_TECHLAMP2
  {SPR_TLMP,32770,4,NULL,S_TECHLAMP4},  // S_TECHLAMP3
  {SPR_TLMP,32771,4,NULL,S_TECHLAMP},   // S_TECHLAMP4
  {SPR_TLP2,32768,4,NULL,S_TECH2LAMP2}, // S_TECH2LAMP
  {SPR_TLP2,32769,4,NULL,S_TECH2LAMP3}, // S_TECH2LAMP2
  {SPR_TLP2,32770,4,NULL,S_TECH2LAMP4}, // S_TECH2LAMP3
  {SPR_TLP2,32771,4,NULL,S_TECH2LAMP},  // S_TECH2LAMP4

  {SPR_TNT1,0,-1,NULL,S_TNT1},          // S_TNT1    // phares 3/8/98

  // killough 8/9/98: grenade
  {SPR_MISL,32768,1000,A_Die,S_GRENADE},      // S_GRENADE

  // killough 8/10/98: variable damage explosion
  {SPR_MISL,32769,4,A_Scream,S_DETONATE2},    // S_DETONATE
  {SPR_MISL,32770,6,A_Detonate,S_DETONATE3},  // S_DETONATE2
  {SPR_MISL,32771,10,NULL,S_NULL},            // S_DETONATE3

#ifdef DOGS
  // killough 7/19/98: Marine's best friend :)
  {SPR_DOGS,0,10,A_Look,S_DOGS_STND2},  // S_DOGS_STND
  {SPR_DOGS,1,10,A_Look,S_DOGS_STND}, // S_DOGS_STND2
  {SPR_DOGS,0,2,A_Chase,S_DOGS_RUN2}, // S_DOGS_RUN1
  {SPR_DOGS,0,2,A_Chase,S_DOGS_RUN3}, // S_DOGS_RUN2
  {SPR_DOGS,1,2,A_Chase,S_DOGS_RUN4}, // S_DOGS_RUN3
  {SPR_DOGS,1,2,A_Chase,S_DOGS_RUN5}, // S_DOGS_RUN4
  {SPR_DOGS,2,2,A_Chase,S_DOGS_RUN6}, // S_DOGS_RUN5
  {SPR_DOGS,2,2,A_Chase,S_DOGS_RUN7}, // S_DOGS_RUN6
  {SPR_DOGS,3,2,A_Chase,S_DOGS_RUN8}, // S_DOGS_RUN7
  {SPR_DOGS,3,2,A_Chase,S_DOGS_RUN1}, // S_DOGS_RUN8
  {SPR_DOGS,4,8,A_FaceTarget,S_DOGS_ATK2},  // S_DOGS_ATK1
  {SPR_DOGS,5,8,A_FaceTarget,S_DOGS_ATK3},  // S_DOGS_ATK2
  {SPR_DOGS,6,8,A_SargAttack,S_DOGS_RUN1},  // S_DOGS_ATK3
  {SPR_DOGS,7,2,NULL,S_DOGS_PAIN2}, // S_DOGS_PAIN
  {SPR_DOGS,7,2,A_Pain,S_DOGS_RUN1},  // S_DOGS_PAIN2
  {SPR_DOGS,8,8,NULL,S_DOGS_DIE2},  // S_DOGS_DIE1
  {SPR_DOGS,9,8,A_Scream,S_DOGS_DIE3},  // S_DOGS_DIE2
  {SPR_DOGS,10,4,NULL,S_DOGS_DIE4}, // S_DOGS_DIE3
  {SPR_DOGS,11,4,A_Fall,S_DOGS_DIE5}, // S_DOGS_DIE4
  {SPR_DOGS,12,4,NULL,S_DOGS_DIE6}, // S_DOGS_DIE5
  {SPR_DOGS,13,-1,NULL,S_NULL}, // S_DOGS_DIE6
  {SPR_DOGS,13,5,NULL,S_DOGS_RAISE2}, // S_DOGS_RAISE1
  {SPR_DOGS,12,5,NULL,S_DOGS_RAISE3}, // S_DOGS_RAISE2
  {SPR_DOGS,11,5,NULL,S_DOGS_RAISE4}, // S_DOGS_RAISE3
  {SPR_DOGS,10,5,NULL,S_DOGS_RAISE5}, // S_DOGS_RAISE4
  {SPR_DOGS,9,5,NULL,S_DOGS_RAISE6},  // S_DOGS_RAISE5
  {SPR_DOGS,8,5,NULL,S_DOGS_RUN1},  // S_DOGS_RAISE6
#endif

#ifdef BETA
  // killough 7/11/98: beta BFG begins here
  // S_OLDBFG1

#define BFGDELAY 1
#define OLDBFG_1FRAMES(x) {SPR_BFGG,1,BFGDELAY,A_FireOldBFG,x+S_OLDBFG1+2},
#define OLDBFG_2FRAMES(x) OLDBFG_1FRAMES(x) OLDBFG_1FRAMES(x+1)
#define OLDBFG_4FRAMES(x) OLDBFG_2FRAMES(x) OLDBFG_2FRAMES(x+2)
#define OLDBFG_8FRAMES(x) OLDBFG_4FRAMES(x) OLDBFG_4FRAMES(x+4)
  {SPR_BFGG,0,10,A_BFGsound,S_OLDBFG1+1},  // S_OLDBFG1

  OLDBFG_8FRAMES(0)
  OLDBFG_8FRAMES(8)
  OLDBFG_8FRAMES(16) 
  OLDBFG_8FRAMES(24)
  OLDBFG_8FRAMES(32)

  {SPR_BFGG,1,0,A_Light0,S_OLDBFG43}, // S_OLDBFG42
  {SPR_BFGG,1,20,A_ReFire,S_BFG},   // S_OLDBFG43

  // killough 7/11/98: end of beta BFG

  // killough 7/19/98: First plasma fireball in the beta:
  {SPR_PLS1,32768,6,NULL,S_PLS1BALL2},  // S_PLS1BALL
  {SPR_PLS1,32769,6,NULL,S_PLS1BALL}, // S_PLS1BALL2
  {SPR_PLS1,32770,4,NULL,S_PLS1EXP2}, // S_PLS1EXP
  {SPR_PLS1,32771,4,NULL,S_PLS1EXP3}, // S_PLS1EXP2
  {SPR_PLS1,32772,4,NULL,S_PLS1EXP4}, // S_PLS1EXP3
  {SPR_PLS1,32773,4,NULL,S_PLS1EXP5}, // S_PLS1EXP4
  {SPR_PLS1,32774,4,NULL,S_NULL}, // S_PLS1EXP5

  // killough 7/19/98: Second plasma fireball in the beta:
  {SPR_PLS2,32768,4,NULL,S_PLS2BALL2}, // S_PLS2BALL
  {SPR_PLS2,32769,4,NULL,S_PLS2BALL},  // S_PLS2BALL2
  {SPR_PLS2,32770,6,NULL,S_PLS2BALLX2},  // S_PLS2BALLX1
  {SPR_PLS2,32771,6,NULL,S_PLS2BALLX3},  // S_PLS2BALLX2
  {SPR_PLS2,32772,6,NULL,S_NULL}, // S_PLS2BALLX3

  {SPR_BON3,0,6,NULL,S_BON3},           // S_BON3  // killough 7/11/98:
  {SPR_BON4,0,6,NULL,S_BON4},           // S_BON4  // beta bonus items

  // killough 10/98: beta lost souls attacked from a distance, 
  // animated with colors, and stayed in the air when killed.
  // This is an approximation, but I'm sure it can be improved.

  // spawnstate
  {SPR_SKUL,0,10,A_Look,S_BSKUL_STND},  // S_BSKUL_STND

  // chasestate
  {SPR_SKUL,1,5,A_Chase,S_BSKUL_RUN2},  // S_BSKUL_RUN1
  {SPR_SKUL,2,5,A_Chase,S_BSKUL_RUN3},  // S_BSKUL_RUN2
  {SPR_SKUL,3,5,A_Chase,S_BSKUL_RUN4},  // S_BSKUL_RUN3
  {SPR_SKUL,0,5,A_Chase,S_BSKUL_RUN1},  // S_BSKUL_RUN4

  // missilestate
  {SPR_SKUL,4,4,A_FaceTarget,S_BSKUL_ATK2},     // S_BSKUL_ATK1
  {SPR_SKUL,5,5,A_BetaSkullAttack,S_BSKUL_ATK3}, // S_BSKUL_ATK2
  {SPR_SKUL,5,4,NULL,S_BSKUL_RUN1},              // S_BSKUL_ATK3

  // painstate
  {SPR_SKUL,6,4,NULL,S_BSKUL_PAIN2},     // S_BSKUL_PAIN1
  {SPR_SKUL,7,2,A_Pain,S_BSKUL_RUN1},   // S_BSKUL_PAIN2
  {SPR_SKUL,8,4,NULL,S_BSKUL_RUN1},      // S_BSKUL_PAIN3

  // deathstate
  {SPR_SKUL, 9,5,NULL,S_BSKUL_DIE2},     // S_BSKUL_DIE1
  {SPR_SKUL,10,5,NULL,S_BSKUL_DIE3},     // S_BSKUL_DIE2
  {SPR_SKUL,11,5,NULL,S_BSKUL_DIE4},     // S_BSKUL_DIE3
  {SPR_SKUL,12,5,NULL,S_BSKUL_DIE5},     // S_BSKUL_DIE4
  {SPR_SKUL,13,5,A_Scream,S_BSKUL_DIE6}, // S_BSKUL_DIE5
  {SPR_SKUL,14,5,NULL,S_BSKUL_DIE7},     // S_BSKUL_DIE6
  {SPR_SKUL,15,5,A_Fall,S_BSKUL_DIE8},   // S_BSKUL_DIE7
  {SPR_SKUL,16,5,A_Stop,S_BSKUL_DIE8},   // S_BSKUL_DIE8

#endif

  // killough 10/98: mushroom effect
  {SPR_MISL,32769,8,A_Mushroom,S_EXPLODE2},  // S_MUSHROOM
};

// ********************************************************************
// Object "Thing" definitions
// ********************************************************************
// Now we get to the actual objects and their characteristics.  If
// you've seen Dehacked, much of this is where the Bits are set,
// commented below as "flags", as well as where you wire in which
// frames are the beginning frames for near and far attack, death,
// and such.  Sounds are hooked in here too, as well as how much
// mass, speed and so forth a Thing has.  Everything you ever wanted
// to know...
//
// Like all this other stuff, the MT_* entries are enumerated in info.h
//
// Note that these are all just indices of the elements involved, and
// not real pointers to them.  For example, the player's death sequence
// is S_PLAY_DIE1, which just evaluates to the index in the states[]
// array above, which actually knows what happens then and what the
// sprite looks like, if it makes noise or not, etc.
//
// Additional comments about each of the entries are located in info.h
// next to the mobjinfo_t structure definition.
//
// This goes on for the next 3000+ lines...

mobjinfo_t mobjinfo[NUMMOBJTYPES] = {
  {   // MT_PLAYER
    -1,   // doomednum
    S_PLAY,   // spawnstate
    100,    // spawnhealth
    S_PLAY_RUN1,    // seestate
    sfx_None,   // seesound
    0,    // reactiontime
    sfx_None,   // attacksound
    S_PLAY_PAIN,    // painstate
    255,    // painchance
    sfx_plpain,   // painsound
    S_NULL,   // meleestate
    S_PLAY_ATK1,    // missilestate
    S_PLAY_DIE1,    // deathstate
    S_PLAY_XDIE1,   // xdeathstate
    sfx_pldeth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH,  // flags // killough 7/18/98
    S_NULL    // raisestate
  },
  
  {   // MT_POSSESSED
    3004,   // doomednum
    S_POSS_STND,    // spawnstate
    20,   // spawnhealth
    S_POSS_RUN1,    // seestate
    sfx_posit1,   // seesound
    8,    // reactiontime
    sfx_pistol,   // attacksound
    S_POSS_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_POSS_ATK1,    // missilestate
    S_POSS_DIE1,    // deathstate
    S_POSS_XDIE1,   // xdeathstate
    sfx_podth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_POSS_RAISE1   // raisestate
  },
  
  {   // MT_SHOTGUY
    9,    // doomednum
    S_SPOS_STND,    // spawnstate
    30,   // spawnhealth
    S_SPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SPOS_ATK1,    // missilestate
    S_SPOS_DIE1,    // deathstate
    S_SPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_SPOS_RAISE1   // raisestate
  },
  
  {   // MT_VILE
    64,   // doomednum
    S_VILE_STND,    // spawnstate
    700,    // spawnhealth
    S_VILE_RUN1,    // seestate
    sfx_vilsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_VILE_PAIN,    // painstate
    10,   // painchance
    sfx_vipain,   // painsound
    0,    // meleestate
    S_VILE_ATK1,    // missilestate
    S_VILE_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_vildth,   // deathsound
    15,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_vilact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_FIRE
    -1,   // doomednum
    S_FIRE1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_UNDEAD
    66,   // doomednum
    S_SKEL_STND,    // spawnstate
    300,    // spawnhealth
    S_SKEL_RUN1,    // seestate
    sfx_skesit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SKEL_PAIN,    // painstate
    100,    // painchance
    sfx_popain,   // painsound
    S_SKEL_FIST1,   // meleestate
    S_SKEL_MISS1,   // missilestate
    S_SKEL_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_skedth,   // deathsound
    10,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_skeact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,  // flags
    S_SKEL_RAISE1   // raisestate
  },
  
  {   // MT_TRACER
    -1,   // doomednum
    S_TRACER,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_skeatk,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TRACEEXP1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    10*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    10,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SMOKE
    -1,   // doomednum
    S_SMOKE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_FATSO
    67,   // doomednum
    S_FATT_STND,    // spawnstate
    600,    // spawnhealth
    S_FATT_RUN1,    // seestate
    sfx_mansit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_FATT_PAIN,    // painstate
    80,   // painchance
    sfx_mnpain,   // painsound
    0,    // meleestate
    S_FATT_ATK1,    // missilestate
    S_FATT_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_mandth,   // deathsound
    8,    // speed
    48*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_FATT_RAISE1   // raisestate
  },
  
  {   // MT_FATSHOT
    -1,   // doomednum
    S_FATSHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_FATSHOTX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    20*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags \\ killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUY
    65,   // doomednum
    S_CPOS_STND,    // spawnstate
    70,   // spawnhealth
    S_CPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_CPOS_ATK1,    // missilestate
    S_CPOS_DIE1,    // deathstate
    S_CPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_CPOS_RAISE1   // raisestate
  },
  
  {   // MT_TROOP
    3001,   // doomednum
    S_TROO_STND,    // spawnstate
    60,   // spawnhealth
    S_TROO_RUN1,    // seestate
    sfx_bgsit1,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_TROO_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    S_TROO_ATK1,    // meleestate
    S_TROO_ATK1,    // missilestate
    S_TROO_DIE1,    // deathstate
    S_TROO_XDIE1,   // xdeathstate
    sfx_bgdth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_bgact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_TROO_RAISE1   // raisestate
  },
  
  {   // MT_SERGEANT
    3002,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_SHADOWS
    58,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_SHADOW|MF_COUNTKILL,   // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_HEAD
    3005,   // doomednum
    S_HEAD_STND,    // spawnstate
    400,    // spawnhealth
    S_HEAD_RUN1,    // seestate
    sfx_cacsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_HEAD_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_HEAD_ATK1,    // missilestate
    S_HEAD_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_cacdth,   // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_HEAD_RAISE1   // raisestate
  },
  
  {   // MT_BRUISER
    3003,   // doomednum
    S_BOSS_STND,    // spawnstate
    1000,   // spawnhealth
    S_BOSS_RUN1,    // seestate
    sfx_brssit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOSS_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOSS_ATK1,    // meleestate
    S_BOSS_ATK1,    // missilestate
    S_BOSS_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_brsdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOSS_RAISE1   // raisestate
  },
  
  {   // MT_BRUISERSHOT
    -1,   // doomednum
    S_BRBALL1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRBALLX1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    15*FRACUNIT,   // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_KNIGHT
    69,   // doomednum
    S_BOS2_STND,    // spawnstate
    500,    // spawnhealth
    S_BOS2_RUN1,    // seestate
    sfx_kntsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOS2_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOS2_ATK1,    // meleestate
    S_BOS2_ATK1,    // missilestate
    S_BOS2_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_kntdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOS2_RAISE1   // raisestate
  },

  {   // MT_SKULL
    3006,   // doomednum
    S_SKULL_STND,   // spawnstate
    100,    // spawnhealth
    S_SKULL_RUN1,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_sklatk,   // attacksound
    S_SKULL_PAIN,   // painstate
    256,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SKULL_ATK1,   // missilestate
    S_SKULL_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    8,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    50,   // mass
    3,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPIDER
    7,    // doomednum
    S_SPID_STND,    // spawnstate
    3000,   // spawnhealth
    S_SPID_RUN1,    // seestate
    sfx_spisit,   // seesound
    8,    // reactiontime
    sfx_shotgn,   // attacksound
    S_SPID_PAIN,    // painstate
    40,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SPID_ATK1,    // missilestate
    S_SPID_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_spidth,   // deathsound
    12,   // speed
    128*FRACUNIT,   // radius
    100*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BABY
    68,   // doomednum
    S_BSPI_STND,    // spawnstate
    500,    // spawnhealth
    S_BSPI_SIGHT,   // seestate
    sfx_bspsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BSPI_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_BSPI_ATK1,    // missilestate
    S_BSPI_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_bspdth,   // deathsound
    12,   // speed
    64*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    600,    // mass
    0,    // damage
    sfx_bspact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BSPI_RAISE1   // raisestate
  },
  
  {   // MT_CYBORG
    16,   // doomednum
    S_CYBER_STND,   // spawnstate
    4000,   // spawnhealth
    S_CYBER_RUN1,   // seestate
    sfx_cybsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CYBER_PAIN,   // painstate
    20,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_CYBER_ATK1,   // missilestate
    S_CYBER_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_cybdth,   // deathsound
    16,   // speed
    40*FRACUNIT,    // radius
    110*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_PAIN
    71,   // doomednum
    S_PAIN_STND,    // spawnstate
    400,    // spawnhealth
    S_PAIN_RUN1,    // seestate
    sfx_pesit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_PAIN_PAIN,    // painstate
    128,    // painchance
    sfx_pepain,   // painsound
    0,    // meleestate
    S_PAIN_ATK1,    // missilestate
    S_PAIN_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_pedth,    // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_PAIN_RAISE1   // raisestate
  },
  
  {   // MT_WOLFSS
    84,   // doomednum
    S_SSWV_STND,    // spawnstate
    50,   // spawnhealth
    S_SSWV_RUN1,    // seestate
    sfx_sssit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SSWV_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SSWV_ATK1,    // missilestate
    S_SSWV_DIE1,    // deathstate
    S_SSWV_XDIE1,   // xdeathstate
    sfx_ssdth,    // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_SSWV_RAISE1   // raisestate
  },
  
  {   // MT_KEEN
    72,   // doomednum
    S_KEENSTND,   // spawnstate
    100,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_KEENPAIN,   // painstate
    256,    // painchance
    sfx_keenpn,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_COMMKEEN,   // deathstate
    S_NULL,   // xdeathstate
    sfx_keendt,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    72*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY|MF_SHOOTABLE|MF_COUNTKILL,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSBRAIN
    88,   // doomednum
    S_BRAIN,    // spawnstate
    250,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_BRAIN_PAIN,   // painstate
    255,    // painchance
    sfx_bospn,    // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRAIN_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_bosdth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSSPIT
    89,   // doomednum
    S_BRAINEYE,   // spawnstate
    1000,   // spawnhealth
    S_BRAINEYESEE,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSTARGET
    87,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNSHOT
    -1,   // doomednum
    S_SPAWN1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_bospit,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    32*FRACUNIT,    // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_NOCLIP,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNFIRE
    -1,   // doomednum
    S_SPAWNFIRE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BARREL
    2035,   // doomednum
    S_BAR1,   // spawnstate
    20,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BEXP,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    42*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TROOPSHOT
    -1,   // doomednum
    S_TBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_HEADSHOT
    -1,   // doomednum
    S_RBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_RBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_ROCKET
    -1,   // doomednum
    S_ROCKET,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rlaunc,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_EXPLODE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    20*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    20,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_PLASMA
    -1,   // doomednum
    S_PLASBALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLASEXP,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BFG
    -1,   // doomednum
    S_BFGSHOT,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BFGLAND,    // deathstate
    S_NULL,   // xdeathstate
    sfx_rxplod,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    100,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_ARACHPLAZ
    -1,   // doomednum
    S_ARACH_PLAZ,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ARACH_PLEX,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_PUFF
    -1,   // doomednum
    S_PUFF1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BLOOD
    -1,   // doomednum
    S_BLOOD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TFOG
    -1,   // doomednum
    S_TFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_IFOG
    -1,   // doomednum
    S_IFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_TELEPORTMAN
    14,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_EXTRABFG
    -1,   // doomednum
    S_BFGEXP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC0
    2018,   // doomednum
    S_ARM1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC1
    2019,   // doomednum
    S_ARM2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC2
    2014,   // doomednum
    S_BON1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC3
    2015,   // doomednum
    S_BON2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC4
    5,    // doomednum
    S_BKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC5
    13,   // doomednum
    S_RKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC6
    6,    // doomednum
    S_YKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC7
    39,   // doomednum
    S_YSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC8
    38,   // doomednum
    S_RSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC9
    40,   // doomednum
    S_BSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC10
    2011,   // doomednum
    S_STIM,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC11
    2012,   // doomednum
    S_MEDI,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC12
    2013,   // doomednum
    S_SOUL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags   // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_INV
    2022,   // doomednum
    S_PINV,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC13
    2023,   // doomednum
    S_PSTR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_INS
    2024,   // doomednum
    S_PINS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC14
    2025,   // doomednum
    S_SUIT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC15
    2026,   // doomednum
    S_PMAP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC16
    2045,   // doomednum
    S_PVIS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MEGA
    83,   // doomednum
    S_MEGA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CLIP
    2007,   // doomednum
    S_CLIP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC17
    2048,   // doomednum
    S_AMMO,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC18
    2010,   // doomednum
    S_ROCK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC19
    2046,   // doomednum
    S_BROK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC20
    2047,   // doomednum
    S_CELL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC21
    17,   // doomednum
    S_CELP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC22
    2008,   // doomednum
    S_SHEL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC23
    2049,   // doomednum
    S_SBOX,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC24
    8,    // doomednum
    S_BPAK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC25
    2006,   // doomednum
    S_BFUG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUN
    2002,   // doomednum
    S_MGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC26
    2005,   // doomednum
    S_CSAW,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC27
    2003,   // doomednum
    S_LAUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC28
    2004,   // doomednum
    S_PLAS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SHOTGUN
    2001,   // doomednum
    S_SHOT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SUPERSHOTGUN
    82,   // doomednum
    S_SHOT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC29
    85,   // doomednum
    S_TECHLAMP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC30
    86,   // doomednum
    S_TECH2LAMP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC31
    2028,   // doomednum
    S_COLU,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC32
    30,   // doomednum
    S_TALLGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC33
    31,   // doomednum
    S_SHRTGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC34
    32,   // doomednum
    S_TALLREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC35
    33,   // doomednum
    S_SHRTREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC36
    37,   // doomednum
    S_SKULLCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC37
    36,   // doomednum
    S_HEARTCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC38
    41,   // doomednum
    S_EVILEYE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC39
    42,   // doomednum
    S_FLOATSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC40
    43,   // doomednum
    S_TORCHTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC41
    44,   // doomednum
    S_BLUETORCH,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC42
    45,   // doomednum
    S_GREENTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC43
    46,   // doomednum
    S_REDTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC44
    55,   // doomednum
    S_BTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC45
    56,   // doomednum
    S_GTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC46
    57,   // doomednum
    S_RTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC47
    47,   // doomednum
    S_STALAGTITE,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC48
    48,   // doomednum
    S_TECHPILLAR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC49
    34,   // doomednum
    S_CANDLESTIK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC50
    35,   // doomednum
    S_CANDELABRA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC51
    49,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC52
    50,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC53
    51,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC54
    52,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC55
    53,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC56
    59,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC57
    60,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC58
    61,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC59
    62,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC60
    63,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC61
    22,   // doomednum
    S_HEAD_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC62
    15,   // doomednum
    S_PLAY_DIE7,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC63
    18,   // doomednum
    S_POSS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC64
    21,   // doomednum
    S_SARG_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC65
    23,   // doomednum
    S_SKULL_DIE6,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC66
    20,   // doomednum
    S_TROO_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC67
    19,   // doomednum
    S_SPOS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC68
    10,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC69
    12,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC70
    28,   // doomednum
    S_HEADSONSTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC71
    24,   // doomednum
    S_GIBS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC72
    27,   // doomednum
    S_HEADONASTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC73
    29,   // doomednum
    S_HEADCANDLES,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC74
    25,   // doomednum
    S_DEADSTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC75
    26,   // doomednum
    S_LIVESTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC76
    54,   // doomednum
    S_BIGTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    32*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC77
    70,   // doomednum
    S_BBAR1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC78
    73,   // doomednum
    S_HANGNOGUTS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC79
    74,   // doomednum
    S_HANGBNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC80
    75,   // doomednum
    S_HANGTLOOKDN,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC81
    76,   // doomednum
    S_HANGTSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC82
    77,   // doomednum
    S_HANGTLOOKUP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC83
    78,   // doomednum
    S_HANGTNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC84
    79,   // doomednum
    S_COLONGIBS,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC85
    80,   // doomednum
    S_SMALLPOOL,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC86
    81,   // doomednum
    S_BRAINSTEM,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },

  // For use with wind and current effects
  {   // MT_PUSH                       // phares
    5001,           // doomednum       //   |      //jff 5/11/98 deconflict
    S_TNT1,         // spawnstate      //   V      // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  },

  // For use with wind and current effects
  {   // MT_PULL
    5002,           // doomednum                   //jff 5/11/98 deconflict            
    S_TNT1,         // spawnstate                  // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  },

#ifdef DOGS
  // Marine's best friend :)      // killough 7/19/98
  {   // MT_DOGS
    888,   // doomednum
    S_DOGS_STND,    // spawnstate
    500,    // spawnhealth
    S_DOGS_RUN1,    // seestate
    sfx_dgsit,   // seesound
    8,    // reactiontime
    sfx_dgatk,   // attacksound
    S_DOGS_PAIN,    // painstate
    180,    // painchance
    sfx_dgpain,   // painsound
    S_DOGS_ATK1,    // meleestate
    0,    // missilestate
    S_DOGS_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_dgdth,   // deathsound
    10,   // speed
    12*FRACUNIT,    // radius
    28*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_dgact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_DOGS_RAISE1   // raisestate
  },
#endif

#ifdef BETA
  // killough 7/11/98: this is the first of two plasma fireballs in the beta
  {   // MT_PLASMA1
    -1,   // doomednum
    S_PLS1BALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLS1EXP,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    4,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_BOUNCES,
    S_NULL    // raisestate
  },
  
  // killough 7/11/98: this is the second of two plasma fireballs in the beta
  {   // MT_PLASMA2
    -1,   // doomednum
    S_PLS2BALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLS2BALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    6*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    4,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_BOUNCES,
    S_NULL    // raisestate
  },

  // killough 7/11/98: this is the evil sceptre in the beta version
  {   // MT_SCEPTRE
    2016,   // doomednum
    S_BON3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },

  // killough 7/11/98: this is the unholy bible in the beta version
  {   // MT_BIBLE
    2017,   // doomednum
    S_BON4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    10*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
#endif /* BETA */

};


// ********************************************************************
// Predefined lumps
// ********************************************************************
// These are internally defined lumps, which can be overwritten in 
// a PWAD.  There were several things that needed these, such 
// as new menus, font characters, color maps, etc. and this
// is an easy way of incorporating them directly into the EXE rather
// than requiring that an ancillary file be carried around with it.
//
// Near the end of this section there is the actual list where the lumps
// are incorporated, and there it's easy to see explanations in context.

// killough 1/31/98: predefined lumps used to make up for wad deficiencies

// Horizontal Sensitivity menu // 2022/07/02 REKKR lump by brightentayle
static const char m_horsen[]={
  115,0,15,0,0,0,0,0,212,1,0,0,229,1,0,0,248,1,0,0,11,2,0,0,30,2,0,0,51,2,0,0,
  60,2,0,0,81,2,0,0,100,2,0,0,119,2,0,0,138,2,0,0,158,2,0,0,159,2,0,0,174,2,0,
  0,191,2,0,0,210,2,0,0,229,2,0,0,246,2,0,0,7,3,0,0,24,3,0,0,43,3,0,0,62,3,0,0,
  79,3,0,0,94,3,0,0,95,3,0,0,112,3,0,0,131,3,0,0,150,3,0,0,169,3,0,0,192,3,0,0,
  209,3,0,0,229,3,0,0,248,3,0,0,10,4,0,0,27,4,0,0,38,4,0,0,39,4,0,0,52,4,0,0,
  71,4,0,0,90,4,0,0,109,4,0,0,128,4,0,0,142,4,0,0,148,4,0,0,149,4,0,0,166,4,0,
  0,187,4,0,0,208,4,0,0,229,4,0,0,251,4,0,0,14,5,0,0,36,5,0,0,57,5,0,0,78,5,0,
  0,99,5,0,0,116,5,0,0,117,5,0,0,132,5,0,0,149,5,0,0,168,5,0,0,187,5,0,0,204,5,
  0,0,221,5,0,0,238,5,0,0,1,6,0,0,20,6,0,0,37,6,0,0,52,6,0,0,53,6,0,0,70,6,0,0,
  89,6,0,0,108,6,0,0,126,6,0,0,144,6,0,0,165,6,0,0,183,6,0,0,201,6,0,0,220,6,0,
  0,239,6,0,0,0,7,0,0,1,7,0,0,10,7,0,0,21,7,0,0,37,7,0,0,56,7,0,0,75,7,0,0,94,
  7,0,0,113,7,0,0,132,7,0,0,149,7,0,0,165,7,0,0,174,7,0,0,175,7,0,0,188,7,0,0,
  203,7,0,0,219,7,0,0,236,7,0,0,0,8,0,0,18,8,0,0,41,8,0,0,60,8,0,0,79,8,0,0,98,
  8,0,0,115,8,0,0,116,8,0,0,133,8,0,0,152,8,0,0,171,8,0,0,190,8,0,0,205,8,0,0,
  214,8,0,0,223,8,0,0,232,8,0,0,242,8,0,0,252,8,0,0,1,12,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,90,91,6,6,6,95,
  96,6,6,255,1,2,6,6,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,5,4,6,6,90,91,6,6,
  255,1,2,6,6,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,90,
  91,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,6,90,91,92,94,95,95,96,6,6,255,0,
  14,6,6,84,85,86,87,6,90,91,92,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,6,7,6,6,6,
  6,6,6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,
  91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,
  0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,
  96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,
  6,95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,
  95,6,6,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,
  86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,
  6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,0,4,6,6,84,85,6,6,
  5,4,6,6,90,91,6,6,255,0,9,6,6,84,85,86,6,6,90,91,6,6,11,2,6,6,6,6,255,0,14,6,
  6,84,85,86,87,88,90,91,92,6,6,95,96,6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,2,12,6,6,6,6,6,6,91,92,94,95,95,96,6,6,255,7,6,6,6,6,6,6,6,
  6,6,255,255,1,2,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,
  96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,
  96,6,6,255,1,2,6,6,6,6,11,3,6,6,96,6,6,255,12,1,6,6,6,255,255,1,4,6,6,6,6,6,
  6,9,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,0,
  5,6,6,84,85,86,6,6,7,7,6,6,92,94,95,95,96,6,6,255,0,4,6,6,84,85,6,6,6,8,6,6,
  91,92,94,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,6,
  255,0,14,6,6,84,85,6,6,88,90,91,92,6,6,95,96,6,6,255,0,9,6,6,84,85,6,87,88,
  90,91,6,6,10,4,6,6,95,96,6,6,255,0,8,6,6,84,85,86,87,88,90,6,6,10,4,6,6,95,
  96,6,6,255,0,7,6,6,84,85,86,87,88,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,84,85,
  86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,
  255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,
  6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,
  86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,
  6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,
  255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,255,
  2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,
  14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,1,13,6,6,6,86,87,88,90,6,6,6,6,95,96,6,6,255,3,
  6,6,6,87,88,90,91,6,6,11,3,6,6,96,6,6,255,1,1,6,6,6,4,6,6,6,88,90,91,92,6,6,
  12,1,6,6,6,255,0,3,6,6,84,6,6,5,6,6,6,90,91,92,94,6,6,255,0,13,6,6,84,85,6,6,
  6,6,91,92,94,95,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,
  6,84,85,86,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,
  0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,
  6,6,96,6,6,255,0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,
  255,5,8,6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,3,
  11,6,6,87,88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,86,87,88,6,91,92,6,6,95,
  96,6,6,255,1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,0,5,6,6,84,85,86,
  6,6,6,4,6,6,91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,6,11,2,6,6,6,6,
  255,0,14,6,6,84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,
  86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,
  6,255,1,2,6,6,6,6,10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,255,10,4,6,6,95,
  96,6,6,255,10,4,6,6,95,96,6,6,255,9,5,6,6,95,95,96,6,6,255,9,5,6,6,95,95,96,
  6,6,255,10,3,6,6,6,6,6,255,
  };

// Vertical Sensitivity menu // 2022/07/02 REKKR lump by brightentayle
static const char m_versen[]={
  90,0,15,0,0,0,0,0,112,1,0,0,127,1,0,0,144,1,0,0,162,1,0,0,181,1,0,0,197,1,0,
  0,206,1,0,0,222,1,0,0,241,1,0,0,3,2,0,0,20,2,0,0,35,2,0,0,36,2,0,0,51,2,0,0,
  68,2,0,0,87,2,0,0,106,2,0,0,131,2,0,0,156,2,0,0,179,2,0,0,196,2,0,0,215,2,0,
  0,236,2,0,0,253,2,0,0,254,2,0,0,15,3,0,0,34,3,0,0,53,3,0,0,72,3,0,0,95,3,0,0,
  112,3,0,0,132,3,0,0,151,3,0,0,169,3,0,0,186,3,0,0,197,3,0,0,198,3,0,0,207,3,
  0,0,218,3,0,0,234,3,0,0,253,3,0,0,16,4,0,0,35,4,0,0,54,4,0,0,73,4,0,0,90,4,0,
  0,106,4,0,0,115,4,0,0,116,4,0,0,129,4,0,0,148,4,0,0,167,4,0,0,186,4,0,0,205,
  4,0,0,219,4,0,0,225,4,0,0,238,4,0,0,253,4,0,0,14,5,0,0,33,5,0,0,52,5,0,0,69,
  5,0,0,86,5,0,0,103,5,0,0,122,5,0,0,143,5,0,0,160,5,0,0,161,5,0,0,174,5,0,0,
  189,5,0,0,205,5,0,0,222,5,0,0,242,5,0,0,4,6,0,0,27,6,0,0,46,6,0,0,65,6,0,0,
  84,6,0,0,101,6,0,0,102,6,0,0,119,6,0,0,138,6,0,0,157,6,0,0,176,6,0,0,191,6,0,
  0,200,6,0,0,209,6,0,0,218,6,0,0,228,6,0,0,238,6,0,0,1,10,6,6,6,6,6,6,6,6,6,6,
  6,6,255,0,12,6,6,84,85,86,87,88,90,91,92,94,95,6,6,255,0,13,6,6,84,85,86,87,
  88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,94,95,95,96,6,6,255,
  1,2,6,6,6,6,9,5,6,6,95,95,96,6,6,255,10,4,6,6,95,96,6,6,255,1,2,6,6,6,6,9,5,
  6,6,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,94,95,95,96,6,6,255,0,13,6,6,
  84,85,86,87,88,90,91,92,94,95,95,6,6,255,0,12,6,6,84,85,86,87,88,90,91,92,94,
  95,6,6,255,1,10,6,6,6,6,6,6,6,6,6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,
  255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,6,88,90,91,92,6,95,95,96,6,6,
  255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,
  6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,
  10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,
  85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,
  96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,
  96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,0,4,6,6,84,
  85,6,6,5,4,6,6,90,91,6,6,255,0,9,6,6,84,85,86,6,6,90,91,6,6,11,2,6,6,6,6,255,
  0,14,6,6,84,85,86,87,88,90,91,92,6,6,95,96,6,6,255,1,13,6,6,85,86,87,88,90,
  91,92,94,95,95,96,6,6,255,2,12,6,6,6,6,6,6,91,92,94,95,95,96,6,6,255,7,6,6,6,
  6,6,6,6,6,6,255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,6,
  84,85,86,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,
  14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,
  6,6,96,6,6,255,0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,
  255,1,2,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,
  255,1,2,6,6,6,6,11,3,6,6,96,6,6,255,12,1,6,6,6,255,3,8,6,6,6,6,6,6,6,6,6,6,
  255,2,10,6,6,86,87,88,90,91,92,94,95,6,6,255,1,12,6,6,85,86,87,88,90,91,92,
  94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,
  6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,
  255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,
  96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,84,85,86,87,
  6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,255,5,8,
  6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,3,11,6,6,87,
  88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,86,87,88,6,91,92,6,6,95,96,6,6,255,
  1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,0,5,6,6,84,85,86,6,6,6,4,6,6,
  91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,6,11,2,6,6,6,6,255,0,14,6,6,
  84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,
  6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,
  92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,1,2,6,6,
  6,6,10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,255,10,
  4,6,6,95,96,6,6,255,9,5,6,6,95,95,96,6,6,255,9,5,6,6,95,95,96,6,6,255,10,3,6,
  6,6,6,6,255,
};

static const char m_generl[] = {  // killough 10/98 // 2022/07/03 REKKR lump by brightentayle
  83,0,15,0,0,0,0,0,84,1,0,0,100,1,0,0,118,1,0,0,137,1,0,0,156,1,0,0,174,1,0,0,
  197,1,0,0,222,1,0,0,244,1,0,0,10,2,0,0,32,2,0,0,53,2,0,0,54,2,0,0,69,2,0,0,
  86,2,0,0,105,2,0,0,124,2,0,0,149,2,0,0,174,2,0,0,197,2,0,0,214,2,0,0,233,2,0,
  0,254,2,0,0,15,3,0,0,16,3,0,0,33,3,0,0,52,3,0,0,71,3,0,0,89,3,0,0,107,3,0,0,
  128,3,0,0,146,3,0,0,164,3,0,0,183,3,0,0,202,3,0,0,219,3,0,0,220,3,0,0,235,3,
  0,0,252,3,0,0,15,4,0,0,34,4,0,0,59,4,0,0,84,4,0,0,107,4,0,0,124,4,0,0,143,4,
  0,0,164,4,0,0,181,4,0,0,182,4,0,0,199,4,0,0,218,4,0,0,237,4,0,0,0,5,0,0,23,5,
  0,0,40,5,0,0,60,5,0,0,79,5,0,0,97,5,0,0,114,5,0,0,125,5,0,0,126,5,0,0,139,5,
  0,0,154,5,0,0,170,5,0,0,187,5,0,0,207,5,0,0,225,5,0,0,248,5,0,0,11,6,0,0,30,
  6,0,0,49,6,0,0,66,6,0,0,67,6,0,0,84,6,0,0,103,6,0,0,122,6,0,0,141,6,0,0,156,
  6,0,0,165,6,0,0,174,6,0,0,183,6,0,0,193,6,0,0,203,6,0,0,2,11,6,6,6,6,6,6,6,6,
  6,6,6,6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,6,6,6,6,6,95,
  95,96,6,6,255,0,5,6,6,84,85,86,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,
  6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,
  6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,6,6,95,95,96,6,6,255,0,4,6,
  6,84,85,6,6,5,9,6,6,90,91,6,94,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,
  91,6,94,95,95,96,6,6,255,1,2,6,6,6,6,6,2,6,6,6,6,9,4,6,6,6,6,6,6,255,255,2,
  10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,6,
  88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,
  95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,
  6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,
  95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,84,85,86,
  87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,255,1,
  12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,13,6,6,6,
  86,87,88,90,6,6,6,6,95,96,6,6,255,3,6,6,6,87,88,90,91,6,6,11,3,6,6,96,6,6,
  255,1,1,6,6,6,4,6,6,6,88,90,91,92,6,6,12,1,6,6,6,255,0,3,6,6,84,6,6,5,6,6,6,
  90,91,92,94,6,6,255,0,13,6,6,84,85,6,6,6,6,91,92,94,95,6,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,
  6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,
  86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,6,88,90,91,92,6,95,
  95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,
  6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,
  6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,
  6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,
  95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,
  6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,
  6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,0,4,6,6,
  84,85,6,6,5,4,6,6,90,91,6,6,255,0,9,6,6,84,85,86,6,6,90,91,6,6,11,2,6,6,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,6,6,95,96,6,6,255,1,13,6,6,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,2,12,6,6,6,6,6,6,91,92,94,95,95,96,6,6,255,7,6,
  6,6,6,6,6,6,6,6,255,255,5,8,6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,92,94,
  95,95,96,6,6,255,3,11,6,6,87,88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,86,87,
  88,6,91,92,6,6,95,96,6,6,255,1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,
  0,5,6,6,84,85,86,6,6,6,4,6,6,91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,
  6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,
  84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,
  94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,
  14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,
  6,6,6,95,96,6,6,255,1,2,6,6,6,6,10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,
  255,10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,255,9,5,6,6,95,95,96,6,6,255,9,
  5,6,6,95,95,96,6,6,255,10,3,6,6,6,6,6,255,
};

static const char m_compat[] = { // 2022/07/03 REKKR lump by brightentayle
  198,0,15,0,0,0,0,0,32,3,0,0,49,3,0,0,68,3,0,0,87,3,0,0,106,3,0,0,123,3,0,0,
  140,3,0,0,159,3,0,0,178,3,0,0,195,3,0,0,210,3,0,0,223,3,0,0,224,3,0,0,239,3,
  0,0,0,4,0,0,19,4,0,0,38,4,0,0,55,4,0,0,72,4,0,0,89,4,0,0,108,4,0,0,127,4,0,0,
  144,4,0,0,159,4,0,0,160,4,0,0,175,4,0,0,192,4,0,0,211,4,0,0,230,4,0,0,247,4,
  0,0,8,5,0,0,25,5,0,0,44,5,0,0,63,5,0,0,80,5,0,0,95,5,0,0,96,5,0,0,112,5,0,0,
  130,5,0,0,149,5,0,0,168,5,0,0,187,5,0,0,201,5,0,0,215,5,0,0,229,5,0,0,248,5,
  0,0,11,6,0,0,30,6,0,0,48,6,0,0,64,6,0,0,65,6,0,0,66,6,0,0,67,6,0,0,68,6,0,0,
  69,6,0,0,82,6,0,0,97,6,0,0,114,6,0,0,133,6,0,0,152,6,0,0,169,6,0,0,186,6,0,0,
  203,6,0,0,222,6,0,0,243,6,0,0,4,7,0,0,5,7,0,0,20,7,0,0,37,7,0,0,56,7,0,0,75,
  7,0,0,92,7,0,0,109,7,0,0,126,7,0,0,145,7,0,0,164,7,0,0,181,7,0,0,196,7,0,0,
  197,7,0,0,213,7,0,0,231,7,0,0,250,7,0,0,13,8,0,0,32,8,0,0,46,8,0,0,60,8,0,0,
  74,8,0,0,93,8,0,0,112,8,0,0,131,8,0,0,149,8,0,0,165,8,0,0,166,8,0,0,183,8,0,
  0,202,8,0,0,221,8,0,0,240,8,0,0,8,9,0,0,30,9,0,0,47,9,0,0,61,9,0,0,75,9,0,0,
  87,9,0,0,97,9,0,0,98,9,0,0,111,9,0,0,126,9,0,0,142,9,0,0,159,9,0,0,179,9,0,0,
  197,9,0,0,220,9,0,0,239,9,0,0,2,10,0,0,21,10,0,0,38,10,0,0,39,10,0,0,48,10,0,
  0,59,10,0,0,75,10,0,0,94,10,0,0,113,10,0,0,132,10,0,0,151,10,0,0,170,10,0,0,
  187,10,0,0,203,10,0,0,212,10,0,0,213,10,0,0,226,10,0,0,245,10,0,0,8,11,0,0,
  27,11,0,0,46,11,0,0,60,11,0,0,66,11,0,0,67,11,0,0,84,11,0,0,103,11,0,0,122,
  11,0,0,141,11,0,0,166,11,0,0,191,11,0,0,216,11,0,0,235,11,0,0,254,11,0,0,15,
  12,0,0,32,12,0,0,33,12,0,0,46,12,0,0,65,12,0,0,84,12,0,0,103,12,0,0,122,12,0,
  0,136,12,0,0,142,12,0,0,143,12,0,0,160,12,0,0,179,12,0,0,198,12,0,0,217,12,0,
  0,232,12,0,0,241,12,0,0,250,12,0,0,3,13,0,0,13,13,0,0,23,13,0,0,31,13,0,0,32,
  13,0,0,45,13,0,0,64,13,0,0,83,13,0,0,102,13,0,0,121,13,0,0,135,13,0,0,141,13,
  0,0,150,13,0,0,161,13,0,0,177,13,0,0,196,13,0,0,215,13,0,0,234,13,0,0,253,13,
  0,0,16,14,0,0,33,14,0,0,49,14,0,0,58,14,0,0,59,14,0,0,68,14,0,0,79,14,0,0,97,
  14,0,0,116,14,0,0,136,14,0,0,150,14,0,0,170,14,0,0,189,14,0,0,208,14,0,0,224,
  14,0,0,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,
  94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,
  14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,
  6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,
  6,95,95,96,6,6,255,0,14,6,6,84,85,86,87,6,6,6,6,94,95,95,96,6,6,255,1,12,6,6,
  85,86,87,88,90,91,92,94,95,95,6,6,255,2,10,6,6,86,87,88,90,91,92,94,95,6,6,
  255,3,8,6,6,6,6,6,6,6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,
  6,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,
  85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,
  6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,
  6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,85,86,87,
  88,90,91,92,94,95,95,6,6,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,255,2,10,6,6,6,
  6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,
  6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,
  95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,
  10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,14,6,6,84,
  85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,255,2,10,6,6,6,6,6,6,6,
  6,6,6,6,6,255,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,1,13,6,6,85,86,87,88,90,
  91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,95,96,6,6,255,0,8,6,6,84,85,86,6,6,6,6,6,
  11,2,6,6,6,6,255,0,9,6,6,84,85,86,87,88,90,91,6,6,255,1,9,6,6,85,86,87,88,90,
  91,92,6,6,255,0,9,6,6,84,85,86,87,88,90,91,6,6,255,0,8,6,6,84,85,86,6,6,6,6,
  6,11,2,6,6,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,255,255,255,255,3,8,6,6,
  6,6,6,6,6,6,6,6,255,2,10,6,6,86,87,88,90,91,92,94,95,6,6,255,1,12,6,6,85,86,
  87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,
  6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,
  4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,
  6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,
  6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,
  6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,
  95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,
  255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,
  96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,
  6,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,
  255,1,13,6,6,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,
  88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,95,96,6,6,
  255,0,8,6,6,84,85,86,6,6,6,6,6,11,2,6,6,6,6,255,0,9,6,6,84,85,86,87,88,90,91,
  6,6,255,1,9,6,6,85,86,87,88,90,91,92,6,6,255,0,9,6,6,84,85,86,87,88,90,91,6,
  6,255,0,8,6,6,84,85,86,6,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,86,6,6,6,6,
  6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,
  13,6,6,85,86,87,88,90,91,92,94,95,95,96,6,6,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,
  6,255,255,1,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,14,5,5,83,84,84,86,87,88,89,
  91,93,94,94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,5,255,
  0,14,5,5,83,84,5,5,5,88,89,5,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,88,
  89,5,5,11,3,5,5,96,5,5,255,0,4,5,5,83,83,5,5,5,4,5,5,88,89,5,5,12,1,5,5,5,
  255,0,4,5,5,83,83,5,5,5,4,5,5,88,89,5,5,255,0,9,5,5,83,84,84,5,87,88,89,5,5,
  255,0,9,5,5,83,84,84,86,87,88,89,5,5,255,1,7,5,5,84,84,86,87,88,5,5,255,2,5,
  5,5,5,5,5,5,5,255,255,5,8,6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,92,94,95,
  95,96,6,6,255,3,11,6,6,87,88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,86,87,88,
  6,91,92,6,6,95,96,6,6,255,1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,0,
  5,6,6,84,85,86,6,6,6,4,6,6,91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,6,
  11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,4,6,6,6,6,6,6,
  255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,6,84,85,86,6,6,11,2,6,6,6,6,255,0,14,6,
  6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,
  95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,6,6,96,6,6,255,0,6,6,6,84,85,86,87,6,
  6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,255,1,2,6,6,6,6,11,2,6,6,6,6,255,0,14,6,
  6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,1,2,6,6,6,6,11,3,6,6,96,6,6,255,12,1,6,6,
  6,255,255,1,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,14,5,5,83,84,84,86,87,88,89,
  91,93,94,94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,5,255,
  0,14,5,5,83,84,5,5,5,5,5,5,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,88,89,
  5,5,10,4,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,88,89,5,5,10,4,5,5,94,
  96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,88,89,5,5,10,4,5,5,94,96,5,5,255,0,14,5,
  5,83,84,5,5,87,88,89,91,5,5,94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,
  93,94,94,96,5,5,255,1,12,5,5,84,84,86,87,5,5,91,92,94,94,5,5,255,2,4,5,5,5,5,
  5,5,8,4,5,5,5,5,5,5,255,255,1,2,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,
  6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,
  6,6,6,6,6,6,95,96,6,6,255,1,2,6,6,6,6,11,3,6,6,96,6,6,255,12,1,6,6,6,255,255,
  1,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,14,5,5,83,83,84,86,87,88,89,91,93,94,
  94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,5,255,0,14,5,5,
  83,84,5,5,5,5,5,5,5,5,94,96,5,5,255,1,2,5,5,5,5,10,4,5,5,94,96,5,5,255,10,4,
  5,5,94,96,5,5,255,10,4,5,5,94,96,5,5,255,10,4,5,5,94,96,5,5,255,9,5,5,5,94,
  94,96,5,5,255,9,5,5,5,94,94,96,5,5,255,10,3,5,5,5,5,5,255,255,1,2,6,6,6,6,11,
  2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,1,2,6,6,6,6,11,3,6,6,
  96,6,6,255,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,
  5,6,6,84,85,86,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,
  11,3,6,6,96,6,6,255,0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,
  255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,7,6,6,84,85,86,87,
  88,6,6,11,2,6,6,6,6,255,0,14,6,6,84,6,6,87,88,90,6,6,6,6,95,96,6,6,255,1,1,6,
  6,6,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,5,9,6,6,90,91,92,94,95,95,96,6,
  6,255,1,1,6,6,6,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,6,6,87,
  88,90,6,6,6,6,95,96,6,6,255,0,7,6,6,84,85,86,87,88,6,6,11,3,6,6,96,6,6,255,0,
  6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,
};

//jff 02/16/98 HUD bargraph patches
// The HUD uses vertical stripe characters to make up the bars in
// view during play, and those are made up here at various stages
// of "fullness".  Note that all HUD elements can be recolored
// dynamically in the code, so only the shapes are defined here.

static const char stbr123[]=  // full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 91,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,
  176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,176,180,185,
   47,  0,255,255,
};

static const char stbr124[]=  // 3/4 full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,
  176,180,185, 47,  0,255,255,255,255,
};

static const char stbr125[]=  // half full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0, 69,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,255,255,255,255,
};

static const char stbr126[]=  // quarter full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 54,  0,  0,  0,
   55,  0,  0,  0, 56,  0,  0,  0, 57,  0,  0,  0, 58,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,255,255,255,
  255,255,255,
};

static const char stbr127[]=  // empty block
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0,
   44,  0,  0,  0, 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0,
  255,255,255,255,255,255,255,255,
};

// The digits themselves that are used in the HUD

static const char dig0[]=  // zero
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig1[]=  // one
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,
   67,  0,  0,  0,  5,  1,  0,176,  0,255,  1,  1,  0,176,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,176,  0,  0,255,  4,  3,  0,  0,  0,
    0,  0,255,
};

static const char dig2[]=  // two
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  1,  0,176,  0,  3,  3,  0,176,176,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,  0,176,  0,
    0,255,  2,  3,  0,  0,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char dig3[]=  // three
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 55,  0,  0,  0, 69,  0,  0,  0,
   80,  0,  0,  0,  1,  2,  0,176,176,  0,  4,  2,  0,176,176,  0,
  255,  1,  3,  0,176,  0,  0,  0,  5,  2,  0,176,  0,  0,255,  1,
    3,  0,176,  0,176,  0,  5,  2,  0,176,  0,  0,255,  1,  6,  0,
  176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,  0,  0,  0,
    0,255,
};

static const char dig4[]=  // four
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 37,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,
   67,  0,  0,  0,  1,  4,  0,176,176,176,176,  0,255,  2,  4,  0,
    0,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,176,  0,  0,  0,255,  4,  2,  0,  0,  0,
    0,255,
};

static const char dig45[]=  // minus '-'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 35,  0,  0,  0, 42,  0,  0,  0,
   49,  0,  0,  0,255,  3,  1,  0,176,  0,255,  3,  2,  0,176,  0,
    0,255,  3,  2,  0,176,  0,  0,255,  4,  1,  0,  0,  0,255,
};


static const char dig47[]=  // slash '/'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 36,  0,  0,  0, 43,  0,  0,  0,
   50,  0,  0,  0,255,  4,  2,  0,176,  0,  0,255,  3,  2,  0,176,
    0,  0,255,  2,  2,  0,176,  0,  0,255,255,
};

static const char dig5[]=  // five
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig58[]=  // colon ':'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 30,  0,  0,  0, 41,  0,  0,  0,
   52,  0,  0,  0,255,255,  2,  1,  0,176,  0,  4,  1,  0,176,  0,
  255,  3,  1,  0,  0,  0,  5,  1,  0,  0,  0,255,255,
};

static const char dig6[]=  // six
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig7[]=  // seven
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,  1,  1,  0,176,  0,255,  1,  2,  0,176,  0,  0,
  255,  1,  5,  0,176,  0,176,176,176,  0,255,  1,  6,  0,176,176,
    0,  0,  0,  0,  0,255,  2,  2,  0,  0,  0,  0,255,
};

static const char dig8[]=  // eight
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig9[]=  // nine
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig91[]=  // open bracket '['
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 39,  0,  0,  0, 50,  0,  0,  0,
   61,  0,  0,  0,255,  1,  5,  0,176,176,176,176,176,  0,255,  1,
    6,  0,176,  0,  0,  0,176,  0,  0,255,  2,  1,  0,  0,  0,  6,
    1,  0,  0,  0,255,255,
};

static const char dig93[]=  // close bracket ']'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
   61,  0,  0,  0,255,  1,  1,  0,176,  0,  5,  1,  0,176,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,
    0,  0,  0,  0,255,255,
};

static const char diga[]=  // these are the letters A-Z
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   68,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,
    0,  0,  0,  0,  0,255,
};

static const char digb[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   70,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,  0,
  176,  0,  0,255,  2,  5,  0,  0,176,176,176,  0,  0,255,  3,  4,
    0,  0,  0,  0,  0,  0,255,
};

static const char digc[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   75,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,  2,  0,176,
    0,  0,255,  2,  1,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char digd[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   72,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  2,  5,  0,176,176,176,  0,  0,  0,255,
    3,  3,  0,  0,  0,  0,  0,255,
};

static const char dige[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  2,  0,176,  0,  0,  4,  3,  0,  0,176,  0,
    0,255,  2,  1,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char digf[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   70,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  2,  0,176,  0,  0,  4,  1,  0,  0,  0,255,  2,  1,
    0,  0,  0,255,
};

static const char digg[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  3,  0,176,  0,176,  0,
    5,  2,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  1,  0,  0,  0,  4,  3,  0,  0,  0,  0,  0,255,
};

static const char digh[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   65,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,176,  0,  0,  0,  0,255,  3,  2,  0,176,  0,  0,255,  1,
    5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,  0,
    0,  0,255,
};

static const char digi[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,255,  1,  1,  0,176,  0,  5,  1,  0,176,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  1,  6,  0,176,  0,
    0,  0,176,  0,  0,255,  5,  2,  0,  0,  0,  0,255,
};

static const char digj[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 40,  0,  0,  0, 53,  0,  0,  0, 64,  0,  0,  0,
   75,  0,  0,  0,  1,  1,  0,176,  0,  4,  2,  0,176,176,  0,255,
    1,  2,  0,176,  0,  0,  5,  2,  0,176,  0,  0,255,  1,  6,  0,
  176,176,176,176,176,  0,  0,255,  1,  6,  0,176,  0,  0,  0,  0,
    0,  0,255,  2,  1,  0,  0,  0,255,
};

static const char digk[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 57,  0,  0,  0,
   68,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,176,176,  0,  0,
  255,  1,  6,  0,176,  0,176,176,176,  0,  0,255,  2,  1,  0,  0,
    0,  4,  3,  0,  0,  0,  0,  0,255,
};

static const char digl[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   62,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,  0,  0,176,  0,  0,255,  5,  2,  0,176,  0,  0,255,  5,
    2,  0,176,  0,  0,255,  6,  1,  0,  0,  0,255,
};

static const char digm[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 56,  0,  0,  0,
   66,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,176,176,  0,  0,  0,  0,255,  2,  3,  0,176,176,  0,  0,255,
    1,  5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,
    0,  0,  0,255,
};

static const char dign[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   65,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,176,176,  0,  0,  0,  0,255,  3,  2,  0,176,176,  0,255,  1,
    5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,  0,
    0,  0,255,
};

static const char digo[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digp[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  4,  0,176,176,176,  0,  0,255,  2,  3,  0,  0,  0,
    0,  0,255,
};

static const char digq[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,176,176,  0,  0,255,  1,  2,  0,176,  0,  0,  4,
    3,  0,  0,176,176,  0,255,  1,  6,  0,176,176,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digr[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,176,176,  0,
    0,255,  2,  4,  0,  0,176,176,176,  0,255,  3,  4,  0,  0,  0,
    0,  0,  0,255,
};

static const char digs[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digt[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,  1,  1,  0,176,  0,255,  1,  2,  0,176,  0,  0,
  255,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,  0,176,  0,
    0,  0,  0,  0,  0,255,  2,  1,  0,  0,  0,255,
};

static const char digu[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   66,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,  0,  0,176,  0,  0,255,  5,  2,  0,176,  0,  0,255,  1,
    6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,  0,
    0,  0,  0,255,
};

static const char digv[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 36,  0,  0,  0, 45,  0,  0,  0, 53,  0,  0,  0,
   64,  0,  0,  0,  1,  3,  0,176,176,176,  0,255,  2,  4,  0,  0,
    0,176,176,  0,255,  4,  3,  0,176,176,  0,  0,255,  1,  6,  0,
  176,176,176,  0,  0,  0,  0,255,  2,  3,  0,  0,  0,  0,  0,255,
};

static const char digw[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 47,  0,  0,  0, 56,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  3,  4,
    0,176,176,  0,  0,  0,255,  3,  4,  0,176,176,  0,  0,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,
    0,  0,  0,  0,255,
};

static const char digx[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  2,  0,176,176,  0,  4,  2,  0,176,176,  0,
  255,  2,  5,  0,176,176,176,  0,  0,  0,255,  2,  4,  0,176,176,
  176,  0,  0,255,  1,  6,  0,176,176,  0,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digy[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 42,  0,  0,  0, 52,  0,  0,  0, 61,  0,  0,  0,
   72,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  2,  0,176,  0,
    0,255,  2,  5,  0,  0,176,  0,176,  0,  0,255,  3,  4,  0,176,
    0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,255,
    2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digz[]=  // end of letters A-Z
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  1,  0,176,  0,  4,  2,  0,176,176,  0,255,
    1,  6,  0,176,  0,176,176,176,  0,  0,255,  1,  6,  0,176,176,
  176,  0,176,  0,  0,255,  1,  6,  0,176,176,  0,  0,176,  0,  0,
  255,  2,  2,  0,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char stkeys6[]=  // show both blue keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,198,
  200,  0,255,  0,  3,  0,198,202,203,  0,255,  0,  6,  0,198,  0,
  202,204,199,197,  0,255,  0,  7,  0,198,202,202,198,207,199,203,
    0,255,  0,  7,  0,200,  0,201,199,200,207,202,  0,255,  2,  5,
    0,202,199,207,199,202,  0,255,  3,  3,  0,204,199,197,  0,255,
};

static const char stkeys7[]=  // show both yellow keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,161,
  161,  0,255,  0,  3,  0,161,163,163,  0,255,  0,  6,  0,161,  0,
  163,220,162,235,  0,255,  0,  7,  0,161,163,217,162,246,214,221,
    0,255,  0,  7,  0,161,  0,214,213,214,246,218,  0,255,  2,  5,
    0,217,162,246,214,221,  0,255,  3,  3,  0,220,162,235,  0,255,
};

static const char stkeys8[]=  // show both red keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,174,
  176,  0,255,  0,  3,  0,174,179,179,  0,255,  0,  6,  0,176,  0,
  179,184,174,174,  0,255,  0,  7,  0,176,179,185,175,246,185,182,
    0,255,  0,  7,  0,176,  0,183,177,176,246,179,  0,255,  2,  5,
    0,185,177,246,185,182,  0,255,  3,  3,  0,185,175,174,  0,255,
};

// Background characters for the message review when enabled
// Makes a general purpose background box, could be used for other
// purposes as well
//
//  ul uc ur
//  cl cc cr
//  ll lc lr
//

static const char boxcc[]=  // message background characters
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,151,151,151, 77, 77, 77, 78, 77,  0,255,  0,  8,  0,
   77, 77, 78, 77, 77, 77, 77, 78,  0,255,  0,  8,  0, 78,151, 77,
   78, 78, 77, 78, 77,  0,255,  0,  8,  0, 77, 77, 78, 77, 77, 77,
   77,151,  0,255,  0,  8,  0,151, 77, 77,151, 77, 78, 77, 77,  0,
  255,  0,  8,  0, 77, 78, 77, 77, 77, 77,151, 78,  0,255,  0,  8,
    0, 78, 77, 77,151, 77, 78, 77, 77,  0,255,  0,  8,  0, 77, 78,
   77, 77, 77,151,151,151,  0,255,
};

static const char boxcl[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 10, 10,  9, 10,  9,  9, 10,  9,  0,255,  0,  8,  0,
   11,126,126,126,126, 11,126,126,  0,255,  0,  8,  0,238,238,238,
  238,238,238,238,238,  0,255,  0,  8,  0,151,151, 76, 77,151,151,
  151,151,  0,255,  0,  8,  0,151, 76,151,151,151, 77,151,151,  0,
  255,  0,  8,  0,151,151,151, 77, 77,151, 78,151,  0,255,  0,  8,
    0, 77, 78, 77, 77, 78, 77,151, 77,  0,255,  0,  8,  0,151,151,
   77, 77, 77, 77, 78, 78,  0,255,
};

static const char boxcr[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 78, 78, 77,151,151, 77,151,151,  0,255,  0,  8,  0,
   77,151, 77,151, 77, 77, 78, 77,  0,255,  0,  8,  0,151, 78,151,
   76,151,151,151,151,  0,255,  0,  8,  0,151,151, 77, 76, 76,151,
   76,151,  0,255,  0,  8,  0,151,151,151,151, 76, 76,151,151,  0,
  255,  0,  8,  0,238,238,238,238,238,238,238,238,  0,255,  0,  8,
    0, 11,126,126,126,126, 11,126,126,  0,255,  0,  8,  0, 10, 10,
    9, 10,  9,  9, 10,  9,  0,255,
};

static const char boxlc[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 77, 77, 77, 78, 77,  9,  9, 11,  0,255,  0,  8,  0,
   77, 77, 77, 77, 78,159, 10,126,  0,255,  0,  8,  0, 78, 78, 77,
   78, 77,  9,  9,126,  0,255,  0,  8,  0, 77, 77, 77, 77,151,159,
   10, 11,  0,255,  0,  8,  0,151, 77, 78, 77, 77,  9, 10,126,  0,
  255,  0,  8,  0, 77, 77, 77,151, 78,  9,  9,126,  0,255,  0,  8,
    0,151, 77, 78, 77, 77,159, 10,126,  0,255,  0,  8,  0, 77, 77,
  151,151,151,159,  9,126,  0,255,
};

static const char boxll[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 10,  9,  9, 10,  9, 10,  9, 10,  0,255,  0,  8,  0,
  126,126, 11,126,126,126, 10, 11,  0,255,  0,  8,  0,238,238,238,
  238,238, 10, 10,126,  0,255,  0,  8,  0, 77,151,151,151,151,159,
   10, 11,  0,255,  0,  8,  0,151,151, 77,151,151,  9, 10,126,  0,
  255,  0,  8,  0, 77, 77,151, 78,151,  9,  9,126,  0,255,  0,  8,
    0, 77, 78, 77,151, 77,159, 10,126,  0,255,  0,  8,  0, 77, 77,
   77, 78, 78,159,  9,126,  0,255,
};

static const char boxlr[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,151,151, 77,151,151,  9,  9, 11,  0,255,  0,  8,  0,
  151, 77, 77, 78, 77,159, 10,126,  0,255,  0,  8,  0, 76,151,151,
  151,151,  9,  9,126,  0,255,  0,  8,  0, 76, 76,151, 76,151,159,
   10,126,  0,255,  0,  8,  0,151, 76, 76,151,151,  9,  9,126,  0,
  255,  0,  8,  0,238,238,238,238,238,  9, 10,126,  0,255,  0,  8,
    0,126,126, 11,126,126,126, 10, 11,  0,255,  0,  8,  0, 10,  9,
    9, 10,  9, 10,  9, 10,  0,255,
};

static const char boxuc[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,  9, 11,239,151,151,151, 77, 77,  0,255,  0,  8,  0,
   10,126,239, 77, 77, 78, 77, 77,  0,255,  0,  8,  0,  9,126,239,
   78,151, 77, 78, 78,  0,255,  0,  8,  0, 10, 11,239, 77, 77, 78,
   77, 77,  0,255,  0,  8,  0, 10,126,239,151, 77, 77,151, 77,  0,
  255,  0,  8,  0,  9,126,239, 77, 78, 77, 77, 77,  0,255,  0,  8,
    0, 10,126,239, 78, 77, 77,151, 77,  0,255,  0,  8,  0,  9,126,
  239, 77, 78, 77, 77, 77,  0,255,
};

static const char boxul[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,159, 10, 10, 10, 10,  9, 10,  9,  0,255,  0,  8,  0,
   10, 11,126, 11,126,126,126,126,  0,255,  0,  8,  0, 10,126,239,
  238,238,238,238,238,  0,255,  0,  8,  0, 10, 11,239,151,151, 76,
   77,151,  0,255,  0,  8,  0, 10,126,239,151, 76,151,151,151,  0,
  255,  0,  8,  0,  9,126,239,151,151,151, 77, 77,  0,255,  0,  8,
    0, 10,126,239, 77, 78, 77, 77, 78,  0,255,  0,  8,  0,  9,126,
  239,151,151, 77, 77, 77,  0,255,
};

static const char boxur[]=  // end message background characters
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,  9, 11,239, 78, 78, 77,151,151,  0,255,  0,  8,  0,
   10,126,239, 77,151, 77,151, 77,  0,255,  0,  8,  0,  9,126,239,
  151, 78,151, 76,151,  0,255,  0,  8,  0, 10,126,239,151,151, 77,
   76, 76,  0,255,  0,  8,  0,  9,126,239,151,151,151,151, 76,  0,
  255,  0,  8,  0, 10,126,239,238,238,238,238,238,  0,255,  0,  8,
    0, 10, 11,126, 11,126,126,126,126,  0,255,  0,  8,  0,159, 10,
   10, 10, 10,  9, 10,  9,  0,255,
};

// An invisible sprite, used for the TNT1 sprite for point wind
static const char invis_sprite[]=
{
    1,  0,  1,  0,  0,  0,  0,  0,
   12,  0,  0,  0,255,
};

// A new setup menu was added in BOOM, and the various menu graphic
// text strings etc. are included here.

// phares 3/31/98
//
// Lumps for menus

static const char m_keybnd[]= // "Key Bindings"  // 2022/07/02 REKKR lump by brightentayle
{
  129,0,15,0,0,0,0,0,12,2,0,0,29,2,0,0,48,2,0,0,67,2,0,0,86,2,0,0,107,2,0,0,
  116,2,0,0,139,2,0,0,158,2,0,0,177,2,0,0,198,2,0,0,215,2,0,0,216,2,0,0,231,2,
  0,0,248,2,0,0,11,3,0,0,30,3,0,0,55,3,0,0,80,3,0,0,103,3,0,0,120,3,0,0,139,3,
  0,0,160,3,0,0,177,3,0,0,178,3,0,0,187,3,0,0,198,3,0,0,216,3,0,0,235,3,0,0,
  255,3,0,0,13,4,0,0,33,4,0,0,52,4,0,0,71,4,0,0,87,4,0,0,96,4,0,0,97,4,0,0,98,
  4,0,0,99,4,0,0,100,4,0,0,101,4,0,0,102,4,0,0,119,4,0,0,138,4,0,0,157,4,0,0,
  176,4,0,0,201,4,0,0,226,4,0,0,251,4,0,0,14,5,0,0,33,5,0,0,50,5,0,0,67,5,0,0,
  68,5,0,0,69,5,0,0,82,5,0,0,101,5,0,0,120,5,0,0,139,5,0,0,158,5,0,0,172,5,0,0,
  178,5,0,0,179,5,0,0,196,5,0,0,215,5,0,0,234,5,0,0,252,5,0,0,14,6,0,0,35,6,0,
  0,53,6,0,0,71,6,0,0,90,6,0,0,109,6,0,0,126,6,0,0,127,6,0,0,144,6,0,0,163,6,0,
  0,182,6,0,0,201,6,0,0,218,6,0,0,235,6,0,0,254,6,0,0,17,7,0,0,34,7,0,0,49,7,0,
  0,62,7,0,0,63,7,0,0,76,7,0,0,95,7,0,0,114,7,0,0,133,7,0,0,152,7,0,0,166,7,0,
  0,172,7,0,0,173,7,0,0,190,7,0,0,209,7,0,0,228,7,0,0,246,7,0,0,8,8,0,0,29,8,0,
  0,47,8,0,0,65,8,0,0,84,8,0,0,103,8,0,0,120,8,0,0,121,8,0,0,137,8,0,0,155,8,0,
  0,174,8,0,0,193,8,0,0,211,8,0,0,234,8,0,0,3,9,0,0,25,9,0,0,47,9,0,0,69,9,0,0,
  90,9,0,0,91,9,0,0,108,9,0,0,129,9,0,0,151,9,0,0,173,9,0,0,195,9,0,0,220,9,0,
  0,242,9,0,0,8,10,0,0,30,10,0,0,51,10,0,0,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,90,91,6,6,6,95,96,6,
  6,255,1,2,6,6,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,5,4,6,6,90,91,6,6,255,1,
  2,6,6,6,6,4,6,6,6,88,90,91,92,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,87,88,90,
  91,92,94,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,6,6,92,94,95,95,96,6,6,255,
  0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,
  6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,
  92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,
  14,6,6,84,85,86,6,88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,
  90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,
  6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,
  84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,
  255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,
  6,6,6,6,6,6,255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,7,6,6,
  84,85,86,87,88,6,6,11,2,6,6,6,6,255,0,14,6,6,84,6,6,87,88,90,6,6,6,6,95,96,6,
  6,255,1,1,6,6,6,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,5,9,6,6,90,91,92,94,
  95,95,96,6,6,255,1,1,6,6,6,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,6,6,87,88,90,6,6,6,6,95,96,6,6,255,0,7,6,6,84,85,86,87,88,6,6,11,3,6,6,96,
  6,6,255,0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,255,255,
  255,255,255,255,1,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,14,5,5,83,84,84,86,87,
  88,89,91,93,94,94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,
  5,255,0,14,5,5,83,84,5,5,5,5,5,5,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,
  88,89,5,5,10,4,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,88,89,5,5,10,4,5,
  5,94,96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,88,89,5,5,10,4,5,5,94,96,5,5,255,0,
  14,5,5,83,84,5,5,87,88,89,91,5,5,94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,
  91,93,94,94,96,5,5,255,1,12,5,5,84,84,86,87,5,5,91,92,94,94,5,5,255,2,4,5,5,
  5,5,5,5,8,4,5,5,5,5,5,5,255,255,255,1,2,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,
  85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,6,6,6,6,6,6,6,6,95,96,6,6,255,1,2,6,6,6,6,11,3,6,6,96,6,6,255,12,1,6,6,6,
  255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,
  92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,
  1,13,6,6,6,86,87,88,90,6,6,6,6,95,96,6,6,255,3,6,6,6,87,88,90,91,6,6,11,3,6,
  6,96,6,6,255,1,1,6,6,6,4,6,6,6,88,90,91,92,6,6,12,1,6,6,6,255,0,3,6,6,84,6,6,
  5,6,6,6,90,91,92,94,6,6,255,0,13,6,6,84,85,6,6,6,6,91,92,94,95,6,6,6,255,0,
  14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,
  5,255,0,14,5,5,83,84,84,86,87,88,89,91,92,94,94,96,5,5,255,0,14,5,5,83,84,5,
  5,5,5,5,5,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,10,4,5,5,94,96,5,5,255,0,4,5,5,
  83,84,5,5,10,4,5,5,94,96,5,5,255,0,5,5,5,83,84,84,5,5,9,5,5,5,94,94,96,5,5,
  255,0,14,5,5,83,84,84,86,5,5,5,5,93,94,94,96,5,5,255,1,12,5,5,84,84,86,87,88,
  89,91,93,94,94,5,5,255,2,10,5,5,84,86,87,88,89,91,93,94,5,5,255,3,8,5,5,5,5,
  5,5,5,5,5,5,255,255,1,2,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,
  6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,
  6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,
  6,95,96,6,6,255,1,2,6,6,6,6,11,3,6,6,96,6,6,255,12,1,6,6,6,255,255,1,12,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,13,6,6,6,86,87,88,
  90,6,6,6,6,95,96,6,6,255,3,6,6,6,87,88,90,91,6,6,11,3,6,6,96,6,6,255,1,1,6,6,
  6,4,6,6,6,88,90,91,92,6,6,12,1,6,6,6,255,0,3,6,6,84,6,6,5,6,6,6,90,91,92,94,
  6,6,255,0,13,6,6,84,85,6,6,6,6,91,92,94,95,6,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,
  6,255,1,13,6,6,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,
  88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,6,6,6,6,6,95,95,96,6,6,
  255,0,5,6,6,84,85,86,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,
  6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,
  6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,
  6,5,9,6,6,90,91,6,94,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,6,94,
  95,95,96,6,6,255,1,2,6,6,6,6,6,2,6,6,6,6,9,4,6,6,6,6,6,6,255,255,2,4,6,6,6,6,
  6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,88,6,6,8,6,6,6,94,95,95,96,6,6,255,
  0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,95,96,6,6,255,0,9,6,6,84,85,6,87,88,
  90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,84,85,6,6,88,90,91,6,6,10,4,6,6,95,
  96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,
  6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,
  91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,6,8,6,6,91,92,94,95,95,96,6,6,
  255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,95,95,6,6,255,1,4,6,6,6,6,6,6,8,4,
  6,6,6,6,6,6,255,
};

static const char m_setup[]=  // "Setup"  // 2022/07/02 REKKR lump by brightentayle
{
  59,0,15,0,0,0,0,0,244,0,0,0,5,1,0,0,26,1,0,0,48,1,0,0,70,1,0,0,92,1,0,0,117,
  1,0,0,139,1,0,0,161,1,0,0,183,1,0,0,204,1,0,0,221,1,0,0,222,1,0,0,237,1,0,0,
  254,1,0,0,17,2,0,0,36,2,0,0,61,2,0,0,86,2,0,0,109,2,0,0,126,2,0,0,145,2,0,0,
  166,2,0,0,183,2,0,0,184,2,0,0,193,2,0,0,204,2,0,0,220,2,0,0,239,2,0,0,2,3,0,
  0,21,3,0,0,40,3,0,0,59,3,0,0,76,3,0,0,92,3,0,0,101,3,0,0,102,3,0,0,118,3,0,0,
  136,3,0,0,155,3,0,0,174,3,0,0,189,3,0,0,198,3,0,0,213,3,0,0,232,3,0,0,251,3,
  0,0,14,4,0,0,31,4,0,0,32,4,0,0,49,4,0,0,68,4,0,0,87,4,0,0,106,4,0,0,130,4,0,
  0,152,4,0,0,169,4,0,0,183,4,0,0,197,4,0,0,209,4,0,0,2,4,6,6,6,6,6,6,9,4,6,6,
  6,6,6,6,255,1,6,6,6,85,86,87,88,6,6,8,6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,
  85,86,87,88,90,6,6,9,5,6,6,95,95,96,6,6,255,0,9,6,6,84,85,6,87,88,90,91,6,6,
  10,4,6,6,95,96,6,6,255,0,9,6,6,84,85,6,6,88,90,91,6,6,10,4,6,6,95,96,6,6,255,
  0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,
  5,9,6,6,90,91,92,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,
  95,96,6,6,255,0,5,6,6,84,85,86,6,6,6,8,6,6,91,92,94,95,95,96,6,6,255,0,6,6,6,
  84,85,86,87,6,6,7,6,6,6,92,94,95,95,6,6,255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,
  255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,
  95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,86,6,88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,
  10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,
  6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,
  10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,
  84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,
  255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,6,84,85,86,6,6,
  11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,
  86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,6,6,96,6,6,255,
  0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,255,1,11,6,6,6,6,
  6,6,6,6,6,6,6,6,6,255,0,13,6,6,84,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,
  6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,
  95,95,96,6,6,255,1,2,6,6,6,6,10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,255,1,
  2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,
  1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,85,6,6,6,90,91,6,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,
  3,6,6,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,12,1,6,6,6,255,0,4,6,6,
  84,85,6,6,5,4,6,6,90,91,6,6,255,0,9,6,6,84,85,86,6,88,90,91,6,6,255,0,9,6,6,
  84,85,86,87,88,90,91,6,6,255,1,7,6,6,85,86,87,88,90,6,6,255,2,5,6,6,6,6,6,6,
  6,255,
};

static const char m_auto[]=  // "Automap" // 2022/07/02 REKKR lump by brightentayle
{
  85,0,15,0,0,0,0,0,92,1,0,0,105,1,0,0,120,1,0,0,136,1,0,0,153,1,0,0,173,1,0,0,
  191,1,0,0,214,1,0,0,233,1,0,0,252,1,0,0,15,2,0,0,32,2,0,0,33,2,0,0,49,2,0,0,
  67,2,0,0,86,2,0,0,105,2,0,0,120,2,0,0,129,2,0,0,144,2,0,0,163,2,0,0,182,2,0,
  0,201,2,0,0,218,2,0,0,219,2,0,0,228,2,0,0,239,2,0,0,255,2,0,0,18,3,0,0,37,3,
  0,0,56,3,0,0,75,3,0,0,94,3,0,0,111,3,0,0,127,3,0,0,136,3,0,0,137,3,0,0,152,3,
  0,0,169,3,0,0,188,3,0,0,207,3,0,0,224,3,0,0,241,3,0,0,2,4,0,0,21,4,0,0,40,4,
  0,0,57,4,0,0,72,4,0,0,73,4,0,0,89,4,0,0,107,4,0,0,126,4,0,0,145,4,0,0,164,4,
  0,0,178,4,0,0,192,4,0,0,206,4,0,0,225,4,0,0,244,4,0,0,7,5,0,0,25,5,0,0,41,5,
  0,0,42,5,0,0,55,5,0,0,70,5,0,0,86,5,0,0,103,5,0,0,123,5,0,0,141,5,0,0,164,5,
  0,0,183,5,0,0,202,5,0,0,221,5,0,0,238,5,0,0,239,5,0,0,0,6,0,0,19,6,0,0,38,6,
  0,0,57,6,0,0,81,6,0,0,103,6,0,0,120,6,0,0,134,6,0,0,148,6,0,0,160,6,0,0,5,8,
  6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,3,11,6,6,87,
  88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,86,87,88,6,91,92,6,6,95,96,6,6,255,
  1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,0,5,6,6,84,85,86,6,6,6,4,6,6,
  91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,6,11,2,6,6,6,6,255,0,14,6,6,
  84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,13,6,6,
  84,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,95,95,96,6,6,255,1,2,6,6,6,6,
  10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,255,1,2,6,6,6,6,10,4,6,6,95,96,6,6,
  255,0,14,6,6,84,85,6,6,6,6,6,6,6,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,
  91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,
  85,86,87,6,6,255,0,5,6,6,84,85,86,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,
  6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,
  0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,
  5,6,6,84,85,86,6,6,11,3,6,6,96,6,6,255,0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,
  255,1,4,6,6,6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,
  87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,
  6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,
  4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,
  6,10,4,6,6,95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,14,
  6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,85,86,87,88,90,91,
  92,94,95,95,6,6,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,255,2,11,6,6,6,6,6,6,6,
  6,6,6,6,6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,
  95,96,6,6,255,0,8,6,6,84,85,86,6,6,6,6,6,11,2,6,6,6,6,255,0,9,6,6,84,85,86,
  87,88,90,91,6,6,255,1,9,6,6,85,86,87,88,90,91,92,6,6,255,0,9,6,6,84,85,86,87,
  88,90,91,6,6,255,0,8,6,6,84,85,86,6,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,
  86,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,
  6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,95,95,96,6,6,255,2,11,6,6,6,6,6,6,6,
  6,6,6,6,6,6,255,255,5,8,6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,92,94,95,
  95,96,6,6,255,3,11,6,6,87,88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,86,87,88,
  6,91,92,6,6,95,96,6,6,255,1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,0,
  5,6,6,84,85,86,6,6,6,4,6,6,91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,6,
  11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,
  6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,90,91,6,
  6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,3,6,6,96,6,6,255,0,
  4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,12,1,6,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,
  90,91,6,6,255,0,9,6,6,84,85,86,6,88,90,91,6,6,255,0,9,6,6,84,85,86,87,88,90,
  91,6,6,255,1,7,6,6,85,86,87,88,90,6,6,255,2,5,6,6,6,6,6,6,6,255,
};

static const char m_chat[]=  // "Chat Strings" // 2022/07/02 REKKR lump by brightentayle
{
  130,0,15,0,0,0,0,0,16,2,0,0,29,2,0,0,44,2,0,0,61,2,0,0,80,2,0,0,99,2,0,0,116,
  2,0,0,133,2,0,0,150,2,0,0,169,2,0,0,190,2,0,0,207,2,0,0,208,2,0,0,225,2,0,0,
  244,2,0,0,7,3,0,0,26,3,0,0,47,3,0,0,56,3,0,0,77,3,0,0,96,3,0,0,115,3,0,0,134,
  3,0,0,154,3,0,0,155,3,0,0,168,3,0,0,183,3,0,0,199,3,0,0,216,3,0,0,236,3,0,0,
  254,3,0,0,21,4,0,0,40,4,0,0,59,4,0,0,78,4,0,0,95,4,0,0,96,4,0,0,105,4,0,0,
  116,4,0,0,132,4,0,0,151,4,0,0,170,4,0,0,189,4,0,0,208,4,0,0,227,4,0,0,244,4,
  0,0,4,5,0,0,13,5,0,0,14,5,0,0,15,5,0,0,16,5,0,0,17,5,0,0,34,5,0,0,55,5,0,0,
  77,5,0,0,99,5,0,0,121,5,0,0,146,5,0,0,168,5,0,0,190,5,0,0,212,5,0,0,233,5,0,
  0,250,5,0,0,251,5,0,0,4,6,0,0,15,6,0,0,31,6,0,0,50,6,0,0,69,6,0,0,88,6,0,0,
  107,6,0,0,126,6,0,0,143,6,0,0,159,6,0,0,168,6,0,0,169,6,0,0,186,6,0,0,205,6,
  0,0,224,6,0,0,243,6,0,0,10,7,0,0,27,7,0,0,47,7,0,0,66,7,0,0,84,7,0,0,101,7,0,
  0,112,7,0,0,113,7,0,0,126,7,0,0,145,7,0,0,164,7,0,0,183,7,0,0,202,7,0,0,216,
  7,0,0,222,7,0,0,223,7,0,0,240,7,0,0,3,8,0,0,22,8,0,0,40,8,0,0,58,8,0,0,79,8,
  0,0,97,8,0,0,115,8,0,0,134,8,0,0,153,8,0,0,170,8,0,0,171,8,0,0,187,8,0,0,205,
  8,0,0,224,8,0,0,243,8,0,0,5,9,0,0,28,9,0,0,53,9,0,0,75,9,0,0,97,9,0,0,119,9,
  0,0,140,9,0,0,141,9,0,0,158,9,0,0,179,9,0,0,201,9,0,0,223,9,0,0,245,9,0,0,14,
  10,0,0,36,10,0,0,58,10,0,0,80,10,0,0,101,10,0,0,3,8,6,6,6,6,6,6,6,6,6,6,255,
  2,10,6,6,86,87,88,90,91,92,94,95,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,
  95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,
  0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,
  6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,
  8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,255,1,12,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,
  6,90,91,6,6,6,95,96,6,6,255,1,2,6,6,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,5,
  4,6,6,90,91,6,6,255,1,2,6,6,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,0,14,6,6,
  84,85,6,6,6,90,91,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,6,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,87,6,90,91,92,94,95,95,96,6,6,255,1,4,6,6,6,
  6,6,6,6,7,6,6,6,6,6,6,6,6,6,255,255,5,8,6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,
  90,91,92,94,95,95,96,6,6,255,3,11,6,6,87,88,90,91,92,94,95,95,96,6,6,255,2,
  12,6,6,86,87,88,6,91,92,6,6,95,96,6,6,255,1,9,6,6,85,86,87,6,6,91,92,6,6,11,
  2,6,6,6,6,255,0,5,6,6,84,85,86,6,6,6,4,6,6,91,92,6,6,255,0,4,6,6,84,85,6,6,6,
  4,6,6,91,92,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,91,92,6,6,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,
  1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,6,84,85,86,6,6,11,2,6,
  6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,
  88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,
  6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,
  6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,6,6,96,6,6,255,0,6,6,
  6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,255,255,255,255,2,4,6,6,
  6,6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,88,6,6,8,6,6,6,94,95,95,96,6,6,
  255,0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,95,96,6,6,255,0,9,6,6,84,85,6,
  87,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,84,85,6,6,88,90,91,6,6,10,4,6,
  6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,
  4,6,6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,
  90,91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,6,8,6,6,91,92,94,95,95,96,6,
  6,255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,95,95,6,6,255,1,4,6,6,6,6,6,6,8,
  4,6,6,6,6,6,6,255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,
  6,84,85,86,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,
  0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,
  6,6,96,6,6,255,0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,
  255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,
  6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,
  2,6,6,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,255,0,9,6,6,84,85,86,6,6,
  90,91,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,6,6,95,96,6,6,
  255,1,13,6,6,85,86,87,88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,6,6,6,6,91,92,
  94,95,95,96,6,6,255,7,6,6,6,6,6,6,6,6,6,255,255,1,2,6,6,6,6,11,2,6,6,6,6,255,
  0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,
  92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,
  0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,1,2,6,6,6,6,11,3,6,6,96,6,6,255,
  12,1,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,
  88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,
  6,6,255,1,13,6,6,6,86,87,88,90,6,6,6,6,95,96,6,6,255,3,6,6,6,87,88,90,91,6,6,
  11,3,6,6,96,6,6,255,1,1,6,6,6,4,6,6,6,88,90,91,92,6,6,12,1,6,6,6,255,0,3,6,6,
  84,6,6,5,6,6,6,90,91,92,94,6,6,255,0,13,6,6,84,85,6,6,6,6,91,92,94,95,6,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,
  2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,95,95,96,
  6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,
  86,87,6,6,6,6,6,95,95,96,6,6,255,0,5,6,6,84,85,86,6,6,10,4,6,6,95,96,6,6,255,
  0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,
  6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,6,6,95,95,
  96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,6,94,95,95,96,6,6,255,0,4,6,6,84,
  85,6,6,5,9,6,6,90,91,6,94,95,95,96,6,6,255,1,2,6,6,6,6,6,2,6,6,6,6,9,4,6,6,6,
  6,6,6,255,255,2,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,88,6,6,8,
  6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,95,96,6,6,
  255,0,9,6,6,84,85,6,87,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,84,85,6,6,
  88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,
  6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,6,255,0,4,6,
  6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,6,8,6,6,
  91,92,94,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,95,95,6,6,
  255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,255,
};

static const char m_enem[]=  // "Enemies" // 2022/07/02 REKKR lump by brightentayle
{
  80,0,15,0,0,0,0,0,72,1,0,0,87,1,0,0,104,1,0,0,123,1,0,0,142,1,0,0,167,1,0,0,
  192,1,0,0,215,1,0,0,232,1,0,0,251,1,0,0,16,2,0,0,33,2,0,0,34,2,0,0,51,2,0,0,
  70,2,0,0,89,2,0,0,107,2,0,0,125,2,0,0,146,2,0,0,164,2,0,0,182,2,0,0,201,2,0,
  0,220,2,0,0,237,2,0,0,238,2,0,0,253,2,0,0,14,3,0,0,33,3,0,0,52,3,0,0,77,3,0,
  0,102,3,0,0,125,3,0,0,142,3,0,0,161,3,0,0,182,3,0,0,199,3,0,0,200,3,0,0,216,
  3,0,0,234,3,0,0,253,3,0,0,16,4,0,0,35,4,0,0,49,4,0,0,63,4,0,0,77,4,0,0,96,4,
  0,0,115,4,0,0,134,4,0,0,152,4,0,0,168,4,0,0,169,4,0,0,182,4,0,0,201,4,0,0,
  220,4,0,0,239,4,0,0,2,5,0,0,16,5,0,0,22,5,0,0,37,5,0,0,54,5,0,0,73,5,0,0,92,
  5,0,0,117,5,0,0,142,5,0,0,165,5,0,0,182,5,0,0,201,5,0,0,222,5,0,0,239,5,0,0,
  240,5,0,0,1,6,0,0,22,6,0,0,44,6,0,0,66,6,0,0,88,6,0,0,113,6,0,0,135,6,0,0,
  157,6,0,0,179,6,0,0,200,6,0,0,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,
  86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,0,14,6,6,84,85,86,6,88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,85,
  6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,
  6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,
  255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,
  95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,
  6,6,6,9,4,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,
  84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,
  94,95,95,96,6,6,255,1,13,6,6,6,86,87,88,90,6,6,6,6,95,96,6,6,255,3,6,6,6,87,
  88,90,91,6,6,11,3,6,6,96,6,6,255,1,1,6,6,6,4,6,6,6,88,90,91,92,6,6,12,1,6,6,
  6,255,0,3,6,6,84,6,6,5,6,6,6,90,91,92,94,6,6,255,0,13,6,6,84,85,6,6,6,6,91,
  92,94,95,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,
  6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,
  94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,
  6,84,85,86,6,88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,
  6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,
  96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,
  85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,
  0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,
  6,6,6,6,255,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,1,13,6,6,85,86,87,88,90,
  91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,95,96,6,6,255,0,8,6,6,84,85,86,6,6,6,6,6,
  11,2,6,6,6,6,255,0,9,6,6,84,85,86,87,88,90,91,6,6,255,1,9,6,6,85,86,87,88,90,
  91,92,6,6,255,0,9,6,6,84,85,86,87,88,90,91,6,6,255,0,8,6,6,84,85,86,6,6,6,6,
  6,11,2,6,6,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,
  85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,2,6,6,6,6,11,2,6,6,6,
  6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,1,2,6,6,6,6,11,3,6,6,96,6,
  6,255,12,1,6,6,6,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,
  90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,6,88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,
  6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,
  4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,
  6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,
  6,255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,
  4,6,6,6,6,6,6,255,255,2,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,
  88,6,6,8,6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,
  95,96,6,6,255,0,9,6,6,84,85,6,87,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,
  84,85,6,6,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,
  91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,
  6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,
  6,6,6,8,6,6,91,92,94,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,
  95,95,6,6,255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,255,
};

static const char m_stat[]=  // "Status Bar / HUD" // 2022/07/02 REKKR lump by brightentayle
{
  166,0,15,0,0,0,0,0,160,2,0,0,177,2,0,0,198,2,0,0,220,2,0,0,242,2,0,0,8,3,0,0,
  33,3,0,0,55,3,0,0,77,3,0,0,99,3,0,0,120,3,0,0,137,3,0,0,138,3,0,0,147,3,0,0,
  158,3,0,0,174,3,0,0,193,3,0,0,212,3,0,0,231,3,0,0,250,3,0,0,13,4,0,0,30,4,0,
  0,46,4,0,0,55,4,0,0,56,4,0,0,69,4,0,0,84,4,0,0,100,4,0,0,117,4,0,0,137,4,0,0,
  155,4,0,0,178,4,0,0,197,4,0,0,216,4,0,0,235,4,0,0,252,4,0,0,253,4,0,0,6,5,0,
  0,17,5,0,0,33,5,0,0,52,5,0,0,71,5,0,0,90,5,0,0,109,5,0,0,128,5,0,0,145,5,0,0,
  161,5,0,0,170,5,0,0,171,5,0,0,187,5,0,0,205,5,0,0,224,5,0,0,243,5,0,0,2,6,0,
  0,11,6,0,0,26,6,0,0,45,6,0,0,64,6,0,0,83,6,0,0,100,6,0,0,101,6,0,0,118,6,0,0,
  139,6,0,0,161,6,0,0,183,6,0,0,205,6,0,0,230,6,0,0,252,6,0,0,18,7,0,0,40,7,0,
  0,61,7,0,0,78,7,0,0,79,7,0,0,80,7,0,0,81,7,0,0,82,7,0,0,83,7,0,0,100,7,0,0,
  119,7,0,0,138,7,0,0,157,7,0,0,182,7,0,0,207,7,0,0,232,7,0,0,251,7,0,0,14,8,0,
  0,31,8,0,0,48,8,0,0,49,8,0,0,62,8,0,0,77,8,0,0,93,8,0,0,110,8,0,0,130,8,0,0,
  148,8,0,0,171,8,0,0,190,8,0,0,209,8,0,0,228,8,0,0,245,8,0,0,246,8,0,0,7,9,0,
  0,26,9,0,0,45,9,0,0,64,9,0,0,87,9,0,0,104,9,0,0,124,9,0,0,143,9,0,0,161,9,0,
  0,178,9,0,0,189,9,0,0,190,9,0,0,191,9,0,0,192,9,0,0,193,9,0,0,194,9,0,0,201,
  9,0,0,211,9,0,0,223,9,0,0,237,9,0,0,251,9,0,0,9,10,0,0,22,10,0,0,33,10,0,0,
  42,10,0,0,48,10,0,0,49,10,0,0,50,10,0,0,51,10,0,0,52,10,0,0,53,10,0,0,70,10,
  0,0,89,10,0,0,108,10,0,0,127,10,0,0,148,10,0,0,157,10,0,0,178,10,0,0,197,10,
  0,0,216,10,0,0,235,10,0,0,255,10,0,0,0,11,0,0,16,11,0,0,34,11,0,0,53,11,0,0,
  72,11,0,0,87,11,0,0,96,11,0,0,111,11,0,0,130,11,0,0,149,11,0,0,168,11,0,0,
  185,11,0,0,186,11,0,0,203,11,0,0,222,11,0,0,241,11,0,0,4,12,0,0,21,12,0,0,38,
  12,0,0,57,12,0,0,76,12,0,0,93,12,0,0,108,12,0,0,2,4,6,6,6,6,6,6,9,4,6,6,6,6,
  6,6,255,1,6,6,6,85,86,87,88,6,6,8,6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,85,86,
  87,88,90,6,6,9,5,6,6,95,95,96,6,6,255,0,9,6,6,84,85,6,87,88,90,91,6,6,10,4,6,
  6,95,96,6,6,255,0,9,6,6,84,85,6,6,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,
  6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,
  6,90,91,92,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,
  6,255,0,5,6,6,84,85,86,6,6,6,8,6,6,91,92,94,95,95,96,6,6,255,0,6,6,6,84,85,
  86,87,6,6,7,6,6,6,92,94,95,95,6,6,255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,255,
  255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,6,84,85,86,6,6,11,
  2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,
  85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,6,6,96,6,6,255,0,
  6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,255,5,8,6,6,6,6,6,6,
  6,6,6,6,255,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,3,11,6,6,87,88,90,91,92,
  94,95,95,96,6,6,255,2,12,6,6,86,87,88,6,91,92,6,6,95,96,6,6,255,1,9,6,6,85,
  86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,0,5,6,6,84,85,86,6,6,6,4,6,6,91,92,6,6,
  255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,
  6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,255,255,1,4,6,6,6,6,6,6,255,0,6,6,6,84,85,86,87,6,6,255,0,5,6,
  6,84,85,86,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,
  0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,11,3,
  6,6,96,6,6,255,0,6,6,6,84,85,86,87,6,6,12,1,6,6,6,255,1,4,6,6,6,6,6,6,255,
  255,1,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,13,6,6,84,85,86,87,88,90,91,92,94,
  95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,
  84,85,6,6,6,6,6,6,6,95,95,96,6,6,255,1,2,6,6,6,6,10,4,6,6,95,96,6,6,255,10,4,
  6,6,95,96,6,6,255,1,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,
  6,6,6,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,
  0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,255,255,2,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,88,6,
  6,8,6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,95,96,
  6,6,255,0,9,6,6,84,85,6,87,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,84,85,
  6,6,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,
  10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,6,255,
  0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,6,
  8,6,6,91,92,94,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,95,95,
  6,6,255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,255,255,255,255,255,255,1,12,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,5,255,
  0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,5,255,0,14,5,5,83,84,5,5,5,5,
  5,5,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,5,4,5,5,88,89,5,5,10,4,5,5,94,96,5,5,
  255,0,4,5,5,83,84,5,5,5,4,5,5,88,89,5,5,10,4,5,5,94,96,5,5,255,0,4,5,5,83,84,
  5,5,5,4,5,5,88,89,5,5,10,4,5,5,94,96,5,5,255,0,14,5,5,83,84,5,5,87,88,89,91,
  5,5,94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,94,96,5,5,255,1,12,
  5,5,84,84,86,87,5,5,91,92,94,94,5,5,255,2,4,5,5,5,5,5,5,8,4,5,5,5,5,5,5,255,
  255,5,8,6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,3,
  11,6,6,87,88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,86,87,88,6,91,92,6,6,95,
  96,6,6,255,1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,6,255,0,5,6,6,84,85,86,
  6,6,6,4,6,6,91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,91,92,6,6,11,2,6,6,6,6,
  255,0,14,6,6,84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,
  86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,6,95,96,6,
  6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,2,6,6,6,6,255,0,4,6,6,84,85,6,6,
  5,4,6,6,90,91,6,6,255,0,9,6,6,84,85,86,6,6,90,91,6,6,11,2,6,6,6,6,255,0,14,6,
  6,84,85,86,87,88,90,91,92,6,6,95,96,6,6,255,1,13,6,6,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,2,12,6,6,6,6,6,6,91,92,94,95,95,96,6,6,255,7,6,6,6,6,6,6,6,
  6,6,255,255,255,255,255,255,11,2,5,5,5,5,255,9,5,5,5,5,94,96,5,5,255,7,7,5,5,
  5,94,94,94,96,5,5,255,5,9,5,5,5,89,91,93,94,94,5,5,5,255,3,9,5,5,5,87,88,89,
  91,93,5,5,5,255,1,9,5,5,5,86,86,87,88,89,5,5,5,255,0,8,5,5,83,84,84,86,87,5,
  5,5,255,0,6,5,5,83,84,84,5,5,5,255,0,4,5,5,83,5,5,5,255,1,1,5,5,5,255,255,
  255,255,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,0,14,6,6,84,85,6,6,6,90,91,6,6,6,95,96,6,6,255,1,2,6,6,6,6,5,4,6,6,90,
  91,6,6,11,2,6,6,6,6,255,5,4,6,6,90,91,6,6,255,1,2,6,6,6,6,5,4,6,6,90,91,6,6,
  11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,90,91,6,6,6,95,96,6,6,255,0,14,6,6,84,
  85,86,87,6,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,6,90,91,92,94,
  95,95,96,6,6,255,1,4,6,6,6,6,6,6,6,7,6,6,6,6,6,6,6,6,6,255,255,1,11,6,6,6,6,
  6,6,6,6,6,6,6,6,6,255,0,13,6,6,84,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,
  6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,
  95,95,96,6,6,255,1,2,6,6,6,6,10,4,6,6,95,96,6,6,255,10,4,6,6,95,96,6,6,255,1,
  2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,14,6,6,84,85,6,6,6,6,6,6,6,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,
  87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,
  1,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,93,94,
  94,96,5,5,255,0,14,5,5,83,84,84,86,87,88,89,91,92,94,94,96,5,5,255,0,14,5,5,
  83,84,5,5,5,5,5,5,5,5,94,96,5,5,255,0,4,5,5,83,84,5,5,10,4,5,5,94,96,5,5,255,
  0,4,5,5,83,84,5,5,10,4,5,5,94,96,5,5,255,0,5,5,5,83,84,84,5,5,9,5,5,5,94,94,
  96,5,5,255,0,14,5,5,83,84,84,86,5,5,5,5,93,94,94,96,5,5,255,1,12,5,5,84,84,
  86,87,88,89,91,93,94,94,5,5,255,2,10,5,5,84,86,87,88,89,91,93,94,5,5,255,3,8,
  5,5,5,5,5,5,5,5,5,5,255,
};



static const char m_weap[]=  // "Weapons" // 2022/07/02 REKKR lump by brightentayle
{
  85,0,15,0,0,0,0,0,92,1,0,0,108,1,0,0,126,1,0,0,145,1,0,0,164,1,0,0,183,1,0,0,
  197,1,0,0,211,1,0,0,225,1,0,0,244,1,0,0,7,2,0,0,26,2,0,0,44,2,0,0,60,2,0,0,
  61,2,0,0,76,2,0,0,93,2,0,0,112,2,0,0,131,2,0,0,156,2,0,0,181,2,0,0,204,2,0,0,
  221,2,0,0,240,2,0,0,5,3,0,0,22,3,0,0,23,3,0,0,36,3,0,0,51,3,0,0,67,3,0,0,84,
  3,0,0,104,3,0,0,122,3,0,0,145,3,0,0,164,3,0,0,183,3,0,0,202,3,0,0,219,3,0,0,
  220,3,0,0,237,3,0,0,0,4,0,0,19,4,0,0,38,4,0,0,62,4,0,0,84,4,0,0,101,4,0,0,
  115,4,0,0,129,4,0,0,141,4,0,0,151,4,0,0,152,4,0,0,167,4,0,0,184,4,0,0,203,4,
  0,0,222,4,0,0,239,4,0,0,0,5,0,0,17,5,0,0,36,5,0,0,55,5,0,0,72,5,0,0,87,5,0,0,
  88,5,0,0,105,5,0,0,124,5,0,0,143,5,0,0,161,5,0,0,179,5,0,0,200,5,0,0,218,5,0,
  0,236,5,0,0,255,5,0,0,18,6,0,0,35,6,0,0,36,6,0,0,53,6,0,0,74,6,0,0,96,6,0,0,
  118,6,0,0,140,6,0,0,165,6,0,0,187,6,0,0,209,6,0,0,231,6,0,0,252,6,0,0,1,11,6,
  6,6,6,6,6,6,6,6,6,6,6,6,255,0,13,6,6,84,85,86,87,88,90,91,92,94,95,95,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,6,
  6,6,6,6,6,95,95,96,6,6,255,1,2,6,6,6,6,6,8,6,6,6,6,6,95,95,96,6,6,255,5,9,6,
  6,90,91,92,94,95,95,96,6,6,255,4,9,6,6,88,90,91,92,94,95,95,6,6,255,5,9,6,6,
  90,91,92,94,95,95,96,6,6,255,1,2,6,6,6,6,6,8,6,6,6,6,6,95,95,96,6,6,255,0,14,
  6,6,84,85,6,6,6,6,6,6,6,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,
  95,95,96,6,6,255,0,13,6,6,84,85,86,87,88,90,91,92,94,95,95,6,6,255,1,11,6,6,
  6,6,6,6,6,6,6,6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,
  86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,
  96,6,6,255,0,14,6,6,84,85,86,6,88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,85,
  6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,
  6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,
  255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,
  95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,
  6,6,6,9,4,6,6,6,6,6,6,255,255,5,8,6,6,6,6,6,6,6,6,6,6,255,4,10,6,6,88,90,91,
  92,94,95,95,96,6,6,255,3,11,6,6,87,88,90,91,92,94,95,95,96,6,6,255,2,12,6,6,
  86,87,88,6,91,92,6,6,95,96,6,6,255,1,9,6,6,85,86,87,6,6,91,92,6,6,11,2,6,6,6,
  6,255,0,5,6,6,84,85,86,6,6,6,4,6,6,91,92,6,6,255,0,4,6,6,84,85,6,6,6,4,6,6,
  91,92,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,91,92,6,6,95,96,6,6,255,0,
  14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,
  6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,6,
  6,6,90,91,6,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,11,3,6,6,
  96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,12,1,6,6,6,255,0,4,6,6,84,85,
  6,6,5,4,6,6,90,91,6,6,255,0,9,6,6,84,85,86,6,88,90,91,6,6,255,0,9,6,6,84,85,
  86,87,88,90,91,6,6,255,1,7,6,6,85,86,87,88,90,6,6,255,2,5,6,6,6,6,6,6,6,255,
  255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,
  6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,
  86,6,6,6,6,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,
  6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,
  255,0,14,6,6,84,85,86,6,6,6,6,6,6,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,255,
  2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,255,1,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,255,0,
  14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,
  90,91,92,94,95,95,96,6,6,255,1,13,6,6,6,86,87,88,90,6,6,6,6,95,96,6,6,255,3,
  6,6,6,87,88,90,91,6,6,11,3,6,6,96,6,6,255,1,1,6,6,6,4,6,6,6,88,90,91,92,6,6,
  12,1,6,6,6,255,0,3,6,6,84,6,6,5,6,6,6,90,91,92,94,6,6,255,0,13,6,6,84,85,6,6,
  6,6,91,92,94,95,6,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,255,255,2,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,
  88,6,6,8,6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,
  95,96,6,6,255,0,9,6,6,84,85,6,87,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,
  84,85,6,6,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,
  91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,
  6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,
  6,6,6,8,6,6,91,92,94,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,
  95,95,6,6,255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,255,
};

static const char m_mess[]=  // "Messages" // 2022/07/02 REKKR lump by brightentayle
{
  97,0,15,0,0,0,0,0,140,1,0,0,156,1,0,0,174,1,0,0,193,1,0,0,212,1,0,0,231,1,0,
  0,245,1,0,0,3,2,0,0,17,2,0,0,36,2,0,0,55,2,0,0,74,2,0,0,92,2,0,0,108,2,0,0,
  109,2,0,0,124,2,0,0,141,2,0,0,160,2,0,0,179,2,0,0,204,2,0,0,229,2,0,0,252,2,
  0,0,13,3,0,0,32,3,0,0,53,3,0,0,70,3,0,0,71,3,0,0,88,3,0,0,109,3,0,0,131,3,0,
  0,153,3,0,0,175,3,0,0,200,3,0,0,222,3,0,0,244,3,0,0,10,4,0,0,31,4,0,0,48,4,0,
  0,49,4,0,0,66,4,0,0,87,4,0,0,109,4,0,0,131,4,0,0,153,4,0,0,178,4,0,0,200,4,0,
  0,222,4,0,0,244,4,0,0,9,5,0,0,26,5,0,0,27,5,0,0,40,5,0,0,55,5,0,0,71,5,0,0,
  88,5,0,0,108,5,0,0,126,5,0,0,149,5,0,0,168,5,0,0,187,5,0,0,206,5,0,0,223,5,0,
  0,224,5,0,0,240,5,0,0,2,6,0,0,21,6,0,0,40,6,0,0,58,6,0,0,81,6,0,0,106,6,0,0,
  128,6,0,0,150,6,0,0,172,6,0,0,193,6,0,0,194,6,0,0,209,6,0,0,226,6,0,0,245,6,
  0,0,8,7,0,0,33,7,0,0,58,7,0,0,81,7,0,0,98,7,0,0,117,7,0,0,138,7,0,0,155,7,0,
  0,156,7,0,0,173,7,0,0,194,7,0,0,216,7,0,0,238,7,0,0,4,8,0,0,29,8,0,0,51,8,0,
  0,73,8,0,0,95,8,0,0,116,8,0,0,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,1,13,6,6,85,
  86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,95,96,6,6,255,0,8,6,6,84,85,86,
  6,6,6,6,6,11,2,6,6,6,6,255,0,9,6,6,84,85,86,87,88,90,91,6,6,255,1,9,6,6,85,
  86,87,88,90,91,92,6,6,255,0,9,6,6,84,85,86,87,88,90,91,6,6,255,0,8,6,6,84,85,
  86,6,6,6,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,86,6,6,6,6,6,6,6,95,96,6,6,255,
  0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,13,6,6,85,86,87,88,90,
  91,92,94,95,95,96,6,6,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,255,2,10,6,6,6,
  6,6,6,6,6,6,6,6,6,255,1,12,6,6,85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,
  6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,6,88,90,91,
  92,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,
  255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,
  6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,
  255,0,5,6,6,84,85,86,6,6,9,5,6,6,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,8,
  6,6,6,94,95,95,96,6,6,255,1,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,255,2,4,6,6,6,
  6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,88,6,6,8,6,6,6,94,95,95,96,6,6,
  255,0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,95,96,6,6,255,0,9,6,6,84,85,6,
  87,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,84,85,6,6,88,90,91,6,6,10,4,6,
  6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,
  4,6,6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,
  90,91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,6,8,6,6,91,92,94,95,95,96,6,
  6,255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,95,95,6,6,255,1,4,6,6,6,6,6,6,8,
  4,6,6,6,6,6,6,255,255,2,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,85,86,87,
  88,6,6,8,6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,85,86,87,88,90,6,6,9,5,6,6,95,
  95,96,6,6,255,0,9,6,6,84,85,6,87,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,9,6,6,
  84,85,6,6,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,
  91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,6,6,95,96,6,
  6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,6,255,0,5,6,6,84,85,86,
  6,6,6,8,6,6,91,92,94,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,7,6,6,6,92,94,
  95,95,6,6,255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,255,255,5,8,6,6,6,6,6,6,6,6,6,
  6,255,4,10,6,6,88,90,91,92,94,95,95,96,6,6,255,3,11,6,6,87,88,90,91,92,94,95,
  95,96,6,6,255,2,12,6,6,86,87,88,6,91,92,6,6,95,96,6,6,255,1,9,6,6,85,86,87,6,
  6,91,92,6,6,11,2,6,6,6,6,255,0,5,6,6,84,85,86,6,6,6,4,6,6,91,92,6,6,255,0,4,
  6,6,84,85,6,6,6,4,6,6,91,92,6,6,11,2,6,6,6,6,255,0,14,6,6,84,85,6,6,6,6,91,
  92,6,6,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,0,
  14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,255,1,12,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,255,255,2,11,6,6,6,6,6,6,6,6,6,6,6,6,6,255,1,13,6,6,85,86,87,88,90,
  91,92,94,95,95,96,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,95,96,6,6,
  255,0,14,6,6,84,85,86,87,6,6,6,6,6,95,95,96,6,6,255,0,5,6,6,84,85,86,6,6,10,
  4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,6,255,0,4,
  6,6,84,85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,
  6,6,90,91,6,6,95,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,6,94,95,95,96,
  6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,6,94,95,95,96,6,6,255,1,2,6,6,6,6,6,
  2,6,6,6,6,9,4,6,6,6,6,6,6,255,255,2,10,6,6,6,6,6,6,6,6,6,6,6,6,255,1,12,6,6,
  85,86,87,88,90,91,92,94,95,95,6,6,255,0,14,6,6,84,85,86,87,88,90,91,92,94,95,
  95,96,6,6,255,0,14,6,6,84,85,86,6,88,90,91,92,6,95,95,96,6,6,255,0,4,6,6,84,
  85,6,6,5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,4,6,6,90,
  91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,6,2,6,6,6,6,10,4,6,6,95,96,6,
  6,255,0,4,6,6,84,85,6,6,10,4,6,6,95,96,6,6,255,0,5,6,6,84,85,86,6,6,9,5,6,6,
  95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,8,6,6,6,94,95,95,96,6,6,255,1,4,6,6,
  6,6,6,6,9,4,6,6,6,6,6,6,255,255,2,4,6,6,6,6,6,6,9,4,6,6,6,6,6,6,255,1,6,6,6,
  85,86,87,88,6,6,8,6,6,6,94,95,95,96,6,6,255,0,8,6,6,84,85,86,87,88,90,6,6,9,
  5,6,6,95,95,96,6,6,255,0,9,6,6,84,85,6,87,88,90,91,6,6,10,4,6,6,95,96,6,6,
  255,0,9,6,6,84,85,6,6,88,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,
  5,4,6,6,90,91,6,6,10,4,6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,
  6,6,95,96,6,6,255,0,4,6,6,84,85,6,6,5,9,6,6,90,91,92,94,6,95,96,6,6,255,0,5,
  6,6,84,85,86,6,6,6,8,6,6,91,92,94,95,95,96,6,6,255,0,6,6,6,84,85,86,87,6,6,7,
  6,6,6,92,94,95,95,6,6,255,1,4,6,6,6,6,6,6,8,4,6,6,6,6,6,6,255,
};


static const char m_colors[]=  // Palette for color selection
{
  137,  0,137,  0,  0,  0,  0,  0,
   44,  2,  0,  0,186,  2,  0,  0, 72,  3,  0,  0,214,  3,  0,  0,
  100,  4,  0,  0,242,  4,  0,  0,128,  5,  0,  0, 14,  6,  0,  0,
  156,  6,  0,  0, 42,  7,  0,  0,184,  7,  0,  0, 70,  8,  0,  0,
  212,  8,  0,  0, 98,  9,  0,  0,240,  9,  0,  0,126, 10,  0,  0,
   12, 11,  0,  0,154, 11,  0,  0, 40, 12,  0,  0,182, 12,  0,  0,
   68, 13,  0,  0,210, 13,  0,  0, 96, 14,  0,  0,238, 14,  0,  0,
  124, 15,  0,  0, 10, 16,  0,  0,152, 16,  0,  0, 38, 17,  0,  0,
  180, 17,  0,  0, 66, 18,  0,  0,208, 18,  0,  0, 94, 19,  0,  0,
  236, 19,  0,  0,122, 20,  0,  0,  8, 21,  0,  0,150, 21,  0,  0,
   36, 22,  0,  0,178, 22,  0,  0, 64, 23,  0,  0,206, 23,  0,  0,
   92, 24,  0,  0,234, 24,  0,  0,120, 25,  0,  0,  6, 26,  0,  0,
  148, 26,  0,  0, 34, 27,  0,  0,176, 27,  0,  0, 62, 28,  0,  0,
  204, 28,  0,  0, 90, 29,  0,  0,232, 29,  0,  0,118, 30,  0,  0,
    4, 31,  0,  0,146, 31,  0,  0, 32, 32,  0,  0,174, 32,  0,  0,
   60, 33,  0,  0,202, 33,  0,  0, 88, 34,  0,  0,230, 34,  0,  0,
  116, 35,  0,  0,  2, 36,  0,  0,144, 36,  0,  0, 30, 37,  0,  0,
  172, 37,  0,  0, 58, 38,  0,  0,200, 38,  0,  0, 86, 39,  0,  0,
  228, 39,  0,  0,114, 40,  0,  0,  0, 41,  0,  0,142, 41,  0,  0,
   28, 42,  0,  0,170, 42,  0,  0, 56, 43,  0,  0,198, 43,  0,  0,
   84, 44,  0,  0,226, 44,  0,  0,112, 45,  0,  0,254, 45,  0,  0,
  140, 46,  0,  0, 26, 47,  0,  0,168, 47,  0,  0, 54, 48,  0,  0,
  196, 48,  0,  0, 82, 49,  0,  0,224, 49,  0,  0,110, 50,  0,  0,
  252, 50,  0,  0,138, 51,  0,  0, 24, 52,  0,  0,166, 52,  0,  0,
   52, 53,  0,  0,194, 53,  0,  0, 80, 54,  0,  0,222, 54,  0,  0,
  108, 55,  0,  0,250, 55,  0,  0,136, 56,  0,  0, 22, 57,  0,  0,
  164, 57,  0,  0, 50, 58,  0,  0,192, 58,  0,  0, 78, 59,  0,  0,
  220, 59,  0,  0,106, 60,  0,  0,248, 60,  0,  0,134, 61,  0,  0,
   20, 62,  0,  0,162, 62,  0,  0, 48, 63,  0,  0,190, 63,  0,  0,
   76, 64,  0,  0,218, 64,  0,  0,104, 65,  0,  0,246, 65,  0,  0,
  132, 66,  0,  0, 18, 67,  0,  0,160, 67,  0,  0, 46, 68,  0,  0,
  188, 68,  0,  0, 74, 69,  0,  0,216, 69,  0,  0,102, 70,  0,  0,
  244, 70,  0,  0,130, 71,  0,  0, 16, 72,  0,  0,158, 72,  0,  0,
   44, 73,  0,  0,186, 73,  0,  0, 72, 74,  0,  0,214, 74,  0,  0,
  100, 75,  0,  0,242, 75,  0,  0,128, 76,  0,  0, 14, 77,  0,  0,
  156, 77,  0,  0,  0,137,  0, 91, 91, 91, 94, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 98,
    0,255,  0,137,  0, 91, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,105,  0,255,
    0,137,  0, 91, 98,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105, 94, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  4,  0,  0,  0,  0,  0,  4,  0, 16, 16, 16, 16, 16, 16,
   16,  0, 32, 32, 32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48,
   48,  0, 64, 64, 64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80,
   80,  0, 96, 96, 96, 96, 96, 96, 96,  0,112,112,112,112,112,112,
  112,  0,128,128,128,128,128,128,128,  0,144,144,144,144,144,144,
  144,  0,160,160,160,160,160,160,160,  0,176,176,176,176,176,176,
  176,  0,192,192,192,192,192,192,192,  0,255,255,255,255,255,255,
  255,  0,255,255,255,255,255,255,255,  0,207,207,207,207,207,207,
  207,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    0,  4,  0,  0,  0,  4,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0,
   32, 32, 32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0,
   64, 64, 64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0,
   96, 96, 96, 96, 96, 96, 96,  0,112,112,112,112,112,112,112,  0,
  128,128,128,128,128,128,128,  0,144,144,144,144,144,144,144,  0,
  160,160,160,160,160,160,160,  0,176,176,176,176,176,176,176,  0,
  192,192,192,192,192,192,192,  0,255,255,255,255,255,255,255,  0,
  255,255,255,255,255,255,255,  0,207,207,207,207,207,207,207,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,
    4,  0,  4,  0,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32,
   32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64,
   64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96,
   96, 96, 96, 96, 96,  0,112,112,112,112,112,112,112,  0,128,128,
  128,128,128,128,128,  0,144,144,144,144,144,144,144,  0,160,160,
  160,160,160,160,160,  0,176,176,176,176,176,176,176,  0,192,192,
  192,192,192,192,192,  0,255,255,255,255,255,255,255,  0,255,255,
  255,255,255,255,255,  0,207,207,207,207,207,207,207,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,  0,  4,
    0,  0,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32,
   32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64,
   64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96,
   96, 96, 96,  0,112,112,112,112,112,112,112,  0,128,128,128,128,
  128,128,128,  0,144,144,144,144,144,144,144,  0,160,160,160,160,
  160,160,160,  0,176,176,176,176,176,176,176,  0,192,192,192,192,
  192,192,192,  0,255,255,255,255,255,255,255,  0,255,255,255,255,
  255,255,255,  0,207,207,207,207,207,207,207,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,  4,  0,  4,  0,
    0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32,
   32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64,
   64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96,
   96,  0,112,112,112,112,112,112,112,  0,128,128,128,128,128,128,
  128,  0,144,144,144,144,144,144,144,  0,160,160,160,160,160,160,
  160,  0,176,176,176,176,176,176,176,  0,192,192,192,192,192,192,
  192,  0,255,255,255,255,255,255,255,  0,255,255,255,255,255,255,
  255,  0,207,207,207,207,207,207,207,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,
   16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32, 32,  0,
   48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64, 64,  0,
   80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96, 96,  0,
  112,112,112,112,112,112,112,  0,128,128,128,128,128,128,128,  0,
  144,144,144,144,144,144,144,  0,160,160,160,160,160,160,160,  0,
  176,176,176,176,176,176,176,  0,192,192,192,192,192,192,192,  0,
  255,255,255,255,255,255,255,  0,255,255,255,255,255,255,255,  0,
  207,207,207,207,207,207,207,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  4,  0,  0,  0,  0,  0,  4,  0, 16, 16,
   16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32, 32,  0, 48, 48,
   48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64, 64,  0, 80, 80,
   80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96, 96,  0,112,112,
  112,112,112,112,112,  0,128,128,128,128,128,128,128,  0,144,144,
  144,144,144,144,144,  0,160,160,160,160,160,160,160,  0,176,176,
  176,176,176,176,176,  0,192,192,192,192,192,192,192,  0,255,255,
  255,255,255,255,255,  0,255,255,255,255,255,255,255,  0,207,207,
  207,207,207,207,207,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  1,  1,  1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17,
   17,  0, 33, 33, 33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49,
   49,  0, 65, 65, 65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81,
   81,  0, 97, 97, 97, 97, 97, 97, 97,  0,113,113,113,113,113,113,
  113,  0,129,129,129,129,129,129,129,  0,145,145,145,145,145,145,
  145,  0,161,161,161,161,161,161,161,  0,177,177,177,177,177,177,
  177,  0,193,193,193,193,193,193,193,  0,209,209,209,209,209,209,
  209,  0,225,225,225,225,225,225,225,  0,241,241,241,241,241,241,
  241,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    1,  1,  1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0,
   33, 33, 33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0,
   65, 65, 65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0,
   97, 97, 97, 97, 97, 97, 97,  0,113,113,113,113,113,113,113,  0,
  129,129,129,129,129,129,129,  0,145,145,145,145,145,145,145,  0,
  161,161,161,161,161,161,161,  0,177,177,177,177,177,177,177,  0,
  193,193,193,193,193,193,193,  0,209,209,209,209,209,209,209,  0,
  225,225,225,225,225,225,225,  0,241,241,241,241,241,241,241,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,
    1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33,
   33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65,
   65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97,
   97, 97, 97, 97, 97,  0,113,113,113,113,113,113,113,  0,129,129,
  129,129,129,129,129,  0,145,145,145,145,145,145,145,  0,161,161,
  161,161,161,161,161,  0,177,177,177,177,177,177,177,  0,193,193,
  193,193,193,193,193,  0,209,209,209,209,209,209,209,  0,225,225,
  225,225,225,225,225,  0,241,241,241,241,241,241,241,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,
    1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33,
   33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65,
   65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97,
   97, 97, 97,  0,113,113,113,113,113,113,113,  0,129,129,129,129,
  129,129,129,  0,145,145,145,145,145,145,145,  0,161,161,161,161,
  161,161,161,  0,177,177,177,177,177,177,177,  0,193,193,193,193,
  193,193,193,  0,209,209,209,209,209,209,209,  0,225,225,225,225,
  225,225,225,  0,241,241,241,241,241,241,241,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,
    1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33,
   33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65,
   65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97,
   97,  0,113,113,113,113,113,113,113,  0,129,129,129,129,129,129,
  129,  0,145,145,145,145,145,145,145,  0,161,161,161,161,161,161,
  161,  0,177,177,177,177,177,177,177,  0,193,193,193,193,193,193,
  193,  0,209,209,209,209,209,209,209,  0,225,225,225,225,225,225,
  225,  0,241,241,241,241,241,241,241,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0,
   17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33, 33,  0,
   49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65, 65,  0,
   81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97, 97,  0,
  113,113,113,113,113,113,113,  0,129,129,129,129,129,129,129,  0,
  145,145,145,145,145,145,145,  0,161,161,161,161,161,161,161,  0,
  177,177,177,177,177,177,177,  0,193,193,193,193,193,193,193,  0,
  209,209,209,209,209,209,209,  0,225,225,225,225,225,225,225,  0,
  241,241,241,241,241,241,241,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0, 17, 17,
   17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33, 33,  0, 49, 49,
   49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65, 65,  0, 81, 81,
   81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97, 97,  0,113,113,
  113,113,113,113,113,  0,129,129,129,129,129,129,129,  0,145,145,
  145,145,145,145,145,  0,161,161,161,161,161,161,161,  0,177,177,
  177,177,177,177,177,  0,193,193,193,193,193,193,193,  0,209,209,
  209,209,209,209,209,  0,225,225,225,225,225,225,225,  0,241,241,
  241,241,241,241,241,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  2,  2,  2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18,
   18,  0, 34, 34, 34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50,
   50,  0, 66, 66, 66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82,
   82,  0, 98, 98, 98, 98, 98, 98, 98,  0,114,114,114,114,114,114,
  114,  0,130,130,130,130,130,130,130,  0,146,146,146,146,146,146,
  146,  0,162,162,162,162,162,162,162,  0,178,178,178,178,178,178,
  178,  0,194,194,194,194,194,194,194,  0,210,210,210,210,210,210,
  210,  0,226,226,226,226,226,226,226,  0,242,242,242,242,242,242,
  242,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    2,  2,  2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0,
   34, 34, 34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0,
   66, 66, 66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0,
   98, 98, 98, 98, 98, 98, 98,  0,114,114,114,114,114,114,114,  0,
  130,130,130,130,130,130,130,  0,146,146,146,146,146,146,146,  0,
  162,162,162,162,162,162,162,  0,178,178,178,178,178,178,178,  0,
  194,194,194,194,194,194,194,  0,210,210,210,210,210,210,210,  0,
  226,226,226,226,226,226,226,  0,242,242,242,242,242,242,242,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,
    2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34,
   34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66,
   66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98,
   98, 98, 98, 98, 98,  0,114,114,114,114,114,114,114,  0,130,130,
  130,130,130,130,130,  0,146,146,146,146,146,146,146,  0,162,162,
  162,162,162,162,162,  0,178,178,178,178,178,178,178,  0,194,194,
  194,194,194,194,194,  0,210,210,210,210,210,210,210,  0,226,226,
  226,226,226,226,226,  0,242,242,242,242,242,242,242,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,
    2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34,
   34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66,
   66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98,
   98, 98, 98,  0,114,114,114,114,114,114,114,  0,130,130,130,130,
  130,130,130,  0,146,146,146,146,146,146,146,  0,162,162,162,162,
  162,162,162,  0,178,178,178,178,178,178,178,  0,194,194,194,194,
  194,194,194,  0,210,210,210,210,210,210,210,  0,226,226,226,226,
  226,226,226,  0,242,242,242,242,242,242,242,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,
    2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34,
   34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66,
   66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98,
   98,  0,114,114,114,114,114,114,114,  0,130,130,130,130,130,130,
  130,  0,146,146,146,146,146,146,146,  0,162,162,162,162,162,162,
  162,  0,178,178,178,178,178,178,178,  0,194,194,194,194,194,194,
  194,  0,210,210,210,210,210,210,210,  0,226,226,226,226,226,226,
  226,  0,242,242,242,242,242,242,242,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,  2,  0,
   18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34, 34,  0,
   50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66, 66,  0,
   82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98, 98,  0,
  114,114,114,114,114,114,114,  0,130,130,130,130,130,130,130,  0,
  146,146,146,146,146,146,146,  0,162,162,162,162,162,162,162,  0,
  178,178,178,178,178,178,178,  0,194,194,194,194,194,194,194,  0,
  210,210,210,210,210,210,210,  0,226,226,226,226,226,226,226,  0,
  242,242,242,242,242,242,242,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,  2,  0, 18, 18,
   18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34, 34,  0, 50, 50,
   50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66, 66,  0, 82, 82,
   82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98, 98,  0,114,114,
  114,114,114,114,114,  0,130,130,130,130,130,130,130,  0,146,146,
  146,146,146,146,146,  0,162,162,162,162,162,162,162,  0,178,178,
  178,178,178,178,178,  0,194,194,194,194,194,194,194,  0,210,210,
  210,210,210,210,210,  0,226,226,226,226,226,226,226,  0,242,242,
  242,242,242,242,242,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  3,  3,  3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19,
   19,  0, 35, 35, 35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51,
   51,  0, 67, 67, 67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83,
   83,  0, 99, 99, 99, 99, 99, 99, 99,  0,115,115,115,115,115,115,
  115,  0,131,131,131,131,131,131,131,  0,147,147,147,147,147,147,
  147,  0,163,163,163,163,163,163,163,  0,179,179,179,179,179,179,
  179,  0,195,195,195,195,195,195,195,  0,211,211,211,211,211,211,
  211,  0,227,227,227,227,227,227,227,  0,243,243,243,243,243,243,
  243,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    3,  3,  3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0,
   35, 35, 35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0,
   67, 67, 67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0,
   99, 99, 99, 99, 99, 99, 99,  0,115,115,115,115,115,115,115,  0,
  131,131,131,131,131,131,131,  0,147,147,147,147,147,147,147,  0,
  163,163,163,163,163,163,163,  0,179,179,179,179,179,179,179,  0,
  195,195,195,195,195,195,195,  0,211,211,211,211,211,211,211,  0,
  227,227,227,227,227,227,227,  0,243,243,243,243,243,243,243,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,
    3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35,
   35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67,
   67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99,
   99, 99, 99, 99, 99,  0,115,115,115,115,115,115,115,  0,131,131,
  131,131,131,131,131,  0,147,147,147,147,147,147,147,  0,163,163,
  163,163,163,163,163,  0,179,179,179,179,179,179,179,  0,195,195,
  195,195,195,195,195,  0,211,211,211,211,211,211,211,  0,227,227,
  227,227,227,227,227,  0,243,243,243,243,243,243,243,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,
    3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35,
   35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67,
   67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99,
   99, 99, 99,  0,115,115,115,115,115,115,115,  0,131,131,131,131,
  131,131,131,  0,147,147,147,147,147,147,147,  0,163,163,163,163,
  163,163,163,  0,179,179,179,179,179,179,179,  0,195,195,195,195,
  195,195,195,  0,211,211,211,211,211,211,211,  0,227,227,227,227,
  227,227,227,  0,243,243,243,243,243,243,243,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,
    3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35,
   35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67,
   67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99,
   99,  0,115,115,115,115,115,115,115,  0,131,131,131,131,131,131,
  131,  0,147,147,147,147,147,147,147,  0,163,163,163,163,163,163,
  163,  0,179,179,179,179,179,179,179,  0,195,195,195,195,195,195,
  195,  0,211,211,211,211,211,211,211,  0,227,227,227,227,227,227,
  227,  0,243,243,243,243,243,243,243,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0,
   19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35, 35,  0,
   51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67, 67,  0,
   83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99, 99,  0,
  115,115,115,115,115,115,115,  0,131,131,131,131,131,131,131,  0,
  147,147,147,147,147,147,147,  0,163,163,163,163,163,163,163,  0,
  179,179,179,179,179,179,179,  0,195,195,195,195,195,195,195,  0,
  211,211,211,211,211,211,211,  0,227,227,227,227,227,227,227,  0,
  243,243,243,243,243,243,243,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0, 19, 19,
   19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35, 35,  0, 51, 51,
   51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67, 67,  0, 83, 83,
   83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99, 99,  0,115,115,
  115,115,115,115,115,  0,131,131,131,131,131,131,131,  0,147,147,
  147,147,147,147,147,  0,163,163,163,163,163,163,163,  0,179,179,
  179,179,179,179,179,  0,195,195,195,195,195,195,195,  0,211,211,
  211,211,211,211,211,  0,227,227,227,227,227,227,227,  0,243,243,
  243,243,243,243,243,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  4,  4,  4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20,
   20,  0, 36, 36, 36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52,
   52,  0, 68, 68, 68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84,
   84,  0,100,100,100,100,100,100,100,  0,116,116,116,116,116,116,
  116,  0,132,132,132,132,132,132,132,  0,148,148,148,148,148,148,
  148,  0,164,164,164,164,164,164,164,  0,180,180,180,180,180,180,
  180,  0,196,196,196,196,196,196,196,  0,212,212,212,212,212,212,
  212,  0,228,228,228,228,228,228,228,  0,244,244,244,244,244,244,
  244,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    4,  4,  4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0,
   36, 36, 36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0,
   68, 68, 68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,
  100,100,100,100,100,100,100,  0,116,116,116,116,116,116,116,  0,
  132,132,132,132,132,132,132,  0,148,148,148,148,148,148,148,  0,
  164,164,164,164,164,164,164,  0,180,180,180,180,180,180,180,  0,
  196,196,196,196,196,196,196,  0,212,212,212,212,212,212,212,  0,
  228,228,228,228,228,228,228,  0,244,244,244,244,244,244,244,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,
    4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36,
   36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68,
   68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,
  100,100,100,100,100,  0,116,116,116,116,116,116,116,  0,132,132,
  132,132,132,132,132,  0,148,148,148,148,148,148,148,  0,164,164,
  164,164,164,164,164,  0,180,180,180,180,180,180,180,  0,196,196,
  196,196,196,196,196,  0,212,212,212,212,212,212,212,  0,228,228,
  228,228,228,228,228,  0,244,244,244,244,244,244,244,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,
    4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36,
   36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68,
   68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,
  100,100,100,  0,116,116,116,116,116,116,116,  0,132,132,132,132,
  132,132,132,  0,148,148,148,148,148,148,148,  0,164,164,164,164,
  164,164,164,  0,180,180,180,180,180,180,180,  0,196,196,196,196,
  196,196,196,  0,212,212,212,212,212,212,212,  0,228,228,228,228,
  228,228,228,  0,244,244,244,244,244,244,244,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,
    4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36,
   36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68,
   68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,100,100,
  100,  0,116,116,116,116,116,116,116,  0,132,132,132,132,132,132,
  132,  0,148,148,148,148,148,148,148,  0,164,164,164,164,164,164,
  164,  0,180,180,180,180,180,180,180,  0,196,196,196,196,196,196,
  196,  0,212,212,212,212,212,212,212,  0,228,228,228,228,228,228,
  228,  0,244,244,244,244,244,244,244,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,  4,  0,
   20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36, 36,  0,
   52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68, 68,  0,
   84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,100,100,100,  0,
  116,116,116,116,116,116,116,  0,132,132,132,132,132,132,132,  0,
  148,148,148,148,148,148,148,  0,164,164,164,164,164,164,164,  0,
  180,180,180,180,180,180,180,  0,196,196,196,196,196,196,196,  0,
  212,212,212,212,212,212,212,  0,228,228,228,228,228,228,228,  0,
  244,244,244,244,244,244,244,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,  4,  0, 20, 20,
   20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36, 36,  0, 52, 52,
   52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68, 68,  0, 84, 84,
   84, 84, 84, 84, 84,  0,100,100,100,100,100,100,100,  0,116,116,
  116,116,116,116,116,  0,132,132,132,132,132,132,132,  0,148,148,
  148,148,148,148,148,  0,164,164,164,164,164,164,164,  0,180,180,
  180,180,180,180,180,  0,196,196,196,196,196,196,196,  0,212,212,
  212,212,212,212,212,  0,228,228,228,228,228,228,228,  0,244,244,
  244,244,244,244,244,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  5,  5,  5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21,
   21,  0, 37, 37, 37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53,
   53,  0, 69, 69, 69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85,
   85,  0,101,101,101,101,101,101,101,  0,117,117,117,117,117,117,
  117,  0,133,133,133,133,133,133,133,  0,149,149,149,149,149,149,
  149,  0,165,165,165,165,165,165,165,  0,181,181,181,181,181,181,
  181,  0,197,197,197,197,197,197,197,  0,213,213,213,213,213,213,
  213,  0,229,229,229,229,229,229,229,  0,245,245,245,245,245,245,
  245,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    5,  5,  5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0,
   37, 37, 37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0,
   69, 69, 69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,
  101,101,101,101,101,101,101,  0,117,117,117,117,117,117,117,  0,
  133,133,133,133,133,133,133,  0,149,149,149,149,149,149,149,  0,
  165,165,165,165,165,165,165,  0,181,181,181,181,181,181,181,  0,
  197,197,197,197,197,197,197,  0,213,213,213,213,213,213,213,  0,
  229,229,229,229,229,229,229,  0,245,245,245,245,245,245,245,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,
    5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37,
   37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69,
   69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,
  101,101,101,101,101,  0,117,117,117,117,117,117,117,  0,133,133,
  133,133,133,133,133,  0,149,149,149,149,149,149,149,  0,165,165,
  165,165,165,165,165,  0,181,181,181,181,181,181,181,  0,197,197,
  197,197,197,197,197,  0,213,213,213,213,213,213,213,  0,229,229,
  229,229,229,229,229,  0,245,245,245,245,245,245,245,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,
    5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37,
   37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69,
   69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,
  101,101,101,  0,117,117,117,117,117,117,117,  0,133,133,133,133,
  133,133,133,  0,149,149,149,149,149,149,149,  0,165,165,165,165,
  165,165,165,  0,181,181,181,181,181,181,181,  0,197,197,197,197,
  197,197,197,  0,213,213,213,213,213,213,213,  0,229,229,229,229,
  229,229,229,  0,245,245,245,245,245,245,245,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,
    5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37,
   37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69,
   69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,101,101,
  101,  0,117,117,117,117,117,117,117,  0,133,133,133,133,133,133,
  133,  0,149,149,149,149,149,149,149,  0,165,165,165,165,165,165,
  165,  0,181,181,181,181,181,181,181,  0,197,197,197,197,197,197,
  197,  0,213,213,213,213,213,213,213,  0,229,229,229,229,229,229,
  229,  0,245,245,245,245,245,245,245,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0,
   21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37, 37,  0,
   53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69, 69,  0,
   85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,101,101,101,  0,
  117,117,117,117,117,117,117,  0,133,133,133,133,133,133,133,  0,
  149,149,149,149,149,149,149,  0,165,165,165,165,165,165,165,  0,
  181,181,181,181,181,181,181,  0,197,197,197,197,197,197,197,  0,
  213,213,213,213,213,213,213,  0,229,229,229,229,229,229,229,  0,
  245,245,245,245,245,245,245,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0, 21, 21,
   21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37, 37,  0, 53, 53,
   53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69, 69,  0, 85, 85,
   85, 85, 85, 85, 85,  0,101,101,101,101,101,101,101,  0,117,117,
  117,117,117,117,117,  0,133,133,133,133,133,133,133,  0,149,149,
  149,149,149,149,149,  0,165,165,165,165,165,165,165,  0,181,181,
  181,181,181,181,181,  0,197,197,197,197,197,197,197,  0,213,213,
  213,213,213,213,213,  0,229,229,229,229,229,229,229,  0,245,245,
  245,245,245,245,245,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  6,  6,  6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22,
   22,  0, 38, 38, 38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54,
   54,  0, 70, 70, 70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86,
   86,  0,102,102,102,102,102,102,102,  0,118,118,118,118,118,118,
  118,  0,134,134,134,134,134,134,134,  0,150,150,150,150,150,150,
  150,  0,166,166,166,166,166,166,166,  0,182,182,182,182,182,182,
  182,  0,198,198,198,198,198,198,198,  0,214,214,214,214,214,214,
  214,  0,230,230,230,230,230,230,230,  0,246,246,246,246,246,246,
  246,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    6,  6,  6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0,
   38, 38, 38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0,
   70, 70, 70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,
  102,102,102,102,102,102,102,  0,118,118,118,118,118,118,118,  0,
  134,134,134,134,134,134,134,  0,150,150,150,150,150,150,150,  0,
  166,166,166,166,166,166,166,  0,182,182,182,182,182,182,182,  0,
  198,198,198,198,198,198,198,  0,214,214,214,214,214,214,214,  0,
  230,230,230,230,230,230,230,  0,246,246,246,246,246,246,246,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,
    6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38,
   38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70,
   70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,
  102,102,102,102,102,  0,118,118,118,118,118,118,118,  0,134,134,
  134,134,134,134,134,  0,150,150,150,150,150,150,150,  0,166,166,
  166,166,166,166,166,  0,182,182,182,182,182,182,182,  0,198,198,
  198,198,198,198,198,  0,214,214,214,214,214,214,214,  0,230,230,
  230,230,230,230,230,  0,246,246,246,246,246,246,246,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,
    6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38,
   38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70,
   70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,
  102,102,102,  0,118,118,118,118,118,118,118,  0,134,134,134,134,
  134,134,134,  0,150,150,150,150,150,150,150,  0,166,166,166,166,
  166,166,166,  0,182,182,182,182,182,182,182,  0,198,198,198,198,
  198,198,198,  0,214,214,214,214,214,214,214,  0,230,230,230,230,
  230,230,230,  0,246,246,246,246,246,246,246,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,
    6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38,
   38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70,
   70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,102,102,
  102,  0,118,118,118,118,118,118,118,  0,134,134,134,134,134,134,
  134,  0,150,150,150,150,150,150,150,  0,166,166,166,166,166,166,
  166,  0,182,182,182,182,182,182,182,  0,198,198,198,198,198,198,
  198,  0,214,214,214,214,214,214,214,  0,230,230,230,230,230,230,
  230,  0,246,246,246,246,246,246,246,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,  6,  0,
   22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38, 38,  0,
   54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70, 70,  0,
   86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,102,102,102,  0,
  118,118,118,118,118,118,118,  0,134,134,134,134,134,134,134,  0,
  150,150,150,150,150,150,150,  0,166,166,166,166,166,166,166,  0,
  182,182,182,182,182,182,182,  0,198,198,198,198,198,198,198,  0,
  214,214,214,214,214,214,214,  0,230,230,230,230,230,230,230,  0,
  246,246,246,246,246,246,246,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,  6,  0, 22, 22,
   22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38, 38,  0, 54, 54,
   54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70, 70,  0, 86, 86,
   86, 86, 86, 86, 86,  0,102,102,102,102,102,102,102,  0,118,118,
  118,118,118,118,118,  0,134,134,134,134,134,134,134,  0,150,150,
  150,150,150,150,150,  0,166,166,166,166,166,166,166,  0,182,182,
  182,182,182,182,182,  0,198,198,198,198,198,198,198,  0,214,214,
  214,214,214,214,214,  0,230,230,230,230,230,230,230,  0,246,246,
  246,246,246,246,246,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  7,  7,  7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23,
   23,  0, 39, 39, 39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55,
   55,  0, 71, 71, 71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87,
   87,  0,103,103,103,103,103,103,103,  0,119,119,119,119,119,119,
  119,  0,135,135,135,135,135,135,135,  0,151,151,151,151,151,151,
  151,  0,167,167,167,167,167,167,167,  0,183,183,183,183,183,183,
  183,  0,199,199,199,199,199,199,199,  0,215,215,215,215,215,215,
  215,  0,231,231,231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    7,  7,  7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0,
   39, 39, 39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0,
   71, 71, 71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,
  103,103,103,103,103,103,103,  0,119,119,119,119,119,119,119,  0,
  135,135,135,135,135,135,135,  0,151,151,151,151,151,151,151,  0,
  167,167,167,167,167,167,167,  0,183,183,183,183,183,183,183,  0,
  199,199,199,199,199,199,199,  0,215,215,215,215,215,215,215,  0,
  231,231,231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,
    7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39,
   39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71,
   71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,
  103,103,103,103,103,  0,119,119,119,119,119,119,119,  0,135,135,
  135,135,135,135,135,  0,151,151,151,151,151,151,151,  0,167,167,
  167,167,167,167,167,  0,183,183,183,183,183,183,183,  0,199,199,
  199,199,199,199,199,  0,215,215,215,215,215,215,215,  0,231,231,
  231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,
    7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39,
   39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71,
   71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,
  103,103,103,  0,119,119,119,119,119,119,119,  0,135,135,135,135,
  135,135,135,  0,151,151,151,151,151,151,151,  0,167,167,167,167,
  167,167,167,  0,183,183,183,183,183,183,183,  0,199,199,199,199,
  199,199,199,  0,215,215,215,215,215,215,215,  0,231,231,231,231,
  231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,
    7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39,
   39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71,
   71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,103,103,
  103,  0,119,119,119,119,119,119,119,  0,135,135,135,135,135,135,
  135,  0,151,151,151,151,151,151,151,  0,167,167,167,167,167,167,
  167,  0,183,183,183,183,183,183,183,  0,199,199,199,199,199,199,
  199,  0,215,215,215,215,215,215,215,  0,231,231,231,231,231,231,
  231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,  7,  0,
   23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39, 39,  0,
   55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71, 71,  0,
   87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,103,103,103,  0,
  119,119,119,119,119,119,119,  0,135,135,135,135,135,135,135,  0,
  151,151,151,151,151,151,151,  0,167,167,167,167,167,167,167,  0,
  183,183,183,183,183,183,183,  0,199,199,199,199,199,199,199,  0,
  215,215,215,215,215,215,215,  0,231,231,231,231,231,231,231,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,  7,  0, 23, 23,
   23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39, 39,  0, 55, 55,
   55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71, 71,  0, 87, 87,
   87, 87, 87, 87, 87,  0,103,103,103,103,103,103,103,  0,119,119,
  119,119,119,119,119,  0,135,135,135,135,135,135,135,  0,151,151,
  151,151,151,151,151,  0,167,167,167,167,167,167,167,  0,183,183,
  183,183,183,183,183,  0,199,199,199,199,199,199,199,  0,215,215,
  215,215,215,215,215,  0,231,231,231,231,231,231,231,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  8,  8,  8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24,
   24,  0, 40, 40, 40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56,
   56,  0, 72, 72, 72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88,
   88,  0,104,104,104,104,104,104,104,  0,120,120,120,120,120,120,
  120,  0,136,136,136,136,136,136,136,  0,152,152,152,152,152,152,
  152,  0,255,255,255,255,255,255,255,  0,184,184,184,184,184,184,
  184,  0,200,200,200,200,200,200,200,  0,216,216,216,216,216,216,
  216,  0,232,232,232,232,232,232,232,  0,248,248,248,248,248,248,
  248,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    8,  8,  8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0,
   40, 40, 40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0,
   72, 72, 72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,
  104,104,104,104,104,104,104,  0,120,120,120,120,120,120,120,  0,
  136,136,136,136,136,136,136,  0,152,152,152,152,152,152,152,  0,
  255,255,255,255,255,255,255,  0,184,184,184,184,184,184,184,  0,
  200,200,200,200,200,200,200,  0,216,216,216,216,216,216,216,  0,
  232,232,232,232,232,232,232,  0,248,248,248,248,248,248,248,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,
    8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40,
   40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72,
   72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,
  104,104,104,104,104,  0,120,120,120,120,120,120,120,  0,136,136,
  136,136,136,136,136,  0,152,152,152,152,152,152,152,  0,255,255,
  255,255,255,255,255,  0,184,184,184,184,184,184,184,  0,200,200,
  200,200,200,200,200,  0,216,216,216,216,216,216,216,  0,232,232,
  232,232,232,232,232,  0,248,248,248,248,248,248,248,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,
    8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40,
   40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72,
   72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,
  104,104,104,  0,120,120,120,120,120,120,120,  0,136,136,136,136,
  136,136,136,  0,152,152,152,152,152,152,152,  0,255,255,255,255,
  255,255,255,  0,184,184,184,184,184,184,184,  0,200,200,200,200,
  200,200,200,  0,216,216,216,216,216,216,216,  0,232,232,232,232,
  232,232,232,  0,248,248,248,248,248,248,248,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,
    8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40,
   40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72,
   72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,104,104,
  104,  0,120,120,120,120,120,120,120,  0,136,136,136,136,136,136,
  136,  0,152,152,152,152,152,152,152,  0,255,255,255,255,255,255,
  255,  0,184,184,184,184,184,184,184,  0,200,200,200,200,200,200,
  200,  0,216,216,216,216,216,216,216,  0,232,232,232,232,232,232,
  232,  0,248,248,248,248,248,248,248,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0,
   24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40, 40,  0,
   56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72, 72,  0,
   88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,104,104,104,  0,
  120,120,120,120,120,120,120,  0,136,136,136,136,136,136,136,  0,
  152,152,152,152,152,152,152,  0,255,255,255,255,255,255,255,  0,
  184,184,184,184,184,184,184,  0,200,200,200,200,200,200,200,  0,
  216,216,216,216,216,216,216,  0,232,232,232,232,232,232,232,  0,
  248,248,248,248,248,248,248,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0, 24, 24,
   24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40, 40,  0, 56, 56,
   56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72, 72,  0, 88, 88,
   88, 88, 88, 88, 88,  0,104,104,104,104,104,104,104,  0,120,120,
  120,120,120,120,120,  0,136,136,136,136,136,136,136,  0,152,152,
  152,152,152,152,152,  0,255,255,255,255,255,255,255,  0,184,184,
  184,184,184,184,184,  0,200,200,200,200,200,200,200,  0,216,216,
  216,216,216,216,216,  0,232,232,232,232,232,232,232,  0,248,248,
  248,248,248,248,248,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  9,  9,  9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25,
   25,  0, 41, 41, 41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57,
   57,  0, 73, 73, 73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89,
   89,  0,105,105,105,105,105,105,105,  0,121,121,121,121,121,121,
  121,  0,137,137,137,137,137,137,137,  0,153,153,153,153,153,153,
  153,  0,169,169,169,169,169,169,169,  0,185,185,185,185,185,185,
  185,  0,201,201,201,201,201,201,201,  0,217,217,217,217,217,217,
  217,  0,233,233,233,233,233,233,233,  0,249,249,249,249,249,249,
  249,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    9,  9,  9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0,
   41, 41, 41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0,
   73, 73, 73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,
  105,105,105,105,105,105,105,  0,121,121,121,121,121,121,121,  0,
  137,137,137,137,137,137,137,  0,153,153,153,153,153,153,153,  0,
  169,169,169,169,169,169,169,  0,185,185,185,185,185,185,185,  0,
  201,201,201,201,201,201,201,  0,217,217,217,217,217,217,217,  0,
  233,233,233,233,233,233,233,  0,249,249,249,249,249,249,249,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,
    9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41,
   41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73,
   73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,
  105,105,105,105,105,  0,121,121,121,121,121,121,121,  0,137,137,
  137,137,137,137,137,  0,153,153,153,153,153,153,153,  0,169,169,
  169,169,169,169,169,  0,185,185,185,185,185,185,185,  0,201,201,
  201,201,201,201,201,  0,217,217,217,217,217,217,217,  0,233,233,
  233,233,233,233,233,  0,249,249,249,249,249,249,249,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,
    9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41,
   41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73,
   73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,
  105,105,105,  0,121,121,121,121,121,121,121,  0,137,137,137,137,
  137,137,137,  0,153,153,153,153,153,153,153,  0,169,169,169,169,
  169,169,169,  0,185,185,185,185,185,185,185,  0,201,201,201,201,
  201,201,201,  0,217,217,217,217,217,217,217,  0,233,233,233,233,
  233,233,233,  0,249,249,249,249,249,249,249,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,
    9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41,
   41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73,
   73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,105,105,
  105,  0,121,121,121,121,121,121,121,  0,137,137,137,137,137,137,
  137,  0,153,153,153,153,153,153,153,  0,169,169,169,169,169,169,
  169,  0,185,185,185,185,185,185,185,  0,201,201,201,201,201,201,
  201,  0,217,217,217,217,217,217,217,  0,233,233,233,233,233,233,
  233,  0,249,249,249,249,249,249,249,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,  9,  0,
   25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41, 41,  0,
   57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73, 73,  0,
   89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,105,105,105,  0,
  121,121,121,121,121,121,121,  0,137,137,137,137,137,137,137,  0,
  153,153,153,153,153,153,153,  0,169,169,169,169,169,169,169,  0,
  185,185,185,185,185,185,185,  0,201,201,201,201,201,201,201,  0,
  217,217,217,217,217,217,217,  0,233,233,233,233,233,233,233,  0,
  249,249,249,249,249,249,249,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,  9,  0, 25, 25,
   25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41, 41,  0, 57, 57,
   57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73, 73,  0, 89, 89,
   89, 89, 89, 89, 89,  0,105,105,105,105,105,105,105,  0,121,121,
  121,121,121,121,121,  0,137,137,137,137,137,137,137,  0,153,153,
  153,153,153,153,153,  0,169,169,169,169,169,169,169,  0,185,185,
  185,185,185,185,185,  0,201,201,201,201,201,201,201,  0,217,217,
  217,217,217,217,217,  0,233,233,233,233,233,233,233,  0,249,249,
  249,249,249,249,249,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 10, 10, 10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26,
   26,  0, 42, 42, 42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58,
   58,  0, 74, 74, 74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90,
   90,  0,106,106,106,106,106,106,106,  0,122,122,122,122,122,122,
  122,  0,138,138,138,138,138,138,138,  0,154,154,154,154,154,154,
  154,  0,170,170,170,170,170,170,170,  0,186,186,186,186,186,186,
  186,  0,202,202,202,202,202,202,202,  0,218,218,218,218,218,218,
  218,  0,234,234,234,234,234,234,234,  0,250,250,250,250,250,250,
  250,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   10, 10, 10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0,
   42, 42, 42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0,
   74, 74, 74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,
  106,106,106,106,106,106,106,  0,122,122,122,122,122,122,122,  0,
  138,138,138,138,138,138,138,  0,154,154,154,154,154,154,154,  0,
  170,170,170,170,170,170,170,  0,186,186,186,186,186,186,186,  0,
  202,202,202,202,202,202,202,  0,218,218,218,218,218,218,218,  0,
  234,234,234,234,234,234,234,  0,250,250,250,250,250,250,250,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10,
   10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42,
   42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74,
   74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,
  106,106,106,106,106,  0,122,122,122,122,122,122,122,  0,138,138,
  138,138,138,138,138,  0,154,154,154,154,154,154,154,  0,170,170,
  170,170,170,170,170,  0,186,186,186,186,186,186,186,  0,202,202,
  202,202,202,202,202,  0,218,218,218,218,218,218,218,  0,234,234,
  234,234,234,234,234,  0,250,250,250,250,250,250,250,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10,
   10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42,
   42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74,
   74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,
  106,106,106,  0,122,122,122,122,122,122,122,  0,138,138,138,138,
  138,138,138,  0,154,154,154,154,154,154,154,  0,170,170,170,170,
  170,170,170,  0,186,186,186,186,186,186,186,  0,202,202,202,202,
  202,202,202,  0,218,218,218,218,218,218,218,  0,234,234,234,234,
  234,234,234,  0,250,250,250,250,250,250,250,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10,
   10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42,
   42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74,
   74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,106,106,
  106,  0,122,122,122,122,122,122,122,  0,138,138,138,138,138,138,
  138,  0,154,154,154,154,154,154,154,  0,170,170,170,170,170,170,
  170,  0,186,186,186,186,186,186,186,  0,202,202,202,202,202,202,
  202,  0,218,218,218,218,218,218,218,  0,234,234,234,234,234,234,
  234,  0,250,250,250,250,250,250,250,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10, 10,  0,
   26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42, 42,  0,
   58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74, 74,  0,
   90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,106,106,106,  0,
  122,122,122,122,122,122,122,  0,138,138,138,138,138,138,138,  0,
  154,154,154,154,154,154,154,  0,170,170,170,170,170,170,170,  0,
  186,186,186,186,186,186,186,  0,202,202,202,202,202,202,202,  0,
  218,218,218,218,218,218,218,  0,234,234,234,234,234,234,234,  0,
  250,250,250,250,250,250,250,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10, 10,  0, 26, 26,
   26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42, 42,  0, 58, 58,
   58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74, 74,  0, 90, 90,
   90, 90, 90, 90, 90,  0,106,106,106,106,106,106,106,  0,122,122,
  122,122,122,122,122,  0,138,138,138,138,138,138,138,  0,154,154,
  154,154,154,154,154,  0,170,170,170,170,170,170,170,  0,186,186,
  186,186,186,186,186,  0,202,202,202,202,202,202,202,  0,218,218,
  218,218,218,218,218,  0,234,234,234,234,234,234,234,  0,250,250,
  250,250,250,250,250,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 11, 11, 11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27,
   27,  0, 43, 43, 43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59,
   59,  0, 75, 75, 75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91,
   91,  0,107,107,107,107,107,107,107,  0,123,123,123,123,123,123,
  123,  0,139,139,139,139,139,139,139,  0,155,155,155,155,155,155,
  155,  0,171,171,171,171,171,171,171,  0,187,187,187,187,187,187,
  187,  0,203,203,203,203,203,203,203,  0,219,219,219,219,219,219,
  219,  0,235,235,235,235,235,235,235,  0,251,251,251,251,251,251,
  251,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   11, 11, 11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0,
   43, 43, 43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0,
   75, 75, 75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,
  107,107,107,107,107,107,107,  0,123,123,123,123,123,123,123,  0,
  139,139,139,139,139,139,139,  0,155,155,155,155,155,155,155,  0,
  171,171,171,171,171,171,171,  0,187,187,187,187,187,187,187,  0,
  203,203,203,203,203,203,203,  0,219,219,219,219,219,219,219,  0,
  235,235,235,235,235,235,235,  0,251,251,251,251,251,251,251,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11,
   11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43,
   43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75,
   75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,
  107,107,107,107,107,  0,123,123,123,123,123,123,123,  0,139,139,
  139,139,139,139,139,  0,155,155,155,155,155,155,155,  0,171,171,
  171,171,171,171,171,  0,187,187,187,187,187,187,187,  0,203,203,
  203,203,203,203,203,  0,219,219,219,219,219,219,219,  0,235,235,
  235,235,235,235,235,  0,251,251,251,251,251,251,251,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11,
   11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43,
   43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75,
   75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,
  107,107,107,  0,123,123,123,123,123,123,123,  0,139,139,139,139,
  139,139,139,  0,155,155,155,155,155,155,155,  0,171,171,171,171,
  171,171,171,  0,187,187,187,187,187,187,187,  0,203,203,203,203,
  203,203,203,  0,219,219,219,219,219,219,219,  0,235,235,235,235,
  235,235,235,  0,251,251,251,251,251,251,251,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11,
   11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43,
   43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75,
   75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,107,107,
  107,  0,123,123,123,123,123,123,123,  0,139,139,139,139,139,139,
  139,  0,155,155,155,155,155,155,155,  0,171,171,171,171,171,171,
  171,  0,187,187,187,187,187,187,187,  0,203,203,203,203,203,203,
  203,  0,219,219,219,219,219,219,219,  0,235,235,235,235,235,235,
  235,  0,251,251,251,251,251,251,251,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11, 11,  0,
   27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43, 43,  0,
   59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75, 75,  0,
   91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,107,107,107,  0,
  123,123,123,123,123,123,123,  0,139,139,139,139,139,139,139,  0,
  155,155,155,155,155,155,155,  0,171,171,171,171,171,171,171,  0,
  187,187,187,187,187,187,187,  0,203,203,203,203,203,203,203,  0,
  219,219,219,219,219,219,219,  0,235,235,235,235,235,235,235,  0,
  251,251,251,251,251,251,251,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11, 11,  0, 27, 27,
   27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43, 43,  0, 59, 59,
   59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75, 75,  0, 91, 91,

   91, 91, 91, 91, 91,  0,107,107,107,107,107,107,107,  0,123,123,
  123,123,123,123,123,  0,139,139,139,139,139,139,139,  0,155,155,
  155,155,155,155,155,  0,171,171,171,171,171,171,171,  0,187,187,
  187,187,187,187,187,  0,203,203,203,203,203,203,203,  0,219,219,
  219,219,219,219,219,  0,235,235,235,235,235,235,235,  0,251,251,
  251,251,251,251,251,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28,
   28,  0, 44, 44, 44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60,
   60,  0, 76, 76, 76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92,
   92,  0,108,108,108,108,108,108,108,  0,124,124,124,124,124,124,
  124,  0,140,140,140,140,140,140,140,  0,156,156,156,156,156,156,
  156,  0,172,172,172,172,172,172,172,  0,188,188,188,188,188,188,
  188,  0,204,204,204,204,204,204,204,  0,220,220,220,220,220,220,
  220,  0,236,236,236,236,236,236,236,  0,252,252,252,252,252,252,
  252,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   12, 12, 12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0,
   44, 44, 44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0,
   76, 76, 76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,
  108,108,108,108,108,108,108,  0,124,124,124,124,124,124,124,  0,
  140,140,140,140,140,140,140,  0,156,156,156,156,156,156,156,  0,
  172,172,172,172,172,172,172,  0,188,188,188,188,188,188,188,  0,
  204,204,204,204,204,204,204,  0,220,220,220,220,220,220,220,  0,
  236,236,236,236,236,236,236,  0,252,252,252,252,252,252,252,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12,
   12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44,
   44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76,
   76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,
  108,108,108,108,108,  0,124,124,124,124,124,124,124,  0,140,140,
  140,140,140,140,140,  0,156,156,156,156,156,156,156,  0,172,172,
  172,172,172,172,172,  0,188,188,188,188,188,188,188,  0,204,204,
  204,204,204,204,204,  0,220,220,220,220,220,220,220,  0,236,236,
  236,236,236,236,236,  0,252,252,252,252,252,252,252,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12,
   12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44,
   44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76,
   76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,
  108,108,108,  0,124,124,124,124,124,124,124,  0,140,140,140,140,
  140,140,140,  0,156,156,156,156,156,156,156,  0,172,172,172,172,
  172,172,172,  0,188,188,188,188,188,188,188,  0,204,204,204,204,
  204,204,204,  0,220,220,220,220,220,220,220,  0,236,236,236,236,
  236,236,236,  0,252,252,252,252,252,252,252,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12,
   12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44,
   44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76,
   76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,108,108,
  108,  0,124,124,124,124,124,124,124,  0,140,140,140,140,140,140,
  140,  0,156,156,156,156,156,156,156,  0,172,172,172,172,172,172,
  172,  0,188,188,188,188,188,188,188,  0,204,204,204,204,204,204,
  204,  0,220,220,220,220,220,220,220,  0,236,236,236,236,236,236,
  236,  0,252,252,252,252,252,252,252,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0,
   28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44, 44,  0,
   60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76, 76,  0,
   92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,108,108,108,  0,
  124,124,124,124,124,124,124,  0,140,140,140,140,140,140,140,  0,
  156,156,156,156,156,156,156,  0,172,172,172,172,172,172,172,  0,
  188,188,188,188,188,188,188,  0,204,204,204,204,204,204,204,  0,
  220,220,220,220,220,220,220,  0,236,236,236,236,236,236,236,  0,
  252,252,252,252,252,252,252,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 28, 28,
   28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44, 44,  0, 60, 60,
   60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76, 76,  0, 92, 92,
   92, 92, 92, 92, 92,  0,108,108,108,108,108,108,108,  0,124,124,
  124,124,124,124,124,  0,140,140,140,140,140,140,140,  0,156,156,
  156,156,156,156,156,  0,172,172,172,172,172,172,172,  0,188,188,
  188,188,188,188,188,  0,204,204,204,204,204,204,204,  0,220,220,
  220,220,220,220,220,  0,236,236,236,236,236,236,236,  0,252,252,
  252,252,252,252,252,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 13, 13, 13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29,
   29,  0, 45, 45, 45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61,
   61,  0, 77, 77, 77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93,
   93,  0,109,109,109,109,109,109,109,  0,125,125,125,125,125,125,
  125,  0,141,141,141,141,141,141,141,  0,157,157,157,157,157,157,
  157,  0,173,173,173,173,173,173,173,  0,189,189,189,189,189,189,
  189,  0,205,205,205,205,205,205,205,  0,221,221,221,221,221,221,
  221,  0,237,237,237,237,237,237,237,  0,253,253,253,253,253,253,
  253,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   13, 13, 13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0,
   45, 45, 45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0,
   77, 77, 77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,
  109,109,109,109,109,109,109,  0,125,125,125,125,125,125,125,  0,
  141,141,141,141,141,141,141,  0,157,157,157,157,157,157,157,  0,
  173,173,173,173,173,173,173,  0,189,189,189,189,189,189,189,  0,
  205,205,205,205,205,205,205,  0,221,221,221,221,221,221,221,  0,
  237,237,237,237,237,237,237,  0,253,253,253,253,253,253,253,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13,
   13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45,
   45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77,
   77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,
  109,109,109,109,109,  0,125,125,125,125,125,125,125,  0,141,141,
  141,141,141,141,141,  0,157,157,157,157,157,157,157,  0,173,173,
  173,173,173,173,173,  0,189,189,189,189,189,189,189,  0,205,205,
  205,205,205,205,205,  0,221,221,221,221,221,221,221,  0,237,237,
  237,237,237,237,237,  0,253,253,253,253,253,253,253,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13,
   13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45,
   45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77,
   77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,
  109,109,109,  0,125,125,125,125,125,125,125,  0,141,141,141,141,
  141,141,141,  0,157,157,157,157,157,157,157,  0,173,173,173,173,
  173,173,173,  0,189,189,189,189,189,189,189,  0,205,205,205,205,
  205,205,205,  0,221,221,221,221,221,221,221,  0,237,237,237,237,
  237,237,237,  0,253,253,253,253,253,253,253,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13,
   13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45,
   45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77,
   77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,109,109,
  109,  0,125,125,125,125,125,125,125,  0,141,141,141,141,141,141,
  141,  0,157,157,157,157,157,157,157,  0,173,173,173,173,173,173,
  173,  0,189,189,189,189,189,189,189,  0,205,205,205,205,205,205,
  205,  0,221,221,221,221,221,221,221,  0,237,237,237,237,237,237,
  237,  0,253,253,253,253,253,253,253,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13, 13,  0,
   29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45, 45,  0,
   61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77, 77,  0,
   93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,109,109,109,  0,
  125,125,125,125,125,125,125,  0,141,141,141,141,141,141,141,  0,
  157,157,157,157,157,157,157,  0,173,173,173,173,173,173,173,  0,
  189,189,189,189,189,189,189,  0,205,205,205,205,205,205,205,  0,
  221,221,221,221,221,221,221,  0,237,237,237,237,237,237,237,  0,
  253,253,253,253,253,253,253,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13, 13,  0, 29, 29,
   29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45, 45,  0, 61, 61,
   61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77, 77,  0, 93, 93,
   93, 93, 93, 93, 93,  0,109,109,109,109,109,109,109,  0,125,125,
  125,125,125,125,125,  0,141,141,141,141,141,141,141,  0,157,157,
  157,157,157,157,157,  0,173,173,173,173,173,173,173,  0,189,189,
  189,189,189,189,189,  0,205,205,205,205,205,205,205,  0,221,221,
  221,221,221,221,221,  0,237,237,237,237,237,237,237,  0,253,253,
  253,253,253,253,253,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 14, 14, 14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30,
   30,  0, 46, 46, 46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62,
   62,  0, 78, 78, 78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94,
   94,  0,110,110,110,110,110,110,110,  0,126,126,126,126,126,126,
  126,  0,142,142,142,142,142,142,142,  0,158,158,158,158,158,158,
  158,  0,174,174,174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45,
   45,  0,206,206,206,206,206,206,206,  0,222,222,222,222,222,222,
  222,  0,238,238,238,238,238,238,238,  0,254,254,254,254,254,254,
  254,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   14, 14, 14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0,
   46, 46, 46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0,
   78, 78, 78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,
  110,110,110,110,110,110,110,  0,126,126,126,126,126,126,126,  0,
  142,142,142,142,142,142,142,  0,158,158,158,158,158,158,158,  0,
  174,174,174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,
  206,206,206,206,206,206,206,  0,222,222,222,222,222,222,222,  0,
  238,238,238,238,238,238,238,  0,254,254,254,254,254,254,254,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14,
   14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46,
   46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78,
   78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,
  110,110,110,110,110,  0,126,126,126,126,126,126,126,  0,142,142,
  142,142,142,142,142,  0,158,158,158,158,158,158,158,  0,174,174,
  174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,
  206,206,206,206,206,  0,222,222,222,222,222,222,222,  0,238,238,
  238,238,238,238,238,  0,254,254,254,254,254,254,254,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14,
   14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46,
   46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78,
   78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,
  110,110,110,  0,126,126,126,126,126,126,126,  0,142,142,142,142,
  142,142,142,  0,158,158,158,158,158,158,158,  0,174,174,174,174,
  174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,
  206,206,206,  0,222,222,222,222,222,222,222,  0,238,238,238,238,
  238,238,238,  0,254,254,254,254,254,254,254,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14,
   14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46,
   46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78,
   78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,110,110,
  110,  0,126,126,126,126,126,126,126,  0,142,142,142,142,142,142,
  142,  0,158,158,158,158,158,158,158,  0,174,174,174,174,174,174,
  174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,206,206,
  206,  0,222,222,222,222,222,222,222,  0,238,238,238,238,238,238,
  238,  0,254,254,254,254,254,254,254,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14, 14,  0,
   30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46, 46,  0,
   62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78, 78,  0,
   94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,110,110,110,  0,
  126,126,126,126,126,126,126,  0,142,142,142,142,142,142,142,  0,
  158,158,158,158,158,158,158,  0,174,174,174,174,174,174,174,  0,
   45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,206,206,206,  0,
  222,222,222,222,222,222,222,  0,238,238,238,238,238,238,238,  0,
  254,254,254,254,254,254,254,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14, 14,  0, 30, 30,
   30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46, 46,  0, 62, 62,
   62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78, 78,  0, 94, 94,
   94, 94, 94, 94, 94,  0,110,110,110,110,110,110,110,  0,126,126,
  126,126,126,126,126,  0,142,142,142,142,142,142,142,  0,158,158,
  158,158,158,158,158,  0,174,174,174,174,174,174,174,  0, 45, 45,
   45, 45, 45, 45, 45,  0,206,206,206,206,206,206,206,  0,222,222,
  222,222,222,222,222,  0,238,238,238,238,238,238,238,  0,254,254,
  254,254,254,254,254,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 15, 15, 15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31,
   31,  0, 47, 47, 47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63,
   63,  0, 79, 79, 79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95,
   95,  0,111,111,111,111,111,111,111,  0,127,127,127,127,127,127,
  127,  0,143,143,143,143,143,143,143,  0,159,159,159,159,159,159,
  159,  0,175,175,175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47,
   47,  0,207,207,207,207,207,207,207,  0,223,223,223,223,223,223,
  223,  0,239,239,239,239,239,239,239,  0,255,255,255,255,255,255,
  255,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   15, 15, 15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0,
   47, 47, 47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0,
   79, 79, 79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,
  111,111,111,111,111,111,111,  0,127,127,127,127,127,127,127,  0,
  143,143,143,143,143,143,143,  0,159,159,159,159,159,159,159,  0,
  175,175,175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,
  207,207,207,207,207,207,207,  0,223,223,223,223,223,223,223,  0,
  239,239,239,239,239,239,239,  0,255,255,255,255,255,255,255,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15,
   15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47,
   47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79,
   79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,
  111,111,111,111,111,  0,127,127,127,127,127,127,127,  0,143,143,
  143,143,143,143,143,  0,159,159,159,159,159,159,159,  0,175,175,
  175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,
  207,207,207,207,207,  0,223,223,223,223,223,223,223,  0,239,239,
  239,239,239,239,239,  0,255,255,255,255,255,255,255,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15,
   15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47,
   47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79,
   79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,
  111,111,111,  0,127,127,127,127,127,127,127,  0,143,143,143,143,
  143,143,143,  0,159,159,159,159,159,159,159,  0,175,175,175,175,
  175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,
  207,207,207,  0,223,223,223,223,223,223,223,  0,239,239,239,239,
  239,239,239,  0,255,255,255,255,255,255,255,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15,
   15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47,
   47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79,
   79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,111,111,
  111,  0,127,127,127,127,127,127,127,  0,143,143,143,143,143,143,
  143,  0,159,159,159,159,159,159,159,  0,175,175,175,175,175,175,
  175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,207,207,
  207,  0,223,223,223,223,223,223,223,  0,239,239,239,239,239,239,
  239,  0,255,255,255,255,255,255,255,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15, 15,  0,
   31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47, 47,  0,
   63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79, 79,  0,
   95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,111,111,111,  0,
  127,127,127,127,127,127,127,  0,143,143,143,143,143,143,143,  0,
  159,159,159,159,159,159,159,  0,175,175,175,175,175,175,175,  0,
   47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,207,207,207,  0,
  223,223,223,223,223,223,223,  0,239,239,239,239,239,239,239,  0,
  255,255,255,255,255,255,255,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15, 15,  0, 31, 31,
   31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47, 47,  0, 63, 63,
   63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79, 79,  0, 95, 95,
   95, 95, 95, 95, 95,  0,111,111,111,111,111,111,111,  0,127,127,
  127,127,127,127,127,  0,143,143,143,143,143,143,143,  0,159,159,
  159,159,159,159,159,  0,175,175,175,175,175,175,175,  0, 47, 47,
   47, 47, 47, 47, 47,  0,207,207,207,207,207,207,207,  0,223,223,
  223,223,223,223,223,  0,239,239,239,239,239,239,239,  0,255,255,
  255,255,255,255,255,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98, 94, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 98,105,  0,255,  0,137,  0, 91, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98,105,  0,255,  0,137,  0, 98,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
    0,255,
};

static const char m_palno[]=  // Marker to not show this color in automap
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 48,  0,  0,  0, 60,  0,  0,  0, 72,  0,  0,  0,
   84,  0,  0,  0, 96,  0,  0,  0,108,  0,  0,  0,  0,  7,  0,  4,
    0,  0,  0,  0,  0,  4,  0,255,  0,  7,  0,  0,  4,  0,  0,  0,
    4,  0,  0,255,  0,  7,  0,  0,  0,  4,  0,  4,  0,  0,  0,255,
    0,  7,  0,  0,  0,  0,  4,  0,  0,  0,  0,255,  0,  7,  0,  0,
    0,  4,  0,  4,  0,  0,  0,255,  0,  7,  0,  0,  4,  0,  0,  0,
    4,  0,  0,255,  0,  7,  0,  4,  0,  0,  0,  0,  0,  4,  0,255,
};

static const char stcfn096[]= // backquote character, never existed
{
    4,  0,  4,  0,  0,  0,  0,  0,
   24,  0,  0,  0, 32,  0,  0,  0, 41,  0,  0,  0, 50,  0,  0,  0,
    0,  3,  0,191,191,191,  0,255,  0,  4,  0,191,179,179,191,  0,
  255,  0,  4,  0,191,181,191,191,  0,255,  0,  3,  0,191,191,191,
    0,255,
};

static const char m_butt1[]=  // Options reset button unlit
{
   15,  0, 15,  0,  0,  0,  0,  0,
   68,  0,  0,  0, 88,  0,  0,  0,108,  0,  0,  0,128,  0,  0,  0,
  148,  0,  0,  0,168,  0,  0,  0,188,  0,  0,  0,208,  0,  0,  0,
  228,  0,  0,  0,248,  0,  0,  0, 12,  1,  0,  0, 32,  1,  0,  0,
   52,  1,  0,  0, 72,  1,  0,  0, 92,  1,  0,  0,  0, 15,  0, 59,
   59, 57, 59, 56, 59, 59, 57, 56, 57, 56, 59, 59, 59, 63,  0,255,
    0, 15,  0, 59, 67, 67, 67, 65, 68, 65, 67, 67, 67, 67, 65, 67,
   67, 73,  0,255,  0, 15,  0, 57, 67, 67, 67, 67, 65, 67, 67, 65,
   67, 67, 65, 67, 67, 75,  0,255,  0, 15,  0, 57, 65, 67,119,120,
  118,119,117,119,118,120,123, 70, 65, 73,  0,255,  0, 15,  0, 57,
   65, 67,119,117,119,119,120,119,119,123,124, 73, 67, 75,  0,255,
    0, 15,  0, 57, 67, 65,118,119, 47, 47, 47, 47, 47,125,126, 73,
   67, 74,  0,255,  0, 15,  0, 57, 67, 67,119,119, 47,188,188,188,
   47,124,125, 73, 65, 74,  0,255,  0, 15,  0, 59, 67, 65,119,119,
   47,188,188,188, 47,125,124, 73, 68, 74,  0,255,  0, 15,  0, 60,
   67, 67,117,120, 47,188,188,188, 47,125,125, 73, 65, 73,  0,255,
    0, 15,  0, 57, 67, 67,119,119, 47, 47, 47, 47, 47,126,125, 73,
   65, 73,  0,255,  0, 15,  0, 59, 65, 67,119,123,125,125,124,125,
  125,125,125, 73, 65, 75,  0,255,  0, 15,  0, 59, 68, 67,123,124,
  126,125,125,125,124,125,125, 73, 68, 73,  0,255,  0, 15,  0, 59,
   67, 65, 70, 73, 73, 73, 73, 73, 73, 73, 73, 73, 67, 74,  0,255,
    0, 15,  0, 59, 67, 67, 65, 67, 67, 65, 68, 67, 67, 67, 67, 67,
   67, 73,  0,255,  0, 15,  0, 64, 73, 73, 75, 73, 73, 75, 74, 74,
   74, 74, 74, 73, 73, 73,  0,255,
};


static const char m_butt2[]=  // Options reset button lit
{
   15,  0, 15,  0,  0,  0,  0,  0,
   68,  0,  0,  0, 88,  0,  0,  0,108,  0,  0,  0,128,  0,  0,  0,
  148,  0,  0,  0,168,  0,  0,  0,188,  0,  0,  0,208,  0,  0,  0,
  228,  0,  0,  0,248,  0,  0,  0, 12,  1,  0,  0, 32,  1,  0,  0,
   52,  1,  0,  0, 72,  1,  0,  0, 92,  1,  0,  0,  0, 15,  0, 59,
   59, 57, 59, 56, 59, 59, 57, 56, 57, 56, 59, 59, 59, 63,  0,255,
    0, 15,  0, 59, 67, 67, 67, 65, 68, 65, 67, 67, 67, 67, 65, 67,
   67, 73,  0,255,  0, 15,  0, 57, 67, 67, 67, 67, 65, 67, 67, 65,
   67, 67, 65, 67, 67, 75,  0,255,  0, 15,  0, 57, 65, 67,119,120,
  118,119,117,119,118,120,123, 70, 65, 73,  0,255,  0, 15,  0, 57,
   65, 67,119,117,119,119,120,119,119,123,124, 73, 67, 75,  0,255,
    0, 15,  0, 57, 67, 65,118,119, 47, 47, 47, 47, 47,125,126, 73,
   67, 74,  0,255,  0, 15,  0, 57, 67, 67,119,119, 47,176,176,176,
   47,124,125, 73, 65, 74,  0,255,  0, 15,  0, 59, 67, 65,119,119,
   47,176,176,176, 47,125,124, 73, 68, 74,  0,255,  0, 15,  0, 60,
   67, 67,117,120, 47,176,176,176, 47,125,125, 73, 65, 73,  0,255,
    0, 15,  0, 57, 67, 67,119,119, 47, 47, 47, 47, 47,126,125, 73,
   65, 73,  0,255,  0, 15,  0, 59, 65, 67,119,123,125,125,124,125,
  125,125,125, 73, 65, 75,  0,255,  0, 15,  0, 59, 68, 67,123,124,
  126,125,125,125,124,125,125, 73, 68, 73,  0,255,  0, 15,  0, 59,
   67, 65, 70, 73, 73, 73, 73, 73, 73, 73, 73, 73, 67, 74,  0,255,
    0, 15,  0, 59, 67, 67, 65, 67, 67, 65, 68, 67, 67, 67, 67, 67,
   67, 73,  0,255,  0, 15,  0, 64, 73, 73, 75, 73, 73, 75, 74, 74,
   74, 74, 74, 73, 73, 73,  0,255,
};

// Animated textures definition lump -- see SWANTBLS.EXE docs
static const char animated[]=
{
    0, 78, 85, 75, 65, 71, 69, 51,  0,  0, 78, 85, 75, 65, 71, 69,
   49,  0,  0,  8,  0,  0,  0,  0, 70, 87, 65, 84, 69, 82, 52,  0,
    0, 70, 87, 65, 84, 69, 82, 49,  0,  0,  8,  0,  0,  0,  0, 83,
   87, 65, 84, 69, 82, 52,  0,  0, 83, 87, 65, 84, 69, 82, 49,  0,
    0,  8,  0,  0,  0,  0, 76, 65, 86, 65, 52,  0,  0,  0,  0, 76,
   65, 86, 65, 49,  0,  0,  0,  0,  8,  0,  0,  0,  0, 66, 76, 79,
   79, 68, 51,  0,  0,  0, 66, 76, 79, 79, 68, 49,  0,  0,  0,  8,
    0,  0,  0,  0, 82, 82, 79, 67, 75, 48, 56,  0,  0, 82, 82, 79,
   67, 75, 48, 53,  0,  0,  8,  0,  0,  0,  0, 83, 76, 73, 77, 69,
   48, 52,  0,  0, 83, 76, 73, 77, 69, 48, 49,  0,  0,  8,  0,  0,
    0,  0, 83, 76, 73, 77, 69, 48, 56,  0,  0, 83, 76, 73, 77, 69,
   48, 53,  0,  0,  8,  0,  0,  0,  0, 83, 76, 73, 77, 69, 49, 50,
    0,  0, 83, 76, 73, 77, 69, 48, 57,  0,  0,  8,  0,  0,  0,  1,
   66, 76, 79, 68, 71, 82, 52,  0,  0, 66, 76, 79, 68, 71, 82, 49,
    0,  0,  8,  0,  0,  0,  1, 83, 76, 65, 68, 82, 73, 80, 51,  0,
   83, 76, 65, 68, 82, 73, 80, 49,  0,  8,  0,  0,  0,  1, 66, 76,
   79, 68, 82, 73, 80, 52,  0, 66, 76, 79, 68, 82, 73, 80, 49,  0,
    8,  0,  0,  0,  1, 70, 73, 82, 69, 87, 65, 76, 76,  0, 70, 73,
   82, 69, 87, 65, 76, 65,  0,  8,  0,  0,  0,  1, 71, 83, 84, 70,
   79, 78, 84, 51,  0, 71, 83, 84, 70, 79, 78, 84, 49,  0,  8,  0,
    0,  0,  1, 70, 73, 82, 69, 76, 65, 86, 65,  0, 70, 73, 82, 69,
   76, 65, 86, 51,  0,  8,  0,  0,  0,  1, 70, 73, 82, 69, 77, 65,
   71, 51,  0, 70, 73, 82, 69, 77, 65, 71, 49,  0,  8,  0,  0,  0,
    1, 70, 73, 82, 69, 66, 76, 85, 50,  0, 70, 73, 82, 69, 66, 76,
   85, 49,  0,  8,  0,  0,  0,  1, 82, 79, 67, 75, 82, 69, 68, 51,
    0, 82, 79, 67, 75, 82, 69, 68, 49,  0,  8,  0,  0,  0,  1, 66,
   70, 65, 76, 76, 52,  0,  0,  0, 66, 70, 65, 76, 76, 49,  0,  0,
    0,  8,  0,  0,  0,  1, 83, 70, 65, 76, 76, 52,  0,  0,  0, 83,
   70, 65, 76, 76, 49,  0,  0,  0,  8,  0,  0,  0,  1, 87, 70, 65,
   76, 76, 52,  0,  0,  0, 87, 70, 65, 76, 76, 49,  0,  0,  0,  8,
    0,  0,  0,  1, 68, 66, 82, 65, 73, 78, 52,  0,  0, 68, 66, 82,
   65, 73, 78, 49,  0,  0,  8,  0,  0,  0,255,255,255,255,
};

// Switch textures definition lump -- see SWANTBLS.EXE docs
static const char switches[]=
{
   83, 87, 49, 66, 82, 67, 79, 77,  0, 83, 87, 50, 66, 82, 67, 79,
   77,  0,  1,  0, 83, 87, 49, 66, 82, 78, 49,  0,  0, 83, 87, 50,
   66, 82, 78, 49,  0,  0,  1,  0, 83, 87, 49, 66, 82, 78, 50,  0,
    0, 83, 87, 50, 66, 82, 78, 50,  0,  0,  1,  0, 83, 87, 49, 66,
   82, 78, 71, 78,  0, 83, 87, 50, 66, 82, 78, 71, 78,  0,  1,  0,
   83, 87, 49, 66, 82, 79, 87, 78,  0, 83, 87, 50, 66, 82, 79, 87,
   78,  0,  1,  0, 83, 87, 49, 67, 79, 77, 77,  0,  0, 83, 87, 50,
   67, 79, 77, 77,  0,  0,  1,  0, 83, 87, 49, 67, 79, 77, 80,  0,
    0, 83, 87, 50, 67, 79, 77, 80,  0,  0,  1,  0, 83, 87, 49, 68,
   73, 82, 84,  0,  0, 83, 87, 50, 68, 73, 82, 84,  0,  0,  1,  0,
   83, 87, 49, 69, 88, 73, 84,  0,  0, 83, 87, 50, 69, 88, 73, 84,
    0,  0,  1,  0, 83, 87, 49, 71, 82, 65, 89,  0,  0, 83, 87, 50,
   71, 82, 65, 89,  0,  0,  1,  0, 83, 87, 49, 71, 82, 65, 89, 49,
    0, 83, 87, 50, 71, 82, 65, 89, 49,  0,  1,  0, 83, 87, 49, 77,
   69, 84, 65, 76,  0, 83, 87, 50, 77, 69, 84, 65, 76,  0,  1,  0,
   83, 87, 49, 80, 73, 80, 69,  0,  0, 83, 87, 50, 80, 73, 80, 69,
    0,  0,  1,  0, 83, 87, 49, 83, 76, 65, 68,  0,  0, 83, 87, 50,
   83, 76, 65, 68,  0,  0,  1,  0, 83, 87, 49, 83, 84, 65, 82, 71,
    0, 83, 87, 50, 83, 84, 65, 82, 71,  0,  1,  0, 83, 87, 49, 83,
   84, 79, 78, 49,  0, 83, 87, 50, 83, 84, 79, 78, 49,  0,  1,  0,
   83, 87, 49, 83, 84, 79, 78, 50,  0, 83, 87, 50, 83, 84, 79, 78,
   50,  0,  1,  0, 83, 87, 49, 83, 84, 79, 78, 69,  0, 83, 87, 50,
   83, 84, 79, 78, 69,  0,  1,  0, 83, 87, 49, 83, 84, 82, 84, 78,
    0, 83, 87, 50, 83, 84, 82, 84, 78,  0,  1,  0, 83, 87, 49, 66,
   76, 85, 69,  0,  0, 83, 87, 50, 66, 76, 85, 69,  0,  0,  2,  0,
   83, 87, 49, 67, 77, 84,  0,  0,  0, 83, 87, 50, 67, 77, 84,  0,
    0,  0,  2,  0, 83, 87, 49, 71, 65, 82, 71,  0,  0, 83, 87, 50,
   71, 65, 82, 71,  0,  0,  2,  0, 83, 87, 49, 71, 83, 84, 79, 78,
    0, 83, 87, 50, 71, 83, 84, 79, 78,  0,  2,  0, 83, 87, 49, 72,
   79, 84,  0,  0,  0, 83, 87, 50, 72, 79, 84,  0,  0,  0,  2,  0,
   83, 87, 49, 76, 73, 79, 78,  0,  0, 83, 87, 50, 76, 73, 79, 78,
    0,  0,  2,  0, 83, 87, 49, 83, 65, 84, 89, 82,  0, 83, 87, 50,
   83, 65, 84, 89, 82,  0,  2,  0, 83, 87, 49, 83, 75, 73, 78,  0,
    0, 83, 87, 50, 83, 75, 73, 78,  0,  0,  2,  0, 83, 87, 49, 86,
   73, 78, 69,  0,  0, 83, 87, 50, 86, 73, 78, 69,  0,  0,  2,  0,
   83, 87, 49, 87, 79, 79, 68,  0,  0, 83, 87, 50, 87, 79, 79, 68,
    0,  0,  2,  0, 83, 87, 49, 80, 65, 78, 69, 76,  0, 83, 87, 50,
   80, 65, 78, 69, 76,  0,  3,  0, 83, 87, 49, 82, 79, 67, 75,  0,
    0, 83, 87, 50, 82, 79, 67, 75,  0,  0,  3,  0, 83, 87, 49, 77,
   69, 84, 50,  0,  0, 83, 87, 50, 77, 69, 84, 50,  0,  0,  3,  0,
   83, 87, 49, 87, 68, 77, 69, 84,  0, 83, 87, 50, 87, 68, 77, 69,
   84,  0,  3,  0, 83, 87, 49, 66, 82, 73, 75,  0,  0, 83, 87, 50,
   66, 82, 73, 75,  0,  0,  3,  0, 83, 87, 49, 77, 79, 68, 49,  0,
    0, 83, 87, 50, 77, 79, 68, 49,  0,  0,  3,  0, 83, 87, 49, 90,
   73, 77,  0,  0,  0, 83, 87, 50, 90, 73, 77,  0,  0,  0,  3,  0,
   83, 87, 49, 83, 84, 79, 78, 54,  0, 83, 87, 50, 83, 84, 79, 78,
   54,  0,  3,  0, 83, 87, 49, 84, 69, 75,  0,  0,  0, 83, 87, 50,
   84, 69, 75,  0,  0,  0,  3,  0, 83, 87, 49, 77, 65, 82, 66,  0,
    0, 83, 87, 50, 77, 65, 82, 66,  0,  0,  3,  0, 83, 87, 49, 83,
   75, 85, 76, 76,  0, 83, 87, 50, 83, 75, 85, 76, 76,  0,  3,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,
};

// colormap for underwater, original default greenish
static const unsigned char watermap[] = {
  0,126,127,103,193,5,6,7,8,123,124,126,12,122,123,124,193,193,194,194,88,90,
  92,93,95,96,98,98,100,101,102,103,3,105,106,107,14,15,15,238,238,239,239,239,
  1,2,2,2,193,193,193,193,193,193,193,86,112,112,112,112,113,114,115,115,115,
  116,117,117,118,118,119,120,121,121,122,122,123,124,124,125,193,193,194,194,
  194,194,194,194,194,194,194,194,194,195,195,195,93,94,95,96,97,98,100,101,
  102,104,104,106,106,108,109,110,112,112,113,113,113,114,115,115,117,119,120,
  121,123,124,125,127,112,112,112,113,114,115,115,116,117,118,118,119,119,121,
  121,122,115,116,117,118,120,121,122,123,115,116,117,118,119,121,121,122,112,
  112,112,114,117,120,122,78,193,193,193,194,91,95,136,34,186,187,187,188,188,
  189,189,45,45,46,47,47,47,47,2,2,193,194,194,195,196,197,198,199,200,200,200,
  200,201,202,204,205,193,193,193,193,112,112,114,116,117,118,118,120,120,120,
  74,75,193,193,193,86,112,112,113,114,75,75,76,77,122,124,125,126,205,206,207,
  241,243,244,246,0,113,112,195,198,198,199,204,96,0,126,127,103,193,5,6,7,8,
  123,124,126,12,122,123,124,193,194,194,88,90,90,93,95,95,96,98,98,100,101,
  103,103,105,105,106,107,14,15,15,238,238,239,239,239,1,2,2,2,193,193,193,193,
  193,193,86,86,112,112,112,113,114,115,115,115,115,117,117,117,118,118,120,
  120,121,121,122,122,123,124,124,125,193,194,194,194,194,194,194,194,194,194,
  194,194,195,195,195,195,94,94,95,97,97,98,101,101,103,104,104,106,106,108,
  109,110,112,112,113,113,113,114,115,115,117,119,120,121,123,124,125,127,112,
  112,113,114,115,115,115,117,117,118,118,119,119,121,122,122,115,116,117,118,
  120,121,122,123,115,116,117,118,119,121,121,122,112,112,112,114,117,120,122,
  78,193,193,193,194,91,95,136,34,186,187,188,188,188,189,189,45,45,46,47,47,
  47,47,2,2,193,194,194,195,196,197,198,199,200,200,200,200,201,202,204,205,
  193,193,193,193,112,112,114,116,118,118,120,120,120,120,75,75,193,193,193,86,
  112,112,113,114,75,75,76,77,122,124,125,126,205,206,207,241,243,244,246,0,
  113,112,195,198,198,199,204,96,0,126,127,104,193,5,6,7,8,123,124,126,12,122,
  123,124,193,194,194,90,90,92,93,95,96,98,98,100,101,102,103,3,105,106,107,14,
  15,15,238,238,239,239,239,1,1,2,2,2,193,193,193,193,193,193,86,112,112,112,
  112,113,114,115,115,115,116,117,117,118,118,119,120,121,121,122,122,123,123,
  124,124,125,194,194,194,194,194,194,194,194,194,194,194,194,195,195,195,93,
  94,95,96,97,98,100,101,102,103,104,104,106,106,108,109,110,112,113,113,113,
  114,115,115,117,119,119,120,121,123,124,125,127,112,112,113,114,115,115,116,
  117,118,118,119,119,121,121,122,122,115,117,118,119,121,121,123,124,116,117,
  118,118,119,121,122,122,112,112,112,114,117,120,122,78,193,193,193,88,91,95,
  136,34,187,187,188,188,189,189,45,45,46,47,47,47,47,2,2,2,194,194,194,195,
  196,197,198,199,200,200,200,200,201,202,204,205,193,193,193,86,112,112,114,
  117,118,118,120,120,120,74,75,75,193,193,193,86,112,112,113,114,75,76,76,77,
  123,124,125,126,205,206,207,241,243,244,246,0,114,112,195,198,198,199,204,96,
  0,126,127,104,193,5,6,7,8,123,124,126,12,123,124,125,194,194,88,90,92,93,95,
  96,98,98,100,100,101,102,3,3,106,106,107,14,15,15,238,238,239,239,1,1,1,2,2,
  2,194,193,193,193,193,194,112,112,112,112,113,114,115,115,115,116,117,117,
  118,118,118,119,121,121,121,122,122,123,123,124,125,125,194,194,194,194,194,
  194,194,194,194,194,194,195,195,195,93,94,95,95,97,98,98,100,102,102,104,104,
  106,106,108,108,110,110,112,113,113,113,114,115,115,117,119,120,121,123,123,
  124,125,127,112,113,114,115,115,116,117,118,118,119,119,119,121,121,122,122,
  116,117,118,119,121,122,123,124,116,117,118,119,121,121,122,123,112,112,114,
  117,117,120,122,78,193,194,194,88,92,95,136,34,187,188,188,189,189,189,45,45,
  46,47,47,47,47,2,2,2,194,194,195,195,196,197,198,199,200,200,200,201,202,202,
  204,206,193,194,193,112,112,113,114,118,118,120,120,120,74,75,75,75,193,193,
  193,86,112,112,113,114,75,76,77,78,123,124,125,126,206,207,207,241,243,244,
  246,0,114,112,195,198,198,199,204,96,0,126,127,104,194,5,6,7,8,123,124,126,
  12,123,124,125,194,88,90,90,93,93,95,96,98,100,100,101,102,103,3,105,106,107,
  14,15,15,15,238,238,239,239,1,1,2,2,2,2,194,194,193,193,194,194,194,112,112,
  113,114,115,115,115,116,116,117,118,118,118,119,120,121,121,121,122,122,123,
  124,124,125,125,194,194,194,194,194,194,194,194,194,194,195,195,195,93,93,95,
  95,96,97,98,100,101,102,103,104,106,106,106,108,109,110,5,113,113,113,114,
  114,115,115,117,119,120,121,123,123,124,125,127,113,113,114,115,116,116,117,
  118,118,119,119,121,121,122,122,122,116,117,118,120,121,122,123,124,116,118,
  118,119,121,121,122,123,112,112,114,117,120,122,78,78,194,194,194,90,93,96,
  136,34,187,188,188,189,189,45,45,46,46,47,47,47,47,2,2,2,194,194,195,196,196,
  197,198,199,200,200,200,201,202,204,205,206,194,194,193,112,112,114,115,118,
  120,120,120,120,74,75,75,75,194,194,193,112,112,112,113,114,76,76,77,78,123,
  124,125,126,206,207,241,241,243,244,246,0,115,112,195,198,199,199,204,117,0,
  127,127,104,194,5,6,7,8,123,124,126,12,123,124,125,194,90,90,93,93,95,96,98,
  98,100,101,102,103,3,105,106,106,14,14,15,15,238,238,239,239,239,1,1,2,2,2,2,
  194,194,194,112,112,112,88,112,113,114,114,115,115,116,117,117,117,118,118,
  119,119,121,121,121,122,122,122,123,124,124,125,126,194,194,194,194,194,194,
  194,194,195,195,195,195,93,94,94,95,96,97,98,100,100,101,103,103,104,106,106,
  108,108,109,110,5,113,113,113,114,115,115,117,117,119,120,121,123,124,125,
  125,127,113,114,115,115,116,117,118,118,119,119,119,121,121,122,122,123,117,
  118,119,120,121,122,123,124,117,118,119,119,121,121,122,123,112,112,114,117,
  120,122,78,78,194,194,194,90,95,98,136,188,188,188,189,189,45,45,45,46,47,47,
  47,47,47,2,2,2,194,194,195,196,197,197,198,200,200,200,200,201,202,204,205,
  206,194,194,112,112,113,115,115,118,120,120,120,74,75,75,75,76,194,194,193,
  112,112,112,112,114,76,77,78,78,123,125,125,126,206,207,241,243,243,244,246,
  0,115,112,195,198,199,204,204,117,0,127,127,106,194,6,6,7,8,124,126,126,12,
  123,124,125,112,90,92,93,95,96,96,98,100,100,102,102,103,3,106,106,14,14,15,
  15,238,238,238,239,239,1,1,2,2,2,2,2,194,194,112,112,112,112,112,113,113,114,
  115,115,116,116,117,117,118,118,119,119,120,121,121,121,122,122,123,123,124,
  124,125,126,194,194,194,194,194,194,194,194,195,195,195,195,93,94,95,96,97,
  97,98,100,101,102,103,104,104,106,106,108,108,109,110,5,113,113,114,114,115,
  115,117,119,120,120,121,123,124,125,127,127,114,115,115,116,117,117,118,118,
  119,119,121,121,121,122,123,123,117,118,119,121,122,122,124,124,117,118,119,
  121,121,122,123,123,112,112,114,117,120,122,78,78,194,194,112,92,96,98,101,
  188,188,189,189,189,45,45,46,46,47,47,47,47,2,2,2,2,194,194,195,196,197,198,
  198,200,200,200,201,201,202,204,205,206,194,194,112,112,114,115,115,120,120,
  120,74,74,75,75,75,76,194,194,112,112,112,112,112,114,76,77,78,78,124,125,
  126,126,206,207,241,243,244,244,246,0,115,112,195,198,199,204,204,118,0,127,
  127,106,194,6,6,7,8,124,126,12,12,124,124,125,112,112,93,96,96,96,96,100,100,
  101,102,103,3,105,106,106,14,14,15,15,238,238,239,239,1,1,2,2,2,2,2,2,194,
  194,112,112,112,112,112,112,114,115,115,115,116,117,117,118,118,118,119,120,
  121,121,121,122,122,122,123,124,124,124,125,126,194,194,194,194,194,194,194,
  195,195,195,93,93,94,95,95,96,98,98,100,101,101,103,104,104,106,106,106,108,
  108,109,5,5,113,113,114,115,115,115,117,119,120,120,121,123,124,125,127,127,
  115,115,116,117,117,118,118,119,119,121,121,121,122,122,123,123,118,119,119,
  121,122,123,124,124,118,118,119,121,121,122,123,123,112,114,114,117,120,122,
  78,78,194,194,112,93,96,100,102,188,188,189,189,45,45,45,46,47,47,47,47,47,2,
  2,2,2,194,194,194,196,197,198,198,200,200,200,201,202,202,204,205,206,194,
  194,112,112,114,115,117,120,120,120,74,75,75,75,76,76,194,194,112,112,112,
  112,112,114,77,78,78,78,124,125,126,126,206,207,241,243,244,244,246,0,115,
  112,90,198,199,204,204,118,0,127,127,106,194,6,7,8,8,124,126,12,12,124,125,
  125,112,112,113,96,96,96,96,100,101,102,103,103,3,106,106,14,14,15,15,238,
  238,238,239,1,1,1,2,2,2,2,2,2,194,112,112,112,112,112,112,112,115,115,115,
  116,117,117,118,118,118,119,120,121,121,121,122,122,122,123,123,124,124,125,
  125,126,194,194,194,194,194,195,195,195,195,93,94,94,95,96,96,97,98,98,100,
  101,102,103,104,104,106,106,108,108,109,110,5,5,113,114,114,115,115,117,119,
  119,120,121,123,123,124,125,127,127,115,115,116,117,118,118,119,119,119,121,
  121,122,122,123,123,124,118,119,121,121,122,123,124,124,118,119,119,121,121,
  122,123,123,112,114,117,118,120,122,78,1,194,112,112,95,98,101,103,189,189,
  189,45,45,45,46,46,47,47,47,47,47,2,2,2,2,194,194,195,196,197,198,200,200,
  200,200,201,202,204,204,205,207,194,194,112,112,115,115,117,120,120,74,75,75,
  75,76,76,77,194,194,112,112,112,112,114,114,78,78,78,239,124,125,126,126,207,
  207,241,243,244,244,246,0,116,114,90,198,199,204,204,118,0,127,127,106,194,6,
  7,8,8,124,126,12,12,124,125,125,112,113,96,96,96,96,100,100,118,103,119,120,
  106,106,14,14,15,15,15,238,238,239,1,1,1,1,2,2,2,2,2,2,194,112,112,112,112,
  112,113,113,115,115,116,117,117,118,118,118,119,120,120,121,121,121,122,122,
  122,123,124,124,124,125,125,126,194,194,194,194,195,195,195,195,93,93,94,95,
  96,96,97,98,100,100,101,102,103,104,104,104,106,106,108,109,109,110,5,5,113,
  114,115,115,115,117,119,120,120,121,123,123,124,125,127,127,115,116,117,118,
  118,118,119,119,121,121,121,122,122,123,123,124,118,119,121,121,122,123,124,
  124,118,119,121,121,122,123,123,123,112,114,117,118,121,122,78,1,194,112,112,
  96,98,101,103,189,189,45,45,45,46,46,47,47,47,47,47,2,2,2,2,2,194,194,195,93,
  197,198,200,200,200,201,201,202,204,205,205,207,194,112,112,113,115,116,117,
  120,120,75,75,75,122,76,76,78,194,112,112,112,112,114,114,114,78,78,78,239,
  124,125,126,126,207,241,241,243,244,244,246,0,117,114,195,198,199,204,204,
  119,0,127,7,106,194,6,7,8,8,124,126,12,12,124,125,125,113,96,96,96,96,96,100,
  118,119,119,120,120,106,106,14,14,15,15,238,238,238,239,1,1,1,2,2,2,2,2,2,2,
  194,112,112,112,113,113,114,115,115,116,117,117,118,118,118,119,119,120,121,
  121,121,122,122,122,123,123,124,124,125,125,126,126,194,194,195,195,195,195,
  195,93,94,94,95,95,96,97,98,98,100,101,102,103,103,104,104,106,106,108,108,
  109,109,110,5,5,114,115,115,115,117,119,119,120,121,121,123,124,124,125,127,
  127,116,117,118,118,118,119,119,119,121,121,121,122,122,123,124,124,119,119,
  121,122,123,123,124,125,119,121,121,121,122,123,123,110,114,114,117,118,121,
  78,78,1,194,194,113,96,100,101,3,189,189,45,45,45,46,47,47,47,47,47,47,2,2,2,
  2,2,194,195,195,94,96,198,200,200,200,201,202,202,204,205,206,207,194,194,
  112,113,116,117,117,120,120,75,122,122,122,76,78,78,194,112,112,112,114,114,
  114,114,78,78,78,239,124,125,126,126,207,241,241,243,244,246,246,0,117,114,
  96,199,199,204,204,119,0,127,7,108,194,6,7,8,8,124,126,127,12,124,125,125,96,
  96,96,96,96,117,118,119,119,120,121,121,121,121,14,15,15,15,238,238,1,1,1,1,
  1,2,2,2,2,2,2,2,194,112,112,113,113,114,115,115,116,117,117,118,118,118,119,
  119,120,121,121,121,121,122,122,122,123,124,124,124,125,125,126,126,194,195,
  195,195,195,93,93,94,95,95,96,96,97,98,98,100,101,101,102,103,104,104,106,
  106,106,108,108,109,110,5,5,5,114,115,115,117,117,119,120,120,121,121,123,
  124,124,125,127,7,117,117,118,118,119,119,119,121,121,122,122,122,123,123,
  124,124,119,121,121,122,123,124,124,125,119,121,121,121,122,123,123,110,114,
  116,118,120,121,78,78,1,194,195,114,96,100,102,105,45,45,45,45,46,46,47,47,
  47,47,47,2,2,2,2,2,2,194,195,93,95,97,200,200,200,200,201,202,204,204,205,
  206,207,194,194,113,115,116,117,120,120,120,75,122,122,122,78,78,78,194,112,
  112,113,114,114,114,117,78,78,78,239,124,125,126,126,207,241,243,243,244,246,
  246,0,117,114,96,199,199,204,204,119,0,127,7,108,194,6,7,8,8,5,126,12,8,124,
  125,125,96,96,96,117,117,118,118,119,120,120,121,121,121,121,15,15,15,238,
  238,239,1,1,1,1,2,2,2,2,2,2,2,2,195,113,113,114,114,115,115,115,116,117,118,
  118,118,119,120,120,121,121,121,121,122,122,122,123,123,124,124,124,125,125,
  126,126,195,195,195,195,93,94,94,95,96,96,97,97,98,100,100,101,102,102,103,
  104,104,106,106,106,108,108,109,109,110,5,5,6,115,115,115,117,119,119,120,
  120,121,123,123,124,125,125,127,8,118,118,118,119,119,119,121,121,121,122,
  122,123,123,124,124,124,119,121,122,122,123,124,124,125,119,121,121,122,123,
  123,124,124,115,116,118,121,121,122,123,1,194,195,115,96,101,103,105,45,45,
  45,46,46,47,47,47,47,47,47,2,2,2,2,2,2,195,195,94,96,98,201,201,201,201,202,
  202,204,204,205,206,241,194,195,114,115,117,118,120,120,122,122,122,122,122,
  78,78,78,194,112,113,115,114,114,117,117,78,78,239,1,124,125,126,127,241,241,
  243,243,244,246,246,0,118,117,96,199,204,204,108,119,0,127,7,108,195,6,7,8,8,
  5,126,12,8,125,125,126,96,116,117,117,118,118,119,119,119,121,121,121,121,
  122,15,15,238,238,238,1,1,1,1,2,2,2,2,2,2,2,2,127,195,114,114,115,115,115,
  116,116,116,118,118,118,119,120,120,121,121,121,121,122,122,122,123,123,124,
  124,125,124,125,126,126,126,195,195,93,93,94,95,95,96,96,97,98,98,100,100,
  101,101,102,103,104,104,104,106,106,106,108,109,109,110,110,5,5,6,115,115,
  117,117,119,120,120,121,121,123,123,124,125,125,127,8,118,118,119,119,119,
  121,121,121,122,122,122,123,123,124,124,124,121,121,122,123,124,124,125,125,
  121,121,121,122,123,123,124,124,116,116,118,121,122,123,124,126,195,195,115,
  117,102,3,106,45,45,46,46,47,47,47,47,47,47,2,2,2,2,2,2,127,195,93,95,97,98,
  201,201,201,201,202,202,204,205,205,207,241,195,195,115,115,117,118,120,120,
  122,122,122,122,78,78,78,78,195,195,114,115,116,117,117,117,78,78,239,1,125,
  125,126,127,241,241,243,244,244,246,246,0,118,117,96,199,204,204,108,121,0,
  127,8,109,195,6,7,8,8,125,126,127,8,125,125,126,116,117,117,118,118,118,119,
  119,121,121,121,121,122,122,123,123,124,238,1,1,1,1,1,2,2,2,2,2,2,2,127,127,
  93,115,115,115,115,116,116,117,117,118,118,119,120,121,121,121,121,122,122,
  122,122,123,123,124,124,124,125,125,125,126,126,127,93,93,94,94,95,96,96,97,
  97,98,98,100,100,101,101,102,103,104,104,106,106,106,106,108,108,109,109,110,
  5,5,6,6,115,117,117,119,119,120,121,121,123,123,124,124,125,127,127,8,118,
  119,119,119,121,121,121,122,122,122,123,123,124,124,124,125,121,122,122,123,
  124,124,125,125,121,121,122,122,123,109,124,5,116,117,120,121,122,123,124,
  126,195,93,116,117,103,105,107,15,46,46,47,47,47,47,47,47,47,2,2,2,2,2,2,127,
  93,95,96,98,100,201,201,201,201,202,204,204,205,206,207,241,195,93,115,116,
  117,118,119,122,122,122,122,78,78,78,78,78,195,195,115,116,116,117,117,117,
  78,239,1,1,125,126,126,127,241,243,243,244,244,246,246,0,119,117,96,199,204,
  204,109,121,0,7,8,109,195,7,7,8,8,126,127,127,8,125,125,126,117,117,118,118,
  119,119,119,121,121,121,122,122,122,122,123,123,124,124,1,1,1,1,2,2,2,2,2,2,
  2,2,127,127,94,95,115,116,116,117,117,117,117,118,118,120,121,121,121,121,
  122,122,122,122,122,123,124,124,124,125,125,125,125,126,126,127,94,94,95,95,
  96,97,97,98,98,98,100,100,101,102,102,103,104,104,104,106,106,106,108,108,
  109,109,110,5,5,5,6,6,117,117,119,119,120,120,121,121,123,123,124,124,125,
  127,127,8,119,119,119,121,121,121,122,122,122,123,123,124,124,124,124,125,
  121,122,123,123,124,124,125,126,121,122,122,123,123,110,124,5,116,118,121,
  121,122,123,125,126,195,95,117,118,119,106,107,15,46,47,47,47,47,47,47,47,2,
  2,2,2,2,2,2,127,94,95,97,98,101,202,202,202,202,202,204,204,205,206,207,241,
  195,94,116,117,118,119,120,122,122,122,78,78,78,78,78,78,195,94,115,116,116,
  117,117,120,239,1,1,1,125,126,126,127,241,243,243,244,244,246,246,0,120,118,
  96,199,204,204,109,121,0,7,8,109,94,7,7,8,8,126,127,127,8,125,126,126,118,
  118,118,119,119,119,121,121,121,121,122,122,122,123,123,124,124,124,125,1,1,
  2,2,2,2,2,2,2,127,127,127,127,95,115,117,117,117,118,118,118,118,118,120,121,
  121,121,121,121,122,122,122,122,123,124,124,124,124,125,125,125,125,126,126,
  127,95,95,96,96,97,98,98,98,100,100,101,101,102,103,103,104,104,104,106,106,
  106,108,108,108,109,110,110,5,5,5,6,6,117,119,119,120,120,121,121,123,123,
  123,124,125,125,127,127,8,119,119,121,121,121,122,122,122,123,123,123,124,
  124,124,125,125,122,122,123,124,124,125,125,126,121,122,122,123,109,110,124,
  5,117,118,121,122,122,123,125,126,94,95,117,118,120,106,14,15,47,47,47,47,47,
  47,47,2,2,2,2,2,2,2,127,127,95,96,98,100,102,202,202,202,202,204,204,205,205,
  206,207,241,94,95,117,118,118,120,121,122,122,78,78,78,78,78,78,239,94,115,
  115,116,117,118,120,120,1,1,1,2,125,126,126,127,241,243,243,244,244,246,246,
  0,121,118,97,204,204,204,110,122,0,7,8,110,95,7,7,8,0,6,127,7,8,125,126,126,
  118,119,119,119,119,121,121,121,122,122,122,122,123,123,124,124,124,125,125,
  125,126,126,126,2,2,2,2,127,127,127,127,127,96,97,117,118,118,118,118,118,
  119,119,120,121,121,121,122,122,122,122,123,123,124,124,124,124,125,125,125,
  125,126,126,127,127,96,97,97,97,98,98,100,100,101,101,102,102,103,104,104,
  104,106,106,106,106,108,108,108,109,109,110,5,5,5,6,6,6,119,119,120,120,120,
  121,121,123,123,124,124,125,125,127,127,8,121,121,121,121,122,122,122,123,
  123,124,124,124,124,125,125,125,122,123,123,124,124,125,126,126,122,122,123,
  123,110,124,5,5,118,120,121,122,123,124,125,126,95,97,118,119,121,14,15,238,
  47,47,47,47,47,47,2,2,2,2,2,2,2,2,127,127,96,98,100,101,103,202,202,202,202,
  204,204,205,206,207,241,243,95,96,118,118,118,121,121,122,78,78,78,78,78,78,
  1,1,95,115,116,117,118,118,120,120,1,1,1,2,125,126,127,127,243,243,244,244,
  246,246,0,0,121,120,98,204,204,204,110,122,0,7,8,110,96,7,8,8,0,6,127,7,8,
  126,126,126,119,119,119,121,121,121,121,122,122,122,123,123,123,124,124,124,
  125,125,125,126,126,126,126,126,126,126,127,127,127,127,127,127,97,98,118,
  118,118,119,119,119,119,120,121,121,122,122,122,122,122,123,123,124,124,124,
  125,125,125,125,125,126,126,126,127,127,97,98,98,98,100,100,101,101,102,102,
  103,103,104,104,104,106,106,106,106,108,108,108,109,109,110,5,5,5,5,6,6,6,
  119,119,120,120,121,121,123,123,124,124,124,125,127,127,7,8,121,121,121,122,
  122,122,123,123,124,124,124,124,110,125,125,5,122,123,124,124,125,125,126,
  126,122,123,123,109,110,5,5,126,118,120,122,122,123,124,126,126,96,98,119,
  119,121,14,15,238,47,47,47,47,47,2,2,2,2,2,2,2,2,127,127,127,97,98,101,102,
  104,204,204,204,204,204,205,205,206,207,241,243,96,97,118,119,120,121,121,78,
  78,78,78,78,78,1,1,1,96,116,116,118,118,121,121,122,1,1,126,2,126,126,127,
  127,243,243,244,244,246,246,0,0,121,121,100,204,204,108,110,123,0,8,8,5,97,7,
  8,8,0,6,127,8,8,126,126,127,119,119,121,121,121,121,122,122,123,123,123,123,
  124,124,125,125,125,125,126,126,126,126,126,126,126,127,127,127,127,127,127,
  127,98,100,119,119,119,119,119,119,121,121,121,121,122,122,122,122,123,124,
  124,124,124,125,125,125,125,125,126,126,126,127,127,127,98,100,100,100,101,
  102,102,102,103,103,104,104,104,106,106,106,106,106,108,108,108,109,109,110,
  110,5,5,5,6,6,6,7,120,120,120,121,121,123,123,123,124,124,125,125,127,127,8,
  8,121,122,122,122,123,123,123,124,124,109,124,125,125,125,5,126,123,124,124,
  124,125,125,126,126,108,123,109,110,5,5,126,6,120,120,122,123,124,125,126,
  126,97,100,119,121,121,15,238,239,47,47,47,47,2,2,2,2,2,2,2,2,2,127,127,127,
  98,101,102,103,104,204,204,204,204,205,205,206,207,207,241,243,97,98,119,119,
  120,121,122,78,78,78,78,78,1,1,1,1,97,117,117,118,120,120,121,122,126,126,
  126,2,126,126,127,127,243,243,244,244,246,246,0,0,122,120,101,204,204,109,5,
  123,0,8,8,5,98,7,8,8,0,6,7,8,8,126,126,127,121,121,121,121,122,122,122,123,
  123,123,124,124,124,125,125,125,126,126,126,126,126,126,126,126,127,127,127,
  127,127,127,127,127,100,101,119,119,119,121,121,121,121,121,122,122,122,122,
  123,123,124,124,124,124,125,125,125,125,125,126,126,126,126,127,127,127,100,
  101,101,102,102,103,103,104,104,104,104,104,106,106,106,106,108,108,108,109,
  109,109,110,110,5,5,5,6,6,6,6,7,120,120,121,121,123,123,123,124,124,124,125,
  125,127,127,8,8,122,122,106,106,123,108,108,124,109,109,110,125,125,5,126,
  126,123,124,124,125,125,126,126,127,123,109,110,110,5,5,126,6,120,121,122,
  123,124,125,126,126,98,101,121,121,122,122,238,239,47,47,2,2,2,2,2,2,2,2,2,2,
  127,127,127,127,100,102,103,104,106,204,204,204,204,205,206,206,207,241,243,
  243,98,101,119,121,121,122,122,78,78,78,123,124,125,1,126,126,98,118,118,120,
  120,120,122,122,126,126,126,126,126,127,127,127,243,244,244,244,246,246,0,0,
  122,122,102,204,204,109,5,124,0,8,8,5,101,7,8,8,0,127,7,8,8,126,127,127,121,
  121,122,122,122,122,123,123,124,124,124,124,125,125,125,126,126,126,126,126,
  126,126,126,126,127,127,127,127,127,127,127,127,102,102,103,121,121,121,121,
  121,122,122,122,122,123,123,124,124,124,124,125,125,125,125,125,125,126,126,
  126,126,127,127,127,7,102,102,103,103,103,104,104,104,104,106,106,106,106,
  106,106,108,108,108,109,109,109,110,5,5,5,5,5,6,6,6,7,7,121,121,121,123,123,
  123,124,124,124,125,125,127,127,127,8,8,106,106,106,108,108,108,109,109,109,
  110,110,125,5,126,126,126,124,124,124,125,126,126,126,127,109,110,110,5,5,5,
  6,6,121,122,123,124,125,126,126,126,101,102,121,122,122,123,238,239,47,2,2,2,
  2,2,2,2,2,2,2,127,127,127,127,127,102,103,104,106,106,205,205,205,205,205,
  206,207,207,241,243,243,101,102,121,121,122,122,123,123,123,124,124,125,125,
  126,126,126,101,118,119,119,121,122,122,122,126,126,126,126,126,127,127,7,
  243,244,244,246,246,246,0,0,122,122,104,204,204,110,5,124,0,8,8,5,102,8,8,0,
  0,7,7,8,8,127,127,127,122,122,122,123,123,123,124,124,124,124,125,125,125,
  125,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  103,104,104,121,121,122,122,122,122,122,123,123,124,124,124,124,124,125,125,
  125,125,125,126,126,126,126,126,126,127,127,127,7,103,104,104,104,104,104,
  106,106,106,106,106,106,108,108,108,108,109,109,109,110,110,5,5,5,5,6,6,6,6,
  6,7,7,121,121,123,123,123,124,124,124,125,125,125,127,127,127,8,8,106,108,
  108,108,109,109,109,110,110,110,5,5,5,126,126,126,124,124,125,125,126,126,
  127,127,110,110,5,5,5,6,6,6,121,122,123,124,125,126,126,127,102,104,122,122,
  123,124,1,1,2,2,2,2,2,2,2,2,2,2,127,127,127,127,127,127,103,104,106,106,108,
  205,205,205,205,206,207,207,241,241,243,244,102,103,121,122,122,123,123,124,
  124,125,125,125,126,126,126,126,102,103,119,121,122,122,122,122,126,126,126,
  126,127,127,127,8,244,244,244,246,246,246,0,0,123,122,104,204,108,110,6,125,
  0,8,8,6,104,8,8,0,0,7,8,8,0,127,127,127,122,123,123,123,123,124,124,124,125,
  125,125,125,126,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,
  127,127,8,8,104,104,104,122,122,122,122,123,123,123,124,124,124,124,125,125,
  125,125,125,125,126,126,126,126,126,126,126,127,127,127,7,8,104,104,104,106,
  106,106,106,106,106,108,108,108,108,109,109,109,109,110,110,5,5,5,5,5,6,6,6,
  6,6,7,7,7,123,123,123,123,124,124,124,125,125,125,127,127,127,8,8,8,108,108,
  109,109,109,110,110,110,5,5,5,126,126,126,6,127,124,125,125,126,126,126,127,
  127,110,5,5,5,6,6,6,127,122,123,124,124,125,126,126,127,104,104,122,123,124,
  124,1,1,2,2,2,2,2,2,2,2,2,127,127,127,127,127,127,8,104,106,106,108,108,206,
  206,206,206,207,207,241,241,243,243,244,104,104,122,122,123,124,124,125,125,
  125,126,126,126,126,126,126,104,104,121,121,122,122,123,123,126,126,126,127,
  127,127,7,8,244,244,244,246,246,246,0,0,124,123,106,204,109,5,6,110,0,8,8,6,
  104,8,8,0,0,7,8,8,0,127,127,7,123,123,124,124,124,124,125,125,125,125,126,
  126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,8,8,
  8,106,106,106,106,123,123,123,123,124,124,124,124,125,125,125,125,125,125,
  125,126,126,126,126,126,126,127,127,127,127,7,7,8,106,106,106,106,106,106,
  108,108,108,108,108,109,109,109,109,110,110,110,5,5,5,5,5,6,6,6,6,6,7,7,7,7,
  123,123,124,124,124,124,125,125,125,125,127,127,127,8,8,8,109,109,109,110,
  110,110,5,5,5,5,126,126,126,6,127,127,125,125,126,126,126,127,127,127,5,5,5,
  6,6,6,127,7,123,124,124,125,126,126,126,127,104,106,123,124,124,125,126,2,2,
  2,2,2,2,2,2,2,127,127,127,127,127,127,8,8,106,106,108,108,109,207,207,207,
  207,207,241,241,243,243,244,244,104,106,106,123,124,124,125,125,126,126,126,
  126,126,126,126,126,104,106,121,122,123,123,124,124,126,126,127,127,127,127,
  7,8,244,244,246,246,246,246,0,0,124,123,106,109,110,5,6,110,0,8,0,6,106,8,8,
  0,0,7,8,8,0,127,7,7,108,124,109,109,125,125,125,126,126,126,126,126,126,126,
  126,126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,8,106,108,108,
  108,108,124,124,124,124,125,125,125,125,125,125,126,126,126,126,126,126,126,
  126,126,127,127,127,127,7,7,8,8,106,106,108,108,108,108,108,109,109,109,109,
  109,110,110,110,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,8,124,124,124,124,125,125,
  125,125,127,127,127,127,7,8,8,0,110,110,110,110,5,5,5,5,126,126,126,6,6,127,
  127,127,5,126,126,126,127,127,127,7,5,6,6,6,6,7,7,7,123,124,124,125,126,126,
  127,127,106,108,108,124,125,125,126,2,2,2,2,2,2,2,127,127,127,127,127,127,
  127,8,8,8,106,108,108,109,110,207,207,207,207,241,241,243,243,243,244,244,
  106,106,108,124,124,125,125,126,126,126,126,126,126,126,126,126,106,106,122,
  123,124,124,124,124,126,127,127,127,127,7,8,8,244,246,246,246,246,0,0,0,125,
  124,108,109,5,5,6,5,0,8,0,7,108,8,8,0,0,8,8,8,0,7,7,8,109,110,110,110,110,
  125,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  127,8,8,8,8,8,8,8,108,108,109,109,109,109,125,125,125,125,125,125,125,126,
  126,126,126,126,126,126,126,127,127,127,127,127,127,7,7,8,8,8,108,108,109,
  109,109,109,109,110,110,110,110,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,8,8,
  124,124,125,125,125,125,125,127,127,127,127,127,8,8,8,0,110,5,5,5,5,5,126,
  126,6,6,6,127,127,127,7,7,126,126,126,127,127,127,7,7,6,6,6,6,7,7,7,7,124,
  125,125,126,126,127,127,127,108,108,109,125,126,126,126,2,2,2,2,127,127,127,
  127,127,127,127,127,127,8,8,8,8,108,109,109,110,5,241,241,241,241,241,243,
  243,243,244,244,246,108,108,109,124,125,125,126,126,126,126,126,126,126,126,
  127,127,108,108,123,123,124,124,124,124,127,127,127,127,7,7,8,8,246,246,246,
  246,246,0,0,0,126,124,109,110,5,6,7,126,0,8,0,7,109,8,0,0,0,8,8,0,0,7,8,8,
  110,5,5,5,5,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  127,127,8,8,8,8,8,8,8,8,0,109,110,110,110,110,110,125,125,125,125,126,126,
  126,126,126,126,126,126,127,127,127,127,127,127,127,127,7,7,8,8,8,8,109,110,
  110,110,110,110,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,125,125,
  125,125,125,127,127,127,127,127,7,8,8,8,0,0,5,5,5,6,6,6,6,6,6,127,127,127,7,
  7,7,7,6,6,127,127,7,7,8,8,6,6,6,7,7,7,7,8,124,125,126,126,127,127,127,127,
  109,110,110,5,126,126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,
  8,8,0,109,110,110,5,5,243,243,243,243,243,243,244,244,244,244,246,109,109,
  110,125,125,126,126,126,126,126,126,127,127,127,127,127,109,109,110,124,124,
  124,124,124,127,127,127,127,7,8,8,8,246,246,246,246,0,0,0,0,126,125,110,5,6,
  6,7,6,0,0,0,7,110,0,0,0,0,8,8,0,0,8,8,8,5,5,126,126,126,126,127,127,127,127,
  127,127,127,127,127,127,127,127,7,8,8,8,8,8,8,8,8,8,8,0,0,0,5,5,5,5,5,5,126,
  126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,7,7,7,8,8,8,
  8,8,8,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,125,
  125,127,127,127,127,127,127,7,8,8,8,8,8,0,0,6,6,6,6,6,6,127,7,7,7,7,7,7,7,8,
  8,127,127,7,7,7,8,8,8,7,7,7,7,7,8,8,8,126,126,126,127,127,127,127,8,110,5,5,
  126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,8,8,8,0,0,5,5,5,6,
  6,243,243,243,243,244,244,244,244,246,246,246,110,5,5,126,126,126,126,127,
  127,127,127,127,127,127,127,127,110,5,5,126,126,126,126,126,127,127,127,8,8,
  8,8,0,246,246,246,246,0,0,0,0,126,126,5,6,6,7,7,127,0,0,0,8,5,0,0,0,0,8,0,0,
  0,8,8,8,6,6,6,127,127,127,127,127,127,127,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,
  8,0,0,0,0,6,6,6,6,6,6,6,6,127,127,127,127,127,127,127,127,127,127,7,7,7,7,8,
  8,8,8,8,8,8,8,8,0,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,
  8,8,0,127,127,127,127,127,7,7,8,8,8,8,8,8,0,0,0,6,6,7,7,7,7,7,7,7,7,7,8,8,8,
  8,8,7,7,7,8,8,8,8,8,7,7,7,8,8,8,8,8,126,127,127,127,127,8,8,8,5,6,6,6,127,
  127,127,127,127,127,127,8,8,8,8,8,8,8,8,8,0,0,0,0,6,6,6,6,6,244,244,244,244,
  244,244,244,246,246,246,246,5,6,6,6,127,127,127,127,127,127,127,127,127,127,
  127,8,5,6,6,126,126,126,126,12,8,8,8,8,8,8,0,0,246,246,246,0,0,0,0,0,127,127,
  6,6,7,7,8,7,0,0,0,8,6,0,0,0,0,0,0,0,0,8,0,0,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,
  8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,6,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,0,0,0,0,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,
  0,0,0,0,7,7,8,8,8,8,8,8,8,8,8,0,0,0,0,0,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,0,8,8,8,8,8,8,8,0,127,7,7,8,8,8,8,0,6,7,7,7,7,7,8,8,8,8,8,8,8,8,8,
  0,0,0,0,0,0,0,0,0,7,7,7,7,7,246,246,246,246,246,246,246,246,246,246,0,6,6,7,
  7,7,7,7,8,8,8,8,8,8,8,8,8,6,6,7,127,127,127,12,12,8,8,8,0,8,0,0,0,0,0,0,0,0,
  0,0,0,7,127,7,7,8,8,8,8,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,
  8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,
  0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,
  0,0,0,0,8,8,0,0,0,0,0,0,8,0,0,0,0,0,0,0,8,8,8,8,0,0,0,0,8,8,8,8,8,8,8,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,246,246,246,246,246,246,246,0,0,0,0,8,
  8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,8,8,8,8,8,0,0,8,193,193,193,194,0,193,193,193,193,194,194,193,193,194,194,
  194,108,106,104,103,102,100,98,97,95,94,93,195,195,195,194,194,194,194,194,
  194,194,194,194,194,194,194,194,194,194,193,193,193,7,6,6,5,110,109,108,108,
  106,104,104,102,101,98,97,97,95,94,93,93,195,195,194,194,194,194,194,194,194,
  194,194,194,7,6,5,5,109,108,108,106,104,104,102,101,100,98,97,96,95,94,93,
  195,195,195,194,194,194,194,194,194,194,194,194,194,106,104,102,100,97,95,93,
  195,195,194,194,194,194,194,193,193,102,101,98,97,96,95,94,93,195,195,195,
  194,194,194,194,194,95,93,195,195,194,194,194,194,93,195,195,194,194,194,194,
  194,7,108,104,98,94,195,194,194,0,6,109,104,100,96,93,194,194,194,194,194,
  194,194,194,194,194,194,194,194,194,193,193,193,7,109,104,100,95,195,194,194,
  194,194,194,193,193,193,193,193,0,7,5,109,106,104,101,98,96,95,94,93,195,195,
  194,194,0,0,8,7,7,6,5,5,194,194,194,194,194,194,194,194,193,193,193,193,193,
  193,193,193,103,110,104,195,194,194,194,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,
};

//jff 2/18/98 palette color ranges for translation

static const char cr_brick[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,46,46,46,46,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,46,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
//   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const char cr_tan[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,78,45,78,78,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,78,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_gray[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,110,110,46,110,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,110,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_green[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,127,127,46,127,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,127,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_brown[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,143,143,46,143,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,143,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_gold[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,167,167,46,167,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,167,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     160,160,161,161,162,162,163,163,164,164,165,165,166,166,167,167,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_red[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,191,191,46,191,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,191,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const char cr_blue[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,203,203,46,203,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,203,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     196,196,197,197,198,198,199,199,200,200,201,201,202,202,203,203,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

// killough 2/28/98: The blue translation table above looks bad on the
// status bar but a little better on the HUD. So I've created a separate
// translation table for the status bar, which is the same as last week's.

static const char cr_blue2[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,207,207,46,207,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,207,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     200,200,201,201,202,202,203,203,204,204,205,205,206,206,207,207,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

    
static const char cr_orange[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,223,223,46,223,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,223,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_yellow[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,231,231,46,231,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,231,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     224,224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const char mbftext[] = { // 2022/06/26 REKKR font lump, centred
  242,0,14,0,0,0,0,0,208,3,0,0,209,3,0,0,210,3,0,0,211,3,0,0,212,3,0,0,213,3,0,
  0,214,3,0,0,215,3,0,0,216,3,0,0,217,3,0,0,218,3,0,0,219,3,0,0,220,3,0,0,221,
  3,0,0,222,3,0,0,223,3,0,0,224,3,0,0,225,3,0,0,226,3,0,0,242,3,0,0,4,4,0,0,23,
  4,0,0,42,4,0,0,61,4,0,0,75,4,0,0,89,4,0,0,103,4,0,0,122,4,0,0,141,4,0,0,160,
  4,0,0,178,4,0,0,194,4,0,0,195,4,0,0,208,4,0,0,223,4,0,0,239,4,0,0,0,5,0,0,20,
  5,0,0,38,5,0,0,61,5,0,0,80,5,0,0,99,5,0,0,118,5,0,0,135,5,0,0,136,5,0,0,153,
  5,0,0,172,5,0,0,191,5,0,0,210,5,0,0,233,5,0,0,250,5,0,0,14,6,0,0,33,6,0,0,51,
  6,0,0,68,6,0,0,79,6,0,0,80,6,0,0,93,6,0,0,112,6,0,0,131,6,0,0,150,6,0,0,169,
  6,0,0,183,6,0,0,189,6,0,0,190,6,0,0,207,6,0,0,226,6,0,0,245,6,0,0,7,7,0,0,25,
  7,0,0,46,7,0,0,64,7,0,0,82,7,0,0,101,7,0,0,120,7,0,0,137,7,0,0,138,7,0,0,153,
  7,0,0,170,7,0,0,189,7,0,0,208,7,0,0,233,7,0,0,2,8,0,0,25,8,0,0,42,8,0,0,61,8,
  0,0,82,8,0,0,99,8,0,0,100,8,0,0,108,8,0,0,118,8,0,0,129,8,0,0,140,8,0,0,150,
  8,0,0,158,8,0,0,159,8,0,0,176,8,0,0,197,8,0,0,219,8,0,0,241,8,0,0,7,9,0,0,32,
  9,0,0,54,9,0,0,76,9,0,0,98,9,0,0,119,9,0,0,136,9,0,0,137,9,0,0,138,9,0,0,139,
  9,0,0,156,9,0,0,175,9,0,0,194,9,0,0,213,9,0,0,238,9,0,0,7,10,0,0,32,10,0,0,
  51,10,0,0,70,10,0,0,87,10,0,0,104,10,0,0,105,10,0,0,120,10,0,0,137,10,0,0,
  156,10,0,0,175,10,0,0,200,10,0,0,225,10,0,0,248,10,0,0,9,11,0,0,28,11,0,0,49,
  11,0,0,66,11,0,0,67,11,0,0,84,11,0,0,105,11,0,0,127,11,0,0,149,11,0,0,171,11,
  0,0,196,11,0,0,218,11,0,0,240,11,0,0,6,12,0,0,27,12,0,0,44,12,0,0,45,12,0,0,
  54,12,0,0,65,12,0,0,81,12,0,0,100,12,0,0,119,12,0,0,138,12,0,0,157,12,0,0,
  176,12,0,0,193,12,0,0,209,12,0,0,218,12,0,0,219,12,0,0,220,12,0,0,221,12,0,0,
  237,12,0,0,255,12,0,0,18,13,0,0,37,13,0,0,61,13,0,0,83,13,0,0,98,13,0,0,107,
  13,0,0,116,13,0,0,123,13,0,0,124,13,0,0,141,13,0,0,160,13,0,0,179,13,0,0,198,
  13,0,0,221,13,0,0,238,13,0,0,2,14,0,0,21,14,0,0,39,14,0,0,56,14,0,0,67,14,0,
  0,68,14,0,0,81,14,0,0,100,14,0,0,119,14,0,0,138,14,0,0,157,14,0,0,171,14,0,0,
  177,14,0,0,178,14,0,0,193,14,0,0,210,14,0,0,229,14,0,0,248,14,0,0,17,15,0,0,
  42,15,0,0,65,15,0,0,82,15,0,0,101,15,0,0,122,15,0,0,139,15,0,0,140,15,0,0,
  157,15,0,0,176,15,0,0,195,15,0,0,213,15,0,0,231,15,0,0,252,15,0,0,14,16,0,0,
  32,16,0,0,51,16,0,0,70,16,0,0,87,16,0,0,88,16,0,0,105,16,0,0,124,16,0,0,143,
  16,0,0,162,16,0,0,179,16,0,0,196,16,0,0,215,16,0,0,234,16,0,0,251,16,0,0,10,
  17,0,0,23,17,0,0,24,17,0,0,25,17,0,0,26,17,0,0,27,17,0,0,28,17,0,0,29,17,0,0,
  30,17,0,0,31,17,0,0,32,17,0,0,33,17,0,0,34,17,0,0,35,17,0,0,36,17,0,0,37,17,
  0,0,38,17,0,0,39,17,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,2,11,106,106,106,106,106,106,106,106,106,106,106,106,106,
  255,1,13,106,106,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,
  85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,87,106,
  106,106,106,106,106,106,97,97,106,106,255,0,8,106,106,85,87,87,106,106,106,
  106,106,11,2,106,106,106,106,255,0,9,106,106,85,87,87,87,87,92,92,106,106,
  255,1,9,106,106,87,87,87,87,92,92,92,106,106,255,0,9,106,106,85,87,87,87,87,
  92,92,106,106,255,0,8,106,106,85,87,87,106,106,106,106,106,11,2,106,106,106,
  106,255,0,14,106,106,85,87,87,106,106,106,106,106,106,106,97,97,106,106,255,
  0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,1,13,106,106,87,
  87,87,87,92,92,92,92,97,97,97,106,106,255,2,11,106,106,106,106,106,106,106,
  106,106,106,106,106,106,255,255,5,8,106,106,106,106,106,106,106,106,106,106,
  255,4,10,106,106,87,92,92,92,92,97,97,97,106,106,255,3,11,106,106,87,87,92,
  92,92,92,97,97,97,106,106,255,2,12,106,106,87,87,87,106,92,92,106,106,97,97,
  106,106,255,1,9,106,106,87,87,87,106,106,92,92,106,106,11,2,106,106,106,106,
  255,0,5,106,106,85,87,87,106,106,6,4,106,106,92,92,106,106,255,0,4,106,106,
  85,87,106,106,6,4,106,106,92,92,106,106,11,2,106,106,106,106,255,0,14,106,
  106,85,87,106,106,106,106,92,92,106,106,97,97,106,106,255,0,14,106,106,85,87,
  87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,92,
  92,92,97,97,97,106,106,255,1,12,106,106,106,106,106,106,106,106,106,106,106,
  106,106,106,255,255,1,12,106,106,106,106,106,106,106,106,106,106,106,106,106,
  106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,
  106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,
  106,106,106,106,106,106,106,106,97,97,106,106,255,0,4,106,106,85,87,106,106,
  5,4,106,106,92,92,106,106,11,2,106,106,106,106,255,0,4,106,106,85,87,106,106,
  5,4,106,106,92,92,106,106,255,0,9,106,106,85,87,87,106,106,92,92,106,106,11,
  2,106,106,106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,106,106,97,97,106,
  106,255,1,13,106,106,87,87,87,87,92,92,92,92,97,97,97,106,106,255,2,12,106,
  106,106,106,106,106,92,92,92,97,97,97,106,106,255,7,6,106,106,106,106,106,
  106,106,106,255,255,1,2,106,106,106,106,11,2,106,106,106,106,255,0,14,106,
  106,85,87,106,106,106,106,106,106,106,106,97,97,106,106,255,0,14,106,106,85,
  87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,
  92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,106,106,106,106,106,106,106,
  106,97,97,106,106,255,1,2,106,106,106,106,11,3,106,106,97,106,106,255,12,1,
  106,106,106,255,255,1,12,106,106,106,106,106,106,106,106,106,106,106,106,106,
  106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,
  106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,1,13,106,106,106,87,
  87,87,92,106,106,106,106,97,97,106,106,255,3,6,106,106,87,87,92,92,106,106,
  11,3,106,106,97,106,106,255,1,1,106,106,106,4,6,106,106,87,92,92,92,106,106,
  12,1,106,106,106,255,0,3,106,106,85,106,106,5,6,106,106,92,92,92,92,106,106,
  255,0,13,106,106,85,87,106,106,106,106,92,92,92,97,106,106,106,255,0,14,106,
  106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,87,87,
  87,92,92,92,92,97,97,97,106,106,255,1,12,106,106,106,106,106,106,106,106,106,
  106,106,106,106,106,255,255,2,10,106,106,106,106,106,106,106,106,106,106,106,
  106,255,1,12,106,106,87,87,87,87,92,92,92,92,97,97,106,106,255,0,14,106,106,
  85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,87,106,87,
  92,92,92,106,97,97,97,106,106,255,0,4,106,106,85,87,106,106,5,4,106,106,92,
  92,106,106,10,4,106,106,97,97,106,106,255,0,4,106,106,85,87,106,106,5,4,106,
  106,92,92,106,106,10,4,106,106,97,97,106,106,255,0,4,106,106,85,87,106,106,6,
  2,106,106,106,106,10,4,106,106,97,97,106,106,255,0,4,106,106,85,87,106,106,
  10,4,106,106,97,97,106,106,255,0,5,106,106,85,87,87,106,106,9,5,106,106,97,
  97,97,106,106,255,0,6,106,106,85,87,87,87,106,106,8,6,106,106,92,97,97,97,
  106,106,255,1,4,106,106,106,106,106,106,9,4,106,106,106,106,106,106,255,255,
  1,3,106,106,106,106,106,255,0,5,106,106,87,87,87,106,106,255,0,6,106,106,87,
  87,87,87,106,106,255,1,6,106,106,87,87,87,87,106,106,255,2,5,106,106,87,87,
  87,106,106,255,3,3,106,106,106,106,106,255,255,2,4,106,106,106,106,106,106,9,
  4,106,106,106,106,106,106,255,1,6,106,106,87,87,87,87,106,106,8,6,106,106,92,
  97,97,97,106,106,255,0,8,106,106,85,87,87,87,87,92,106,106,9,5,106,106,97,97,
  97,106,106,255,0,9,106,106,85,87,106,87,87,92,92,106,106,10,4,106,106,97,97,
  106,106,255,0,9,106,106,85,87,106,106,87,92,92,106,106,10,4,106,106,97,97,
  106,106,255,0,4,106,106,85,87,106,106,5,4,106,106,92,92,106,106,10,4,106,106,
  97,97,106,106,255,0,4,106,106,85,87,106,106,5,9,106,106,92,92,92,106,106,97,
  97,106,106,255,0,4,106,106,85,87,106,106,5,9,106,106,92,92,92,92,106,97,97,
  106,106,255,0,5,106,106,85,87,87,106,106,6,8,106,106,92,92,92,97,97,97,106,
  106,255,0,6,106,106,85,87,87,87,106,106,7,6,106,106,92,92,97,97,106,106,255,
  1,4,106,106,106,106,106,106,8,4,106,106,106,106,106,106,255,255,255,255,1,12,
  106,106,106,106,106,106,106,106,106,106,106,106,106,106,255,0,14,106,106,85,
  87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,
  92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,106,106,106,106,106,106,106,
  106,97,97,106,106,255,0,4,106,106,85,87,106,106,5,4,106,106,92,92,106,106,10,
  4,106,106,97,97,106,106,255,0,4,106,106,85,87,106,106,5,4,106,106,92,92,106,
  106,10,4,106,106,97,97,106,106,255,0,4,106,106,85,87,106,106,5,4,106,106,92,
  92,106,106,10,4,106,106,97,97,106,106,255,0,14,106,106,85,87,106,106,87,92,
  92,92,106,106,97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,
  97,97,106,106,255,1,12,106,106,87,87,87,87,106,106,92,92,97,97,106,106,255,2,
  4,106,106,106,106,106,106,8,4,106,106,106,106,106,106,255,255,2,10,106,106,
  106,106,106,106,106,106,106,106,106,106,255,1,12,106,106,87,87,87,87,92,92,
  92,92,97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,
  106,255,0,14,106,106,85,87,87,106,87,92,92,92,106,97,97,97,106,106,255,0,4,
  106,106,85,87,106,106,5,4,106,106,92,92,106,106,10,4,106,106,97,97,106,106,
  255,0,4,106,106,85,87,106,106,5,4,106,106,92,92,106,106,10,4,106,106,97,97,
  106,106,255,0,4,106,106,85,87,106,106,6,2,106,106,106,106,10,4,106,106,97,97,
  106,106,255,0,4,106,106,85,87,106,106,10,4,106,106,97,97,106,106,255,0,5,106,
  106,85,87,87,106,106,9,5,106,106,97,97,97,106,106,255,0,6,106,106,85,87,87,
  87,106,106,8,6,106,106,92,97,97,97,106,106,255,1,4,106,106,106,106,106,106,9,
  4,106,106,106,106,106,106,255,255,2,4,106,106,106,106,106,106,9,4,106,106,
  106,106,106,106,255,1,6,106,106,87,87,87,87,106,106,8,6,106,106,92,97,97,97,
  106,106,255,0,8,106,106,85,87,87,87,87,92,106,106,9,5,106,106,97,97,97,106,
  106,255,0,9,106,106,85,87,106,87,87,92,92,106,106,10,4,106,106,97,97,106,106,
  255,0,9,106,106,85,87,106,106,87,92,92,106,106,10,4,106,106,97,97,106,106,
  255,0,4,106,106,85,87,106,106,5,4,106,106,92,92,106,106,10,4,106,106,97,97,
  106,106,255,0,4,106,106,85,87,106,106,5,9,106,106,92,92,92,106,106,97,97,106,
  106,255,0,4,106,106,85,87,106,106,5,9,106,106,92,92,92,92,106,97,97,106,106,
  255,0,5,106,106,85,87,87,106,106,6,8,106,106,92,92,92,97,97,97,106,106,255,0,
  6,106,106,85,87,87,87,106,106,7,6,106,106,92,92,97,97,106,106,255,1,4,106,
  106,106,106,106,106,8,4,106,106,106,106,106,106,255,255,1,4,106,106,106,106,
  106,106,255,0,6,106,106,85,87,87,87,106,106,255,0,5,106,106,85,87,87,106,106,
  11,2,106,106,106,106,255,0,14,106,106,85,87,106,106,106,106,106,106,106,106,
  97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,
  255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,
  106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,106,
  106,106,106,106,106,106,106,97,97,106,106,255,0,5,106,106,85,87,87,106,106,
  11,3,106,106,97,106,106,255,0,6,106,106,85,87,87,87,106,106,12,1,106,106,106,
  255,1,4,106,106,106,106,106,106,255,255,255,255,2,11,106,106,106,106,106,106,
  106,106,106,106,106,106,106,255,1,13,106,106,87,87,87,87,92,92,92,92,97,97,
  97,106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,
  0,14,106,106,85,87,87,106,87,92,92,92,106,106,97,97,106,106,255,0,4,106,106,
  85,87,106,106,5,4,106,106,92,92,106,106,11,3,106,106,97,106,106,255,0,4,106,
  106,85,87,106,106,5,4,106,106,92,92,106,106,12,1,106,106,106,255,0,4,106,106,
  85,87,106,106,6,2,106,106,106,106,255,0,4,106,106,85,87,106,106,255,0,4,106,
  106,85,87,106,106,255,1,2,106,106,106,106,255,255,1,12,106,106,106,106,106,
  106,106,106,106,106,106,106,106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,
  92,97,97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,
  106,255,0,14,106,106,85,87,106,106,106,106,106,106,106,106,97,97,106,106,255,
  0,4,106,106,85,87,106,106,5,4,106,106,92,92,106,106,11,2,106,106,106,106,255,
  0,4,106,106,85,87,106,106,5,4,106,106,92,92,106,106,255,0,9,106,106,85,87,87,
  106,106,92,92,106,106,11,2,106,106,106,106,255,0,14,106,106,85,87,87,87,87,
  92,92,92,106,106,97,97,106,106,255,1,13,106,106,87,87,87,87,92,92,92,92,97,
  97,97,106,106,255,2,12,106,106,106,106,106,106,92,92,92,97,97,97,106,106,255,
  7,6,106,106,106,106,106,106,106,106,255,255,1,2,106,106,106,106,11,2,106,106,
  106,106,255,0,14,106,106,85,87,106,106,106,106,106,106,106,106,97,97,106,106,
  255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,
  106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,106,
  106,106,106,106,106,106,106,97,97,106,106,255,1,2,106,106,106,106,11,3,106,
  106,97,106,106,255,12,1,106,106,106,255,255,2,10,106,106,106,106,106,106,106,
  106,106,106,106,106,255,1,12,106,106,87,87,87,87,92,92,92,92,97,97,106,106,
  255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,
  106,85,87,87,106,87,92,92,92,106,97,97,97,106,106,255,0,4,106,106,85,87,106,
  106,5,4,106,106,92,92,106,106,10,4,106,106,97,97,106,106,255,0,4,106,106,85,
  87,106,106,5,4,106,106,92,92,106,106,10,4,106,106,97,97,106,106,255,0,4,106,
  106,85,87,106,106,6,2,106,106,106,106,10,4,106,106,97,97,106,106,255,0,4,106,
  106,85,87,106,106,10,4,106,106,97,97,106,106,255,0,5,106,106,85,87,87,106,
  106,9,5,106,106,97,97,97,106,106,255,0,6,106,106,85,87,87,87,106,106,8,6,106,
  106,92,97,97,97,106,106,255,1,4,106,106,106,106,106,106,9,4,106,106,106,106,
  106,106,255,255,1,12,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
  255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,
  106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,1,13,106,106,106,87,87,
  87,92,106,106,106,106,97,97,106,106,255,3,6,106,106,87,87,92,92,106,106,11,3,
  106,106,97,106,106,255,1,1,106,106,106,4,6,106,106,87,92,92,92,106,106,12,1,
  106,106,106,255,0,3,106,106,85,106,106,5,6,106,106,92,92,92,92,106,106,255,0,
  13,106,106,85,87,106,106,106,106,92,92,92,97,106,106,106,255,0,14,106,106,85,
  87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,87,87,87,87,92,
  92,92,92,97,97,97,106,106,255,1,12,106,106,106,106,106,106,106,106,106,106,
  106,106,106,106,255,255,1,12,106,106,106,106,106,106,106,106,106,106,106,106,
  106,106,255,0,14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,
  14,106,106,85,87,87,87,87,92,92,92,92,97,97,97,106,106,255,0,14,106,106,85,
  87,106,106,106,106,106,106,106,106,97,97,106,106,255,0,4,106,106,85,87,106,
  106,10,4,106,106,97,97,106,106,255,0,4,106,106,85,87,106,106,10,4,106,106,97,
  97,106,106,255,0,5,106,106,85,87,87,106,106,9,5,106,106,97,97,97,106,106,255,
  0,14,106,106,85,87,87,87,106,106,106,106,92,97,97,97,106,106,255,1,12,106,
  106,87,87,87,87,92,92,92,92,97,97,106,106,255,2,10,106,106,87,87,87,92,92,92,
  92,97,106,106,255,3,8,106,106,106,106,106,106,106,106,106,106,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};

#ifdef DOGS
static const char dogsd5[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,34,1,0,0,35,1,0,0,44,1,0,0,70,1,0,0,102,1,0,0,135,1,0,
  0,167,1,0,0,199,1,0,0,226,1,0,0,249,1,0,0,21,2,0,0,53,2,0,0,86,2,0,0,120,2,0,
  0,145,2,0,0,155,2,0,0,156,2,0,0,157,2,0,0,158,2,0,0,159,2,0,0,160,2,0,0,161,
  2,0,0,162,2,0,0,163,2,0,0,164,2,0,0,165,2,0,0,166,2,0,0,167,2,0,0,168,2,0,0,
  169,2,0,0,170,2,0,0,171,2,0,0,172,2,0,0,173,2,0,0,174,2,0,0,175,2,0,0,176,2,
  0,0,177,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,49,4,66,66,66,66,67,67,255,
  33,3,66,66,66,66,66,44,14,3,3,3,3,66,66,69,69,69,69,67,67,67,70,70,70,255,33,
  27,103,103,66,66,66,103,66,66,68,0,77,77,107,107,66,66,66,69,69,69,69,69,67,
  67,66,70,70,70,70,255,34,28,103,103,66,66,103,66,66,0,0,77,76,73,71,71,66,66,
  66,66,66,69,69,69,69,69,69,72,72,72,72,72,255,35,27,103,103,109,66,66,68,0,0,
  77,77,73,69,69,66,70,70,3,3,107,109,109,109,103,75,75,75,75,75,75,255,35,27,
  109,109,109,103,68,68,68,0,77,76,76,70,69,69,70,70,3,106,109,109,108,109,109,
  109,109,109,75,75,75,255,36,22,109,109,103,68,68,68,3,107,109,109,73,69,69,
  103,106,106,107,108,109,108,107,107,107,107,255,36,18,109,109,103,68,68,68,3,
  107,109,109,74,71,71,103,106,107,109,109,109,109,255,35,23,109,109,109,103,
  68,68,68,3,107,109,109,71,74,71,103,106,107,107,108,109,108,107,107,107,107,
  255,35,27,70,70,66,103,68,68,68,103,107,109,109,71,71,71,103,103,3,107,107,
  109,109,73,71,71,71,75,75,75,75,255,34,28,66,66,66,66,66,103,70,70,103,107,
  109,109,109,73,70,69,69,103,70,70,70,66,66,71,75,75,75,75,75,75,255,33,29,66,
  66,66,100,103,103,73,73,73,73,109,109,109,109,109,73,69,69,69,70,70,70,70,70,
  71,75,75,75,77,77,77,255,33,3,66,66,100,103,103,44,13,109,109,109,109,73,71,
  71,71,71,71,71,73,73,73,73,255,49,5,73,73,73,73,73,73,73,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsc5[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,34,1,0,0,42,1,0,0,60,1,0,0,85,1,0,0,116,1,0,0,146,1,0,
  0,175,1,0,0,204,1,0,0,226,1,0,0,248,1,0,0,21,2,0,0,50,2,0,0,80,2,0,0,112,2,0,
  0,137,2,0,0,152,2,0,0,160,2,0,0,161,2,0,0,162,2,0,0,163,2,0,0,164,2,0,0,165,
  2,0,0,166,2,0,0,167,2,0,0,168,2,0,0,169,2,0,0,170,2,0,0,171,2,0,0,172,2,0,0,
  173,2,0,0,174,2,0,0,175,2,0,0,176,2,0,0,177,2,0,0,178,2,0,0,179,2,0,0,180,2,
  0,0,181,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,54,3,66,66,103,66,66,255,47,4,70,
  70,69,69,70,70,52,5,66,66,66,103,71,103,103,255,34,3,66,66,66,66,66,44,13,
  107,107,107,74,69,69,65,65,66,66,66,71,103,71,71,255,34,20,103,103,66,66,66,
  103,66,66,66,66,107,107,74,70,69,65,65,66,69,69,72,72,58,2,73,73,73,73,255,
  35,25,103,103,66,66,79,77,73,71,3,107,74,68,66,70,65,66,69,72,72,74,74,73,73,
  73,74,77,77,255,36,24,103,103,109,79,79,79,77,77,107,70,66,66,70,70,66,66,
  107,109,107,107,107,107,107,107,77,77,255,36,18,109,109,109,79,79,77,73,67,
  67,67,67,67,70,70,3,107,109,109,111,111,58,2,77,77,75,75,255,37,17,109,109,
  103,79,77,77,71,71,70,69,69,103,107,107,107,107,109,111,111,255,37,17,109,
  109,103,68,71,76,76,74,73,71,71,103,107,107,109,109,109,111,111,255,36,18,
  109,109,109,103,68,68,68,107,76,74,74,71,103,103,107,107,107,109,111,111,58,
  2,77,77,75,75,255,36,24,70,70,66,103,68,68,68,107,107,76,74,71,103,71,69,71,
  75,109,111,109,109,109,109,111,77,77,255,35,25,66,66,66,66,66,103,70,70,103,
  107,74,71,71,71,70,69,66,66,69,0,77,77,77,77,77,77,77,255,34,21,66,66,66,100,
  103,103,73,73,73,73,109,107,73,72,71,71,69,66,66,66,69,69,69,58,2,77,77,75,
  75,255,34,3,66,66,100,103,103,44,13,109,109,109,72,72,72,72,103,69,66,66,66,
  103,71,71,255,47,10,73,73,73,73,73,71,71,69,103,71,103,103,255,54,3,71,71,
  103,71,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,
};
static const char dogsb1[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,34,1,0,0,45,1,0,0,80,1,0,0,114,1,0,0,147,1,0,0,178,1,0,
  0,204,1,0,0,229,1,0,0,254,1,0,0,24,2,0,0,54,2,0,0,87,2,0,0,121,2,0,0,156,2,0,
  0,168,2,0,0,169,2,0,0,170,2,0,0,171,2,0,0,172,2,0,0,173,2,0,0,174,2,0,0,175,
  2,0,0,176,2,0,0,177,2,0,0,178,2,0,0,179,2,0,0,180,2,0,0,181,2,0,0,182,2,0,0,
  183,2,0,0,184,2,0,0,185,2,0,0,186,2,0,0,187,2,0,0,188,2,0,0,189,2,0,0,190,2,
  0,0,191,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,45,6,71,71,71,71,71,71,71,71,255,
  31,2,66,66,103,103,37,3,71,71,71,71,71,43,17,71,71,71,69,68,67,67,65,65,65,
  65,65,65,65,66,70,69,71,71,255,31,29,71,71,66,103,103,107,68,68,68,71,71,71,
  71,69,68,67,66,66,66,66,66,65,64,64,64,65,66,74,69,71,71,255,32,28,71,71,107,
  107,103,3,68,65,103,103,66,66,66,66,66,66,66,103,71,71,71,68,68,68,66,68,74,
  74,74,74,255,33,26,71,71,109,3,111,3,107,107,107,66,66,69,69,66,100,66,100,
  103,71,103,71,71,3,70,70,77,77,77,255,33,21,71,71,109,109,109,3,107,94,103,
  103,103,103,103,100,103,100,68,100,103,107,75,3,3,255,34,20,109,109,109,0,0,
  107,103,107,3,3,103,103,103,100,68,100,100,3,106,107,75,75,255,34,20,109,109,
  109,0,0,107,103,107,3,3,103,103,103,68,103,100,103,3,106,107,109,109,255,33,
  21,71,71,109,109,109,3,107,97,103,3,3,103,103,103,100,68,100,103,3,106,107,
  77,77,255,33,25,71,71,109,3,111,109,109,109,107,3,3,103,103,100,103,100,100,
  103,70,107,72,72,77,66,69,74,74,255,32,28,66,66,107,107,103,3,68,69,103,103,
  69,69,69,69,69,100,68,103,100,68,66,66,65,65,65,65,74,71,74,74,255,31,29,66,
  66,71,103,103,107,103,73,73,73,73,71,71,71,69,103,103,68,66,66,66,65,64,64,
  65,64,65,74,71,74,74,255,31,2,66,66,103,103,37,3,75,75,75,75,75,43,17,73,73,
  71,69,69,69,69,68,68,68,68,66,66,66,67,74,72,73,73,255,45,7,71,71,71,71,71,
  73,74,75,75,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,
};
static const char dogsa5[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,34,1,0,0,35,1,0,0,53,1,0,0,84,1,0,0,118,1,0,0,151,1,0,
  0,177,1,0,0,202,1,0,0,226,1,0,0,250,1,0,0,19,2,0,0,44,2,0,0,73,2,0,0,107,2,0,
  0,138,2,0,0,157,2,0,0,175,2,0,0,176,2,0,0,177,2,0,0,178,2,0,0,179,2,0,0,180,
  2,0,0,181,2,0,0,182,2,0,0,183,2,0,0,184,2,0,0,185,2,0,0,186,2,0,0,187,2,0,0,
  188,2,0,0,189,2,0,0,190,2,0,0,191,2,0,0,192,2,0,0,193,2,0,0,194,2,0,0,195,2,
  0,0,196,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,50,7,66,66,66,66,66,66,66,66,
  66,60,2,66,66,66,66,255,33,4,66,66,66,66,66,66,44,18,3,3,3,3,103,66,66,66,66,
  66,66,66,66,66,66,66,66,69,69,69,255,33,29,103,103,66,66,66,66,103,66,66,66,
  66,0,79,0,3,66,66,66,66,66,66,66,66,66,70,70,72,3,73,76,76,255,34,28,103,103,
  103,66,66,103,66,66,66,103,0,79,77,0,103,66,66,66,70,72,72,72,72,107,107,107,
  76,76,76,76,255,36,21,103,103,109,66,66,68,103,3,0,77,77,0,103,103,66,70,70,
  3,3,107,108,109,109,255,36,20,109,109,109,103,68,68,103,106,0,77,76,73,67,67,
  67,70,70,3,106,108,108,108,255,37,19,109,109,103,68,68,103,106,107,0,74,75,
  73,69,69,103,106,106,106,108,108,108,255,37,19,109,109,103,68,68,103,106,107,
  0,74,74,73,71,71,103,106,107,109,109,109,109,255,36,20,109,109,109,103,68,68,
  103,3,107,108,0,74,74,74,71,103,103,106,107,107,108,108,255,36,20,70,70,66,
  103,68,68,68,103,108,108,108,3,74,74,71,103,103,3,106,107,108,108,255,34,24,
  66,66,66,66,66,66,103,70,70,103,108,108,108,106,66,71,71,103,70,70,100,100,
  100,100,103,103,255,33,29,66,66,66,66,103,103,103,73,73,73,73,108,109,109,
  107,66,69,71,71,70,70,68,68,68,71,103,103,107,107,76,76,255,33,4,66,66,103,
  103,103,103,44,18,109,109,109,109,71,71,71,71,70,70,69,69,69,73,73,73,74,74,
  76,76,255,48,14,73,73,73,73,73,73,73,73,73,74,74,74,75,75,76,76,255,50,7,74,
  74,74,74,75,76,76,76,76,60,2,76,76,76,76,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsc1[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,34,1,0,0,44,1,0,0,78,1,0,0,113,1,0,0,147,1,0,0,179,1,0,
  0,210,1,0,0,234,1,0,0,2,2,0,0,33,2,0,0,65,2,0,0,99,2,0,0,134,2,0,0,168,2,0,0,
  178,2,0,0,179,2,0,0,180,2,0,0,181,2,0,0,182,2,0,0,183,2,0,0,184,2,0,0,185,2,
  0,0,186,2,0,0,187,2,0,0,188,2,0,0,189,2,0,0,190,2,0,0,191,2,0,0,192,2,0,0,
  193,2,0,0,194,2,0,0,195,2,0,0,196,2,0,0,197,2,0,0,198,2,0,0,199,2,0,0,200,2,
  0,0,201,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,48,5,71,71,71,71,71,71,71,255,34,
  3,66,66,103,103,103,41,3,71,71,71,71,71,45,9,71,71,71,70,68,68,69,70,72,72,
  72,62,2,66,66,66,66,255,34,30,71,71,66,66,103,103,107,68,68,68,71,71,71,68,
  66,66,66,66,66,66,66,66,65,65,65,65,65,65,65,66,66,66,255,35,29,71,71,71,107,
  107,103,3,68,69,103,103,66,66,66,103,66,66,66,66,66,66,66,68,68,68,68,68,66,
  66,66,66,255,37,27,71,71,109,3,111,68,65,107,107,3,3,69,66,100,66,100,103,
  103,103,103,103,103,103,103,103,103,74,72,72,255,37,20,71,71,109,109,109,103,
  111,107,94,103,3,103,100,103,100,68,100,103,103,106,107,107,62,2,74,74,74,74,
  255,38,19,109,109,109,107,3,111,107,103,107,3,103,103,100,68,100,100,3,106,
  107,107,107,255,38,19,109,109,109,107,3,111,107,103,107,3,103,103,68,103,100,
  103,3,106,107,107,107,255,37,20,71,71,109,109,109,103,111,107,97,103,3,103,
  103,100,68,100,103,3,103,106,107,107,62,2,74,74,74,74,255,37,27,71,71,109,3,
  111,68,69,109,109,3,3,103,100,103,100,100,103,103,103,103,103,103,103,103,
  103,103,66,70,70,255,35,29,66,66,66,107,107,103,3,68,73,103,103,69,66,66,66,
  103,103,70,70,70,70,70,70,68,68,68,68,68,66,66,66,255,34,30,66,66,66,71,103,
  103,107,103,73,73,73,73,71,71,103,103,103,103,71,71,71,71,71,71,70,70,70,70,
  70,73,73,73,255,34,3,71,71,71,103,103,41,3,75,75,75,75,75,45,9,71,71,71,71,
  71,71,71,71,73,73,73,62,2,74,74,74,74,255,47,5,73,73,73,73,73,73,73,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,
};
static const char dogsd1[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,42,1,0,0,56,1,0,0,88,1,0,0,117,1,0,0,149,1,0,0,180,1,0,
  0,211,1,0,0,235,1,0,0,3,2,0,0,34,2,0,0,65,2,0,0,97,2,0,0,130,2,0,0,162,2,0,0,
  177,2,0,0,187,2,0,0,188,2,0,0,189,2,0,0,190,2,0,0,191,2,0,0,192,2,0,0,193,2,
  0,0,194,2,0,0,195,2,0,0,196,2,0,0,197,2,0,0,198,2,0,0,199,2,0,0,200,2,0,0,
  201,2,0,0,202,2,0,0,203,2,0,0,204,2,0,0,205,2,0,0,206,2,0,0,207,2,0,0,208,2,
  0,0,209,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,50,4,71,71,71,71,73,73,255,47,9,71,
  71,71,71,69,69,69,70,72,72,72,255,33,2,66,66,103,103,39,3,71,71,71,71,71,43,
  14,71,71,68,68,68,68,68,68,72,73,73,74,74,74,74,74,255,33,24,71,71,66,103,
  103,107,68,68,68,71,71,71,68,66,66,66,66,66,66,66,68,69,71,72,73,73,255,34,
  27,71,71,107,107,103,3,68,65,103,103,66,66,66,66,66,66,66,66,70,70,70,70,70,
  70,72,75,73,73,73,255,35,26,71,71,109,3,111,65,107,107,107,107,69,69,66,100,
  66,100,103,103,103,72,72,72,72,72,75,73,73,73,255,35,26,71,71,109,109,109,
  111,3,107,94,103,3,103,100,103,100,68,100,3,106,107,109,109,109,109,109,107,
  75,75,255,36,19,109,109,109,107,111,0,107,103,107,3,103,103,100,68,100,100,3,
  106,107,109,109,255,36,19,109,109,109,107,111,0,107,103,107,3,103,103,68,103,
  100,103,3,106,107,109,109,255,35,20,71,71,109,109,109,111,3,107,97,103,3,103,
  103,100,68,100,103,3,106,107,109,109,56,2,3,3,76,76,255,35,26,71,71,109,3,
  111,66,109,109,109,107,3,103,100,103,100,100,103,3,106,107,3,3,73,76,76,107,
  73,73,255,34,27,66,66,107,107,103,3,68,69,103,103,69,69,69,69,69,103,69,103,
  70,70,70,70,73,73,76,76,75,73,73,255,33,28,66,66,66,103,103,107,103,73,73,73,
  73,71,71,71,103,103,70,70,70,71,71,73,73,73,75,75,107,76,76,76,255,33,2,71,
  71,71,71,39,3,75,75,75,75,75,43,14,71,71,71,71,71,71,71,73,73,73,73,75,75,75,
  76,76,255,46,10,73,73,73,73,73,73,76,76,76,76,76,76,255,50,5,74,74,74,74,75,
  76,76,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,
};
static const char dogsb5[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,34,1,0,0,35,1,0,0,52,1,0,0,85,1,0,0,122,1,0,0,158,1,0,
  0,187,1,0,0,213,1,0,0,238,1,0,0,7,2,0,0,33,2,0,0,62,2,0,0,96,2,0,0,133,2,0,0,
  166,2,0,0,188,2,0,0,205,2,0,0,206,2,0,0,207,2,0,0,208,2,0,0,209,2,0,0,210,2,
  0,0,211,2,0,0,212,2,0,0,213,2,0,0,214,2,0,0,215,2,0,0,216,2,0,0,217,2,0,0,
  218,2,0,0,219,2,0,0,220,2,0,0,221,2,0,0,222,2,0,0,223,2,0,0,224,2,0,0,225,2,
  0,0,226,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,49,6,66,66,66,65,65,65,65,65,
  62,2,66,66,66,66,255,32,3,66,66,66,66,66,43,21,3,3,3,3,103,66,66,66,65,64,64,
  64,64,64,64,64,64,64,64,64,69,69,69,255,32,32,103,103,66,66,66,103,66,66,66,
  66,3,106,106,106,3,66,66,66,66,66,65,65,66,66,64,64,64,70,70,72,3,73,76,76,
  255,33,31,103,103,66,66,103,66,66,66,103,106,107,107,107,3,103,66,66,66,70,
  72,72,72,72,70,70,70,107,107,107,76,76,76,76,255,34,24,103,103,109,66,66,68,
  68,3,0,77,77,77,3,103,103,66,70,70,3,3,107,109,107,107,107,107,255,34,21,109,
  109,109,103,68,68,68,0,0,77,73,67,67,67,67,67,70,70,3,106,109,109,109,255,35,
  20,109,109,103,68,68,0,0,0,77,77,71,71,70,69,69,103,106,106,108,108,108,108,
  255,35,20,109,109,103,68,68,68,107,0,77,76,76,74,73,71,71,103,106,106,109,
  109,109,109,255,34,21,109,109,109,103,68,68,68,3,107,108,108,107,76,74,74,71,
  103,103,106,107,108,108,108,255,34,24,70,70,66,103,68,68,68,103,107,108,108,
  107,3,76,74,71,103,103,3,106,107,108,103,103,103,103,255,33,29,66,66,66,66,
  66,103,70,70,103,107,108,108,108,3,66,71,71,103,70,70,100,100,100,70,70,103,
  103,103,3,107,107,255,32,32,66,66,66,100,103,103,73,73,73,73,107,109,109,108,
  107,66,69,71,71,70,70,66,66,66,69,69,69,69,100,100,107,107,76,76,255,32,3,66,
  66,100,103,103,43,21,109,109,109,108,71,71,71,71,70,67,67,67,67,72,72,72,71,
  69,69,71,71,76,76,255,47,17,73,73,73,73,71,71,71,71,71,72,72,72,72,72,72,72,
  75,76,76,255,49,6,74,74,74,74,74,74,75,75,62,2,76,76,76,76,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsa1[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,31,1,
  0,0,32,1,0,0,33,1,0,0,34,1,0,0,52,1,0,0,90,1,0,0,126,1,0,0,159,1,0,0,189,1,0,
  0,219,1,0,0,247,1,0,0,18,2,0,0,48,2,0,0,78,2,0,0,110,2,0,0,146,2,0,0,184,2,0,
  0,204,2,0,0,205,2,0,0,206,2,0,0,207,2,0,0,208,2,0,0,209,2,0,0,210,2,0,0,211,
  2,0,0,212,2,0,0,213,2,0,0,214,2,0,0,215,2,0,0,216,2,0,0,217,2,0,0,218,2,0,0,
  219,2,0,0,220,2,0,0,221,2,0,0,222,2,0,0,223,2,0,0,224,2,0,0,225,2,0,0,226,2,
  0,0,227,2,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,46,7,71,71,71,71,71,73,73,74,74,
  60,2,69,69,71,71,255,31,3,66,66,103,103,103,38,3,71,71,71,71,71,43,19,71,71,
  71,71,69,69,69,69,69,69,72,72,74,74,73,72,71,71,69,71,71,255,31,31,71,71,66,
  66,103,103,107,68,68,68,71,71,71,69,69,69,68,68,66,66,66,69,69,71,68,70,77,
  77,74,74,74,74,74,255,32,28,71,71,71,107,107,103,3,68,65,103,103,66,66,66,66,
  66,66,66,103,66,66,71,68,68,68,68,75,77,77,77,255,34,25,71,71,109,3,111,65,
  107,107,107,107,69,69,69,66,100,66,100,103,66,103,71,71,68,103,72,74,74,255,
  34,25,71,71,109,107,3,111,3,107,94,103,3,3,103,100,103,100,68,100,103,109,75,
  3,3,72,72,74,74,255,35,23,109,109,109,107,111,0,107,103,107,3,3,103,103,100,
  68,100,100,106,108,109,75,3,72,74,74,255,35,22,109,109,109,107,111,0,107,103,
  107,3,3,103,103,68,103,100,103,106,108,109,109,77,77,77,255,34,25,71,71,109,
  107,3,111,3,107,97,103,3,3,103,103,100,68,100,103,106,108,109,77,77,66,69,69,
  69,255,34,25,71,71,109,3,111,66,109,109,109,107,3,3,103,100,103,100,100,103,
  70,109,72,72,66,66,69,69,69,255,32,27,66,66,66,107,107,103,3,68,69,103,103,
  69,69,69,69,69,100,68,103,100,68,71,66,66,66,71,71,71,71,255,31,31,66,66,66,
  71,103,103,107,103,73,73,73,73,71,71,71,69,103,103,68,69,69,69,71,66,66,71,
  77,77,77,77,71,74,74,255,31,3,71,71,71,103,103,38,3,75,75,75,75,75,43,19,73,
  73,73,71,69,69,69,69,71,73,71,71,73,76,74,74,74,74,71,74,74,255,46,9,71,71,
  71,71,71,75,75,75,74,74,74,60,2,72,72,73,73,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsf1[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,29,1,0,0,30,1,0,0,36,1,
  0,0,43,1,0,0,50,1,0,0,69,1,0,0,99,1,0,0,138,1,0,0,180,1,0,0,220,1,0,0,5,2,0,
  0,46,2,0,0,89,2,0,0,128,2,0,0,164,2,0,0,202,2,0,0,235,2,0,0,11,3,0,0,39,3,0,
  0,58,3,0,0,67,3,0,0,68,3,0,0,69,3,0,0,70,3,0,0,71,3,0,0,72,3,0,0,73,3,0,0,74,
  3,0,0,75,3,0,0,76,3,0,0,77,3,0,0,78,3,0,0,79,3,0,0,80,3,0,0,81,3,0,0,82,3,0,
  0,83,3,0,0,84,3,0,0,85,3,0,0,86,3,0,0,87,3,0,0,88,3,0,0,89,3,0,0,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  27,1,66,66,66,255,27,2,71,71,68,68,255,28,2,66,66,68,68,255,28,6,71,71,107,
  103,68,68,71,71,49,4,69,69,69,69,69,69,255,28,7,71,71,109,103,100,68,68,71,
  71,39,3,70,70,70,70,70,48,7,69,69,66,66,66,66,66,69,69,255,28,28,109,109,107,
  3,109,65,65,103,71,70,70,103,103,66,66,66,70,72,69,69,69,69,69,66,66,66,69,
  70,69,69,60,2,66,66,66,66,255,28,29,109,109,107,109,111,107,107,107,66,103,
  70,103,66,66,66,66,66,66,66,72,72,73,73,73,73,73,71,71,69,66,66,58,4,66,66,
  66,69,73,73,255,27,35,109,109,107,3,111,111,107,3,98,107,3,70,103,66,66,64,
  64,64,64,64,66,66,71,107,107,107,73,73,71,71,70,70,70,70,73,73,73,255,26,36,
  66,66,109,107,109,111,0,3,103,107,97,3,3,103,66,66,103,100,64,64,64,66,66,71,
  109,109,107,107,75,75,73,73,75,75,75,107,73,73,255,23,36,66,66,66,71,107,103,
  103,109,111,107,103,109,107,103,0,3,103,103,103,3,106,106,100,64,69,69,71,
  109,109,109,107,107,107,75,75,107,107,107,255,23,30,71,71,71,103,103,103,107,
  68,109,109,98,107,187,103,0,3,103,103,100,103,3,106,106,107,107,107,107,109,
  109,109,111,111,54,4,107,107,107,107,107,107,255,27,26,107,107,103,68,69,109,
  3,107,97,109,3,103,100,103,103,103,3,106,106,107,107,107,109,109,109,109,111,
  111,54,4,107,107,107,107,107,107,255,28,31,75,75,71,71,71,98,69,3,3,3,103,
  103,100,103,103,103,106,107,107,107,107,71,73,73,109,107,107,75,75,75,3,3,3,
  255,29,33,75,75,75,73,97,71,66,66,69,103,66,103,103,103,66,66,66,66,69,69,71,
  71,73,109,107,3,75,75,75,75,75,3,66,66,66,255,34,28,71,71,71,69,69,69,69,66,
  66,66,66,66,66,69,69,71,71,75,74,73,73,73,74,75,75,74,73,66,69,69,255,37,19,
  72,72,69,69,69,69,69,69,71,71,71,73,75,75,74,74,73,73,73,74,74,58,4,74,74,73,
  73,73,73,255,38,17,72,72,72,72,72,74,74,74,74,74,76,76,75,74,74,74,74,76,76,
  60,2,73,73,73,73,255,39,4,74,74,74,74,74,74,48,6,76,76,75,74,74,74,76,76,255,
  49,4,76,76,76,76,76,76,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsd2d8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,32,1,0,0,41,1,0,0,51,1,0,0,62,1,0,0,75,1,0,0,91,1,0,0,110,
  1,0,0,135,1,0,0,158,1,0,0,187,1,0,0,219,1,0,0,255,1,0,0,29,2,0,0,56,2,0,0,81,
  2,0,0,105,2,0,0,130,2,0,0,155,2,0,0,180,2,0,0,204,2,0,0,227,2,0,0,247,2,0,0,
  9,3,0,0,25,3,0,0,40,3,0,0,49,3,0,0,58,3,0,0,68,3,0,0,77,3,0,0,86,3,0,0,94,3,
  0,0,102,3,0,0,108,3,0,0,109,3,0,0,110,3,0,0,111,3,0,0,112,3,0,0,113,3,0,0,
  114,3,0,0,115,3,0,0,116,3,0,0,117,3,0,0,118,3,0,0,119,3,0,0,120,3,0,0,121,3,
  0,0,122,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,38,3,0,0,0,109,109,255,38,4,0,0,0,107,103,103,255,38,5,109,109,107,107,
  100,0,0,255,37,6,107,107,109,103,107,97,109,109,255,36,8,109,109,107,107,69,
  103,100,109,107,107,255,35,11,66,66,109,107,73,69,94,98,109,107,3,103,103,
  255,34,14,66,66,103,109,3,0,66,98,97,75,107,3,3,103,103,103,255,33,20,66,66,
  103,103,109,103,107,66,107,77,103,71,3,3,103,103,103,103,72,70,70,70,255,36,
  18,109,109,66,100,66,66,75,103,71,103,103,103,103,100,103,103,103,103,68,68,
  255,35,24,66,66,103,67,66,66,66,103,71,67,66,66,103,103,103,100,103,3,106,
  109,68,68,68,68,68,68,255,33,27,66,66,66,103,103,103,66,66,66,66,67,67,66,66,
  66,103,103,103,103,3,107,109,103,103,103,103,68,68,68,255,34,26,103,103,103,
  73,103,69,67,67,67,67,67,67,68,66,103,103,66,66,106,107,109,3,3,3,3,71,71,71,
  61,1,69,69,69,255,37,17,73,73,73,71,69,69,68,68,68,68,103,103,103,66,66,66,
  66,3,3,58,4,71,71,71,69,73,73,255,39,16,73,73,73,73,71,68,68,100,103,103,68,
  68,66,66,66,66,66,66,60,2,73,73,73,73,255,42,20,109,109,71,68,103,68,68,68,
  68,68,68,68,68,66,66,66,66,66,66,73,73,73,255,42,19,109,109,106,103,68,68,68,
  68,71,72,72,72,68,68,68,68,68,66,66,73,73,255,42,20,111,111,109,106,103,100,
  68,68,68,103,3,107,72,72,72,72,72,68,68,69,69,69,255,42,20,109,109,111,111,
  106,3,100,68,100,3,107,109,109,109,109,109,109,72,72,69,69,69,255,42,20,109,
  109,109,109,107,106,103,103,103,103,106,106,106,106,106,106,3,3,68,69,69,69,
  255,42,19,109,109,109,109,107,3,103,100,68,68,68,68,68,68,69,69,69,69,69,69,
  69,255,42,18,109,109,109,108,106,3,68,66,66,66,68,68,69,69,69,69,70,71,71,71,
  255,43,15,108,108,107,3,68,66,66,66,66,68,69,69,69,70,71,71,71,255,43,13,68,
  68,103,68,68,66,66,66,68,69,69,70,71,71,71,255,43,11,66,66,68,68,68,66,66,66,
  68,70,71,71,71,255,42,10,70,70,66,66,69,70,71,72,72,72,72,72,255,41,4,70,70,
  66,68,72,72,255,40,4,74,74,70,70,77,77,255,39,5,77,77,71,72,77,77,77,255,39,
  4,0,0,74,75,0,0,255,39,4,0,0,75,77,0,0,255,39,3,0,0,77,77,77,255,39,3,0,0,0,
  0,0,255,40,1,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,
};
static const char dogsg1[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,28,1,0,0,34,1,0,0,43,1,0,0,53,1,
  0,0,64,1,0,0,85,1,0,0,110,1,0,0,149,1,0,0,193,1,0,0,239,1,0,0,28,2,0,0,72,2,
  0,0,110,2,0,0,142,2,0,0,172,2,0,0,206,2,0,0,248,2,0,0,27,3,0,0,62,3,0,0,91,3,
  0,0,115,3,0,0,123,3,0,0,124,3,0,0,125,3,0,0,126,3,0,0,127,3,0,0,128,3,0,0,
  129,3,0,0,130,3,0,0,131,3,0,0,132,3,0,0,133,3,0,0,134,3,0,0,135,3,0,0,136,3,
  0,0,137,3,0,0,138,3,0,0,139,3,0,0,140,3,0,0,141,3,0,0,142,3,0,0,143,3,0,0,
  144,3,0,0,145,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,26,1,66,66,66,255,25,4,66,66,68,3,3,3,255,25,5,68,68,
  71,103,3,68,68,255,25,6,109,109,109,3,68,68,71,71,255,24,8,109,109,109,107,
  109,0,65,68,71,71,35,4,70,70,70,94,66,66,255,22,10,71,71,109,109,107,0,0,103,
  109,109,71,71,34,6,103,103,70,64,71,3,70,70,255,20,22,66,66,66,107,3,3,111,0,
  103,103,189,109,97,92,70,103,66,94,3,71,74,69,69,69,44,8,69,69,69,69,66,66,
  66,69,69,69,255,20,33,71,71,71,107,3,109,3,103,109,107,97,187,103,70,70,103,
  66,64,71,3,74,69,69,69,69,69,69,66,66,66,66,66,66,66,66,60,2,66,66,66,66,255,
  21,41,71,71,107,103,68,103,103,107,100,47,3,185,70,70,103,72,72,98,71,74,103,
  103,69,69,69,69,71,71,73,71,71,70,70,66,66,66,66,66,66,66,69,73,73,255,22,40,
  103,103,73,69,109,189,97,47,47,189,103,109,3,103,103,103,103,3,3,3,3,103,103,
  103,71,72,73,73,107,107,107,73,73,70,70,70,70,73,73,73,73,73,255,23,39,73,73,
  73,103,109,187,189,189,189,189,97,0,103,100,103,103,3,3,3,3,3,106,106,106,
  106,106,108,108,109,107,107,107,107,73,73,107,107,107,107,73,73,255,24,33,73,
  73,73,100,109,103,189,189,103,100,0,103,103,100,103,103,3,3,3,106,106,107,
  107,107,107,108,108,109,109,107,107,107,107,107,107,255,25,27,73,73,98,69,
  109,3,97,100,0,3,100,103,103,103,103,3,3,106,106,107,107,107,108,108,108,109,
  109,109,109,255,27,25,98,98,69,69,0,0,3,3,103,100,103,103,103,3,3,106,106,
  107,107,108,109,109,109,109,109,109,109,255,29,29,69,69,69,69,3,100,103,103,
  103,103,3,106,106,106,107,107,107,108,108,109,109,109,109,109,107,107,107,3,
  3,3,3,255,28,1,97,97,97,30,32,72,72,69,69,103,100,103,103,3,107,107,71,71,
  107,107,108,108,108,109,109,109,109,109,107,3,3,75,75,75,3,3,66,66,66,255,32,
  30,72,72,69,66,66,69,71,71,107,64,94,71,109,109,74,74,74,74,74,73,73,73,73,
  74,74,75,75,74,73,66,69,69,255,33,21,72,72,66,66,69,69,66,64,64,66,72,71,71,
  73,73,73,73,73,73,74,74,74,74,57,5,75,75,74,73,73,73,73,255,34,18,72,72,69,
  69,69,66,64,64,98,72,74,74,74,74,74,74,74,74,75,75,60,2,73,73,73,73,255,35,8,
  74,74,74,74,72,72,64,69,72,72,44,7,76,76,76,76,76,76,76,76,76,255,40,3,69,69,
  103,72,72,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,
};
static const char dogsh8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,32,1,0,0,41,1,0,0,51,1,0,0,61,1,0,0,70,1,0,0,89,1,0,0,106,
  1,0,0,126,1,0,0,148,1,0,0,172,1,0,0,197,1,0,0,223,1,0,0,248,1,0,0,17,2,0,0,
  41,2,0,0,65,2,0,0,89,2,0,0,107,2,0,0,134,2,0,0,169,2,0,0,202,2,0,0,234,2,0,0,
  8,3,0,0,32,3,0,0,56,3,0,0,78,3,0,0,95,3,0,0,106,3,0,0,116,3,0,0,126,3,0,0,
  135,3,0,0,143,3,0,0,144,3,0,0,145,3,0,0,146,3,0,0,147,3,0,0,148,3,0,0,149,3,
  0,0,150,3,0,0,151,3,0,0,152,3,0,0,153,3,0,0,154,3,0,0,155,3,0,0,156,3,0,0,
  157,3,0,0,158,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,38,3,0,0,79,0,0,255,38,4,0,0,79,0,0,0,255,38,5,0,0,77,77,0,77,77,255,
  39,5,77,77,75,72,75,72,72,255,41,4,73,73,71,73,70,70,255,42,3,73,73,73,70,70,
  46,7,68,68,68,68,68,68,68,68,68,255,42,12,70,70,66,70,68,66,66,66,66,66,66,
  66,68,68,255,42,15,3,3,66,66,66,66,66,66,66,66,66,66,66,66,68,68,68,255,41,
  17,3,3,3,103,66,66,66,68,68,66,66,66,66,66,66,66,66,68,68,255,41,19,3,3,107,
  3,66,66,66,68,68,68,68,68,68,68,68,68,68,68,68,68,68,255,41,20,3,3,107,109,3,
  66,66,70,68,70,71,72,74,74,107,107,107,73,70,70,68,68,255,41,14,3,3,107,109,
  107,3,3,66,70,72,74,107,107,107,109,109,59,3,71,71,70,68,68,255,41,14,3,3,
  109,109,107,3,3,3,66,68,71,71,3,107,109,109,60,2,71,71,70,70,255,42,20,109,
  109,109,107,3,3,3,66,68,69,70,3,107,109,107,107,107,67,67,73,70,70,255,42,19,
  109,109,107,107,3,3,3,66,68,69,70,3,67,67,67,67,67,67,67,73,73,255,42,19,107,
  107,107,107,3,103,66,66,68,69,69,67,67,67,68,68,68,68,68,73,73,255,42,19,107,
  107,107,3,66,66,66,66,68,69,66,66,67,71,71,71,71,73,73,73,73,255,42,13,107,
  107,3,66,103,66,66,66,66,66,66,66,69,71,71,255,39,16,66,66,66,66,66,66,66,66,
  103,103,66,66,66,66,69,71,109,109,59,2,3,3,107,107,255,33,1,66,66,66,37,18,
  66,66,66,66,66,66,66,66,66,66,68,103,103,69,69,69,71,109,109,109,58,3,106,
  106,106,107,107,255,33,28,66,66,73,66,66,66,66,66,66,66,68,66,66,66,68,68,3,
  3,3,3,107,109,107,3,3,106,107,106,107,107,255,33,27,69,69,69,73,103,103,103,
  68,68,68,68,68,68,68,68,68,68,103,3,106,107,107,107,107,107,107,107,73,73,
  255,34,25,69,69,69,3,3,68,68,68,70,70,70,70,70,70,70,70,103,3,107,107,107,73,
  73,73,73,73,73,255,35,19,103,103,107,3,100,68,68,70,103,71,71,72,3,3,3,3,106,
  107,73,73,73,255,33,19,66,66,66,103,109,107,0,72,74,107,74,72,72,3,3,3,3,106,
  106,107,107,255,34,17,69,69,69,109,109,107,72,107,3,74,3,3,3,3,3,106,106,107,
  107,255,36,12,109,109,109,3,72,100,97,107,73,73,73,106,106,106,255,37,6,109,
  109,107,72,94,100,109,109,255,38,5,109,109,74,74,98,109,109,255,38,5,109,109,
  107,107,103,109,109,255,38,4,0,0,0,107,3,3,255,38,3,0,0,0,109,109,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogse8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,27,1,0,0,
  35,1,0,0,43,1,0,0,52,1,0,0,61,1,0,0,69,1,0,0,78,1,0,0,99,1,0,0,121,1,0,0,144,
  1,0,0,167,1,0,0,190,1,0,0,214,1,0,0,237,1,0,0,1,2,0,0,23,2,0,0,46,2,0,0,69,2,
  0,0,91,2,0,0,113,2,0,0,139,2,0,0,167,2,0,0,202,2,0,0,232,2,0,0,4,3,0,0,29,3,
  0,0,55,3,0,0,81,3,0,0,100,3,0,0,111,3,0,0,121,3,0,0,131,3,0,0,140,3,0,0,148,
  3,0,0,149,3,0,0,150,3,0,0,151,3,0,0,152,3,0,0,153,3,0,0,154,3,0,0,155,3,0,0,
  156,3,0,0,157,3,0,0,158,3,0,0,159,3,0,0,160,3,0,0,161,3,0,0,162,3,0,0,163,3,
  0,0,164,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,42,1,0,0,0,
  255,41,3,0,0,79,0,0,255,41,3,0,0,79,0,0,255,41,4,0,0,77,77,0,0,255,41,4,0,0,
  75,75,77,77,255,42,3,75,75,70,75,75,255,42,4,75,75,70,72,73,73,255,43,3,72,
  72,70,73,73,48,3,70,70,70,70,70,54,2,70,70,70,70,255,43,17,72,72,69,73,72,70,
  66,66,66,70,72,70,66,66,70,70,70,73,73,255,43,18,70,70,68,73,66,66,66,66,66,
  66,66,66,66,66,66,66,66,66,73,73,255,43,18,70,70,69,66,66,66,66,66,66,66,66,
  66,66,3,69,69,69,69,66,66,255,43,18,107,107,69,66,66,66,66,66,66,66,66,66,3,
  107,73,73,73,69,69,69,255,42,13,107,107,107,108,69,66,66,66,66,66,69,69,3,
  107,107,59,2,73,73,69,69,255,42,12,107,107,107,107,108,103,69,69,69,3,3,107,
  107,107,59,2,73,73,71,71,255,42,15,107,107,107,107,108,106,103,3,3,73,73,73,
  107,107,107,107,107,255,42,17,107,107,107,107,108,106,106,103,71,66,66,69,73,
  107,107,107,107,107,107,255,42,18,107,107,107,107,108,106,69,69,71,66,66,66,
  69,73,76,76,73,107,107,107,255,42,18,107,107,107,106,106,103,66,66,69,66,67,
  67,66,70,76,66,66,73,107,107,255,42,17,107,107,106,106,103,69,66,66,66,66,69,
  98,66,66,70,76,66,71,71,255,42,17,106,106,103,66,103,69,66,66,66,67,69,3,98,
  66,66,66,67,71,71,255,38,21,66,66,66,66,66,66,66,66,69,103,69,67,69,69,106,
  109,3,67,69,69,69,71,71,255,36,23,66,66,66,66,66,66,66,66,66,66,68,103,103,
  69,103,103,107,108,109,107,69,69,69,71,71,255,31,3,66,66,66,66,66,35,23,66,
  66,66,66,66,66,66,68,68,68,68,68,68,103,103,103,3,108,109,108,107,74,73,72,
  72,255,32,25,69,69,66,66,103,103,103,68,68,68,68,68,68,68,70,70,72,103,103,
  106,108,108,107,74,73,72,72,255,33,23,69,69,69,3,3,68,68,68,70,70,70,70,70,
  70,71,72,72,3,107,108,107,74,73,72,72,255,34,20,103,103,107,3,100,68,68,70,
  103,71,72,72,72,3,3,3,106,107,74,74,73,73,255,32,21,103,103,66,103,109,3,0,
  70,72,107,74,72,103,103,3,3,3,106,107,74,73,72,72,255,31,21,66,66,69,69,69,
  109,107,107,70,107,103,100,106,3,3,3,106,106,73,72,72,72,72,255,36,14,109,
  109,3,70,73,107,97,108,73,73,73,73,73,71,71,71,255,37,6,109,109,72,72,94,100,
  109,109,255,38,5,109,109,73,3,97,109,109,255,38,5,109,109,107,107,103,109,
  109,255,38,4,0,0,0,107,3,3,255,38,3,107,107,0,109,109,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsd4d6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,31,1,0,0,40,1,0,0,50,1,0,0,62,1,0,0,79,1,0,0,99,1,0,0,122,1,0,0,147,
  1,0,0,177,1,0,0,206,1,0,0,235,1,0,0,18,2,0,0,57,2,0,0,92,2,0,0,118,2,0,0,141,
  2,0,0,168,2,0,0,194,2,0,0,221,2,0,0,245,2,0,0,11,3,0,0,32,3,0,0,51,3,0,0,65,
  3,0,0,78,3,0,0,89,3,0,0,98,3,0,0,106,3,0,0,114,3,0,0,122,3,0,0,130,3,0,0,138,
  3,0,0,146,3,0,0,154,3,0,0,161,3,0,0,168,3,0,0,169,3,0,0,170,3,0,0,171,3,0,0,
  172,3,0,0,173,3,0,0,174,3,0,0,175,3,0,0,176,3,0,0,177,3,0,0,178,3,0,0,179,3,
  0,0,180,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,37,
  3,0,0,109,109,109,255,37,4,0,0,107,103,107,107,255,37,5,109,109,103,66,103,
  107,107,255,36,7,109,109,3,66,66,103,3,0,0,255,35,12,109,109,3,0,66,66,103,3,
  103,103,103,103,103,103,255,35,15,109,109,103,66,66,66,103,68,68,68,68,68,68,
  103,103,103,103,255,34,18,66,66,103,109,103,66,66,66,100,66,66,66,66,66,68,
  68,103,68,68,68,255,33,20,66,66,103,103,109,103,66,66,66,66,66,66,66,66,66,
  103,103,66,68,68,68,68,255,33,25,66,66,3,3,103,72,66,66,66,66,66,66,66,66,66,
  103,66,66,68,68,68,68,68,68,68,68,68,255,35,24,107,107,3,72,69,69,66,66,66,
  66,66,66,103,103,66,66,66,71,71,71,71,71,71,68,68,68,255,35,24,103,103,107,
  72,69,69,69,69,69,72,109,108,3,66,66,68,71,73,73,73,73,73,71,103,68,68,255,
  34,21,70,70,3,107,72,69,69,69,69,72,109,108,108,106,3,66,66,66,3,106,107,109,
  109,56,3,73,73,103,68,68,60,2,71,71,71,71,255,33,22,66,66,70,107,3,69,69,69,
  69,69,109,109,108,107,106,3,66,100,100,69,69,107,109,109,57,2,107,107,107,
  107,60,2,69,69,71,71,255,33,22,66,66,3,3,107,72,72,72,72,69,109,108,108,107,
  3,103,100,65,65,65,65,65,69,69,58,4,68,68,69,69,71,71,255,40,21,72,72,72,108,
  108,107,106,3,103,66,65,65,65,66,66,69,69,68,68,69,69,71,71,255,42,18,108,
  108,107,106,3,100,66,66,65,65,66,68,68,68,68,68,69,69,73,73,255,42,17,107,
  107,107,3,103,66,66,66,65,66,68,68,69,69,69,69,69,75,75,61,1,107,107,107,255,
  42,15,107,107,106,3,100,66,66,66,65,66,68,69,69,71,73,74,74,60,2,107,107,107,
  107,255,42,14,107,107,3,100,66,66,66,66,65,66,68,69,71,73,74,74,58,4,107,107,
  107,107,75,75,255,43,19,3,3,100,66,66,66,66,66,68,69,71,73,74,107,107,107,
  107,75,75,75,75,255,43,17,103,103,66,66,66,68,68,73,70,73,73,74,107,107,107,
  75,75,75,75,255,43,16,70,70,68,66,66,68,72,107,107,107,74,107,107,75,75,75,
  75,75,255,44,14,68,68,68,66,68,72,107,107,107,75,107,75,75,75,75,75,255,45,9,
  68,68,70,68,107,75,75,75,75,75,75,255,45,8,72,72,70,68,75,75,75,75,75,75,255,
  45,6,72,72,68,74,75,75,75,75,255,44,4,72,72,71,71,74,74,255,44,3,74,74,71,74,
  74,255,44,3,74,74,71,74,74,255,44,3,76,76,75,77,77,255,44,3,76,76,75,79,79,
  255,44,3,77,77,77,0,0,255,43,3,0,0,77,79,79,255,43,3,0,0,79,0,0,255,43,2,0,0,
  0,0,255,43,2,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsa2a8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,35,1,0,0,44,1,0,0,55,1,0,0,68,1,
  0,0,88,1,0,0,115,1,0,0,144,1,0,0,173,1,0,0,197,1,0,0,224,1,0,0,1,2,0,0,41,2,
  0,0,74,2,0,0,106,2,0,0,131,2,0,0,154,2,0,0,176,2,0,0,196,2,0,0,219,2,0,0,243,
  2,0,0,12,3,0,0,37,3,0,0,60,3,0,0,82,3,0,0,102,3,0,0,126,3,0,0,134,3,0,0,143,
  3,0,0,152,3,0,0,160,3,0,0,168,3,0,0,174,3,0,0,175,3,0,0,176,3,0,0,177,3,0,0,
  178,3,0,0,179,3,0,0,180,3,0,0,181,3,0,0,182,3,0,0,183,3,0,0,184,3,0,0,185,3,
  0,0,186,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,38,3,0,0,0,109,109,255,38,4,0,0,0,107,103,103,255,37,6,107,
  107,109,107,107,100,109,109,255,36,8,109,109,107,107,103,107,97,109,3,3,255,
  35,15,109,109,109,107,3,69,103,103,109,3,3,3,3,3,3,3,3,255,33,22,66,66,66,
  109,109,3,68,103,94,100,107,3,3,3,103,103,103,103,3,3,70,70,70,70,255,32,24,
  66,66,100,103,109,3,0,66,3,100,97,107,3,3,3,3,103,3,3,103,66,3,70,74,76,76,
  255,32,24,100,100,100,103,109,103,107,66,107,77,103,71,71,3,103,103,103,69,
  103,103,103,3,76,76,76,76,255,35,19,109,109,66,100,66,66,75,103,71,71,69,103,
  69,69,103,103,3,103,3,109,109,255,33,22,66,66,66,103,67,66,66,66,103,71,66,
  66,66,66,66,103,103,103,106,3,107,108,109,109,255,32,23,66,66,100,103,103,
  103,66,66,66,66,66,66,66,66,66,100,103,100,103,103,106,108,108,109,109,62,1,
  76,76,76,255,32,2,100,100,100,100,35,23,73,73,103,68,67,66,66,66,66,66,66,66,
  103,100,66,66,100,103,109,109,73,66,66,70,70,61,2,76,76,76,76,255,36,22,73,
  73,73,69,66,66,66,66,66,66,100,103,66,66,66,66,100,76,73,66,66,66,70,70,61,2,
  76,76,76,76,255,38,20,73,73,73,73,69,103,103,66,103,100,66,66,66,66,70,73,67,
  66,70,66,72,72,60,3,76,76,76,76,76,255,42,20,109,109,107,103,66,66,66,66,66,
  66,66,66,66,70,77,70,74,76,76,76,76,76,255,43,18,109,109,108,103,66,66,66,72,
  66,66,72,70,77,70,70,76,76,76,76,76,255,43,17,108,108,107,106,66,66,66,69,72,
  74,107,108,109,76,76,76,76,76,76,255,43,15,108,108,107,106,106,66,103,103,69,
  100,103,108,109,76,76,76,76,255,43,12,108,108,107,106,106,103,103,103,77,77,
  77,108,109,109,61,2,72,72,66,66,255,43,12,108,108,107,106,103,100,66,100,103,
  103,103,77,109,109,60,3,72,72,66,66,66,255,43,20,108,108,108,100,66,66,66,66,
  66,66,100,103,3,3,3,3,103,66,66,66,66,66,255,43,20,109,109,66,66,66,66,66,66,
  66,66,66,100,100,3,100,100,66,66,66,69,72,72,255,43,18,70,70,66,69,66,66,66,
  66,66,66,66,66,66,100,66,66,69,71,71,71,255,43,17,70,70,66,103,73,69,66,66,
  66,69,69,69,66,66,69,71,73,76,76,255,43,15,70,70,103,77,76,73,73,71,71,71,71,
  73,71,71,71,73,73,255,42,4,109,109,70,103,77,77,49,4,73,73,73,73,73,73,54,3,
  73,73,73,73,73,255,42,3,74,74,72,77,77,255,41,4,109,109,75,74,77,77,255,41,4,
  109,109,75,75,77,77,255,41,3,109,109,77,76,76,255,41,3,109,109,77,109,109,
  255,42,1,109,109,109,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsf8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  28,1,0,0,36,1,0,0,44,1,0,0,53,1,0,0,70,1,0,0,90,1,0,0,114,1,0,0,142,1,0,0,
  160,1,0,0,184,1,0,0,206,1,0,0,228,1,0,0,252,1,0,0,13,2,0,0,30,2,0,0,46,2,0,0,
  62,2,0,0,78,2,0,0,95,2,0,0,116,2,0,0,144,2,0,0,171,2,0,0,197,2,0,0,222,2,0,0,
  246,2,0,0,15,3,0,0,40,3,0,0,64,3,0,0,85,3,0,0,104,3,0,0,120,3,0,0,135,3,0,0,
  149,3,0,0,157,3,0,0,166,3,0,0,174,3,0,0,175,3,0,0,176,3,0,0,177,3,0,0,178,3,
  0,0,179,3,0,0,180,3,0,0,181,3,0,0,182,3,0,0,183,3,0,0,184,3,0,0,185,3,0,0,
  186,3,0,0,187,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  43,1,0,0,0,255,42,3,0,0,79,0,0,255,42,3,0,0,79,0,0,255,42,4,0,0,77,77,0,0,
  255,42,4,0,0,75,75,77,77,57,4,66,66,66,66,66,66,255,43,3,75,75,72,75,75,53,8,
  66,66,66,66,66,66,66,66,66,66,255,43,3,75,75,71,72,72,49,12,70,70,70,70,66,
  66,66,66,69,107,107,69,69,69,255,43,3,72,72,71,73,73,47,10,70,70,70,66,66,66,
  66,66,3,107,107,107,59,2,72,72,72,72,255,43,13,70,70,71,73,70,66,66,66,66,66,
  66,66,3,3,3,255,43,12,70,70,69,66,66,66,66,66,66,66,66,66,3,3,57,3,73,73,73,
  73,73,255,43,17,106,106,69,66,66,66,66,66,66,66,66,69,3,73,73,75,75,75,75,
  255,43,17,107,107,106,103,66,66,66,66,66,66,69,3,106,107,107,107,107,107,107,
  255,43,13,107,107,107,106,103,69,66,66,66,69,3,106,107,107,107,58,2,75,75,
  107,107,255,43,12,107,107,107,106,3,103,69,69,103,3,3,106,107,107,255,43,12,
  107,107,107,106,3,3,103,103,3,106,106,107,107,107,255,43,11,107,107,107,106,
  3,69,66,66,3,106,107,107,107,255,42,11,107,107,107,106,3,103,66,66,69,3,107,
  107,107,255,42,11,107,107,106,3,103,69,66,66,69,73,107,107,107,255,41,12,3,3,
  103,103,66,66,66,66,66,66,69,107,107,107,255,37,16,66,66,66,66,66,66,66,66,
  103,66,66,66,66,66,68,107,107,107,255,31,1,66,66,66,35,18,66,66,66,66,66,66,
  66,66,66,66,66,103,103,66,66,66,68,73,107,107,255,31,22,66,66,73,66,66,66,66,
  66,66,66,68,66,66,66,66,103,103,103,66,66,68,73,107,107,255,31,21,69,69,69,
  73,103,103,103,68,68,68,68,68,68,68,70,70,72,103,103,66,68,73,73,255,32,20,
  69,69,69,3,3,68,68,68,70,70,70,70,70,70,71,72,72,3,66,68,73,73,255,33,19,103,
  103,107,3,100,68,68,70,103,71,71,72,72,3,3,3,107,66,68,107,107,255,31,20,66,
  66,66,103,109,107,0,72,74,107,74,72,72,103,3,3,3,106,107,66,68,68,255,32,20,
  69,69,69,109,109,107,72,107,3,74,3,3,3,3,106,106,75,75,68,68,68,68,255,34,19,
  109,109,109,3,72,100,97,107,73,73,73,73,73,73,75,75,68,70,70,70,70,255,35,6,
  109,109,107,72,94,100,109,109,47,6,73,73,75,68,70,72,72,72,255,36,5,109,109,
  74,74,98,109,109,48,5,73,73,75,72,72,72,72,255,36,5,109,109,107,107,103,109,
  109,48,2,73,73,75,75,255,36,4,0,0,0,107,3,3,48,2,73,73,75,75,255,36,3,0,0,0,
  109,109,48,2,73,73,75,75,255,48,3,73,73,75,75,75,255,48,4,73,73,75,75,75,75,
  255,49,3,75,75,75,75,75,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,
};
static const char dogsh1[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,26,1,0,0,27,1,0,0,34,1,0,0,48,1,0,0,64,1,0,0,78,1,
  0,0,102,1,0,0,128,1,0,0,153,1,0,0,190,1,0,0,231,1,0,0,19,2,0,0,68,2,0,0,111,
  2,0,0,152,2,0,0,182,2,0,0,210,2,0,0,243,2,0,0,24,3,0,0,60,3,0,0,99,3,0,0,128,
  3,0,0,140,3,0,0,152,3,0,0,163,3,0,0,172,3,0,0,179,3,0,0,180,3,0,0,181,3,0,0,
  182,3,0,0,183,3,0,0,184,3,0,0,185,3,0,0,186,3,0,0,187,3,0,0,188,3,0,0,189,3,
  0,0,190,3,0,0,191,3,0,0,192,3,0,0,193,3,0,0,194,3,0,0,195,3,0,0,196,3,0,0,
  197,3,0,0,198,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,27,2,68,68,3,3,255,26,4,109,109,103,3,71,71,31,1,185,185,
  185,255,25,6,109,109,109,3,69,69,71,71,33,1,188,188,188,255,23,9,109,109,107,
  0,0,103,109,69,71,188,188,255,22,10,107,107,109,111,0,103,103,189,109,103,72,
  72,33,5,70,70,70,70,70,70,70,255,20,21,71,71,68,107,109,3,103,109,107,100,
  189,109,72,70,100,66,66,68,68,67,65,94,94,255,21,20,71,71,107,103,103,107,
  103,3,0,0,0,74,70,100,66,68,68,68,65,64,71,71,255,22,21,103,103,69,189,100,3,
  0,107,107,0,107,70,103,70,68,68,68,65,64,94,69,70,70,44,7,69,69,69,69,69,69,
  69,69,69,255,22,30,73,73,71,109,0,0,107,107,107,107,107,3,70,103,72,72,72,67,
  64,71,70,72,69,66,66,66,66,66,67,67,67,67,60,2,66,66,66,66,255,23,39,188,188,
  103,109,0,107,107,107,107,107,3,103,103,3,106,106,106,72,98,103,74,74,71,71,
  71,73,71,71,70,70,66,66,66,66,66,66,66,66,69,73,73,255,21,1,188,188,188,23,
  39,73,73,73,74,109,107,107,107,107,107,3,3,103,3,106,106,106,106,106,103,106,
  74,3,72,73,73,107,107,107,107,73,72,70,70,70,70,72,72,73,73,73,255,24,38,73,
  73,73,107,107,107,107,107,107,3,3,3,3,106,106,106,106,106,106,106,107,108,
  109,109,109,109,109,107,107,107,107,107,107,107,107,107,107,107,73,73,255,22,
  1,185,185,185,25,31,73,73,74,74,107,107,107,3,3,3,3,3,106,106,106,106,106,
  106,107,107,108,108,109,109,109,109,109,109,107,107,107,107,107,255,26,25,73,
  73,74,74,74,3,3,3,3,3,106,106,106,106,106,106,107,107,108,108,109,109,109,
  109,109,109,109,255,28,23,74,74,74,74,3,3,3,3,106,106,106,107,107,107,107,
  108,108,108,108,109,109,109,109,109,109,255,29,28,74,74,74,3,3,3,107,107,107,
  107,107,107,108,108,108,108,108,109,109,109,109,109,109,109,107,107,3,3,3,3,
  255,30,32,3,3,3,73,73,107,109,109,109,109,109,109,109,109,109,109,109,109,
  109,109,107,107,107,3,3,3,75,75,3,3,3,66,66,66,255,31,31,3,3,73,73,3,107,74,
  76,76,77,77,109,109,109,74,74,74,74,73,73,73,73,73,74,74,74,75,73,72,72,66,
  69,69,255,31,6,74,74,73,71,103,3,107,107,38,15,74,74,74,74,74,74,73,73,73,73,
  73,73,73,73,74,74,74,57,5,75,75,74,72,73,73,73,255,32,6,74,74,71,70,69,69,69,
  69,43,8,75,75,75,75,74,74,74,75,75,75,60,2,73,73,73,73,255,33,7,74,74,69,66,
  66,64,67,69,69,255,34,7,72,72,69,64,64,64,67,71,71,255,35,6,70,70,64,64,64,
  66,100,100,255,36,4,67,67,64,69,100,100,255,37,2,103,103,72,72,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsa4a6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,32,1,0,0,41,1,0,0,52,1,0,0,64,1,0,0,77,1,0,0,106,1,0,0,141,
  1,0,0,173,1,0,0,203,1,0,0,235,1,0,0,4,2,0,0,35,2,0,0,69,2,0,0,108,2,0,0,145,
  2,0,0,172,2,0,0,196,2,0,0,216,2,0,0,240,2,0,0,7,3,0,0,31,3,0,0,52,3,0,0,73,3,
  0,0,92,3,0,0,111,3,0,0,120,3,0,0,128,3,0,0,136,3,0,0,145,3,0,0,153,3,0,0,161,
  3,0,0,169,3,0,0,177,3,0,0,184,3,0,0,191,3,0,0,192,3,0,0,193,3,0,0,194,3,0,0,
  195,3,0,0,196,3,0,0,197,3,0,0,198,3,0,0,199,3,0,0,200,3,0,0,201,3,0,0,202,3,
  0,0,203,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,37,3,0,0,109,109,109,255,37,4,0,0,107,103,107,107,255,36,6,109,109,103,
  66,69,107,107,107,255,35,7,109,109,3,66,66,69,3,107,107,255,34,8,109,109,3,0,
  66,66,69,3,107,107,255,34,17,109,109,103,66,66,66,103,66,103,103,103,103,103,
  100,100,66,66,103,103,54,3,66,66,66,66,66,255,31,21,66,66,66,66,103,109,103,
  66,66,66,103,66,66,66,66,100,66,66,66,66,66,103,103,53,5,66,66,66,66,73,66,
  66,255,31,27,103,103,103,103,103,109,103,66,66,66,66,66,66,66,66,103,66,66,
  66,66,66,66,66,66,66,73,66,71,71,255,33,25,103,103,103,103,72,66,69,66,69,66,
  66,66,103,66,66,66,66,66,70,66,66,66,73,71,71,74,74,255,34,21,109,109,103,72,
  69,69,69,66,66,103,3,3,106,3,100,66,66,72,66,66,73,73,73,56,2,74,74,74,74,
  255,34,20,103,103,109,72,69,69,69,69,72,107,107,107,107,106,3,103,66,66,72,
  72,3,3,255,33,21,70,70,103,109,72,69,69,69,69,109,108,108,107,107,107,106,
  103,66,100,103,103,103,103,63,1,68,68,68,255,32,23,66,66,70,109,3,69,69,72,
  69,69,109,109,108,108,107,107,106,3,66,66,66,66,66,100,100,62,2,66,66,68,68,
  255,31,26,66,66,70,103,103,109,72,72,72,69,69,109,109,108,108,107,106,3,66,
  66,66,66,66,66,66,100,3,3,60,4,66,66,66,68,74,74,255,31,2,103,103,103,103,38,
  26,72,72,72,72,109,109,108,108,107,3,66,66,66,66,66,66,66,66,66,107,100,66,
  66,66,70,74,74,74,255,42,22,109,109,108,108,106,103,66,66,66,66,66,66,66,66,
  66,66,66,66,68,70,74,109,109,109,255,43,19,109,109,108,103,66,66,66,66,66,66,
  68,68,68,68,68,68,70,72,74,107,107,255,44,15,3,3,66,66,66,66,68,68,71,74,74,
  74,72,72,72,72,72,255,44,13,3,3,66,66,68,69,70,71,74,106,106,106,72,72,72,61,
  2,107,107,75,75,255,44,11,3,3,66,66,68,70,71,71,73,109,106,106,106,60,3,107,
  107,107,75,75,255,44,19,3,3,69,66,68,73,73,74,74,75,107,107,107,107,107,107,
  107,107,75,75,75,255,45,16,70,70,66,68,107,107,75,75,107,107,107,107,107,107,
  107,75,75,75,255,45,16,70,70,70,75,107,75,75,75,75,75,76,77,107,107,75,75,75,
  75,255,45,14,70,70,71,75,75,75,75,75,75,75,75,75,75,75,75,75,255,44,8,75,75,
  71,72,75,75,75,75,75,75,56,2,75,75,75,75,255,44,4,75,75,72,74,75,75,255,44,3,
  75,75,75,77,77,255,44,3,75,75,75,77,77,255,43,4,79,79,77,77,77,77,255,43,3,
  79,79,77,77,77,255,43,3,0,0,79,77,77,255,42,3,0,0,0,79,79,255,42,3,0,0,0,0,0,
  255,42,2,0,0,0,0,255,42,2,0,0,0,0,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,
};
static const char dogsb4b6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,38,1,0,0,55,1,0,0,73,1,0,0,91,1,0,0,111,1,0,0,135,1,0,0,159,1,0,0,
  185,1,0,0,211,1,0,0,235,1,0,0,4,2,0,0,30,2,0,0,57,2,0,0,84,2,0,0,109,2,0,0,
  128,2,0,0,148,2,0,0,168,2,0,0,193,2,0,0,219,2,0,0,245,2,0,0,14,3,0,0,32,3,0,
  0,50,3,0,0,70,3,0,0,100,3,0,0,121,3,0,0,137,3,0,0,145,3,0,0,153,3,0,0,161,3,
  0,0,169,3,0,0,177,3,0,0,184,3,0,0,191,3,0,0,192,3,0,0,193,3,0,0,194,3,0,0,
  195,3,0,0,196,3,0,0,197,3,0,0,198,3,0,0,199,3,0,0,200,3,0,0,201,3,0,0,202,3,
  0,0,203,3,0,0,204,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,35,3,0,0,109,109,109,48,3,66,66,69,72,72,255,35,4,0,0,107,103,107,
  107,47,4,66,66,69,69,72,72,255,35,5,109,109,103,66,103,107,107,47,4,66,66,69,
  72,72,72,255,34,6,109,109,3,66,66,103,3,3,47,3,66,66,66,69,69,255,33,8,109,
  109,3,0,66,66,103,3,3,3,47,3,69,69,66,69,69,255,33,12,109,109,103,66,66,66,
  103,66,103,103,103,103,103,103,48,3,66,66,66,72,72,255,32,19,66,66,103,109,
  103,66,66,66,100,66,66,66,100,103,103,103,103,66,66,69,69,255,31,21,66,66,
  103,103,109,103,66,66,66,66,66,66,66,66,66,103,103,66,66,66,69,72,72,255,31,
  21,66,66,103,103,103,72,66,66,66,66,66,66,66,66,103,103,66,66,66,66,69,72,72,
  255,33,19,107,107,103,72,69,69,66,66,66,66,3,103,66,66,66,66,66,69,72,107,
  107,255,33,20,103,103,107,72,69,69,69,69,69,3,106,106,106,3,100,66,69,72,74,
  107,107,107,255,32,21,70,70,103,107,72,69,69,69,69,109,108,108,107,107,106,3,
  66,66,66,3,106,107,107,255,31,22,66,66,70,107,3,69,69,69,69,69,109,108,108,
  107,107,107,106,103,66,66,66,106,107,107,255,31,22,66,66,103,103,107,72,72,
  72,72,69,109,108,108,108,107,107,106,3,100,100,100,3,107,107,255,31,1,66,66,
  66,38,15,72,72,72,109,109,108,108,107,106,3,66,66,66,66,66,66,66,255,41,14,
  109,109,108,108,107,3,100,66,66,66,66,66,66,66,66,66,255,41,15,109,109,108,
  108,106,103,66,66,66,66,66,66,66,66,66,66,66,255,42,15,109,109,107,103,100,
  66,66,66,66,66,66,66,66,66,66,66,66,255,43,15,3,3,100,66,66,66,66,66,66,66,
  66,66,66,66,66,66,66,63,1,66,66,66,255,43,21,3,3,100,66,68,69,66,66,68,68,70,
  70,70,68,66,66,66,66,66,66,66,66,66,255,43,21,3,3,66,66,68,70,70,70,72,73,75,
  75,75,70,70,70,70,68,68,66,66,66,66,255,44,20,69,69,66,68,73,70,73,75,75,107,
  107,106,106,3,3,73,73,73,73,73,73,73,255,44,13,69,69,66,71,107,107,107,107,
  107,107,107,107,107,107,107,255,44,13,69,69,66,73,107,107,107,75,75,75,75,
  107,107,107,107,255,43,15,72,72,69,70,76,107,75,75,75,75,75,75,75,107,107,
  107,107,255,43,8,72,72,70,71,76,75,75,75,75,75,53,7,75,75,75,75,107,107,107,
  107,107,61,2,107,107,107,107,255,43,4,75,75,71,76,76,76,55,8,75,75,75,75,75,
  75,107,107,75,75,255,43,3,75,75,73,76,76,59,4,75,75,75,75,75,75,255,43,3,76,
  76,75,77,77,255,43,3,76,76,75,79,79,255,43,3,77,77,77,0,0,255,42,3,0,0,77,79,
  79,255,42,3,0,0,79,0,0,255,42,2,0,0,0,0,255,42,2,0,0,0,0,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,
};
static const char dogsh6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  29,1,0,0,36,1,0,0,44,1,0,0,52,1,0,0,60,1,0,0,68,1,0,0,76,1,0,0,84,1,0,0,97,1,
  0,0,118,1,0,0,140,1,0,0,163,1,0,0,188,1,0,0,213,1,0,0,238,1,0,0,10,2,0,0,35,
  2,0,0,58,2,0,0,82,2,0,0,106,2,0,0,133,2,0,0,168,2,0,0,201,2,0,0,232,2,0,0,6,
  3,0,0,34,3,0,0,57,3,0,0,81,3,0,0,104,3,0,0,126,3,0,0,144,3,0,0,157,3,0,0,168,
  3,0,0,178,3,0,0,187,3,0,0,195,3,0,0,196,3,0,0,197,3,0,0,198,3,0,0,199,3,0,0,
  200,3,0,0,201,3,0,0,202,3,0,0,203,3,0,0,204,3,0,0,205,3,0,0,206,3,0,0,207,3,
  0,0,208,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,42,2,0,
  0,0,0,255,42,2,0,0,0,0,255,42,3,0,0,111,0,0,255,43,3,111,111,109,107,107,255,
  43,3,111,111,109,107,107,255,43,3,0,0,75,107,107,255,43,3,109,109,73,107,107,
  255,43,3,107,107,73,75,75,255,43,8,71,71,73,107,66,66,68,68,68,68,255,43,10,
  70,70,73,107,68,103,68,68,68,68,68,68,55,2,68,68,68,68,255,42,17,107,107,69,
  71,107,107,103,69,69,71,68,68,68,68,68,68,68,70,70,255,42,18,107,107,66,69,
  71,3,103,103,69,72,103,3,106,103,103,103,70,70,70,70,255,41,20,109,109,107,
  66,69,71,3,71,69,72,3,3,106,107,106,106,3,103,71,70,70,70,255,41,20,109,109,
  107,66,68,69,69,66,66,66,66,71,3,107,107,107,107,106,3,103,70,70,255,41,13,
  109,109,107,66,66,68,69,68,68,68,68,68,71,3,3,58,3,107,107,3,103,103,255,41,
  17,109,109,107,103,66,68,69,70,70,70,70,68,66,66,66,66,73,73,73,59,2,107,107,
  3,3,255,41,20,109,109,109,107,68,68,72,72,72,70,70,70,68,68,68,68,73,73,73,
  107,107,107,255,42,18,109,109,109,103,103,72,72,72,72,70,70,70,70,70,70,70,
  70,73,73,73,255,43,19,109,109,109,107,103,72,72,72,72,72,72,72,72,72,72,72,
  72,72,73,73,73,255,44,11,109,109,109,107,107,72,72,72,72,72,72,72,72,58,4,72,
  72,72,72,73,73,255,40,22,71,71,71,71,109,109,109,109,109,107,3,72,72,72,107,
  109,75,75,75,0,72,72,73,73,255,34,2,69,69,66,66,38,24,71,71,71,69,66,66,107,
  109,109,109,109,109,107,72,72,3,107,109,109,109,109,74,74,109,109,109,255,34,
  28,103,103,66,66,71,69,66,66,66,66,103,109,109,109,109,109,107,72,72,3,74,74,
  74,74,74,72,72,109,109,109,255,35,26,103,103,3,66,66,66,66,66,66,103,107,109,
  109,109,109,107,72,72,75,72,72,72,72,72,72,72,109,109,255,35,25,107,107,107,
  103,66,66,66,66,67,66,103,107,107,107,107,72,72,72,72,72,72,72,72,72,72,74,
  74,255,36,23,107,107,103,66,67,67,68,68,68,68,70,70,103,3,3,72,72,72,72,74,
  74,74,74,74,74,255,36,18,107,107,66,67,68,68,70,70,70,70,70,70,70,72,3,3,74,
  74,74,74,255,34,19,66,66,66,66,68,3,70,70,70,70,70,70,70,72,72,72,72,3,106,
  107,107,255,34,18,68,68,68,103,107,3,70,70,72,72,107,72,72,72,72,72,3,106,
  107,107,255,34,17,3,3,103,107,107,107,72,72,72,107,72,107,107,107,107,107,
  107,107,107,255,35,13,107,107,111,107,72,72,72,107,72,107,107,107,107,107,
  107,255,36,8,109,109,107,0,72,72,107,107,0,0,255,37,6,109,109,107,72,107,107,
  109,109,255,38,5,109,109,107,107,107,111,111,255,38,4,0,0,0,107,111,111,255,
  38,3,0,0,0,111,111,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,
};
static const char dogsb2b8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,31,1,0,0,46,1,0,0,64,1,0,0,83,1,0,0,104,1,0,0,129,1,0,0,
  157,1,0,0,183,1,0,0,210,1,0,0,235,1,0,0,5,2,0,0,32,2,0,0,61,2,0,0,84,2,0,0,
  105,2,0,0,123,2,0,0,141,2,0,0,159,2,0,0,177,2,0,0,201,2,0,0,224,2,0,0,247,2,
  0,0,14,3,0,0,31,3,0,0,48,3,0,0,65,3,0,0,91,3,0,0,117,3,0,0,138,3,0,0,158,3,0,
  0,166,3,0,0,175,3,0,0,184,3,0,0,192,3,0,0,200,3,0,0,206,3,0,0,207,3,0,0,208,
  3,0,0,209,3,0,0,210,3,0,0,211,3,0,0,212,3,0,0,213,3,0,0,214,3,0,0,215,3,0,0,
  216,3,0,0,217,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,51,2,69,69,71,71,255,36,3,0,0,0,109,109,50,3,69,69,71,73,73,255,36,4,
  0,0,0,107,103,103,49,5,69,69,71,73,75,73,73,255,36,5,109,109,107,107,100,0,0,
  49,5,69,69,73,75,66,68,68,255,35,7,107,107,109,103,107,97,109,3,3,49,5,69,69,
  75,66,66,68,68,255,34,11,109,109,107,107,69,103,100,109,107,3,3,103,103,49,5,
  71,71,70,66,66,73,73,255,33,14,66,66,109,107,73,69,94,100,109,107,3,3,103,
  103,103,103,49,5,71,71,66,66,68,73,73,255,32,21,66,66,103,109,3,0,66,100,97,
  75,107,3,3,103,103,100,103,103,3,66,68,73,73,255,32,22,66,66,103,109,103,107,
  66,107,77,103,71,3,3,103,103,103,100,103,3,66,68,69,73,73,255,34,20,109,109,
  66,100,66,66,75,103,71,66,66,98,100,103,103,103,103,66,68,69,73,73,255,33,21,
  66,66,103,67,66,66,66,103,71,67,66,66,66,100,100,100,66,66,66,68,69,73,73,
  255,32,22,66,66,103,103,103,66,66,66,66,67,67,66,66,98,100,103,100,66,66,67,
  68,69,73,73,255,32,1,66,66,66,34,19,73,73,103,69,67,67,67,67,67,67,67,100,
  103,66,66,67,67,67,68,73,73,255,35,18,73,73,73,71,69,69,68,68,68,68,100,103,
  66,66,67,67,68,73,109,109,255,37,16,73,73,73,73,71,103,68,68,103,100,66,66,
  67,69,103,107,109,109,255,41,13,109,109,108,106,103,66,66,67,69,69,103,107,
  109,71,71,255,42,13,109,109,108,3,100,67,68,69,69,103,107,109,107,71,71,255,
  42,13,107,107,107,108,3,67,68,69,69,103,108,109,107,73,73,255,43,13,107,107,
  109,106,67,68,69,74,106,108,109,108,107,73,73,255,43,13,107,107,109,106,67,
  100,100,100,108,108,109,108,107,73,73,59,2,75,75,75,75,255,43,18,107,107,109,
  106,100,66,66,100,103,3,108,109,108,107,73,73,73,75,75,75,255,43,18,107,107,
  108,103,66,66,66,66,66,103,3,108,109,109,108,108,108,107,75,75,255,43,18,108,
  108,106,66,66,66,66,66,66,66,103,3,0,109,109,109,109,109,75,75,255,43,12,71,
  71,103,66,66,66,67,67,67,67,66,3,3,3,255,43,12,71,71,68,69,69,69,67,67,67,67,
  66,100,3,3,255,43,12,71,71,68,3,71,71,70,70,69,67,67,66,3,3,255,43,15,71,71,
  69,69,107,73,73,73,72,70,69,67,100,3,103,103,103,60,2,74,74,74,74,255,43,3,
  71,71,69,73,73,48,14,75,75,75,75,73,73,71,69,67,67,100,103,103,71,71,71,255,
  43,3,71,71,70,75,75,53,9,73,73,71,69,69,69,69,69,71,71,71,255,43,3,72,72,73,
  75,75,54,8,73,73,73,73,71,71,71,71,71,71,255,43,3,73,73,75,77,77,255,42,4,0,
  0,74,75,0,0,255,42,4,0,0,75,77,0,0,255,42,3,0,0,77,77,77,255,42,3,0,0,0,0,0,
  255,43,1,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsc2c8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,31,1,0,0,40,1,0,0,56,1,0,0,74,1,0,0,94,1,0,0,117,1,0,0,143,1,0,0,
  173,1,0,0,203,1,0,0,234,1,0,0,11,2,0,0,44,2,0,0,71,2,0,0,95,2,0,0,116,2,0,0,
  136,2,0,0,153,2,0,0,171,2,0,0,188,2,0,0,205,2,0,0,222,2,0,0,239,2,0,0,2,3,0,
  0,22,3,0,0,41,3,0,0,63,3,0,0,85,3,0,0,102,3,0,0,123,3,0,0,143,3,0,0,163,3,0,
  0,178,3,0,0,192,3,0,0,200,3,0,0,206,3,0,0,207,3,0,0,208,3,0,0,209,3,0,0,210,
  3,0,0,211,3,0,0,212,3,0,0,213,3,0,0,214,3,0,0,215,3,0,0,216,3,0,0,217,3,0,0,
  218,3,0,0,219,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,40,3,0,0,0,109,109,255,40,4,0,0,0,107,103,103,255,40,5,109,109,107,107,
  100,0,0,60,2,68,68,68,68,255,39,6,107,107,109,103,107,97,109,109,59,3,68,68,
  68,68,68,255,38,8,109,109,107,107,69,103,100,109,107,107,59,3,68,68,71,103,
  103,255,37,9,66,66,109,107,73,69,94,98,109,107,107,57,5,68,68,68,71,103,3,3,
  255,36,11,66,66,103,109,3,0,66,98,97,75,107,103,103,55,6,68,68,68,71,103,3,3,
  3,255,35,14,66,66,103,103,108,103,107,66,107,77,103,71,3,103,103,103,52,7,68,
  68,68,68,71,103,3,3,3,255,38,20,106,106,66,100,66,66,75,103,71,3,103,103,103,
  103,68,68,71,103,103,3,107,107,63,1,66,66,66,255,37,20,66,66,103,67,66,66,66,
  103,71,67,103,103,103,100,103,103,3,103,3,107,107,107,62,2,66,66,67,67,255,
  35,20,66,66,66,103,103,103,66,66,66,66,67,67,66,103,103,103,100,103,3,106,
  107,107,60,4,66,66,67,67,69,69,255,36,19,103,103,103,73,103,69,67,67,67,67,
  67,66,66,103,103,103,103,3,107,109,109,58,5,66,66,67,67,69,71,71,255,39,22,
  73,73,73,71,69,69,68,68,68,68,100,103,103,100,100,66,66,66,66,66,67,68,71,71,
  255,41,19,73,73,73,71,69,68,68,100,103,103,67,67,67,67,67,67,68,68,69,71,71,
  255,43,16,73,73,71,68,100,103,103,67,67,67,69,69,69,69,69,69,71,71,255,43,15,
  109,109,71,68,103,100,67,67,67,69,69,69,69,71,71,71,71,255,43,12,109,109,107,
  106,103,66,67,67,69,69,71,71,109,109,255,42,13,109,109,109,109,107,3,100,67,
  68,69,69,3,107,109,109,255,42,12,109,109,109,109,108,106,3,67,68,69,69,3,106,
  106,255,41,12,108,108,109,109,109,108,107,3,67,68,69,71,106,106,255,41,12,
  108,108,108,109,109,108,107,3,67,69,71,71,107,107,255,41,12,108,108,108,109,
  108,107,106,103,103,103,72,107,74,74,255,41,14,108,108,108,108,107,3,66,66,
  69,69,3,107,109,74,74,74,255,41,15,108,108,108,107,106,103,66,66,68,68,69,3,
  108,109,74,74,74,255,42,14,108,108,106,3,66,66,69,69,69,69,71,107,109,109,74,
  74,255,42,11,72,72,3,66,70,68,69,69,69,69,71,107,107,54,2,109,109,107,107,
  255,42,11,70,70,66,68,71,68,69,69,69,69,71,107,107,54,2,109,109,109,109,255,
  42,12,70,70,70,68,74,71,71,71,69,69,71,107,3,3,255,42,3,70,70,70,75,75,48,9,
  72,72,72,69,69,71,71,3,3,3,3,255,42,3,71,71,72,77,77,49,8,72,72,69,69,69,69,
  69,72,71,71,255,41,4,0,0,74,75,0,0,50,7,72,72,72,72,72,71,69,71,71,255,41,4,
  0,0,75,77,0,0,55,2,69,69,71,71,255,41,3,0,0,77,77,77,55,2,72,72,72,72,255,41,
  3,0,0,0,0,0,255,42,1,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,
};
static const char dogsg6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,27,1,0,0,34,1,0,0,
  42,1,0,0,50,1,0,0,58,1,0,0,74,1,0,0,90,1,0,0,109,1,0,0,127,1,0,0,148,1,0,0,
  170,1,0,0,189,1,0,0,209,1,0,0,228,1,0,0,246,1,0,0,7,2,0,0,24,2,0,0,42,2,0,0,
  60,2,0,0,77,2,0,0,94,2,0,0,110,2,0,0,126,2,0,0,144,2,0,0,172,2,0,0,200,2,0,0,
  228,2,0,0,0,3,0,0,28,3,0,0,56,3,0,0,87,3,0,0,114,3,0,0,138,3,0,0,158,3,0,0,
  177,3,0,0,188,3,0,0,198,3,0,0,207,3,0,0,215,3,0,0,216,3,0,0,217,3,0,0,218,3,
  0,0,219,3,0,0,220,3,0,0,221,3,0,0,222,3,0,0,223,3,0,0,224,3,0,0,225,3,0,0,
  226,3,0,0,227,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,41,2,0,0,
  0,0,255,41,2,0,0,0,0,255,41,3,0,0,111,0,0,255,42,3,111,111,109,107,107,255,
  42,3,111,111,109,107,107,255,42,4,0,0,107,75,107,107,54,3,66,66,65,66,66,255,
  43,3,109,109,73,107,107,53,4,65,65,66,66,67,67,255,43,4,107,107,73,75,107,
  107,51,6,65,65,65,67,71,69,69,69,255,44,3,71,71,73,107,107,49,6,65,65,65,67,
  71,3,3,3,255,44,9,70,70,73,107,66,66,67,71,3,3,3,55,3,66,66,66,66,66,255,44,
  9,69,69,71,107,68,68,68,3,3,3,3,54,4,66,66,66,66,66,66,255,44,14,69,69,70,
  106,103,69,103,3,3,67,65,65,65,66,66,66,255,43,15,66,66,69,66,106,103,103,3,
  67,65,65,65,65,67,69,69,69,255,42,14,68,68,66,66,66,3,71,69,72,65,65,65,67,
  69,69,69,255,41,13,3,3,68,66,66,66,3,69,71,65,65,67,69,69,69,255,41,12,3,3,
  68,66,66,68,68,66,66,73,69,69,3,3,255,41,12,3,3,3,66,68,68,68,68,68,73,69,69,
  3,3,255,41,13,106,106,3,66,68,68,68,68,70,70,73,69,69,3,3,255,41,13,106,106,
  106,3,68,68,68,70,70,70,70,70,69,3,3,255,42,12,107,107,106,3,68,70,70,70,70,
  70,70,70,106,106,255,42,12,107,107,107,106,103,70,70,70,70,70,70,70,106,106,
  255,43,11,107,107,108,3,103,70,70,70,70,70,3,108,108,255,43,11,107,107,108,
  109,108,107,70,70,70,74,107,108,108,255,41,13,71,71,71,106,108,108,109,108,3,
  73,74,73,107,109,109,255,35,2,69,69,66,66,39,17,71,71,71,69,66,3,108,108,109,
  108,3,70,70,70,106,109,70,70,70,255,35,23,103,103,66,66,71,69,66,66,66,103,3,
  108,109,107,70,70,70,72,106,109,107,73,70,70,70,255,36,23,103,103,3,66,66,66,
  66,66,66,103,3,70,70,70,70,70,72,107,107,107,107,107,73,70,70,255,36,23,107,
  107,107,103,66,66,66,66,67,67,66,3,70,70,70,70,72,72,72,107,75,75,107,73,73,
  255,37,23,107,107,103,66,67,67,68,68,67,70,70,3,3,70,70,70,72,72,72,107,107,
  75,75,107,107,255,37,23,107,107,66,67,68,68,70,70,70,70,70,70,3,107,107,70,
  70,70,72,72,72,107,107,109,109,255,35,16,66,66,66,66,68,3,70,70,70,70,70,70,
  70,70,70,107,107,107,54,6,70,70,70,72,72,107,109,109,255,35,14,68,68,68,103,
  107,3,70,70,72,72,107,107,107,107,107,107,56,4,70,70,70,72,72,72,255,35,12,3,
  3,103,107,107,107,72,72,72,107,72,107,107,107,58,3,70,70,72,72,72,255,36,9,
  107,107,111,107,72,72,72,107,72,107,107,59,2,72,72,72,72,255,37,8,109,109,
  107,0,72,72,107,107,0,0,59,2,72,72,72,72,255,38,6,109,109,107,72,107,107,109,
  109,255,39,5,109,109,107,107,107,111,111,255,39,4,0,0,0,107,111,111,255,39,3,
  0,0,0,111,111,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsc4c6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,31,1,0,0,40,1,0,0,50,1,0,0,62,1,0,0,81,1,0,0,104,1,0,0,130,1,0,0,
  162,1,0,0,196,1,0,0,223,1,0,0,249,1,0,0,25,2,0,0,56,2,0,0,90,2,0,0,113,2,0,0,
  134,2,0,0,153,2,0,0,171,2,0,0,188,2,0,0,206,2,0,0,224,2,0,0,242,2,0,0,5,3,0,
  0,26,3,0,0,47,3,0,0,69,3,0,0,89,3,0,0,109,3,0,0,127,3,0,0,146,3,0,0,162,3,0,
  0,177,3,0,0,191,3,0,0,205,3,0,0,213,3,0,0,221,3,0,0,228,3,0,0,235,3,0,0,236,
  3,0,0,237,3,0,0,238,3,0,0,239,3,0,0,240,3,0,0,241,3,0,0,242,3,0,0,243,3,0,0,
  244,3,0,0,245,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,38,3,0,0,109,109,109,255,38,4,0,0,107,103,107,107,255,38,5,109,109,103,
  66,103,107,107,255,37,7,109,109,3,66,66,103,3,0,0,255,36,8,109,109,3,0,66,66,
  103,3,0,0,59,2,66,66,66,66,255,36,11,109,109,103,66,66,66,103,66,103,103,103,
  103,103,58,3,66,66,66,66,66,255,35,14,66,66,103,109,103,66,66,66,100,66,103,
  103,103,103,103,103,58,3,66,66,66,69,69,255,33,18,66,66,66,103,103,109,103,
  66,66,66,66,103,66,66,66,66,100,103,103,103,56,5,66,66,66,66,71,73,73,255,34,
  18,69,69,3,3,103,72,66,66,66,66,66,66,66,66,66,100,103,103,103,103,54,7,66,
  66,66,66,69,69,75,75,75,255,36,22,107,107,3,72,69,69,66,66,66,66,66,100,103,
  103,100,66,66,66,66,66,66,69,3,3,255,36,21,103,103,107,72,69,69,69,69,69,66,
  66,103,103,66,66,66,66,66,66,69,69,3,3,255,35,21,70,70,3,107,72,69,69,69,69,
  69,69,103,100,66,66,66,66,66,66,69,3,3,3,57,2,73,73,73,73,255,34,20,66,66,70,
  107,3,69,69,69,69,69,69,109,109,3,103,66,66,66,66,69,3,3,57,2,73,73,77,77,
  255,33,22,66,66,69,3,3,107,72,72,72,72,69,109,108,108,107,3,66,66,66,66,75,
  107,109,109,56,3,73,73,77,109,109,255,41,18,72,72,72,108,108,107,107,3,66,66,
  66,66,3,107,109,73,109,109,109,109,255,42,16,109,109,108,108,107,106,3,66,66,
  66,3,3,107,109,109,109,109,109,255,43,14,107,107,107,106,3,103,103,103,103,3,
  107,109,109,109,109,109,255,42,13,107,107,107,106,3,103,66,68,68,68,103,107,
  107,109,109,255,42,12,107,107,3,100,100,66,66,68,68,68,68,103,107,107,255,41,
  13,107,107,107,100,66,66,66,68,68,68,68,68,68,3,3,255,41,13,107,107,3,66,66,
  66,66,68,68,68,68,68,68,3,3,255,41,13,107,107,70,67,66,66,66,68,68,68,68,68,
  68,3,3,255,41,14,3,3,70,67,66,66,66,68,70,70,72,70,68,68,70,70,255,41,16,3,3,
  70,67,67,66,68,73,70,73,75,70,70,70,68,70,70,70,255,42,16,70,70,70,67,69,76,
  107,107,107,72,72,72,72,70,70,70,70,70,255,43,9,70,70,70,69,76,107,107,107,
  75,107,107,54,4,73,73,72,70,70,70,255,44,9,72,72,69,76,107,75,75,75,107,107,
  107,56,2,73,73,73,73,255,44,9,72,72,72,76,75,75,75,75,107,107,107,56,2,73,73,
  73,73,255,43,4,75,75,72,76,76,76,49,5,75,75,75,107,107,107,107,255,42,4,75,
  75,71,76,76,76,49,6,75,75,75,75,107,107,107,107,255,42,3,75,75,73,76,76,52,4,
  75,75,107,107,107,107,255,42,3,76,76,75,77,77,53,3,75,75,107,107,107,255,42,
  3,76,76,75,79,79,54,2,75,75,75,75,255,42,3,77,77,77,0,0,54,2,75,75,75,75,255,
  41,3,0,0,77,79,79,255,41,3,0,0,79,0,0,255,41,2,0,0,0,0,255,41,2,0,0,0,0,255,
  255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsg8[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  34,1,0,0,49,1,0,0,64,1,0,0,82,1,0,0,101,1,0,0,118,1,0,0,135,1,0,0,154,1,0,0,
  172,1,0,0,190,1,0,0,209,1,0,0,229,1,0,0,249,1,0,0,13,2,0,0,33,2,0,0,51,2,0,0,
  68,2,0,0,84,2,0,0,103,2,0,0,124,2,0,0,148,2,0,0,175,2,0,0,204,2,0,0,239,2,0,
  0,16,3,0,0,47,3,0,0,78,3,0,0,106,3,0,0,136,3,0,0,162,3,0,0,182,3,0,0,199,3,0,
  0,215,3,0,0,224,3,0,0,232,3,0,0,233,3,0,0,234,3,0,0,235,3,0,0,236,3,0,0,237,
  3,0,0,238,3,0,0,239,3,0,0,240,3,0,0,241,3,0,0,242,3,0,0,243,3,0,0,244,3,0,0,
  245,3,0,0,246,3,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  40,1,0,0,0,53,2,66,66,66,66,255,39,3,0,0,79,0,0,52,3,66,66,66,66,66,255,39,3,
  0,0,79,0,0,52,3,66,66,66,66,66,255,39,4,0,0,77,77,0,0,50,5,66,66,66,66,70,73,
  73,255,39,4,0,0,75,75,77,77,48,6,66,66,66,66,66,70,73,73,255,40,3,75,75,72,
  75,75,48,5,66,66,66,66,73,73,73,255,40,3,75,75,71,72,72,48,5,70,70,66,66,70,
  73,73,255,40,14,72,72,71,73,69,69,66,66,70,66,66,66,66,70,109,109,255,41,13,
  71,71,69,66,66,66,66,66,66,66,66,66,70,109,109,255,41,13,72,72,69,66,66,66,
  66,66,66,66,66,66,70,109,109,255,41,14,72,72,3,3,69,66,66,66,66,66,66,66,107,
  109,74,74,255,41,15,107,107,109,109,70,66,66,66,66,66,70,103,108,108,107,74,
  74,255,41,15,107,107,109,111,75,70,66,66,66,70,103,3,109,108,107,107,107,255,
  41,15,107,107,109,111,111,75,72,66,66,66,66,66,108,108,108,107,107,255,41,15,
  109,109,109,111,111,109,107,103,66,66,66,66,107,108,108,107,107,255,42,13,
  109,109,111,111,109,107,3,66,66,66,66,66,107,109,109,255,43,12,111,111,111,
  109,107,103,66,66,66,66,66,3,109,109,255,44,11,111,111,107,107,66,66,66,66,
  66,103,103,103,103,255,44,14,107,107,107,3,66,66,66,66,66,66,66,66,70,70,70,
  70,255,44,16,107,107,70,66,3,66,66,66,66,66,66,66,66,66,70,70,70,70,255,42,
  19,66,66,66,66,66,66,3,3,68,68,68,66,66,66,66,66,66,66,66,70,70,255,40,22,66,
  66,66,66,66,66,66,66,68,3,3,3,68,74,74,70,68,68,68,68,66,66,70,70,255,39,24,
  66,66,66,66,66,66,66,66,68,68,68,3,3,3,106,107,74,74,74,74,70,68,68,68,66,66,
  255,35,20,66,66,73,66,66,66,66,66,66,66,68,68,68,68,70,70,3,3,106,108,109,
  109,58,6,74,74,74,70,68,68,66,66,255,35,20,69,69,69,73,103,103,103,68,68,68,
  68,68,68,68,72,72,3,3,106,108,109,109,60,4,74,74,74,70,68,68,255,36,20,69,69,
  69,3,3,68,68,68,70,70,70,70,70,103,103,103,3,106,109,108,107,107,62,2,74,74,
  70,70,255,37,20,103,103,107,3,100,68,68,70,103,71,71,72,103,3,3,106,107,109,
  108,107,107,107,62,2,74,74,74,74,255,36,23,66,66,103,109,107,0,70,74,107,74,
  72,103,103,3,3,107,107,109,108,107,107,107,107,107,107,255,35,25,66,66,69,69,
  109,109,107,70,107,3,74,3,3,3,3,73,73,73,73,73,73,73,107,107,107,107,107,255,
  38,11,109,109,109,3,103,100,97,107,73,73,73,73,73,55,6,73,73,73,73,107,107,
  107,107,255,39,6,109,109,107,3,94,100,109,109,57,5,73,73,73,107,107,107,107,
  255,40,5,109,109,3,74,98,109,109,59,3,73,73,107,107,107,255,40,5,109,109,107,
  107,103,109,109,60,2,73,73,107,107,255,40,4,0,0,0,107,3,3,255,40,3,0,0,0,109,
  109,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsf6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,28,1,0,0,
  35,1,0,0,43,1,0,0,51,1,0,0,59,1,0,0,68,1,0,0,86,1,0,0,109,1,0,0,133,1,0,0,
  154,1,0,0,172,1,0,0,188,1,0,0,214,1,0,0,240,1,0,0,11,2,0,0,37,2,0,0,58,2,0,0,
  78,2,0,0,97,2,0,0,116,2,0,0,138,2,0,0,168,2,0,0,196,2,0,0,223,2,0,0,249,2,0,
  0,18,3,0,0,43,3,0,0,71,3,0,0,99,3,0,0,126,3,0,0,148,3,0,0,168,3,0,0,187,3,0,
  0,204,3,0,0,220,3,0,0,235,3,0,0,243,3,0,0,244,3,0,0,245,3,0,0,246,3,0,0,247,
  3,0,0,248,3,0,0,249,3,0,0,250,3,0,0,251,3,0,0,252,3,0,0,253,3,0,0,254,3,0,0,
  255,3,0,0,0,4,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,41,2,0,
  0,0,0,255,41,2,0,0,0,0,255,41,3,0,0,111,0,0,255,42,3,111,111,109,107,107,255,
  42,3,111,111,109,107,107,255,42,4,0,0,107,75,107,107,255,43,3,109,109,73,107,
  107,57,6,66,66,66,66,66,66,66,66,255,43,4,107,107,73,75,107,107,53,10,66,66,
  66,66,66,68,68,70,103,103,66,66,255,44,19,71,71,73,107,66,66,66,66,66,66,68,
  68,68,68,70,70,70,107,107,103,103,255,44,16,70,70,73,107,68,68,68,68,68,70,
  70,103,103,3,107,107,107,107,255,44,13,69,69,71,107,103,69,69,71,68,103,103,
  3,107,107,107,255,44,11,69,69,70,106,103,103,69,72,103,3,106,107,107,255,43,
  21,66,66,68,70,3,71,69,72,3,3,106,107,66,66,66,66,66,66,66,66,66,66,66,255,
  43,21,67,67,67,103,66,69,71,71,108,108,66,66,66,66,66,66,69,69,69,69,69,66,
  66,255,42,22,3,3,66,67,67,69,66,66,66,66,66,68,68,68,69,69,69,72,72,72,72,72,
  69,69,255,42,16,107,107,103,67,68,69,69,69,69,69,69,69,69,70,71,71,72,72,63,
  1,72,72,72,255,42,16,107,107,103,67,68,69,69,70,70,70,70,70,71,71,3,3,107,
  107,255,41,15,106,106,107,3,69,69,69,70,70,71,71,72,72,72,3,107,107,255,41,
  14,106,106,107,107,3,69,69,71,72,72,72,72,72,72,107,107,255,40,14,3,3,106,
  107,107,109,3,72,72,72,72,72,72,72,107,107,255,36,17,71,71,71,71,71,3,106,
  107,108,108,109,107,107,72,72,72,3,107,107,255,30,2,69,69,66,66,34,19,71,71,
  71,69,66,66,66,103,3,107,108,108,109,109,107,73,74,74,106,108,108,255,30,23,
  103,103,66,66,71,69,66,66,66,66,66,103,103,107,108,108,109,109,107,72,72,3,
  108,109,109,255,31,22,103,103,3,66,66,66,66,66,66,66,66,103,106,108,108,109,
  109,72,72,3,107,108,109,109,255,31,21,107,107,106,103,66,66,66,66,67,67,67,
  103,3,106,108,109,72,72,72,3,107,109,109,255,32,20,107,107,103,66,67,67,68,
  68,67,67,67,103,3,108,72,72,72,72,74,108,109,109,255,32,20,107,107,66,67,68,
  68,70,70,70,70,70,70,103,72,72,72,72,72,74,74,74,74,255,30,23,66,66,66,66,68,
  3,70,70,70,70,70,70,70,70,70,107,72,72,72,72,72,74,74,74,74,255,30,23,68,68,
  68,103,106,3,70,70,72,72,107,72,72,72,72,72,107,107,106,72,73,73,74,74,74,
  255,30,22,3,3,103,107,107,106,72,72,72,107,72,107,107,107,107,107,107,107,
  107,72,73,73,74,74,255,31,9,107,107,111,107,72,72,72,107,72,107,107,48,4,73,
  73,73,74,74,74,255,32,8,109,109,107,0,72,72,107,107,0,0,48,3,73,73,73,74,74,
  255,33,6,109,109,107,72,107,107,109,109,47,4,71,71,72,73,74,74,255,34,5,109,
  109,107,107,107,111,111,47,3,71,71,72,73,73,255,34,4,0,0,0,107,111,111,47,3,
  71,71,72,74,74,255,34,3,0,0,0,111,111,47,3,71,71,72,74,74,255,47,3,72,72,72,
  72,72,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsn0[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,21,1,0,0,27,1,0,0,34,1,0,0,48,1,0,0,63,1,0,0,79,1,0,0,93,1,0,0,
  107,1,0,0,122,1,0,0,137,1,0,0,155,1,0,0,172,1,0,0,189,1,0,0,205,1,0,0,221,1,
  0,0,237,1,0,0,253,1,0,0,14,2,0,0,31,2,0,0,48,2,0,0,65,2,0,0,82,2,0,0,98,2,0,
  0,114,2,0,0,130,2,0,0,147,2,0,0,164,2,0,0,181,2,0,0,198,2,0,0,215,2,0,0,231,
  2,0,0,247,2,0,0,7,3,0,0,23,3,0,0,39,3,0,0,55,3,0,0,71,3,0,0,87,3,0,0,102,3,0,
  0,116,3,0,0,130,3,0,0,143,3,0,0,159,3,0,0,167,3,0,0,176,3,0,0,185,3,0,0,194,
  3,0,0,202,3,0,0,211,3,0,0,219,3,0,0,226,3,0,0,233,3,0,0,240,3,0,0,246,3,0,0,
  252,3,0,0,2,4,0,0,255,255,255,255,255,255,255,59,1,186,186,186,255,59,1,186,
  186,186,255,58,2,186,186,189,189,255,56,4,109,109,109,186,189,189,63,1,185,
  185,185,255,55,5,107,107,187,187,109,189,189,63,1,185,185,185,255,55,5,107,
  107,187,109,109,189,189,62,2,188,188,185,185,255,55,9,107,107,189,109,109,
  189,68,70,73,185,185,255,55,9,107,107,189,109,109,68,70,70,73,185,185,255,54,
  10,107,107,66,73,109,109,103,70,73,188,185,185,255,54,10,107,107,66,71,109,
  103,103,70,73,188,185,185,255,51,13,66,66,103,107,107,74,74,74,103,103,73,
  103,189,185,185,255,52,12,66,66,103,74,66,68,70,103,3,73,3,189,185,185,255,
  52,12,66,66,74,74,66,66,70,73,107,107,3,189,187,187,255,53,11,74,74,66,66,66,
  66,70,107,109,107,189,187,187,255,53,11,74,74,65,66,73,66,70,109,109,109,189,
  187,187,255,53,11,66,66,65,66,73,66,70,109,109,109,189,185,185,255,53,11,66,
  66,65,66,71,66,70,109,109,109,47,185,185,255,52,12,66,66,65,65,66,71,70,70,
  109,109,109,47,185,185,255,52,12,66,66,65,65,66,70,73,107,107,109,109,47,185,
  185,255,52,12,66,66,65,65,66,70,73,107,107,109,109,47,185,185,255,52,12,66,
  66,65,65,66,70,73,107,107,109,109,107,187,187,255,52,12,66,66,65,65,66,70,73,
  107,107,109,109,107,187,187,255,52,11,66,66,65,65,66,70,107,3,107,109,109,
  107,107,255,52,11,179,179,65,65,66,71,107,3,107,109,109,107,107,255,52,11,
  179,179,65,65,71,69,103,3,107,109,109,3,3,255,52,12,182,182,65,65,65,69,103,
  3,107,109,109,71,71,71,255,52,12,184,184,65,65,66,66,103,3,107,109,109,71,71,
  71,255,52,12,66,66,65,65,65,66,103,3,107,109,109,71,72,72,255,52,12,66,66,65,
  65,66,66,103,3,107,109,109,72,73,73,255,52,12,66,66,66,65,65,66,3,107,107,
  109,103,73,74,74,255,53,11,66,66,66,66,66,103,107,107,109,103,73,75,75,255,
  53,11,66,66,66,66,66,100,3,107,109,109,74,75,75,255,53,11,69,69,66,66,66,100,
  3,107,66,69,71,75,75,255,53,11,69,69,66,66,66,66,3,107,66,69,71,75,75,255,53,
  11,69,69,66,66,66,66,3,107,66,69,107,75,75,255,53,11,69,69,66,66,66,66,103,
  107,66,3,75,75,75,255,53,11,69,69,66,66,66,66,66,109,66,3,75,75,75,255,53,11,
  69,69,66,66,66,66,66,66,66,107,75,75,75,255,54,10,69,69,66,66,66,66,66,66,
  107,75,75,75,255,54,9,69,69,69,66,66,66,66,66,107,75,75,255,54,9,70,70,71,69,
  66,66,66,70,107,75,75,255,55,8,69,69,71,72,72,70,107,75,75,75,255,55,3,70,70,
  71,73,73,59,4,72,72,72,75,75,75,255,56,3,69,69,71,73,73,255,56,4,70,70,71,73,
  75,75,255,57,4,71,71,73,74,75,75,255,58,4,73,73,75,77,77,77,255,59,3,75,75,
  77,77,77,255,59,4,75,75,77,77,0,0,255,60,3,75,75,77,0,0,255,61,2,77,77,77,77,
  255,61,2,77,77,0,0,255,61,2,0,0,0,0,255,62,1,0,0,0,255,62,1,0,0,0,255,62,1,0,
  0,0,255,255,
};
static const char dogse6[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,25,1,0,0,32,1,0,0,40,1,0,0,48,1,0,0,
  56,1,0,0,64,1,0,0,73,1,0,0,81,1,0,0,89,1,0,0,98,1,0,0,107,1,0,0,126,1,0,0,
  148,1,0,0,172,1,0,0,196,1,0,0,220,1,0,0,243,1,0,0,8,2,0,0,30,2,0,0,53,2,0,0,
  78,2,0,0,104,2,0,0,132,2,0,0,159,2,0,0,189,2,0,0,227,2,0,0,2,3,0,0,31,3,0,0,
  62,3,0,0,93,3,0,0,124,3,0,0,157,3,0,0,189,3,0,0,211,3,0,0,228,3,0,0,241,3,0,
  0,252,3,0,0,5,4,0,0,14,4,0,0,22,4,0,0,23,4,0,0,24,4,0,0,25,4,0,0,26,4,0,0,27,
  4,0,0,28,4,0,0,29,4,0,0,30,4,0,0,31,4,0,0,32,4,0,0,33,4,0,0,34,4,0,0,35,4,0,
  0,255,255,255,255,255,255,255,255,255,255,41,2,0,0,0,0,255,41,2,0,0,0,0,255,
  41,3,0,0,111,0,0,255,41,3,0,0,111,111,111,255,42,3,111,111,109,107,107,255,
  42,3,111,111,109,107,107,255,42,4,0,0,107,75,107,107,255,43,3,107,107,75,107,
  107,255,43,3,109,109,73,107,107,255,43,4,107,107,71,75,107,107,255,43,4,107,
  107,71,75,107,107,255,44,7,70,70,73,107,66,66,66,66,66,55,3,66,66,66,66,66,
  255,44,17,66,66,71,106,66,66,66,66,66,66,66,66,68,68,68,66,66,66,66,255,44,
  19,66,66,71,106,68,68,68,68,66,66,66,72,3,3,3,72,72,70,70,70,70,255,44,19,66,
  66,70,3,103,69,69,71,68,72,72,3,106,107,107,3,3,3,103,70,70,255,43,13,66,66,
  66,70,3,103,103,69,72,103,3,3,106,107,107,61,2,3,3,3,3,255,43,12,66,66,66,67,
  69,71,69,72,3,3,106,107,107,107,61,2,3,3,3,3,255,42,16,3,3,66,67,67,69,69,71,
  71,109,109,109,109,68,68,68,70,70,255,42,17,3,3,103,67,68,68,69,69,69,67,67,
  67,67,66,66,66,66,66,66,255,42,18,106,106,103,67,68,69,69,69,69,69,69,67,67,
  69,69,69,69,69,69,69,255,42,20,107,107,3,103,69,69,69,69,69,69,69,69,72,72,
  72,72,72,72,72,69,69,69,255,42,21,107,107,106,3,3,69,69,69,72,72,72,72,72,72,
  107,107,74,74,74,72,69,69,69,255,42,15,107,107,107,108,106,3,69,72,72,72,72,
  72,72,74,74,107,107,60,4,74,74,72,69,69,69,255,41,15,3,3,107,107,108,108,109,
  108,107,72,72,72,74,74,74,107,107,61,3,74,74,72,69,69,255,38,19,71,71,71,71,
  3,107,107,108,108,109,109,108,107,107,107,107,109,111,72,72,72,62,2,72,72,72,
  72,255,31,2,66,66,66,66,36,21,71,71,71,69,66,66,103,106,107,108,108,108,109,
  109,108,72,107,107,109,111,75,75,75,62,2,74,74,74,74,255,31,26,69,69,69,66,
  66,71,69,66,66,66,66,66,3,107,108,108,108,109,72,72,76,74,74,109,111,109,109,
  109,255,32,24,103,103,103,3,66,66,66,66,66,66,66,3,106,108,108,108,109,72,72,
  74,72,72,74,74,109,109,255,33,26,107,107,107,103,66,66,66,66,67,67,67,103,
  106,108,108,72,72,72,72,72,72,72,72,74,74,74,74,74,255,34,26,107,107,103,66,
  67,67,68,68,68,68,69,3,70,70,72,72,72,72,72,72,72,72,72,74,70,70,74,74,255,
  34,26,107,107,66,67,68,68,70,70,70,70,70,70,3,70,72,72,72,72,72,107,72,72,72,
  74,74,72,74,74,255,33,19,66,66,66,66,3,70,70,70,70,70,70,70,70,70,107,107,72,
  72,107,107,107,55,5,74,74,72,72,74,74,74,255,32,19,66,66,66,103,107,3,70,70,
  72,72,72,72,72,72,72,74,107,107,107,107,107,56,4,74,74,74,74,74,74,255,31,17,
  66,66,69,103,107,107,107,72,72,72,107,107,107,72,74,74,74,76,76,255,32,12,3,
  3,107,111,107,72,72,72,107,72,107,107,107,107,255,34,8,109,109,107,0,72,72,
  107,107,109,109,255,36,6,107,107,72,107,107,109,109,109,255,37,4,107,107,107,
  107,111,111,255,37,4,0,0,109,107,111,111,255,37,3,0,0,0,111,111,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsd3d7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,25,1,0,0,34,1,0,0,43,1,0,0,53,1,0,0,64,1,0,0,
  75,1,0,0,88,1,0,0,101,1,0,0,116,1,0,0,134,1,0,0,155,1,0,0,177,1,0,0,201,1,0,
  0,221,1,0,0,241,1,0,0,7,2,0,0,29,2,0,0,51,2,0,0,75,2,0,0,98,2,0,0,120,2,0,0,
  143,2,0,0,164,2,0,0,185,2,0,0,206,2,0,0,231,2,0,0,1,3,0,0,27,3,0,0,52,3,0,0,
  75,3,0,0,98,3,0,0,120,3,0,0,141,3,0,0,159,3,0,0,176,3,0,0,192,3,0,0,206,3,0,
  0,215,3,0,0,224,3,0,0,232,3,0,0,240,3,0,0,248,3,0,0,0,4,0,0,8,4,0,0,16,4,0,0,
  25,4,0,0,33,4,0,0,41,4,0,0,49,4,0,0,56,4,0,0,63,4,0,0,64,4,0,0,65,4,0,0,66,4,
  0,0,255,255,255,255,255,255,255,255,255,40,3,0,0,0,107,107,255,40,4,0,0,0,3,
  107,107,255,40,4,109,109,109,103,107,107,255,40,5,109,109,107,103,3,107,107,
  255,39,6,109,109,109,103,66,3,107,107,255,39,6,109,109,107,66,66,103,107,107,
  255,38,8,109,109,107,0,66,66,103,106,107,107,255,38,8,109,109,103,100,66,66,
  103,66,107,107,255,37,10,109,109,109,103,66,66,66,100,66,103,107,107,255,36,
  13,66,66,109,107,103,66,66,66,66,103,66,106,107,107,107,255,35,16,66,66,103,
  68,107,3,103,100,66,66,66,66,3,106,107,107,107,107,255,35,17,66,66,66,103,
  107,3,103,100,66,66,66,66,103,103,103,3,106,107,107,255,35,2,66,66,107,107,
  39,13,72,72,70,68,66,66,66,66,66,100,100,103,3,107,107,255,39,15,72,72,70,68,
  68,66,66,66,66,66,66,103,103,109,107,71,71,255,40,15,72,72,70,70,68,66,66,66,
  66,66,100,103,103,109,73,71,71,255,41,17,72,72,72,70,70,66,66,66,66,66,100,
  103,109,107,73,73,71,71,71,255,42,17,72,72,72,70,70,100,100,103,103,103,66,
  71,109,107,107,107,73,73,73,255,42,17,109,109,107,107,106,106,103,103,103,66,
  66,71,109,107,107,107,107,73,73,255,43,12,109,109,109,109,107,106,103,66,66,
  66,71,109,109,109,56,3,107,107,107,73,73,255,43,12,111,111,111,111,109,107,
  66,66,66,66,68,71,109,109,57,2,107,107,107,107,255,43,12,109,109,109,109,109,
  109,103,66,69,66,66,68,71,71,60,1,73,73,73,255,43,18,111,111,111,111,111,109,
  106,66,71,66,66,66,68,68,68,68,71,73,73,73,255,44,16,109,109,109,109,107,66,
  66,71,66,66,66,66,66,66,66,71,73,73,255,43,16,107,107,108,109,108,106,66,66,
  69,71,71,71,71,71,71,73,71,71,255,43,16,107,107,108,108,106,103,66,66,69,3,
  107,109,107,107,107,68,71,71,255,43,14,107,107,107,107,3,103,66,66,69,3,109,
  107,107,107,107,107,60,2,70,70,70,70,255,42,15,107,107,107,107,106,103,66,66,
  69,103,107,109,107,107,107,107,107,60,2,70,70,70,70,255,42,14,107,107,107,
  107,106,103,69,71,107,107,107,107,107,107,107,107,59,3,70,70,70,70,70,255,42,
  13,107,107,107,106,3,103,69,64,64,65,65,70,70,107,107,58,3,70,70,70,69,69,
  255,42,18,107,107,107,3,103,67,64,65,65,65,65,65,66,66,107,69,69,69,70,70,
  255,42,18,107,107,107,103,66,65,65,65,65,66,66,66,66,66,69,69,69,70,73,73,
  255,42,17,107,107,106,103,66,65,65,65,66,66,69,69,69,69,69,69,70,73,73,255,
  42,16,106,106,106,66,66,65,65,66,66,69,69,69,70,70,70,70,73,73,255,42,13,3,3,
  3,66,66,65,66,66,69,69,70,70,71,73,73,255,42,12,70,70,66,66,66,66,66,66,69,
  70,70,71,73,73,255,42,11,70,70,66,66,66,66,69,69,70,70,71,73,73,255,43,9,69,
  69,66,74,66,69,71,71,72,73,73,255,43,4,71,71,69,103,74,74,255,43,4,72,72,69,
  71,74,74,255,43,3,72,72,69,74,74,255,43,3,74,74,71,74,74,255,42,3,74,74,71,
  74,74,255,42,3,74,74,72,74,74,255,42,3,74,74,74,74,74,255,41,3,75,75,77,77,
  77,255,40,4,75,75,77,77,0,0,255,40,3,77,77,77,77,77,255,40,3,0,0,77,0,0,255,
  40,3,0,0,0,0,0,255,40,2,0,0,0,0,255,40,2,0,0,0,0,255,255,255,255,255,
};
static const char dogsh7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,24,1,0,0,33,1,0,0,43,1,0,0,54,1,0,0,64,1,0,0,74,1,0,0,
  83,1,0,0,91,1,0,0,99,1,0,0,107,1,0,0,120,1,0,0,135,1,0,0,152,1,0,0,170,1,0,0,
  193,1,0,0,217,1,0,0,242,1,0,0,12,2,0,0,39,2,0,0,66,2,0,0,94,2,0,0,123,2,0,0,
  148,2,0,0,171,2,0,0,193,2,0,0,216,2,0,0,233,2,0,0,2,3,0,0,29,3,0,0,54,3,0,0,
  80,3,0,0,106,3,0,0,130,3,0,0,154,3,0,0,180,3,0,0,204,3,0,0,227,3,0,0,244,3,0,
  0,1,4,0,0,13,4,0,0,24,4,0,0,35,4,0,0,45,4,0,0,54,4,0,0,63,4,0,0,71,4,0,0,72,
  4,0,0,73,4,0,0,74,4,0,0,75,4,0,0,76,4,0,0,77,4,0,0,78,4,0,0,79,4,0,0,80,4,0,
  0,255,255,255,255,255,255,255,255,38,3,0,0,0,0,0,255,38,4,0,0,0,0,79,79,255,
  38,5,0,0,79,79,77,77,77,255,38,6,0,0,77,77,77,73,73,73,255,39,5,77,77,76,73,
  73,70,70,255,40,5,76,76,73,70,71,71,71,255,41,4,72,72,70,71,70,70,255,42,3,
  71,71,68,70,70,255,42,3,69,69,68,69,69,255,42,3,69,69,68,66,66,255,42,8,69,
  69,66,103,66,66,66,66,66,66,255,42,10,66,66,66,66,66,66,66,66,66,66,66,66,
  255,41,12,107,107,66,66,66,66,66,66,66,66,66,66,66,66,255,41,13,107,107,3,66,
  66,66,66,66,66,66,66,66,66,66,66,255,40,18,107,107,107,107,3,66,66,68,68,66,
  66,66,66,66,66,66,66,66,66,66,255,40,19,107,107,107,108,3,66,66,69,68,68,68,
  68,68,68,68,68,68,68,68,68,68,255,40,20,107,107,108,109,107,3,66,69,69,69,69,
  69,69,69,69,69,69,69,68,68,68,68,255,40,21,107,107,109,109,109,107,3,66,69,
  69,69,69,70,70,70,70,70,70,70,70,70,70,70,255,40,22,107,107,109,109,109,109,
  106,103,66,73,73,73,73,73,73,107,107,107,107,71,71,70,70,70,255,41,15,109,
  109,109,109,109,107,103,66,69,107,107,107,107,107,107,74,74,59,3,71,71,71,70,
  70,255,41,16,109,109,109,109,109,107,3,66,66,69,3,107,109,107,107,107,74,74,
  59,3,74,74,71,71,71,255,41,18,109,109,109,109,109,109,106,103,66,69,69,3,109,
  107,107,107,107,73,73,73,60,2,74,74,71,71,255,42,20,109,109,109,109,109,107,
  103,66,66,69,71,71,73,73,73,73,66,68,71,74,74,74,255,42,18,109,109,109,109,
  109,107,3,66,66,71,69,66,66,66,66,66,73,68,73,73,255,43,17,111,111,111,111,
  109,106,66,66,66,66,66,68,68,68,68,68,68,73,73,255,42,18,107,107,107,107,109,
  109,106,66,66,66,66,66,71,71,71,71,71,71,73,73,255,43,12,111,111,111,111,111,
  103,66,66,66,66,69,71,107,107,255,42,13,107,107,107,107,107,106,103,66,66,66,
  69,71,107,107,107,57,3,107,107,107,75,75,255,41,14,107,107,107,107,106,3,103,
  103,103,103,103,103,3,107,107,107,56,4,107,107,107,107,75,75,255,40,20,69,69,
  69,66,66,66,66,66,3,3,3,3,3,106,107,107,107,107,107,107,75,75,255,38,21,69,
  69,69,66,66,66,66,66,66,66,66,69,69,3,106,107,107,107,107,107,107,75,75,255,
  37,21,69,69,66,66,66,66,66,66,66,69,69,69,69,69,3,106,107,107,74,74,74,74,74,
  255,36,19,69,69,66,66,66,66,66,66,66,69,69,69,69,70,103,3,106,107,107,74,74,
  255,35,19,109,109,66,68,68,66,66,66,66,69,69,70,70,70,103,3,106,107,107,107,
  107,255,32,21,66,66,66,68,68,68,3,103,70,66,66,66,70,71,71,71,71,3,106,107,
  107,107,107,255,33,19,66,66,68,3,3,3,103,70,66,66,69,71,103,3,3,3,106,107,
  107,107,107,255,32,18,66,66,71,71,109,109,103,68,66,66,69,103,103,3,107,107,
  107,107,107,107,255,33,12,68,68,68,109,109,3,68,68,68,103,71,3,107,107,255,
  36,8,109,109,107,100,68,68,103,71,107,107,255,36,7,109,109,107,0,70,69,103,
  109,109,255,37,6,109,109,109,70,70,103,109,109,255,37,6,109,109,109,3,70,3,
  111,111,255,38,5,109,109,107,3,107,111,111,255,38,4,109,109,109,107,109,109,
  255,38,4,0,0,0,107,111,111,255,38,3,0,0,0,111,111,255,255,255,255,255,255,
  255,255,255,255,255,
};
static const char dogsi0[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,21,1,0,0,22,1,0,0,
  23,1,0,0,24,1,0,0,25,1,0,0,44,1,0,0,69,1,0,0,91,1,0,0,114,1,0,0,139,1,0,0,
  168,1,0,0,198,1,0,0,230,1,0,0,6,2,0,0,41,2,0,0,78,2,0,0,116,2,0,0,140,2,0,0,
  169,2,0,0,192,2,0,0,220,2,0,0,247,2,0,0,22,3,0,0,53,3,0,0,78,3,0,0,108,3,0,0,
  133,3,0,0,157,3,0,0,180,3,0,0,202,3,0,0,219,3,0,0,234,3,0,0,247,3,0,0,0,4,0,
  0,9,4,0,0,18,4,0,0,27,4,0,0,37,4,0,0,46,4,0,0,55,4,0,0,63,4,0,0,71,4,0,0,77,
  4,0,0,78,4,0,0,79,4,0,0,80,4,0,0,81,4,0,0,82,4,0,0,83,4,0,0,84,4,0,0,85,4,0,
  0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,32,2,
  66,66,103,103,38,3,71,71,71,71,71,48,1,187,187,187,255,32,15,71,71,66,103,
  103,107,68,68,68,71,71,70,70,70,70,70,70,51,1,187,187,187,255,33,17,71,71,
  107,107,103,3,68,65,103,103,66,103,70,70,70,70,70,187,187,255,34,18,71,71,
  109,103,109,65,107,107,107,107,3,3,103,103,103,103,70,70,70,70,255,34,20,71,
  71,109,107,103,111,3,103,103,107,97,3,3,103,100,103,103,3,3,70,70,70,255,35,
  24,109,109,109,107,111,0,103,109,107,187,0,3,103,103,103,100,103,3,3,103,70,
  70,70,70,70,70,255,35,25,109,109,109,107,111,0,103,109,107,187,0,3,103,103,
  100,103,103,103,3,3,103,103,103,103,103,70,70,255,34,27,71,71,109,107,103,
  111,3,103,103,107,97,3,3,66,103,103,103,103,103,3,109,3,3,3,3,103,70,72,72,
  255,34,27,71,71,109,103,109,66,109,109,109,107,3,3,66,103,103,103,103,103,
  103,3,109,109,109,109,3,3,70,72,72,255,33,22,66,66,107,107,103,107,68,69,103,
  103,69,66,66,179,184,103,103,66,66,66,66,69,72,72,57,4,109,109,3,72,72,72,
  255,32,24,66,66,66,103,103,107,103,73,73,73,73,71,109,109,184,184,189,66,66,
  66,66,66,66,69,72,72,58,4,72,72,72,75,75,75,255,32,2,71,71,71,71,38,3,75,75,
  75,75,75,42,20,181,181,109,103,103,188,47,189,66,71,66,66,66,66,66,69,69,69,
  69,75,75,75,255,43,19,109,109,109,183,179,188,181,66,68,71,66,66,66,66,66,66,
  66,66,72,107,107,255,38,1,184,184,184,43,19,109,109,109,189,185,181,185,66,
  68,71,66,66,66,66,66,66,66,66,72,107,107,255,43,18,109,109,179,109,107,185,
  103,66,68,70,75,75,75,75,75,75,66,69,75,75,255,40,2,183,183,179,179,43,17,
  109,109,109,109,107,3,103,66,68,70,107,109,107,107,107,107,75,75,75,255,41,
  17,183,183,109,109,109,109,107,3,103,66,68,70,107,109,107,107,107,107,107,61,
  1,66,66,66,255,39,1,179,179,179,42,15,109,109,109,109,109,107,3,103,66,68,70,
  107,109,107,107,107,107,60,2,66,66,66,66,255,39,1,183,183,183,42,14,181,181,
  181,109,109,107,3,103,66,68,103,107,109,107,107,107,59,3,66,66,66,66,66,255,
  41,13,109,109,181,187,109,109,107,3,103,103,103,103,107,109,109,59,3,66,66,
  66,70,70,255,35,1,183,183,183,41,20,109,109,109,109,109,107,107,103,103,68,
  68,68,68,68,103,103,103,103,66,66,70,70,255,41,20,109,109,109,109,107,107,
  103,68,66,66,66,66,66,66,66,66,66,66,66,70,73,73,255,41,19,109,109,109,107,
  107,103,66,66,66,66,66,66,66,66,66,66,66,66,70,73,73,255,41,18,109,109,109,
  107,103,66,66,66,66,68,68,68,68,68,68,68,68,70,73,73,255,41,17,109,109,109,
  66,103,66,66,68,68,68,68,68,68,68,70,70,73,73,73,255,42,12,109,109,66,66,66,
  68,68,68,68,68,68,70,73,73,255,42,10,70,70,66,70,66,68,68,68,70,70,73,73,255,
  42,8,70,70,66,103,70,73,73,73,73,73,255,42,4,70,70,66,66,70,70,255,41,4,70,
  70,66,66,73,73,255,41,4,70,70,66,71,73,73,255,40,4,74,74,70,70,77,77,255,39,
  5,77,77,71,72,77,77,77,255,39,4,0,0,74,75,0,0,255,39,4,0,0,75,77,0,0,255,39,
  3,0,0,77,77,77,255,39,3,0,0,0,0,0,255,40,1,0,0,0,255,255,255,255,255,255,255,
  255,255,255,
};
static const char dogsa3a7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,26,1,0,0,35,1,0,0,44,1,0,0,55,1,0,0,
  66,1,0,0,78,1,0,0,91,1,0,0,105,1,0,0,125,1,0,0,149,1,0,0,172,1,0,0,198,1,0,0,
  228,1,0,0,255,1,0,0,25,2,0,0,49,2,0,0,71,2,0,0,93,2,0,0,115,2,0,0,136,2,0,0,
  158,2,0,0,174,2,0,0,190,2,0,0,212,2,0,0,235,2,0,0,4,3,0,0,33,3,0,0,61,3,0,0,
  89,3,0,0,116,3,0,0,140,3,0,0,164,3,0,0,187,3,0,0,209,3,0,0,230,3,0,0,250,3,0,
  0,15,4,0,0,27,4,0,0,35,4,0,0,43,4,0,0,51,4,0,0,60,4,0,0,69,4,0,0,78,4,0,0,86,
  4,0,0,95,4,0,0,103,4,0,0,112,4,0,0,120,4,0,0,128,4,0,0,135,4,0,0,136,4,0,0,
  137,4,0,0,255,255,255,255,255,255,255,255,255,255,39,3,0,0,0,107,107,255,39,
  4,0,0,0,3,107,107,255,39,4,109,109,109,103,107,107,255,38,6,109,109,107,103,
  103,3,107,107,255,38,6,109,109,107,66,70,3,107,107,255,37,7,109,109,107,103,
  66,68,3,107,107,255,36,8,109,109,107,0,66,66,68,3,107,107,255,36,9,109,109,
  103,100,66,66,68,66,106,107,107,255,33,15,66,66,66,109,109,103,66,66,66,100,
  66,103,106,107,107,107,107,255,32,19,66,66,3,107,109,107,103,66,66,66,66,103,
  70,103,3,106,107,107,107,107,107,255,34,18,66,66,66,107,3,103,100,66,66,66,
  66,100,103,103,103,3,106,107,107,107,255,33,21,66,66,66,66,107,3,103,100,66,
  66,66,66,66,66,100,100,103,103,3,106,70,72,72,255,33,3,3,3,107,107,107,37,18,
  72,72,70,68,66,66,66,66,66,66,66,66,66,100,103,3,77,75,72,72,255,37,22,72,72,
  70,68,68,66,66,66,66,66,66,66,66,100,100,103,107,77,75,75,66,68,72,72,255,38,
  21,72,72,70,70,68,66,66,66,66,66,66,100,103,103,103,3,77,77,68,66,68,72,72,
  255,40,19,72,72,70,70,66,66,66,100,100,103,66,66,66,103,76,72,66,66,68,72,72,
  255,42,17,72,72,103,103,103,103,103,100,66,66,66,66,76,67,66,76,70,76,76,255,
  42,17,107,107,107,3,103,103,100,66,66,66,66,66,66,66,67,72,72,76,76,255,42,
  17,107,107,107,106,3,66,66,66,66,103,66,66,66,66,76,76,76,77,77,255,43,16,
  107,107,107,106,100,66,66,66,76,66,66,67,76,77,77,77,77,77,255,43,11,107,107,
  107,106,3,66,66,66,70,76,66,76,76,56,2,77,77,77,77,255,43,11,107,107,107,106,
  3,66,66,67,67,103,76,107,107,255,43,11,107,107,107,106,3,66,67,67,67,103,106,
  107,107,255,43,11,107,107,107,106,3,66,67,67,67,103,106,107,107,60,2,77,77,
  107,107,255,43,11,107,107,107,106,3,66,68,68,68,103,106,107,107,59,3,77,77,
  77,107,107,255,42,20,107,107,107,107,106,3,66,68,68,71,103,106,107,77,77,77,
  77,77,77,77,107,107,255,42,19,107,107,107,107,106,3,66,70,70,71,103,106,77,
  77,77,77,77,77,77,77,77,62,1,66,66,66,255,42,17,107,107,107,107,106,3,3,3,3,
  71,103,77,77,77,77,77,77,77,77,61,2,66,66,70,70,255,42,16,107,107,107,107,
  106,103,103,103,3,3,107,77,77,77,77,77,77,77,60,3,66,66,66,70,70,255,42,14,
  107,107,107,106,103,100,66,66,100,103,3,107,77,77,77,77,59,4,66,66,66,70,70,
  70,255,42,12,107,107,107,3,66,66,66,66,66,100,100,3,107,107,58,3,100,100,66,
  70,70,255,42,19,107,107,103,66,66,66,66,66,66,66,100,103,107,107,3,100,100,
  66,66,70,70,255,42,18,71,71,100,66,66,66,66,66,66,66,66,100,103,107,100,100,
  66,66,72,72,255,43,17,66,66,66,66,66,66,66,66,66,66,66,100,103,66,66,66,70,
  72,72,255,43,16,70,70,66,66,66,66,66,66,66,66,66,66,66,66,66,70,72,72,255,43,
  15,71,71,66,66,66,66,66,66,66,68,68,66,66,66,70,72,72,255,44,8,70,70,66,103,
  68,68,68,68,72,72,53,4,70,70,70,70,72,72,255,44,7,73,73,66,69,72,72,72,72,72,
  255,44,3,74,74,69,75,75,255,44,3,75,75,69,75,75,255,44,3,75,75,69,75,75,255,
  43,4,75,75,72,71,75,75,255,43,4,75,75,72,71,75,75,255,43,4,75,75,72,76,75,75,
  255,43,3,75,75,76,0,0,255,42,4,75,75,0,76,0,0,255,42,3,0,0,0,0,0,255,41,4,0,
  0,0,0,0,0,255,41,3,0,0,0,0,0,255,41,3,0,0,0,0,0,255,41,2,0,0,0,0,255,255,255,
  255,
};
static const char dogsb3b7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,26,1,0,0,41,1,0,0,58,1,0,0,77,1,0,0,
  96,1,0,0,116,1,0,0,136,1,0,0,158,1,0,0,185,1,0,0,213,1,0,0,241,1,0,0,12,2,0,
  0,42,2,0,0,65,2,0,0,87,2,0,0,107,2,0,0,126,2,0,0,144,2,0,0,162,2,0,0,179,2,0,
  0,196,2,0,0,213,2,0,0,230,2,0,0,246,2,0,0,6,3,0,0,22,3,0,0,38,3,0,0,55,3,0,0,
  72,3,0,0,90,3,0,0,108,3,0,0,126,3,0,0,144,3,0,0,162,3,0,0,187,3,0,0,210,3,0,
  0,233,3,0,0,253,3,0,0,18,4,0,0,43,4,0,0,66,4,0,0,85,4,0,0,93,4,0,0,101,4,0,0,
  110,4,0,0,118,4,0,0,126,4,0,0,134,4,0,0,141,4,0,0,148,4,0,0,149,4,0,0,150,4,
  0,0,151,4,0,0,255,255,255,255,255,255,255,255,255,255,37,3,0,0,0,107,107,255,
  37,4,0,0,0,3,107,107,55,2,66,66,67,67,255,37,4,109,109,109,103,107,107,53,4,
  73,73,66,67,68,68,255,37,5,109,109,107,103,3,107,107,52,5,73,73,70,66,68,71,
  71,255,36,6,109,109,109,103,66,3,107,107,52,4,73,73,66,66,73,73,255,36,6,109,
  109,107,66,66,103,107,107,51,5,73,73,73,66,68,73,73,255,35,7,109,109,107,0,
  66,66,103,106,106,51,4,73,73,70,66,69,69,255,35,9,109,109,103,100,66,66,103,
  66,106,107,107,51,4,73,73,66,66,71,71,255,33,14,68,68,109,109,103,66,66,66,
  100,66,103,106,107,107,107,107,51,4,73,73,66,67,71,71,255,32,23,66,66,107,
  109,107,103,66,66,66,66,103,66,103,3,106,107,107,107,107,73,70,66,67,73,73,
  255,32,23,66,66,103,68,107,3,103,100,66,66,66,66,100,103,103,103,3,106,107,
  107,66,66,68,73,73,255,33,22,66,66,103,107,3,103,100,66,66,66,66,66,66,100,
  100,103,103,3,107,66,66,69,73,73,255,33,2,66,66,107,107,36,19,72,72,70,68,66,
  66,66,66,66,66,66,66,66,100,103,71,66,66,69,73,73,255,36,18,72,72,70,68,68,
  66,66,66,66,66,66,66,100,100,66,66,66,67,73,73,255,37,17,72,72,70,70,68,66,
  66,66,66,66,100,103,66,66,66,66,68,73,73,255,39,15,72,72,70,70,66,66,66,100,
  103,103,66,66,66,66,68,73,73,255,40,14,107,107,72,103,103,103,103,103,66,66,
  66,66,69,69,73,73,255,41,13,107,107,106,3,3,103,66,66,66,66,71,71,73,73,73,
  255,41,13,107,107,107,106,3,100,66,66,66,67,67,103,76,107,107,255,42,12,107,
  107,107,106,103,66,66,67,67,67,103,106,107,107,255,42,12,107,107,107,107,3,
  100,66,67,67,67,103,106,107,107,255,42,12,107,107,107,107,106,103,66,68,68,
  68,103,106,107,107,255,42,12,107,107,107,107,106,103,66,68,68,69,103,106,107,
  107,255,42,11,107,107,107,107,106,103,66,68,68,69,3,107,107,255,42,11,107,
  107,107,107,106,3,66,68,68,69,106,107,107,255,42,11,107,107,107,107,106,3,66,
  68,68,70,106,108,108,255,42,11,107,107,107,107,106,3,66,68,70,71,107,108,108,
  255,42,12,107,107,107,107,106,3,103,103,71,74,108,108,75,75,255,42,12,107,
  107,107,106,3,103,100,100,103,3,108,109,75,75,255,42,13,107,107,106,3,103,66,
  66,66,68,103,107,108,107,75,75,255,42,13,3,3,103,100,66,66,66,66,66,68,3,108,
  109,75,75,255,42,13,3,3,100,66,66,66,66,66,66,66,68,107,108,107,107,255,43,
  13,66,66,66,66,66,66,66,66,66,66,70,107,109,75,75,255,43,13,68,68,66,66,66,
  66,66,66,66,66,68,3,108,107,107,255,43,14,70,70,66,66,66,66,66,66,66,66,66,3,
  107,109,107,107,60,2,73,73,107,107,255,44,18,68,68,66,103,68,68,66,66,66,66,
  69,3,109,108,107,75,73,107,107,107,255,44,18,70,70,66,69,72,66,66,66,66,66,
  66,3,108,108,108,107,107,109,109,109,255,44,3,74,74,69,75,75,48,8,72,72,69,
  66,66,66,66,66,103,103,255,44,3,75,75,69,75,75,49,9,72,72,72,69,66,66,66,66,
  103,103,103,255,44,3,75,75,69,75,75,52,7,69,69,66,66,66,66,69,69,69,61,2,66,
  66,66,66,255,44,3,75,75,71,75,75,52,11,72,72,72,72,69,69,66,66,66,66,66,66,
  66,255,44,3,75,75,71,77,77,56,7,72,72,72,72,72,72,72,72,72,255,44,3,75,75,76,
  77,77,255,44,3,75,75,77,77,77,255,43,4,75,75,77,77,0,0,255,43,3,77,77,77,77,
  77,255,43,3,0,0,77,0,0,255,43,3,0,0,0,0,0,255,43,2,0,0,0,0,255,43,2,0,0,0,0,
  255,255,255,255,255,
};
static const char dogsf7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,20,1,
  0,0,28,1,0,0,36,1,0,0,45,1,0,0,53,1,0,0,60,1,0,0,75,1,0,0,93,1,0,0,115,1,0,0,
  138,1,0,0,159,1,0,0,178,1,0,0,204,1,0,0,228,1,0,0,252,1,0,0,16,2,0,0,35,2,0,
  0,53,2,0,0,71,2,0,0,88,2,0,0,104,2,0,0,119,2,0,0,134,2,0,0,150,2,0,0,166,2,0,
  0,182,2,0,0,198,2,0,0,215,2,0,0,232,2,0,0,250,2,0,0,12,3,0,0,30,3,0,0,50,3,0,
  0,72,3,0,0,95,3,0,0,119,3,0,0,143,3,0,0,168,3,0,0,196,3,0,0,223,3,0,0,251,3,
  0,0,19,4,0,0,39,4,0,0,59,4,0,0,79,4,0,0,99,4,0,0,117,4,0,0,126,4,0,0,135,4,0,
  0,143,4,0,0,144,4,0,0,145,4,0,0,146,4,0,0,147,4,0,0,148,4,0,0,149,4,0,0,150,
  4,0,0,151,4,0,0,255,255,255,255,255,42,2,0,0,0,0,255,42,3,0,0,0,0,0,255,42,3,
  0,0,79,79,79,255,42,4,0,0,77,77,77,77,255,43,3,77,77,76,73,73,255,44,2,76,76,
  73,73,255,44,3,76,76,70,71,71,61,3,66,66,66,66,66,255,44,3,72,72,70,71,71,58,
  6,66,66,66,66,66,66,66,66,255,44,3,71,71,69,70,70,54,10,68,68,66,66,66,66,66,
  66,66,66,66,66,255,44,3,71,71,68,70,70,53,11,68,68,68,66,66,66,66,66,103,107,
  107,66,66,255,44,3,69,69,68,69,69,51,9,68,68,68,68,66,66,73,107,107,107,107,
  255,44,14,69,69,68,66,68,68,68,68,66,66,66,66,73,107,107,107,255,44,14,69,69,
  66,103,68,68,66,66,66,66,66,68,73,107,107,107,59,3,73,73,75,76,76,255,43,19,
  69,69,66,66,69,66,66,66,66,66,66,66,100,107,107,76,76,76,76,107,107,255,43,
  19,69,69,66,66,66,66,66,66,66,66,66,68,103,107,107,107,107,107,107,107,107,
  255,43,15,69,69,66,66,66,66,66,66,66,66,66,100,3,107,107,107,107,255,42,14,
  107,107,66,66,66,66,66,66,66,66,66,68,3,107,107,107,255,42,13,107,107,66,66,
  66,66,66,66,66,66,68,103,107,107,107,255,42,13,107,107,103,66,66,66,66,66,68,
  68,3,3,107,107,107,255,42,12,107,107,108,103,103,100,68,68,100,103,3,107,107,
  107,255,42,11,107,107,108,108,103,103,103,103,107,107,107,107,107,255,42,10,
  107,107,108,108,109,109,107,107,107,106,107,107,255,42,10,107,107,108,108,
  109,109,103,103,100,71,107,107,255,42,11,107,107,108,108,109,109,103,66,68,
  71,106,109,109,255,42,11,107,107,108,108,109,109,103,66,68,70,106,109,109,
  255,42,11,107,107,108,108,109,109,103,66,68,70,106,108,108,255,42,11,107,107,
  108,108,109,109,103,66,68,70,3,108,108,255,42,12,107,107,108,108,109,107,66,
  66,68,70,3,108,109,109,255,42,12,107,107,108,108,109,3,66,66,68,69,3,108,109,
  109,255,41,13,107,107,107,108,108,109,103,66,66,66,68,3,107,109,109,255,41,
  13,107,107,107,108,108,109,66,66,66,66,66,68,71,109,109,255,41,13,107,107,
  107,108,108,106,66,66,66,66,66,66,69,69,69,255,40,15,107,107,107,106,106,106,
  3,103,66,66,66,66,66,68,69,71,71,255,38,17,69,69,69,69,66,66,66,66,3,3,103,
  66,66,66,67,68,69,71,71,255,37,18,69,69,69,66,66,66,66,66,66,69,3,3,103,103,
  69,67,68,69,71,71,255,36,19,69,69,66,66,66,66,66,66,66,69,69,69,69,3,71,103,
  67,68,71,71,71,255,35,19,69,69,66,66,66,66,66,66,66,69,69,69,70,71,71,103,3,
  67,68,71,71,255,34,20,109,109,66,68,68,66,66,66,66,69,69,70,71,71,103,103,3,
  107,68,68,71,71,255,31,23,66,66,66,68,68,68,3,103,70,66,66,66,70,71,71,103,
  103,3,3,107,107,68,69,71,71,255,32,22,66,66,68,3,3,3,103,70,66,66,69,71,103,
  3,3,107,107,107,107,107,68,69,71,71,255,31,16,66,66,71,71,109,109,103,68,66,
  66,69,103,103,3,107,107,107,107,50,3,107,107,68,69,69,255,32,12,68,68,68,109,
  109,3,68,68,68,103,71,3,107,107,50,3,107,107,68,69,69,255,35,8,109,109,107,
  100,68,68,103,71,107,107,50,3,107,107,68,69,69,255,35,7,109,109,107,0,70,69,
  103,109,109,50,4,107,107,69,69,71,71,255,36,6,109,109,109,70,70,103,109,109,
  51,5,69,69,69,69,71,74,74,255,36,6,109,109,109,3,70,3,111,111,51,5,107,107,
  71,71,73,74,74,255,37,5,109,109,107,3,107,111,111,52,4,107,107,73,74,74,74,
  255,37,4,109,109,109,107,109,109,255,37,4,0,0,0,107,111,111,255,37,3,0,0,0,
  111,111,255,255,255,255,255,255,255,255,255,255,
};
static const char dogse7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,18,1,0,0,26,1,0,0,34,1,
  0,0,43,1,0,0,51,1,0,0,60,1,0,0,68,1,0,0,77,1,0,0,86,1,0,0,95,1,0,0,103,1,0,0,
  111,1,0,0,119,1,0,0,128,1,0,0,147,1,0,0,167,1,0,0,189,1,0,0,213,1,0,0,239,1,
  0,0,12,2,0,0,37,2,0,0,63,2,0,0,90,2,0,0,113,2,0,0,137,2,0,0,164,2,0,0,188,2,
  0,0,210,2,0,0,233,2,0,0,1,3,0,0,26,3,0,0,48,3,0,0,70,3,0,0,93,3,0,0,117,3,0,
  0,143,3,0,0,170,3,0,0,198,3,0,0,223,3,0,0,249,3,0,0,18,4,0,0,41,4,0,0,62,4,0,
  0,76,4,0,0,89,4,0,0,101,4,0,0,112,4,0,0,122,4,0,0,131,4,0,0,140,4,0,0,148,4,
  0,0,149,4,0,0,150,4,0,0,151,4,0,0,152,4,0,0,153,4,0,0,154,4,0,0,155,4,0,0,
  156,4,0,0,157,4,0,0,255,255,255,41,2,0,0,0,0,255,41,3,0,0,0,0,0,255,41,3,0,0,
  79,79,79,255,41,4,0,0,77,77,77,77,255,42,3,77,77,77,76,76,255,42,4,77,77,76,
  73,73,73,255,43,3,76,76,73,73,73,255,43,4,76,76,70,103,71,71,255,43,4,72,72,
  103,70,71,71,255,43,4,72,72,103,69,70,70,255,44,3,71,71,66,70,70,255,44,3,71,
  71,66,70,70,255,44,3,69,69,66,69,69,255,44,4,69,69,66,66,69,69,255,44,7,69,
  69,66,103,66,68,68,68,68,53,3,68,68,68,66,66,255,43,15,69,69,66,66,69,66,66,
  66,66,68,68,66,66,66,66,66,66,255,43,17,69,69,66,66,66,66,66,66,66,66,66,66,
  66,66,66,66,66,66,66,255,43,19,69,69,66,66,66,66,66,66,66,66,66,66,103,100,
  66,66,66,66,66,66,66,255,42,21,107,107,66,66,66,66,66,66,66,66,66,66,68,106,
  3,3,103,100,70,66,66,66,66,255,42,14,107,107,103,66,66,66,66,66,66,66,66,68,
  100,107,3,3,58,6,3,3,3,103,70,66,66,66,255,42,13,107,107,107,103,66,66,66,66,
  66,68,68,100,3,107,107,61,3,70,70,70,66,66,255,42,15,107,107,107,108,106,103,
  100,68,68,68,100,3,107,73,73,73,73,62,2,70,70,70,70,255,42,17,107,107,107,
  108,108,106,103,103,103,3,3,108,108,75,75,74,73,73,73,63,1,70,70,70,255,42,
  18,107,107,107,108,109,108,108,106,107,107,107,109,109,107,107,107,75,74,73,
  73,255,42,19,107,107,107,108,108,109,108,106,103,69,71,108,109,107,107,107,
  107,107,75,73,73,255,42,12,107,107,107,108,108,109,108,103,66,69,71,107,109,
  109,56,6,107,107,107,107,107,107,107,107,255,43,12,107,107,108,108,109,108,
  103,66,69,71,106,108,109,109,59,3,107,107,107,107,107,255,43,12,107,107,108,
  108,109,108,103,66,69,71,106,108,109,109,61,1,107,107,107,255,43,12,107,107,
  108,108,109,108,103,66,69,71,3,107,109,109,57,2,109,109,109,109,255,43,12,
  107,107,108,108,109,107,66,66,69,71,3,107,109,109,57,3,109,109,109,109,109,
  255,43,12,107,107,108,108,109,3,66,66,69,72,72,106,109,109,56,4,109,109,109,
  109,109,109,255,43,17,107,107,108,108,108,103,66,66,72,68,68,72,76,109,109,
  109,109,109,109,255,42,17,107,107,107,108,108,106,66,66,66,103,66,66,66,68,
  76,66,66,72,72,255,41,18,69,69,107,108,108,106,3,103,66,66,66,66,66,66,66,72,
  76,66,72,72,255,40,19,69,69,69,66,3,3,3,3,3,103,66,66,66,66,72,66,66,66,66,
  72,72,255,38,21,69,69,69,66,66,66,66,66,66,66,3,103,69,66,69,103,76,72,68,68,
  68,72,72,255,37,22,69,69,66,66,66,66,66,66,66,66,66,69,3,3,103,103,106,108,
  76,76,72,72,72,72,255,36,23,69,69,66,66,66,66,66,66,66,66,66,69,69,69,3,71,3,
  106,109,108,107,76,76,76,76,255,35,20,109,109,66,68,68,66,66,66,66,66,66,69,
  69,69,69,71,103,106,107,108,108,108,255,33,21,103,103,68,68,68,3,103,70,66,
  66,66,69,69,69,70,71,103,3,106,107,108,108,108,255,32,20,66,66,66,68,3,3,3,
  103,70,66,66,66,69,71,103,3,3,106,106,107,107,107,255,33,18,71,71,71,109,109,
  103,68,66,66,66,103,71,103,3,106,106,107,107,108,108,255,32,16,66,66,68,68,
  109,109,3,68,68,68,103,71,103,106,107,107,107,107,255,36,9,109,109,107,100,
  68,68,103,71,107,107,107,255,36,8,109,109,107,0,70,69,72,107,111,111,255,37,
  7,109,109,109,3,70,72,107,111,111,255,38,6,109,109,107,70,72,107,111,111,255,
  39,5,107,107,3,107,111,111,111,255,39,4,109,109,109,107,109,109,255,39,4,0,0,
  0,107,111,111,255,39,3,0,0,0,111,111,255,255,255,255,255,255,255,255,255,255,
  255,
};
static const char dogsc3c7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,26,1,0,0,35,1,0,0,44,1,0,0,54,1,0,0,
  65,1,0,0,82,1,0,0,102,1,0,0,125,1,0,0,153,1,0,0,186,1,0,0,221,1,0,0,254,1,0,
  0,31,2,0,0,57,2,0,0,81,2,0,0,102,2,0,0,120,2,0,0,138,2,0,0,155,2,0,0,172,2,0,
  0,189,2,0,0,205,2,0,0,222,2,0,0,239,2,0,0,0,3,0,0,17,3,0,0,33,3,0,0,50,3,0,0,
  67,3,0,0,84,3,0,0,101,3,0,0,119,3,0,0,136,3,0,0,153,3,0,0,171,3,0,0,189,3,0,
  0,208,3,0,0,231,3,0,0,255,3,0,0,24,4,0,0,49,4,0,0,67,4,0,0,85,4,0,0,101,4,0,
  0,117,4,0,0,132,4,0,0,140,4,0,0,148,4,0,0,155,4,0,0,162,4,0,0,163,4,0,0,164,
  4,0,0,165,4,0,0,255,255,255,255,255,255,255,255,255,255,40,3,0,0,0,107,107,
  255,40,4,0,0,0,3,107,107,255,40,4,109,109,109,103,107,107,255,40,5,109,109,
  107,103,3,107,107,255,39,6,109,109,109,103,66,3,107,107,255,39,6,109,109,107,
  66,66,103,107,107,61,2,70,70,73,73,255,38,8,109,109,107,0,66,66,103,106,107,
  107,60,3,70,70,73,73,73,255,38,10,109,109,103,100,66,66,103,66,106,107,107,
  107,60,4,70,70,73,66,66,66,255,36,14,68,68,109,109,103,66,66,66,100,66,103,
  106,107,107,107,107,59,5,70,70,73,3,66,66,66,255,35,17,66,66,107,109,107,103,
  66,66,66,66,103,66,103,3,106,106,107,107,107,57,7,70,70,70,73,3,66,66,69,69,
  255,34,30,66,66,66,103,68,107,3,103,100,66,66,66,66,100,103,103,103,3,106,
  107,73,70,70,70,73,3,66,66,66,69,73,73,255,35,28,66,66,66,103,107,3,103,100,
  66,66,66,66,66,66,100,100,103,3,106,107,73,3,3,66,66,66,69,69,73,73,255,36,1,
  107,107,107,39,23,72,72,70,68,66,66,66,66,66,66,66,66,100,103,106,107,66,66,
  66,66,66,69,73,73,73,255,39,21,72,72,70,68,68,66,66,66,66,66,66,66,103,100,
  66,66,66,66,66,66,69,73,73,255,40,19,72,72,70,70,68,66,66,66,66,66,103,103,
  100,66,66,66,66,69,69,73,73,255,42,16,72,72,70,70,66,66,100,103,103,100,66,
  66,66,69,69,73,73,73,255,43,13,3,3,3,3,103,103,103,100,66,66,66,66,69,73,73,
  255,43,13,107,107,109,107,3,103,100,66,66,66,66,66,73,107,107,255,44,12,111,
  111,111,107,3,66,66,66,66,66,73,3,107,107,255,44,12,109,109,109,109,106,100,
  66,66,66,103,103,106,107,107,255,44,12,111,111,111,111,106,103,66,66,103,103,
  103,106,107,107,255,44,11,109,109,109,109,106,103,66,66,69,69,3,107,107,255,
  43,12,107,107,108,108,108,106,100,66,68,69,69,3,107,107,255,43,12,107,107,
  107,107,107,3,100,66,68,69,103,106,107,107,255,42,12,107,107,107,107,107,107,
  103,66,67,68,69,3,107,107,255,42,12,107,107,107,107,107,106,103,66,67,69,103,
  106,107,107,255,42,11,107,107,107,107,107,106,103,66,70,70,3,106,106,255,41,
  12,107,107,107,107,107,106,3,3,3,72,72,106,107,107,255,41,12,107,107,107,107,
  106,3,103,103,103,3,3,106,107,107,255,41,12,107,107,107,106,3,103,103,68,68,
  100,103,3,107,107,255,41,12,107,107,106,106,3,66,68,68,68,68,68,103,3,3,255,
  41,13,107,107,106,3,66,68,68,70,70,70,70,73,103,107,107,255,42,12,3,3,66,66,
  68,70,70,70,70,70,71,73,107,107,255,42,12,69,69,66,66,68,70,70,70,70,70,71,
  73,107,107,255,42,13,69,69,66,66,68,70,70,70,70,70,71,73,107,74,74,255,43,13,
  69,69,66,66,71,70,70,70,70,71,73,107,107,74,74,255,44,14,69,69,68,71,73,71,
  70,70,73,107,109,109,107,74,74,74,255,44,9,71,71,68,71,74,74,71,70,73,107,
  107,54,5,109,109,109,107,107,74,74,255,44,3,71,71,68,71,71,48,5,74,74,73,70,
  71,107,107,56,3,109,109,107,107,107,255,44,3,71,71,70,73,73,48,6,74,74,73,71,
  71,73,74,74,56,3,109,109,109,109,109,255,43,3,72,72,70,73,73,49,7,74,74,73,
  71,71,73,74,75,75,57,2,109,109,109,109,255,43,3,74,74,72,74,74,51,6,73,73,71,
  71,71,73,73,73,255,43,3,74,74,74,74,74,52,6,73,73,73,71,71,71,73,73,255,42,3,
  75,75,77,77,77,54,4,73,73,71,71,73,73,255,41,4,75,75,77,77,0,0,55,3,71,71,71,
  73,73,255,41,3,77,77,77,77,77,55,3,72,72,74,74,74,255,41,3,0,0,77,0,0,255,41,
  3,0,0,0,0,0,255,41,2,0,0,0,0,255,41,2,0,0,0,0,255,255,255,255,255,
};
static const char dogsg7[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,19,1,0,0,27,1,
  0,0,36,1,0,0,51,1,0,0,67,1,0,0,82,1,0,0,98,1,0,0,115,1,0,0,132,1,0,0,150,1,0,
  0,172,1,0,0,194,1,0,0,217,1,0,0,241,1,0,0,5,2,0,0,24,2,0,0,43,2,0,0,61,2,0,0,
  79,2,0,0,96,2,0,0,112,2,0,0,128,2,0,0,145,2,0,0,161,2,0,0,178,2,0,0,196,2,0,
  0,213,2,0,0,230,2,0,0,247,2,0,0,9,3,0,0,26,3,0,0,43,3,0,0,61,3,0,0,81,3,0,0,
  104,3,0,0,129,3,0,0,156,3,0,0,184,3,0,0,214,3,0,0,250,3,0,0,32,4,0,0,67,4,0,
  0,97,4,0,0,120,4,0,0,139,4,0,0,156,4,0,0,167,4,0,0,177,4,0,0,186,4,0,0,195,4,
  0,0,203,4,0,0,204,4,0,0,205,4,0,0,206,4,0,0,207,4,0,0,208,4,0,0,209,4,0,0,
  210,4,0,0,211,4,0,0,255,255,255,255,41,2,0,0,0,0,255,41,3,0,0,0,0,0,255,41,4,
  0,0,79,79,0,0,255,41,4,0,0,77,77,77,77,56,2,66,66,69,69,255,42,4,77,77,76,73,
  76,76,55,3,66,66,66,69,69,255,43,3,76,76,73,76,76,55,3,66,66,66,69,69,255,43,
  3,76,76,70,71,71,54,4,66,66,66,68,103,103,255,43,3,72,72,70,71,71,52,5,66,66,
  66,66,68,103,103,255,43,3,71,71,69,70,70,51,5,66,66,66,66,68,103,103,255,43,
  3,71,71,68,70,70,49,6,66,66,66,66,68,103,103,103,255,44,3,69,69,66,69,69,49,
  4,66,66,66,69,103,103,57,2,73,73,73,73,255,44,3,69,69,66,69,69,49,4,66,66,66,
  70,106,106,57,2,73,73,73,73,255,44,3,69,69,66,69,69,49,4,70,70,66,103,107,
  107,56,3,73,73,73,107,107,255,43,10,71,71,66,66,69,70,70,66,66,103,106,106,
  54,5,73,73,73,107,107,107,107,255,42,15,71,71,69,66,66,70,66,70,66,66,68,103,
  73,106,107,107,107,255,42,14,69,69,66,66,66,66,66,66,66,66,68,103,106,107,
  107,107,255,41,14,69,69,66,66,66,66,66,66,66,66,66,69,103,107,107,107,255,41,
  13,69,69,3,66,66,66,66,66,66,66,66,69,3,107,107,255,41,13,3,3,3,103,66,66,66,
  66,66,66,68,103,106,107,107,255,41,12,3,3,106,3,103,66,66,66,66,68,103,3,107,
  107,255,41,11,3,3,106,107,108,106,103,68,69,70,103,106,106,255,41,11,3,3,107,
  108,108,108,106,103,103,3,106,107,107,255,41,12,3,3,107,108,109,108,108,107,
  3,103,71,106,109,109,255,42,11,107,107,109,109,109,108,3,103,69,69,71,108,
  108,255,42,12,107,107,109,109,109,109,107,66,66,69,71,108,109,109,255,42,13,
  107,107,108,109,109,109,107,103,66,69,69,106,108,109,109,255,43,12,107,107,
  109,109,109,108,3,66,66,69,71,108,109,109,255,43,12,107,107,109,109,109,108,
  3,66,66,69,71,106,109,109,255,44,12,108,108,109,111,108,106,66,66,69,70,106,
  108,109,109,255,43,13,107,107,107,107,108,108,106,66,66,69,70,3,108,109,109,
  255,44,12,108,108,109,111,108,66,66,66,66,103,3,108,108,108,255,44,12,107,
  107,108,109,108,66,66,66,66,66,3,107,108,108,255,43,13,107,107,107,107,3,3,
  103,66,66,66,66,69,69,108,108,255,43,15,3,3,3,103,103,103,3,3,66,66,66,66,66,
  69,69,69,69,255,41,18,69,69,69,69,66,66,66,66,103,3,100,66,66,66,66,66,66,69,
  69,69,255,40,20,69,69,69,66,66,66,66,66,66,69,103,3,100,100,66,66,66,66,66,
  66,69,69,255,39,22,69,69,66,66,66,66,66,66,66,69,69,71,103,3,3,69,69,69,66,
  66,66,66,69,69,255,38,23,69,69,66,66,66,66,66,66,66,69,69,71,71,71,103,3,107,
  73,71,69,69,66,66,69,69,255,37,25,109,109,66,68,68,66,66,66,66,69,69,70,71,
  103,103,3,106,107,107,107,107,71,69,66,66,69,69,255,35,23,103,103,68,68,68,3,
  103,70,66,66,66,70,71,71,3,3,3,106,107,107,107,107,107,107,107,59,4,71,71,69,
  66,69,69,255,34,25,66,66,66,68,3,3,3,103,70,66,66,69,71,103,3,106,107,107,74,
  74,73,73,107,107,107,107,107,60,4,71,71,69,66,69,69,255,35,14,71,71,71,109,
  109,103,68,66,66,69,103,103,3,106,107,107,55,5,73,73,74,107,107,107,107,61,3,
  71,71,69,66,66,255,34,13,66,66,68,68,109,109,3,68,68,68,103,71,3,107,107,56,
  8,73,73,73,107,107,107,107,69,69,69,255,38,8,109,109,107,100,68,68,103,71,
  107,107,58,6,73,73,74,107,107,71,71,71,255,38,7,109,109,107,0,70,69,103,109,
  109,59,3,73,73,74,107,107,255,39,6,109,109,109,70,70,103,109,109,60,2,73,73,
  74,74,255,39,6,109,109,109,3,70,3,111,111,255,40,5,109,109,107,3,107,111,111,
  255,40,4,109,109,109,107,109,109,255,40,4,0,0,0,107,111,111,255,40,3,0,0,0,
  111,111,255,255,255,255,255,255,255,255,255,255,
};
static const char dogsj0[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,15,1,0,0,16,1,0,0,17,1,0,0,18,1,0,0,19,1,0,0,20,1,0,0,27,1,0,0,36,1,0,0,
  46,1,0,0,55,1,0,0,64,1,0,0,78,1,0,0,101,1,0,0,129,1,0,0,162,1,0,0,190,1,0,0,
  214,1,0,0,238,1,0,0,10,2,0,0,37,2,0,0,62,2,0,0,94,2,0,0,122,2,0,0,151,2,0,0,
  175,2,0,0,194,2,0,0,217,2,0,0,240,2,0,0,1,3,0,0,29,3,0,0,58,3,0,0,87,3,0,0,
  118,3,0,0,149,3,0,0,175,3,0,0,198,3,0,0,224,3,0,0,244,3,0,0,7,4,0,0,24,4,0,0,
  39,4,0,0,55,4,0,0,75,4,0,0,96,4,0,0,120,4,0,0,144,4,0,0,161,4,0,0,175,4,0,0,
  183,4,0,0,192,4,0,0,201,4,0,0,210,4,0,0,218,4,0,0,224,4,0,0,225,4,0,0,226,4,
  0,0,227,4,0,0,255,255,255,255,255,255,255,255,255,255,255,255,47,2,66,66,66,
  66,255,46,4,66,66,71,71,107,107,255,45,5,66,66,71,3,3,107,107,255,45,4,66,66,
  71,3,107,107,255,44,4,66,66,71,3,107,107,255,44,4,66,66,71,3,107,107,50,1,
  185,185,185,255,25,2,66,66,103,103,31,3,71,71,71,71,71,43,5,65,65,65,65,3,
  107,107,255,25,13,71,71,66,103,103,107,68,68,68,71,71,70,70,70,70,41,6,185,
  185,65,65,65,65,68,68,255,26,14,71,71,107,107,103,3,65,65,65,70,70,70,70,70,
  70,70,42,5,65,65,65,65,65,68,68,53,1,185,185,185,255,27,14,71,71,109,103,109,
  65,65,103,103,103,103,103,103,70,70,70,42,5,65,65,65,66,73,73,73,255,27,19,
  71,71,109,107,103,65,103,103,189,100,3,103,103,103,103,70,65,65,73,107,107,
  255,28,19,109,109,3,107,107,107,107,189,97,3,103,100,103,103,103,65,66,73,
  107,185,185,255,28,18,109,109,111,3,103,103,97,189,187,0,103,103,103,100,65,
  65,66,73,107,107,48,1,187,187,187,255,27,22,71,71,109,111,0,103,109,187,189,
  187,0,103,100,103,103,65,65,66,73,106,107,187,185,185,255,27,20,71,71,109,
  111,0,103,109,187,187,97,3,103,103,103,65,65,66,66,73,106,107,107,255,26,22,
  66,66,107,107,111,3,103,103,97,103,3,3,66,183,103,65,66,66,66,73,106,106,107,
  107,50,1,187,187,187,255,25,23,66,66,66,103,103,66,109,109,109,107,73,71,180,
  66,187,187,66,66,66,66,73,106,106,107,107,255,25,2,71,71,71,71,31,18,75,75,
  75,75,0,181,109,47,180,187,183,66,66,73,3,3,106,107,107,107,255,33,1,183,183,
  183,35,14,109,109,109,180,47,47,183,66,73,3,3,3,3,106,107,107,255,35,14,109,
  109,109,109,47,183,66,66,68,103,103,3,3,106,107,107,255,34,1,183,183,183,36,
  13,109,109,180,107,3,103,66,66,68,103,103,3,106,107,107,255,30,1,178,178,178,
  36,13,109,109,109,109,180,103,100,66,68,68,103,3,106,107,107,255,37,12,109,
  109,109,107,3,103,66,66,68,103,3,3,107,107,255,34,1,185,185,185,38,12,109,
  109,107,107,103,66,66,68,68,103,3,107,75,75,56,2,72,72,75,75,255,30,1,180,
  180,180,38,12,109,109,107,107,3,66,66,68,68,103,3,107,75,75,55,3,72,72,72,75,
  75,255,33,2,178,178,181,181,39,11,109,109,107,3,100,66,66,68,103,3,107,75,75,
  55,3,72,72,75,75,75,255,33,2,181,181,185,185,39,12,109,109,107,107,103,66,66,
  68,103,3,109,107,75,75,54,4,72,72,72,75,75,75,255,35,1,183,183,183,39,13,109,
  109,107,107,3,66,66,68,103,3,109,107,107,75,75,54,4,72,72,107,75,75,75,255,
  39,13,109,109,107,107,3,66,66,66,103,3,109,109,107,75,75,53,4,75,75,107,107,
  75,75,255,39,18,109,109,107,107,103,66,66,66,66,103,103,109,107,107,75,107,
  107,107,75,75,255,28,1,183,183,183,40,16,107,107,107,100,66,66,66,66,66,66,
  103,109,107,75,107,107,109,109,255,40,15,109,109,103,66,66,66,66,66,66,66,66,
  103,107,75,107,109,109,255,40,14,109,109,100,66,66,66,66,66,66,66,66,66,103,
  107,109,109,255,41,12,68,68,66,66,67,67,67,67,66,66,66,103,109,109,255,42,10,
  66,66,66,67,67,67,67,67,66,66,66,66,255,42,11,68,68,66,66,69,67,67,67,67,66,
  66,103,103,255,43,15,68,68,66,69,69,67,67,67,66,66,66,69,69,69,69,69,69,255,
  43,16,70,70,66,66,73,69,69,67,67,66,66,66,67,67,67,69,72,72,255,44,4,70,70,
  66,70,73,73,49,11,69,69,68,68,68,68,68,68,68,69,69,72,72,255,44,5,72,72,70,
  70,73,74,74,50,10,72,72,72,72,72,72,72,69,69,69,72,72,255,45,4,72,72,70,70,
  74,74,56,4,72,72,72,69,72,72,255,46,4,72,72,72,74,77,77,58,1,72,72,72,255,47,
  3,72,72,74,77,77,255,47,4,0,0,74,77,0,0,255,47,4,0,0,75,77,0,0,255,47,4,0,0,
  77,77,0,0,255,47,3,0,0,0,0,0,255,48,1,0,0,0,255,255,255,255,255,
};
static const char dogsl0[] = {
  64,0,64,0,32,0,59,0,8,1,0,0,9,1,0,0,10,1,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,
  0,0,21,1,0,0,30,1,0,0,40,1,0,0,49,1,0,0,58,1,0,0,74,1,0,0,95,1,0,0,113,1,0,0,
  140,1,0,0,169,1,0,0,200,1,0,0,234,1,0,0,10,2,0,0,48,2,0,0,80,2,0,0,118,2,0,0,
  144,2,0,0,175,2,0,0,199,2,0,0,233,2,0,0,10,3,0,0,34,3,0,0,57,3,0,0,81,3,0,0,
  100,3,0,0,117,3,0,0,140,3,0,0,164,3,0,0,190,3,0,0,215,3,0,0,240,3,0,0,6,4,0,
  0,27,4,0,0,48,4,0,0,68,4,0,0,87,4,0,0,104,4,0,0,123,4,0,0,142,4,0,0,157,4,0,
  0,173,4,0,0,190,4,0,0,208,4,0,0,225,4,0,0,241,4,0,0,1,5,0,0,17,5,0,0,34,5,0,
  0,49,5,0,0,57,5,0,0,65,5,0,0,73,5,0,0,81,5,0,0,89,5,0,0,96,5,0,0,103,5,0,0,
  104,5,0,0,255,255,255,255,255,255,53,2,66,66,66,66,255,52,4,66,66,66,66,73,
  73,255,51,5,66,66,66,69,69,73,73,255,51,4,66,66,69,73,75,75,255,50,4,66,66,
  69,73,75,75,255,40,3,69,69,69,69,69,50,4,66,66,69,75,75,75,255,39,4,69,69,71,
  73,73,73,50,3,66,66,69,75,75,60,1,186,186,186,255,37,5,109,109,109,71,73,73,
  73,49,4,66,66,69,71,75,75,255,35,9,109,109,109,3,66,66,66,66,71,71,71,49,4,
  66,66,69,71,75,75,59,1,186,186,186,255,35,11,109,109,3,66,66,66,66,66,71,71,
  71,71,71,49,4,66,66,69,71,75,75,59,1,189,189,189,255,34,13,109,109,107,103,
  103,66,66,64,64,64,103,103,71,71,71,49,4,69,69,69,73,75,75,59,1,189,189,189,
  255,32,16,0,0,0,109,109,107,188,103,64,64,66,66,66,103,103,71,71,71,49,4,69,
  69,69,73,75,75,59,1,189,189,189,255,32,21,0,0,0,185,188,109,107,103,64,66,66,
  66,70,70,3,3,103,71,69,71,73,75,75,60,2,186,186,47,47,255,32,21,0,0,185,187,
  109,109,107,103,64,66,73,70,70,70,73,3,3,106,71,71,73,75,75,54,2,182,182,185,
  185,60,2,186,186,47,47,255,32,22,0,0,187,0,109,107,103,103,103,69,69,73,73,
  73,73,3,3,3,106,73,73,75,75,75,61,1,47,47,47,255,33,21,188,188,0,0,109,109,
  109,103,66,66,69,73,73,3,3,103,3,106,106,73,75,75,75,57,2,185,185,187,187,60,
  2,186,186,47,47,255,39,15,107,107,103,66,66,66,69,73,3,103,103,3,106,75,75,
  75,75,60,2,186,186,47,47,255,40,15,3,3,66,66,66,66,69,73,3,103,3,106,106,107,
  75,187,187,57,1,182,182,182,60,2,189,189,47,47,255,40,13,45,45,70,66,66,66,
  69,69,73,103,3,3,106,107,107,60,2,189,189,47,47,255,37,1,181,181,181,40,13,
  45,45,185,70,66,66,69,69,73,3,103,3,106,107,107,58,1,186,186,186,60,2,189,
  189,47,47,255,34,1,183,183,183,40,13,184,184,45,70,70,66,69,69,103,3,103,3,
  106,107,107,58,1,186,186,186,61,1,47,47,47,255,38,1,183,183,183,40,14,180,
  180,45,185,70,103,69,103,103,3,103,3,106,106,107,107,255,41,13,45,45,45,70,
  70,103,103,103,103,103,3,106,106,107,107,59,1,186,186,186,255,37,1,181,181,
  181,40,14,183,183,187,45,189,185,66,69,103,103,103,3,106,106,107,107,255,40,
  14,187,187,187,107,3,100,66,66,103,103,103,3,106,106,107,107,255,42,12,107,
  107,107,103,66,66,67,103,103,3,106,106,107,107,255,43,11,107,107,3,100,66,66,
  103,103,3,106,107,107,107,60,3,73,73,73,73,73,255,44,12,107,107,100,66,66,
  103,103,3,107,107,107,74,74,74,60,3,73,73,73,73,73,255,44,13,107,107,103,66,
  66,103,3,3,107,107,107,75,75,74,74,59,4,73,73,73,73,109,109,255,45,12,3,3,66,
  66,103,103,3,107,107,107,76,76,75,75,59,4,73,73,73,107,109,109,255,45,13,3,3,
  67,66,68,69,103,3,107,107,107,76,75,74,74,59,3,73,73,73,109,109,255,45,17,3,
  3,67,66,66,67,69,103,3,107,107,107,76,75,74,73,107,109,109,255,45,16,3,3,67,
  66,66,66,67,103,3,107,107,107,76,75,74,73,107,107,255,45,16,3,3,69,66,66,66,
  66,69,103,107,109,107,107,76,74,73,107,107,255,46,15,69,69,67,66,66,66,67,
  103,107,109,109,107,76,74,107,107,107,255,46,14,69,69,67,66,66,66,67,103,107,
  109,109,107,107,107,107,107,255,47,12,67,67,67,66,66,66,103,109,109,109,107,
  107,107,107,255,47,7,67,67,67,66,66,66,103,103,103,56,3,109,109,107,107,107,
  255,47,8,68,68,67,67,66,66,69,103,103,103,56,2,107,107,107,107,255,47,10,69,
  69,68,67,66,66,66,66,69,103,103,103,255,47,11,70,70,68,67,67,66,66,66,66,66,
  69,103,103,255,47,12,70,70,68,71,67,67,66,66,66,66,66,67,69,69,255,47,13,70,
  70,69,71,72,67,67,67,67,66,66,66,67,68,68,255,48,12,70,70,71,72,69,69,69,69,
  69,69,66,66,68,68,255,48,3,70,70,71,72,72,57,4,67,67,66,68,71,71,255,48,3,74,
  74,71,72,72,57,4,68,68,68,68,71,71,255,48,3,74,74,72,72,72,57,4,69,69,69,69,
  71,71,255,48,4,74,74,74,72,74,74,57,4,69,69,69,69,71,71,255,48,4,74,74,74,74,
  74,74,58,2,71,71,71,71,255,49,3,77,77,77,0,0,255,49,3,77,77,77,0,0,255,49,3,
  77,77,77,0,0,255,49,3,0,0,77,0,0,255,49,3,0,0,0,0,0,255,49,2,0,0,0,0,255,49,
  2,0,0,0,0,255,255,255,
};

static const char dsdgsit[] = {
  3,0,17,43,85,8,0,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
  128,128,128,128,128,128,128,128,129,134,134,134,134,130,129,129,129,128,128,
  128,127,127,127,128,128,128,128,128,128,128,128,128,128,128,126,122,126,128,
  128,128,128,128,128,130,134,130,129,128,128,128,128,128,128,127,127,127,127,
  128,127,127,127,128,128,130,130,136,137,137,136,129,129,128,128,128,128,126,
  126,126,126,127,128,128,128,128,128,128,129,129,128,128,127,122,122,122,126,
  127,127,127,127,128,128,130,130,129,128,128,128,128,128,128,126,122,122,126,
  128,128,128,128,130,137,145,148,144,137,129,128,128,128,128,126,120,119,127,
  130,130,130,130,129,129,134,136,136,130,128,120,119,119,119,120,126,126,127,
  128,129,130,134,130,128,128,127,127,126,122,122,126,128,128,134,140,145,148,
  144,142,140,136,129,128,122,114,114,114,119,126,128,128,128,128,128,130,134,
  129,128,128,126,119,116,119,122,122,126,126,128,128,129,130,129,127,120,119,
  128,134,136,142,145,142,137,134,134,134,136,134,129,128,127,128,128,129,128,
  122,116,119,128,137,140,136,126,120,120,120,122,122,120,120,120,127,128,129,
  128,116,116,120,128,142,154,149,148,144,130,128,128,126,119,119,116,114,127,
  129,129,128,126,114,114,120,127,128,128,120,111,108,114,127,127,128,128,128,
  128,128,129,130,136,144,152,148,144,142,137,136,136,128,114,111,111,114,127,
  136,129,128,128,122,119,119,116,112,112,111,111,112,114,120,122,126,126,127,
  127,144,160,165,170,174,154,140,127,128,129,144,137,128,120,119,122,140,152,
  145,128,104,104,111,122,120,114,102,96,98,112,126,130,128,127,127,129,144,
  168,168,152,145,134,119,122,128,126,119,114,104,107,128,137,145,142,128,104,
  98,98,111,112,111,103,98,98,116,128,129,130,136,144,162,190,190,184,160,136,
  116,128,129,129,122,112,107,129,160,165,160,145,127,104,96,94,96,96,98,98,
  104,111,114,122,129,144,168,198,200,197,184,154,129,128,127,127,120,111,96,
  126,153,160,165,168,140,114,78,72,72,83,91,96,102,104,104,114,128,149,178,
  208,205,200,189,162,136,128,126,122,104,94,86,128,168,174,173,168,140,108,71,
  63,63,66,72,88,103,111,111,119,129,162,185,204,202,193,174,145,122,112,104,
  96,91,88,88,140,190,190,178,162,128,94,59,56,58,71,83,98,111,119,122,148,178,
  205,208,193,190,174,145,144,130,82,63,63,66,88,130,154,168,162,137,111,72,58,
  63,64,71,91,102,107,154,185,192,208,217,212,193,174,174,170,165,126,83,71,67,
  78,129,168,185,137,96,91,72,48,58,72,88,96,102,107,134,177,204,220,220,204,
  189,174,165,160,149,127,79,58,67,148,178,184,168,137,102,72,54,56,63,71,78,
  102,136,148,168,205,216,209,173,153,149,168,184,180,128,58,51,56,76,128,153,
  122,103,88,59,48,56,76,88,88,96,108,142,178,216,216,208,190,160,136,177,190,
  184,158,128,83,112,158,160,149,129,104,79,67,66,67,72,88,111,145,173,184,198,
  212,212,178,122,116,126,153,165,165,126,102,96,114,130,149,112,59,54,48,47,
  59,86,126,129,134,158,180,208,204,200,193,162,128,120,127,137,140,137,136,
  134,128,114,103,94,64,47,47,64,86,91,108,129,165,190,200,204,200,185,168,145,
  128,122,122,126,127,128,130,134,130,120,88,58,39,48,54,58,88,116,130,173,209,
  205,202,193,170,149,129,128,128,127,128,130,137,144,144,127,98,71,56,52,52,
  59,76,112,149,185,202,204,200,193,190,148,114,112,111,108,128,136,128,128,
  116,82,58,42,52,58,63,82,103,126,160,204,204,202,202,177,152,136,129,128,128,
  128,129,140,148,144,127,96,59,44,52,54,64,98,120,134,184,205,202,202,198,184,
  153,120,119,119,120,136,137,96,76,67,48,44,59,120,162,170,165,160,177,178,
  162,160,148,104,86,82,116,134,142,158,168,165,149,129,127,103,64,47,39,54,63,
  71,107,140,174,193,204,202,200,193,149,114,79,76,76,82,91,96,72,63,63,72,96,
  137,168,185,180,168,153,149,137,112,96,83,82,91,111,165,204,198,198,193,154,
  107,44,42,44,51,56,72,122,149,162,202,222,200,173,145,140,145,160,111,67,52,
  44,44,56,82,119,180,222,220,185,144,96,102,148,153,149,130,111,103,178,208,
  205,204,193,168,153,140,136,111,67,71,71,66,71,72,71,94,134,185,217,217,222,
  222,198,158,112,96,78,54,54,71,122,145,160,190,209,205,128,52,42,54,79,71,67,
  72,66,76,145,193,224,224,224,214,185,160,149,114,58,58,58,58,58,71,128,158,
  170,216,229,202,142,94,86,116,162,98,72,98,98,116,197,224,217,136,83,58,56,
  64,88,137,202,184,153,108,137,180,208,212,204,145,107,86,128,160,142,114,79,
  58,58,83,82,86,111,158,216,209,205,205,173,149,160,130,88,86,83,83,88,88,58,
  48,52,67,79,94,149,198,200,212,224,184,149,127,127,128,140,128,112,153,177,
  177,154,127,66,52,59,59,88,144,180,202,198,197,190,170,173,197,128,76,67,44,
  27,40,66,91,98,112,140,173,192,111,66,63,59,72,108,126,128,130,158,200,204,
  184,126,94,76,72,96,136,112,86,72,54,40,66,122,205,220,217,197,205,217,184,
  173,178,137,96,58,54,64,72,126,202,198,174,128,98,76,48,48,67,86,96,88,71,64,
  148,200,222,224,220,192,160,128,78,52,51,58,64,66,114,162,174,193,220,212,
  174,91,64,64,104,108,86,108,126,128,168,214,204,148,59,52,64,98,142,170,112,
  83,76,108,134,154,168,170,158,144,130,130,136,142,129,116,88,58,32,72,98,104,
  129,158,162,173,185,184,190,205,168,120,66,40,34,58,64,44,59,76,76,116,180,
  198,198,177,165,158,144,128,108,111,116,127,153,184,197,148,71,66,71,82,88,
  88,78,72,71,88,126,184,205,214,212,190,158,154,148,136,128,112,79,63,59,145,
  192,190,134,86,66,82,116,129,160,202,198,184,162,154,154,185,184,144,83,32,
  28,52,86,86,78,58,56,64,88,134,193,197,198,200,170,134,91,94,116,126,142,177,
  165,153,160,160,152,126,86,32,39,44,44,78,127,149,177,202,202,198,198,190,
  170,98,56,48,48,54,72,66,51,51,63,88,130,160,128,114,103,102,114,137,128,116,
  104,112,128,160,177,184,180,168,142,120,94,63,47,47,54,58,56,96,142,154,184,
  229,214,197,184,177,173,173,130,63,54,51,42,59,88,127,165,209,205,189,152,
  104,59,63,59,56,71,88,104,165,229,217,209,208,200,180,140,127,111,66,58,79,
  82,82,88,79,79,128,168,209,209,212,220,180,129,79,54,52,67,88,114,165,216,
  212,209,212,165,120,72,64,63,52,67,96,136,165,174,193,209,209,197,177,168,
  148,108,82,64,64,67,72,104,129,160,126,83,94,114,140,162,168,149,160,177,200,
  198,184,140,122,128,153,177,158,137,127,116,98,72,51,42,79,94,94,78,72,76,
  140,205,216,217,214,208,193,168,165,152,103,67,44,64,79,88,122,137,108,83,63,
  63,76,102,127,148,184,200,208,200,185,168,129,111,128,154,185,170,136,86,76,
  72,79,71,58,86,96,86,86,88,96,111,128,112,102,88,128,174,205,212,204,158,126,
  102,127,142,128,122,114,103,96,96,83,72,72,76,83,111,126,127,160,197,220,214,
  197,197,198,198,190,165,111,96,102,116,104,71,96,126,128,153,174,114,82,78,
  72,82,112,111,104,165,197,197,205,214,222,190,148,144,142,142,142,127,67,51,
  51,64,82,103,86,72,78,88,104,126,129,129,136,152,180,197,204,193,190,189,160,
  142,137,129,126,112,94,64,59,63,79,76,67,64,76,96,140,168,160,140,128,165,
  198,224,228,216,184,173,168,154,154,165,136,104,67,67,79,88,96,98,71,59,91,
  102,112,145,142,112,149,173,168,197,224,209,184,154,142,130,130,149,153,83,
  52,51,40,42,67,67,63,67,88,127,144,153,144,148,158,180,178,162,177,185,185,
  185,178,152,136,128,122,98,52,42,47,64,72,79,64,66,91,136,178,180,168,149,
  154,154,149,149,148,142,144,149,154,160,162,160,142,91,58,36,36,40,51,63,86,
  129,154,168,184,184,168,153,144,152,168,184,168,144,108,104,108,126,130,137,
  120,104,102,83,67,59,63,67,71,79,96,126,145,162,168,162,137,122,108,136,165,
  170,189,205,197,168,120,111,119,142,134,114,78,56,56,72,94,104,107,104,112,
  126,137,149,160,174,178,178,149,128,119,158,192,192,180,162,160,154,154,148,
  128,79,59,54,63,66,66,72,88,114,128,140,136,148,170,184,180,130,116,111,120,
  136,160,158,153,153,154,154,142,116,72,71,71,71,71,76,112,130,137,154,165,
  160,178,200,200,189,168,136,119,126,122,116,98,96,103,145,174,174,152,128,
  112,104,103,102,96,91,96,108,128,140,142,158,170,178,154,128,126,122,120,116,
  108,94,94,102,130,168,202,184,170,170,149,128,111,94,72,72,76,79,91,108,142,
  160,160,168,168,168,154,140,136,128,111,107,111,128,129,134,144,149,149,128,
  119,116,108,103,94,94,98,98,107,122,128,140,162,174,178,193,200,193,148,107,
  102,94,88,96,103,103,103,108,128,144,160,137,127,127,120,116,116,119,127,128,
  128,130,137,145,170,180,178,168,153,137,122,104,103,91,78,82,94,116,122,126,
  128,137,153,160,168,168,170,170,160,128,88,88,94,108,120,128,128,129,134,148,
  152,144,122,103,103,104,107,103,108,126,128,128,140,148,158,162,165,162,145,
  129,122,112,107,107,104,102,107,114,126,128,128,127,
};

static const char dsdgatk[] = {
  3,0,17,43,34,23,0,0,129,134,134,134,134,130,129,129,129,128,128,128,127,127,
  127,128,128,128,128,128,128,128,128,128,128,128,126,122,126,128,128,128,128,
  128,128,130,134,130,129,128,128,128,128,128,128,127,127,127,127,128,127,127,
  127,128,128,130,130,136,137,137,136,129,129,128,128,128,128,126,126,126,126,
  127,128,128,128,128,128,128,129,129,128,128,127,122,122,122,126,127,127,127,
  127,128,128,130,130,129,128,128,128,128,128,128,126,122,122,126,128,128,128,
  128,130,137,145,148,144,137,129,128,128,128,128,126,120,119,127,130,130,130,
  130,129,129,134,136,136,130,128,120,119,119,119,120,126,126,127,128,129,130,
  134,130,128,128,127,127,126,122,122,126,128,128,134,140,145,148,144,142,140,
  136,129,128,122,114,114,114,119,126,128,128,128,128,128,130,134,129,128,128,
  126,119,116,119,122,122,126,126,128,128,129,130,129,127,120,119,128,134,136,
  142,145,142,137,134,134,134,136,134,129,128,127,128,128,129,128,122,116,119,
  128,137,140,136,126,120,120,120,122,122,120,120,120,127,128,129,128,116,116,
  120,128,142,154,149,148,144,130,128,128,126,119,119,116,114,127,129,129,128,
  126,114,114,120,127,128,128,120,111,108,114,127,127,128,128,128,128,128,129,
  130,136,144,152,148,144,142,137,136,136,128,114,111,111,114,127,136,129,128,
  128,122,119,119,116,112,112,111,111,112,114,120,122,126,126,127,127,144,160,
  165,170,174,154,140,127,128,129,144,137,128,120,119,122,140,152,145,128,104,
  104,111,122,120,114,102,96,98,112,126,130,128,127,127,129,144,168,168,152,
  145,134,119,122,128,126,119,114,104,107,128,137,145,142,128,104,98,98,111,
  112,111,103,98,98,116,128,129,130,136,144,162,190,190,184,160,136,116,128,
  129,129,122,112,107,129,160,165,160,145,127,104,96,94,96,96,98,98,104,111,
  114,122,129,144,168,198,200,197,184,154,129,128,127,127,120,111,96,126,153,
  160,165,168,140,114,78,72,72,83,91,96,102,104,104,114,128,149,178,208,205,
  200,189,162,136,128,126,122,104,94,86,128,168,174,173,168,140,108,71,63,63,
  66,72,88,103,111,111,119,129,162,185,204,202,193,174,145,122,112,104,96,91,
  88,88,140,190,190,178,162,128,94,59,56,58,71,83,98,111,119,122,148,178,205,
  208,193,190,174,145,144,130,82,63,63,66,88,130,154,168,162,137,111,72,58,63,
  64,71,91,102,107,154,185,192,208,217,212,193,174,174,170,165,126,83,71,67,78,
  129,168,185,137,96,91,72,48,58,72,88,96,102,107,134,177,204,220,220,204,189,
  174,165,160,149,127,79,58,67,148,178,184,168,137,102,72,54,56,63,71,78,102,
  136,148,168,205,216,209,173,153,149,168,184,180,128,58,51,56,76,128,153,122,
  103,88,59,48,56,76,88,88,96,108,142,178,216,216,208,190,160,136,177,190,184,
  158,128,83,112,158,160,149,129,104,79,67,66,67,72,88,111,145,173,184,198,212,
  212,178,122,116,126,153,165,165,126,102,96,114,130,149,112,59,54,48,47,59,86,
  126,129,134,158,180,208,204,200,193,162,128,120,127,137,140,137,136,134,128,
  114,103,94,64,47,47,64,86,91,108,129,165,190,200,204,200,185,168,145,128,122,
  122,126,127,128,130,134,130,120,88,58,39,48,54,58,88,116,130,173,209,205,202,
  193,170,149,129,128,128,127,128,130,137,144,144,127,98,71,56,52,52,59,76,112,
  149,185,202,204,200,193,190,148,114,112,111,108,128,136,128,128,116,82,58,42,
  52,58,63,82,103,126,160,204,204,202,202,177,152,136,129,128,128,128,129,140,
  148,144,127,96,59,44,52,54,64,98,120,134,184,205,202,202,198,184,153,120,119,
  119,120,136,137,96,76,67,48,44,59,120,162,170,165,160,177,178,162,160,148,
  104,86,82,116,134,142,158,168,165,149,129,127,103,64,47,39,54,63,71,107,140,
  174,193,204,202,200,193,149,114,79,76,76,82,91,96,72,63,63,72,96,137,168,185,
  180,168,153,149,137,112,96,83,82,91,111,165,204,198,198,193,154,107,44,42,44,
  51,56,72,122,149,162,202,222,200,173,145,140,145,160,111,67,52,44,44,56,82,
  119,180,222,220,185,144,96,102,148,153,149,130,111,103,178,208,205,204,193,
  168,153,140,136,111,67,71,71,66,71,72,71,94,134,185,217,217,222,222,198,158,
  112,96,78,54,54,71,122,145,160,190,209,205,128,52,42,54,79,71,67,72,66,76,
  145,193,224,224,224,214,185,160,149,114,58,58,58,58,58,71,128,158,170,216,
  229,202,142,94,86,116,162,98,72,98,98,116,197,224,217,136,83,58,56,64,88,137,
  202,184,153,108,137,180,208,212,204,145,107,86,128,160,142,114,79,58,58,83,
  82,86,111,158,216,209,205,205,173,149,160,130,88,86,83,83,88,88,58,48,52,67,
  79,94,149,198,200,212,224,184,149,127,127,128,140,128,112,153,177,177,154,
  127,66,52,59,59,88,144,180,202,198,197,190,170,173,197,128,76,67,44,27,40,66,
  91,98,112,140,173,192,111,66,63,59,72,108,126,128,130,158,200,204,184,126,94,
  76,72,96,136,112,86,72,54,40,66,122,205,220,217,197,205,217,184,173,178,137,
  96,58,54,64,72,126,202,198,174,128,98,76,48,48,67,86,96,88,71,64,148,200,222,
  224,220,192,160,128,78,52,51,58,64,66,114,162,174,193,220,212,174,91,64,64,
  104,108,86,108,126,128,168,214,204,148,59,52,64,98,142,170,112,83,76,108,134,
  154,168,170,158,144,130,130,136,142,129,116,88,58,32,72,98,104,129,158,162,
  173,185,184,190,205,168,120,66,40,34,58,64,44,59,76,76,116,180,198,198,177,
  165,158,144,128,108,111,116,127,153,184,197,148,71,66,71,82,88,88,78,72,71,
  88,126,184,205,214,212,190,158,154,148,136,128,112,79,63,59,145,192,190,134,
  86,66,82,116,129,160,202,198,184,162,154,154,185,184,144,83,32,28,52,86,86,
  78,58,56,64,88,134,193,197,198,200,170,134,91,94,116,126,142,177,165,153,160,
  160,152,126,86,32,39,44,44,78,127,149,177,202,202,198,198,190,170,98,56,48,
  48,54,72,66,51,51,63,88,130,160,128,114,103,102,114,137,128,116,104,112,128,
  160,177,184,180,168,142,120,94,63,47,47,54,58,56,96,142,154,184,229,214,197,
  184,177,173,173,130,63,54,51,42,59,88,127,165,209,205,189,152,104,59,63,59,
  56,71,88,104,165,229,217,209,208,200,180,140,127,111,66,58,79,82,82,88,79,79,
  128,168,209,209,212,220,180,129,79,54,52,67,88,114,165,216,212,209,212,165,
  120,72,64,63,52,67,96,136,165,174,193,209,209,197,177,168,148,108,82,64,64,
  67,72,104,129,160,126,83,94,114,140,162,168,149,160,177,200,198,184,140,122,
  128,153,177,158,137,127,116,98,72,51,42,79,94,94,78,72,76,140,205,216,217,
  214,208,193,168,165,152,103,67,44,64,79,88,122,137,108,83,63,63,76,102,127,
  148,184,200,208,200,185,168,129,111,128,154,185,170,136,86,76,72,79,71,58,86,
  96,86,86,88,96,111,128,112,102,88,128,174,205,212,204,158,126,102,127,142,
  128,122,114,103,96,96,83,72,72,76,83,111,126,127,160,197,220,214,197,197,198,
  198,190,165,111,96,102,116,104,71,96,126,128,153,174,114,82,78,72,82,112,111,
  104,165,197,197,205,214,222,190,148,144,142,142,142,127,67,51,51,64,82,103,
  86,72,78,88,104,126,129,129,136,152,180,197,204,193,190,189,160,142,137,129,
  126,112,94,64,59,63,79,76,67,64,76,96,140,168,160,140,128,165,198,224,228,
  216,184,173,168,154,154,165,136,104,67,67,79,88,96,98,71,59,91,102,112,145,
  142,112,149,173,168,197,224,209,184,154,142,130,130,149,153,83,52,51,40,42,
  67,67,63,67,88,127,144,153,144,148,158,180,178,162,177,185,185,185,178,152,
  136,128,122,98,52,42,47,64,72,79,64,66,91,136,178,180,168,149,154,154,149,
  149,148,142,144,149,154,160,162,160,142,91,58,36,36,40,51,63,86,129,154,168,
  184,184,168,153,144,152,168,184,168,144,108,104,108,126,130,137,120,104,102,
  83,67,59,63,67,71,79,96,126,145,162,168,162,137,122,108,136,165,170,189,205,
  197,168,120,111,119,142,134,114,78,56,56,72,94,104,107,104,112,126,137,149,
  160,174,178,178,149,128,119,158,192,192,180,162,160,154,154,148,128,79,59,54,
  63,66,66,72,88,114,128,140,136,148,170,184,180,130,116,111,120,136,160,158,
  153,153,154,154,142,116,72,71,71,71,71,76,112,130,137,154,165,160,178,200,
  200,189,168,136,119,126,122,116,98,96,103,145,174,174,152,128,112,104,103,
  102,96,91,96,108,128,140,142,158,170,178,154,128,126,122,120,116,108,94,94,
  102,130,168,202,184,170,170,149,128,111,94,72,72,76,79,91,108,142,160,160,
  168,168,168,154,140,136,128,111,107,111,128,129,134,144,149,149,128,119,116,
  108,103,94,94,98,98,107,122,128,140,162,174,178,193,200,193,148,107,102,94,
  88,96,103,103,103,108,128,144,160,137,127,127,120,116,116,119,127,128,128,
  130,137,145,170,180,178,168,153,137,122,104,103,91,78,82,94,116,122,126,128,
  137,153,160,168,168,170,170,160,128,88,88,94,108,120,128,128,129,134,148,152,
  144,122,103,103,104,107,103,108,126,128,128,140,148,158,162,165,162,145,129,
  122,112,107,107,104,102,107,114,126,128,128,127,127,127,119,142,134,114,78,
  56,56,72,94,104,107,104,112,126,137,149,160,174,178,178,149,128,119,158,192,
  192,180,162,160,154,154,148,128,79,59,54,63,142,164,166,159,149,143,143,156,
  160,140,110,78,76,85,103,105,102,92,90,92,104,127,160,164,165,166,154,136,
  112,107,120,125,133,152,149,141,145,146,143,128,109,83,80,84,84,97,123,138,
  152,165,167,165,165,161,156,118,91,87,86,88,97,97,88,87,91,104,127,147,131,
  121,115,113,118,132,129,122,116,118,126,142,154,158,156,151,138,125,112,96,
  85,85,88,91,90,106,135,142,154,177,175,165,159,155,152,152,138,99,90,88,84,
  90,103,123,144,168,170,163,144,120,92,93,93,90,96,104,114,141,181,176,172,
  170,166,159,139,127,121,98,89,100,103,103,106,103,98,123,147,168,171,171,175,
  160,134,106,90,88,95,104,118,143,174,172,171,172,152,127,103,94,93,89,93,109,
  129,147,152,161,171,171,166,155,150,142,120,105,94,94,96,98,112,128,142,129,
  103,108,117,132,145,152,142,144,152,164,167,159,139,123,126,139,156,145,136,
  128,122,114,101,89,80,99,109,109,102,97,100,129,168,173,175,174,171,165,152,
  148,145,118,98,85,92,101,106,121,137,120,106,94,93,97,111,124,136,154,166,
  170,167,161,151,134,116,127,140,158,152,138,110,100,99,101,99,91,103,111,106,
  105,105,109,117,127,121,114,107,125,150,167,173,170,148,127,115,123,137,130,
  125,121,115,111,111,105,99,99,100,102,115,125,126,142,162,174,174,164,164,
  165,165,161,153,123,111,112,120,118,100,109,124,128,139,156,126,104,101,99,
  100,116,119,112,143,164,164,168,172,177,165,140,138,136,136,136,131,101,87,
  87,93,101,112,107,99,101,106,113,123,130,130,133,138,154,163,168,164,161,160,
  148,136,134,131,126,120,111,96,92,92,100,101,97,95,98,109,131,151,147,137,
  124,145,163,176,180,177,160,152,150,144,143,148,135,118,99,95,102,106,110,
  112,99,90,106,113,116,135,138,121,137,153,150,161,179,172,161,145,137,131,
  131,138,148,110,88,87,82,81,94,96,93,95,104,123,136,143,138,139,142,154,157,
  148,153,159,159,159,158,143,134,129,125,115,92,83,83,92,99,102,96,93,106,129,
  155,156,152,141,142,144,141,140,139,137,137,139,143,146,147,145,140,113,93,
  81,80,82,86,92,101,126,142,148,156,159,151,143,137,141,147,157,151,140,120,
  115,115,124,130,134,124,116,113,105,96,92,92,95,97,100,109,122,137,146,150,
  148,136,125,118,130,147,151,158,169,165,153,127,119,119,134,134,122,104,90,
  90,98,108,114,116,115,118,123,132,139,145,152,155,156,142,130,123,140,162,
  162,157,148,145,143,143,139,132,106,92,89,93,95,95,98,104,118,128,135,134,
  137,149,157,160,135,121,118,122,130,144,145,142,142,143,143,137,125,102,97,
  97,97,97,97,116,130,134,141,148,146,152,166,166,162,152,136,122,124,124,123,
  114,110,114,134,153,153,144,129,120,115,114,113,112,109,110,115,127,135,136,
  143,150,155,146,127,126,124,123,121,118,110,109,111,128,146,164,159,151,151,
  142,128,120,110,100,99,100,102,107,114,133,145,146,149,150,150,144,135,134,
  128,119,116,117,126,130,132,137,140,140,131,122,121,118,114,110,109,111,112,
  114,123,128,133,145,152,154,161,167,164,144,116,113,110,106,110,114,114,114,
  115,126,136,145,136,126,126,123,121,121,122,125,127,128,131,133,136,149,156,
  156,150,143,135,125,115,114,110,101,103,108,119,123,125,127,132,141,145,149,
  149,150,152,146,132,109,106,108,116,122,128,129,130,131,138,142,138,126,114,
  114,114,116,115,116,123,126,128,134,139,143,146,148,147,140,131,125,120,117,
  116,115,113,115,119,124,127,127,126,126,126,130,135,136,140,146,145,139,127,
  123,123,127,130,131,126,122,122,123,126,128,126,123,123,123,124,125,126,125,
  125,125,127,128,131,134,138,138,137,136,133,130,127,127,126,123,120,118,121,
  122,122,121,121,121,124,129,130,130,132,134,137,142,144,144,140,137,132,130,
  128,128,127,126,123,122,123,124,125,126,125,124,122,122,122,123,124,126,128,
  129,130,130,130,132,134,134,135,135,133,132,132,127,123,123,122,122,122,120,
  118,118,118,121,123,127,130,132,132,137,141,143,138,130,129,128,127,129,130,
  126,124,123,123,124,128,124,120,120,119,119,122,124,124,123,123,124,126,130,
  130,131,131,132,133,133,132,131,131,131,132,131,130,130,130,129,126,122,117,
  119,121,121,122,123,123,128,137,140,141,144,144,143,135,130,130,127,125,125,
  122,118,118,121,125,129,131,125,124,124,126,128,129,127,125,125,126,128,128,
  129,131,132,133,133,133,131,129,128,128,125,123,123,125,129,129,128,128,127,
  127,127,127,126,126,125,125,126,128,128,128,130,130,132,136,137,138,140,138,
  134,127,124,124,126,126,124,124,124,124,126,129,130,130,130,131,131,131,129,
  125,123,122,122,122,122,122,124,130,131,131,131,130,129,128,128,128,128,128,
  130,130,128,128,127,127,127,126,125,124,123,123,123,124,125,125,125,125,127,
  129,131,132,133,133,133,133,134,134,133,133,131,129,127,126,124,124,122,121,
  121,124,131,133,132,130,129,128,129,130,130,130,128,126,126,126,126,127,127,
  128,128,130,132,132,133,132,131,129,127,127,128,129,131,132,132,132,131,130,
  129,128,127,125,125,125,125,125,126,128,128,128,128,129,131,131,131,130,128,
  127,127,129,132,132,131,130,130,129,127,127,127,127,128,129,129,129,129,130,
  129,127,126,126,126,127,129,130,129,129,129,128,128,128,128,128,128,128,128,
  128,128,128,128,128,128,129,130,130,129,129,129,127,126,126,126,127,127,128,
  128,128,127,127,127,127,127,126,126,128,130,130,131,130,130,130,130,131,131,
  131,132,131,129,128,128,128,128,128,128,128,128,128,128,128,128,127,126,125,
  124,124,126,129,131,131,131,130,130,129,129,129,128,127,126,126,128,129,129,
  130,129,129,129,129,129,129,129,127,127,127,127,127,128,129,130,131,131,131,
  130,128,128,127,126,126,126,126,126,126,127,128,128,128,129,129,129,130,130,
  131,131,132,131,129,129,129,129,129,129,127,125,125,125,126,127,127,127,127,
  127,127,128,128,128,128,128,128,129,129,129,129,129,129,129,130,130,129,129,
  129,129,129,129,127,127,127,127,127,128,129,129,130,130,130,130,129,129,129,
  129,129,128,127,127,128,128,128,128,128,128,128,128,128,128,127,127,128,129,
  129,130,131,131,131,130,130,129,129,129,129,129,129,129,129,129,129,130,130,
  130,129,129,129,129,129,129,128,127,126,126,126,126,126,127,128,128,129,129,
  129,129,129,128,128,128,128,128,128,129,129,129,128,128,127,127,127,127,127,
  127,126,126,126,128,128,129,129,129,129,129,130,130,130,129,128,128,128,129,
  130,130,130,129,129,129,130,130,129,127,127,127,127,128,128,128,128,129,129,
  129,129,129,130,130,129,129,129,129,129,128,127,127,127,127,127,127,127,127,
  128,128,128,128,128,128,128,128,128,128,128,128,129,130,130,129,128,128,128,
  129,129,128,128,128,128,128,128,128,128,128,128,128,128,128,128,129,129,128,
  128,128,128,128,128,129,129,128,128,128,128,128,129,130,130,129,129,129,129,
  129,130,129,128,127,127,127,127,127,127,127,127,128,128,129,129,129,129,129,
  129,129,129,130,132,132,131,129,129,128,128,128,127,126,126,126,126,126,126,
  127,128,128,128,129,129,130,131,132,131,130,129,129,129,130,130,131,130,129,
  128,127,127,127,127,126,126,127,128,128,128,129,129,130,131,131,130,130,130,
  129,129,128,128,128,129,130,130,130,130,130,129,129,127,126,126,126,126,126,
  127,127,128,128,129,130,130,129,128,128,128,128,128,129,128,128,127,127,127,
  127,127,128,127,126,126,126,127,128,128,127,127,127,128,128,129,128,128,128,
  129,129,130,130,129,129,129,128,127,127,127,127,127,127,127,127,128,128,128,
  128,128,128,128,128,129,129,129,129,130,130,130,129,128,127,127,127,127,127,
  127,127,128,128,129,129,129,130,130,130,130,130,130,130,130,130,130,129,128,
  128,127,127,127,127,127,128,129,129,128,128,128,128,128,128,128,128,128,128,
  129,130,131,131,130,130,129,128,128,128,128,127,127,127,128,129,130,130,130,
  130,129,129,129,129,128,128,128,129,129,129,129,129,129,128,127,127,127,127,
  127,127,128,129,129,129,130,130,129,129,128,128,128,129,128,128,128,128,128,
  128,128,128,129,129,130,130,130,130,130,129,128,128,127,127,127,128,128,128,
  128,128,128,127,127,126,126,126,126,127,128,128,129,130,130,130,130,130,129,
  129,128,128,128,128,128,128,127,127,127,128,128,128,128,128,128,128,128,128,
  128,128,128,129,130,130,131,132,132,130,128,128,127,127,126,126,126,126,126,
  126,127,127,129,130,130,130,129,129,128,128,128,127,127,127,128,130,131,131,
  131,131,131,129,128,128,127,126,126,126,127,128,128,128,129,130,130,130,130,
  130,129,128,127,127,127,127,127,127,128,129,130,129,129,128,127,126,126,126,
  126,127,127,127,127,128,129,129,130,130,130,129,129,127,126,126,126,127,127,
  127,127,129,130,130,130,129,128,127,126,126,127,127,127,128,128,129,129,129,
  129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,128,128,128,127,
  127,127,127,127,128,129,129,129,130,130,130,130,131,130,130,129,128,128,128,
  128,128,129,129,128,128,128,128,128,129,128,128,128,128,128,129,129,128,128,
  128,128,129,129,129,129,130,129,129,128,128,128,128,128,127,127,127,128,129,
  129,129,129,130,129,129,129,128,128,128,128,129,130,130,130,130,130,129,128,
  128,128,128,129,128,128,128,128,128,127,127,126,126,126,126,127,128,129,129,
  129,129,129,128,128,127,127,127,127,127,127,128,129,130,129,129,128,127,126,
  126,126,126,126,126,127,130,130,130,130,131,130,130,130,129,128,127,127,127,
  127,127,127,127,127,128,128,128,128,128,128,129,129,129,129,129,129,129,130,
  131,131,131,130,130,129,129,129,129,129,128,127,126,126,126,126,127,127,128,
  129,129,130,130,131,131,129,129,128,128,128,128,127,127,127,128,128,128,128,
  128,128,128,128,128,128,128,128,128,128,128,128,129,131,131,130,130,129,128,
  128,128,128,128,128,128,128,128,128,129,129,129,129,129,129,128,128,127,127,
  127,127,127,128,129,129,129,131,131,130,130,129,129,129,129,129,129,129,129,
  129,128,128,128,128,128,128,128,129,129,129,128,128,128,129,129,129,129,129,
  129,129,129,129,129,128,128,128,128,128,128,128,128,128,128,128,128,129,129,
  130,130,130,129,129,129,129,128,128,128,128,128,128,129,129,129,128,128,127,
  127,127,127,126,126,126,127,129,131,131,131,130,129,128,128,128,128,128,128,
  128,128,128,128,128,128,128,128,128,128,128,128,128,129,129,129,129,129,129,
  129,129,129,129,128,128,128,128,128,128,128,128,128,127,126,126,126,126,127,
  127,128,129,129,129,129,129,128,128,128,128,128,128,128,129,129,129,129,129,
  129,128,128,128,129,129,130,129,129,129,129,129,128,128,128,128,128,128,128,
  129,129,129,129,128,128,128,128,129,130,130,130,130,130,129,129,129,128,128,
  127,127,127,128,128,128,128,128,128,129,129,129,128,128,128,128,128,128,128,
  128,129,129,129,129,128,128,128,128,128,128,127,127,127,127,127,127,127,127,
  127,127,129,131,131,131,130,130,129,128,127,127,127,127,126,126,127,127,128,
  129,129,128,128,128,128,128,128,128,129,130,131,132,132,132,130,129,129,128,
  126,126,126,127,128,128,128,129,129,129,129,129,128,128,128,128,129,129,128,
  128,128,128,128,129,129,129,129,129,128,128,128,128,128,128,127,127,127,127,
  127,127,128,128,128,128,128,129,129,129,129,129,128,128,128,129,129,129,128,
  128,128,128,128,128,128,127,127,127,127,127,127,127,127,127,128,130,131,131,
  131,131,131,130,130,130,129,129,127,127,127,128,128,128,129,129,127,127,127,
  127,128,128,128,128,129,129,129,130,130,130,130,130,129,128,128,127,127,127,
  127,127,127,127,127,127,127,127,127,127,128,129,129,129,130,130,130,129,129,
  129,129,128,128,128,128,128,128,128,128,127,127,127,127,127,128,128,128,129,
  129,129,130,130,131,131,131,130,129,129,129,129,129,129,129,128,128,128,129,
  128,128,128,128,129,130,130,129,128,128,128,128,128,128,129,130,130,130,130,
  130,129,128,128,127,127,127,127,127,128,128,128,129,129,129,130,130,128,128,
  128,128,128,128,128,128,128,128,128,129,129,129,128,128,128,128,128,128,128,
  128,128,128,128,128,128,128,128,128,129,129,129,129,129,129,128,128,128,128,
  129,129,129,130,129,129,129,129,127,126,126,126,127,127,127,127,128,128,128,
  129,129,129,128,128,128,128,128,127,127,127,128,128,129,129,129,129,128,126,
  126,126,126,126,126,126,128,128,128,129,130,131,131,130,130,130,129,129,128,
  128,128,128,128,128,129,129,130,130,130,129,128,127,127,127,127,128,128,129,
  130,130,130,130,131,130,130,130,129,129,128,128,127,127,127,128,128,128,128,
  128,129,129,129,128,128,128,128,128,128,128,128,129,129,129,129,129,129,129,
  129,129,128,128,127,127,126,126,126,127,128,129,130,130,130,129,129,128,128,
  128,128,128,128,129,129,129,129,129,129,129,128,128,128,129,129,129,128,128,
  128,128,128,128,128,128,128,128,128,128,128,129,129,129,129,129,129,129,129,
  128,127,127,127,127,127,127,127,128,128,128,128,128,128,128,128,128,129,129,
  129,130,130,130,130,130,129,127,127,127,127,127,127,127,127,127,127,128,128,
  129,129,129,129,129,129,129,129,129,129,128,128,128,128,129,129,129,129,128,
  128,128,128,128,128,128,128,129,130,130,130,130,129,128,128,128,129,129,129,
  128,128,128,128,128,129,129,128,128,128,128,128,128,127,127,127,127,127,127,
  127,129,130,130,129,128,128,128,128,128,128,128,128,129,129,130,130,130,129,
  129,129,129,129,129,129,128,128,128,129,129,129,129,129,127,127,127,127,128,
  128,129,129,129,130,130,130,130,130,129,129,129,128,128,127,127,127,127,127,
  127,127,129,130,130,130,130,130,130,130,130,130,129,129,128,127,127,127,127,
  127,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,129,129,129,
  129,129,129,129,129,128,128,128,128,128,128,128,128,128,128,128,129,129,129,
  128,128,128,128,128,128,128,128,128,129,130,130,130,131,131,129,129,129,128,
  128,128,127,127,127,128,128,128,127,127,127,127,127,128,128,128,128,128,128,
  128,129,128,128,128,128,128,128,128,129,129,129,129,129,129,128,128,128,128,
  128,127,127,127,128,129,129,129,129,129,129,129,129,128,128,127,127,127,127,
  127,127,128,128,129,129,129,129,129,130,130,130,129,129,129,129,130,131,130,
  130,129,128,128,128,128,127,127,127,127,127,128,128,128,128,128,128,129,129,
  129,130,130,129,128,128,128,128,128,127,127,127,127,127,127,127,128,128,128,
  128,129,129,128,128,128,128,128,128,128,128,129,129,129,129,129,129,129,129,
  128,128,128,128,128,128,128,128,128,128,129,130,130,130,130,130,129,129,129,
  129,129,129,129,129,129,129,129,130,130,129,129,129,128,128,128,128,128,128,
  128,128,129,129,129,129,129,128,127,127,127,127,128,128,128,129,129,129,130,
  130,130,129,129,128,128,128,128,128,127,127,127,128,129,129,129,129,128,128,
  128,128,128,128,129,129,130,130,130,130,129,129,129,129,128,128,128,128,128,
  128,127,127,127,128,128,128,128,128,129,129,129,129,129,129,129,129,128,128,
  128,128,128,129,128,127,127,127,127,127,127,127,128,128,128,128,129,129,129,
  128,128,128,128,128,128,129,129,129,129,129,128,128,128,127,126,126,126,127,
  128,128,128,128,128,128,130,130,130,129,128,128,128,129,129,129,129,129,129,
  130,130,130,129,129,128,128,128,127,127,127,128,128,129,129,129,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,129,129,128,
  127,127,128,128,128,128,128,128,128,129,130,130,130,130,130,129,129,129,128,
  127,127,127,127,127,128,128,129,129,128,128,128,128,128,128,128,128,128,128,
  129,130,130,130,129,129,129,129,129,128,127,127,127,127,127,127,127,127,128,
  128,128,128,128,128,128,128,129,129,129,129,129,129,129,129,129,129,129,129,
  128,128,128,128,128,128,127,127,127,127,127,128,129,129,130,130,129,128,128,
  128,128,128,128,128,128,128,128,129,129,129,128,128,127,127,127,127,127,127,
  127,127,128,128,128,128,129,129,129,129,128,128,128,129,129,129,129,129,129,
  129,129,129,128,128,127,127,128,129,129,128,128,128,128,129,130,131,131,131,
  130,130,129,129,129,128,128,128,128,128,128,128,128,127,127,127,127,127,127,
  127,128,128,128,128,129,129,129,129,129,129,129,129,129,129,129,129,129,128,
  128,127,127,127,128,128,128,128,128,128,128,128,129,129,129,130,130,130,130,
  130,129,129,129,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
  128,128,128,129,129,129,130,131,131,131,131,130,130,130,129,128,128,127,127,
  127,127,127,127,127,127,128,128,129,128,128,128,128,128,128,128,
};

static const char dsdgact[] = {
  3,0,17,43,161,27,0,0,110,126,125,125,126,128,131,134,134,135,134,133,129,126,
  118,110,100,92,91,106,122,138,138,138,139,144,144,127,111,96,115,128,136,135,
  135,149,156,160,141,129,122,123,121,110,107,110,125,135,141,145,149,153,143,
  127,91,63,47,67,95,128,139,139,151,163,174,141,110,93,112,140,134,126,115,
  141,164,165,149,127,129,129,129,121,118,135,153,168,154,133,105,65,36,31,66,
  113,133,138,130,159,180,176,134,83,86,110,153,150,149,159,181,203,180,154,
  125,121,120,120,126,135,139,107,42,18,27,96,130,144,93,96,146,189,184,90,61,
  70,173,213,199,158,146,196,198,178,122,106,121,141,149,134,134,130,71,23,1,
  48,108,155,111,58,117,178,241,127,48,42,136,238,215,178,133,189,215,185,125,
  73,107,138,166,126,82,40,28,32,65,106,154,125,107,112,150,178,112,71,48,153,
  225,244,200,158,188,190,174,108,82,117,155,171,91,43,21,42,72,113,102,92,134,
  168,195,120,68,56,122,196,231,215,169,193,203,191,130,75,75,122,195,117,60,
  31,42,70,120,110,66,115,156,190,112,41,70,153,255,226,186,143,173,201,184,
  126,47,76,112,158,92,31,48,70,93,107,106,83,102,121,116,122,138,209,236,211,
  184,164,174,170,155,81,46,56,117,155,108,72,45,82,107,118,92,77,105,136,166,
  148,151,181,200,204,170,155,150,168,166,146,134,134,158,151,126,52,25,46,53,
  66,95,103,106,151,184,204,123,63,85,159,245,213,185,161,176,183,159,110,53,
  46,43,45,52,65,86,95,101,123,163,219,150,90,70,117,185,199,201,194,190,181,
  163,151,144,139,96,15,33,58,77,103,125,85,105,176,171,134,47,73,139,186,200,
  185,146,131,169,140,93,63,65,92,95,88,71,93,123,117,113,110,136,143,108,106,
  122,176,203,205,196,181,156,146,146,173,161,120,70,42,55,117,164,66,47,91,
  181,210,129,92,87,174,199,179,159,158,185,176,145,56,35,62,96,103,65,71,96,
  148,144,100,117,136,160,116,72,111,166,231,209,191,183,161,146,171,160,126,
  67,38,56,115,158,108,85,78,170,200,141,90,68,155,184,173,154,145,151,151,131,
  47,36,70,134,139,61,67,102,170,149,77,90,118,169,129,95,146,179,199,190,179,
  168,170,161,111,77,56,65,98,164,112,61,87,145,215,111,66,97,169,223,194,155,
  115,166,175,128,81,50,75,123,178,88,55,85,155,188,96,78,102,131,143,134,174,
  206,190,181,175,170,153,125,77,45,58,102,153,86,63,88,156,184,87,83,127,181,
  200,180,100,57,135,160,153,77,62,111,158,163,68,62,97,151,145,76,87,110,135,
  161,186,186,185,180,175,168,155,98,31,57,78,95,151,165,72,70,106,154,158,121,
  160,188,174,110,40,73,131,216,173,122,82,129,191,131,92,71,78,86,88,96,113,
  185,206,180,175,171,170,141,105,70,61,76,128,164,165,135,106,133,115,57,73,
  105,153,173,180,169,170,181,169,139,78,63,66,73,80,82,86,117,194,193,159,85,
  65,88,108,141,201,200,181,175,170,164,129,93,53,56,70,77,97,128,126,128,140,
  154,154,86,81,122,180,209,189,179,170,164,138,100,72,58,67,76,85,87,93,103,
  120,123,108,163,218,193,176,166,86,61,117,159,173,87,91,150,173,160,96,83,85,
  91,93,95,116,149,199,198,185,179,173,166,120,87,75,78,97,155,163,141,159,166,
  160,96,42,71,115,165,169,169,165,164,161,155,108,40,57,70,77,80,83,92,135,
  196,178,141,82,77,86,102,151,216,191,174,166,155,138,106,81,60,68,82,101,125,
  133,100,100,113,106,125,173,183,184,179,138,85,90,121,184,148,106,91,125,173,
  134,100,68,78,93,105,118,136,188,205,185,179,164,129,96,66,75,82,87,102,131,
  194,196,168,102,76,88,127,163,184,183,165,85,71,126,164,174,123,98,95,161,
  159,91,80,85,115,128,129,96,116,186,181,174,173,153,128,113,91,60,70,83,101,
  148,198,180,155,122,82,62,85,148,213,185,158,129,107,105,141,128,101,93,96,
  106,100,93,92,118,148,139,116,81,101,135,196,195,175,173,154,125,102,85,75,
  76,83,100,134,185,163,148,148,145,134,95,85,97,158,191,176,169,160,130,127,
  140,88,57,67,75,87,128,145,145,123,105,95,113,140,178,186,175,136,102,72,102,
  140,144,113,57,118,160,173,115,57,78,100,120,175,201,183,173,165,161,131,85,
  72,70,81,85,87,98,125,158,154,138,103,123,155,179,179,163,92,63,92,145,185,
  161,136,115,129,126,98,78,67,83,101,117,126,149,191,186,175,171,163,151,106,
  77,68,72,90,136,153,149,148,153,169,127,85,75,83,107,166,193,176,161,145,129,
  111,92,93,87,73,75,82,102,138,180,164,146,129,100,78,86,131,194,180,170,165,
  136,118,134,107,62,75,87,101,151,179,129,108,100,95,101,121,171,206,185,163,
  136,86,87,144,145,131,98,97,110,115,110,96,105,113,113,117,129,186,205,186,
  168,134,68,85,133,140,120,71,106,149,191,174,134,118,112,116,88,72,87,135,
  190,185,180,178,174,170,161,105,41,65,80,90,146,176,140,155,181,171,134,72,
  71,76,80,112,151,171,176,170,168,164,160,135,102,68,58,67,102,134,159,122,81,
  146,159,126,87,85,151,163,154,133,110,85,144,164,108,85,83,143,136,77,80,93,
  125,139,141,118,126,156,144,135,135,156,179,171,163,153,154,138,92,73,66,78,
  116,173,100,61,81,123,160,154,160,176,170,155,126,100,86,131,129,93,108,134,
  175,153,113,73,76,108,110,102,86,116,146,143,125,97,158,189,176,155,141,163,
  166,158,127,96,66,70,82,98,100,91,115,139,166,140,111,115,148,198,181,164,
  145,131,126,139,123,91,107,130,164,134,100,85,91,110,100,102,118,145,158,116,
  97,96,151,180,175,166,161,170,166,156,143,134,134,93,60,68,81,96,128,127,86,
  112,139,139,108,63,101,144,196,189,175,168,163,160,143,121,90,86,83,72,77,91,
  112,121,117,128,143,159,130,86,88,111,155,166,166,148,159,181,170,150,122,
  134,148,150,135,117,118,108,88,73,67,80,107,135,97,87,106,141,155,118,126,
  153,176,181,169,149,141,164,159,136,81,81,135,138,120,65,61,81,133,136,98,92,
  108,161,156,128,105,126,189,180,161,130,135,151,164,148,108,105,115,146,136,
  117,120,133,156,115,80,70,72,81,102,113,116,143,166,181,161,135,133,148,174,
  161,148,133,141,153,140,117,85,88,103,131,127,110,72,62,76,93,116,144,129,
  111,136,161,186,146,121,120,151,183,155,127,98,136,154,135,103,78,103,116,
  118,97,96,130,148,155,131,131,146,140,116,65,68,92,136,151,145,130,136,171,
  166,146,108,101,113,128,128,107,120,140,165,163,139,115,103,113,117,117,105,
  107,118,122,118,105,107,115,130,135,133,135,141,150,143,131,122,127,143,144,
  139,127,127,128,130,122,110,110,113,123,127,127,127,129,133,133,131,130,130,
  129,129,131,138,140,138,128,113,102,102,108,120,121,123,125,131,136,135,128,
  118,122,129,138,135,133,133,140,150,149,143,130,125,121,117,113,110,115,121,
  130,135,139,140,131,117,91,82,92,117,135,131,131,136,158,164,153,136,128,138,
  136,129,107,102,113,128,134,123,120,120,128,129,122,117,116,122,126,129,129,
  134,141,143,141,138,135,131,128,123,117,110,103,97,105,118,134,136,125,116,
  115,129,133,130,123,127,141,145,143,131,133,136,135,126,107,107,112,126,127,
  126,126,128,133,127,123,123,131,141,141,134,122,107,97,96,105,117,122,126,
  128,141,150,150,138,125,123,127,134,128,123,122,125,128,128,128,129,131,130,
  125,120,116,121,123,125,128,131,136,138,139,136,135,135,130,128,125,123,123,
  126,128,129,130,129,123,115,108,108,113,122,125,125,122,123,127,133,134,133,
  133,134,139,140,139,133,130,130,133,134,130,130,129,129,126,121,121,121,123,
  123,122,122,126,131,131,129,125,127,128,122,111,97,107,120,133,130,126,126,
  134,148,140,129,116,118,123,123,118,110,118,128,138,133,127,125,128,133,128,
  125,122,126,130,130,129,129,130,131,131,133,134,134,130,123,122,122,127,125,
  121,121,123,128,125,121,115,120,125,128,123,115,113,115,118,121,122,126,129,
  133,133,135,138,139,138,134,131,130,130,128,123,123,125,129,130,129,128,128,
  128,126,121,117,118,122,127,129,129,131,134,134,131,128,126,125,125,122,117,
  111,112,116,125,129,131,129,129,133,136,139,131,127,122,125,128,128,125,122,
  127,130,134,131,129,129,129,130,126,123,121,125,128,129,130,130,130,129,129,
  126,123,123,125,128,130,131,131,134,135,135,133,129,126,125,125,126,125,123,
  123,125,126,126,125,117,112,111,116,123,129,129,125,127,130,135,134,130,128,
  129,131,130,128,123,126,130,134,134,131,130,130,130,126,121,116,117,121,123,
  127,130,131,131,130,128,126,127,127,125,123,123,126,128,128,127,125,118,113,
  111,117,123,128,125,123,125,128,131,129,126,122,126,129,129,128,127,131,136,
  140,135,131,129,131,134,131,129,126,126,125,122,118,117,121,123,126,126,127,
  133,134,133,128,127,129,130,129,127,127,128,129,129,127,126,125,127,125,120,
  113,112,113,123,129,130,129,128,133,136,139,136,134,131,131,130,127,126,126,
  129,131,131,129,126,126,126,126,125,123,125,128,129,127,126,126,126,126,123,
  125,128,135,136,134,128,123,121,121,121,117,115,112,117,123,131,136,139,135,
  130,127,127,127,126,123,123,128,130,131,127,125,125,127,128,128,128,128,133,
  134,134,129,127,128,129,128,126,125,125,127,128,128,127,127,127,125,120,118,
  120,123,126,128,130,134,136,134,130,126,127,130,128,125,120,123,127,131,128,
  122,117,117,120,122,125,125,127,130,134,136,136,135,135,135,134,131,129,128,
  127,126,125,123,123,126,126,126,126,125,125,125,126,128,131,133,131,131,131,
  131,130,128,123,121,121,121,121,121,125,129,130,129,127,127,128,128,125,121,
  120,122,126,128,128,127,127,127,127,125,122,122,121,121,122,126,128,129,129,
  129,129,129,130,131,131,131,131,130,129,126,125,125,125,126,126,125,125,125,
  126,128,129,130,130,128,127,127,127,127,125,125,125,128,130,129,125,122,126,
  127,126,125,125,127,129,130,129,129,129,129,127,125,122,121,125,128,131,130,
  130,131,130,128,127,128,131,133,131,129,128,127,127,126,125,125,126,129,130,
  130,127,126,125,125,126,126,128,130,130,130,130,131,133,133,128,123,122,122,
  125,125,127,129,133,135,131,126,121,125,128,129,127,126,126,126,125,123,122,
  123,125,123,120,120,121,125,127,127,126,126,126,126,126,126,125,121,121,123,
  129,131,131,130,130,131,130,128,123,122,121,123,126,128,127,126,121,120,120,
  123,126,126,122,118,120,125,130,130,129,127,129,131,134,130,125,123,125,128,
  129,130,130,133,134,131,128,126,127,128,128,125,121,121,122,127,133,135,135,
  134,131,131,130,128,126,123,123,125,128,130,130,129,127,125,123,122,121,121,
  122,125,128,131,131,127,123,125,127,130,129,127,123,123,125,129,129,128,123,
  121,123,126,128,126,122,121,123,127,130,130,130,131,134,136,135,131,126,125,
  123,122,122,122,127,130,134,134,131,129,127,127,125,123,122,123,126,128,130,
  130,130,130,131,131,129,126,122,120,122,125,128,129,129,129,127,125,120,117,
  117,120,123,126,127,128,131,134,135,131,127,122,122,126,127,126,121,122,126,
  131,134,133,131,130,130,127,125,122,121,121,122,126,128,131,134,134,134,131,
  131,130,128,126,125,123,123,123,125,127,129,130,129,128,128,129,129,129,129,
  128,128,128,127,125,123,123,125,125,123,122,121,120,120,122,128,129,130,130,
  131,133,131,129,125,125,125,125,123,122,123,126,129,130,129,129,130,131,129,
  126,121,122,126,129,130,128,128,129,131,133,131,130,128,125,122,122,122,120,
  121,125,129,134,134,134,133,129,126,125,125,125,125,125,126,127,127,127,125,
  122,121,121,121,120,120,125,127,129,129,129,129,127,127,127,129,131,129,128,
  127,128,128,128,127,127,127,127,129,131,131,131,131,131,129,128,127,127,128,
  129,131,134,134,133,129,125,122,122,123,126,128,130,130,133,133,129,127,126,
  126,125,122,122,122,122,122,121,120,117,115,117,121,127,129,130,129,128,128,
  129,130,128,125,122,127,129,130,126,121,120,125,130,130,128,125,128,131,134,
  131,128,128,129,130,128,126,126,127,130,130,129,129,129,129,129,128,126,123,
  123,123,126,128,130,131,131,129,127,126,125,125,125,126,126,123,122,121,120,
  118,116,122,128,133,131,127,127,128,134,131,128,125,123,126,126,125,120,123,
  127,131,131,129,130,133,138,135,133,128,127,127,126,125,125,126,127,129,129,
  127,127,126,123,121,120,120,121,122,128,134,140,139,136,133,131,130,129,126,
  121,121,121,125,126,123,118,116,116,122,128,128,126,121,121,123,127,126,123,
  122,126,131,131,129,126,126,128,131,134,133,130,130,133,135,134,127,122,121,
  127,129,127,121,117,122,129,136,136,134,131,131,129,126,122,121,122,125,128,
  131,135,136,138,138,134,130,126,126,125,123,121,117,115,115,115,121,127,133,
  134,131,129,129,131,127,121,112,115,120,128,130,127,128,131,140,139,134,129,
  128,128,127,127,127,128,130,135,135,130,122,117,121,125,128,129,130,130,129,
  129,129,127,125,122,123,127,133,136,138,135,131,128,122,116,112,112,116,118,
  121,122,122,121,115,113,118,129,139,139,138,136,135,134,131,128,123,123,123,
  125,127,128,128,128,128,128,125,121,118,120,123,126,128,131,135,139,135,133,
  131,130,127,120,116,115,126,134,136,127,116,110,110,113,125,133,139,134,127,
  127,130,136,133,128,120,117,117,123,127,128,123,121,121,129,136,143,146,149,
  140,127,108,100,96,102,110,118,125,129,129,130,133,138,140,139,139,136,133,
  135,138,144,139,129,112,105,108,120,129,126,120,111,112,118,130,149,164,164,
  149,128,120,116,120,123,127,135,136,133,118,112,117,126,130,125,120,117,118,
  122,129,135,138,127,118,113,131,144,153,143,131,127,129,134,125,108,83,77,85,
  122,146,163,140,127,123,126,129,129,143,159,146,134,121,134,146,143,127,105,
  95,92,97,111,125,140,144,143,151,159,165,130,93,61,83,127,161,165,135,108,87,
  83,93,112,141,153,143,130,128,149,153,148,118,98,88,106,126,143,149,151,151,
  148,140,110,80,60,91,139,173,164,117,115,121,139,129,115,130,136,134,111,105,
  134,151,159,125,101,87,122,154,173,166,149,130,110,86,71,75,107,131,146,120,
  107,107,131,148,148,151,153,145,126,98,107,123,153,145,125,97,110,153,178,
  181,151,118,86,66,76,110,146,161,136,113,97,112,130,150,158,155,138,117,102,
  118,136,156,143,134,134,150,165,155,120,67,32,27,66,123,173,166,148,121,126,
  130,136,143,149,148,131,105,96,102,129,143,150,145,151,166,174,164,126,66,21,
  46,100,170,170,155,122,111,111,128,153,181,174,158,129,126,126,120,102,77,
  106,134,165,117,61,33,75,154,186,174,103,88,93,125,138,140,148,148,138,138,
  146,175,180,171,135,112,103,117,126,105,76,47,78,122,180,179,164,139,128,123,
  113,105,98,95,96,110,131,156,158,160,165,176,175,133,72,7,40,88,156,145,128,
  120,133,156,151,158,179,175,159,117,101,100,140,169,185,170,139,77,42,23,53,
  112,200,150,95,67,90,131,144,151,154,160,160,148,135,127,131,148,174,168,138,
  65,43,56,149,195,196,125,77,103,122,133,91,78,93,123,141,133,123,120,165,186,
  185,128,76,41,51,82,148,169,151,141,141,158,158,154,170,174,169,133,116,134,
  150,156,103,60,26,40,57,71,93,122,171,189,179,113,68,66,125,193,200,164,90,
  118,156,201,195,170,140,131,139,87,52,52,91,128,91,75,75,115,138,130,133,144,
  181,179,145,101,85,117,148,165,113,87,81,156,201,195,170,139,95,116,181,150,
  106,45,51,85,150,153,113,80,85,151,180,180,103,71,71,93,134,201,203,190,184,
  176,168,154,145,145,143,131,83,60,50,62,98,170,138,91,70,88,133,173,164,90,
  76,85,123,154,180,185,185,178,170,159,130,136,161,144,106,42,46,62,67,96,135,
  121,117,129,161,173,111,80,71,106,146,195,185,170,171,169,164,128,105,97,125,
  131,57,46,66,85,126,194,123,63,101,150,200,158,112,63,73,110,190,201,180,174,
  168,163,120,91,121,141,151,71,40,66,93,125,163,122,55,129,168,168,113,70,78,
  102,133,168,173,148,163,175,168,154,136,96,70,57,65,75,83,139,199,105,73,105,
  164,198,166,108,46,70,118,189,184,175,171,170,168,163,150,128,80,50,66,75,86,
  129,123,73,90,126,195,190,151,81,60,85,148,189,178,174,171,170,168,165,154,
  123,53,53,77,87,127,191,111,58,83,143,200,174,122,47,70,103,148,169,179,176,
  173,169,164,154,136,92,48,66,81,93,130,136,82,92,125,170,175,150,96,68,90,
  150,208,185,171,165,151,148,161,138,105,72,63,72,82,107,153,126,92,134,159,
  174,108,73,91,143,190,175,168,165,164,159,146,102,61,70,77,81,102,126,156,
  128,96,117,138,156,125,106,108,148,185,174,168,165,164,156,143,92,48,66,77,
  83,102,107,93,108,134,170,149,95,95,116,164,175,176,173,170,168,156,130,87,
  75,73,80,97,117,103,98,105,118,126,110,113,128,179,200,183,174,169,168,165,
  160,117,85,66,72,82,90,97,105,116,121,118,106,100,111,150,201,189,180,176,
  173,170,166,138,97,76,68,77,98,117,125,116,102,113,113,102,110,133,189,194,
  176,171,169,168,160,148,121,90,60,72,81,87,97,107,120,115,101,100,116,149,
  176,194,185,178,173,168,156,140,88,53,71,80,87,95,102,112,123,130,129,159,
  196,181,169,159,102,76,128,159,176,153,126,97,111,117,95,82,75,86,95,105,103,
  102,102,123,153,176,186,181,176,169,156,111,61,75,85,92,139,149,78,86,126,
  181,196,175,102,58,82,97,117,179,195,170,165,156,138,146,153,101,77,78,83,
  110,174,122,50,80,133,204,185,168,161,156,141,80,61,78,91,117,166,127,80,129,
  153,156,96,63,85,92,97,110,146,203,185,171,165,148,125,86,73,77,83,90,100,
  130,159,150,149,151,122,107,118,155,189,174,150,120,88,88,133,155,156,98,78,
  85,97,120,154,135,107,86,93,118,170,194,178,170,165,161,141,113,77,61,75,87,
  103,135,127,95,103,118,140,168,186,170,160,150,81,52,81,143,186,149,112,78,
  131,146,110,91,83,101,143,199,175,144,102,144,184,166,150,134,72,48,72,88,
  105,120,117,108,144,168,175,150,122,95,122,174,168,161,156,113,76,77,102,135,
  116,95,76,82,96,117,155,200,184,173,166,149,122,72,72,100,164,186,165,113,76,
  80,110,145,136,111,67,77,93,106,123,145,179,191,179,173,166,163,139,107,77,
  67,77,83,90,95,106,122,179,198,175,153,125,82,80,97,155,180,174,170,165,154,
  156,161,128,96,63,70,78,85,92,101,125,153,185,179,171,166,134,96,87,86,90,
  136,160,130,108,100,168,186,164,101,63,86,98,115,175,193,171,166,163,161,153,
  139,106,85,76,78,82,87,111,135,122,141,186,175,165,160,138,111,80,72,82,105,
  133,174,153,122,139,145,145,95,68,87,120,150,161,150,123,155,174,164,155,136,
  76,62,81,86,91,96,101,107,110,143,199,181,169,163,112,65,87,110,131,169,185,
  170,148,130,145,149,148,91,63,82,91,98,116,127,133,168,185,174,166,160,154,
  121,71,77,82,85,115,133,92,102,146,169,178,168,136,106,86,81,87,105,135,185,
  183,170,164,160,156,128,100,72,75,85,95,97,96,115,144,188,183,170,165,156,
  144,83,58,77,97,123,166,141,86,153,183,164,113,73,83,88,93,135,161,169,165,
  161,160,158,154,133,103,62,67,78,86,127,176,120,101,126,155,175,168,155,141,
  120,96,71,83,111,165,160,128,97,106,158,131,102,85,82,90,103,131,174,175,170,
  166,163,160,156,134,93,81,76,81,105,131,116,103,96,143,178,168,161,156,143,
  112,65,77,110,170,175,158,141,143,161,146,120,67,63,82,116,122,102,97,111,
  164,170,160,160,160,160,154,130,71,66,80,85,98,122,140,156,165,161,146,105,
  82,78,86,97,115,138,161,166,166,163,161,159,155,144,125,72,58,77,87,115,176,
  133,72,108,144,181,170,159,155,151,146,135,102,51,88,112,102,95,97,146,156,
  136,92,70,88,139,185,159,127,87,146,179,165,160,156,155,148,136,105,81,71,76,
  83,90,123,175,122,91,100,139,174,159,158,168,163,156,151,135,123,135,112,62,
  72,92,123,111,92,90,98,113,160,174,135,122,125,160,164,149,156,159,154,145,
  135,129,136,150,125,97,67,67,80,108,106,85,91,120,176,173,154,130,120,115,
  148,164,158,148,135,115,103,98,105,100,76,80,88,93,130,183,127,105,122,156,
  181,169,129,81,144,174,160,153,139,102,105,127,145,135,91,82,83,88,116,151,
  150,126,76,125,170,165,153,138,126,134,163,160,148,128,128,135,105,83,73,78,
  85,88,93,101,135,140,115,125,144,178,181,170,163,159,156,151,136,97,85,86,
  102,106,98,106,110,101,98,102,122,136,148,134,135,174,180,171,169,165,163,
  159,148,122,101,87,121,139,144,133,117,97,86,80,86,101,122,135,133,98,127,
  173,170,168,166,164,160,155,130,103,105,120,148,110,81,81,106,130,97,86,92,
  102,115,135,154,169,170,169,165,153,149,160,151,129,77,68,95,128,138,102,106,
  122,138,120,72,83,100,117,153,186,171,164,163,160,158,153,135,113,78,70,78,
  95,112,131,131,126,126,130,140,122,102,83,96,120,161,170,155,148,149,163,161,
  151,125,101,80,101,123,146,155,151,116,88,66,77,102,145,118,82,90,128,185,
  173,154,126,139,156,155,138,111,103,116,158,139,111,101,121,156,133,110,85,
  100,112,90,82,85,98,129,185,168,141,138,149,168,161,140,101,112,129,134,112,
  75,100,127,159,130,98,88,102,128,118,116,125,154,174,149,121,93,122,141,148,
  126,111,127,136,143,125,123,140,149,144,110,92,87,112,126,125,126,130,148,
  141,125,108,111,133,138,134,116,115,121,136,146,149,153,151,141,129,118,121,
  112,92,80,75,90,125,161,130,112,106,151,183,164,129,92,108,128,151,126,107,
  122,145,168,141,118,96,108,116,103,96,95,123,139,144,133,133,158,164,159,134,
  115,97,90,86,86,108,136,151,145,120,133,150,168,150,120,98,102,128,122,112,
  103,130,165,165,151,126,113,110,120,113,102,107,118,135,134,136,145,159,170,
  155,138,118,121,123,121,100,77,80,98,131,151,153,123,117,123,153,158,141,112,
  98,113,129,141,134,136,148,155,151,128,115,108,117,116,106,102,107,127,133,
  135,135,143,156,153,144,127,123,123,127,120,105,88,85,97,122,144,143,133,118,
  133,148,158,138,113,107,117,138,128,120,115,136,158,149,130,108,120,128,130,
  113,97,110,123,139,127,122,127,144,159,150,140,130,133,133,129,121,112,110,
  102,91,92,106,133,144,145,128,125,130,141,140,122,115,116,135,140,134,122,
  121,136,143,140,125,118,121,129,129,118,118,121,130,127,118,120,128,146,145,
  140,130,131,138,138,133,122,120,117,108,100,93,115,131,145,134,125,128,139,
  153,136,122,107,122,135,133,120,102,120,139,161,150,135,126,129,139,129,120,
  110,121,131,133,125,112,122,130,141,131,125,127,134,141,136,131,128,131,135,
  130,118,102,97,101,115,127,133,126,121,118,133,141,141,127,118,127,135,141,
  125,117,118,138,149,140,128,116,125,129,129,121,117,125,127,125,110,107,115,
  127,133,128,126,126,135,141,141,136,134,134,133,130,122,117,113,111,107,103,
  105,111,125,129,129,123,126,139,148,149,130,120,116,128,135,130,126,122,135,
  140,136,126,121,129,133,134,120,113,113,123,126,120,117,118,126,129,128,126,
  127,135,139,141,138,138,139,139,135,128,122,117,118,117,116,108,105,106,117,
  128,131,128,118,123,130,141,135,128,128,135,149,143,133,121,126,135,138,131,
  121,123,127,131,125,116,116,121,130,123,117,112,120,128,130,130,129,133,136,
  139,136,135,135,134,131,126,121,117,117,117,120,121,122,118,113,107,112,118,
  125,129,130,130,130,133,136,139,135,134,133,133,130,125,118,116,126,133,138,
  130,128,130,133,133,125,120,117,123,125,118,115,115,125,130,131,126,123,126,
  128,128,125,128,134,139,140,134,129,126,125,123,123,125,127,127,122,116,108,
  106,108,118,126,130,126,121,125,134,144,140,135,128,136,143,139,127,112,121,
  130,143,133,121,113,118,128,126,121,115,121,125,125,120,113,122,129,135,131,
  129,129,131,134,131,130,130,134,136,131,127,123,123,123,126,127,126,122,122,
  122,122,122,120,116,115,122,129,134,129,126,121,125,129,136,135,130,128,129,
  134,131,128,121,125,130,135,134,125,122,125,131,130,126,118,118,123,125,122,
  117,118,123,129,129,126,127,128,131,133,133,134,136,138,136,134,129,126,123,
  123,125,125,122,120,117,122,128,128,126,122,120,120,122,123,126,127,128,128,
  130,133,138,135,131,126,125,128,128,126,120,121,127,133,133,127,127,129,135,
  133,129,123,123,127,127,125,120,122,127,129,128,125,123,125,128,128,126,126,
  128,133,135,136,136,133,130,129,128,127,125,122,120,120,120,125,126,123,122,
  120,120,123,128,128,126,121,122,127,134,138,136,130,131,136,136,131,121,117,
  118,126,128,126,125,126,131,133,131,127,126,127,126,122,118,121,123,127,127,
  126,126,128,130,128,126,122,125,129,129,129,129,129,130,131,133,131,130,128,
  125,125,125,127,126,125,125,123,122,120,118,120,125,129,125,121,117,123,130,
  134,131,127,129,134,143,138,129,121,121,126,128,127,121,123,127,133,133,129,
  127,126,126,126,125,123,123,125,126,126,126,128,130,130,129,127,126,127,129,
  133,134,133,130,129,129,128,126,125,125,125,125,125,125,125,127,129,129,126,
  125,123,125,126,127,125,123,123,126,130,133,133,131,129,129,129,128,126,126,
  127,129,129,128,128,129,133,133,130,125,122,123,127,128,127,126,126,126,126,
  125,122,123,126,126,126,125,126,128,131,131,130,130,131,133,130,128,125,125,
  127,127,126,125,122,121,121,122,125,125,123,122,120,118,121,125,128,128,128,
  128,133,136,135,130,126,127,129,131,127,122,118,123,130,130,128,125,127,129,
  133,130,126,123,125,128,127,126,125,126,128,128,128,127,126,123,123,121,121,
  125,128,129,128,128,130,133,134,130,128,127,128,128,127,125,123,126,127,128,
  128,127,127,126,125,123,122,122,122,123,127,127,127,128,131,135,135,131,126,
  125,125,126,125,122,122,125,130,133,133,131,131,130,130,128,125,123,123,126,
  127,128,128,129,129,128,127,126,126,127,127,128,128,129,129,129,129,129,129,
  129,129,128,128,128,127,127,127,127,127,127,126,126,126,126,126,127,127,128,
  128,125,121,118,118,121,123,126,126,123,123,125,129,130,130,128,127,130,131,
  130,127,125,125,126,126,123,123,123,128,129,129,128,128,130,131,130,126,125,
  125,125,126,127,128,128,128,128,128,128,127,126,125,122,122,122,125,127,129,
  131,133,133,130,128,128,128,127,125,122,121,123,127,130,131,130,129,127,123,
  120,116,115,120,123,127,129,133,133,133,133,131,129,126,125,123,123,123,125,
  127,129,131,133,133,129,128,128,129,130,129,127,125,127,129,130,129,128,125,
  125,125,126,125,121,118,120,126,130,133,133,133,133,133,131,128,126,123,123,
  126,127,127,127,127,128,130,128,125,121,120,121,126,127,129,131,133,131,126,
  122,122,125,128,128,123,118,120,125,130,133,131,129,129,129,129,127,122,121,
  121,125,127,129,130,133,133,130,130,130,131,130,126,122,120,123,127,127,126,
  123,125,126,126,127,127,127,127,128,128,128,128,128,128,128,128,128,128,127,
  126,125,125,127,127,126,125,123,125,128,130,130,128,126,126,126,126,123,122,
  122,125,127,127,126,125,125,126,127,128,128,127,127,129,129,128,126,127,129,
  131,131,129,126,124,127,128,128,128,128,128,128,128,127,126,126,128,130,130,
  129,127,127,127,129,129,128,127,127,127,127,127,125,122,122,125,128,130,127,
  126,126,128,129,129,128,128,128,129,128,127,127,127,127,125,119,117,116,121,
  124,126,125,126,131,134,136,133,130,128,128,127,127,125,123,126,128,128,127,
  126,126,127,128,128,128,128,130,132,131,129,127,127,127,128,129,128,126,126,
  127,127,128,128,124,122,122,125,128,129,129,129,130,131,132,131,129,127,127,
  127,129,129,129,128,127,126,126,126,126,126,126,124,123,123,125,127,128,128,
  127,127,127,128,128,127,125,125,127,129,130,126,125,125,126,128,128,127,126,
  128,129,130,129,128,128,127,126,123,121,121,123,126,128,129,129,130,130,128,
  128,128,128,127,125,124,123,122,122,124,126,128,129,129,128,126,126,126,126,
  126,127,127,129,132,132,131,129,127,125,122,121,119,119,120,124,126,128,128,
  129,131,131,130,129,128,128,130,129,127,125,124,126,129,130,129,128,128,128,
  127,127,126,126,129,130,130,130,130,130,131,131,129,127,124,124,124,124,124,
  125,125,126,128,129,129,129,127,126,128,130,131,130,129,128,129,131,131,130,
  127,125,124,126,127,127,127,126,125,125,124,123,123,123,125,125,124,126,128,
  131,132,130,127,127,129,132,132,129,126,124,125,126,127,125,124,126,130,132,
  131,129,127,126,125,124,125,127,128,129,129,129,130,130,128,126,125,125,126,
  126,125,124,125,126,128,128,128,128,128,128,127,126,126,127,129,129,127,126,
  126,126,128,129,129,129,127,126,123,122,122,123,124,125,126,126,127,126,126,
  127,129,131,130,128,126,127,130,131,130,125,124,124,128,128,125,124,124,130,
  132,132,129,128,128,127,127,127,127,127,128,127,127,127,128,128,127,127,127,
  126,126,125,124,125,127,129,129,128,128,128,129,129,128,127,127,126,125,125,
  125,126,127,129,130,131,131,128,126,124,124,124,124,124,123,123,124,127,128,
  128,127,127,128,129,128,125,125,126,129,131,131,128,127,127,127,128,127,126,
  126,127,128,128,128,129,129,130,130,128,127,124,124,124,127,130,130,128,125,
  125,126,128,127,126,125,126,127,128,128,128,129,130,131,130,128,126,126,125,
  125,125,125,125,125,125,126,128,128,128,128,126,126,126,126,125,125,124,123,
  124,125,128,129,130,128,127,126,128,130,130,129,128,130,130,129,126,123,123,
  124,126,124,124,124,127,131,132,132,130,129,129,129,128,126,124,124,124,127,
  129,129,128,128,128,128,127,126,125,125,126,128,130,129,128,128,129,130,131,
  130,128,127,126,126,125,125,125,126,126,127,129,129,129,129,130,130,130,127,
  124,122,122,122,121,121,124,126,128,127,127,127,128,129,128,126,125,127,128,
  128,127,127,130,131,130,128,127,127,128,128,126,125,125,127,128,128,128,128,
  128,127,126,124,125,126,127,128,128,129,129,127,126,126,126,127,127,127,127,
  128,129,129,129,128,127,126,125,125,124,123,123,123,125,127,129,129,130,130,
  129,128,127,125,124,124,123,123,123,124,125,127,129,129,129,128,128,127,127,
  126,126,126,127,130,130,131,131,129,128,128,128,127,127,126,126,126,126,126,
  126,126,127,127,127,127,127,129,130,131,131,130,129,128,127,126,126,125,125,
  125,125,126,128,129,129,128,128,127,127,127,128,128,128,127,127,127,128,130,
  130,127,126,125,125,124,122,122,122,125,127,128,128,128,130,130,129,127,127,
  128,128,127,126,126,127,130,130,128,127,127,127,126,125,125,125,125,127,128,
  128,129,128,128,128,128,128,127,127,126,126,126,127,127,127,127,127,127,126,
  126,126,126,126,126,126,127,128,129,129,129,129,129,129,128,127,127,127,127,
  127,128,128,128,127,127,126,126,126,126,126,127,127,127,127,128,129,130,130,
  129,129,129,128,127,126,126,126,127,127,127,127,127,127,127,127,126,126,127,
  128,128,128,128,128,129,129,129,128,126,126,125,125,125,125,125,125,127,128,
  129,
};

static const char dsdgdth[] = {
  3,0,17,43,255,84,0,0,132,132,133,132,133,132,133,132,133,132,133,132,133,132,
  133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,
  132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,
  133,132,133,132,132,134,131,133,132,133,132,133,131,134,133,131,132,129,129,
  131,134,137,138,138,131,130,129,133,133,136,134,132,130,128,122,122,123,134,
  142,151,144,131,127,124,132,135,138,132,132,128,129,117,111,112,132,148,157,
  146,132,122,125,129,130,127,127,128,132,125,110,100,108,131,148,156,145,129,
  125,127,128,128,126,127,130,132,118,98,96,107,134,154,154,143,130,128,129,
  132,128,126,127,133,126,111,92,93,113,139,156,154,137,128,129,135,135,132,
  132,138,139,121,99,81,97,129,154,157,140,128,128,132,135,133,134,143,147,132,
  102,79,89,127,156,160,142,124,123,130,131,132,135,149,153,134,100,74,92,140,
  173,172,145,119,110,122,128,130,137,151,146,122,89,82,117,163,192,181,146,
  118,110,114,119,124,134,135,129,108,90,102,142,181,196,178,148,120,117,117,
  119,121,118,110,101,102,112,139,162,180,182,169,151,137,130,129,126,117,92,
  82,93,117,145,155,150,142,144,158,162,165,153,140,126,109,96,92,104,130,140,
  137,116,107,120,158,190,190,171,148,132,123,113,109,106,113,110,93,81,96,135,
  186,215,204,175,140,126,127,129,120,100,79,71,80,98,132,162,189,192,177,152,
  143,137,136,124,102,82,85,102,132,151,155,139,122,120,138,155,162,144,127,
  130,142,155,151,138,125,117,94,77,67,82,111,150,177,193,199,202,190,166,133,
  98,77,59,59,57,77,112,159,198,223,217,201,176,150,120,84,53,39,53,89,129,169,
  193,196,192,177,164,136,113,87,71,72,82,111,142,178,191,198,182,159,121,84,
  57,55,80,117,158,188,197,184,169,151,133,117,102,89,83,78,86,115,151,186,214,
  208,169,124,96,83,100,121,136,139,134,134,125,126,124,127,133,137,138,141,
  145,151,159,153,144,135,125,97,79,72,88,122,156,187,189,187,167,147,123,103,
  94,93,104,112,121,137,146,165,166,157,141,115,106,106,117,131,146,159,156,
  152,129,112,97,92,104,122,135,142,150,158,169,167,153,129,102,79,80,95,112,
  133,149,154,162,160,157,144,128,119,107,104,107,121,129,129,139,139,135,130,
  133,134,152,161,168,161,136,115,86,78,72,94,119,147,173,182,193,172,158,138,
  120,99,79,78,93,125,152,171,164,146,139,127,114,96,101,115,150,172,188,171,
  139,129,112,86,61,67,86,123,165,194,191,165,161,140,117,102,106,106,123,134,
  133,129,108,114,112,110,121,143,166,182,198,190,167,125,100,64,36,42,74,118,
  166,211,231,225,188,152,108,69,47,52,74,102,149,188,202,185,175,138,103,94,
  97,107,122,155,169,156,130,121,92,80,94,113,137,169,210,211,185,128,100,57,
  37,51,77,117,161,214,229,208,163,127,82,46,55,68,107,145,203,210,191,152,114,
  80,61,87,98,130,151,182,173,173,138,121,94,76,97,107,138,159,178,164,140,103,
  86,80,94,132,154,197,195,192,151,112,62,47,47,67,126,172,230,240,213,164,110,
  57,39,46,64,120,168,221,225,205,157,112,67,49,51,70,122,174,232,231,201,156,
  92,57,38,52,75,138,189,225,221,182,136,95,72,66,81,101,147,178,193,178,144,
  106,81,84,95,133,161,203,198,175,128,81,51,51,78,111,164,213,234,225,174,108,
  49,34,31,76,120,180,214,233,203,165,105,65,47,56,87,132,189,220,215,174,123,
  76,47,53,80,130,185,227,223,182,130,71,49,46,68,107,162,205,235,219,170,108,
  61,30,49,83,127,187,230,229,192,131,82,39,43,79,123,179,222,233,190,130,70,
  35,43,75,133,178,220,231,207,146,87,41,25,56,99,164,210,244,216,171,97,56,36,
  43,95,140,199,223,232,180,124,63,25,35,62,122,174,221,229,212,151,96,44,25,
  38,87,147,205,241,226,186,111,61,31,36,72,129,190,225,236,200,139,81,42,28,
  59,102,167,217,233,214,155,97,42,43,48,104,157,214,224,216,153,96,52,30,54,
  95,159,210,243,213,166,96,48,28,45,85,145,201,225,219,173,112,63,37,34,84,
  136,192,230,230,183,123,68,27,35,64,125,183,229,232,205,138,89,38,35,55,107,
  169,219,238,208,152,87,41,24,56,98,166,218,243,210,167,94,52,30,45,92,152,
  204,234,221,168,115,53,39,41,91,149,212,228,229,163,107,61,29,44,83,148,203,
  236,220,186,117,70,33,45,69,141,193,231,213,185,112,65,36,40,86,148,211,231,
  222,165,108,49,34,31,101,141,205,233,216,157,112,65,33,65,88,150,194,220,197,
  142,82,53,29,78,110,182,209,237,192,146,71,31,25,56,112,168,223,235,206,148,
  88,27,36,62,127,164,225,219,194,131,93,27,36,66,122,174,226,234,201,145,82,
  37,19,65,110,171,218,222,194,156,93,52,30,65,109,174,211,233,191,155,85,38,
  26,56,104,174,215,226,206,153,95,43,32,43,113,170,221,226,211,147,99,43,42,
  49,114,166,222,222,223,145,111,53,39,54,104,163,216,226,206,160,100,69,37,65,
  104,172,210,239,201,165,98,66,25,55,95,169,206,252,204,170,108,54,35,55,97,
  162,212,244,211,160,104,43,44,44,106,151,218,233,233,168,117,54,34,36,85,125,
  200,225,239,184,131,70,36,37,64,121,183,223,224,198,137,83,40,32,46,108,171,
  223,241,216,140,101,34,26,37,103,145,216,226,214,159,120,46,34,36,77,137,209,
  227,218,175,105,64,31,47,68,137,196,218,220,185,116,81,40,42,57,130,177,220,
  220,197,125,97,42,42,49,121,155,222,213,189,147,103,64,57,63,114,158,199,205,
  190,151,110,72,50,69,95,162,187,224,180,174,113,94,53,68,85,142,166,198,187,
  165,131,113,69,75,87,123,158,192,177,181,129,112,76,70,77,117,145,184,180,
  185,144,131,92,76,82,102,142,163,198,172,169,123,99,69,89,92,147,153,199,170,
  185,128,121,74,78,75,125,143,189,181,186,150,130,82,83,73,113,132,168,184,
  179,163,126,96,88,63,109,121,160,178,187,158,150,108,79,70,96,111,147,174,
  181,178,148,126,89,88,77,115,130,182,164,197,144,139,94,90,65,118,128,176,
  172,199,147,152,98,93,66,108,113,157,174,182,168,157,106,101,72,85,117,143,
  176,174,170,147,118,93,81,82,115,135,164,175,182,149,138,82,81,68,94,127,172,
  176,187,153,143,82,97,66,98,122,166,151,202,160,144,105,101,53,102,99,142,
  161,191,168,160,129,96,76,103,87,140,148,169,171,161,130,115,89,93,91,129,
  142,168,173,166,144,110,97,85,104,118,142,158,168,157,153,114,116,90,115,110,
  147,146,160,157,154,109,126,93,107,119,146,131,176,151,155,121,135,87,121,
  108,141,122,172,130,163,125,129,104,135,106,142,124,160,122,158,118,128,116,
  125,105,133,120,140,135,160,124,141,122,126,121,131,108,127,126,134,130,141,
  129,134,128,135,114,140,125,130,127,135,124,138,133,135,127,139,119,124,122,
  127,127,148,145,148,138,132,116,122,110,108,128,147,142,166,145,139,127,113,
  103,105,125,135,154,167,152,144,123,108,104,98,113,129,154,163,173,150,142,
  106,98,86,102,114,155,162,186,155,157,109,122,77,100,102,135,152,187,155,173,
  122,122,80,111,85,131,135,170,164,192,134,132,95,97,72,117,114,156,165,186,
  148,160,105,100,87,103,99,150,151,175,159,169,113,117,83,94,96,132,140,167,
  158,159,136,131,105,102,100,122,121,150,145,151,149,135,119,122,115,118,121,
  135,137,150,153,141,138,127,117,113,111,124,134,141,154,155,149,138,125,117,
  113,103,122,120,146,154,160,150,146,122,122,97,110,105,135,134,165,154,167,
  131,131,95,105,90,125,121,170,147,175,138,147,115,115,80,101,99,146,144,186,
  153,182,124,127,77,106,75,128,123,185,158,200,145,142,84,100,65,118,114,168,
  163,206,155,159,82,89,49,106,106,177,171,200,152,165,104,102,73,92,87,145,
  136,169,164,164,142,136,103,88,75,102,124,170,179,181,165,134,102,74,59,54,
  103,148,191,196,203,147,135,98,88,67,105,108,173,167,190,143,148,94,112,78,
  105,88,149,142,193,167,177,120,124,68,89,59,103,107,167,171,203,159,147,88,
  101,85,108,106,163,152,193,168,129,100,98,87,110,116,129,150,150,174,161,166,
  125,120,88,101,71,122,120,183,179,205,136,141,86,106,70,123,112,178,160,191,
  139,152,92,123,83,112,100,143,134,185,159,176,140,132,84,84,63,96,132,181,
  212,192,170,121,99,76,74,77,126,132,184,163,187,141,157,101,117,65,117,97,
  178,154,210,146,176,93,104,50,98,78,164,157,222,187,194,128,127,67,86,68,103,
  130,169,175,199,166,135,113,77,88,103,131,152,188,165,177,131,125,77,102,70,
  127,124,174,138,196,154,166,99,125,67,115,93,144,132,179,143,175,120,128,92,
  113,96,117,125,165,164,172,159,135,112,75,83,88,123,140,193,170,191,132,145,
  97,109,77,124,90,162,118,181,138,187,123,166,80,119,66,136,116,176,133,190,
  134,163,100,118,76,100,107,148,152,188,155,148,133,104,115,100,114,112,157,
  139,179,126,159,102,140,78,125,85,150,127,198,157,202,125,141,59,99,36,109,
  110,196,177,222,163,152,98,104,60,82,78,132,148,171,189,178,149,118,104,75,
  85,75,127,141,187,170,182,131,129,63,91,73,146,135,202,156,187,102,132,64,
  108,51,121,117,197,155,206,142,177,115,108,51,89,83,145,148,180,185,168,148,
  114,115,78,107,107,162,161,201,150,176,100,114,49,91,56,152,135,222,183,215,
  135,137,60,97,36,95,85,175,166,222,164,164,101,108,61,89,83,127,161,200,186,
  178,125,97,79,63,93,100,131,154,215,183,208,132,118,55,83,42,120,103,183,171,
  241,148,161,60,90,48,133,90,192,131,218,150,170,87,105,30,105,61,140,136,209,
  196,199,142,120,68,66,63,115,148,182,180,180,166,128,108,67,94,72,117,150,
  176,172,198,132,138,75,97,45,103,98,180,173,232,169,211,107,133,61,123,75,
  160,102,186,129,174,122,146,62,140,80,150,135,174,149,223,162,147,101,119,78,
  112,100,161,177,187,183,155,121,93,91,62,101,93,133,140,205,199,226,145,162,
  67,47,12,112,113,216,207,222,114,181,15,78,102,177,53,183,132,167,131,181,
  106,149,107,137,91,181,162,218,222,229,163,201,110,80,51,0,61,185,133,188,
  143,74,125,140,74,67,32,21,101,115,152,165,141,118,141,127,183,212,237,190,
  233,180,185,67,19,34,151,30,40,0,114,168,223,161,235,97,129,68,132,91,174,
  137,192,126,110,5,40,7,75,70,171,169,236,224,242,209,213,151,226,181,205,127,
  105,191,253,244,211,143,99,85,76,91,86,53,90,101,183,178,22,131,13,34,116,
  242,211,229,182,190,104,114,35,54,15,150,83,166,111,165,81,105,32,75,15,60,
  140,201,152,182,101,187,87,91,50,96,77,91,137,233,254,240,91,30,48,64,127,
  242,226,166,118,146,144,122,127,183,177,24,75,152,220,239,216,66,193,178,193,
  93,150,103,126,42,164,170,189,0,67,57,170,84,119,200,232,156,177,68,69,15,9,
  2,122,39,79,105,162,101,101,45,44,56,123,175,250,245,251,195,106,204,60,22,8,
  4,89,160,158,220,163,173,120,129,89,200,226,245,241,242,240,243,128,137,56,
  108,77,175,138,210,101,189,104,87,2,10,0,95,118,216,181,227,162,164,116,136,
  107,161,174,192,251,247,223,177,128,63,31,6,18,59,126,116,164,109,124,64,89,
  52,129,111,199,167,235,149,202,102,143,57,114,49,152,144,218,124,173,87,155,
  29,80,21,67,47,112,40,51,6,132,111,148,77,105,56,117,86,140,122,126,102,97,
  73,77,54,25,61,81,125,142,168,154,174,149,224,234,242,172,165,133,193,157,
  209,138,159,117,177,150,233,215,245,242,244,218,252,154,206,154,231,182,251,
  221,250,199,216,104,144,58,121,83,163,128,194,144,161,88,69,14,32,25,67,110,
  180,156,147,90,29,24,12,13,12,41,65,100,68,85,3,27,13,12,11,39,41,150,112,
  170,81,101,6,60,10,121,98,215,164,248,161,196,110,141,80,201,169,244,244,241,
  241,241,242,245,215,223,201,237,225,228,231,246,218,201,163,119,151,134,187,
  203,227,192,215,145,164,84,124,57,141,102,194,132,207,80,171,27,100,5,83,5,
  118,59,133,66,130,22,70,18,35,21,46,35,77,75,81,83,53,60,26,45,25,66,37,122,
  71,174,80,154,47,107,9,124,21,179,87,220,134,222,88,183,41,143,56,158,121,
  214,180,236,189,202,142,121,97,106,142,156,240,209,211,153,184,82,138,65,179,
  143,255,225,244,239,253,144,225,78,201,118,244,216,246,226,255,151,170,50,
  116,53,154,166,209,213,199,155,101,57,35,62,41,160,122,234,133,197,61,91,0,
  73,0,135,84,213,119,206,62,107,7,53,0,78,69,162,135,185,137,144,79,47,44,39,
  113,135,174,147,204,79,52,5,27,11,174,101,156,94,255,119,210,66,171,43,185,
  128,247,205,245,246,255,106,158,118,156,128,185,211,228,230,218,216,149,152,
  84,118,14,68,21,137,51,135,44,138,41,143,64,162,90,183,120,231,178,237,138,
  176,74,104,28,13,11,32,27,32,50,47,36,39,114,129,188,143,193,110,179,75,133,
  19,97,0,79,0,92,25,158,53,162,43,108,30,117,58,154,117,143,158,218,204,215,
  182,138,176,160,210,190,231,191,247,164,229,103,184,85,198,110,228,180,252,
  229,254,159,187,118,234,204,245,230,244,227,255,129,140,107,151,72,194,234,
  218,203,156,186,184,136,36,126,119,200,183,234,140,183,101,148,104,80,28,194,
  150,220,203,229,69,54,50,105,5,77,79,85,82,157,112,81,2,4,55,126,92,125,142,
  130,114,58,73,15,17,17,56,58,101,64,70,4,20,10,35,39,50,24,121,136,150,140,
  187,130,109,95,122,150,215,223,250,217,183,216,151,90,152,141,109,116,106,
  178,210,180,166,149,107,101,13,25,20,82,109,167,162,189,233,183,88,135,179,
  226,186,125,179,216,255,164,140,151,142,92,121,143,125,65,108,91,72,42,80,97,
  103,157,150,167,195,152,108,103,100,96,131,124,154,158,178,181,156,129,126,
  92,73,96,154,168,196,171,149,127,59,50,61,51,61,113,139,145,173,162,126,95,
  104,85,96,119,140,170,182,166,166,140,108,94,78,116,144,177,191,218,171,117,
  43,72,46,22,77,189,174,225,237,255,170,140,89,142,125,211,210,225,216,210,
  156,153,122,93,94,137,186,229,244,242,242,248,220,162,177,154,156,182,227,
  186,217,147,104,56,95,98,85,81,166,202,192,146,174,129,110,86,102,80,82,86,
  137,119,63,68,82,120,53,107,105,129,101,82,17,79,66,34,6,40,33,90,46,93,98,
  132,96,109,79,84,56,73,71,136,104,97,71,37,39,40,22,34,147,144,140,130,126,
  73,150,81,134,95,142,122,161,124,143,116,122,89,102,60,110,88,144,189,205,
  176,159,197,165,207,181,174,148,211,177,212,149,190,138,174,164,189,129,193,
  163,217,194,184,162,135,118,169,150,184,218,191,214,188,218,174,169,119,159,
  88,113,80,111,109,201,153,185,115,176,154,217,150,198,145,197,152,161,124,
  101,38,86,128,112,111,123,142,119,120,86,142,127,174,161,175,131,214,147,230,
  168,163,114,166,90,134,123,128,126,149,129,81,69,51,44,96,120,122,168,164,
  172,99,71,68,86,48,99,83,156,123,115,83,86,59,76,79,98,128,147,142,120,119,
  87,53,30,52,42,66,75,92,82,109,82,104,72,73,65,59,77,95,123,129,139,105,122,
  74,103,78,116,98,163,138,139,74,114,64,98,61,123,106,141,111,160,142,157,135,
  97,79,99,124,146,184,205,220,219,200,111,147,147,202,207,212,199,205,209,176,
  195,180,169,161,159,169,168,224,230,242,236,225,186,177,184,174,226,210,230,
  243,210,205,162,203,143,188,177,172,132,167,144,148,193,135,138,125,134,114,
  110,143,176,198,127,173,88,113,86,122,119,124,108,97,122,71,93,62,107,108,99,
  116,69,123,91,137,52,119,53,63,67,88,97,66,93,58,64,53,53,44,24,95,75,140,79,
  165,134,158,124,138,133,131,175,134,181,176,192,160,137,166,96,131,96,154,96,
  153,147,128,121,127,161,100,159,115,135,123,151,189,138,180,129,190,132,191,
  152,160,202,172,169,92,173,89,147,92,110,138,159,191,120,173,103,110,61,136,
  135,107,137,90,148,78,172,98,146,116,106,106,107,170,108,214,113,149,95,92,
  95,87,160,82,179,123,189,127,178,134,83,133,56,134,85,150,71,111,119,89,125,
  81,119,48,144,117,151,162,138,143,115,189,89,184,150,216,130,125,131,125,163,
  128,196,108,153,93,133,131,98,160,95,149,80,143,87,126,103,111,146,101,138,
  115,188,71,125,148,131,133,120,146,81,186,133,175,136,163,171,134,173,71,155,
  93,189,105,134,103,85,118,63,125,75,145,47,108,115,124,125,115,166,89,142,
  113,178,136,152,132,164,185,161,168,100,123,109,84,79,152,158,76,131,106,124,
  85,133,116,154,143,161,173,139,172,123,119,98,144,97,100,129,169,152,135,151,
  115,191,154,212,159,185,156,162,117,72,122,80,162,169,249,205,250,211,217,
  196,168,178,92,113,62,132,80,115,108,140,205,173,232,134,242,134,213,137,233,
  203,182,156,61,139,81,206,120,217,156,167,180,109,180,52,193,21,182,49,169,
  113,115,113,44,158,4,142,0,81,40,95,134,79,177,18,198,11,164,24,133,70,94,
  156,79,197,51,180,36,173,64,120,101,80,163,32,176,0,179,30,128,55,107,111,34,
  136,9,186,0,181,40,147,102,83,153,109,218,70,230,54,187,96,193,174,130,213,
  110,239,47,242,85,205,92,159,148,81,180,70,230,64,217,33,166,82,151,129,72,
  194,72,199,68,223,98,211,124,148,156,87,196,66,216,99,247,98,205,91,135,141,
  127,183,92,236,57,221,98,158,123,135,145,77,189,46,230,94,255,100,207,134,
  123,134,120,191,84,252,65,194,75,151,117,123,182,107,245,122,255,109,245,89,
  178,148,131,163,113,240,82,255,99,208,91,155,87,72,144,47,195,58,226,60,176,
  72,125,141,86,179,87,229,58,222,59,178,62,114,87,51,163,101,202,83,200,32,
  149,64,82,113,78,181,86,219,45,204,62,133,34,106,115,72,157,69,203,69,165,42,
  141,77,107,125,109,191,86,229,84,171,67,138,62,124,126,124,176,104,183,72,
  158,65,112,82,125,143,148,202,131,189,77,128,81,133,95,126,126,124,176,119,
  177,70,138,84,124,123,176,159,155,183,137,170,96,148,83,139,124,158,161,182,
  204,161,128,84,138,104,144,122,155,152,175,162,112,130,75,115,79,145,125,154,
  115,164,116,101,110,90,102,81,166,132,174,164,159,108,113,103,71,103,88,164,
  101,195,159,189,114,107,108,94,129,93,181,176,228,137,146,91,113,105,75,154,
  165,219,111,222,169,174,156,162,165,121,168,67,177,135,211,106,157,129,163,
  124,134,177,95,208,108,162,140,185,114,150,133,124,236,116,213,127,201,122,
  162,62,72,49,127,144,75,166,83,96,70,80,67,97,113,80,167,103,167,101,172,102,
  148,87,158,122,70,148,99,180,119,140,101,143,111,124,96,52,75,35,117,78,110,
  86,102,79,61,153,104,164,95,163,97,174,89,140,129,139,121,135,152,107,140,
  131,153,126,150,155,120,181,128,190,137,188,145,180,151,182,183,198,188,135,
  164,153,142,140,165,150,148,181,158,185,182,190,137,177,177,171,142,176,180,
  132,125,135,162,157,160,113,167,130,157,139,101,91,122,98,101,103,163,161,88,
  129,119,92,131,100,113,137,135,134,159,118,140,70,4,92,151,62,131,36,102,119,
  55,148,59,93,107,98,132,167,179,133,129,166,130,73,98,55,123,87,130,107,71,
  160,55,41,59,171,104,142,144,110,104,94,88,71,96,90,119,182,176,161,153,161,
  95,100,89,128,84,97,130,216,227,178,146,108,131,110,145,97,144,184,208,239,
  248,152,127,121,115,141,147,157,211,231,230,165,181,117,147,101,170,134,245,
  166,208,152,117,116,124,122,79,138,139,151,162,98,87,84,97,51,81,107,194,173,
  135,149,155,110,43,69,39,175,91,189,187,190,138,174,113,59,104,64,106,124,
  151,138,173,184,115,130,87,133,99,163,152,181,174,179,151,139,123,71,121,108,
  159,158,145,148,134,120,79,96,57,121,112,130,123,139,156,103,70,51,83,88,125,
  93,138,152,157,114,103,82,70,98,114,151,121,170,141,126,100,106,79,95,144,
  120,163,158,167,128,133,106,106,117,129,134,121,181,149,153,138,130,93,110,
  135,124,184,176,180,172,194,125,147,119,138,149,188,187,168,183,166,141,118,
  105,111,132,154,159,201,152,172,141,151,95,126,118,126,112,138,165,127,140,
  118,127,50,102,100,143,136,157,131,125,151,88,118,98,124,120,142,177,168,182,
  128,133,86,102,67,112,117,174,160,150,177,126,144,84,137,92,150,157,178,177,
  157,151,102,121,80,115,139,164,172,165,201,134,154,80,121,59,148,124,179,172,
  191,167,137,130,72,96,70,134,141,174,192,159,161,108,93,38,100,82,119,152,
  154,176,152,148,51,87,21,77,39,136,153,160,138,129,86,27,63,22,78,105,135,
  170,171,157,103,98,28,84,40,113,109,173,180,164,150,108,92,27,100,85,143,167,
  219,222,185,150,106,84,50,94,100,180,214,223,202,156,142,95,107,56,117,135,
  207,210,220,205,157,145,86,102,77,155,143,230,233,222,182,149,132,71,77,70,
  155,170,233,239,223,176,120,115,41,109,94,176,194,234,223,176,147,101,103,64,
  118,93,183,190,207,197,168,128,52,78,49,104,119,209,221,201,181,112,114,42,
  63,53,139,139,198,186,187,133,83,86,20,87,73,141,158,210,186,157,108,89,80,
  11,81,84,155,189,200,178,135,117,30,51,27,116,97,201,174,204,165,149,110,65,
  75,43,132,145,183,198,195,178,121,88,50,105,74,161,156,220,217,182,148,99,97,
  20,90,83,172,167,230,209,167,123,69,83,42,113,107,174,194,220,193,138,123,58,
  74,8,95,113,178,205,203,181,116,121,18,49,30,116,121,196,220,196,161,97,102,
  14,79,63,128,155,187,229,188,162,80,96,36,78,88,169,189,202,223,174,155,76,
  97,21,110,85,154,196,213,206,165,126,31,65,39,100,99,170,214,236,215,143,138,
  32,75,45,97,136,198,226,224,204,117,116,14,79,36,118,143,193,233,172,176,97,
  110,3,70,63,130,170,221,220,173,169,82,121,30,54,54,143,190,209,236,164,148,
  81,64,20,82,93,151,228,232,237,162,150,70,89,33,79,112,169,223,223,225,146,
  128,45,92,55,91,157,153,221,214,217,115,129,53,62,29,93,155,169,232,216,195,
  104,121,34,48,49,115,157,178,252,206,178,89,94,37,66,80,90,194,180,237,188,
  175,92,83,41,51,80,111,182,185,238,161,155,60,86,67,34,94,128,188,176,244,
  180,158,75,67,63,52,114,120,215,196,198,143,139,87,81,103,47,115,119,189,180,
  197,153,154,87,75,97,71,137,95,188,181,216,189,135,125,67,100,58,130,125,193,
  180,181,191,147,112,63,111,67,120,104,181,194,207,191,108,128,81,127,85,82,
  87,154,199,200,194,122,167,70,118,71,70,105,133,219,176,203,113,143,46,101,
  66,71,112,118,185,205,208,116,176,60,78,52,54,98,123,207,204,205,123,146,89,
  108,75,56,118,129,194,190,205,146,137,92,90,85,30,105,96,206,195,207,164,160,
  117,60,97,40,97,105,186,199,224,192,144,141,95,110,49,62,68,150,225,212,218,
  143,161,76,83,47,55,68,136,199,212,241,146,127,76,99,87,41,83,130,225,200,
  251,162,139,109,92,59,24,72,99,224,216,221,208,180,104,79,109,50,72,77,197,
  210,227,237,182,135,95,102,64,81,60,132,191,211,242,186,121,85,132,97,48,42,
  112,167,165,223,188,156,86,130,118,95,60,33,113,164,215,204,196,101,132,124,
  70,80,11,91,127,193,170,198,125,124,112,93,86,31,17,35,166,170,196,206,134,
  122,129,114,62,32,12,128,190,178,233,160,134,118,149,85,59,29,39,156,172,234,
  196,163,113,138,128,80,69,31,117,151,217,223,212,140,148,162,120,81,46,63,82,
  228,224,219,182,150,106,123,138,76,61,53,139,203,210,229,179,127,99,159,112,
  92,48,69,146,177,221,191,165,96,129,127,116,89,44,58,139,216,209,191,139,94,
  128,149,132,72,57,58,175,181,185,161,135,89,100,155,124,125,47,82,154,192,
  170,134,129,78,140,131,149,84,57,65,156,202,166,148,115,108,134,151,144,95,
  58,91,183,159,173,134,128,111,158,167,160,136,77,100,130,204,155,155,134,140,
  136,138,180,155,117,68,150,167,158,154,134,173,130,184,156,172,91,110,112,
  153,165,113,139,138,164,137,167,156,108,74,102,139,151,134,108,144,142,112,
  138,151,144,83,97,103,133,72,138,141,134,117,131,168,140,103,60,126,145,132,
  105,126,138,105,133,155,175,100,72,79,126,132,99,151,125,139,113,186,182,141,
  70,84,117,132,108,92,139,135,115,150,170,191,79,85,98,145,105,123,131,154,
  124,132,195,182,142,82,110,112,154,100,124,144,133,111,140,193,168,136,118,
  131,120,83,101,130,140,119,143,167,222,152,114,119,133,96,62,97,121,151,96,
  154,192,209,162,153,161,110,77,73,131,139,152,132,147,194,203,193,178,153,93,
  61,80,123,122,133,137,141,182,193,224,191,166,89,57,54,106,128,118,123,120,
  151,181,207,174,184,118,72,56,62,94,75,99,112,166,169,201,195,190,161,97,74,
  28,72,71,79,90,131,159,173,212,197,201,127,92,35,50,55,75,72,98,152,175,218,
  200,189,182,147,89,68,57,73,58,43,140,160,213,198,194,215,202,145,81,50,51,
  50,47,85,140,172,196,211,242,230,221,155,84,47,49,49,67,67,131,174,211,225,
  239,247,230,144,81,55,39,62,75,97,132,172,209,224,245,243,227,123,72,38,34,
  48,52,84,130,185,215,243,240,241,198,138,66,33,21,8,34,74,137,173,201,211,
  227,221,176,130,69,28,10,13,31,81,109,147,170,204,232,195,176,128,63,10,11,
  18,43,43,86,154,169,197,230,226,203,156,124,56,32,7,22,38,86,121,177,182,221,
  248,220,185,141,89,25,13,8,38,69,105,158,198,229,245,237,215,191,131,55,45,
  35,40,68,94,130,193,225,247,241,226,197,170,83,43,29,39,63,86,131,166,221,
  219,247,238,213,169,109,61,24,33,49,87,110,161,191,225,234,240,230,178,162,
  99,58,23,37,44,62,101,147,200,219,246,227,221,181,139,94,47,27,21,48,97,153,
  184,235,244,246,234,198,154,103,58,31,17,24,45,100,146,172,211,225,223,210,
  170,138,111,83,27,9,10,34,81,127,178,206,231,228,214,160,141,101,54,14,11,9,
  30,87,130,164,180,204,204,220,191,164,124,82,32,9,10,24,65,104,152,166,195,
  219,227,225,185,159,103,65,22,13,32,70,114,154,190,217,236,226,225,190,168,
  125,77,42,39,63,102,144,173,207,214,201,190,190,194,162,141,82,55,29,63,105,
  138,169,191,183,169,170,175,200,203,203,169,110,49,27,56,104,124,130,128,116,
  112,129,153,198,233,236,185,136,55,23,29,90,101,115,115,114,108,133,171,210,
  239,204,153,84,19,8,15,84,127,131,102,127,132,145,159,205,220,200,169,112,74,
  26,20,41,119,132,125,122,151,177,161,187,200,182,152,132,87,60,37,16,88,165,
  182,147,165,188,168,143,165,194,173,145,139,121,63,28,27,116,189,191,190,207,
  201,152,105,125,159,136,129,155,140,87,59,72,118,174,170,175,186,162,109,109,
  143,149,142,125,136,137,99,74,84,108,152,194,190,179,132,89,105,127,100,107,
  148,137,127,127,117,122,120,126,165,177,159,136,109,105,144,133,142,141,111,
  73,77,96,116,148,182,181,174,137,117,92,94,97,145,151,147,104,66,74,91,149,
  211,252,239,183,98,57,54,60,109,142,181,173,114,93,80,99,135,180,174,168,122,
  77,64,71,107,166,192,185,184,157,130,125,92,88,83,51,34,34,80,186,222,215,
  211,155,114,118,111,124,146,147,126,94,57,46,74,93,138,170,207,215,193,145,
  149,97,62,83,106,117,131,150,144,145,137,116,135,103,76,75,129,208,222,160,
  138,125,87,105,132,134,134,127,125,148,125,87,102,87,87,95,123,181,197,199,
  206,219,131,101,87,103,108,133,121,171,163,114,78,69,74,71,105,171,192,180,
  177,164,153,144,131,121,132,122,94,103,127,118,124,117,104,71,58,82,133,166,
  197,173,206,193,183,152,126,121,116,115,122,107,105,97,103,124,154,140,112,
  102,139,152,173,148,158,167,168,173,138,135,132,100,106,119,144,133,121,96,
  125,156,142,120,104,126,164,162,121,154,182,161,147,155,173,156,113,48,87,
  121,124,88,102,119,124,165,178,169,150,145,125,132,116,104,129,119,107,91,
  131,138,148,138,156,182,158,144,123,110,78,51,57,118,133,132,126,141,145,133,
  137,164,188,171,112,99,118,128,138,172,133,77,47,72,118,168,148,124,136,145,
  145,187,210,191,166,125,104,88,92,54,24,30,68,125,158,193,226,237,199,166,
  188,226,244,165,62,8,26,38,79,124,146,139,140,132,134,168,194,175,167,143,
  139,138,116,113,123,135,127,89,75,96,142,175,144,112,106,97,141,186,202,189,
  124,93,85,75,67,59,77,67,33,61,121,156,204,223,226,223,192,153,124,101,67,51,
  46,36,36,56,101,156,177,164,173,174,178,184,174,149,109,62,37,42,54,107,146,
  161,193,193,197,222,213,209,193,124,90,66,63,69,69,98,113,102,101,109,117,
  165,206,220,204,169,119,73,60,85,136,162,160,151,145,126,113,129,136,124,62,
  17,43,110,157,177,200,219,198,170,158,135,129,118,122,111,66,26,19,72,93,140,
  160,187,202,207,218,211,200,175,165,139,77,12,13,50,108,134,139,153,144,150,
  164,209,226,202,165,150,115,68,44,31,68,75,92,119,167,211,234,242,241,212,
  174,150,125,110,73,50,87,105,89,74,61,82,123,143,175,197,208,186,159,147,120,
  110,115,115,75,89,87,122,134,132,136,151,134,134,149,177,168,147,150,150,123,
  93,34,57,85,96,128,119,103,141,161,167,165,151,162,141,135,144,148,160,142,
  98,90,44,27,52,81,76,100,138,186,211,230,224,197,190,176,167,181,126,79,67,
  34,30,24,45,100,143,148,153,180,223,219,193,192,169,153,99,40,43,48,62,92,
  117,135,139,142,158,162,167,193,192,195,169,143,127,89,55,70,42,51,66,56,87,
  132,173,214,221,213,172,157,169,166,160,147,93,91,75,25,45,54,79,112,123,149,
  173,183,210,211,194,195,158,141,141,118,111,88,81,63,56,42,76,122,168,172,
  205,210,206,220,219,193,166,124,79,50,20,58,63,74,117,161,201,209,190,195,
  214,194,171,149,128,105,54,61,61,80,106,104,109,133,147,173,201,193,192,168,
  172,164,135,108,78,64,60,58,80,91,92,113,138,169,183,178,187,171,178,182,168,
  150,124,69,54,46,30,72,66,83,115,141,161,197,196,197,183,161,166,145,132,119,
  95,66,30,45,56,70,90,122,154,197,207,208,211,215,214,188,143,100,57,48,51,49,
  74,108,92,117,145,167,196,205,182,187,182,182,185,155,118,77,47,33,18,54,70,
  99,136,174,179,190,194,205,214,183,182,163,141,103,71,69,50,30,52,70,92,134,
  157,173,202,200,198,199,197,186,149,105,63,44,51,50,64,86,97,119,152,177,188,
  192,184,188,178,179,182,151,123,82,64,52,43,51,64,78,136,183,205,227,216,208,
  202,192,176,140,98,65,39,49,45,52,89,103,133,153,172,175,190,192,213,201,192,
  174,126,101,53,20,20,23,54,91,115,158,196,192,209,193,196,187,166,154,139,
  109,73,45,31,35,27,65,95,120,162,181,210,227,224,209,194,154,152,122,95,61,
  26,55,61,70,86,102,108,157,171,188,208,192,198,177,180,174,149,105,66,50,53,
  49,59,91,103,157,171,190,205,191,202,197,191,177,161,102,66,31,43,51,52,87,
  92,127,168,183,189,207,178,189,196,184,197,155,119,53,38,28,34,27,48,73,116,
  159,166,207,209,215,216,201,182,156,120,79,49,28,51,34,62,78,110,149,175,185,
  196,195,187,189,167,176,137,109,76,43,44,35,31,60,121,145,188,194,209,225,
  224,218,193,180,141,119,76,51,19,29,43,67,94,104,155,171,188,206,226,227,208,
  188,178,171,112,86,56,42,21,43,52,73,123,158,195,194,207,180,214,191,176,166,
  150,126,76,62,35,37,39,64,73,121,167,163,176,176,215,203,216,179,167,142,123,
  98,58,50,11,34,53,75,97,169,184,173,196,199,225,201,189,155,157,129,102,68,
  47,39,16,57,77,96,134,167,176,207,233,216,207,172,163,137,137,96,70,45,38,50,
  39,77,83,143,171,176,172,230,235,224,215,170,154,118,110,66,64,33,31,33,45,
  95,122,171,168,172,184,209,204,207,180,156,145,128,110,81,64,32,31,28,63,115,
  143,166,149,184,208,238,225,203,161,138,123,105,91,59,36,25,46,45,101,137,
  169,185,172,194,205,208,197,190,169,167,145,115,96,71,46,31,35,39,105,150,
  173,170,174,195,222,219,207,189,158,143,125,99,86,53,27,31,32,60,136,155,172,
  178,183,204,222,214,200,177,148,138,117,99,84,56,48,46,36,70,128,139,151,159,
  171,207,230,217,218,202,173,145,120,88,71,38,26,29,33,81,138,151,162,189,204,
  231,233,204,194,168,129,103,85,82,77,50,44,51,58,99,138,153,150,159,169,219,
  227,207,208,184,155,132,115,99,75,34,25,34,30,70,118,147,168,196,195,234,236,
  219,217,178,130,85,68,64,65,38,34,43,59,109,160,176,176,176,158,197,206,193,
  195,174,151,130,119,100,91,47,40,27,40,69,111,129,146,171,177,219,224,226,
  229,198,161,118,92,78,74,45,28,21,42,72,141,165,154,170,171,215,221,215,201,
  184,147,119,93,75,66,55,50,52,57,61,127,150,141,149,146,181,205,228,235,217,
  159,133,121,110,107,72,33,19,30,36,93,116,135,150,169,199,224,234,233,218,
  173,130,101,85,76,59,28,25,41,45,92,142,158,163,176,187,212,225,222,209,160,
  135,110,103,103,89,53,34,30,31,53,109,134,133,144,159,190,228,233,228,200,
  171,143,117,105,83,48,19,21,25,48,90,142,158,176,189,205,225,238,222,194,151,
  110,87,79,78,63,44,39,45,66,109,148,175,170,177,178,198,223,222,208,180,142,
  111,106,107,93,63,39,32,35,59,93,132,144,150,172,194,222,243,229,197,161,117,
  104,95,83,55,33,23,42,64,106,145,161,176,180,200,208,228,217,192,156,114,84,
  80,88,91,80,61,47,50,69,106,153,179,160,158,173,204,241,236,213,174,137,116,
  107,85,66,43,48,49,63,61,95,131,150,170,187,204,213,240,225,197,164,130,113,
  113,101,81,56,42,44,60,82,97,116,156,149,151,170,206,236,242,228,186,150,119,
  105,80,67,56,52,51,57,54,60,118,160,191,182,195,199,222,218,194,163,151,134,
  113,98,69,57,68,90,95,66,58,80,123,153,161,142,157,192,235,244,221,190,159,
  136,112,86,47,57,68,72,45,28,32,93,158,196,199,181,192,217,226,220,176,140,
  124,104,64,43,38,64,87,98,65,61,90,149,185,199,183,146,177,213,214,192,156,
  130,126,109,78,58,63,95,111,97,63,43,79,149,183,168,173,154,178,215,201,180,
  157,136,137,114,74,50,49,94,130,119,88,65,69,119,173,189,187,186,144,162,139,
  120,120,131,144,167,141,111,102,110,144,151,116,76,59,66,120,147,150,131,138,
  129,145,151,154,182,192,203,189,144,115,111,99,107,96,60,62,77,125,153,171,
  165,145,131,131,98,111,120,146,180,189,182,183,176,171,150,111,89,69,63,70,
  90,97,115,131,125,124,123,131,128,135,158,177,196,207,201,188,153,114,97,89,
  94,76,78,72,101,122,147,138,135,136,142,127,123,114,113,150,176,210,207,194,
  167,142,119,103,82,81,78,58,80,111,133,163,178,172,157,138,118,104,96,102,
  126,174,186,204,188,157,126,105,99,104,98,106,94,94,106,137,179,202,192,152,
  109,90,94,108,94,88,95,90,118,122,151,170,198,201,179,144,136,134,139,125,
  103,80,94,115,140,147,131,112,111,103,102,92,75,82,107,119,137,145,172,218,
  218,200,180,164,146,130,111,112,88,96,95,95,101,112,106,110,117,124,123,118,
  112,107,106,117,133,138,164,173,184,193,188,192,191,160,136,119,99,83,66,52,
  63,77,106,133,137,140,139,134,131,134,118,101,106,129,144,156,174,186,191,
  194,183,159,119,103,95,114,107,110,88,93,111,115,125,129,133,123,125,122,140,
  136,133,130,125,115,121,124,152,161,139,147,119,129,145,144,154,142,122,106,
  106,121,128,124,132,134,137,111,120,123,126,103,119,103,127,123,134,133,144,
  142,145,128,111,112,111,123,114,146,144,161,172,177,184,155,131,130,109,77,
  63,60,71,78,95,115,126,154,167,194,172,187,163,172,126,117,114,104,83,76,83,
  93,110,142,180,194,191,181,165,151,127,109,85,71,66,101,114,133,142,161,158,
  151,132,131,129,130,113,112,110,124,132,131,143,142,148,139,149,147,154,144,
  149,134,130,103,98,99,104,116,118,133,142,154,162,147,139,135,135,127,129,
  117,127,126,139,136,140,136,137,135,146,133,126,127,126,140,120,105,105,116,
  124,135,136,148,158,157,153,137,136,123,134,131,130,129,125,124,121,128,131,
  138,125,129,131,139,141,142,157,142,135,106,99,104,104,108,113,121,133,138,
  144,151,152,149,140,142,140,138,144,137,134,118,113,102,100,108,121,129,124,
  136,147,157,144,143,137,129,129,127,120,121,124,118,123,115,128,129,136,142,
  145,161,148,148,127,128,114,113,102,102,112,123,135,134,140,137,140,127,122,
  129,129,132,132,139,137,143,137,143,138,130,123,117,115,108,112,112,126,124,
  137,141,141,151,151,158,145,135,115,112,98,102,101,111,125,139,153,157,163,
  157,154,137,125,117,113,109,108,112,105,113,112,134,145,155,152,150,147,146,
  149,143,145,128,126,118,106,107,118,126,132,138,129,129,126,133,133,141,139,
  133,136,139,147,147,153,136,133,121,115,113,104,109,111,120,119,129,129,144,
  146,150,156,156,156,147,147,131,126,115,111,101,103,109,112,124,121,140,143,
  158,157,157,154,143,134,117,113,100,115,107,109,113,130,143,146,153,147,151,
  139,144,142,141,125,111,108,103,111,107,115,110,127,134,146,150,146,147,138,
  144,137,136,123,125,123,120,112,109,118,114,120,116,128,124,132,137,139,141,
  136,134,127,128,118,123,117,119,123,128,132,130,130,131,139,136,139,134,133,
  132,133,132,127,124,114,112,110,119,121,128,131,135,142,149,153,145,150,148,
  148,138,132,119,110,109,102,109,107,115,117,129,129,138,143,143,148,146,149,
  146,145,135,134,125,118,103,104,109,107,120,121,136,141,158,152,155,146,144,
  139,129,123,112,118,113,119,112,115,117,124,134,141,149,146,152,148,152,139,
  130,119,109,104,105,110,112,126,126,137,143,147,144,136,137,136,139,133,142,
  128,129,121,126,122,118,117,112,122,123,134,127,135,132,141,149,149,151,138,
  140,128,125,120,118,105,108,116,117,123,123,136,141,151,155,152,149,144,137,
  130,125,106,104,100,107,110,120,128,137,146,154,158,154,153,138,138,127,120,
  115,106,105,111,118,123,134,132,135,134,142,147,152,147,141,140,143,143,141,
  129,114,107,103,108,117,117,122,131,137,143,148,148,147,143,143,144,138,129,
  116,114,110,111,112,119,121,129,136,147,153,156,154,148,141,132,129,119,113,
  108,114,119,121,123,122,128,131,139,144,147,143,145,146,143,147,140,133,119,
  117,110,110,108,113,119,124,134,136,147,145,152,152,155,151,141,134,124,120,
  113,118,112,112,113,122,134,137,141,140,150,144,153,148,153,141,129,118,112,
  111,108,104,108,124,127,138,144,148,148,144,147,143,143,130,129,123,122,116,
  118,115,109,111,118,131,135,136,142,151,155,151,151,144,138,127,120,115,114,
  104,104,109,115,124,129,139,147,153,152,156,158,151,141,135,130,122,116,109,
  108,109,109,112,124,129,133,134,143,146,148,150,148,149,140,134,123,118,108,
  102,104,106,113,117,131,142,146,153,157,161,157,151,135,132,120,114,104,103,
  105,107,113,120,126,135,142,148,153,150,148,145,137,137,135,126,120,118,112,
  112,113,115,119,123,130,138,138,142,143,147,147,149,143,137,134,127,123,116,
  109,107,110,106,110,122,133,137,144,153,153,149,143,139,132,125,124,119,113,
  110,111,114,115,119,127,133,137,138,138,144,149,153,144,137,130,124,123,119,
  117,112,113,114,118,126,134,136,142,147,143,148,153,149,137,134,128,120,112,
  108,115,114,118,123,132,139,147,151,144,138,131,129,129,130,130,130,130,130,
  130,130,129,121,126,121,124,132,139,139,142,142,137,137,132,139,132,129,126,
  126,125,124,124,122,128,123,129,135,146,144,141,136,132,130,126,127,122,124,
  125,129,131,134,134,129,130,123,128,130,133,128,130,129,134,140,134,132,129,
  133,126,127,124,128,128,122,129,123,130,131,139,132,134,132,139,139,128,125,
  117,122,115,122,127,132,135,136,141,137,135,129,123,112,121,116,119,128,132,
  145,144,143,133,134,128,130,122,118,117,113,122,127,130,132,133,127,133,139,
  137,137,135,132,126,129,123,125,124,129,132,130,133,130,135,128,132,127,124,
  123,125,126,138,138,138,145,144,153,140,132,124,107,104,105,120,119,132,135,
  141,152,154,159,148,144,123,128,123,124,119,120,109,115,112,128,141,144,148,
  139,139,138,130,134,132,127,127,122,132,138,145,142,131,126,126,116,121,112,
  110,122,127,133,135,138,151,157,153,149,142,139,131,121,100,102,104,109,123,
  118,128,129,142,146,160,155,157,135,134,129,126,124,127,123,108,116,111,118,
  123,140,138,134,131,125,137,142,149,142,138,133,129,126,127,122,124,122,129,
  121,115,117,125,129,133,131,143,140,158,136,146,128,144,134,128,125,121,114,
  117,120,125,129,128,124,120,128,126,138,155,154,154,151,141,143,131,133,121,
  123,112,107,108,103,118,124,136,130,140,135,148,151,154,143,150,145,134,121,
  121,117,100,102,106,120,115,130,132,141,153,154,149,140,142,134,116,130,121,
  127,131,139,135,132,119,118,108,131,117,125,121,121,128,136,147,152,149,147,
  147,145,127,118,116,126,114,109,102,110,111,120,122,135,138,151,139,147,159,
  146,142,146,147,139,111,107,104,110,110,113,111,124,136,139,146,130,137,135,
  151,148,143,136,128,133,130,139,139,125,119,111,113,107,107,122,124,134,136,
  137,153,144,152,153,151,128,134,134,127,127,122,119,107,100,93,113,123,136,
  135,138,148,151,159,148,158,149,150,135,124,115,104,109,109,109,118,116,118,
  123,135,137,143,154,157,150,158,147,135,130,127,127,128,119,111,111,118,114,
  124,118,121,127,134,135,144,135,143,146,152,149,144,132,128,121,118,115,118,
  118,122,123,117,118,113,117,135,148,153,154,138,135,134,137,137,136,122,128,
  117,111,112,123,134,139,136,132,134,131,135,136,144,137,134,129,132,141,131,
  131,124,122,127,129,128,128,135,136,138,138,128,127,126,134,134,136,133,137,
  125,128,124,124,125,132,139,139,138,132,135,135,142,131,125,120,118,124,130,
  141,139,135,125,125,118,121,128,137,144,140,140,131,129,133,133,136,134,127,
  126,126,126,130,129,134,127,121,112,113,120,124,132,135,146,151,146,141,137,
  133,127,126,124,126,120,119,122,121,118,118,125,123,131,123,128,128,131,134,
  140,139,143,147,147,141,132,125,118,118,115,111,105,111,115,123,130,131,135,
  142,145,137,128,128,135,144,150,148,133,125,124,124,123,114,111,112,117,118,
  127,130,142,150,147,141,134,139,144,146,132,121,122,117,121,118,113,119,123,
  128,137,133,138,142,143,142,133,128,127,133,142,146,139,128,130,125,122,115,
  112,108,116,123,127,128,133,142,146,151,152,151,147,144,133,126,125,122,125,
  121,124,123,122,119,123,128,132,128,126,124,128,132,135,139,138,137,141,146,
  149,143,142,133,123,118,114,120,114,110,105,109,116,134,132,145,145,142,141,
  137,140,135,132,124,120,116,117,118,123,130,134,139,133,128,124,127,126,126,
  126,126,127,127,128,128,132,133,132,132,132,128,126,126,127,123,121,119,121,
  125,130,132,134,136,143,143,143,136,133,132,134,128,125,119,117,112,128,133,
  132,131,134,134,139,136,134,131,130,130,127,127,126,126,128,133,133,131,133,
  137,144,142,140,136,135,131,131,135,134,131,129,129,129,129,124,124,123,125,
  129,132,135,137,142,143,142,134,126,124,125,132,132,137,136,137,133,136,138,
  133,126,127,120,118,121,122,129,135,140,137,133,128,127,130,132,134,132,130,
  129,132,133,132,133,131,133,133,136,134,135,141,138,138,130,124,116,114,114,
  122,129,131,137,138,139,140,144,142,140,134,129,126,124,127,128,129,126,129,
  135,138,138,127,128,128,128,127,123,123,123,123,124,132,137,137,144,147,143,
  133,128,128,128,129,124,118,119,122,128,133,134,137,139,139,134,134,126,122,
  128,127,123,119,112,117,126,131,133,133,132,129,128,128,128,129,133,132,129,
  129,130,130,130,127,129,127,127,124,125,126,126,127,127,126,126,127,127,129,
  132,132,134,133,132,128,128,124,122,125,126,124,129,131,134,138,138,137,137,
  131,132,132,130,127,126,125,121,119,116,118,122,123,123,128,135,136,142,144,
  147,148,144,140,141,136,127,122,118,119,116,117,120,128,129,131,135,137,140,
  142,140,138,134,129,130,128,128,127,128,126,128,129,135,140,137,136,136,134,
  134,134,136,135,132,130,128,122,122,122,123,123,127,128,127,133,133,137,136,
  136,134,134,136,136,138,131,128,130,130,130,129,123,123,122,121,128,131,135,
  136,138,141,139,138,134,133,129,127,121,121,121,128,129,134,134,134,138,139,
  139,134,136,134,134,127,122,121,118,122,125,129,132,130,130,131,134,133,135,
  127,126,127,124,127,128,129,130,130,132,130,127,128,128,128,128,128,128,128,
  129,130,132,137,134,129,130,130,129,130,128,126,124,125,127,129,134,138,138,
  140,141,133,133,129,128,125,120,122,123,128,129,131,137,138,142,140,139,134,
  129,123,121,118,122,124,130,129,135,137,137,137,137,132,127,123,125,126,128,
  129,133,132,133,128,134,131,135,131,127,127,126,124,128,130,131,137,139,138,
  138,135,131,128,124,119,119,122,124,125,128,133,137,142,143,145,138,132,127,
  123,118,112,114,118,121,129,134,139,140,139,138,132,130,127,128,127,127,129,
  130,133,131,129,130,130,129,128,130,130,129,128,127,130,132,135,136,139,138,
  138,131,125,122,119,118,119,121,127,129,133,135,145,148,144,139,135,129,124,
  119,118,117,122,123,129,131,134,134,137,134,133,132,133,132,133,132,133,132,
  133,132,132,132,127,128,128,130,130,130,126,127,129,135,138,140,146,144,137,
  133,128,122,117,118,118,125,128,133,137,139,144,141,140,138,133,131,133,131,
  128,129,127,128,129,134,131,134,132,129,124,125,126,129,133,131,133,133,133,
  143,136,134,128,130,130,127,121,119,121,122,125,131,137,141,142,148,145,139,
  129,122,118,119,122,126,133,134,139,140,139,133,132,137,140,134,128,123,121,
  121,121,128,132,138,142,151,153,146,144,141,133,128,124,118,120,116,118,123,
  135,136,133,137,145,140,134,126,126,128,124,129,132,144,137,134,138,135,127,
  122,125,125,112,119,118,130,132,132,142,146,149,142,139,140,140,115,112,110,
  107,121,99,125,120,144,137,148,149,148,143,142,138,121,129,107,129,113,124,
  112,127,121,134,127,138,124,136,121,141,127,133,120,134,126,141,135,136,138,
  125,128,122,123,117,111,122,118,128,119,146,131,155,135,156,133,151,119,136,
  110,127,101,126,104,131,119,140,128,156,135,159,125,157,125,159,107,129,103,
  126,110,127,121,140,125,135,132,144,140,139,136,144,127,138,128,136,126,142,
  123,140,115,137,124,140,128,132,132,141,129,134,131,144,134,143,138,140,138,
  121,124,134,134,135,131,134,132,132,129,134,137,139,133,138,132,143,126,139,
  130,145,125,134,114,128,111,129,126,138,131,144,132,147,130,149,141,144,134,
  128,127,126,109,128,109,135,123,138,134,139,134,138,138,160,137,138,127,130,
  124,122,130,129,130,127,126,137,133,145,127,136,136,150,124,138,127,130,129,
  133,131,136,130,142,118,141,117,144,113,143,119,139,127,134,127,149,129,139,
  128,140,133,132,121,129,114,132,109,137,120,138,110,132,124,141,129,150,144,
  144,129,135,117,124,121,129,111,123,118,122,129,115,133,119,138,118,148,125,
  143,118,135,117,151,116,130,114,135,112,147,110,143,103,144,115,145,110,136,
  119,149,128,148,119,135,110,133,117,134,114,142,118,132,116,119,116,135,146,
  131,152,127,144,122,156,124,142,110,138,114,133,108,132,116,152,124,154,124,
  146,107,174,109,156,116,155,117,150,113,140,117,144,117,139,132,124,128,133,
  143,136,137,131,135,136,135,123,146,135,140,117,141,113,135,114,146,100,156,
  109,147,117,160,122,141,118,154,121,159,132,145,118,139,118,139,112,127,122,
  136,120,129,137,131,151,124,154,120,163,123,155,124,143,108,136,105,132,107,
  140,113,139,126,149,129,146,124,151,128,146,121,135,123,134,129,132,115,114,
  124,129,121,129,124,130,135,131,139,140,145,124,147,139,142,107,136,117,132,
  120,133,103,134,114,135,121,145,123,148,123,142,125,148,128,133,122,133,123,
  132,118,117,129,122,119,116,142,122,117,134,138,130,145,127,141,120,148,119,
  136,120,128,120,126,115,111,118,131,123,130,122,140,135,147,139,145,137,127,
  127,132,135,124,123,116,135,116,130,113,133,117,140,124,136,121,141,131,142,
  132,142,132,136,121,139,122,139,114,128,111,118,114,124,121,130,127,140,138,
  142,146,140,157,146,141,120,130,117,121,118,126,107,109,112,128,124,129,136,
  148,143,149,142,152,144,138,133,127,118,118,116,119,117,116,114,116,125,126,
  131,134,139,143,143,147,142,131,138,135,133,114,131,120,131,118,122,115,120,
  116,125,124,131,127,138,142,150,144,141,138,137,139,127,128,121,122,115,123,
  117,122,120,127,126,133,131,137,132,138,134,139,143,138,137,135,131,137,134,
  129,129,127,125,124,120,113,118,120,127,132,135,134,141,145,153,148,149,134,
  136,126,131,125,120,107,115,114,125,116,126,126,137,136,139,140,136,142,141,
  145,133,139,123,131,128,134,126,124,124,114,126,125,122,124,129,129,133,133,
  131,132,142,139,145,140,140,130,134,128,131,121,124,116,119,122,119,124,129,
  136,131,138,133,137,131,141,135,135,128,134,131,138,129,130,127,127,122,119,
  123,115,123,121,134,131,139,129,142,138,144,141,139,144,135,142,125,135,123,
  130,121,118,113,116,111,112,120,123,130,137,137,145,145,153,155,142,149,140,
  141,126,131,124,120,112,104,111,107,113,111,122,117,141,127,139,139,149,139,
  162,144,156,144,138,131,136,126,112,116,93,99,89,105,94,126,111,141,129,159,
  138,174,155,169,162,149,137,137,134,117,126,103,99,91,104,84,107,101,125,118,
  156,136,169,163,161,169,174,158,134,145,122,120,108,100,83,85,88,95,98,117,
  122,130,143,158,177,182,188,189,171,151,145,132,117,109,85,75,57,63,73,91,
  104,122,134,168,170,196,204,196,201,196,171,148,138,110,96,79,77,63,65,65,82,
  94,121,128,151,160,186,192,194,193,200,176,160,153,128,109,91,82,78,65,63,75,
  84,107,114,143,154,172,181,191,187,202,178,162,144,133,112,100,78,74,75,75,
  90,87,106,116,133,155,173,178,188,177,180,183,163,139,135,115,102,87,76,73,
  79,90,96,101,118,126,152,165,179,184,178,182,181,171,153,147,124,108,89,76,
  74,74,82,86,82,104,109,139,157,173,186,187,181,182,187,165,157,138,114,95,71,
  60,68,68,89,77,101,114,137,160,177,199,190,195,185,181,165,150,139,106,83,63,
  55,65,72,97,96,100,124,150,165,181,200,181,195,188,178,163,148,130,105,90,62,
  46,59,72,83,106,99,125,146,172,188,205,192,191,189,165,153,144,136,102,84,62,
  59,58,91,85,103,120,125,151,174,196,203,200,186,182,162,144,138,125,108,83,
  63,59,65,82,98,97,121,128,151,166,192,199,193,191,171,161,144,144,124,110,82,
  69,63,75,82,108,95,120,136,151,165,189,182,181,192,169,158,148,144,121,112,
  89,74,73,86,83,100,104,101,130,142,163,176,195,190,191,183,165,153,137,126,
  95,77,64,62,71,91,80,111,119,137,155,183,190,201,195,193,184,167,148,130,114,
  98,71,62,66,64,96,86,93,116,137,152,178,187,192,213,197,184,168,153,129,105,
  85,61,58,61,66,80,103,96,134,151,167,191,198,189,196,210,174,157,137,120,91,
  76,57,60,71,88,74,98,112,136,158,181,189,188,201,206,206,190,161,130,103,82,
  55,47,56,59,87,93,93,134,146,167,192,196,191,212,206,182,166,142,118,97,74,
  47,56,66,77,87,116,110,135,155,168,179,204,181,194,210,176,153,151,115,85,71,
  50,50,61,92,81,97,123,132,159,177,194,179,212,193,192,184,158,124,113,91,48,
  54,58,57,80,109,86,131,147,150,181,189,188,202,225,182,173,160,130,101,78,51,
  36,53,69,66,97,112,123,152,168,178,196,195,204,207,203,166,143,123,100,72,49,
  50,50,67,87,85,122,131,153,160,194,185,209,225,204,198,172,140,108,100,55,44,
  46,48,52,92,91,106,146,150,168,192,205,203,227,217,182,162,129,103,82,55,30,
  46,65,59,74,111,117,144,163,176,188,223,194,223,224,181,145,125,101,70,57,37,
  45,69,82,66,97,125,148,163,197,187,210,202,221,227,186,140,108,94,63,55,53,
  49,74,84,70,83,126,147,163,184,187,199,222,202,220,192,142,100,92,83,55,51,
  53,77,90,90,85,114,129,161,183,195,193,213,207,209,216,147,121,98,85,61,68,
  54,59,90,92,90,104,134,147,171,190,202,211,203,184,196,172,127,107,94,99,72,
  58,66,82,91,95,97,112,136,164,184,193,194,199,168,202,179,141,124,108,91,100,
  106,73,71,80,83,94,128,131,136,153,171,171,210,190,161,192,159,142,119,123,
  111,109,80,59,79,90,109,99,113,118,136,156,174,155,187,168,179,166,164,156,
  122,113,113,121,99,77,68,84,105,113,112,118,126,140,145,161,175,181,181,157,
  172,156,149,146,133,102,76,65,68,115,114,91,92,93,111,152,152,159,169,175,
  163,200,195,165,157,132,116,105,96,62,64,87,92,88,102,96,122,148,158,146,203,
  180,167,194,179,172,160,136,112,106,61,48,89,102,108,99,76,73,122,149,174,
  163,184,153,204,193,206,203,157,118,104,107,72,62,61,71,86,83,81,100,139,167,
  166,177,186,191,190,194,205,166,155,121,111,84,60,50,55,99,109,74,85,97,119,
  168,174,168,183,190,167,221,211,174,149,115,92,88,83,44,61,84,91,83,94,94,
  140,166,175,160,191,167,178,201,194,191,147,117,99,100,64,47,72,87,110,101,
  90,93,129,152,174,171,171,164,184,184,199,183,154,113,108,103,78,62,61,90,
  114,104,87,102,119,168,161,173,157,179,156,188,193,176,173,120,108,99,109,66,
  69,95,102,107,104,87,110,152,152,157,165,181,164,203,184,192,168,138,112,115,
  111,65,69,67,102,109,94,86,97,125,152,150,170,186,188,176,197,189,172,161,
  120,111,97,81,55,63,103,103,93,82,84,118,150,154,166,185,181,166,199,183,194,
  176,129,98,97,87,46,88,102,105,108,87,56,103,145,164,160,173,156,158,187,210,
  205,178,138,98,109,90,67,69,89,111,114,95,63,75,132,149,173,168,165,153,168,
  207,199,193,161,127,112,104,84,58,86,95,102,95,66,61,120,143,171,167,174,163,
  184,183,208,193,161,143,111,116,92,71,69,77,98,103,69,81,95,134,162,174,170,
  190,185,173,210,192,179,154,118,92,97,83,55,76,94,109,107,78,73,117,151,177,
  161,176,175,178,195,222,190,167,137,85,101,85,61,63,88,107,120,102,73,82,141,
  163,173,169,158,157,174,224,196,185,151,109,107,105,80,53,86,93,105,104,79,
  77,117,153,181,173,161,157,168,177,209,187,160,135,109,114,93,77,75,92,107,
  113,76,74,87,126,161,175,160,154,164,165,194,198,184,145,132,119,114,100,66,
  80,100,115,103,76,72,96,136,169,173,168,147,165,167,214,195,181,157,122,127,
  103,89,67,88,106,120,97,78,65,100,139,166,168,148,152,160,181,204,209,183,
  155,138,114,108,76,71,80,113,107,92,68,68,95,154,165,172,160,148,162,197,202,
  206,182,143,133,119,105,82,68,81,108,98,84,65,75,116,157,165,169,163,163,176,
  193,198,193,175,139,138,127,100,76,67,91,99,101,71,57,78,120,154,167,168,158,
  183,192,183,199,182,156,155,137,123,100,80,64,91,99,94,68,62,78,113,152,167,
  175,170,180,203,189,195,192,160,150,133,105,94,68,67,81,107,96,74,66,72,107,
  155,161,169,176,177,197,197,196,193,184,152,135,106,90,69,56,65,82,95,78,73,
  76,104,146,163,166,184,187,180,177,184,184,190,166,138,124,107,85,53,49,70,
  85,79,71,73,115,145,170,190,206,201,195,174,168,178,186,156,135,124,107,79,
  54,48,78,93,87,65,74,104,138,167,192,197,202,196,169,161,166,171,166,147,129,
  113,79,52,43,66,88,94,67,74,92,141,166,198,201,211,188,165,141,151,167,176,
  152,131,119,96,68,56,63,92,105,86,66,83,116,152,182,195,201,200,168,145,138,
  162,184,174,147,124,119,88,61,44,68,89,100,79,79,113,147,169,202,204,212,184,
  142,124,143,179,194,178,150,130,101,68,41,48,72,94,87,74,104,130,170,195,209,
  211,207,148,123,123,149,199,193,163,133,108,80,49,47,64,88,87,78,81,128,167,
  184,200,209,195,180,126,131,133,179,189,176,149,119,87,46,38,51,84,94,87,77,
  112,148,178,197,203,199,183,150,121,148,145,193,176,163,137,101,69,44,54,67,
  102,91,101,93,144,156,189,187,201,178,177,135,140,146,160,190,169,156,118,83,
  46,42,63,80,96,104,113,116,152,164,182,179,189,165,170,147,136,138,159,193,
  178,157,99,72,50,65,67,86,94,119,130,135,144,162,181,167,182,164,169,157,130,
  123,156,197,181,147,88,68,69,78,75,82,100,128,131,119,144,151,184,158,170,
  157,173,146,126,123,147,182,154,126,85,82,82,82,78,88,100,124,126,114,146,
  156,173,159,169,161,182,149,125,124,134,168,147,128,84,84,86,92,97,99,108,
  118,125,123,148,149,170,150,170,165,172,154,119,116,121,157,140,132,95,95,91,
  102,107,107,118,121,126,121,150,143,170,150,165,158,171,145,110,111,113,150,
  145,145,108,110,107,114,115,114,111,108,128,122,138,137,159,148,164,161,169,
  169,118,111,104,151,161,161,115,96,102,119,127,109,103,91,116,116,128,139,
  153,146,144,161,166,178,138,114,107,136,162,161,126,99,97,108,124,110,99,91,
  112,117,132,139,146,154,145,166,172,180,156,120,104,122,142,150,130,106,109,
  107,117,117,101,99,112,130,135,139,142,147,135,162,162,180,172,123,100,100,
  126,143,154,115,106,106,119,132,114,112,105,127,136,134,131,141,136,145,175,
  165,174,138,98,90,108,139,157,134,113,113,124,134,136,119,105,115,124,124,
  118,120,130,129,155,159,166,159,107,82,94,133,158,166,123,121,131,147,151,
  121,112,108,116,107,108,96,121,128,135,167,170,170,133,105,98,140,161,171,
  142,124,140,146,148,125,102,79,91,89,94,96,108,133,145,173,188,194,172,124,
  109,119,143,170,162,124,127,134,146,128,96,70,76,98,104,107,110,139,148,190,
  206,202,194,145,96,95,119,145,160,129,109,122,135,136,114,85,73,96,117,118,
  108,138,162,180,200,196,187,166,96,77,90,124,152,145,113,120,137,145,133,98,
  93,102,121,117,110,118,152,168,181,193,174,157,116,75,85,109,145,158,132,131,
  148,160,151,124,98,93,101,106,98,100,136,151,167,176,172,165,150,93,87,105,
  129,161,157,138,152,168,166,149,110,96,78,91,93,80,91,131,137,157,182,162,
  170,150,105,113,133,154,170,158,140,146,152,143,109,79,71,66,78,80,81,117,
  148,161,187,191,184,184,147,115,126,141,153,157,129,133,139,133,104,76,63,63,
  72,90,96,115,159,186,194,214,209,193,181,116,100,106,113,131,119,113,114,127,
  122,107,80,85,83,99,113,118,134,170,192,202,201,188,171,140,87,78,84,101,119,
  117,121,135,152,145,127,113,109,106,116,112,120,146,172,181,182,174,156,146,
  119,70,80,92,103,130,135,152,169,175,163,137,118,114,92,94,97,102,125,149,
  146,161,164,157,147,136,89,96,112,123,153,167,173,174,169,150,120,93,80,60,
  75,86,98,126,156,162,182,185,166,164,151,107,112,116,134,152,166,161,154,146,
  117,91,64,65,55,80,94,114,149,183,190,203,201,182,176,147,98,98,99,109,135,
  139,139,139,131,117,93,79,77,75,97,125,142,169,205,192,205,198,166,155,127,
  61,69,64,93,131,139,143,147,146,135,115,93,94,84,110,128,138,157,184,175,183,
  174,143,135,118,57,65,72,102,147,159,165,164,166,148,122,97,90,79,92,110,115,
  140,170,166,176,174,150,145,132,78,87,102,122,161,172,176,175,164,139,102,72,
  69,61,79,98,121,148,180,180,192,191,175,163,141,89,94,99,123,158,156,163,157,
  143,120,90,65,70,63,85,106,130,159,189,199,205,204,193,166,143,86,83,87,95,
  133,136,144,146,140,125,98,77,78,77,98,124,144,160,196,194,195,205,174,152,
  131,75,73,72,82,119,144,143,154,144,128,111,93,96,91,107,126,137,157,195,187,
  186,188,164,135,128,76,55,71,75,124,152,162,164,160,149,127,108,102,97,97,
  114,126,138,174,177,172,184,162,137,129,94,61,83,89,130,159,168,179,169,158,
  131,107,95,87,79,95,108,131,165,181,177,189,177,156,142,108,73,87,96,123,155,
  167,173,168,155,126,96,83,80,69,89,110,129,165,189,184,197,187,165,153,123,
  76,85,93,104,143,154,162,163,153,128,102,84,85,77,101,116,135,160,194,190,
  201,193,173,147,126,74,70,84,94,135,149,159,165,153,129,108,87,90,81,93,112,
  130,161,195,189,195,189,173,135,123,84,65,77,90,123,144,157,166,158,140,113,
  90,88,85,90,109,127,152,177,186,188,200,178,147,123,90,50,70,75,111,146,155,
  167,160,146,122,100,89,86,79,103,117,145,175,188,192,189,173,148,120,90,55,
  73,87,108,140,153,169,170,148,121,99,82,93,84,104,123,138,165,187,192,186,
  174,160,122,113,66,71,84,97,141,153,168,169,154,132,108,93,96,85,96,117,134,
  161,187,195,193,183,165,119,107,76,59,80,88,131,154,163,176,163,140,118,91,
  92,92,97,111,128,153,182,186,182,177,160,133,107,88,51,76,91,126,153,167,174,
  168,155,133,105,88,91,81,110,129,137,160,179,178,178,169,149,116,102,68,82,
  105,127,146,163,178,170,159,127,101,86,97,82,100,116,133,157,183,183,178,179,
  160,129,115,93,66,97,113,140,155,167,163,155,135,102,81,79,83,88,115,128,150,
  174,182,185,191,180,145,121,99,68,82,104,122,153,167,167,153,132,107,85,84,
  96,89,113,132,149,185,203,193,199,183,158,116,101,62,72,96,109,134,147,155,
  153,145,123,100,93,101,97,116,139,143,173,193,187,182,177,160,118,116,85,52,
  82,93,121,153,165,163,158,132,114,99,114,112,110,130,136,150,178,177,176,180,
  169,139,108,88,53,71,100,118,148,159,163,162,148,135,111,111,111,99,120,123,
  134,161,180,177,173,162,141,106,108,74,61,87,100,135,165,173,177,165,141,115,
  101,109,100,108,121,122,143,166,162,161,171,154,130,108,91,61,104,115,144,
  172,185,177,167,147,121,100,101,102,91,108,110,122,153,175,172,180,169,149,
  112,114,87,88,115,122,147,170,175,165,147,126,99,92,93,78,86,105,116,154,177,
  181,177,188,173,145,122,115,67,95,103,116,158,168,165,148,133,106,90,89,97,
  85,115,123,138,169,198,189,200,188,159,115,118,73,71,97,99,140,160,155,147,
  129,115,94,91,101,92,107,128,138,172,202,207,187,189,157,127,107,82,40,77,85,
  101,147,145,157,143,135,119,107,111,119,108,139,140,152,177,191,178,172,160,
  124,90,90,52,45,80,83,131,156,165,163,155,148,125,114,120,108,113,125,126,
  146,170,174,155,157,137,110,93,76,45,73,95,115,161,168,184,172,165,141,116,
  113,107,91,118,118,121,150,164,163,159,156,127,99,101,72,67,110,120,151,182,
  188,184,169,156,121,112,108,97,98,108,110,136,160,168,157,161,144,127,112,
  110,75,107,124,133,175,187,185,173,157,126,100,93,80,70,98,110,118,151,170,
  162,177,177,153,126,128,97,82,120,118,148,176,166,163,148,129,94,78,84,80,88,
  107,105,139,176,193,189,192,175,155,124,113,73,92,116,120,151,157,155,142,
  130,113,91,92,87,73,100,124,140,175,194,192,190,185,157,119,118,94,71,105,
  101,118,146,148,148,145,136,105,86,85,95,100,132,140,160,189,201,178,177,172,
  152,117,112,63,69,90,91,134,152,161,148,140,123,106,104,108,100,128,140,139,
  161,179,183,179,181,153,119,109,79,51,86,87,114,146,148,154,152,145,120,110,
  113,118,115,124,122,144,171,191,182,177,157,137,106,98,59,63,96,102,139,153,
  161,161,166,146,126,116,112,100,116,127,139,169,184,176,167,165,140,112,99,
  81,54,90,98,119,159,166,179,181,170,136,111,104,109,99,125,121,130,161,161,
  159,147,148,136,105,113,81,77,114,127,157,178,185,176,168,139,112,101,100,96,
  99,111,116,142,152,163,156,164,156,132,118,104,82,120,128,136,172,169,170,
  159,138,109,91,94,90,90,103,110,130,156,174,170,174,174,154,120,126,93,94,
  114,115,143,161,163,150,141,122,103,97,99,93,104,116,122,150,174,180,184,177,
  160,141,121,110,72,95,106,122,153,147,150,149,149,121,103,99,104,101,115,116,
  130,162,180,173,163,163,156,120,117,85,69,108,109,123,154,159,165,154,142,
  115,108,106,99,91,105,117,144,162,174,157,168,163,141,112,111,86,95,108,103,
  150,176,179,168,152,122,103,91,91,78,95,106,120,149,174,170,178,181,163,133,
  135,103,77,108,107,137,170,175,157,140,124,94,82,80,84,83,108,117,145,173,
  195,185,194,184,162,125,114,78,81,105,104,142,149,150,135,130,114,89,88,93,
  93,109,133,137,173,197,197,184,186,162,132,110,88,58,86,97,99,136,142,148,
  145,141,117,105,104,113,111,132,138,148,171,187,174,168,170,138,104,101,76,
  61,95,95,118,153,168,166,156,146,119,120,116,109,107,128,121,140,162,176,160,
  165,144,125,102,104,82,86,109,103,150,171,181,166,157,131,117,107,99,91,103,
  112,124,143,164,172,169,169,151,139,129,114,77,104,112,132,163,157,156,155,
  150,110,94,83,98,90,116,122,136,169,181,176,181,183,165,143,118,90,68,104,
  105,123,151,151,152,143,136,105,97,99,110,112,129,133,157,173,181,182,186,
  180,149,109,97,80,72,103,95,123,148,156,155,144,134,120,117,115,122,122,128,
  129,151,166,187,172,168,156,122,105,99,84,81,97,95,141,154,171,157,142,127,
  126,125,117,116,113,117,127,149,161,173,155,158,147,132,112,109,94,81,104,
  117,144,159,164,144,144,127,124,112,114,104,108,114,128,148,170,174,163,173,
  150,136,105,95,86,88,99,103,134,152,153,141,138,124,122,107,108,104,113,125,
  130,153,165,183,170,173,149,129,100,96,84,73,93,95,132,145,156,146,145,133,
  125,117,117,118,123,136,128,148,167,186,167,166,137,117,95,96,85,74,101,103,
  140,159,170,156,155,137,132,124,124,122,123,122,122,145,156,176,153,159,142,
  127,109,106,95,93,108,109,141,154,168,147,140,130,129,122,120,114,116,123,
  127,145,161,179,172,169,157,140,115,114,104,93,109,105,121,139,147,133,136,
  132,130,126,128,129,131,138,136,147,158,184,169,166,152,126,109,100,95,77,91,
  87,107,136,153,153,149,151,145,142,138,138,131,134,126,135,148,172,161,154,
  143,116,114,99,92,85,93,102,121,146,163,157,155,154,144,133,125,127,114,114,
  105,120,138,163,163,156,154,138,130,112,110,93,98,100,104,136,150,147,143,
  139,129,121,121,117,104,115,110,127,147,176,183,174,174,142,131,107,105,94,
  85,78,81,118,138,141,135,140,133,137,132,130,125,134,126,136,151,177,189,176,
  162,133,123,103,96,79,63,63,74,121,148,164,163,167,158,150,141,136,129,131,
  122,126,144,169,180,160,151,133,120,102,91,76,69,82,98,130,160,171,162,164,
  155,144,132,127,114,114,106,110,132,155,172,161,161,147,129,112,100,88,79,91,
  102,128,158,171,164,154,142,130,117,110,108,113,115,119,141,161,192,182,170,
  158,131,115,100,87,80,88,88,108,147,157,148,132,129,124,123,123,123,124,127,
  130,144,169,194,188,167,153,120,115,85,84,75,73,85,100,135,149,153,134,136,
  136,136,133,134,136,137,138,148,173,184,184,152,137,116,106,79,82,75,75,89,
  93,135,150,155,144,149,146,149,142,137,143,140,130,134,150,164,177,141,134,
  119,102,98,86,91,84,96,95,125,150,164,156,151,151,140,140,139,133,133,130,
  118,138,154,168,153,138,132,118,123,99,111,98,101,96,110,146,154,155,141,148,
  142,143,135,134,133,130,120,130,144,163,164,152,153,136,132,120,113,103,86,
  85,95,121,134,141,135,141,150,146,138,142,142,134,128,125,142,157,177,165,
  155,153,133,124,102,100,79,74,74,91,124,146,143,143,161,152,162,158,148,143,
  132,125,137,153,171,173,156,151,121,112,89,85,69,58,65,82,124,149,163,165,
  172,179,176,166,155,138,123,118,119,139,160,171,149,142,125,107,99,70,78,62,
  67,89,124,159,182,182,181,184,170,156,143,124,114,101,98,122,144,167,163,152,
  141,121,109,94,83,87,83,87,107,150,168,177,179,173,164,146,127,112,111,107,
  102,116,142,162,182,168,146,141,114,113,86,89,76,77,94,113,150,165,166,155,
  155,139,131,122,118,112,119,125,139,166,182,180,155,137,119,100,91,74,80,73,
  76,94,127,157,170,165,153,147,142,143,136,132,138,131,139,151,164,168,158,
  134,111,102,89,81,71,84,84,97,117,149,168,178,166,154,160,151,152,148,139,
  136,132,127,142,148,152,133,117,111,97,100,95,94,101,100,111,127,155,173,174,
  161,160,156,157,147,144,131,123,114,107,128,141,149,136,122,119,115,115,102,
  112,106,101,107,120,148,160,166,154,163,163,158,143,128,126,117,106,111,129,
  151,160,139,139,132,126,125,102,104,88,81,86,118,153,169,174,164,170,166,159,
  142,119,110,101,101,120,145,163,171,161,148,135,121,112,88,87,67,65,81,126,
  160,183,180,170,175,161,149,127,118,107,103,105,129,155,174,173,151,143,124,
  114,84,67,68,60,64,101,145,180,198,187,179,173,157,143,126,112,109,98,105,
  131,165,182,175,140,129,109,96,80,59,65,65,87,121,166,195,209,185,171,165,
  145,129,116,105,103,96,104,132,170,181,166,141,117,104,83,80,74,89,85,105,
  134,173,190,187,169,157,156,134,125,108,109,111,117,126,146,173,180,160,132,
  120,101,103,94,89,96,96,105,131,159,181,176,154,145,146,141,133,124,121,122,
  127,135,152,176,178,160,126,113,110,98,100,88,94,88,90,110,145,170,174,160,
  149,152,150,149,135,131,130,131,131,141,163,163,150,130,119,113,110,92,80,75,
  82,80,111,140,171,177,177,162,167,166,159,144,130,126,110,111,126,151,161,
  159,128,114,110,105,88,78,65,69,76,108,138,175,188,185,176,173,170,153,135,
  116,108,105,102,106,138,164,167,148,122,113,101,90,75,64,76,87,105,143,179,
  197,199,181,167,162,145,117,96,91,89,100,115,141,180,186,169,136,114,104,89,
  79,69,72,82,96,132,167,193,194,176,156,148,132,117,97,90,109,120,138,156,185,
  186,175,137,114,93,84,65,64,62,84,98,126,157,191,199,183,159,143,142,130,129,
  124,129,133,142,150,167,180,166,131,102,90,79,76,70,79,86,111,121,160,183,
  202,193,182,149,148,145,136,131,126,127,124,134,142,161,159,145,110,96,84,87,
  85,89,94,113,126,141,172,188,195,175,162,145,149,134,132,118,114,116,123,135,
  147,166,157,143,108,104,99,105,95,99,91,112,114,137,158,182,188,172,155,146,
  151,133,126,111,113,123,131,136,152,165,159,139,111,108,95,93,71,74,71,105,
  119,153,175,198,198,181,159,146,141,121,111,96,109,118,137,145,163,169,161,
  135,97,90,78,76,73,86,85,130,142,172,189,200,184,166,139,123,117,109,112,107,
  123,136,151,160,172,169,155,126,84,75,69,76,75,96,98,140,146,161,169,189,171,
  160,125,119,121,123,128,119,133,154,160,155,162,157,138,106,67,60,71,81,79,
  95,108,143,151,167,173,188,180,163,130,120,129,132,141,136,141,154,153,140,
  136,141,126,106,70,66,74,95,97,112,129,144,152,155,168,173,180,157,140,121,
  132,139,143,132,129,133,143,139,131,141,139,128,96,81,87,100,110,108,117,123,
  147,142,156,172,183,167,151,122,123,135,138,131,127,126,139,155,154,153,149,
  134,102,71,68,79,92,100,107,125,136,154,160,181,183,175,151,127,104,128,134,
  144,140,141,148,162,152,142,128,122,105,67,56,70,93,110,119,129,156,167,168,
  160,169,156,147,125,111,111,140,151,151,145,141,158,158,137,109,107,101,93,
  59,65,89,122,134,133,134,157,151,147,142,147,137,133,125,127,135,155,162,158,
  149,136,142,135,123,97,99,101,108,80,82,97,133,146,138,132,145,142,148,138,
  140,150,149,134,125,130,146,156,150,147,143,146,146,127,110,111,121,120,104,
  83,92,121,143,139,135,138,156,146,144,125,136,131,130,114,128,142,166,167,
  162,161,161,166,143,119,101,94,93,91,72,78,114,148,158,146,136,138,152,132,
  124,116,129,120,131,135,168,182,198,185,172,153,135,116,107,86,67,79,94,108,
  112,127,148,170,164,138,124,128,136,125,110,104,118,137,153,156,175,179,169,
  156,150,132,118,108,108,104,104,101,115,126,133,120,129,132,138,121,108,109,
  126,130,128,120,134,142,153,150,165,179,176,163,153,138,119,104,95,115,114,
  104,84,102,119,134,127,139,138,139,122,115,122,135,133,128,129,128,137,139,
  157,170,176,169,138,118,113,98,104,110,125,136,130,121,127,138,145,130,116,
  107,95,95,94,101,131,145,146,155,146,150,158,145,138,142,143,136,121,100,121,
  139,158,151,140,148,148,122,106,97,100,106,101,96,108,118,133,137,139,146,
  151,147,148,138,131,141,153,150,139,127,126,127,132,130,140,156,157,158,156,
  149,135,113,93,82,80,81,85,93,107,121,144,154,161,171,171,166,166,157,159,
  154,138,120,123,118,113,112,124,133,141,140,147,150,137,131,124,115,107,98,
  100,108,102,109,114,126,123,125,141,162,169,170,175,181,176,151,131,116,106,
  88,82,84,96,93,109,129,172,180,168,149,163,156,131,111,107,114,103,87,93,104,
  119,128,144,161,154,145,150,155,159,144,139,142,129,109,102,113,119,115,118,
  121,119,123,128,142,154,150,146,143,127,128,125,122,128,123,122,121,123,134,
  137,135,144,131,124,128,122,128,126,126,128,127,128,132,132,134,133,138,144,
  137,134,143,151,152,142,147,148,132,123,123,119,113,97,99,103,114,123,138,
  142,141,146,150,140,142,146,129,120,117,123,140,141,147,149,146,142,141,149,
  154,141,141,133,136,135,128,125,117,120,126,126,116,113,111,111,118,130,138,
  144,140,136,141,143,147,148,138,134,131,129,126,135,137,141,132,138,128,126,
  127,125,123,127,131,139,144,138,148,146,137,119,126,121,119,115,122,120,130,
  129,134,136,122,128,125,125,115,118,124,121,121,128,130,132,129,127,132,140,
  138,139,137,144,143,140,133,128,115,110,102,108,113,123,120,128,141,149,143,
  143,142,136,129,121,118,120,127,129,132,140,137,135,127,125,124,124,119,115,
  124,133,131,128,132,131,135,133,128,130,132,126,132,139,140,138,139,138,137,
  131,126,127,117,113,117,126,123,124,135,131,135,134,139,141,136,134,138,132,
  130,132,139,131,132,137,137,133,129,127,127,124,125,123,133,134,123,129,130,
  128,120,120,126,135,129,129,134,139,142,142,149,144,135,126,127,123,122,127,
  126,129,133,141,137,133,133,126,119,126,134,128,128,122,136,136,140,140,140,
  141,132,125,120,126,124,119,121,129,126,135,136,142,142,137,131,134,129,133,
  132,129,128,132,134,133,136,138,138,131,126,128,129,121,123,125,132,130,129,
  132,129,130,130,132,132,134,133,134,126,133,140,137,134,132,128,126,126,129,
  128,127,118,122,131,129,129,132,130,129,124,130,134,134,136,138,137,139,138,
  137,138,131,127,127,129,123,125,128,127,127,122,131,130,125,121,124,130,132,
  132,138,136,136,137,133,138,137,135,129,126,127,128,129,127,126,125,123,113,
  120,123,127,133,132,137,136,137,134,138,140,139,128,129,132,133,127,137,137,
  129,132,127,128,121,119,119,122,127,130,127,126,134,137,142,140,140,138,133,
  125,132,129,128,131,133,135,128,126,124,128,128,128,118,121,123,121,127,128,
  133,132,138,137,134,137,131,132,129,128,132,130,129,127,128,126,127,128,127,
  121,123,129,134,133,133,133,133,137,134,136,133,133,135,129,130,128,130,132,
  133,131,130,129,130,128,132,132,132,130,128,132,134,133,137,140,138,138,138,
  137,131,128,130,129,129,132,130,130,130,130,128,126,128,130,127,128,124,124,
  129,135,137,139,138,138,138,138,141,137,134,131,131,135,132,132,127,122,123,
  127,125,122,122,123,123,126,135,137,142,141,142,138,138,134,136,132,134,134,
  128,130,132,138,128,127,127,124,124,125,122,125,126,129,129,135,140,138,137,
  136,138,138,139,132,135,135,132,130,129,130,130,130,127,128,126,127,121,125,
  127,126,128,134,134,137,138,134,137,138,137,136,134,133,131,129,130,129,134,
  132,132,133,133,128,128,124,124,123,123,125,131,134,136,138,140,143,141,143,
  139,138,129,125,122,123,128,129,130,130,130,128,127,123,127,126,127,127,126,
  131,133,134,137,138,142,140,139,134,127,125,122,121,129,130,132,129,127,124,
  128,128,128,130,127,123,121,125,132,137,144,142,140,139,133,127,124,124,119,
  119,118,120,128,132,130,132,134,131,130,129,128,122,122,123,129,135,137,143,
  139,137,132,130,128,127,123,121,123,128,133,134,138,137,132,127,126,127,124,
  122,118,116,124,130,135,140,140,138,134,133,128,129,128,128,129,130,129,135,
  132,133,128,130,129,127,124,122,116,114,118,122,136,139,143,140,140,138,143,
  145,143,136,131,127,122,123,127,133,134,134,129,127,127,124,122,124,122,127,
  132,135,139,145,147,146,147,146,139,134,123,119,116,120,123,129,132,133,128,
  129,128,128,128,124,121,122,124,129,136,139,145,145,142,140,141,133,127,122,
  116,118,119,124,132,135,138,137,133,129,129,128,125,124,124,124,129,132,138,
  142,143,142,142,138,131,125,121,119,121,124,130,132,135,136,133,132,128,128,
  129,123,121,118,117,124,133,138,146,150,145,141,136,132,128,125,124,123,128,
  129,132,132,134,136,133,134,129,128,122,116,119,122,129,138,144,147,144,139,
  138,135,131,129,127,123,123,123,128,132,137,139,139,137,133,127,128,120,119,
  123,130,132,135,139,139,143,140,140,140,139,131,128,126,130,130,132,132,134,
  140,139,134,128,129,124,123,121,121,125,126,133,132,140,145,144,142,145,138,
  134,129,128,128,127,128,128,134,136,139,137,131,129,126,125,122,125,129,132,
  135,139,145,146,149,145,142,137,129,125,120,122,123,127,131,135,139,139,137,
  134,132,130,126,124,127,124,130,132,135,141,149,146,142,131,128,124,122,119,
  122,127,128,133,134,138,142,142,138,132,124,122,119,116,120,123,130,133,136,
  141,139,138,130,123,123,119,122,127,126,127,129,131,137,138,137,131,125,119,
  113,116,118,122,128,133,130,137,139,139,136,133,125,126,125,123,125,126,126,
  129,132,132,135,135,131,128,124,124,123,128,129,132,130,131,134,132,132,134,
  134,131,128,124,128,128,132,132,134,134,139,138,138,137,137,132,128,130,130,
  130,129,126,124,127,130,130,132,133,135,132,129,130,129,133,134,132,130,131,
  133,133,136,137,137,132,128,125,123,127,124,129,129,133,134,137,137,141,139,
  138,132,130,132,129,129,128,128,133,132,137,139,139,137,131,127,127,127,128,
  128,128,133,134,136,134,133,134,131,128,125,123,128,129,132,133,134,137,139,
  141,138,138,134,127,123,123,124,125,126,126,126,130,132,130,132,129,134,132,
  133,129,131,133,134,133,134,136,137,135,128,126,127,123,123,122,123,125,125,
  123,125,129,132,135,136,133,133,129,129,126,126,129,132,130,126,126,126,126,
  126,126,126,127,125,123,123,124,128,133,131,134,132,134,132,129,130,130,130,
  133,127,128,132,131,133,132,133,133,134,134,132,132,130,129,127,130,129,132,
  133,129,130,131,134,131,135,136,135,132,130,129,132,133,131,134,136,134,133,
  134,131,133,132,132,128,125,123,125,126,129,128,133,132,135,133,134,131,133,
  132,130,131,135,137,137,138,137,137,138,137,131,129,127,125,118,117,123,127,
  132,133,132,133,134,132,132,130,133,131,133,132,135,139,139,139,139,137,134,
  130,124,122,121,124,125,124,123,127,132,133,129,130,130,133,129,130,129,133,
  133,133,127,131,133,136,133,133,133,126,127,128,128,128,128,127,127,123,124,
  124,131,130,130,130,130,131,134,132,130,130,130,130,130,131,133,134,136,134,
  132,133,132,129,127,123,119,122,125,123,128,133,136,138,131,128,128,128,129,
  124,124,127,130,132,134,138,145,144,138,135,128,126,125,121,121,121,127,130,
  132,132,133,128,129,126,126,126,126,129,130,131,135,138,140,143,137,137,132,
  129,127,128,128,128,127,127,130,133,129,128,124,127,124,125,127,133,133,133,
  133,136,138,139,137,131,128,125,123,128,129,136,140,143,139,136,133,131,132,
  130,132,130,129,129,132,135,138,138,139,135,132,129,128,129,128,129,131,135,
  134,138,138,139,138,137,133,131,129,128,130,132,134,133,138,139,140,136,134,
  131,129,128,123,125,127,129,132,131,134,132,133,131,133,134,133,133,131,129,
  130,129,133,132,139,140,140,139,139,138,135,129,125,122,121,119,117,113,118,
  123,125,132,132,133,137,137,133,130,133,133,137,133,129,129,130,130,130,132,
  132,130,128,127,126,125,123,123,123,124,123,124,126,124,124,129,130,132,130,
  131,133,134,137,140,142,142,138,137,131,128,124,122,119,117,117,118,121,129,
  132,134,132,132,138,138,133,132,130,132,133,132,130,133,131,135,133,136,136,
  136,138,137,134,132,129,125,120,119,121,123,128,129,134,131,134,133,137,138,
  137,132,130,128,129,128,130,131,135,132,134,133,136,134,128,127,127,122,124,
  123,127,130,132,133,132,133,132,133,128,130,129,134,131,135,138,142,142,142,
  140,138,132,125,124,122,121,119,118,123,124,125,128,132,130,133,129,129,128,
  132,130,130,130,132,138,138,138,136,136,133,127,127,128,128,129,130,130,129,
  129,128,126,125,123,122,123,127,126,127,128,132,130,130,130,130,130,128,128,
  131,134,136,137,138,138,137,134,133,129,126,128,124,123,125,123,125,126,129,
  132,134,137,138,134,133,129,130,130,130,132,133,132,132,133,133,134,132,130,
  130,130,132,132,132,130,130,132,130,129,129,130,128,128,131,135,137,140,140,
  138,135,131,129,128,127,123,125,127,132,132,134,136,138,141,137,139,138,133,
  127,128,127,130,130,130,130,130,129,127,128,128,129,131,133,133,133,134,137,
  142,139,141,137,137,131,128,128,127,127,130,133,132,130,128,130,130,130,133,
  132,132,128,128,133,134,138,140,139,141,139,137,133,129,128,123,122,122,125,
  123,127,130,132,132,134,132,133,131,130,130,130,130,129,132,132,134,136,137,
  132,133,131,130,129,134,132,130,130,130,132,131,134,132,133,128,130,128,126,
  126,124,129,128,131,134,131,133,134,136,134,133,131,132,134,136,134,134,137,
  135,131,128,128,124,124,123,125,127,129,131,133,134,133,136,136,136,134,133,
  132,135,133,133,133,131,129,128,123,121,121,123,122,127,131,137,138,142,143,
  143,141,140,138,132,130,126,124,125,128,127,129,130,130,130,130,127,127,128,
  123,127,129,132,131,135,133,134,134,133,133,132,130,127,128,127,124,127,126,
  128,128,129,129,126,128,128,130,130,131,134,133,133,136,133,133,133,129,127,
  127,124,124,122,125,127,129,130,132,134,133,129,130,128,127,126,124,128,129,
  130,130,130,132,133,136,133,132,128,128,129,129,134,134,131,132,132,130,128,
  129,124,124,125,123,125,128,128,131,133,132,137,138,137,135,132,129,130,130,
  131,133,132,133,133,132,132,129,128,128,125,122,122,123,127,129,132,133,136,
  137,136,135,132,129,128,128,128,128,128,128,128,130,130,129,128,128,128,128,
  124,122,125,128,131,133,136,136,136,133,133,129,127,127,126,126,128,128,130,
  132,132,134,134,131,130,128,128,123,127,126,129,132,132,134,136,134,129,130,
  130,129,130,132,132,130,132,132,134,134,133,133,129,128,126,124,128,128,129,
  133,130,134,133,134,129,132,128,130,127,128,130,130,130,130,129,134,132,133,
  131,130,129,128,129,133,131,133,133,133,133,133,133,132,130,130,130,129,130,
  133,132,133,131,133,133,133,134,131,133,132,133,132,133,132,132,133,132,133,
  134,132,133,132,130,130,130,127,128,128,129,132,132,133,132,132,129,130,130,
  130,130,130,130,130,130,129,133,133,133,134,132,130,129,128,127,128,128,128,
  132,130,130,131,134,132,130,130,128,128,128,130,130,132,133,138,139,138,135,
  132,128,127,125,123,125,126,127,129,132,133,134,134,134,131,130,130,128,128,
  129,132,132,138,138,138,138,134,129,128,124,127,126,126,126,128,133,134,139,
  138,137,134,128,127,124,127,128,129,132,134,138,141,139,139,137,129,128,126,
  124,127,128,129,132,132,137,137,136,133,127,127,121,122,125,127,131,134,138,
  142,142,142,140,135,128,125,124,123,123,127,127,133,128,134,132,132,129,128,
  124,123,127,128,133,134,136,140,142,142,138,133,128,125,122,123,122,124,128,
  130,132,131,134,132,130,130,127,126,127,130,132,132,137,137,140,138,138,135,
  132,129,123,122,123,128,130,132,133,133,134,133,132,130,130,129,127,124,129,
  129,133,133,136,138,137,137,133,133,131,130,130,130,131,133,133,132,130,130,
  130,130,128,128,126,124,127,129,132,134,136,139,139,139,138,134,133,132,128,
  128,126,128,128,128,129,132,130,130,130,130,130,130,129,128,130,132,132,135,
  136,136,137,136,134,132,134,129,128,126,124,127,126,129,130,133,131,134,132,
  133,129,130,129,128,128,132,130,131,134,134,134,136,135,132,129,127,125,123,
  127,128,130,130,132,133,132,130,129,128,125,122,121,122,128,132,132,135,139,
  140,140,140,137,132,128,123,122,122,123,127,128,130,130,133,132,129,127,125,
  124,124,124,128,133,134,138,142,142,141,140,135,128,125,121,119,123,124,130,
  130,130,133,132,129,130,129,127,123,123,124,127,133,133,142,142,142,140,137,
  133,129,127,123,121,122,125,127,130,132,132,129,128,128,129,124,124,123,123,
  128,129,134,140,142,142,139,139,136,133,131,128,127,128,123,128,127,129,128,
  128,127,126,127,124,124,127,126,124,130,131,137,137,138,136,136,134,133,129,
  126,124,126,124,123,125,128,129,129,129,130,130,130,130,129,128,128,129,130,
  132,133,136,137,137,136,138,134,132,128,128,125,124,124,128,128,128,128,128,
  128,128,128,129,124,125,123,123,125,127,133,134,137,138,138,137,134,131,127,
  125,123,123,123,127,128,128,128,128,128,128,128,124,123,123,122,124,129,134,
  137,142,142,141,143,138,135,131,128,127,126,127,128,132,133,134,133,133,132,
  133,128,127,126,124,127,131,136,139,143,145,145,140,140,138,133,129,129,128,
  127,128,134,133,136,137,132,134,129,129,123,124,123,127,128,135,137,142,144,
  144,143,139,138,133,131,132,130,132,133,131,134,136,134,132,129,128,123,123,
  125,123,128,129,134,134,138,140,140,139,136,133,132,129,129,129,130,132,133,
  131,130,130,128,128,123,124,124,124,125,128,132,130,130,130,131,133,132,134,
  129,132,131,134,132,132,133,134,129,128,126,126,127,122,124,122,125,126,128,
  128,128,128,129,132,130,131,134,134,134,136,136,137,136,134,128,127,126,125,
  122,125,123,128,128,128,127,129,129,130,128,128,129,132,132,133,134,137,139,
  139,134,134,132,130,128,127,123,128,128,130,132,132,132,134,132,132,130,128,
  130,129,128,132,132,134,136,134,136,137,134,134,131,130,130,132,133,132,132,
  133,133,133,131,133,132,133,131,128,128,129,130,129,133,136,137,138,136,134,
  137,136,136,133,131,132,130,132,130,132,133,131,130,130,130,128,128,127,128,
  129,132,133,131,133,134,136,136,134,133,131,135,131,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
  130,129,130,132,130,130,129,128,132,128,128,128,128,128,128,128,128,132,132,
  128,128,128,128,128,127,129,130,130,130,130,132,132,134,131,133,128,130,130,
  130,130,130,130,130,130,130,133,132,133,129,128,128,128,127,127,130,132,133,
  133,131,132,133,134,132,133,132,132,130,130,130,130,130,132,133,132,133,132,
  133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,131,133,
  134,134,134,133,133,131,133,132,132,128,134,132,133,132,132,134,133,131,133,
  132,133,132,133,132,133,132,133,132,133,132,132,134,133,133,134,131,132,133,
  133,132,133,131,130,128,126,126,127,128,126,129,132,134,136,140,140,141,136,
  133,131,129,129,124,127,128,129,134,131,133,137,136,136,135,132,130,129,127,
  127,128,130,133,132,133,131,134,136,133,133,133,127,128,127,129,130,130,132,
  132,129,129,128,128,128,128,128,128,129,132,133,133,134,131,127,127,121,121,
  118,121,123,130,132,135,133,134,136,136,133,129,128,127,127,126,124,129,129,
  130,132,130,130,130,130,130,130,130,130,131,133,133,132,133,129,130,127,124,
  127,127,129,129,132,133,134,137,136,135,132,127,128,127,123,127,129,132,129,
  133,132,135,133,133,131,132,129,130,130,130,128,132,130,130,130,130,130,130,
  130,130,130,130,131,134,132,132,129,130,130,130,130,129,127,128,128,129,132,
  132,137,137,136,133,132,130,128,128,128,128,128,128,127,130,130,132,133,128,
  130,130,130,130,130,127,129,130,130,130,130,130,130,130,130,130,130,130,130,
  133,131,134,133,132,130,128,128,128,128,128,130,130,130,130,130,133,132,130,
  128,126,128,128,129,130,130,130,130,132,133,132,132,129,128,128,128,129,129,
  130,130,132,133,132,132,128,130,129,128,128,132,132,132,133,131,133,133,134,
  134,134,132,133,131,130,130,130,130,130,129,129,132,130,130,130,130,130,130,
  130,130,130,130,130,130,133,132,133,132,133,132,129,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,131,134,132,133,132,133,132,
  132,130,130,130,130,130,130,130,130,130,130,130,132,132,133,131,130,133,132,
  132,133,131,132,132,132,132,132,132,133,132,133,132,133,132,132,133,132,135,
  132,132,130,130,130,130,129,130,132,132,133,131,133,132,134,131,130,130,130,
  130,130,130,130,131,134,132,133,132,133,129,130,127,128,128,128,128,132,132,
  131,134,132,133,132,132,130,130,130,130,130,130,132,134,134,134,132,133,129,
  130,128,128,128,129,132,133,131,133,133,133,133,133,129,132,129,129,132,133,
  131,133,133,133,133,132,133,129,130,130,129,128,129,130,132,133,131,135,132,
  130,130,130,130,130,130,130,130,130,130,133,132,132,128,130,130,130,128,127,
  127,128,128,129,130,133,132,133,132,133,132,133,128,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,129,129,132,129,134,132,133,132,133,132,130,
  130,130,129,128,129,132,130,129,134,132,130,130,130,130,130,130,130,132,132,
  132,134,132,132,133,131,130,130,130,130,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,132,135,132,133,132,132,130,130,130,130,130,
  130,130,130,130,130,132,133,132,133,132,133,132,133,132,133,131,134,133,133,
  134,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,
  132,133,132,133,131,135,133,133,133,132,133,132,133,128,132,133,132,133,131,
  134,133,132,133,132,130,130,130,130,128,128,129,132,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,131,134,132,133,128,130,130,129,127,128,128,
  129,130,130,132,133,132,132,130,129,128,128,128,128,128,129,130,130,130,132,
  130,129,130,130,130,129,129,130,130,129,133,133,133,133,133,131,129,130,127,
  128,127,127,130,132,132,133,133,133,133,131,133,132,133,132,133,132,132,133,
  133,133,133,134,131,133,132,133,131,129,130,132,133,131,134,133,133,133,132,
  133,132,133,132,133,132,133,132,132,134,136,133,132,130,132,133,132,133,132,
  133,132,133,131,134,134,132,132,132,132,132,132,129,130,133,131,133,134,134,
  136,135,132,132,130,130,130,128,128,128,129,130,133,131,134,133,132,132,130,
  130,130,130,130,130,129,134,132,133,132,132,129,130,129,127,128,128,128,129,
  132,129,133,132,136,131,132,129,130,130,130,127,130,130,130,130,133,132,133,
  131,129,129,128,128,128,128,128,128,128,128,132,130,130,127,128,128,128,128,
  128,128,128,128,128,128,132,130,130,130,129,128,128,128,128,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,132,134,132,137,134,132,
  130,129,130,130,129,128,129,132,130,130,130,133,131,130,130,130,130,130,130,
  130,130,129,134,131,133,134,134,131,129,130,130,130,128,128,129,132,130,130,
  129,134,131,130,130,129,132,130,130,130,129,133,132,134,134,132,133,129,128,
  128,126,126,126,126,129,128,129,128,128,128,128,129,128,129,130,128,130,130,
  130,132,134,132,133,132,129,129,127,128,126,126,126,128,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,132,134,132,133,132,132,134,131,129,130,
  129,128,128,128,128,132,132,133,132,133,131,134,131,133,132,133,132,132,134,
  133,133,133,133,132,134,132,130,130,128,130,130,130,130,133,132,133,132,133,
  131,133,135,132,133,132,132,135,133,133,133,133,134,132,133,132,133,132,130,
  130,131,133,132,133,132,134,134,134,132,133,132,133,132,133,132,133,132,133,
  132,133,131,135,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,
  133,132,133,132,133,132,132,133,134,133,133,131,133,132,133,132,133,132,133,
  131,129,130,132,133,132,133,131,133,133,133,133,134,132,133,129,130,130,130,
  132,130,130,130,130,130,130,129,128,128,129,130,130,133,131,134,133,133,134,
  134,132,133,129,130,130,130,130,130,130,131,134,132,132,130,130,130,130,129,
  128,128,132,130,132,131,134,131,133,133,132,133,128,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,129,130,130,130,132,133,134,133,
  133,131,129,130,130,130,127,128,128,129,132,129,134,132,133,131,130,130,130,
  130,130,130,130,130,130,133,132,133,132,133,129,129,128,126,128,128,130,130,
  130,130,130,132,133,131,128,129,128,129,128,129,130,130,133,129,128,128,128,
  128,128,128,128,128,128,127,129,129,129,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,132,130,130,128,128,128,128,128,128,126,126,
  126,127,129,128,132,130,130,130,130,130,130,128,128,128,128,126,128,128,128,
  132,130,130,129,128,128,128,128,127,128,130,130,130,130,130,130,130,132,133,
  133,131,133,132,134,132,130,130,130,130,130,128,130,130,132,131,134,132,132,
  135,133,133,133,133,133,132,133,132,133,132,133,132,133,132,132,137,133,133,
  133,133,134,131,133,132,133,129,130,130,131,134,132,133,131,135,133,133,133,
  134,131,133,132,133,132,132,133,129,133,132,133,132,133,132,133,132,133,132,
  133,132,129,130,132,133,132,133,132,133,131,135,133,133,133,133,131,133,132,
  133,132,133,132,133,131,129,130,130,131,134,132,133,131,134,133,136,136,133,
  133,132,133,129,130,130,130,130,130,130,130,130,130,130,130,130,132,130,132,
  132,132,133,132,132,134,132,133,132,133,132,133,129,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,132,133,133,132,130,
  130,130,130,130,130,130,130,132,133,131,130,128,129,128,128,127,127,129,129,
  129,130,132,132,133,131,130,129,128,128,128,128,128,128,130,132,130,129,128,
  128,128,128,126,127,128,129,130,130,130,133,131,134,131,130,130,129,129,129,
  129,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,132,133,132,133,
  132,133,132,133,132,132,134,133,133,134,131,133,132,133,132,133,132,133,132,
  133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,
  132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,
  133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,
  132,133,132,133,132,133,132,133,132,132,133,132,134,132,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
  133,132,133,132,133,128,129,130,130,130,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,133,132,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,130,130,134,
};

static const char dsdgpain[] = {
  3,0,17,43,206,8,0,0,132,132,133,132,133,132,133,132,133,132,133,132,133,132,
  133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,
  132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,133,132,
  133,132,133,132,132,134,131,133,132,133,132,133,131,134,133,131,132,129,129,
  131,134,137,138,138,131,130,129,133,133,136,134,132,130,128,122,122,123,134,
  142,151,144,131,127,124,132,135,138,132,132,128,129,117,111,112,132,148,157,
  146,132,122,125,129,130,127,127,128,132,125,110,100,108,131,148,156,145,129,
  125,127,128,128,126,127,130,132,118,98,96,107,134,154,154,143,130,128,129,
  132,128,126,127,133,126,111,92,93,113,139,156,154,137,128,129,135,135,132,
  132,138,139,121,99,81,97,129,154,157,140,128,128,132,135,133,134,143,147,132,
  102,79,89,127,156,160,142,124,123,130,131,132,135,149,153,134,100,74,92,140,
  173,172,145,119,110,122,128,130,137,151,146,122,89,82,117,163,192,181,146,
  118,110,114,119,124,134,135,129,108,90,102,142,181,196,178,148,120,117,117,
  119,121,118,110,101,102,112,139,162,180,182,169,151,137,130,129,126,117,92,
  82,93,117,145,155,150,142,144,158,162,165,153,140,126,109,96,92,104,130,140,
  137,116,107,120,158,190,190,171,148,132,123,113,109,106,113,110,93,81,96,135,
  186,215,204,175,140,126,127,129,120,100,79,71,80,98,132,162,189,192,177,152,
  143,137,136,124,102,82,85,102,132,151,155,139,122,120,138,155,162,144,127,
  130,142,155,151,138,125,117,94,77,67,82,111,150,177,193,199,202,190,166,133,
  98,77,59,59,57,77,112,159,198,223,217,201,176,150,120,84,53,39,53,89,129,169,
  193,196,192,177,164,136,113,87,71,72,82,111,142,178,191,198,182,159,121,84,
  57,55,80,117,158,188,197,184,169,151,133,117,102,89,83,78,86,115,151,186,214,
  208,169,124,96,83,100,121,136,139,134,134,125,126,124,127,133,137,138,141,
  145,151,159,153,144,135,125,97,79,72,88,122,156,187,189,187,167,147,123,103,
  94,93,104,112,121,137,146,165,166,157,141,115,106,106,117,131,146,159,156,
  152,129,112,97,92,104,122,135,142,150,158,169,167,153,129,102,79,80,95,112,
  133,149,154,162,160,157,144,128,119,107,104,107,121,129,129,139,139,135,130,
  133,134,152,161,168,161,136,115,86,78,72,94,119,147,173,182,193,172,158,138,
  120,99,79,78,93,125,152,171,164,146,139,127,114,96,101,115,150,172,188,171,
  139,129,112,86,61,67,86,123,165,194,191,165,161,140,117,102,106,106,123,134,
  133,129,108,114,112,110,121,143,166,182,198,190,167,125,100,64,36,42,74,118,
  166,211,231,225,188,152,108,69,47,52,74,102,149,188,202,185,175,138,103,94,
  97,107,122,155,169,156,130,121,92,80,94,113,137,169,210,211,185,128,100,57,
  37,51,77,117,161,214,229,208,163,127,82,46,55,68,107,145,203,210,191,152,114,
  80,61,87,98,130,151,182,173,173,138,121,94,76,97,107,138,159,178,164,140,103,
  86,80,94,132,154,197,195,192,151,112,62,47,47,67,126,172,230,240,213,164,110,
  57,39,46,64,120,168,221,225,205,157,112,67,49,51,70,122,174,232,231,201,156,
  92,57,38,52,75,138,189,225,221,182,136,95,72,66,81,101,147,178,193,178,144,
  106,81,84,95,133,161,203,198,175,128,81,51,51,78,111,164,213,234,225,174,108,
  49,34,31,76,120,180,214,233,203,165,105,65,47,56,87,132,189,220,215,174,123,
  76,47,53,80,130,185,227,223,182,130,71,49,46,68,107,162,205,235,219,170,108,
  61,30,49,83,127,187,230,229,192,131,82,39,43,79,123,179,222,233,190,130,70,
  35,43,75,133,178,220,231,207,146,87,41,25,56,99,164,210,244,216,171,97,56,36,
  43,95,140,199,223,232,180,124,63,25,35,62,122,174,221,229,212,151,96,44,25,
  38,87,147,205,241,226,186,111,61,31,36,72,129,190,225,236,200,139,81,42,28,
  59,102,167,217,233,214,155,97,42,43,48,104,157,214,224,216,153,96,52,30,54,
  95,159,210,243,213,166,96,48,28,45,85,145,201,225,219,173,112,63,37,34,84,
  136,192,230,230,183,123,68,27,35,64,125,183,229,232,205,138,89,38,35,55,107,
  169,219,238,208,152,87,41,24,56,98,166,218,243,210,167,94,52,30,45,92,152,
  204,234,221,168,115,53,39,41,91,149,212,228,229,163,107,61,29,44,83,148,203,
  236,220,186,117,70,33,45,69,141,193,231,213,185,112,65,36,40,86,148,211,231,
  222,165,108,49,34,31,101,141,205,233,216,157,112,65,33,65,88,150,194,220,197,
  142,82,53,29,78,110,182,209,237,192,146,71,31,25,56,112,168,223,235,206,148,
  88,27,36,62,127,164,225,219,194,131,93,27,36,66,122,174,226,234,201,145,82,
  37,19,65,110,171,218,222,194,156,93,52,30,65,109,174,211,233,191,155,85,38,
  26,56,104,174,215,226,206,153,95,43,32,43,113,170,221,226,211,147,99,43,42,
  49,114,166,222,222,223,145,111,53,39,54,104,163,216,226,206,160,100,69,37,65,
  104,172,210,239,201,165,98,66,25,55,95,169,206,252,204,170,108,54,35,55,97,
  162,212,244,211,160,104,43,44,44,106,151,218,233,233,168,117,54,34,36,85,125,
  200,225,239,184,131,70,36,37,64,121,183,223,224,198,137,83,40,32,46,108,171,
  223,241,216,140,101,34,26,37,103,145,216,226,214,159,120,46,34,36,77,137,209,
  227,218,175,105,64,31,47,68,137,196,218,220,185,116,81,40,42,57,130,177,220,
  220,197,125,97,42,42,49,121,155,222,213,189,147,103,64,57,63,114,158,199,205,
  190,151,110,72,50,69,95,162,187,224,180,174,113,94,53,68,85,142,166,198,187,
  165,131,113,69,75,87,123,158,192,177,181,129,112,76,70,77,117,145,184,180,
  185,144,131,92,76,82,102,142,163,198,172,169,123,99,69,89,92,147,153,199,170,
  185,128,121,74,78,75,125,143,189,181,186,150,130,82,83,73,113,132,168,184,
  179,163,126,96,88,63,109,121,160,178,187,158,150,108,79,70,96,111,147,174,
  181,178,148,126,89,88,77,115,130,182,164,197,144,139,94,90,65,118,128,176,
  172,199,147,152,98,93,66,108,113,157,174,182,168,157,106,101,72,85,117,143,
  176,174,170,147,118,93,81,82,115,135,164,175,182,149,138,82,81,68,94,127,172,
  176,187,153,143,82,97,66,98,122,166,151,202,160,144,105,101,53,102,99,142,
  161,191,168,160,129,96,76,103,87,140,148,169,171,161,130,115,89,93,91,129,
  142,168,173,166,144,110,97,85,104,118,142,158,168,157,153,114,116,90,115,110,
  147,146,160,157,154,109,126,93,107,119,146,131,176,151,155,121,135,87,121,
  108,141,122,172,130,163,125,129,104,135,106,142,124,160,122,158,118,128,116,
  125,105,133,120,140,135,160,124,141,122,126,121,131,108,127,126,134,130,141,
  129,134,128,135,114,140,125,130,127,135,124,138,133,135,127,139,119,124,122,
  127,127,148,145,148,138,132,116,122,110,108,128,147,142,166,145,139,127,113,
  103,105,125,135,154,167,152,144,123,108,104,98,113,129,154,163,173,150,142,
  106,98,86,102,114,155,162,186,155,157,109,122,77,100,102,135,152,187,155,173,
  122,122,80,111,85,131,135,170,164,192,134,132,95,97,72,117,114,156,165,186,
  148,160,105,100,87,103,99,150,151,175,159,169,113,117,83,94,96,132,140,167,
  158,159,136,131,105,102,100,122,121,150,145,151,149,135,119,122,115,118,121,
  135,137,150,153,141,138,127,117,113,111,124,134,141,154,155,149,138,125,117,
  113,103,122,120,146,154,160,150,146,122,122,97,110,105,135,134,165,154,167,
  131,131,95,105,90,125,121,170,147,175,138,147,115,115,80,101,99,146,144,186,
  153,182,124,127,77,106,75,128,123,185,158,200,145,142,84,100,65,118,114,168,
  163,206,155,159,82,89,49,106,106,177,171,200,152,165,104,102,73,92,87,145,
  136,169,164,164,142,136,103,88,75,102,124,170,179,181,165,134,102,74,59,54,
  103,148,191,196,203,147,135,98,88,67,105,108,173,167,190,143,148,94,112,78,
  105,88,149,142,193,167,177,120,124,68,89,59,103,107,167,171,203,159,147,88,
  101,85,108,106,163,152,193,168,129,100,98,87,110,116,129,150,150,174,161,166,
  125,120,88,101,71,122,120,183,179,205,136,141,86,106,70,123,112,178,160,191,
  139,152,92,123,83,112,100,143,134,185,159,176,140,132,84,84,63,96,132,181,
  212,192,170,121,99,76,74,77,126,132,184,163,187,141,157,101,117,65,117,97,
  178,154,210,146,176,93,104,50,98,78,164,157,222,187,194,128,127,67,86,68,103,
  130,169,175,199,166,135,113,77,88,103,131,152,188,165,177,131,125,77,102,70,
  127,124,174,138,196,154,166,99,125,67,115,93,144,132,179,143,175,120,128,92,
  113,96,117,125,165,164,172,159,135,112,75,83,88,123,140,193,170,191,132,145,
  97,109,77,124,90,162,118,181,138,187,123,166,80,119,66,136,116,176,133,190,
  134,163,100,118,76,100,107,148,152,188,155,148,133,104,115,100,114,112,157,
  139,179,126,159,102,140,78,125,85,150,127,198,157,202,125,141,59,99,36,109,
  110,196,177,222,163,152,98,104,60,82,78,132,148,171,189,178,149,118,104,75,
  85,75,127,141,187,170,182,131,129,63,91,73,146,135,202,156,187,102,132,64,
  108,51,121,117,197,155,206,142,177,115,108,51,89,83,145,148,180,185,168,148,
  114,115,78,107,107,162,161,201,150,176,100,114,49,91,56,152,135,222,183,215,
  135,137,60,97,36,95,85,175,166,222,164,164,101,108,61,89,83,127,161,200,186,
  178,125,97,79,63,93,100,131,154,215,183,208,132,118,55,83,42,120,103,183,171,
  241,148,161,60,90,48,133,90,192,131,218,150,170,87,105,30,105,61,140,136,209,
  196,199,142,120,68,66,63,115,148,182,180,180,166,128,108,67,94,72,117,150,
  176,172,198,132,138,75,97,45,103,98,180,173,232,169,211,107,133,61,123,75,
  160,102,186,149,
};

static const char dogovrly[] = {
  64,1,200,0,0,0,0,0,8,5,0,0,51,5,0,0,94,5,0,0,137,5,0,0,180,5,0,0,223,5,0,0,
  10,6,0,0,53,6,0,0,96,6,0,0,139,6,0,0,182,6,0,0,225,6,0,0,12,7,0,0,55,7,0,0,
  98,7,0,0,141,7,0,0,184,7,0,0,227,7,0,0,14,8,0,0,57,8,0,0,100,8,0,0,143,8,0,0,
  186,8,0,0,229,8,0,0,16,9,0,0,59,9,0,0,102,9,0,0,145,9,0,0,188,9,0,0,231,9,0,
  0,18,10,0,0,61,10,0,0,104,10,0,0,147,10,0,0,190,10,0,0,233,10,0,0,20,11,0,0,
  63,11,0,0,106,11,0,0,149,11,0,0,192,11,0,0,235,11,0,0,22,12,0,0,65,12,0,0,
  108,12,0,0,151,12,0,0,194,12,0,0,237,12,0,0,24,13,0,0,67,13,0,0,110,13,0,0,
  153,13,0,0,196,13,0,0,239,13,0,0,26,14,0,0,69,14,0,0,112,14,0,0,155,14,0,0,
  198,14,0,0,241,14,0,0,28,15,0,0,71,15,0,0,114,15,0,0,157,15,0,0,200,15,0,0,
  243,15,0,0,30,16,0,0,73,16,0,0,116,16,0,0,159,16,0,0,202,16,0,0,245,16,0,0,
  32,17,0,0,75,17,0,0,118,17,0,0,161,17,0,0,204,17,0,0,205,17,0,0,206,17,0,0,
  207,17,0,0,208,17,0,0,209,17,0,0,210,17,0,0,211,17,0,0,212,17,0,0,213,17,0,0,
  214,17,0,0,215,17,0,0,216,17,0,0,217,17,0,0,218,17,0,0,219,17,0,0,220,17,0,0,
  221,17,0,0,222,17,0,0,223,17,0,0,224,17,0,0,225,17,0,0,226,17,0,0,227,17,0,0,
  228,17,0,0,229,17,0,0,230,17,0,0,231,17,0,0,232,17,0,0,233,17,0,0,234,17,0,0,
  235,17,0,0,236,17,0,0,237,17,0,0,238,17,0,0,239,17,0,0,240,17,0,0,241,17,0,0,
  242,17,0,0,243,17,0,0,244,17,0,0,245,17,0,0,246,17,0,0,247,17,0,0,248,17,0,0,
  249,17,0,0,250,17,0,0,251,17,0,0,252,17,0,0,253,17,0,0,254,17,0,0,255,17,0,0,
  0,18,0,0,1,18,0,0,2,18,0,0,3,18,0,0,4,18,0,0,5,18,0,0,6,18,0,0,7,18,0,0,8,18,
  0,0,9,18,0,0,10,18,0,0,11,18,0,0,12,18,0,0,13,18,0,0,14,18,0,0,15,18,0,0,16,
  18,0,0,17,18,0,0,18,18,0,0,19,18,0,0,20,18,0,0,21,18,0,0,22,18,0,0,23,18,0,0,
  24,18,0,0,25,18,0,0,26,18,0,0,27,18,0,0,28,18,0,0,29,18,0,0,30,18,0,0,31,18,
  0,0,32,18,0,0,33,18,0,0,34,18,0,0,35,18,0,0,36,18,0,0,37,18,0,0,38,18,0,0,39,
  18,0,0,40,18,0,0,41,18,0,0,42,18,0,0,43,18,0,0,44,18,0,0,45,18,0,0,46,18,0,0,
  47,18,0,0,48,18,0,0,49,18,0,0,50,18,0,0,51,18,0,0,52,18,0,0,53,18,0,0,54,18,
  0,0,55,18,0,0,56,18,0,0,57,18,0,0,58,18,0,0,59,18,0,0,60,18,0,0,61,18,0,0,62,
  18,0,0,63,18,0,0,64,18,0,0,120,18,0,0,176,18,0,0,232,18,0,0,32,19,0,0,88,19,
  0,0,144,19,0,0,200,19,0,0,0,20,0,0,56,20,0,0,112,20,0,0,168,20,0,0,224,20,0,
  0,24,21,0,0,80,21,0,0,136,21,0,0,192,21,0,0,248,21,0,0,48,22,0,0,104,22,0,0,
  160,22,0,0,216,22,0,0,16,23,0,0,72,23,0,0,128,23,0,0,184,23,0,0,240,23,0,0,
  40,24,0,0,96,24,0,0,152,24,0,0,208,24,0,0,8,25,0,0,64,25,0,0,120,25,0,0,176,
  25,0,0,232,25,0,0,32,26,0,0,88,26,0,0,144,26,0,0,200,26,0,0,0,27,0,0,56,27,0,
  0,112,27,0,0,168,27,0,0,224,27,0,0,24,28,0,0,80,28,0,0,136,28,0,0,192,28,0,0,
  248,28,0,0,48,29,0,0,104,29,0,0,160,29,0,0,216,29,0,0,16,30,0,0,72,30,0,0,
  128,30,0,0,184,30,0,0,240,30,0,0,40,31,0,0,96,31,0,0,152,31,0,0,208,31,0,0,8,
  32,0,0,64,32,0,0,120,32,0,0,176,32,0,0,232,32,0,0,32,33,0,0,88,33,0,0,144,33,
  0,0,200,33,0,0,0,34,0,0,56,34,0,0,112,34,0,0,168,34,0,0,224,34,0,0,24,35,0,0,
  80,35,0,0,136,35,0,0,192,35,0,0,248,35,0,0,48,36,0,0,63,36,0,0,78,36,0,0,93,
  36,0,0,108,36,0,0,123,36,0,0,138,36,0,0,153,36,0,0,168,36,0,0,183,36,0,0,198,
  36,0,0,213,36,0,0,228,36,0,0,243,36,0,0,2,37,0,0,17,37,0,0,32,37,0,0,47,37,0,
  0,62,37,0,0,77,37,0,0,92,37,0,0,107,37,0,0,122,37,0,0,137,37,0,0,152,37,0,0,
  167,37,0,0,182,37,0,0,197,37,0,0,212,37,0,0,227,37,0,0,242,37,0,0,1,38,0,0,
  16,38,0,0,31,38,0,0,46,38,0,0,61,38,0,0,76,38,0,0,91,38,0,0,106,38,0,0,121,
  38,0,0,136,38,0,0,151,38,0,0,166,38,0,0,181,38,0,0,196,38,0,0,211,38,0,0,162,
  38,177,177,179,177,179,182,181,182,183,183,183,183,183,184,183,183,185,185,
  185,186,183,178,179,183,186,185,187,2,189,189,2,47,47,47,47,47,47,47,0,0,255,
  162,38,45,45,47,47,2,45,181,182,183,183,183,184,183,183,183,183,183,185,185,
  186,188,183,183,185,188,0,2,2,2,2,186,0,47,46,47,2,47,47,0,0,255,162,38,184,
  184,177,181,181,177,181,181,183,183,183,183,183,183,183,183,184,182,183,186,
  187,188,187,45,2,2,0,2,47,188,47,47,46,47,47,2,47,47,0,0,255,162,38,183,183,
  187,47,183,183,181,181,183,183,183,183,183,184,47,187,182,178,180,185,185,
  187,189,2,2,188,188,45,47,188,0,47,189,47,2,47,47,47,2,2,255,162,38,177,177,
  45,181,177,177,181,181,183,183,183,183,184,182,188,187,182,181,183,185,188,
  188,188,45,188,45,189,47,45,47,47,46,46,47,2,47,47,45,187,187,255,162,38,179,
  179,183,177,183,184,181,181,183,183,183,183,182,181,187,189,187,185,185,188,
  188,45,45,45,189,188,188,47,47,47,47,189,47,2,47,47,188,47,45,45,255,162,38,
  183,183,184,179,177,177,177,181,183,183,183,184,181,184,188,45,47,47,47,188,
  188,186,47,47,187,186,188,47,47,0,46,189,47,2,47,47,0,0,0,0,255,162,38,179,
  179,181,181,181,179,179,181,183,183,183,184,181,186,182,186,45,47,187,187,
  184,45,47,189,187,188,45,47,47,47,46,46,2,47,47,2,0,0,0,0,255,162,38,181,181,
  183,181,181,181,181,183,183,183,183,184,184,181,182,184,45,188,186,184,187,
  187,47,188,45,188,47,47,0,47,189,47,2,47,47,0,0,2,47,47,255,162,38,179,179,
  177,179,181,179,181,181,182,182,182,184,182,181,181,184,188,187,184,182,188,
  188,184,187,185,185,47,47,0,46,46,47,47,47,47,47,47,187,185,185,255,162,38,
  181,181,187,187,187,188,188,186,47,183,183,184,180,180,181,184,187,182,187,
  181,45,188,45,185,185,185,47,47,0,189,47,47,47,47,47,188,188,187,186,186,255,
  162,38,187,187,179,182,185,188,184,186,187,45,45,186,178,180,180,184,184,180,
  184,180,45,188,185,185,185,185,47,0,0,46,47,47,47,47,189,188,187,187,187,187,
  255,162,38,178,178,182,185,189,184,182,187,47,47,186,45,178,181,181,181,180,
  180,177,180,45,188,185,185,188,185,47,0,47,46,47,47,47,47,189,188,188,188,
  186,186,255,162,38,178,178,179,185,47,182,182,186,188,47,187,45,184,180,181,
  184,182,177,184,180,45,188,184,185,45,185,47,47,45,47,47,47,47,188,47,188,45,
  189,189,189,255,162,38,181,181,181,47,189,182,181,183,189,47,188,47,186,181,
  181,181,187,178,181,180,45,188,189,185,47,187,47,46,189,47,47,47,188,47,47,
  184,47,184,187,187,255,162,38,177,177,184,47,186,181,182,184,189,47,45,45,
  182,178,178,178,45,178,184,180,188,187,187,187,45,189,47,189,189,47,47,188,
  186,184,184,187,184,187,45,45,255,162,38,177,177,183,188,183,181,182,184,187,
  189,47,189,180,176,177,178,45,182,184,181,187,47,46,47,188,47,45,188,45,47,
  47,186,186,186,186,184,184,188,188,188,255,162,38,183,183,182,45,186,186,182,
  184,182,45,47,189,180,176,177,178,45,186,181,187,184,45,47,189,189,188,189,
  189,47,47,188,186,186,186,186,186,187,187,187,187,255,162,38,183,183,183,47,
  187,188,182,182,183,188,45,47,180,176,178,180,188,187,184,45,181,188,47,45,
  45,46,188,45,47,47,45,188,186,184,186,187,187,187,187,187,255,162,38,185,185,
  184,47,45,188,186,187,183,47,47,188,180,178,178,181,45,187,186,184,186,182,
  188,47,47,45,189,47,47,187,45,45,188,186,184,186,187,187,188,188,255,162,38,
  185,185,189,187,47,47,182,182,184,189,47,187,182,180,178,186,47,45,187,188,
  188,186,186,47,47,45,47,47,47,47,47,47,47,45,186,184,184,188,45,45,255,162,
  38,186,186,189,188,186,184,182,183,189,189,47,188,178,182,184,47,2,2,2,47,45,
  188,188,47,47,47,2,47,47,47,47,47,47,47,47,188,188,184,188,188,255,162,38,
  188,188,189,188,182,184,186,186,186,187,189,47,180,178,178,47,47,47,47,2,47,
  47,45,47,46,47,0,47,47,47,47,47,47,47,47,47,47,188,47,47,255,162,38,188,188,
  189,188,47,2,47,181,183,186,2,2,181,178,180,45,45,188,45,47,47,47,2,2,47,47,
  2,45,187,184,182,180,178,180,47,47,47,188,47,47,255,162,38,47,47,188,47,2,47,
  47,47,186,2,0,2,182,180,180,188,188,185,185,188,45,45,2,47,47,0,47,185,182,
  179,179,178,178,180,180,180,178,184,45,45,255,162,38,189,189,188,47,47,47,47,
  47,47,2,2,2,186,181,181,187,186,181,182,183,187,189,185,47,47,2,183,185,180,
  179,179,180,180,180,182,182,179,178,45,45,255,162,38,189,189,47,47,47,47,47,
  2,47,47,47,47,45,184,182,184,188,182,177,179,182,184,186,47,0,47,189,188,179,
  180,180,183,187,182,185,185,180,179,186,186,255,162,38,189,189,47,47,47,47,
  46,45,46,45,47,47,46,187,188,187,188,183,177,180,183,185,185,2,2,185,186,189,
  188,185,184,187,180,184,188,189,186,181,186,186,255,162,38,45,45,189,47,47,
  47,46,47,2,2,47,47,45,46,184,188,45,185,183,183,184,184,186,183,179,183,185,
  187,184,187,184,180,182,187,189,45,45,189,185,185,255,162,38,187,187,45,47,
  47,189,45,47,47,46,45,189,185,184,180,180,180,176,185,185,185,185,183,179,
  177,183,185,183,182,187,185,187,189,186,45,45,47,47,45,45,255,162,38,186,186,
  188,45,187,45,47,47,47,47,188,188,183,184,180,180,180,176,179,182,187,186,
  185,183,183,184,187,185,180,185,184,180,181,187,45,189,189,47,47,47,255,162,
  38,186,186,186,189,189,47,47,189,187,188,184,184,182,180,180,180,176,176,181,
  184,187,184,189,185,185,186,189,189,183,183,184,187,189,189,47,189,47,47,189,
  189,255,162,38,186,186,186,189,45,47,188,187,188,187,186,186,181,180,178,176,
  176,177,182,181,184,184,184,185,186,186,187,189,180,186,186,181,185,47,189,
  47,47,187,187,187,255,162,38,185,185,189,188,189,47,47,189,47,47,189,187,186,
  182,181,178,176,177,185,185,188,184,186,186,186,187,188,189,182,189,47,47,
  189,47,47,187,188,187,186,186,255,162,38,189,189,189,189,47,187,45,47,188,
  188,47,187,189,187,186,182,176,180,185,185,187,184,187,187,186,188,45,47,47,
  47,47,47,2,47,189,187,189,187,187,187,255,162,38,45,45,189,189,188,186,47,47,
  189,186,188,187,185,189,188,186,177,181,188,189,186,187,45,45,188,45,45,47,
  47,47,47,47,47,2,189,187,188,186,187,187,255,162,38,45,45,45,187,185,185,47,
  47,189,187,184,189,187,185,189,188,177,181,188,45,186,184,184,188,47,47,47,
  47,47,47,47,2,2,47,47,189,189,187,186,186,255,162,38,45,45,45,189,188,186,47,
  47,47,188,185,186,189,185,185,180,177,182,188,45,184,181,181,187,47,47,47,47,
  47,47,47,2,47,47,47,189,188,188,186,186,255,162,38,45,45,189,188,189,187,46,
  47,47,188,187,185,189,187,183,177,177,183,188,187,184,181,184,187,47,47,47,
  47,47,47,47,47,2,47,189,2,189,188,187,187,255,162,38,187,187,187,188,189,189,
  189,46,187,184,189,188,47,184,180,177,178,184,47,186,184,187,188,188,47,47,
  46,47,47,47,47,47,47,47,47,2,47,189,186,186,255,162,38,184,184,186,188,189,
  45,188,47,187,183,187,47,47,181,177,177,179,185,187,188,186,184,186,186,188,
  47,47,47,47,47,47,47,47,47,46,45,189,187,186,186,255,162,38,184,184,186,188,
  189,47,47,189,188,185,189,47,183,179,177,177,180,185,187,47,187,182,186,182,
  188,189,184,47,47,47,47,47,47,47,47,47,47,189,186,186,255,162,38,184,184,186,
  184,184,47,47,47,189,188,47,47,180,177,177,177,180,185,187,47,188,187,182,
  182,188,45,189,47,47,45,47,46,47,47,47,2,189,189,186,186,255,162,38,185,185,
  184,181,186,185,184,184,188,47,47,47,0,44,44,178,180,185,187,45,45,184,184,
  186,45,46,47,47,47,46,47,47,47,47,47,47,47,188,187,187,255,162,38,183,183,
  185,185,184,181,179,178,178,178,181,185,0,40,184,40,181,186,187,188,45,178,
  184,188,47,47,189,45,47,47,47,47,47,47,2,47,47,189,186,186,255,162,38,178,
  178,180,184,186,181,177,177,178,178,179,44,184,177,181,40,40,186,187,188,45,
  187,187,47,47,47,45,47,47,47,46,47,2,2,2,47,189,188,187,187,255,162,38,179,
  179,180,182,184,185,178,177,178,179,44,185,177,177,181,185,40,186,189,188,47,
  186,188,47,45,47,47,46,46,45,47,47,47,47,2,47,189,188,189,189,255,162,38,182,
  182,183,184,186,183,182,178,178,44,185,0,177,177,181,185,40,187,188,188,45,
  47,47,47,47,47,47,46,47,47,47,47,47,47,47,47,189,189,187,187,255,162,38,184,
  184,184,185,184,184,184,182,180,44,184,177,177,177,184,181,184,184,184,184,
  184,181,181,177,177,184,47,47,47,177,177,177,2,2,0,2,47,189,186,186,255,162,
  38,177,177,178,180,182,184,181,181,181,184,44,184,177,177,177,184,177,177,
  177,177,181,177,177,177,177,177,184,47,177,177,177,185,181,47,2,47,189,187,
  186,186,255,162,38,179,179,179,183,183,184,184,184,184,184,44,184,177,177,
  177,177,177,177,177,177,184,177,177,177,177,177,177,177,177,177,185,181,181,
  0,0,189,2,187,186,186,255,162,38,180,180,180,183,183,186,179,177,184,184,184,
  184,177,181,177,181,177,177,177,185,177,177,177,177,177,182,177,177,177,185,
  181,181,39,47,47,47,47,187,0,0,255,162,38,182,182,183,184,186,183,178,178,
  179,44,184,184,181,181,181,177,177,181,185,185,39,185,181,177,177,184,177,
  177,185,185,45,39,39,47,47,47,47,47,47,47,255,162,38,184,184,184,186,186,186,
  186,183,183,184,44,184,181,181,181,181,181,40,40,40,40,39,185,181,177,177,
  184,184,185,189,189,189,45,47,45,47,47,47,47,47,255,162,38,186,186,186,189,
  47,47,2,189,182,184,44,184,181,181,181,181,44,41,41,40,40,40,39,181,177,181,
  184,184,184,186,188,188,189,45,188,45,47,47,181,181,255,162,38,2,2,2,2,2,47,
  47,181,182,44,185,181,181,184,181,181,44,44,41,41,40,40,39,185,177,177,177,
  177,177,181,185,185,188,45,188,189,47,181,181,181,255,162,38,47,47,2,2,2,2,
  181,182,184,184,44,184,184,184,181,181,44,44,41,41,40,39,185,177,177,177,177,
  177,177,177,181,185,185,189,184,177,177,181,39,39,255,162,38,47,47,47,47,2,2,
  184,184,47,2,47,47,189,184,184,184,44,44,41,41,40,185,177,177,177,177,177,
  177,177,177,177,40,181,177,177,177,181,39,39,39,255,162,38,47,47,47,47,2,2,2,
  2,47,47,2,2,45,45,46,189,189,44,41,41,39,181,177,177,177,177,177,177,177,177,
  177,177,177,177,181,181,39,44,44,44,255,162,38,47,47,2,2,2,2,2,2,2,47,47,2,
  47,45,45,45,47,47,44,41,181,177,177,177,177,177,177,180,180,189,189,189,45,
  47,47,47,189,187,186,186,255,162,38,2,2,2,2,2,2,2,47,47,2,47,47,47,47,47,47,
  47,46,47,185,177,177,177,177,180,180,2,236,140,137,138,142,236,237,238,238,
  79,14,142,142,255,162,38,47,47,2,2,2,2,2,2,2,47,47,47,47,47,47,45,47,47,47,
  185,177,177,180,181,182,183,236,140,138,139,141,143,236,237,238,238,238,238,
  79,79,255,162,38,47,47,47,2,2,2,2,2,2,47,47,47,47,45,45,45,46,47,47,185,177,
  177,180,182,183,14,140,138,139,141,142,143,236,237,238,238,238,79,79,79,255,
  162,38,2,2,47,2,2,2,2,2,2,2,47,47,47,188,189,45,47,47,47,185,181,177,180,185,
  37,140,139,139,140,142,143,236,237,15,15,15,15,15,79,79,255,162,38,2,2,2,2,2,
  2,47,2,2,2,2,47,47,189,45,47,2,47,47,47,182,177,180,40,40,140,140,140,142,14,
  14,237,15,14,15,15,15,15,15,15,255,162,38,189,189,45,47,47,47,47,0,47,47,47,
  47,47,47,47,2,0,45,188,188,182,182,39,137,134,132,132,135,136,138,142,14,14,
  15,15,15,79,15,15,15,255,162,38,45,45,47,47,47,47,47,47,47,47,47,47,47,47,47,
  2,0,45,188,187,182,183,137,121,121,123,124,125,124,123,138,138,15,79,79,15,
  15,79,79,79,255,162,38,45,45,47,47,0,47,47,47,47,47,47,47,47,47,0,2,0,45,188,
  39,183,122,120,119,121,121,123,124,125,127,125,124,139,14,79,79,79,79,79,79,
  255,162,38,45,45,47,0,47,47,47,47,47,47,47,47,47,47,2,2,45,45,187,39,121,119,
  118,120,121,123,123,124,124,125,127,126,125,141,14,5,5,79,79,79,255,162,38,
  45,45,47,47,47,47,47,47,47,0,47,47,47,47,187,45,45,188,187,121,118,119,120,
  121,123,123,124,125,125,125,126,127,127,125,142,14,79,5,5,5,255,162,38,45,45,
  45,47,47,47,47,0,0,0,0,47,187,181,187,45,45,189,121,118,119,120,121,122,123,
  124,125,125,125,126,126,127,127,127,5,141,142,15,79,79,255,162,38,47,47,2,
  187,188,188,188,186,184,182,184,187,181,183,179,177,185,188,116,119,120,121,
  122,123,124,125,125,126,126,126,127,127,126,126,127,5,14,14,15,15,255,162,38,
  187,187,187,185,189,0,0,2,0,47,187,187,184,179,181,180,185,121,118,120,121,
  122,123,123,124,125,125,125,126,127,127,127,126,126,126,6,6,5,79,79,255,162,
  38,187,187,179,179,185,181,181,182,182,184,45,181,181,183,179,179,180,118,
  120,121,122,123,124,124,125,125,125,127,127,127,127,127,126,126,126,126,6,6,
  6,6,255,162,38,181,181,188,187,47,47,2,187,183,185,179,179,179,177,177,185,
  118,119,120,122,123,124,124,124,125,125,124,126,127,127,126,127,126,127,126,
  126,126,126,126,126,255,162,38,188,188,183,179,179,179,181,187,184,184,177,
  185,184,185,45,120,119,119,121,122,124,124,124,124,124,124,124,123,126,127,
  127,127,127,126,126,127,126,125,125,125,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,149,51,14,14,9,9,9,9,9,
  125,5,5,11,8,8,8,2,185,181,181,182,179,179,181,183,185,189,188,185,185,185,
  182,35,73,72,69,67,163,60,210,209,208,160,227,227,226,226,226,226,226,227,
  160,226,226,226,255,149,51,9,9,9,9,9,9,9,110,126,5,8,1,8,8,2,180,181,182,181,
  179,179,181,183,186,45,187,184,184,187,41,15,73,69,67,164,163,162,211,210,
  209,209,210,210,210,210,209,209,160,160,160,227,226,226,255,149,51,9,9,125,
  125,125,125,125,79,5,5,8,8,8,2,185,180,179,182,179,178,179,181,183,186,45,
  188,185,183,187,43,76,165,164,164,164,163,163,61,58,57,58,56,54,53,210,210,
  209,160,160,160,160,160,160,255,149,51,125,125,125,125,125,126,11,1,10,5,8,8,
  8,2,181,181,181,182,179,178,180,182,184,189,45,189,186,184,185,185,166,165,
  165,165,68,66,64,131,131,60,130,129,128,53,53,210,210,209,160,227,160,160,
  160,255,149,51,125,125,125,125,126,110,10,5,5,8,1,8,2,2,181,181,182,181,180,
  178,180,183,185,45,189,189,186,183,182,183,165,165,166,166,71,69,65,144,131,
  144,132,130,128,54,53,53,210,209,160,227,160,160,160,255,149,51,110,110,126,
  126,110,79,141,6,5,8,8,8,47,186,182,182,182,182,179,179,182,184,45,187,188,
  187,187,185,187,185,166,167,36,36,73,72,69,145,144,67,144,131,129,128,54,55,
  54,210,160,160,160,160,160,255,149,51,110,110,10,10,110,126,142,10,8,5,8,8,
  181,182,183,184,184,184,183,182,183,45,187,185,186,187,186,187,185,185,183,
  182,182,186,36,36,72,69,66,67,144,132,130,129,129,129,128,52,160,160,227,160,
  160,255,149,51,10,10,110,10,126,79,15,126,8,8,8,181,181,181,184,184,184,185,
  185,185,45,187,185,182,183,187,185,186,183,185,185,186,183,182,34,36,73,71,
  71,69,64,144,131,131,132,144,129,54,160,160,227,128,128,255,149,51,110,110,
  10,5,110,5,79,15,8,8,179,179,180,182,182,183,184,185,187,185,188,185,183,185,
  185,185,185,185,186,184,185,186,186,183,31,36,36,74,15,71,67,67,144,132,134,
  144,129,55,161,160,211,66,66,255,149,51,10,10,110,5,126,5,5,6,5,79,178,179,
  179,181,180,182,183,185,187,186,185,184,184,185,186,186,185,185,186,185,184,
  186,185,184,184,186,188,77,45,70,69,69,65,145,136,144,128,55,161,160,56,60,
  60,255,149,51,111,111,110,110,126,8,1,6,5,79,15,179,181,179,180,180,183,185,
  187,187,184,184,184,185,185,187,187,185,185,186,185,186,185,184,186,188,188,
  189,188,70,69,70,69,146,147,145,58,57,161,161,57,59,59,255,149,51,10,10,111,
  5,5,5,1,5,5,79,15,178,178,178,179,180,183,185,187,186,184,183,183,185,185,
  186,187,187,186,185,185,186,185,186,189,47,47,47,45,72,71,71,70,148,148,69,
  64,62,162,161,59,25,25,255,149,51,5,5,111,126,9,7,5,5,110,110,15,178,177,178,
  178,180,183,186,188,185,183,183,183,184,185,186,187,188,187,185,185,186,186,
  189,189,47,47,47,47,74,72,73,72,73,73,71,66,65,162,161,61,68,68,255,149,51,
  10,10,5,1,8,8,8,8,110,110,15,14,177,178,179,181,183,188,187,183,182,182,182,
  183,185,185,186,187,188,186,186,186,189,45,45,188,188,47,187,41,43,77,77,75,
  73,71,68,65,164,62,61,26,26,255,149,51,5,5,1,10,8,8,8,8,78,15,238,15,178,179,
  180,181,185,188,186,182,180,180,181,183,185,185,185,186,188,188,187,189,45,
  45,45,188,187,47,186,188,45,45,45,77,75,71,68,65,164,164,61,26,26,255,149,51,
  10,10,5,10,107,8,8,8,15,15,15,14,178,179,180,181,185,188,186,182,180,180,181,
  183,185,185,185,186,188,188,187,45,46,45,188,187,187,187,186,188,45,45,45,45,
  77,72,70,66,165,165,62,26,26,255,149,51,5,5,79,107,159,157,108,108,15,79,15,
  74,180,180,180,182,187,187,186,186,182,181,181,183,185,185,185,185,188,188,
  189,45,45,47,47,47,47,45,187,188,45,45,45,45,45,77,76,68,165,165,64,43,43,
  255,149,51,1,1,3,94,3,10,5,5,78,238,142,179,180,180,182,183,186,186,186,185,
  185,185,184,185,186,187,186,185,188,189,45,45,189,47,189,189,45,189,188,187,
  185,45,189,189,189,42,188,186,234,232,184,30,30,255,149,51,107,107,91,106,78,
  6,110,110,110,15,47,178,180,182,183,185,186,184,181,181,183,185,185,187,187,
  189,187,187,188,189,188,189,189,189,45,47,47,47,45,46,47,45,45,45,189,188,
  188,186,233,232,184,184,184,255,149,51,91,91,78,0,7,5,78,5,78,238,180,179,
  180,182,184,187,184,183,182,182,181,182,182,184,185,187,189,189,189,189,188,
  189,189,45,189,189,45,189,187,186,186,45,45,189,189,188,186,186,222,221,184,
  185,185,255,149,51,138,138,0,7,110,78,78,15,79,182,181,179,180,182,185,187,
  186,185,185,184,183,182,182,182,182,185,187,186,186,189,186,44,189,45,45,47,
  189,187,187,187,189,45,45,45,45,188,186,189,182,180,184,185,185,255,149,51,0,
  0,0,0,5,15,9,79,180,183,180,180,181,182,185,187,187,186,185,185,185,183,183,
  183,184,184,184,186,188,186,189,186,47,189,189,189,189,189,187,47,187,187,45,
  45,47,188,186,189,105,110,184,185,185,255,149,51,5,5,101,101,108,110,9,15,
  179,183,180,179,180,180,184,184,184,183,183,183,182,182,183,184,185,186,186,
  185,186,188,44,47,47,189,189,47,189,189,45,45,189,45,45,189,189,189,189,188,
  188,46,47,183,183,255,149,51,101,101,91,82,98,106,143,180,178,181,181,179,
  180,182,184,187,188,47,185,184,183,182,182,182,185,185,186,187,185,184,185,
  184,184,187,187,47,47,45,45,45,45,47,45,45,189,189,189,188,189,184,183,183,
  183,255,149,51,82,82,134,102,153,153,141,180,178,180,180,180,181,184,185,184,
  184,47,47,185,185,183,183,183,184,184,185,185,186,182,184,185,186,184,186,
  187,45,45,45,47,47,47,45,45,189,188,188,189,187,184,183,183,183,255,149,51,9,
  9,78,2,2,78,108,37,178,179,182,180,181,183,182,180,187,45,47,185,185,184,182,
  182,183,184,185,185,185,182,185,184,185,183,185,186,187,45,47,47,47,47,47,
  189,189,186,186,186,184,184,182,182,182,255,149,51,2,2,0,0,0,2,143,2,178,178,
  181,179,181,180,179,179,189,188,45,184,185,184,181,181,182,184,185,184,182,
  184,182,184,184,185,183,185,186,187,47,47,188,188,188,189,187,185,185,184,
  182,180,181,182,182,255,149,51,15,15,2,2,108,108,79,2,187,178,181,179,180,
  179,179,178,45,184,47,183,183,183,182,182,183,183,184,182,183,183,183,182,
  183,183,184,184,184,184,187,188,186,186,186,188,185,185,184,182,180,179,181,
  182,182,255,149,51,110,110,238,238,79,238,2,2,2,178,180,179,179,178,178,178,
  182,187,182,182,180,181,182,182,183,184,184,183,184,184,183,183,182,183,183,
  183,181,182,184,184,188,185,188,185,185,184,182,180,178,178,180,181,181,255,
  149,51,106,106,79,0,2,2,2,2,2,187,179,179,178,178,179,179,179,181,182,182,
  181,182,181,182,184,186,186,186,185,184,184,183,182,182,183,183,182,181,182,
  183,185,185,185,184,184,182,182,180,178,175,178,182,182,255,149,51,106,106,
  79,79,2,2,2,2,2,2,179,180,179,178,179,179,182,183,184,183,181,183,181,185,
  186,186,186,186,186,185,185,185,185,185,185,185,183,182,181,182,184,185,185,
  182,182,182,180,177,175,174,178,183,183,255,149,51,78,78,79,79,2,2,2,2,2,2,
  178,180,179,179,179,181,184,45,186,183,181,183,183,186,186,187,187,187,185,
  185,184,185,184,185,184,184,184,183,181,181,183,184,185,182,182,180,179,175,
  174,174,178,183,183,255,149,51,0,0,79,79,2,2,2,2,2,2,178,179,180,179,180,181,
  189,45,182,179,182,185,186,186,185,183,182,182,182,182,182,182,182,182,182,
  181,181,180,180,180,182,184,185,182,180,179,178,175,174,174,181,188,188,255,
  149,51,108,108,79,2,2,2,2,2,2,2,180,178,180,180,181,183,46,45,177,185,186,
  185,186,186,186,185,184,184,183,184,184,187,187,186,184,184,186,181,182,179,
  181,185,185,182,180,179,177,176,174,182,187,187,187,255,149,51,79,79,2,2,2,2,
  2,2,2,2,181,178,179,180,181,184,188,46,182,45,46,186,186,187,187,185,182,186,
  184,183,187,187,188,189,186,186,189,181,182,179,180,185,186,182,180,179,177,
  174,182,186,187,187,187,255,149,51,2,2,2,2,2,2,2,2,2,2,181,180,178,179,181,
  183,185,188,45,46,189,185,185,187,186,180,184,186,187,188,189,186,184,183,
  184,179,189,185,182,179,182,186,186,182,180,180,180,182,185,187,186,187,187,
  255,149,51,2,2,2,2,2,2,2,2,2,2,187,180,180,178,180,181,183,187,46,189,187,
  185,185,186,185,180,185,185,187,189,189,186,184,182,182,184,187,189,187,182,
  184,187,186,184,182,180,183,185,186,185,185,186,186,255,149,51,2,2,2,2,2,2,2,
  2,2,2,2,181,181,181,182,183,186,189,46,47,185,185,186,189,181,185,185,186,
  186,189,189,187,184,182,181,183,183,186,47,183,185,187,186,184,184,183,185,
  184,185,184,185,187,187,255,149,51,2,2,2,2,2,2,2,2,2,2,2,188,182,182,183,185,
  185,189,46,2,189,189,186,184,186,187,189,186,186,189,189,187,186,182,183,183,
  183,182,47,184,187,187,188,182,184,183,185,185,185,185,187,187,187,255,149,
  51,2,2,2,47,2,2,2,2,2,2,2,2,188,183,184,184,182,182,47,0,181,185,189,184,188,
  189,187,187,186,189,187,186,186,184,183,181,183,181,177,177,177,179,180,181,
  182,183,185,184,185,185,187,188,188,255,149,51,47,47,2,2,47,47,2,2,2,2,0,2,0,
  47,47,47,47,47,0,2,185,181,184,183,187,187,187,187,186,187,186,185,186,184,0,
  0,40,177,177,177,179,179,180,181,181,186,184,184,186,185,187,188,188,255,149,
  51,47,47,47,47,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,189,190,187,189,188,189,
  187,189,184,182,183,185,0,0,185,40,176,176,177,179,179,180,183,186,184,184,
  186,185,187,188,188,255,149,51,2,2,2,47,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,
  190,190,190,189,188,186,186,189,188,184,183,183,184,44,44,184,40,176,177,177,
  177,177,180,183,185,185,185,186,185,185,187,187,255,149,51,47,47,47,2,2,2,2,
  2,2,2,2,2,2,2,188,0,0,0,0,0,0,190,189,190,190,187,186,186,189,188,185,184,
  184,184,44,40,184,185,40,177,177,177,177,181,183,184,184,185,186,185,182,186,
  186,255,149,51,2,2,2,47,47,0,0,2,0,0,0,2,2,2,2,0,0,0,0,0,0,190,190,190,190,
  187,187,186,186,187,0,0,0,44,44,184,177,185,40,177,177,177,179,181,184,184,
  185,185,186,185,177,185,185,255,149,51,2,2,2,47,47,2,0,0,0,0,2,185,2,2,188,0,
  0,0,0,0,0,190,189,190,47,190,47,186,188,185,176,183,45,44,40,177,177,184,40,
  177,177,177,180,180,183,182,184,185,185,185,177,185,185,255,149,51,2,2,2,0,
  47,47,2,0,0,0,2,2,2,180,187,0,0,0,0,0,190,47,190,190,47,190,190,186,176,181,
  187,188,44,40,0,177,177,184,39,178,177,179,179,180,180,182,184,185,185,182,
  177,186,186,255,149,51,2,2,2,2,2,2,2,0,0,0,185,185,182,2,0,0,0,190,190,187,
  190,190,190,190,190,190,186,176,181,183,179,177,44,184,181,177,177,184,177,
  39,40,178,179,179,180,182,183,184,185,177,177,186,186,255,149,51,2,2,2,2,0,2,
  2,2,2,0,185,45,0,185,0,0,190,187,184,185,189,190,190,190,190,47,181,183,184,
  179,180,44,44,184,177,177,177,181,177,184,39,40,40,40,180,182,184,184,185,
  177,181,186,186,255,149,51,2,2,2,2,2,2,2,2,2,2,2,0,2,0,181,190,188,184,179,
  179,185,181,188,190,45,184,45,181,181,180,40,44,40,184,177,177,177,177,184,
  177,184,185,39,40,40,40,40,185,182,177,181,185,185,255,149,51,2,2,2,2,2,2,0,
  2,0,2,2,2,45,45,182,181,186,181,188,187,47,47,0,187,183,185,179,179,179,180,
  184,180,40,185,184,181,177,177,177,177,181,184,184,184,185,39,40,40,177,177,
  181,185,185,255,149,51,0,0,2,2,2,2,2,2,2,2,2,187,45,178,45,184,181,188,183,
  179,179,179,181,187,184,184,177,185,184,185,180,184,40,37,184,181,177,177,
  177,177,177,177,181,181,184,184,185,40,177,177,181,185,185,255,149,51,0,0,0,
  2,2,47,0,2,187,187,182,185,187,45,184,186,188,179,181,183,183,189,47,179,181,
  189,183,177,177,179,180,40,181,184,182,180,177,177,177,177,177,177,177,177,
  177,181,184,183,177,177,181,186,186,255,149,51,2,2,2,2,0,2,0,2,47,45,185,45,
  185,186,180,45,186,183,183,185,183,184,183,181,181,189,180,179,184,189,183,
  187,47,184,182,180,180,177,177,177,177,177,177,177,181,181,177,177,177,179,
  186,186,186,255,149,51,2,2,187,187,187,183,183,45,45,188,179,185,183,45,186,
  186,183,181,183,177,176,176,177,181,183,185,179,189,179,181,177,45,181,181,
  184,182,182,180,177,177,177,177,177,181,184,177,214,177,177,214,186,186,186,
  255,149,51,47,47,0,2,47,187,184,2,185,2,179,181,184,186,45,186,181,179,177,
  184,183,181,179,179,177,177,45,181,179,179,179,183,177,185,185,185,184,182,
  182,177,177,177,181,184,231,177,231,231,231,231,186,185,185,255,149,51,185,
  185,47,47,47,183,2,188,184,184,182,183,183,177,181,185,181,181,184,187,184,
  188,184,185,187,184,45,181,179,181,183,184,179,181,181,181,182,40,184,184,
  184,184,184,184,177,177,177,177,181,214,186,185,185,255,149,51,183,183,2,2,
  188,185,2,182,47,189,185,183,181,185,187,45,45,183,177,179,179,176,176,179,
  177,179,181,45,177,179,179,181,181,183,182,182,181,181,40,39,185,185,184,177,
  177,177,177,183,183,186,186,184,184,255,149,51,186,186,0,182,187,185,187,185,
  47,182,177,181,181,179,187,45,45,179,179,179,179,179,179,179,176,176,177,47,
  176,181,181,183,181,183,183,182,181,181,40,40,39,185,181,177,177,177,214,231,
  231,214,40,184,184,255,149,51,47,47,47,180,47,183,47,181,47,182,183,183,181,
  181,181,187,183,179,183,184,183,184,183,181,185,181,47,188,179,179,179,177,
  179,183,182,184,184,183,184,40,40,39,184,177,177,179,231,179,184,231,40,184,
  184,255,149,51,187,187,185,180,187,187,188,181,45,179,183,181,181,183,183,
  184,181,181,181,177,179,177,177,181,177,188,185,176,179,179,181,181,180,180,
  182,184,186,183,186,40,40,40,185,181,214,179,231,179,184,231,40,185,185,255,
  149,51,47,47,183,183,185,188,178,188,188,183,184,183,183,184,181,179,179,177,
  177,176,177,176,177,176,188,0,181,183,179,177,181,179,180,180,184,184,186,
  184,185,40,40,40,39,184,231,231,231,231,231,231,40,183,183,255,149,51,181,
  181,185,188,185,184,183,45,188,181,183,181,181,179,179,184,184,188,45,188,45,
  47,45,47,0,0,177,181,181,181,179,177,180,182,184,184,185,186,186,40,40,40,39,
  184,177,180,180,181,184,214,40,182,182,255,149,51,185,185,184,189,0,187,184,
  45,182,181,181,183,184,184,184,183,181,179,177,177,179,179,179,181,183,185,
  177,181,181,179,179,179,182,185,187,47,183,185,186,40,40,40,39,184,177,180,
  180,181,37,40,186,180,180,255,149,51,187,187,184,189,2,184,183,189,178,184,
  185,180,183,183,181,181,185,185,177,181,181,181,186,179,181,187,177,177,179,
  179,179,181,184,45,185,47,184,184,185,40,40,40,39,185,177,180,180,181,39,40,
  185,177,177,255,149,51,183,183,184,45,47,181,183,186,183,183,184,183,181,181,
  185,189,188,187,45,185,183,183,179,179,183,185,177,181,183,179,179,187,45,
  187,189,189,180,181,181,40,40,40,39,185,177,213,231,213,39,231,185,179,179,
  255,149,51,186,186,185,181,45,181,186,47,183,184,184,186,181,189,188,177,177,
  176,176,176,179,183,181,183,185,188,177,179,179,179,185,45,187,185,187,185,
  183,181,182,40,40,40,39,185,177,231,182,231,40,231,185,179,179,255,149,51,
  186,186,47,188,2,183,47,178,179,179,181,183,177,177,177,188,187,188,181,45,
  179,183,181,181,181,182,179,177,179,179,47,187,184,185,184,185,179,179,180,
  40,40,40,39,185,184,231,183,213,231,215,39,177,177,255,149,51,189,189,185,
  184,186,45,45,184,184,183,181,185,188,188,183,181,188,178,188,188,183,184,
  183,183,184,183,45,177,179,47,2,179,179,45,179,185,178,179,181,40,40,39,185,
  184,181,181,184,37,41,44,39,176,176,255,149,51,2,2,187,187,188,47,187,185,
  181,183,184,189,185,181,188,184,184,183,45,188,181,183,181,181,177,181,179,
  181,189,2,47,177,181,187,183,189,180,181,181,40,39,185,185,177,177,218,231,
  231,231,214,40,176,176,255,149,51,45,45,179,186,188,2,187,183,184,186,185,
  189,189,184,186,183,187,184,45,182,181,181,183,184,184,184,179,177,176,177,
  47,178,184,189,182,188,181,184,181,185,184,181,177,177,177,231,175,180,37,
  231,44,177,177,255,149,51,45,45,185,186,187,2,185,181,183,184,186,47,189,181,
  181,183,184,183,189,178,184,185,180,183,177,177,179,185,45,2,47,177,184,183,
  180,185,183,181,181,185,181,177,177,177,177,214,231,231,231,214,41,177,177,
  255,149,51,45,45,181,188,189,2,184,181,183,183,186,47,181,183,181,183,181,
  183,186,183,183,184,183,181,179,179,179,177,177,179,47,183,183,186,183,189,
  186,181,178,181,177,177,177,177,177,177,177,177,177,182,40,176,176,255,149,
  51,2,2,183,189,188,187,188,184,183,184,188,185,181,183,184,186,181,186,47,
  183,184,184,186,181,181,179,183,189,45,47,45,184,183,186,181,189,186,183,180,
  181,180,177,177,177,177,231,231,231,231,231,37,176,176,255,149,51,189,189,
  181,183,189,187,188,183,184,183,186,185,184,186,183,181,183,47,178,179,179,
  181,183,177,179,181,181,181,181,176,2,184,184,183,180,187,184,181,178,181,
  182,177,177,177,177,231,177,231,177,177,37,177,177,255,149,51,185,185,189,
  188,187,187,189,183,184,184,185,185,184,181,183,184,45,45,184,184,183,181,
  183,188,177,177,179,183,184,181,47,184,181,188,180,179,187,179,177,179,180,
  180,177,184,180,180,177,177,177,177,181,177,177,255,149,51,188,188,189,47,
  182,187,45,179,184,186,189,189,187,184,184,183,185,188,185,180,181,179,177,
  177,179,181,183,184,185,47,0,185,181,45,183,181,184,183,178,179,179,182,177,
  181,184,231,177,177,177,177,177,176,176,255,149,51,184,184,186,47,185,189,47,
  181,186,184,45,185,183,183,185,185,183,187,189,47,179,177,179,179,179,177,
  177,177,176,176,47,187,180,189,179,181,183,183,179,179,179,39,181,39,181,231,
  231,231,231,231,177,176,176,255,149,51,187,187,188,2,185,184,45,188,185,184,
  186,187,186,185,183,184,186,183,182,183,181,183,181,183,181,183,185,189,47,2,
  187,45,184,183,183,181,183,189,178,177,182,39,181,39,181,231,184,184,181,177,
  177,176,176,255,149,51,185,185,188,47,185,188,189,187,189,184,45,188,183,184,
  186,181,181,184,47,187,183,181,181,183,184,181,181,179,179,181,2,47,181,185,
  183,181,181,183,179,182,182,39,181,39,181,181,181,181,181,181,177,176,176,
  255,149,51,189,189,185,47,185,187,186,45,181,188,177,183,183,181,181,183,183,
  189,179,179,179,185,179,177,179,179,179,177,177,179,184,47,184,181,188,183,
  185,183,181,182,182,39,183,39,181,161,231,231,231,218,184,176,176,255,149,51,
  47,47,47,2,184,185,188,47,179,185,180,183,183,188,189,181,177,183,181,181,
  184,177,179,179,179,185,181,187,45,181,179,45,187,181,47,180,181,181,177,182,
  182,39,183,43,181,177,176,175,177,231,178,177,177,255,190,10,205,205,43,181,
  176,176,161,231,177,178,177,177,255,190,10,205,205,43,181,177,176,175,177,
  231,176,176,176,255,190,10,205,205,0,181,161,231,231,231,218,177,176,176,255,
  190,10,205,205,183,181,176,175,176,176,176,177,178,178,255,190,10,205,205,
  180,178,214,231,231,231,231,176,178,178,255,190,10,205,205,176,177,161,177,
  231,176,176,177,178,178,255,190,10,205,205,177,177,214,231,231,231,231,177,
  178,178,255,190,10,205,205,176,177,176,176,176,176,176,176,178,178,255,190,
  10,205,205,177,177,231,231,231,231,231,176,178,178,255,190,10,205,205,176,
  177,231,176,231,176,176,176,176,176,255,190,10,205,205,176,177,214,231,176,
  231,231,176,176,176,255,190,10,205,205,176,176,176,176,176,176,176,176,176,
  176,255,190,10,205,205,176,176,231,231,231,231,231,176,176,176,255,190,10,
  205,205,176,176,161,176,161,176,161,176,176,176,255,190,10,205,205,176,176,
  176,176,176,176,176,176,176,176,255,190,10,205,205,176,176,176,176,176,176,
  231,231,176,176,255,190,10,205,205,176,176,176,176,176,176,176,176,176,176,
  255,190,10,205,205,178,176,176,181,176,176,176,176,176,176,255,190,10,205,
  205,178,178,179,176,176,176,176,176,177,177,255,190,10,205,205,185,218,231,
  231,231,231,231,218,177,177,255,190,10,205,205,185,231,178,176,176,176,176,
  231,177,177,255,190,10,205,205,186,231,177,231,231,231,177,231,180,180,255,
  190,10,205,205,183,231,176,231,176,231,176,231,177,177,255,190,10,205,205,
  182,231,177,231,177,231,177,231,177,177,255,190,10,205,205,178,231,182,178,
  178,178,178,231,177,177,255,190,10,205,205,182,223,231,231,231,231,231,223,
  178,178,255,190,10,205,205,187,189,188,182,182,180,180,180,184,184,255,190,
  10,205,205,188,189,189,231,185,182,231,182,185,185,255,190,10,205,205,2,188,
  231,231,231,231,231,185,187,187,255,190,10,205,205,188,2,2,190,189,189,231,
  186,188,188,255,190,10,205,205,2,2,212,231,212,190,189,189,189,189,255,190,
  10,205,205,189,2,231,233,231,2,190,2,2,2,255,190,10,205,205,0,2,231,2,231,0,
  0,0,2,2,255,190,10,205,205,189,2,231,231,231,231,231,2,2,2,255,190,10,205,
  205,2,2,2,0,190,2,190,2,2,2,255,190,10,205,205,0,2,214,231,214,2,0,2,2,2,255,
  190,10,205,205,2,2,231,233,231,0,0,0,2,2,255,190,10,205,205,2,2,231,2,231,2,
  2,0,0,0,255,190,10,205,205,2,2,231,231,231,231,231,2,2,2,255,190,10,205,205,
  0,0,0,2,0,0,0,0,2,2,255,190,10,205,205,0,0,219,0,2,2,219,0,2,2,255,190,10,
  205,205,0,0,231,2,2,0,231,0,0,0,255,190,10,205,205,0,0,231,0,231,0,231,2,2,2,
  255,190,10,205,205,0,0,231,231,2,231,231,2,2,2,255,190,10,2,2,0,2,47,47,47,
  47,2,2,2,2,255,190,10,2,2,2,47,2,47,47,47,47,2,2,2,255,
};

#endif /* DOGS */

#ifdef BETA
static const char pls1a0[] = { // 2022/07/05 Freedoom lump
  15,0,15,0,8,0,12,0,68,0,0,0,78,0,0,0,92,0,0,0,108,0,0,0,126,0,0,0,144,0,0,0,
  164,0,0,0,184,0,0,0,204,0,0,0,224,0,0,0,244,0,0,0,6,1,0,0,24,1,0,0,40,1,0,0,
  54,1,0,0,5,5,164,164,165,164,165,164,164,255,3,9,164,164,164,162,164,164,162,
  164,164,164,164,255,2,11,164,164,164,163,162,161,160,161,162,162,163,165,165,
  255,1,13,165,165,162,162,161,161,160,227,161,160,161,162,163,165,165,255,1,
  13,165,165,164,161,161,161,227,225,226,161,227,162,164,166,166,255,0,15,164,
  164,163,162,162,161,226,225,4,4,226,161,161,162,163,73,73,255,0,15,164,164,
  162,161,160,161,225,4,4,4,225,161,161,163,163,164,164,255,0,15,164,164,163,
  161,162,161,225,4,4,4,225,227,160,163,163,165,165,255,0,15,164,164,163,162,
  161,161,227,225,225,4,226,161,162,162,162,164,164,255,0,15,164,164,163,162,
  161,227,227,227,226,227,161,162,162,163,163,164,164,255,1,13,164,164,164,163,
  162,161,161,160,161,160,160,163,163,164,164,255,1,13,164,164,163,163,162,163,
  161,161,161,163,161,163,163,73,73,255,2,11,164,164,164,162,163,161,163,162,
  162,162,162,164,164,255,3,9,163,163,165,162,163,162,162,162,165,163,163,255,
  5,5,166,166,166,164,166,165,165,255,
};
static const char pls1b0[] = { // 2022/07/05 Freedoom lump
  15,0,15,0,8,0,12,0,68,0,0,0,78,0,0,0,92,0,0,0,108,0,0,0,126,0,0,0,144,0,0,0,
  164,0,0,0,184,0,0,0,204,0,0,0,224,0,0,0,244,0,0,0,6,1,0,0,24,1,0,0,40,1,0,0,
  54,1,0,0,5,5,163,163,165,164,72,73,73,255,3,9,164,164,165,163,162,163,163,
  163,164,164,164,255,2,11,165,165,162,162,161,161,161,162,162,162,162,164,164,
  255,1,13,166,166,163,163,161,160,227,227,226,162,161,163,162,163,163,255,1,
  13,164,164,163,162,161,226,225,225,226,226,227,162,163,165,165,255,0,15,164,
  164,164,163,162,161,225,225,4,4,226,227,161,162,162,165,165,255,0,15,163,163,
  162,162,161,227,225,4,4,4,225,226,227,163,163,164,164,255,0,15,165,165,164,
  161,227,227,225,4,4,4,226,226,161,162,163,164,164,255,0,15,163,163,162,161,
  161,226,226,225,4,4,226,226,227,161,163,164,164,255,0,15,165,165,162,162,162,
  161,226,226,226,226,227,227,160,163,162,163,163,255,1,13,165,165,163,161,160,
  227,227,227,161,161,227,161,164,164,164,255,1,13,165,165,163,162,162,161,161,
  160,162,160,162,163,162,164,164,255,2,11,165,165,163,163,161,162,161,162,162,
  164,162,164,164,255,3,9,73,73,164,163,164,164,163,162,165,164,164,255,5,5,
  166,166,165,164,165,165,165,255,
};
static const char pls1c0[] = { // 2022/07/05 Freedoom lump
  15,0,15,0,8,0,12,0,68,0,0,0,78,0,0,0,92,0,0,0,108,0,0,0,126,0,0,0,144,0,0,0,
  164,0,0,0,184,0,0,0,204,0,0,0,224,0,0,0,244,0,0,0,6,1,0,0,24,1,0,0,40,1,0,0,
  54,1,0,0,5,5,164,164,165,164,165,164,164,255,3,9,164,164,164,162,164,164,162,
  164,164,164,164,255,2,11,164,164,164,163,162,161,160,161,162,162,163,165,165,
  255,1,13,165,165,162,162,161,161,160,227,161,160,161,162,163,165,165,255,1,
  13,165,165,164,161,161,161,227,225,226,161,227,162,164,166,166,255,0,15,164,
  164,163,162,162,161,226,225,4,4,226,161,161,162,163,73,73,255,0,15,164,164,
  162,161,160,161,225,4,4,4,225,161,161,163,163,164,164,255,0,15,164,164,163,
  161,162,161,225,4,4,4,225,227,160,163,163,165,165,255,0,15,164,164,163,162,
  161,161,227,225,225,4,226,161,162,162,162,164,164,255,0,15,164,164,163,162,
  161,227,227,227,226,227,161,162,162,163,163,164,164,255,1,13,164,164,164,163,
  162,161,161,160,161,160,160,163,163,164,164,255,1,13,164,164,163,163,162,163,
  161,161,161,163,161,163,163,73,73,255,2,11,164,164,164,162,163,161,163,162,
  162,162,162,164,164,255,3,9,163,163,165,162,163,162,162,162,165,163,163,255,
  5,5,166,166,166,164,166,165,165,255,
};
static const char pls1d0[] = { // 2022/07/05 Freedoom lump
  15,0,15,0,8,0,12,0,68,0,0,0,78,0,0,0,92,0,0,0,108,0,0,0,126,0,0,0,144,0,0,0,
  164,0,0,0,184,0,0,0,204,0,0,0,224,0,0,0,244,0,0,0,6,1,0,0,24,1,0,0,40,1,0,0,
  54,1,0,0,5,5,163,163,165,164,72,73,73,255,3,9,164,164,165,163,162,163,163,
  163,164,164,164,255,2,11,165,165,162,162,161,161,161,162,162,162,162,164,164,
  255,1,13,166,166,163,163,161,160,227,227,226,162,161,163,162,163,163,255,1,
  13,164,164,163,162,161,226,225,225,226,226,227,162,163,165,165,255,0,15,164,
  164,164,163,162,161,225,225,4,4,226,227,161,162,162,165,165,255,0,15,163,163,
  162,162,161,227,225,4,4,4,225,226,227,163,163,164,164,255,0,15,165,165,164,
  161,227,227,225,4,4,4,226,226,161,162,163,164,164,255,0,15,163,163,162,161,
  161,226,226,225,4,4,226,226,227,161,163,164,164,255,0,15,165,165,162,162,162,
  161,226,226,226,226,227,227,160,163,162,163,163,255,1,13,165,165,163,161,160,
  227,227,227,161,161,227,161,164,164,164,255,1,13,165,165,163,162,162,161,161,
  160,162,160,162,163,162,164,164,255,2,11,165,165,163,163,161,162,161,162,162,
  164,162,164,164,255,3,9,73,73,164,163,164,164,163,162,165,164,164,255,5,5,
  166,166,165,164,165,165,165,255,
};
static const char pls1e0[] = { // 2022/07/05 Freedoom lump
  34,0,33,0,17,0,21,0,144,0,0,0,150,0,0,0,157,0,0,0,180,0,0,0,195,0,0,0,216,0,
  0,0,246,0,0,0,20,1,0,0,50,1,0,0,87,1,0,0,129,1,0,0,166,1,0,0,202,1,0,0,234,1,
  0,0,13,2,0,0,47,2,0,0,80,2,0,0,119,2,0,0,155,2,0,0,189,2,0,0,223,2,0,0,0,3,0,
  0,32,3,0,0,62,3,0,0,96,3,0,0,132,3,0,0,167,3,0,0,196,3,0,0,229,3,0,0,3,4,0,0,
  28,4,0,0,53,4,0,0,76,4,0,0,83,4,0,0,19,1,166,166,166,255,7,2,166,166,166,166,
  255,7,2,166,166,166,166,13,7,166,166,166,165,166,165,166,166,166,26,1,166,
  166,166,255,11,10,166,166,165,165,164,164,164,164,164,165,166,166,255,6,16,
  165,165,165,165,165,164,164,164,164,163,164,163,164,164,164,164,166,166,255,
  5,18,165,165,164,164,163,164,164,163,163,160,160,161,161,163,161,163,164,165,
  166,166,25,3,166,166,164,164,164,255,4,25,165,165,165,163,164,163,162,162,
  163,160,163,160,164,160,161,164,163,163,165,164,165,164,164,164,164,166,166,
  255,4,25,165,165,164,164,164,162,160,165,163,162,163,164,227,160,160,160,164,
  163,163,165,164,164,165,164,164,166,166,255,3,27,166,166,164,164,164,163,227,
  227,164,161,161,227,160,160,163,227,227,160,163,162,161,163,164,164,163,165,
  164,166,166,32,1,166,166,166,255,1,1,166,166,166,3,27,166,166,164,163,163,
  160,227,227,162,160,160,160,227,160,227,227,160,160,160,160,163,164,164,160,
  164,164,164,164,164,32,1,166,166,166,255,0,2,166,166,166,166,4,26,165,165,
  165,163,164,160,161,160,160,160,163,227,160,162,161,161,160,161,227,160,160,
  164,164,162,165,164,165,165,255,0,1,166,166,166,4,26,165,165,164,164,161,160,
  162,161,227,161,163,161,162,163,162,164,164,163,162,227,226,161,161,162,164,
  164,165,165,255,4,27,165,165,164,164,160,161,163,227,161,162,164,160,165,164,
  164,165,165,164,163,160,160,227,160,163,163,164,165,165,165,255,3,14,166,166,
  165,164,164,163,163,160,160,163,164,163,164,165,166,166,19,12,166,166,165,
  161,160,227,227,160,161,163,164,165,166,166,255,2,14,164,164,164,164,165,163,
  163,161,161,163,163,164,165,164,166,166,20,11,166,166,163,161,227,161,227,
  162,162,164,165,165,165,255,2,13,166,166,164,164,161,163,161,227,160,227,162,
  165,165,165,165,20,11,165,165,165,162,160,227,160,160,163,164,165,164,164,
  255,0,1,166,166,166,2,13,165,165,164,164,162,160,227,227,227,161,162,164,164,
  165,165,19,12,166,166,166,165,163,160,227,160,160,163,163,166,165,165,255,2,
  14,165,165,164,164,162,160,227,227,160,163,164,165,164,164,166,166,18,13,165,
  165,166,165,164,162,160,227,227,162,162,164,165,165,165,255,2,29,165,165,164,
  164,162,161,227,227,227,161,163,164,165,164,165,166,165,166,167,165,161,160,
  227,227,160,161,162,164,166,166,166,255,2,29,164,164,164,163,161,162,161,161,
  160,227,161,161,164,164,165,165,164,165,165,164,162,162,227,160,161,161,163,
  164,165,165,165,255,2,28,166,166,164,164,164,163,160,162,162,227,160,160,163,
  163,164,162,162,164,165,162,162,227,160,162,162,162,163,165,166,166,255,3,27,
  166,166,164,164,164,164,162,161,160,227,226,160,163,161,227,161,163,162,161,
  227,164,162,163,163,163,164,166,166,166,255,4,25,165,165,165,164,164,164,162,
  161,227,161,163,160,160,227,227,161,160,227,165,164,163,164,162,163,165,166,
  166,255,4,24,165,165,164,163,165,161,161,162,161,160,161,160,227,160,160,160,
  160,162,164,164,164,164,163,164,166,166,31,1,165,165,165,255,3,24,166,166,
  164,164,164,162,163,227,161,163,161,227,227,227,227,227,160,162,162,164,163,
  164,162,164,166,166,30,3,166,166,166,166,166,255,2,25,166,166,165,165,164,
  164,164,162,162,163,161,162,163,162,227,160,162,163,164,164,163,164,164,164,
  165,166,166,31,1,166,166,166,255,2,24,165,165,164,164,164,163,164,164,162,
  162,227,163,163,163,162,163,163,164,163,162,161,165,165,166,166,166,255,2,23,
  164,164,164,164,164,164,164,164,164,163,164,161,161,163,162,227,164,164,164,
  163,164,165,165,165,165,26,1,165,165,165,255,2,3,165,165,165,164,164,6,18,
  164,164,164,164,164,164,164,163,164,163,164,164,164,164,164,164,165,164,166,
  166,255,3,20,166,166,164,164,165,164,165,164,165,164,165,164,164,164,164,164,
  164,166,165,165,166,166,255,5,5,166,166,164,165,165,165,165,11,11,164,164,
  165,165,164,164,164,165,164,165,164,165,165,255,3,1,166,166,166,6,3,165,165,
  166,165,165,14,6,165,165,164,165,165,164,165,165,255,11,2,167,167,166,166,
  255,12,3,166,166,166,166,166,255,
};
static const char pls1f0[] = { // 2022/07/05 Freedoom lump
  40,0,35,0,19,0,25,0,168,0,0,0,181,0,0,0,197,0,0,0,217,0,0,0,242,0,0,0,14,1,0,
  0,45,1,0,0,77,1,0,0,111,1,0,0,145,1,0,0,180,1,0,0,218,1,0,0,0,2,0,0,38,2,0,0,
  76,2,0,0,115,2,0,0,155,2,0,0,195,2,0,0,229,2,0,0,8,3,0,0,42,3,0,0,77,3,0,0,
  113,3,0,0,148,3,0,0,190,3,0,0,236,3,0,0,16,4,0,0,51,4,0,0,85,4,0,0,119,4,0,0,
  152,4,0,0,185,4,0,0,219,4,0,0,254,4,0,0,30,5,0,0,59,5,0,0,86,5,0,0,115,5,0,0,
  141,5,0,0,168,5,0,0,14,8,165,165,166,166,166,166,166,165,165,165,255,12,11,
  165,165,164,165,164,164,164,164,164,164,164,166,166,255,9,15,165,165,165,164,
  166,164,165,164,163,164,163,163,164,165,165,165,165,255,6,20,164,164,165,165,
  164,164,164,165,164,164,164,163,163,163,161,164,164,165,165,165,165,165,255,
  5,23,165,165,164,165,164,165,165,165,164,164,163,161,162,162,163,161,161,164,
  165,164,164,165,165,165,165,255,4,26,164,164,165,164,164,166,164,165,164,164,
  164,162,163,163,162,162,163,160,164,164,164,164,161,163,164,164,165,165,255,
  3,27,164,164,165,164,165,164,165,164,162,164,164,163,162,227,164,162,161,161,
  163,165,164,165,164,165,164,164,164,165,165,255,2,29,166,166,165,164,166,164,
  163,164,161,163,161,162,162,163,164,162,163,162,162,227,162,164,164,165,165,
  165,166,165,164,165,165,255,2,29,166,166,164,165,164,164,163,163,163,160,164,
  162,163,160,162,162,162,161,163,163,161,162,164,163,164,165,164,164,164,165,
  165,255,2,30,165,165,165,164,164,164,161,163,160,160,161,163,163,162,160,160,
  162,161,227,160,163,160,162,163,163,164,164,164,164,164,165,165,255,1,33,166,
  166,165,165,164,164,163,163,162,226,160,162,163,163,160,227,227,162,227,226,
  227,227,162,162,162,163,163,164,164,164,164,164,165,165,165,255,1,33,165,165,
  164,164,164,163,163,163,162,227,161,161,162,160,227,160,160,160,160,227,227,
  227,160,161,161,163,162,163,163,164,164,165,164,165,165,255,1,33,165,165,164,
  164,163,165,164,163,163,162,162,162,162,161,162,227,227,160,163,161,227,226,
  226,227,160,227,162,163,164,164,164,164,165,165,165,255,1,33,164,164,164,165,
  164,164,163,161,163,163,163,163,163,160,227,227,161,162,163,164,164,164,163,
  160,227,160,227,160,161,163,164,164,165,165,165,255,1,34,165,165,164,164,164,
  164,161,227,160,162,161,160,227,227,227,161,164,164,165,164,165,164,164,161,
  160,227,160,227,160,162,162,164,164,165,165,165,255,0,17,165,165,165,166,165,
  165,164,161,160,163,162,161,160,227,160,162,164,164,164,21,14,164,164,162,
  164,163,227,160,160,162,163,162,162,164,165,166,166,255,0,15,166,166,165,164,
  164,164,164,162,161,163,160,227,160,227,160,164,164,22,2,164,164,163,163,25,
  10,164,164,163,160,227,160,162,161,163,165,165,165,255,0,14,164,164,164,165,
  164,164,163,163,162,160,227,160,227,162,164,164,24,11,164,164,161,160,227,
  227,160,163,162,164,166,165,165,255,0,14,165,165,164,165,164,162,161,162,161,
  160,160,227,160,161,165,165,23,12,165,165,162,162,160,227,160,162,161,162,
  164,164,166,166,255,0,13,165,165,164,164,164,162,161,160,161,160,227,160,162,
  164,164,23,12,164,164,164,161,163,163,162,164,163,164,164,164,165,165,255,0,
  13,165,165,164,164,163,160,162,160,163,227,160,227,161,165,165,22,13,165,165,
  165,163,161,160,160,161,163,164,164,163,164,165,165,255,0,14,165,165,165,165,
  164,163,161,162,163,227,160,160,160,163,165,165,22,13,165,165,164,160,160,
  226,227,227,163,161,164,164,163,165,165,255,1,13,165,165,165,164,164,162,160,
  163,161,226,160,227,163,164,164,22,13,164,164,162,227,227,160,160,161,161,
  162,164,164,164,165,165,255,1,13,165,165,164,164,164,163,163,163,160,160,160,
  227,161,164,164,17,4,164,164,164,164,163,163,23,12,162,162,227,227,227,163,
  163,162,162,164,164,165,165,165,255,1,14,166,166,164,164,164,164,163,161,161,
  161,161,227,227,163,164,164,16,2,227,227,161,161,20,2,161,161,160,160,23,11,
  161,161,160,161,162,163,161,161,165,164,165,166,166,255,2,15,166,166,164,164,
  164,164,163,161,161,163,160,227,160,161,163,164,164,22,12,162,162,227,161,
  163,162,162,161,164,164,164,166,165,165,255,3,30,165,165,164,164,163,164,162,
  163,161,160,227,160,161,162,163,164,164,164,164,164,227,161,161,163,164,164,
  161,163,164,165,166,166,255,3,29,164,164,165,164,164,164,163,161,162,163,160,
  160,160,227,162,227,162,160,160,227,160,163,163,162,164,164,163,164,166,165,
  165,255,3,29,165,165,165,164,164,164,162,160,163,163,162,160,160,226,227,227,
  160,227,160,160,162,160,164,164,164,164,164,164,166,166,166,255,3,28,164,164,
  164,164,164,164,160,160,161,163,162,160,160,163,227,160,162,162,161,162,162,
  163,164,161,164,163,164,164,166,166,255,2,28,166,166,164,164,164,163,164,164,
  163,163,162,161,163,160,227,162,162,162,161,162,161,162,164,164,164,164,164,
  164,166,166,255,1,29,164,164,165,165,165,164,164,163,164,161,163,161,161,162,
  162,160,162,161,160,162,161,164,164,162,164,165,165,166,165,165,165,255,1,4,
  164,164,165,164,164,164,7,22,163,163,164,164,162,162,160,163,162,161,160,163,
  163,161,164,164,164,164,164,164,164,164,166,166,255,1,3,165,165,164,165,165,
  8,20,164,164,164,163,164,164,163,162,161,163,227,227,164,164,164,163,164,165,
  165,165,164,164,255,1,3,165,165,164,165,165,9,17,164,164,164,164,164,164,164,
  163,163,161,163,164,165,164,164,165,165,165,165,255,2,3,166,166,164,165,165,
  10,15,164,164,164,164,164,164,164,164,163,162,163,164,164,165,166,166,166,
  255,2,4,166,166,164,164,165,165,9,16,165,165,164,164,165,164,165,164,164,164,
  164,164,164,166,165,165,165,165,255,3,21,165,165,165,164,165,165,166,166,164,
  165,164,164,165,164,165,164,164,164,165,166,165,166,166,255,4,7,165,165,165,
  165,164,165,164,165,165,12,11,165,165,166,164,165,165,164,164,165,164,165,
  165,165,255,6,4,165,165,165,166,165,165,15,6,165,165,165,165,164,165,164,164,
  255,
};
static const char pls1g0[] = { // 2022/07/05 Freedoom lump
  46,0,39,0,22,0,28,0,192,0,0,0,201,0,0,0,214,0,0,0,234,0,0,0,5,1,0,0,38,1,0,0,
  76,1,0,0,113,1,0,0,150,1,0,0,187,1,0,0,226,1,0,0,9,2,0,0,55,2,0,0,98,2,0,0,
  135,2,0,0,171,2,0,0,205,2,0,0,236,2,0,0,10,3,0,0,40,3,0,0,67,3,0,0,100,3,0,0,
  128,3,0,0,156,3,0,0,184,3,0,0,212,3,0,0,244,3,0,0,17,4,0,0,48,4,0,0,79,4,0,0,
  120,4,0,0,162,4,0,0,196,4,0,0,227,4,0,0,10,5,0,0,48,5,0,0,82,5,0,0,108,5,0,0,
  140,5,0,0,174,5,0,0,209,5,0,0,242,5,0,0,14,6,0,0,45,6,0,0,74,6,0,0,104,6,0,0,
  20,4,166,166,166,166,166,166,255,17,8,166,166,164,164,164,164,164,164,167,
  167,255,10,2,166,166,166,166,16,9,166,166,164,163,163,163,164,163,164,167,
  167,255,6,8,165,165,166,166,166,164,164,164,166,166,15,10,164,164,164,162,
  162,161,161,161,164,163,165,165,255,4,20,165,165,166,166,164,164,164,166,165,
  166,164,164,164,162,163,161,161,162,161,162,163,163,27,4,164,164,165,166,165,
  165,255,3,22,166,166,166,166,164,166,166,166,164,164,164,163,164,162,161,160,
  161,162,161,161,161,163,164,164,26,7,163,163,160,162,162,163,166,166,166,255,
  2,32,166,166,166,166,164,165,164,164,163,163,161,163,164,162,161,163,162,161,
  160,160,161,161,161,164,166,166,166,164,164,166,166,165,166,166,255,2,32,166,
  166,166,164,164,166,164,164,164,163,161,161,160,162,162,161,163,161,161,161,
  161,161,162,164,164,164,165,164,163,163,164,166,165,165,255,2,32,166,166,166,
  164,164,165,164,164,164,163,162,162,162,162,161,164,163,160,161,162,160,163,
  162,161,164,164,166,166,164,164,164,166,165,165,255,1,34,166,166,166,164,166,
  165,164,164,164,163,161,163,162,161,161,162,164,161,162,164,163,162,164,162,
  161,161,164,164,166,166,167,166,164,165,166,166,255,1,34,167,167,164,166,164,
  164,163,163,162,161,160,161,164,161,163,163,162,161,164,164,164,161,162,161,
  161,164,164,163,164,164,163,164,164,164,166,166,255,1,17,166,166,166,164,164,
  163,163,161,162,161,160,163,162,162,164,161,163,160,160,19,6,165,165,164,164,
  163,161,163,163,26,10,162,162,162,163,164,164,164,163,164,164,166,166,255,0,
  17,165,165,166,164,163,163,164,162,161,162,161,163,163,162,163,164,164,164,
  164,22,2,164,164,164,164,27,11,164,164,162,163,163,164,163,163,164,164,166,
  166,166,255,0,15,166,166,164,163,163,163,163,161,161,162,162,164,161,161,163,
  164,164,25,13,160,160,162,162,160,162,163,164,164,163,163,164,164,166,166,
  255,0,14,166,166,163,164,164,166,166,163,160,163,164,161,162,163,164,164,25,
  13,164,164,164,163,161,161,161,163,163,163,163,164,164,166,166,255,0,13,166,
  166,163,166,164,163,163,162,161,162,161,162,162,164,164,26,12,163,163,163,
  163,163,160,161,162,161,163,164,164,166,166,255,0,12,166,166,164,165,165,163,
  163,161,164,163,164,163,164,164,28,10,164,164,163,163,161,161,162,162,163,
  164,166,166,255,1,11,167,167,166,166,163,163,161,161,164,164,163,164,164,26,
  10,164,164,164,163,164,163,163,161,161,164,164,164,255,2,9,164,164,163,165,
  164,161,164,163,163,164,164,27,12,164,164,163,162,164,163,164,164,161,161,
  163,167,164,164,255,4,7,162,162,160,161,160,166,163,164,164,28,11,164,164,
  164,164,163,161,160,162,162,163,166,165,165,255,2,9,167,167,162,161,162,160,
  161,162,164,164,164,13,1,162,162,162,29,10,160,160,164,160,162,162,161,162,
  164,166,166,166,255,1,9,164,164,164,161,162,161,160,161,163,161,161,29,10,
  164,164,161,162,163,163,161,163,164,164,166,166,255,0,10,165,165,164,164,161,
  162,162,160,161,163,164,164,30,9,164,164,160,163,161,163,163,163,164,166,166,
  255,0,10,166,166,164,163,162,161,161,160,161,163,164,164,30,9,164,164,161,
  161,161,164,163,164,164,166,166,255,0,10,165,165,164,164,162,161,162,161,162,
  163,164,164,30,9,164,164,161,163,162,163,163,163,164,166,166,255,1,9,164,164,
  163,161,162,161,161,161,163,164,164,28,1,160,160,160,30,9,163,163,163,163,
  162,161,163,163,164,166,166,255,0,11,166,166,164,163,163,161,162,160,161,163,
  161,164,164,30,9,164,164,160,163,162,161,163,164,164,166,166,255,0,11,166,
  166,164,164,164,163,162,160,161,161,161,164,164,28,11,164,164,163,161,162,
  161,163,162,163,164,167,166,166,255,0,12,167,167,164,164,163,163,163,161,162,
  162,161,162,164,164,28,10,164,164,164,164,163,162,162,164,163,166,167,167,
  255,1,10,167,167,164,164,163,164,163,160,161,163,164,164,13,5,164,164,164,
  164,161,164,164,25,2,164,164,164,164,30,7,164,164,164,163,163,164,164,167,
  167,255,2,9,166,166,164,164,164,163,164,164,164,166,166,12,7,164,164,163,163,
  163,160,161,163,163,22,8,163,163,164,164,160,162,164,164,163,163,34,1,164,
  164,164,255,4,5,166,166,166,164,165,165,165,11,20,164,164,162,161,163,163,
  163,161,161,161,160,163,163,163,160,161,162,162,164,164,164,164,255,11,20,
  160,160,163,162,160,163,163,163,164,163,164,163,161,161,162,161,163,164,164,
  164,164,164,34,2,166,166,166,166,255,3,3,165,165,165,165,165,10,22,164,164,
  163,161,161,160,160,161,163,163,164,160,160,162,162,162,163,163,162,164,164,
  162,164,164,34,1,166,166,166,255,3,4,167,167,167,167,166,166,9,9,164,164,163,
  163,162,161,162,163,163,164,164,20,12,164,164,161,162,161,161,164,164,163,
  164,164,163,164,164,255,4,2,166,166,166,166,9,8,164,164,161,161,162,162,161,
  163,164,164,21,11,164,164,162,164,163,161,163,164,164,166,166,165,165,255,9,
  7,163,163,164,161,161,164,161,164,164,22,10,163,163,164,163,163,164,164,165,
  166,167,167,167,255,3,2,165,165,166,166,10,7,163,163,163,164,163,161,161,164,
  164,21,10,163,163,163,164,163,164,164,164,166,166,166,166,255,2,4,166,166,
  166,166,166,166,10,7,163,163,164,164,164,162,161,164,164,21,10,163,163,164,
  164,163,164,164,165,166,166,166,166,255,2,4,166,166,166,166,166,166,10,8,163,
  163,163,163,163,161,162,164,164,164,20,10,163,163,164,164,164,163,164,165,
  166,166,167,167,255,1,6,163,163,166,164,165,166,165,165,10,18,164,164,164,
  164,163,163,163,163,162,162,162,164,164,164,163,164,166,166,166,166,255,1,3,
  167,167,163,166,166,11,16,164,164,164,163,163,164,163,163,160,162,162,163,
  164,164,167,166,167,167,255,1,5,167,167,164,164,166,166,166,10,17,165,165,
  164,164,164,164,164,164,163,163,164,163,163,164,167,166,165,166,166,255,2,24,
  166,166,164,163,163,164,166,166,166,166,166,166,164,164,164,164,164,163,163,
  164,165,166,166,165,166,166,255,3,9,166,166,166,166,166,166,166,164,164,166,
  166,13,12,166,166,166,166,165,164,164,164,164,164,166,165,165,165,255,6,5,
  166,166,166,166,166,166,166,16,7,165,165,166,165,166,166,166,166,166,255,
};
static const char pls2a0[] = { // 2022/07/05 Freedoom lump
  15,0,15,0,8,0,14,0,68,0,0,0,81,0,0,0,93,0,0,0,108,0,0,0,125,0,0,0,143,0,0,0,
  163,0,0,0,182,0,0,0,201,0,0,0,220,0,0,0,240,0,0,0,2,1,0,0,20,1,0,0,36,1,0,0,
  51,1,0,0,5,1,254,254,254,7,3,254,254,253,253,253,255,4,7,254,254,201,252,203,
  253,205,253,253,255,2,10,254,254,253,203,204,201,201,200,200,203,254,254,255,
  1,12,254,254,203,204,201,201,201,198,201,201,201,203,254,254,255,1,13,253,
  253,203,201,201,200,197,197,198,198,201,201,254,253,253,255,0,15,253,253,201,
  203,200,198,196,196,196,196,197,198,201,200,201,253,253,255,0,14,253,253,203,
  200,201,197,196,194,196,193,196,197,201,201,253,253,255,1,14,254,254,201,201,
  196,195,195,194,196,195,196,198,201,253,253,253,255,1,14,253,253,201,198,196,
  195,195,193,195,195,196,201,201,203,254,254,255,0,15,254,254,203,201,201,197,
  196,194,195,195,195,197,201,204,203,253,253,255,1,13,254,254,203,198,198,196,
  196,195,195,196,198,201,203,254,254,255,1,13,253,253,252,203,203,198,197,196,
  197,200,201,203,203,253,253,255,2,11,253,253,203,204,204,201,201,201,203,203,
  203,253,253,255,3,10,254,254,254,203,201,253,253,201,253,254,254,254,255,5,2,
  253,253,253,253,9,1,254,254,254,255,
};
static const char pls2b0[] = { // 2022/07/05 Freedoom lump
  16,0,16,0,8,0,15,0,72,0,0,0,84,0,0,0,96,0,0,0,110,0,0,0,126,0,0,0,144,0,0,0,
  163,0,0,0,183,0,0,0,202,0,0,0,223,0,0,0,244,0,0,0,7,1,0,0,25,1,0,0,42,1,0,0,
  57,1,0,0,70,1,0,0,6,1,254,254,254,8,2,253,253,253,253,255,4,7,253,253,253,
  203,253,201,203,254,254,255,3,9,253,253,253,203,201,201,201,201,253,254,254,
  255,2,11,254,254,253,201,203,200,198,198,203,203,203,253,253,255,1,13,253,
  253,253,201,200,201,200,200,201,200,200,198,203,254,254,255,1,14,254,254,204,
  201,200,197,197,196,196,198,201,201,200,254,254,254,255,0,15,254,254,203,201,
  201,198,196,196,193,195,196,198,201,201,201,253,253,255,1,14,253,253,201,201,
  197,195,195,194,195,195,197,201,201,203,253,253,255,0,16,253,253,203,201,200,
  197,195,193,195,193,195,197,200,201,201,205,253,253,255,0,16,253,253,201,201,
  201,198,196,195,194,195,195,198,201,201,203,204,254,254,255,1,14,253,253,204,
  201,198,196,195,195,195,197,201,201,201,204,254,254,255,1,13,253,253,253,203,
  201,200,198,197,197,201,201,204,203,254,254,255,2,12,254,254,201,203,201,201,
  201,201,204,203,201,253,254,254,255,3,10,254,254,205,205,204,203,201,201,205,
  254,253,253,255,4,8,253,253,253,205,205,254,253,253,253,253,255,6,2,253,253,
  253,253,255,
};
static const char pls2c0[] = { // 2022/07/05 Freedoom lump
  32,0,30,0,16,0,23,0,136,0,0,0,142,0,0,0,155,0,0,0,172,0,0,0,192,0,0,0,217,0,
  0,0,238,0,0,0,6,1,0,0,37,1,0,0,65,1,0,0,94,1,0,0,123,1,0,0,160,1,0,0,193,1,0,
  0,229,1,0,0,8,2,0,0,44,2,0,0,76,2,0,0,104,2,0,0,134,2,0,0,163,2,0,0,193,2,0,
  0,224,2,0,0,251,2,0,0,23,3,0,0,48,3,0,0,72,3,0,0,95,3,0,0,122,3,0,0,148,3,0,
  0,178,3,0,0,198,3,0,0,17,1,207,207,207,255,3,1,243,243,243,16,3,205,205,241,
  242,242,255,10,4,205,205,206,207,206,206,15,4,204,204,204,207,241,241,255,8,
  2,241,241,207,207,12,9,207,207,206,241,205,203,204,243,244,242,242,255,4,1,
  206,206,206,7,15,241,241,207,205,206,241,207,207,241,241,202,204,243,244,243,
  241,241,255,6,16,205,205,207,207,205,205,205,205,206,203,205,204,204,244,244,
  242,241,241,255,4,1,242,242,242,7,14,205,205,205,204,204,203,204,206,203,204,
  203,202,241,241,207,207,255,3,21,243,243,242,241,241,206,204,204,204,204,204,
  205,198,198,198,198,203,206,205,206,207,241,241,26,1,241,241,241,255,2,23,
  242,242,242,207,207,207,206,205,204,203,204,203,204,199,198,198,198,204,202,
  204,205,206,242,242,242,255,2,24,243,243,242,205,205,204,206,205,203,202,202,
  202,204,198,197,198,199,202,202,204,207,241,243,242,241,241,255,3,24,242,242,
  207,207,207,241,207,203,199,199,198,198,198,197,197,198,197,202,202,207,207,
  242,241,242,241,241,255,1,27,243,243,244,245,244,243,242,241,242,207,198,197,
  196,197,196,195,196,196,196,197,199,203,205,207,206,207,241,242,242,29,1,243,
  243,243,255,0,28,241,241,242,244,244,243,242,242,243,242,206,205,196,195,195,
  195,193,194,194,195,196,197,203,203,204,206,241,242,242,242,255,2,23,242,242,
  207,206,204,206,206,241,207,198,196,194,193,193,193,193,193,194,195,197,202,
  205,205,206,206,26,4,242,242,207,242,207,207,255,2,24,205,205,205,205,204,
  203,202,198,198,197,195,193,193,193,193,192,194,193,195,196,203,206,207,241,
  207,207,28,2,241,241,242,242,255,1,26,206,206,205,204,205,205,204,199,198,
  197,195,194,193,193,192,192,193,193,193,194,196,198,203,206,205,205,205,205,
  28,1,207,207,207,255,1,27,205,205,204,205,205,207,205,203,198,197,195,193,
  192,192,82,192,82,192,192,194,195,203,203,205,206,241,242,242,242,255,3,23,
  203,203,203,205,205,204,203,203,196,193,193,82,82,192,82,192,193,194,196,198,
  205,204,205,206,206,255,1,25,242,242,207,202,202,203,207,206,203,198,197,195,
  194,193,82,82,193,192,194,196,197,205,206,206,207,207,207,255,3,24,204,204,
  205,206,206,206,203,198,196,195,194,194,193,193,193,194,195,197,206,207,206,
  206,207,206,206,206,255,2,25,205,205,207,242,241,207,204,203,198,197,195,194,
  195,194,194,194,195,196,197,203,207,207,205,207,206,206,206,255,3,21,243,243,
  242,242,207,207,206,204,198,197,197,196,195,195,195,196,197,198,203,206,207,
  206,206,25,1,207,207,207,255,4,22,243,243,242,243,242,207,207,203,203,202,
  198,197,197,196,203,203,203,204,205,206,242,243,207,207,255,3,23,204,204,206,
  241,207,207,242,205,204,202,205,203,202,199,199,205,205,204,206,206,206,207,
  243,207,207,255,5,20,241,241,206,242,241,206,204,203,204,205,204,199,198,202,
  207,205,203,207,206,241,241,241,255,5,19,241,241,242,242,242,241,206,205,207,
  207,203,202,202,202,206,205,206,207,207,241,241,255,6,18,242,242,242,241,241,
  207,205,241,241,203,203,204,204,204,205,205,204,207,205,205,255,5,17,243,243,
  242,241,204,206,206,205,241,241,202,206,203,204,206,207,243,205,205,26,1,241,
  241,241,255,7,1,207,207,207,9,1,241,241,241,11,11,241,241,241,242,241,207,
  204,206,207,207,241,207,207,255,8,2,207,207,242,242,11,3,243,243,243,242,242,
  15,1,207,207,207,18,2,241,241,241,241,21,1,207,207,207,255,8,1,207,207,207,
  11,3,241,241,243,241,241,19,3,206,206,206,207,207,255,11,2,241,241,241,241,
  19,1,206,206,206,255,
};
static const char pls2d0[] = { // 2022/07/05 Freedoom lump
  40,0,35,0,20,0,27,0,168,0,0,0,189,0,0,0,227,0,0,0,10,1,0,0,40,1,0,0,71,1,0,0,
  109,1,0,0,138,1,0,0,190,1,0,0,235,1,0,0,18,2,0,0,59,2,0,0,98,2,0,0,141,2,0,0,
  182,2,0,0,229,2,0,0,16,3,0,0,59,3,0,0,100,3,0,0,140,3,0,0,187,3,0,0,234,3,0,
  0,23,4,0,0,70,4,0,0,116,4,0,0,162,4,0,0,201,4,0,0,238,4,0,0,22,5,0,0,68,5,0,
  0,118,5,0,0,157,5,0,0,201,5,0,0,243,5,0,0,29,6,0,0,72,6,0,0,110,6,0,0,138,6,
  0,0,166,6,0,0,188,6,0,0,15,3,207,207,206,207,207,19,1,241,241,241,25,4,207,
  207,207,207,206,206,255,13,1,207,207,207,15,1,206,206,206,19,1,207,207,207,
  21,1,241,241,241,24,3,207,207,207,206,206,28,1,207,207,207,30,1,241,241,241,
  255,12,4,207,207,241,207,206,206,17,2,205,205,206,206,20,3,206,206,241,205,
  205,24,1,241,241,241,27,3,241,241,206,206,206,31,1,207,207,207,255,12,1,242,
  242,242,14,1,206,206,206,17,2,205,205,205,205,20,2,206,206,206,206,29,3,207,
  207,206,206,206,255,10,1,242,242,242,13,3,206,206,206,205,205,17,8,203,203,
  205,205,206,205,205,205,206,206,30,2,241,241,205,205,255,9,1,206,206,206,12,
  2,205,205,205,205,15,3,206,206,203,202,202,19,1,205,205,205,21,5,205,205,205,
  205,206,206,206,31,1,207,207,207,255,8,3,207,207,241,241,241,14,12,205,205,
  206,201,199,204,202,203,202,205,205,206,204,204,31,1,206,206,206,255,6,1,241,
  241,241,8,1,207,207,207,11,3,205,205,206,205,205,15,1,203,203,203,17,4,202,
  202,203,203,204,204,22,4,199,199,203,203,205,205,27,1,205,205,205,30,4,206,
  206,206,241,207,207,255,7,1,207,207,207,10,2,205,205,203,203,13,11,205,205,
  203,203,202,203,198,203,199,203,203,202,202,25,3,203,203,205,205,205,29,2,
  206,206,241,241,32,1,207,207,207,255,5,1,241,241,241,7,23,205,205,207,205,
  206,205,202,202,204,203,203,202,203,199,199,202,202,202,203,204,205,206,205,
  205,205,31,2,206,206,242,242,255,4,7,243,243,205,205,203,206,203,205,205,12,
  15,203,203,203,202,201,202,201,199,202,202,199,203,202,203,203,202,202,28,1,
  205,205,205,30,1,206,206,206,255,3,7,244,244,242,205,205,206,206,205,205,11,
  17,204,204,204,202,202,201,199,199,199,199,201,202,204,199,199,202,203,205,
  205,30,2,207,207,241,241,255,3,4,242,242,243,205,205,205,8,5,205,205,203,203,
  203,201,201,14,12,202,202,199,202,199,202,205,199,199,202,203,203,202,202,27,
  5,205,205,205,206,242,207,207,255,2,6,241,241,241,207,204,203,205,205,9,19,
  203,203,202,202,201,202,203,203,204,203,203,206,206,199,199,202,203,203,204,
  206,206,29,3,206,206,206,206,206,255,1,2,242,242,241,241,4,1,205,205,205,7,3,
  204,204,203,203,203,11,18,201,201,203,203,206,206,206,202,205,203,199,199,
  199,203,203,202,203,202,206,206,31,2,206,206,243,243,255,1,1,207,207,207,3,3,
  206,206,205,203,203,7,21,203,203,203,201,199,203,203,202,206,206,206,202,206,
  203,202,203,205,199,202,199,202,203,203,30,1,206,206,206,255,1,13,242,242,
  205,206,202,202,202,203,199,201,206,206,203,204,204,15,2,202,202,203,203,18,
  15,203,203,203,203,204,205,206,199,199,202,204,203,204,205,205,206,206,255,0,
  12,207,207,206,207,205,203,203,202,199,199,206,206,203,203,19,1,203,203,203,
  21,10,199,199,204,206,202,199,202,203,202,203,205,205,33,1,241,241,241,255,0,
  1,207,207,207,2,2,205,205,205,205,5,6,203,203,201,199,201,206,202,202,22,6,
  207,207,202,199,199,199,203,203,30,4,203,203,206,205,207,207,255,1,9,205,205,
  204,204,206,203,199,199,202,203,203,11,3,203,203,203,205,205,17,1,206,206,
  206,21,12,203,203,203,206,199,199,201,203,199,203,203,206,206,206,34,1,207,
  207,207,255,0,10,207,207,206,206,205,203,205,203,202,203,206,206,12,2,206,
  206,203,203,16,3,206,206,203,207,207,20,9,203,203,202,205,203,201,201,202,
  203,202,202,31,2,205,205,205,205,255,0,1,206,206,206,2,9,206,206,203,202,203,
  202,199,201,206,203,203,16,17,203,203,203,203,205,206,203,203,202,199,199,
  202,202,202,203,203,206,206,206,34,1,206,206,206,255,0,11,207,207,241,204,
  203,203,202,199,199,201,205,205,205,13,1,202,202,202,15,17,205,205,206,203,
  207,204,203,203,202,201,201,199,203,202,204,202,204,205,205,34,1,207,207,207,
  255,1,4,241,241,206,203,202,202,6,1,201,201,201,8,4,203,203,204,205,203,203,
  15,14,203,203,205,203,203,206,205,206,201,201,198,202,204,202,203,203,33,2,
  207,207,207,207,255,0,1,243,243,243,2,12,206,206,203,202,202,202,199,201,199,
  203,206,202,202,202,15,20,203,203,203,203,203,206,203,205,199,199,203,203,
  204,202,204,205,241,207,242,206,207,207,255,0,7,243,243,241,206,205,203,202,
  202,202,8,23,201,201,199,201,206,203,203,206,204,206,206,206,203,199,199,201,
  202,203,203,201,199,203,205,207,207,255,2,3,207,207,206,205,205,7,25,202,202,
  199,199,199,198,202,207,205,205,205,199,198,199,201,201,203,203,203,203,203,
  203,204,206,205,207,207,255,4,25,204,204,205,206,202,203,201,199,201,202,199,
  199,203,203,202,201,199,202,199,203,203,203,202,206,203,205,205,30,1,205,205,
  205,33,1,242,242,242,255,1,5,241,241,205,206,205,206,206,7,21,205,205,203,
  199,203,203,201,201,201,201,203,199,201,201,199,202,203,202,202,201,203,203,
  203,29,2,205,205,206,206,32,1,207,207,207,255,1,2,241,241,207,207,4,2,205,
  205,205,205,7,22,205,205,204,203,203,203,202,201,199,201,198,203,199,201,199,
  203,203,203,201,199,199,203,203,203,30,1,205,205,205,32,2,207,207,241,241,
  255,4,24,206,206,205,206,205,205,206,202,203,201,202,199,199,202,202,203,199,
  203,202,203,203,201,202,204,203,203,29,1,205,205,205,32,1,241,241,241,255,4,
  4,206,206,205,205,206,206,9,2,205,205,205,205,12,14,203,203,203,203,204,203,
  204,203,204,201,203,202,206,201,202,202,28,2,204,204,206,206,32,1,243,243,
  243,255,4,20,206,206,206,241,241,207,205,207,206,205,203,199,203,203,202,202,
  206,203,202,203,202,202,25,2,203,203,205,205,28,2,205,205,207,207,31,1,207,
  207,207,255,5,12,207,207,206,206,205,206,205,207,205,205,203,202,202,202,18,
  5,205,205,201,203,203,205,205,24,1,203,203,203,27,2,206,206,207,207,31,1,207,
  207,207,255,5,3,206,206,207,206,206,9,5,202,202,205,206,206,206,206,15,11,
  204,204,203,203,203,203,203,205,205,206,206,206,206,27,1,207,207,207,29,2,
  207,207,241,241,255,7,1,207,207,207,9,2,206,206,207,207,12,4,207,207,204,203,
  203,203,17,8,203,203,202,202,205,205,206,206,207,207,26,2,206,206,206,206,
  255,9,6,241,241,207,206,242,205,205,205,16,8,203,203,203,202,205,205,206,207,
  206,206,28,1,207,207,207,255,11,1,207,207,207,13,7,205,205,205,205,205,204,
  206,206,206,21,1,207,207,207,23,2,207,207,241,241,255,12,1,242,242,242,14,1,
  206,206,206,16,7,206,206,206,206,206,206,241,207,207,255,13,6,241,241,207,
  241,207,241,241,241,20,1,242,242,242,255,
};

static const char pls2e0[] = { // 2022/07/05 Freedoom lump
  49,0,44,0,25,0,34,0,204,0,0,0,215,0,0,0,237,0,0,0,33,1,0,0,84,1,0,0,137,1,0,
  0,192,1,0,0,234,1,0,0,37,2,0,0,69,2,0,0,116,2,0,0,156,2,0,0,208,2,0,0,1,3,0,
  0,47,3,0,0,88,3,0,0,137,3,0,0,177,3,0,0,240,3,0,0,28,4,0,0,65,4,0,0,111,4,0,
  0,151,4,0,0,184,4,0,0,221,4,0,0,11,5,0,0,49,5,0,0,94,5,0,0,127,5,0,0,174,5,0,
  0,231,5,0,0,27,6,0,0,75,6,0,0,119,6,0,0,179,6,0,0,234,6,0,0,28,7,0,0,77,7,0,
  0,142,7,0,0,202,7,0,0,11,8,0,0,73,8,0,0,142,8,0,0,196,8,0,0,251,8,0,0,48,9,0,
  0,77,9,0,0,119,9,0,0,141,9,0,0,27,1,207,207,207,30,1,207,207,207,255,6,2,241,
  241,206,206,13,1,206,206,206,28,1,241,241,241,36,1,242,242,242,255,7,1,207,
  207,207,10,1,241,241,241,12,1,207,207,207,18,2,241,241,207,207,21,4,206,206,
  207,241,241,241,26,1,207,207,207,28,1,242,242,242,30,3,241,241,207,242,242,
  39,1,207,207,207,255,9,1,241,241,241,13,1,206,206,206,16,4,241,241,242,241,
  205,205,21,1,206,206,206,23,4,206,206,207,207,206,206,29,3,206,206,206,206,
  206,33,2,207,207,207,207,36,2,242,242,207,207,255,3,1,207,207,207,7,2,206,
  206,207,207,12,1,207,207,207,16,4,206,206,241,206,207,207,21,11,205,205,205,
  205,206,206,206,206,206,207,206,207,207,33,1,206,206,206,35,4,205,205,204,
  206,241,241,255,5,1,207,207,207,10,1,207,207,207,12,1,206,206,206,14,4,242,
  242,241,241,242,242,19,5,207,207,205,207,205,206,206,25,1,207,207,207,27,4,
  206,206,205,206,241,241,35,5,207,207,241,206,206,241,241,255,12,1,207,207,
  207,14,8,207,207,241,241,206,207,205,207,203,203,23,1,241,241,241,26,3,206,
  206,204,206,206,32,1,207,207,207,37,3,241,241,205,242,242,255,0,1,206,206,
  206,9,2,241,241,241,241,12,7,242,242,241,207,207,206,205,206,206,21,1,204,
  204,204,23,1,207,207,207,25,6,205,205,205,204,205,206,205,205,32,1,207,207,
  207,34,7,207,207,206,207,205,243,205,207,207,255,10,9,206,206,242,241,207,
  207,206,205,206,206,206,24,1,205,205,205,26,1,202,202,202,35,4,207,207,207,
  207,241,241,255,10,3,207,207,207,241,241,14,1,207,207,207,16,2,204,204,206,
  206,19,1,205,205,205,24,3,206,206,203,202,202,29,1,205,205,205,35,2,207,207,
  206,206,38,1,206,206,206,255,3,1,242,242,242,5,2,242,242,207,207,10,5,207,
  207,242,241,207,205,205,17,4,205,205,205,207,241,241,31,2,207,207,207,207,36,
  1,241,241,241,255,9,1,243,243,243,12,2,207,207,206,206,15,3,206,206,206,241,
  241,21,1,207,207,207,23,1,206,206,206,25,3,206,206,203,204,204,30,2,205,205,
  206,206,34,1,207,207,207,36,1,241,241,241,255,9,8,243,243,241,207,205,205,
  206,203,205,205,18,2,204,204,206,206,26,2,204,204,207,207,30,2,203,203,241,
  241,33,1,207,207,207,35,4,207,207,242,207,206,206,40,1,206,206,206,255,10,1,
  206,206,206,13,1,205,205,205,18,1,207,207,207,23,1,205,205,205,25,1,205,205,
  205,27,4,202,202,206,207,205,205,34,8,241,241,207,207,241,207,207,206,241,
  241,255,12,1,207,207,207,14,1,207,207,207,18,1,241,241,241,22,2,205,205,205,
  205,26,2,207,207,202,202,29,1,207,207,207,34,4,241,241,242,207,241,241,255,5,
  2,207,207,241,241,10,2,206,206,206,206,13,2,241,241,205,205,17,5,241,241,241,
  206,207,207,207,25,1,204,204,204,28,2,241,241,199,199,36,1,207,207,207,42,1,
  206,206,206,255,5,4,241,241,207,206,206,206,10,1,207,207,207,17,1,205,205,
  205,21,1,199,199,199,27,1,206,206,206,32,1,207,207,207,35,2,207,207,207,207,
  255,5,2,242,242,207,207,10,1,207,207,207,12,1,206,206,206,14,1,203,203,203,
  16,1,207,207,207,18,1,207,207,207,22,1,204,204,204,24,2,202,202,207,207,27,2,
  205,205,241,241,32,2,207,207,206,206,35,4,207,207,206,207,206,206,255,4,1,
  242,242,242,7,1,205,205,205,12,1,241,241,241,15,1,206,206,206,25,2,206,206,
  206,206,31,1,242,242,242,33,1,203,203,203,37,3,205,205,206,242,242,255,3,7,
  207,207,241,205,205,202,203,205,205,29,2,207,207,203,203,32,1,203,203,203,34,
  1,203,203,203,36,5,205,205,205,206,207,243,243,255,2,2,207,207,242,242,5,7,
  205,205,204,203,207,202,206,207,207,26,1,206,206,206,32,1,207,207,207,35,1,
  203,203,203,37,4,205,205,207,206,241,241,42,1,242,242,242,255,1,7,241,241,
  207,207,206,206,203,241,241,9,1,201,201,201,28,1,207,207,207,31,1,202,202,
  202,36,2,207,207,206,206,39,3,205,205,207,207,207,255,2,3,207,207,241,204,
  204,7,4,203,203,207,207,206,206,33,2,204,204,202,202,36,2,202,202,203,203,39,
  1,206,206,206,255,2,3,241,241,206,206,206,8,3,205,205,202,206,206,19,1,241,
  241,241,23,1,207,207,207,32,8,206,206,203,201,203,202,204,205,206,206,255,1,
  3,206,206,206,206,206,6,1,206,206,206,8,1,203,203,203,13,1,207,207,207,19,1,
  206,206,206,31,2,206,206,205,205,35,1,207,207,207,38,3,205,205,206,207,207,
  255,2,6,207,207,205,206,205,205,203,203,10,1,205,205,205,26,1,206,206,206,32,
  3,205,205,204,202,202,38,1,204,204,204,40,1,207,207,207,255,2,7,207,207,206,
  206,205,199,205,204,204,10,1,203,203,203,14,1,207,207,207,31,2,202,202,205,
  205,35,3,203,203,202,203,203,39,1,207,207,207,41,1,241,241,241,255,4,5,206,
  206,203,202,207,207,207,10,1,205,205,205,15,1,241,241,241,33,3,241,241,199,
  203,203,37,2,207,207,241,241,255,0,1,207,207,207,2,1,207,207,207,4,4,205,205,
  203,203,202,202,9,2,206,206,205,205,12,1,206,206,206,20,1,207,207,207,30,1,
  205,205,205,33,3,202,202,241,202,202,255,2,2,206,206,207,207,6,1,203,203,203,
  9,1,205,205,205,11,3,242,242,204,206,206,19,1,241,241,241,28,1,207,207,207,
  32,3,241,241,242,203,203,36,2,207,207,207,207,39,1,207,207,207,41,1,207,207,
  207,255,0,1,241,241,241,6,2,205,205,241,241,9,1,206,206,206,12,1,206,206,206,
  18,4,241,241,207,242,242,242,30,2,205,205,205,205,33,2,202,202,206,206,36,1,
  205,205,205,39,1,242,242,242,255,2,3,241,241,207,206,206,6,1,203,203,203,8,2,
  202,202,242,242,14,2,242,242,207,207,32,3,204,204,205,203,203,36,1,205,205,
  205,39,2,206,206,242,242,42,1,206,206,206,255,4,1,206,206,206,6,1,207,207,
  207,8,2,203,203,207,207,12,1,205,205,205,27,2,207,207,206,206,30,7,203,203,
  204,207,204,207,204,207,207,40,1,207,207,207,255,3,1,207,207,207,5,1,241,241,
  241,7,3,241,241,205,241,241,11,1,207,207,207,13,2,241,241,206,206,17,1,207,
  207,207,19,1,207,207,207,29,1,207,207,207,32,6,203,203,203,205,241,207,204,
  204,39,2,205,205,207,207,255,3,1,206,206,206,8,4,205,205,205,205,241,241,13,
  1,207,207,207,15,1,203,203,203,20,2,242,242,207,207,29,3,203,203,242,202,202,
  35,3,205,205,205,205,205,39,2,205,205,206,206,42,1,207,207,207,255,3,8,207,
  207,207,205,205,206,205,207,205,205,13,1,207,207,207,17,1,241,241,241,22,2,
  207,207,207,207,25,2,205,205,207,207,30,11,206,206,241,202,203,203,206,241,
  205,207,207,207,207,255,5,1,241,241,241,7,5,206,206,205,206,206,241,241,16,4,
  204,204,207,204,205,205,25,1,202,202,202,28,2,202,202,205,205,32,1,241,241,
  241,34,1,207,207,207,36,1,205,205,205,255,6,2,207,207,206,206,10,4,204,204,
  206,206,205,205,16,2,206,206,203,203,19,1,243,243,243,21,3,205,205,206,203,
  203,25,1,205,205,205,27,3,207,207,206,207,207,31,1,242,242,242,33,1,206,206,
  206,38,1,207,207,207,40,1,207,207,207,255,6,9,206,206,207,205,241,241,242,
  207,206,207,207,16,1,202,202,202,20,1,203,203,203,23,1,203,203,203,25,2,241,
  241,204,204,28,1,202,202,202,30,1,203,203,203,32,6,205,205,205,205,207,207,
  241,241,39,1,241,241,241,255,7,4,207,207,241,206,206,206,12,2,242,242,241,
  241,15,2,205,205,203,203,18,1,203,203,203,20,1,202,202,202,22,1,202,202,202,
  24,2,204,204,202,202,28,1,202,202,202,31,1,205,205,205,33,3,206,206,207,207,
  207,42,2,207,207,207,207,255,4,2,207,207,206,206,7,5,207,207,207,206,205,205,
  205,14,4,205,205,206,206,241,241,19,7,241,241,203,202,202,204,203,203,203,27,
  1,203,203,203,29,1,207,207,207,32,3,205,205,206,241,241,37,1,241,241,241,40,
  1,207,207,207,255,5,3,207,207,207,207,207,9,1,206,206,206,11,3,206,206,206,
  207,207,15,1,207,207,207,17,1,202,202,202,19,1,202,202,202,21,2,202,202,202,
  202,24,4,203,203,203,204,205,205,30,5,205,205,205,207,206,207,207,36,2,207,
  207,206,206,41,1,207,207,207,255,2,1,207,207,207,9,1,241,241,241,11,2,204,
  204,203,203,14,3,205,205,206,206,206,18,2,202,202,202,202,24,10,203,203,206,
  207,242,206,207,206,207,207,206,206,37,1,207,207,207,39,1,206,206,206,255,4,
  2,206,206,205,205,8,1,207,207,207,10,3,241,241,207,206,206,17,2,241,241,206,
  206,20,2,202,202,202,202,23,1,203,203,203,25,10,207,207,206,206,241,241,207,
  205,206,241,242,242,39,1,241,241,241,255,2,1,207,207,207,4,1,207,207,207,13,
  1,206,206,206,16,1,207,207,207,19,3,204,204,241,202,202,23,1,207,207,207,27,
  6,207,207,241,241,242,207,241,241,34,1,241,241,241,37,1,241,241,241,255,14,1,
  207,207,207,16,9,242,242,205,205,205,205,206,205,207,241,241,29,1,207,207,
  207,37,1,241,241,241,255,12,1,207,207,207,15,5,207,207,242,206,206,206,206,
  21,3,206,206,206,207,207,28,1,207,207,207,31,1,241,241,241,39,1,243,243,243,
  42,1,206,206,206,255,0,1,206,206,206,7,1,207,207,207,16,1,207,207,207,18,2,
  207,207,243,243,255,22,1,241,241,241,32,2,207,207,207,207,255,
};
#endif /* BETA */

// killough 1/31/98: 
// Table of predefined lumps, used to make up for any wad deficiencies.
// Always overriden by iwad or pwads.

// see also the lump definitions above for additional comments

const lumpinfo_t predefined_lumps[]={
  { "M_HORSEN", sizeof m_horsen, m_horsen },
  { "M_VERSEN", sizeof m_versen, m_versen },
  { "M_COMPAT", sizeof m_compat, m_compat },   // killough 10/98
  { "M_GENERL", sizeof m_generl, m_generl },   // killough 10/98

  { "STBR123",  sizeof stbr123, stbr123 }, //jff 02/16/98 bargraph patches
  { "STBR124",  sizeof stbr124, stbr124 },
  { "STBR125",  sizeof stbr125, stbr125 },
  { "STBR126",  sizeof stbr126, stbr126 },
  { "STBR127",  sizeof stbr127, stbr127 },
  { "DIG0",     sizeof dig0, dig0 }, //jff 02/20/98 smaller digit patches
  { "DIG1",     sizeof dig1, dig1 },
  { "DIG2",     sizeof dig2, dig2 },
  { "DIG3",     sizeof dig3, dig3 },
  { "DIG4",     sizeof dig4, dig4 },
  { "DIG5",     sizeof dig5, dig5 },
  { "DIG6",     sizeof dig6, dig6 },
  { "DIG7",     sizeof dig7, dig7 },
  { "DIG8",     sizeof dig8, dig8 },
  { "DIG9",     sizeof dig9, dig9 },
  { "DIGA",     sizeof diga, diga }, //jff 2/22/98 full new smaller hud font
  { "DIGB",     sizeof digb, digb },
  { "DIGC",     sizeof digc, digc },
  { "DIGD",     sizeof digd, digd },
  { "DIGE",     sizeof dige, dige },
  { "DIGF",     sizeof digf, digf },
  { "DIGG",     sizeof digg, digg },
  { "DIGH",     sizeof digh, digh },
  { "DIGI",     sizeof digi, digi },
  { "DIGJ",     sizeof digj, digj },
  { "DIGK",     sizeof digk, digk },
  { "DIGL",     sizeof digl, digl },
  { "DIGM",     sizeof digm, digm },
  { "DIGN",     sizeof dign, dign },
  { "DIGO",     sizeof digo, digo },
  { "DIGP",     sizeof digp, digp },
  { "DIGQ",     sizeof digq, digq },
  { "DIGR",     sizeof digr, digr },
  { "DIGS",     sizeof digs, digs },
  { "DIGT",     sizeof digt, digt },
  { "DIGU",     sizeof digu, digu },
  { "DIGV",     sizeof digv, digv },
  { "DIGW",     sizeof digw, digw },
  { "DIGX",     sizeof digx, digx },
  { "DIGY",     sizeof digy, digy },
  { "DIGZ",     sizeof digz, digz },
  { "DIG45",    sizeof dig45, dig45 },        //jff 3/3/98 add minus sign
  { "DIG47",    sizeof dig47, dig47 },
  { "DIG58",    sizeof dig58, dig58 },
  { "DIG91",    sizeof dig91, dig91 },
  { "DIG93",    sizeof dig93, dig93 },
  { "STKEYS6",  sizeof stkeys6, stkeys6 }, //jff 2/24/98 double key graphics
  { "STKEYS7",  sizeof stkeys7, stkeys7 },
  { "STKEYS8",  sizeof stkeys8, stkeys8 },
  { "BOXUL",    sizeof boxul, boxul }, //jff 2/26/98 background window graphics
  { "BOXUC",    sizeof boxuc, boxuc },
  { "BOXUR",    sizeof boxur, boxur },
  { "BOXCL",    sizeof boxcl, boxcl },
  { "BOXCC",    sizeof boxcc, boxcc },
  { "BOXCR",    sizeof boxcr, boxcr },
  { "BOXLL",    sizeof boxll, boxll },
  { "BOXLC",    sizeof boxlc, boxlc },
  { "BOXLR",    sizeof boxlr, boxlr },
  
  // killough 8/98: remove ENDBOOM lump, use id's ENDOOM instead

  { "S_START"},                              // killough 3/21/98
  { "TNT1A0",   sizeof invis_sprite, invis_sprite },            // invis sprite

#ifdef DOGS
  // killough 7/19/98: Marine's best friend :)
  {"DOGSD5", sizeof dogsd5, dogsd5},
  {"DOGSH5", sizeof dogsd5, dogsd5},
  {"DOGSC5", sizeof dogsc5, dogsc5},
  {"DOGSG5", sizeof dogsc5, dogsc5},
  {"DOGSB1", sizeof dogsb1, dogsb1},
  {"DOGSA5", sizeof dogsa5, dogsa5},
  {"DOGSE5", sizeof dogsa5, dogsa5},
  {"DOGSC1", sizeof dogsc1, dogsc1},
  {"DOGSD1", sizeof dogsd1, dogsd1},
  {"DOGSB5", sizeof dogsb5, dogsb5},
  {"DOGSF5", sizeof dogsb5, dogsb5},
  {"DOGSA1", sizeof dogsa1, dogsa1},
  {"DOGSE1", sizeof dogsa1, dogsa1},
  {"DOGSF1", sizeof dogsf1, dogsf1},
  {"DOGSD2D8", sizeof dogsd2d8, dogsd2d8},
  {"DOGSH2", sizeof dogsd2d8, dogsd2d8},
  {"DOGSG1", sizeof dogsg1, dogsg1},
  {"DOGSH8", sizeof dogsh8, dogsh8},
  {"DOGSE8", sizeof dogse8, dogse8},
  {"DOGSD4D6", sizeof dogsd4d6, dogsd4d6},
  {"DOGSH4", sizeof dogsd4d6, dogsd4d6},
  {"DOGSA2A8", sizeof dogsa2a8, dogsa2a8},
  {"DOGSE2", sizeof dogsa2a8, dogsa2a8},
  {"DOGSF8", sizeof dogsf8, dogsf8},
  {"DOGSH1", sizeof dogsh1, dogsh1},
  {"DOGSA4A6", sizeof dogsa4a6, dogsa4a6},
  {"DOGSE4", sizeof dogsa4a6, dogsa4a6},
  {"DOGSB4B6", sizeof dogsb4b6, dogsb4b6},
  {"DOGSF4", sizeof dogsb4b6, dogsb4b6},
  {"DOGSH6", sizeof dogsh6, dogsh6},
  {"DOGSB2B8", sizeof dogsb2b8, dogsb2b8},
  {"DOGSF2", sizeof dogsb2b8, dogsb2b8},
  {"DOGSC2C8", sizeof dogsc2c8, dogsc2c8},
  {"DOGSG2", sizeof dogsc2c8, dogsc2c8},
  {"DOGSG6", sizeof dogsg6, dogsg6},
  {"DOGSC4C6", sizeof dogsc4c6, dogsc4c6},
  {"DOGSG4", sizeof dogsc4c6, dogsc4c6},
  {"DOGSG8", sizeof dogsg8, dogsg8},
  {"DOGSF6", sizeof dogsf6, dogsf6},
  {"DOGSN0", sizeof dogsn0, dogsn0},
  {"DOGSE6", sizeof dogse6, dogse6},
  {"DOGSD3D7", sizeof dogsd3d7, dogsd3d7},
  {"DOGSH3", sizeof dogsd3d7, dogsd3d7},
  {"DOGSH7", sizeof dogsh7, dogsh7},
  {"DOGSI0", sizeof dogsi0, dogsi0},
  {"DOGSA3A7", sizeof dogsa3a7, dogsa3a7},
  {"DOGSE3", sizeof dogsa3a7, dogsa3a7},
  {"DOGSB3B7", sizeof dogsb3b7, dogsb3b7},
  {"DOGSF3", sizeof dogsb3b7, dogsb3b7},
  {"DOGSF7", sizeof dogsf7, dogsf7},
  {"DOGSE7", sizeof dogse7, dogse7},
  {"DOGSC3C7", sizeof dogsc3c7, dogsc3c7},
  {"DOGSG3", sizeof dogsc3c7, dogsc3c7},
  {"DOGSG7", sizeof dogsg7, dogsg7},
  {"DOGSJ0", sizeof dogsj0, dogsj0},
  {"DOGSK0", sizeof dogsj0, dogsj0},
  {"DOGSL0", sizeof dogsl0, dogsl0},
  {"DOGSM0", sizeof dogsl0, dogsl0},
#endif

#ifdef BETA
  // killough 7/19/98: Pre-Beta BFG fireballs
  {"PLS1A0", sizeof pls1a0, pls1a0},
  {"PLS1B0", sizeof pls1b0, pls1b0},
  {"PLS1C0", sizeof pls1c0, pls1c0},
  {"PLS1D0", sizeof pls1d0, pls1d0},
  {"PLS1E0", sizeof pls1e0, pls1e0},
  {"PLS1F0", sizeof pls1f0, pls1f0},
  {"PLS1G0", sizeof pls1g0, pls1g0},
  {"PLS2A0", sizeof pls2a0, pls2a0},
  {"PLS2B0", sizeof pls2b0, pls2b0},
  {"PLS2C0", sizeof pls2c0, pls2c0},
  {"PLS2D0", sizeof pls2d0, pls2d0},
  {"PLS2E0", sizeof pls2e0, pls2e0},
#endif

  // end of sprites
  { "S_END"},                          // phares 3/9/98    killough 3/21/98

#ifdef DOGS
  {"DSDGSIT", sizeof dsdgsit, dsdgsit},
  {"DSDGATK", sizeof dsdgatk, dsdgatk},
  {"DSDGACT", sizeof dsdgact, dsdgact},
  {"DSDGDTH", sizeof dsdgdth, dsdgdth},
  {"DSDGPAIN", sizeof dsdgpain, dsdgpain},
  {"DOGOVRLY", sizeof dogovrly, dogovrly},
#endif

  { "SWITCHES", sizeof switches, switches},   // jff 3/23/98 switch list
  { "ANIMATED", sizeof animated, animated},   // jff 3/23/98 animation list
  { "M_SETUP" , sizeof m_setup,  m_setup },   // phares 3/24/98 menu item
  { "M_KEYBND", sizeof m_keybnd, m_keybnd},   // phares 3/24/98 menu item
  { "M_AUTO"  , sizeof m_auto,   m_auto  },   // phares 3/30/98 menu item
  { "M_CHAT"  , sizeof m_chat,   m_chat  },   // phares 4/10/98 menu item
  { "M_ENEM",   sizeof m_enem,   m_enem  },   // phares 4/08/98 menu item
  { "M_STAT",   sizeof m_stat,   m_stat  },   // phares 3/29/98 menu item
  { "M_WEAP",   sizeof m_weap,   m_weap  },   // phares 3/28/98 menu item
  { "M_MESS"  , sizeof m_mess,   m_mess  },   // phares 4/08/98 menu item
  { "M_COLORS", sizeof m_colors, m_colors},   // phares 4/01/98 menu item
  { "M_PALNO",  sizeof m_palno,  m_palno},    // phares 4/01/98 menu item
  { "C_START" },  // killough 4/4/98: colormap markers
  { "WATERMAP", sizeof watermap, watermap},   // killough 3/21/98, 4/4/98
  { "C_END" },    // killough 4/4/98: end colormap markers
  { "STCFN096", sizeof stcfn096, stcfn096},   // jff 4/5/98 missing char
  { "M_BUTT1",  sizeof m_butt1,  m_butt1},    // phares 4/16/98 reset button
  { "M_BUTT2",  sizeof m_butt2,  m_butt2},    // phares 4/16/98 reset button
  { "CRBRICK",  sizeof cr_brick, cr_brick},   // jff 4/24/98 brick color range
  { "CRTAN",    sizeof cr_tan,   cr_tan},     // jff 4/24/98 tan color range
  { "CRGRAY",   sizeof cr_gray,  cr_gray},    // jff 4/24/98 gray color range
  { "CRGREEN",  sizeof cr_green, cr_green},   // jff 4/24/98 green color range
  { "CRBROWN",  sizeof cr_brown, cr_brown},   // jff 4/24/98 brown color range
  { "CRGOLD",   sizeof cr_gold,  cr_gold},    // jff 4/24/98 gold color range
  { "CRRED",    sizeof cr_red,   cr_red},     // jff 4/24/98 red color range
  { "CRBLUE",   sizeof cr_blue,  cr_blue},    // jff 4/24/98 blue color range
  { "CRBLUE2",  sizeof cr_blue2, cr_blue2},   // jff 4/24/98 blue2 color range
  { "CRORANGE", sizeof cr_orange,cr_orange},  // jff 4/24/98 orange color range
  { "CRYELLOW", sizeof cr_yellow,cr_yellow},  // jff 4/24/98 yellow color range
  { "MBFTEXT",  sizeof mbftext, mbftext},     // killough 11/98: mbf title text
};

// Calculate how many of them there are
const size_t num_predefined_lumps =
  sizeof predefined_lumps / sizeof *predefined_lumps;

//----------------------------------------------------------------------------
//
// $Log: info.c,v $
// Revision 1.2  2000-08-12 21:29:25  fraggle
// change license header
//
// Revision 1.1.1.1  2000/07/29 13:20:39  fraggle
// imported sources
//
// Revision 1.44  1998/05/12  12:46:36  phares
// Removed OVER_UNDER code
//
// Revision 1.43  1998/05/12  09:35:07  phares
// Corrected 4001->5001 and 4002->5002 in OVER/UNDER table
//
// Revision 1.42  1998/05/12  08:41:13  jim
// fix decl of endboom
//
// Revision 1.40  1998/05/11  12:21:20  jim
// 4001/2 deconflicted with DosDOOM
//
// Revision 1.39  1998/05/06  11:30:54  jim
// Moved predefined lump writer info->w_wad
//
// Revision 1.38  1998/05/04  21:34:49  thldrmn
// commenting and reformatting
//
// Revision 1.37  1998/05/03  23:23:50  killough
// Fix #includes at the top, nothing else
//
// Revision 1.36  1998/04/29  09:20:37  jim
// New ENDBOOM
//
// Revision 1.35  1998/04/27  02:15:10  killough
// Fix cr_gold declaration, add missing v1.1 lumps
//
// Revision 1.34  1998/04/24  08:08:36  jim
// Make text translate tables lumps
//
// Revision 1.33  1998/04/22  13:45:37  phares
// Added Setup screen Reset to Defaults
//
// Revision 1.32  1998/04/22  06:34:43  killough
// Make WritePredefinedLumpWad endian-independent, remove tabs
//
// Revision 1.31  1998/04/21  23:46:21  jim
// Predefined lump dumper option
//
// Revision 1.30  1998/04/17  00:04:11  jim
// text file changes and new ENDBOOM
//
// Revision 1.29  1998/04/12  22:54:55  phares
// Remaining 3 Setup screens
//
// Revision 1.28  1998/04/06  04:36:51  killough
// Change WATERMAP, add C_START/C_END
//
// Revision 1.27  1998/04/05  10:10:13  jim
// added STCFN096 lump
//
// Revision 1.26  1998/04/03  19:18:46  phares
// Automap Palette work, slot 0 = disable, 247 = BLACK
//
// Revision 1.25  1998/04/02  05:01:49  jim
// Added ENDOOM, BOOM.TXT mods
//
// Revision 1.24  1998/04/01  15:34:30  phares
// Added Automap Setup Screen, fixed Seg Viol in Setup Menus
//
// Revision 1.23  1998/03/31  01:08:26  phares
// Initial Setup screens and Extended HELP screens
//
// Revision 1.22  1998/03/23  18:39:10  jim
// Switch and animation tables now lumps
//
// Revision 1.21  1998/03/23  15:23:54  phares
// Changed pushers to linedef control
//
// Revision 1.20  1998/03/23  03:18:09  killough
// Add WATERMAP colormap lump for underwater viewing
//
// Revision 1.19  1998/03/09  18:30:28  phares
// Added invisible sprite for MT_PUSH
//
// Revision 1.18  1998/03/09  07:15:14  killough
// Remove unnecessary translucency lumps
//
// Revision 1.17  1998/03/04  22:23:04  phares
// Removed BOOMHELP predefined lump
//
// Revision 1.16  1998/03/04  11:52:43  jim
// Add TRAN50 TRAN66 predefined lumps
//
// Revision 1.15  1998/03/03  00:21:54  jim
// Added predefined ENDBETA lump for beta test
//
// Revision 1.13  1998/02/27  11:51:50  jim
// Add predefined lump STTMINUS
//
// Revision 1.11  1998/02/24  08:45:44  phares
// Pushers, recoil, new friction, and over/under work
//
// Revision 1.10  1998/02/24  04:13:37  jim
// Added double keys to status
//
// Revision 1.8  1998/02/23  04:31:13  killough
// Make tranlucency apply realistically
//
// Revision 1.7  1998/02/22  12:51:38  jim
// HUD control on F5, z coord, spacing change
//
// Revision 1.5  1998/02/20  21:56:49  phares
// Preliminarey sprite translucency
//
// Revision 1.4  1998/02/18  00:59:44  jim
// Addition of HUD
//
// Revision 1.3  1998/02/02  13:36:12  killough
// Add predefined lumps
//
// Revision 1.2  1998/01/26  19:23:34  phares
// First rev with no ^Ms
//
// Revision 1.1.1.1  1998/01/19  14:02:56  rand
// Lee's Jan 19 sources
//
//----------------------------------------------------------------------------
