// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: d_englsh.h,v 1.2 2000-08-12 21:29:25 fraggle Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// DESCRIPTION:
//  Printed strings for translation.
//  English language support (default).
//  See dstrings.h for suggestions about foreign language BEX support
//
//-----------------------------------------------------------------------------

#ifndef __D_ENGLSH__
#define __D_ENGLSH__

//
//  Printed strings for translation
//

//
// D_Main.C
//
#define D_DEVSTR    "Development mode ON.\n"
#define D_CDROM     "CD-ROM Version: default.cfg from c:\\doomdata\n"

//
//  M_Menu.C
//
#define PRESSKEY    "press a key."
#define PRESSYN     "press y or n."
#define QUITMSG     "are you sure you want to\nquit this great game?"
#define LOADNET     "you can't do load while in a net game!\n\n"PRESSKEY
#define QLOADNET    "you can't quickload during a netgame!\n\n"PRESSKEY
#define QSAVESPOT   "you haven't picked a quicksave slot yet!\n\n"PRESSKEY
#define SAVEDEAD    "you can't save if you aren't playing!\n\n"PRESSKEY
#define QSPROMPT    "quicksave over your game named\n\n'%s'?\n\n"PRESSYN
#define QLPROMPT    "do you want to quickload the game named\n\n'%s'?\n\n"PRESSYN

#define NEWGAME \
  "you can't start a new game\n"\
  "while in a network game.\n\n"PRESSKEY

#define NIGHTMARE \
  "an exercise in futility.\n"\
  "you will die.\n\n"\
  "wanna play? y or n.\n\n"

#define SWSTRING  \
  "this is the shareware version of doom.\n\n"\
  "you need to order the entire trilogy.\n\n"PRESSKEY

#define MSGOFF      "Messages OFF"
#define MSGON       "Messages ON"
#define NETEND      "you can't end a netgame!\n\n"PRESSKEY
#define ENDGAME     "are you sure you want to end the game?\n\n"PRESSYN

#define DOSY        "(press y to quit)"

#define DETAILHI    "High detail"
#define DETAILLO    "Low detail"
#define GAMMALVL0   "Gamma correction OFF"
#define GAMMALVL1   "Gamma correction level 1"
#define GAMMALVL2   "Gamma correction level 2"
#define GAMMALVL3   "Gamma correction level 3"
#define GAMMALVL4   "Gamma correction level 4"
#define EMPTYSTRING "empty slot"

//
//  P_inter.C
//
#define GOTARMOR    "Found ringmail armor."
#define GOTMEGA     "Found platemail armor."
#define GOTHTHBONUS "Found medicinal herb."
#define GOTARMBONUS "Found an armor patch."
#define GOTSTIM     "Found health essence."
#define GOTMEDINEED "Found health that you REALLY needed"
#define GOTMEDIKIT  "Found bottled health."
#define GOTSUPER    "Shamans brew"

#define GOTBLUECARD "Picked up a blue key."
#define GOTYELWCARD "Picked up a yellow key."
#define GOTREDCARD  "Picked up a red key."
#define GOTBLUESKUL "You found a blue Z-Key!"
#define GOTYELWSKUL "You found a yellow Z-Key!"
#define GOTREDSKULL "You found a red Z-Key!"

#define GOTINVUL    "Ethereal Guard"
#define GOTBERSERK  "WODE!"
#define GOTINVIS    "Cloak of deceit."
#define GOTSUIT     "Boots of Protection."
#define GOTMAP      "A map of the area."

#define GOTVISOR    "A torch!"

#define GOTMSPHERE  "Body Armor!"

#define GOTCLIP     "Captured a soul."
#define GOTCLIPBOX  "Found a soul prism."
#define GOTROCKET   "Found a rune."
#define GOTROCKBOX  "Found a stack of runes."
#define GOTCELL     "Captured a mana sprite."
#define GOTCELLBOX  "Found a mana seal."
#define GOTSHELLS   "Found some steelshot."
#define GOTSHELLBOX "Found a sack of steelshot."

#define GOTBACKPACK "Found a sack of carrying!"

#define GOTBFG9000  "BLESSING OF THE GODS!"
#define GOTCHAINGUN "Soul launcher!"
#define GOTCHAINSAW "An axe!"
#define GOTLAUNCHER "Staff of rune explosion!"
#define GOTPLASMA   "Found a holy relic!"
#define GOTSHOTGUN  "A steelshot launcher!"
#define GOTSHOTGUN2 "You grab a Cryogun! FREEZE!"

//
// P_Doors.C
//
#define PD_BLUEO    "You need a blue key to activate this object"
#define PD_REDO     "You need a red key to activate this object"
#define PD_YELLOWO  "You need a yellow key to activate this object"
#define PD_BLUEK    "You need a blue key to open this door"
#define PD_REDK     "You need a red key to open this door"
#define PD_YELLOWK  "You need a yellow key to open this door"
//jff 02/05/98 Create messages specific to card and skull keys
#define PD_BLUEC    "You need a blue card to open this door"
#define PD_REDC     "You need a red card to open this door"
#define PD_YELLOWC  "You need a yellow card to open this door"
#define PD_BLUES    "You need a blue skull to open this door"
#define PD_REDS     "You need a red skull to open this door"
#define PD_YELLOWS  "You need a yellow skull to open this door"
#define PD_ANY      "Any key will open this door"
#define PD_ALL3     "You need all three keys to open this door"
#define PD_ALL6     "You need all six keys to open this door"

//
//  G_game.C
//
#define GGSAVED     "game saved."

//
//  HU_stuff.C
//
#define HUSTR_MSGU  "[Message unsent]"

#define HUSTR_E1M1  "E1M1:Sinking"
#define HUSTR_E1M2  "E1M2:Down"
#define HUSTR_E1M3  "E1M3:Flurrious"
#define HUSTR_E1M4  "E1M4:Blade Swamp"
#define HUSTR_E1M5  "E1M5:Fielding"
#define HUSTR_E1M6  "E1M6:Rampart"
#define HUSTR_E1M7  "E1M7:Dripstone Wharf"
#define HUSTR_E1M8  "E1M8:Hazardous Coast"
#define HUSTR_E1M9  "E1M9:Pop Some Hops"

#define HUSTR_E2M1  "E2M1:On Fire"
#define HUSTR_E2M2  "E2M2:Drained"
#define HUSTR_E2M3  "E2M3:Sequester"
#define HUSTR_E2M4  "E2M4:Metal"
#define HUSTR_E2M5  "E2M5:Marketplace"
#define HUSTR_E2M6  "E2M6:Magnus Avenue"
#define HUSTR_E2M7  "E2M7:Mistory"
#define HUSTR_E2M8  "E2M8:Audience"
#define HUSTR_E2M9  "E2M9:Addle"

#define HUSTR_E3M1  "E3M1:Isolation"
#define HUSTR_E3M2  "E3M2:Claustrophilia"
#define HUSTR_E3M3  "E3M3:Dungeon"
#define HUSTR_E3M4  "E3M4:Acrophobinox"
#define HUSTR_E3M5  "E3M5:Shine On"
#define HUSTR_E3M6  "E3M6:Seeing Red"
#define HUSTR_E3M7  "E3M7:Siege"
#define HUSTR_E3M8  "E3M8:Rok"
#define HUSTR_E3M9  "E3M9:Begin"

#define HUSTR_E4M1  "E4M1:Delusion"
#define HUSTR_E4M2  "E4M2:Ice Melt"
#define HUSTR_E4M3  "E4M3:Quick"
#define HUSTR_E4M4  "E4M4:Window Pain"
#define HUSTR_E4M5  "E4M5:Mal Arena"
#define HUSTR_E4M6  "E4M6:Cliffusion"
#define HUSTR_E4M7  "E4M7:Dance Macabre "
#define HUSTR_E4M8  "E4M8:Eyebrawl"
#define HUSTR_E4M9  "E4M9:Home"

#define HUSTR_1     "GenEmp Corp."
#define HUSTR_2     "Tunnel Town"
#define HUSTR_3     "Lava Annex"
#define HUSTR_4     "Alcatraz"
#define HUSTR_5     "Cyber Circus"
#define HUSTR_6     "Digi-Ota"
#define HUSTR_7     "The Great Wall"
#define HUSTR_8     "Garden of Delights"
#define HUSTR_9     "Hidden Fortress"
#define HUSTR_10    "Anarchist Dream"
#define HUSTR_11    "Notus Us!"
  
#define HUSTR_12    "Gothik Gauntlet"
#define HUSTR_13    "The Sewers"
#define HUSTR_14    "'Trode Wars"
#define HUSTR_15    "Twilight of Enk's"
#define HUSTR_16    "Protean Cybex"
#define HUSTR_17    "River of Blood"
#define HUSTR_18    "Bizarro"
#define HUSTR_19    "The War Rooms"
#define HUSTR_20    "Intruder Alert!"
  
#define HUSTR_21    "unused"
#define HUSTR_22    "unused"
#define HUSTR_23    "unused"
#define HUSTR_24    "unused"
#define HUSTR_25    "unused"
#define HUSTR_26    "unused"
#define HUSTR_27    "unused"
#define HUSTR_28    "unused"
#define HUSTR_29    "unused"
#define HUSTR_30    "unused"
  
#define HUSTR_31    "Desiccant Room"
#define HUSTR_32    "unused"

#define PHUSTR_1    "unused"
#define PHUSTR_2    "unused"
#define PHUSTR_3    "unused"
#define PHUSTR_4    "unused"
#define PHUSTR_5    "unused"
#define PHUSTR_6    "unused"
#define PHUSTR_7    "unused"
#define PHUSTR_8    "unused"
#define PHUSTR_9    "unused"
#define PHUSTR_10   "unused"
#define PHUSTR_11   "unused"
  
#define PHUSTR_12   "unused"
#define PHUSTR_13   "unused"
#define PHUSTR_14   "unused"
#define PHUSTR_15   "unused"
#define PHUSTR_16   "unused"
#define PHUSTR_17   "unused"
#define PHUSTR_18   "unused"
#define PHUSTR_19   "unused"
#define PHUSTR_20   "unused"
  
#define PHUSTR_21   "unused"
#define PHUSTR_22   "unusedn"
#define PHUSTR_23   "unused"
#define PHUSTR_24   "unused"
#define PHUSTR_25   "unused"
#define PHUSTR_26   "unused"
#define PHUSTR_27   "unused"
#define PHUSTR_28   "unused"
#define PHUSTR_29   "unused"
#define PHUSTR_30   "unused"
  
#define PHUSTR_31   "unused"
#define PHUSTR_32   "unused"
  
#define THUSTR_1    "unused"
#define THUSTR_2    "unused"
#define THUSTR_3    "unused"
#define THUSTR_4    "unused"
#define THUSTR_5    "unused"
#define THUSTR_6    "unused"
#define THUSTR_7    "unused"
#define THUSTR_8    "unused"
#define THUSTR_9    "unused"
#define THUSTR_10   "unused"
#define THUSTR_11   "unused"
  
#define THUSTR_12   "unused"
#define THUSTR_13   "unused"
#define THUSTR_14   "unused"
#define THUSTR_15   "unused"
#define THUSTR_16   "unused"
#define THUSTR_17   "unused"
#define THUSTR_18   "unused"
#define THUSTR_19   "unused"
#define THUSTR_20   "unused"
  
#define THUSTR_21   "unused"
#define THUSTR_22   "unused"
#define THUSTR_23   "unused"
#define THUSTR_24   "unused"
#define THUSTR_25   "unused"
#define THUSTR_26   "unused"
#define THUSTR_27   "unused"
#define THUSTR_28   "unused"
#define THUSTR_29   "unused"
#define THUSTR_30   "unused"
  
#define THUSTR_31   "unused"
#define THUSTR_32   "unused"

#define HUSTR_CHATMACRO1  "I'm ready to kick butt!"
#define HUSTR_CHATMACRO2  "I'm OK."
#define HUSTR_CHATMACRO3  "I'm not looking too good!"
#define HUSTR_CHATMACRO4  "Help!"
#define HUSTR_CHATMACRO5  "You suck!"
#define HUSTR_CHATMACRO6  "Next time, scumbag..."
#define HUSTR_CHATMACRO7  "Come here!"
#define HUSTR_CHATMACRO8  "I'll take care of it."
#define HUSTR_CHATMACRO9  "Yes"
#define HUSTR_CHATMACRO0  "No"

#define HUSTR_TALKTOSELF1 "You mumble to yourself"
#define HUSTR_TALKTOSELF2 "Who's there?"
#define HUSTR_TALKTOSELF3 "You scare yourself"
#define HUSTR_TALKTOSELF4 "You start to rave"
#define HUSTR_TALKTOSELF5 "You've lost it..."

#define HUSTR_MESSAGESENT "[Message Sent]"

// The following should NOT be changed unless it seems
// just AWFULLY necessary

#define HUSTR_PLRGREEN    "Green: "
#define HUSTR_PLRINDIGO   "Indigo: "
#define HUSTR_PLRBROWN    "Brown: "
#define HUSTR_PLRRED      "Red: "

#define HUSTR_KEYGREEN    'g'
#define HUSTR_KEYINDIGO   'i'
#define HUSTR_KEYBROWN    'b'
#define HUSTR_KEYRED      'r'

//
//  AM_map.C
//

#define AMSTR_FOLLOWON    "Follow Mode ON"
#define AMSTR_FOLLOWOFF   "Follow Mode OFF"

#define AMSTR_GRIDON      "Grid ON"
#define AMSTR_GRIDOFF     "Grid OFF"

#define AMSTR_MARKEDSPOT  "Marked Spot"
#define AMSTR_MARKSCLEARED  "All Marks Cleared"

//
//  ST_stuff.C
//

#define STSTR_MUS       "Song Change" // 2022/07/03 changed strings to add more flavour
#define STSTR_NOMUS     "IMPOSSIBLE SELECTION"
#define STSTR_DQDON     "You are invincible!"
#define STSTR_DQDOFF    "You get back to normal again"

#define STSTR_KFAADDED  "You get everything!"
#define STSTR_FAADDED   "Armed to the teeth!"

#define STSTR_NCON      "Walk through walls!"
#define STSTR_NCOFF     "Become tangible again"

#define STSTR_BEHOLD    "Your incantation does not seem to work"
#define STSTR_BEHOLDX   "Spell invoked"

#define STSTR_CHOPPERS  "... doesn't suck - GM"
#define STSTR_CLEV      "Changing Level..."

#define STSTR_COMPON    "Compatibility Mode On"            // phares
#define STSTR_COMPOFF   "Compatibility Mode Off"           // phares

//
//  F_Finale.C
//
#define E1TEXT \
  "You've been through war. The lone\n"\
  "survivor of a shipwreck of lost souls,\n"\
  "you made it home only to find home has\n"\
  "been dragged through hell.\n"\
  "\n"\
  "After killing your way through, you\n"\
  "wonder what caused this. What the hell\n"\
  "are these monsters, and where did they \n"\
  "come from?\n"\
  "\n"\
  "Across the sea you can just make out the\n"\
  "capital city. If anyone has answers, or\n"\
  "a plan, it's them. The only problem is\n"\
  "it's on fire.\n"\
  "\n"\
  "You steel yourself for what's next.\n"  
  
  
#define E2TEXT \
  "The sacrificial pit goes on for miles.\n"\
  "The king sought to use an army of the\n"\
  "dead to win what he saw as a hopeless\n"\
  "war, and abandoned all morals to\n"\
  "achieve it. The dead only saw an\n"\
  "opportunity.\n"\
  "\n"\
  "A dim light shines at the end of the\n"\
  "tunnel, and the pain you feel as you\n"\
  "move toward it is immeasurable. You\n"\
  "trudge to the end and wrench the\n"\
  "portal open.\n"\
  "\n"\
  "You don't know who or what is\n"\
  "coordinating the attack, but you'll\n"\
  "break him for what he's done."
  
  
#define E3TEXT \
  "The shattered remains of your foe lie\n"\
  "behind you. The invasion has been\n"\
  "stopped and vengeance is dealt.\n"\
  "\n"\
  "You walk into a blinding light as a\n"\
  "coldness overtakes your senses. A\n"\
  "heaviness leaves you.\n"\
  "\n"\
  "Where you go now is a matter of fate."
  
  
#define E4TEXT \
  "Did you have fun?  Did you kill all the\n"\
  "monsters?  Did you save all the puppies?\n"\
  "There might be a secret or two you didn't\n"\
  "find.  Maybe a bug that was accidentally\n"\
  "left in.\n"\
  "\n"\
  "Anyway, hope you enjoyed it! We should do\n"\
  "this again sometime..."
  
  
// after level 6, put this:
  
#define C1TEXT \
  "TWENTY MILL IN GOLD DOESN'T SEEM WORTH ALL\n" \
  "THIS AGGRAVATION, DOES IT, HACKER? MAKES\n" \
  "THE PEN LOOK LIKE A FREAKIN' PICNIC!\n" \
  "\n" \
  "BUTT-UGLY BIO-MUTATIONS AND YOUR FELLOW\n" \
  "HUMANS HUNG FROM A CEILING LIKE\n" \
  "FOOD SACKS.\n" \
  "\n" \
  "WHAT THE HELL IS THIS GENIE? LIKE NO\n" \
  "COMPUTER YOU'VE EVER HACKED!\n" \
  "\n" \
  "YOU BETTER FIND THE NEXT TERMINAL, SLICE\n" \
  "A RIDE THROUGH C-SPACE, DICE SOME MUTANT\n" \
  "BUTT, AND GET THE HELL OUT OF DODGE!"
  
// After level 11, put this:
  
#define C2TEXT \
  "WHERE ARE ALL THE PEOPLE?!\n" \
  "\n" \
  "PARIS IS A GHOST TOWN, UNLESS YOU CONSIDER\n" \
  "MUTANT BUGS OUTSTANDING CITIZENS.\n" \
  "\n" \
  "YOU'VE HIT BLOODY RESISTANCE. MAN, CAN\n" \
  "THESE BUGS FIGHT! LUCKY FOR YOU THEY'RE NOT\n" \
  "THE BRIGHTEST PORCH LIGHTS ON THE BLOCK.\n" \
  "\n" \
  "BUT YOU'VE GOTTEN SOME OF THE INFORMATICS\n" \
  "THE SUBCOMMITTEE WANTS. AND IT'S NASTY!\n" \
  "\n" \
  "HUMAN NEURAL FLUIDS FEED THESE BUGS! NO\n" \
  "WONDER THE NEIGHBORHOOD'S GETTING KIND OF\n" \
  "SPARSE. REPORT TO THE SUBCOMMITTEE. AND\n" \
  "WATCH YOUR BACK...\n"
  
  
// After level 20, put this:
  
#define C3TEXT \
  "CIVILIZATION AS YOU KNEW IT IS NADA!\n" \
  "\n" \
  "NO FRIENDS, NO FAMILY. NO MORE PEOPLE.\n" \
  "NOT NORMAL PEOPLE, ANYWAY.\n" \
  "\n" \
  "ONLY ONE THING LEFT...GENIE!\n" \
  "AND IF YOU HAVE TO GO TO THE END OF THE\n" \
  "UNIVERSE YOU'LL FIND ITS MUTANT BUTT!\n" \
  "'CAUSE NOW YOU'RE PISSED!\n" \
  "\n" \
  "AND THE GOLD? HELL, THIS IS FOR FREE.\n" \
  "\n" \
  ".....(TO BE CONTINUED)....."
  
  
// After level 29, put this:
  
#define C4TEXT \
  "unused"  
  
// Before level 31, put this:
  
  #define C5TEXT \
"YOU'RE ALIVE!\n" \
"\n" \
"WHAT ARE THOSE ODDS, HACKER?!\n" \
"'CAUSE IT'S CRAWLING WITH BUGS.\n" \
"\n" \
"YOU CAN'T REACH THE SUBCOMMITTEE, WHICH\n" \
"MEANS IT'S BEEN COMPROMISED.\n" \
"\n" \
"\n" \
"YOU... ARE ALONE."
  
// Before level 32, put this:
  
  #define C6TEXT \
  "unused"
  
// after map 06 
  
  #define P1TEXT  \
  "unused"
  
// after map 11
  
  #define P2TEXT \
  "unused"
  
// after map 20
  
  #define P3TEXT \
  "unused"
  
// after map 30
  
  #define P4TEXT \
  "unused"
  
// before map 31
  
#define P5TEXT \
  "unused"
  
// before map 32
  
#define P6TEXT \
  "unused"
  
  
#define T1TEXT \
  "unused"
  
#define T2TEXT \
  "unused"
  
#define T3TEXT \
  "unused"
  
#define T4TEXT \
  "unused"  
  
#define T5TEXT \
  "unused"
  
#define T6TEXT \
  "unused"

//
// Character cast strings F_FINALE.C
//
#define CC_ZOMBIE "ZOMBIEMAN"
#define CC_SHOTGUN  "SHOTGUN GUY"
#define CC_HEAVY  "HEAVY WEAPON DUDE"
#define CC_IMP  "IMP"
#define CC_DEMON  "DEMON"
#define CC_LOST "LOST SOUL"
#define CC_CACO "CACODEMON"
#define CC_HELL "HELL KNIGHT"
#define CC_BARON  "BARON OF HELL"
#define CC_ARACH  "ARACHNOTRON"
#define CC_PAIN "PAIN ELEMENTAL"
#define CC_REVEN  "REVENANT"
#define CC_MANCU  "MANCUBUS"
#define CC_ARCH "ARCH-VILE"
#define CC_SPIDER "THE SPIDER MASTERMIND"
#define CC_CYBER  "THE CYBERDEMON"
#define CC_HERO "OUR HERO"


#endif

//----------------------------------------------------------------------------
//
// $Log: d_englsh.h,v $
// Revision 1.2  2000-08-12 21:29:25  fraggle
// change license header
//
// Revision 1.1.1.1  2000/07/29 13:20:41  fraggle
// imported sources
//
// Revision 1.5  1998/05/04  21:33:57  thldrmn
// commenting and reformatting
//
// Revision 1.4  1998/02/08  15:26:40  jim
// New messages for keyed doors
//
// Revision 1.3  1998/01/28  12:23:02  phares
// TNTCOMP cheat code added
//
// Revision 1.2  1998/01/26  19:26:21  phares
// First rev with no ^Ms
//
// Revision 1.1.1.1  1998/01/19  14:02:51  rand
// Lee's Jan 19 sources
//
//
//----------------------------------------------------------------------------
