cd jasper-version-2.0.33
patch -p1 < ../jasper-1.900.1-fix-filename-buffer-overflow.patch

sed -r 's|(CMAKE_SKIP_BUILD_RPATH) FALSE|\1 TRUE|g' -i CMakeLists.txt
mkdir -p build-shared build-static

options=(
  -DCMAKE_INSTALL_PREFIX=/usr
  -DCMAKE_INSTALL_LIBDIR=lib
  -DCMAKE_BUILD_TYPE=Release
  -DJAS_ENABLE_OPENGL=ON
  -DJAS_ENABLE_LIBJPEG=ON
  -DJAS_ENABLE_AUTOMATIC_DEPENDENCIES=OFF
  -DCMAKE_SKIP_RPATH=ON
)

echo "Building static lib..."
cd build-static
cmake ${options[@]} -DJAS_ENABLE_SHARED=OFF ..
make
cd ..

echo "Building shared lib..."
cd build-shared
cmake ${options[@]} -DJAS_ENABLE_SHARED=ON ..
make
cd ..

make -C build-static DESTDIR=$PWD/../../build install
make -C build-shared DESTDIR=$PWD/../../build install
