pkgname=libaio
pkgver=0.3.112
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Bartłomiej Piotrowski <barthalion@gmail.com>
# and contributor Thomas S Hatch <thatch45 at gmail dot com>

# Allow cc to use gcc
mkdir -p path
ln -s /usr/bin/gcc path/cc
export PATH=$PATH:$PWD/path

cd "$srcdir/$pkgname-$pkgver"

# AIO library is a thin wrapper around kernel syscalls, it does not use stdlib
# and other helpers like stack protection libraries
CFLAGS="-march=${CARCH/_/-} -mtune=generic -O2 -pipe"
make

# work around gcc warning (-Werror) in test suite
sed -i '/strncpy/s#sizeof(TEMPLATE)#sizeof(template)#' harness/cases/19.t
sed -i '/strncpy/s#sizeof(TEMPLATE)#sizeof(temp_file)#' harness/cases/21.t

make partcheck

make prefix="$pkgdir/usr" install
