pkgname=sdl2
pkgver=2.0.16
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Sven-Hendrik Haase <svenstaro@gmail.com>

cd SDL2-${pkgver}
cmake \
  -Bbuild \
  -GNinja \
  -DCMAKE_INSTALL_PREFIX=/usr \
  -DCMAKE_INSTALL_LIBDIR=lib \
  -DSDL_STATIC=OFF \
  -DSDL_DLOPEN=ON \
  -DARTS=OFF \
  -DESD=OFF \
  -DNAS=OFF \
  -DALSA=ON \
  -DHIDAPI=ON \
  -DPULSEAUDIO_SHARED=ON \
  -DVIDEO_WAYLAND=ON \
  -DRPATH=OFF \
  -DCLOCK_GETTIME=ON \
  -DJACK_SHARED=ON \
  -DPIPEWIRE=OFF \
  -DPIPEWIRE_SHARED=OFF
ninja -C build

DESTDIR="${pkgdir}" ninja -C build install

sed -i "s/libSDL2\.a/libSDL2main.a/g" "$pkgdir"/usr/lib/cmake/SDL2/SDL2Targets-noconfig.cmake

install -Dm644 LICENSE.txt "$pkgdir/usr/share/licenses/$pkgname/LICENSE"
