'----------------------------------------------------------------------------
' DIRECTQB.BI
'   Include file for the DirectQB library version 1.0
'
' This file contains constants and function declarations used by the library
' Always include this file into your own programs!
'----------------------------------------------------------------------------

'$DYNAMIC
DEFINT A-Z

DECLARE FUNCTION DQBinit (BYVAL NumLayers, BYVAL NumSounds)
DECLARE FUNCTION DQBemsSeg ()
DECLARE FUNCTION DQBpoint (BYVAL Layer, BYVAL x, BYVAL y)
DECLARE FUNCTION DQBdimToGet (BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2)
DECLARE FUNCTION DQBloadLayer (BYVAL Layer, BYVAL FileSeg, BYVAL FileOff, BYVAL PalSeg, BYVAL PalOff)
DECLARE FUNCTION DQBsaveLayer (BYVAL Layer, BYVAL FileSeg, BYVAL FileOff, BYVAL PalSeg, BYVAL PalOff, BYVAL Format)
DECLARE FUNCTION DQBkey (BYVAL ScanCode)
DECLARE FUNCTION DQBjoyDetected (BYVAL JoyNum)
DECLARE FUNCTION DQBjoyMove (BYVAL JoyNum, BYVAL Direction)
DECLARE FUNCTION DQBjoyFire (BYVAL JoyNum, BYVAL Button)
DECLARE SUB DQBcopyLayer (BYVAL SourceLayer, BYVAL DestLayer)
DECLARE SUB DQBclearLayer (BYVAL Layer)
DECLARE SUB DQBpset (BYVAL Layer, BYVAL x, BYVAL y, BYVAL Col)
DECLARE SUB DQBbox (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBboxf (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBscroll (BYVAL Layer, BYVAL dx, BYVAL dy)
DECLARE SUB DQBwait (BYVAL Times)
DECLARE SUB DQBsetTransPut ()
DECLARE SUB DQBsetSolidPut ()
DECLARE SUB DQBsetClipBox (BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2)
DECLARE SUB DQBget (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBput (BYVAL Layer, BYVAL x, BYVAL y, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBsetCol (BYVAL ColorIndex, BYVAL r, BYVAL g, BYVAL B)
DECLARE SUB DQBgetCol (BYVAL ColorIndex, r, g, B)
DECLARE SUB DQBsetPal (BYVAL PalSeg, BYVAL PalOff)
DECLARE SUB DQBgetPal (BYVAL PalSeg, BYVAL PalOff)
DECLARE SUB DQBfadeIn (BYVAL PalSeg, BYVAL PalOff)
DECLARE SUB DQBprint (BYVAL Layer, BYVAL TextSeg, BYVAL TextOff, BYVAL x, BYVAL y, BYVAL Col)
DECLARE SUB DQBsetBIOSfont ()
DECLARE SUB DQBsetFont (BYVAL FontSeg, BYVAL FontOff)
DECLARE SUB DQBsetTransText ()
DECLARE SUB DQBsetSolidText ()
DECLARE SUB DQBsetTextBackCol (BYVAL Col)
DECLARE SUB DQBinstallKeyboard ()
DECLARE SUB DQBremoveKeyboard ()
DECLARE SUB DQBpollJoy (BYVAL JoyNum)
DECLARE SUB DQBclose ()

CONST VIDEO = 0, BSV = 0, PCX = 1
CONST KEYESC = 1, KEYENTER = 28, KEYSPACE = 57
CONST KEYUP = 72, KEYDOWN = 80, KEYLEFT = 75, KEYRIGHT = 77
CONST UP = 0, DOWN = 1, LEFT = 2, RIGHT = 3
CONST JOY1 = 0, JOY2 = 1, BUTA = 0, BUTB = 1

