pkgname=e2fsprogs
pkgdir=$PWD/../build
srcdir=$PWD
pkgver=1.46.2

# Borrowed from arch linux and maintainer Ronald van Haren <ronald.archlinux.org>
# and contributor judd <jvinet@zeroflux.org>

cd "${srcdir}/${pkgname}-${pkgver}"

# Remove unnecessary init.d directory
sed -i '/init\.d/s|^|#|' misc/Makefile.in

echo "Configuring..."
echo ""
./configure \
  --prefix=/usr \
  --with-root-prefix="" \
  --libdir=/usr/lib \
  --sbindir=/usr/bin \
  --enable-elf-shlibs \
  --disable-fsck \
  --disable-uuidd \
  --disable-libuuid \
  --disable-libblkid

echo "Making..."
echo ""
make

# regenerate locale files
echo "Regenerating locale files..."
echo ""

find po/ -name '*.gmo' -delete
make -C po update-gmo

echo "Installing..."
echo ""
make DESTDIR="${pkgdir}" install install-libs

echo "Packaging..."
echo ""
sed -i -e 's/^AWK=.*/AWK=awk/' "${pkgdir}/usr/bin/compile_et"

# remove references to build directory
sed -i -e 's#^SS_DIR=.*#SS_DIR="/usr/share/ss"#' "${pkgdir}/usr/bin/mk_cmds"
sed -i -e 's#^ET_DIR=.*#ET_DIR="/usr/share/et"#' "${pkgdir}/usr/bin/compile_et"

# remove static libraries with a shared counterpart
rm -rf "${pkgdir}"/usr/lib/lib{com_err,e2p,ext2fs,ss}.a

# install MIT license
install -Dm644 "${srcdir}/MIT-LICENSE" \
  "${pkgdir}/usr/share/licenses/${pkgname}/MIT-LICENSE"
