pkgbase=libseccomp
pkgname=libseccomp
pkgver=2.5.1
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Levente Polyak <anthraxx[at]archlinux[dot]org>
# and maintainer Tobias Powalowski <tpowa@archlinux.org>
# and contributor Daniel Micay <danielmicay@gmail.com>
# and contributor Patryk Kowalczyk < patryk at kowalczyk dot ws>

cd ${pkgbase}-${pkgver}
autoreconf -fiv

./configure --prefix=/usr
make

cd src/python
env VERSION_RELEASE=${pkgver} CFLAGS="-I ${srcdir}/${pkgbase}-${pkgver}/include"  python setup.py build
cd ../..

make check

make DESTDIR="${pkgdir}" install
install -Dm 644 CHANGELOG README.md SECURITY.md -t "${pkgdir}/usr/share/doc/${pkgname}"

# Package up python library
cd src/python
env VERSION_RELEASE=${pkgver} python setup.py install --root="${pkgdir}" --prefix=/usr -O1 --skip-build

mkdir -p "${pkgdir}/python-libseccomp/usr/lib"
mv "${pkgdir}/usr/lib/python3.7" "${pkgdir}/python-libseccomp/usr/lib"
