var grid = canvasDatagrid({
    parentNode: document.getElementById("gridctr"),
    data: []
});

window.defaultStyleLibrary["default"] = grid.defaults.styles;
window.defaultStyleLibrary["default"]["width"] = "100%";
window.defaultStyleLibrary["default"]["height"] = "100%";

const process = function(data) {
    var wb = XLSX.read(data, {type: 'array'});
    var ws = wb.Sheets[wb.SheetNames[0]];
    var json_data = XLSX.utils.sheet_to_json(ws, {header: 1});

    grid.data = json_data;
    grid.style.height = "100%";
    grid.style.width  = "100%";

    //var range = XLSX.utils.decode_range(ws['!ref']);
    //for(var i = range.s.c; i <= range.e.c; ++i) grid.schema[i - range.s.c].title = XLSX.utils.encode_col(i);
};

const load = function(url) {
    // Get the pcx data
    var xhr = new XMLHttpRequest();
    const loadingProgress = document.querySelector('.progress');

    xhr.onload = function(e) {
        var data = xhr.response;
        loadingProgress.style.width = "100%";
        loadingProgress.style.display = "none";

        process(data);
    }
    xhr.onerror = function(e) {
        console.log(url + " has errored");
    }
    xhr.addEventListener("progress", function(evt) {
        if (evt.lengthComputable) {
            var percentComplete = evt.loaded / evt.total;
            loadingProgress.style.width = (percentComplete * 100) + "%";
        }
        else {
            var total = parseInt(xhr.getResponseHeader('X-Content-Length'));

            if (total) {
                var percentComplete = evt.loaded / total;

                loadingProgress.style.width = (percentComplete * 100) + "%";
            }
        }
    }, false);

    xhr.open('GET', url);
    xhr.responseType = 'arraybuffer';

    // Add authentication
    //xhr.setRequestHeader('X-Occam-Token', token);

    xhr.send();
};

// Handle OCCAM events
window.addEventListener('message', function(event) {
    if (event.data.name === 'updateConfiguration') {
        // Configuration has changed
        var configuration = event.data.data.values;

        grid.style = window.defaultStyleLibrary[configuration.theme];
    }
    else if (event.data.name === 'updateStatus') {
        if (event.data.data == "ready") {
            // Maximize the widget
            window.parent.postMessage({
                'name': 'updateSize',
                'data': {
                    'height': "100%"
                }
            }, '*');

            // Request input data
            window.parent.postMessage({
                'name': 'updateInput'
            }, '*');
        }
    }
    else if (event.data.name === 'updateInput') {
        var objectInfo = event.data.data;

        inputInfo = objectInfo;

        if (!inputInfo) {
            // No input
            // Load default
            process(new Uint8Array([]));
        }
        else {
            // Get the filename to pull the data
            var filename = objectInfo.file;
            var url = objectInfo.url;

            // Load the input.
            load(url);
        }
    }
});

// We are ready.

// Request configuration data.
window.parent.postMessage({
    'name': 'updateConfiguration'
}, '*');

// Request input file (if any)
window.parent.postMessage({
    'name': 'updateInput'
}, '*');
