# Get the configuration
TYPE=`jq .type -r ${PWD}/../inputs/0/0/config.json`
NAME=`jq .name -r ${PWD}/../inputs/0/0/config.json`
SUBTYPES=

echo "Combining"
echo

LOCAL_ROOT=${PWD}

echo 'Configuration:'
cat ${PWD}/../inputs/0/0/config.json

# Craft the object
mkdir -p ../output
cd ../output

# For every input
count=`jq '.inputs[2].connections | length' -r ${LOCAL_ROOT}/../task.json`
i=0

IMAGE_COUNT=0
IMAGES=
DESCRIPTION=
FILE=

# Add the main object
KEY=".inputs[1].connections[0]"

INPUT_TYPE=`jq "${KEY}.type" -r ${LOCAL_ROOT}/../task.json`
INPUT_NAME=`jq "${KEY}.name" -r ${LOCAL_ROOT}/../task.json`

echo
echo "Adding main input [${INPUT_TYPE}] '${INPUT_NAME}'"

echo " - Looking at the input's metadata description..."
INPUT_PATH=`jq "${KEY}.paths.mount" -r ${LOCAL_ROOT}/../task.json`

INPUT_SUBTYPES=`jq ".subtype" ${INPUT_PATH}/object.json`

if [[ "${NAME}" == "" ]]; then
  NAME="${INPUT_NAME}"
fi

if [[ "${TYPE}" == "" ]]; then
  TYPE="${INPUT_TYPE}"
fi

if [[ -z "${SUBTYPES}" && "${INPUT_SUBTYPES}" != "null" ]]; then
  SUBTYPES="${INPUT_SUBTYPES}"
fi

echo " - Looking for a description..."
description=`jq ".description" ${INPUT_PATH}/object.json`
if [[ -z "${DESCRIPTION}" && "${description}" != "null" ]]; then
  DESCRIPTION="${description}"
fi

echo " - Looking for a file..."
file=`jq ".file" ${INPUT_PATH}/object.json | sed "s/^\"/    \"input-${i}\//"`
if [[ -z "${FILE}" && "${file}" != "null" ]]; then
  FILE="${file}"
fi

echo " - Gathering images..."
image_count=`jq '.images | length' -r ${INPUT_PATH}/object.json`
j=0
while [ ${j} != ${image_count} ]; do
  image=`jq ".images[${j}]" ${INPUT_PATH}/object.json | sed "s/^\"/    \"input-${i}\//"`
  IMAGES="${IMAGES} ${image}"
  j=$((j + 1))
done
IMAGE_COUNT=$((IMAGE_COUNT + image_count))

echo '{' > temp.json
echo "  \"name\": \"${NAME}\"," >> temp.json
echo "  \"type\": \"${TYPE}\"," >> temp.json

if [ ! -z "${SUBTYPES}" ]; then
  echo "  \"subtype\": ${SUBTYPES}," >> temp.json
fi

echo '  "install": [' >> temp.json
jq "${KEY} | {id: .id, uid: .uid, name: .name, type: .type} + (if has(\"source\") then {source: .source} else {} end) + {\"to\": \"input-0\"}" ${LOCAL_ROOT}/../task.json >> temp.json

if [ 0 != ${count} ]; then
  echo ',' >> temp.json
fi

# Add each input object
while [ ${i} != ${count} ]; do
  KEY=".inputs[2].connections[${i}]"
  i=$((i + 1))

  INPUT_TYPE=`jq "${KEY}.type" -r ${LOCAL_ROOT}/../task.json`
  INPUT_NAME=`jq "${KEY}.name" -r ${LOCAL_ROOT}/../task.json`
  echo
  echo "Adding input [${INPUT_TYPE}] '${INPUT_NAME}'"
  jq "${KEY} | {id: .id, uid: .uid, name: .name, type: .type} + (if has(\"source\") then {source: .source} else {} end) + {\"to\": \"input-${i}\"}" ${LOCAL_ROOT}/../task.json >> temp.json

  echo " - Looking at the input's metadata description..."
  INPUT_PATH=`jq "${KEY}.paths.mount" -r ${LOCAL_ROOT}/../task.json`

  echo " - Gathering images..."
  image_count=`jq '.images | length' -r ${INPUT_PATH}/object.json`
  j=0
  while [ ${j} != ${image_count} ]; do
    image=`jq ".images[${j}]" ${INPUT_PATH}/object.json | sed "s/^\"/    \"input-${i}\//"`
    IMAGES="${IMAGES} ${image}"
    j=$((j + 1))
  done
  IMAGE_COUNT=$((IMAGE_COUNT + image_count))

  if [ ${i} != ${count} ]; then
    echo ',' >> temp.json
  fi
done

echo '  ],' >> temp.json

echo
echo "Generating Object"

# Look for a suitable description
if [ ! -z "${DESCRIPTION}" ]; then
  echo " - Adding description..."
  echo "  \"description\": ${DESCRIPTION}," >> temp.json
fi

# Look for a suitable description
if [ ! -z "${FILE}" ]; then
  echo " - Adding file..."
  echo "  \"file\": ${FILE}," >> temp.json
fi

# Combine images together
echo '  "images": [' >> temp.json

IMAGES=(${IMAGES})
i=0
while [ ${i} != ${IMAGE_COUNT} ]; do
  image=${IMAGES[i]}
  echo " - Attaching image at ${image}..."
  i=$((i + 1))
  if [ ${i} != ${IMAGE_COUNT} ]; then
    image=${image},
  fi
  echo ${image} >> temp.json
done

echo '  ]' >> temp.json

echo '}' >> temp.json

# Pretty print it
cat temp.json | jq > object.json

echo
echo 'object.json:'
cat object.json
