/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.sisu.inject.InjectorPublisher;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.launch.SisuExtender;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.BundleTracker;

public class BundleScanner
extends BundleTracker {
    private static final Set<String> SUPPORT_BUNDLE_NAMES;
    private static final Map<Long, Injector> bundleInjectors;
    protected final int stateMask;
    protected final MutableBeanLocator locator;

    static {
        Class[] supportTypes;
        SUPPORT_BUNDLE_NAMES = new HashSet<String>();
        Class[] classArray = supportTypes = new Class[]{Inject.class, Guice.class, SisuExtender.class};
        int n = supportTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            SUPPORT_BUNDLE_NAMES.add(FrameworkUtil.getBundle((Class)type).getSymbolicName());
            ++n2;
        }
        bundleInjectors = Collections.synchronizedMap(new HashMap());
    }

    public BundleScanner(BundleContext context, int stateMask, MutableBeanLocator locator) {
        super(context, stateMask, null);
        this.stateMask = stateMask;
        this.locator = locator;
    }

    public final void open() {
        super.open();
        this.purgeBundles();
    }

    public final Object addingBundle(Bundle bundle, BundleEvent event) {
        if (this.injectBundle(bundle)) {
            Long bundleId = bundle.getBundleId();
            if (!bundleInjectors.containsKey(bundleId)) {
                bundleInjectors.put(bundleId, null);
                Injector injector = this.createInjector(bundle);
                bundleInjectors.put(bundleId, injector);
            }
            return bundle;
        }
        return null;
    }

    public final void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        Long bundleId = bundle.getBundleId();
        if (this.evictBundle(bundle, bundleInjectors.get(bundleId))) {
            this.destroyInjector(bundle, bundleInjectors.remove(bundleId));
        }
    }

    public final void purgeBundles() {
        for (Long bundleId : new ArrayList<Long>(bundleInjectors.keySet())) {
            Bundle bundle = this.context.getBundle(bundleId.longValue());
            if (!this.evictBundle(bundle, bundleInjectors.get(bundleId))) continue;
            this.destroyInjector(bundle, bundleInjectors.remove(bundleId));
        }
    }

    protected boolean injectBundle(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        if (SUPPORT_BUNDLE_NAMES.contains(symbolicName)) {
            return false;
        }
        Dictionary headers = bundle.getHeaders();
        String host = (String)headers.get("Fragment-Host");
        if (host != null) {
            return false;
        }
        String imports = (String)headers.get("Import-Package");
        if (imports == null) {
            return false;
        }
        return imports.contains("javax.inject") || imports.contains("com.google.inject");
    }

    protected Injector createInjector(Bundle bundle) {
        return Guice.createInjector(new BundleModule(bundle, this.locator));
    }

    protected boolean evictBundle(Bundle bundle, Injector injector) {
        return bundle == null || (bundle.getState() & this.stateMask) == 0;
    }

    protected void destroyInjector(Bundle bundle, Injector injector) {
        if (injector != null) {
            this.locator.remove(new InjectorPublisher(injector, null));
        }
    }
}

