/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.serde.tsv;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.spout.Scheme;
import org.apache.storm.sql.runtime.utils.Utils;
import org.apache.storm.tuple.Fields;

public class TsvScheme
implements Scheme {
    private final List<String> fieldNames;
    private final char delimiter;

    public TsvScheme(List<String> fieldNames, char delimiter) {
        this.fieldNames = fieldNames;
        this.delimiter = delimiter;
    }

    public List<Object> deserialize(ByteBuffer ser) {
        String data = new String(org.apache.storm.utils.Utils.toByteArray((ByteBuffer)ser), StandardCharsets.UTF_8);
        List<String> parts = Utils.split(data, this.delimiter);
        Preconditions.checkArgument((parts.size() == this.fieldNames.size() ? 1 : 0) != 0, (Object)"Invalid schema");
        ArrayList<Object> list = new ArrayList<Object>(this.fieldNames.size());
        list.addAll(parts);
        return list;
    }

    public Fields getOutputFields() {
        return new Fields(this.fieldNames);
    }
}

