/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class HiveDecimalWritable
implements WritableComparable<HiveDecimalWritable> {
    private static final Log LOG = LogFactory.getLog(HiveDecimalWritable.class);
    private byte[] internalStorage = new byte[0];
    private int scale;
    private final LazyBinaryUtils.VInt vInt = new LazyBinaryUtils.VInt();

    public HiveDecimalWritable() {
    }

    public HiveDecimalWritable(byte[] bytes, int scale) {
        this.set(bytes, scale);
    }

    public HiveDecimalWritable(HiveDecimalWritable writable) {
        this.set(writable.getHiveDecimal());
    }

    public HiveDecimalWritable(HiveDecimal value) {
        this.set(value);
    }

    public void set(HiveDecimal value) {
        this.set(value.unscaledValue().toByteArray(), value.scale());
    }

    public void set(HiveDecimal value, int maxPrecision, int maxScale) {
        this.set(HiveDecimal.enforcePrecisionScale((HiveDecimal)value, (int)maxPrecision, (int)maxScale));
    }

    public void set(HiveDecimalWritable writable) {
        this.set(writable.getHiveDecimal());
    }

    public void set(byte[] bytes, int scale) {
        this.internalStorage = bytes;
        this.scale = scale;
    }

    public void setFromBytes(byte[] bytes, int offset, int length) {
        LazyBinaryUtils.readVInt(bytes, offset, this.vInt);
        this.scale = this.vInt.value;
        LazyBinaryUtils.readVInt(bytes, offset += this.vInt.length, this.vInt);
        offset += this.vInt.length;
        if (this.internalStorage.length != this.vInt.value) {
            this.internalStorage = new byte[this.vInt.value];
        }
        System.arraycopy(bytes, offset, this.internalStorage, 0, this.vInt.value);
    }

    public HiveDecimal getHiveDecimal() {
        return HiveDecimal.create((BigInteger)new BigInteger(this.internalStorage), (int)this.scale);
    }

    public HiveDecimal getHiveDecimal(int maxPrecision, int maxScale) {
        return HiveDecimalUtils.enforcePrecisionScale(HiveDecimal.create((BigInteger)new BigInteger(this.internalStorage), (int)this.scale), maxPrecision, maxScale);
    }

    public void readFields(DataInput in) throws IOException {
        this.scale = WritableUtils.readVInt((DataInput)in);
        int byteArrayLen = WritableUtils.readVInt((DataInput)in);
        if (this.internalStorage.length != byteArrayLen) {
            this.internalStorage = new byte[byteArrayLen];
        }
        in.readFully(this.internalStorage);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.scale);
        WritableUtils.writeVInt((DataOutput)out, (int)this.internalStorage.length);
        out.write(this.internalStorage);
    }

    public int compareTo(HiveDecimalWritable that) {
        return this.getHiveDecimal().compareTo(that.getHiveDecimal());
    }

    public static void writeToByteStream(Decimal128 dec, ByteStream.Output byteStream) {
        HiveDecimal hd = HiveDecimal.create((BigDecimal)dec.toBigDecimal());
        LazyBinaryUtils.writeVInt(byteStream, hd.scale());
        byte[] bytes = hd.unscaledValue().toByteArray();
        LazyBinaryUtils.writeVInt(byteStream, bytes.length);
        byteStream.write(bytes, 0, bytes.length);
    }

    public void writeToByteStream(ByteStream.RandomAccessOutput byteStream) {
        LazyBinaryUtils.writeVInt(byteStream, this.scale);
        LazyBinaryUtils.writeVInt(byteStream, this.internalStorage.length);
        byteStream.write(this.internalStorage, 0, this.internalStorage.length);
    }

    public String toString() {
        return this.getHiveDecimal().toString();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof HiveDecimalWritable)) {
            return false;
        }
        HiveDecimalWritable bdw = (HiveDecimalWritable)other;
        return this.getHiveDecimal().compareTo(bdw.getHiveDecimal()) == 0;
    }

    public int hashCode() {
        return this.getHiveDecimal().hashCode();
    }

    public byte[] getInternalStorage() {
        return this.internalStorage;
    }

    public int getScale() {
        return this.scale;
    }
}

