/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.serde.tsv;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.storm.sql.runtime.IOutputSerializer;

public class TsvSerializer
implements IOutputSerializer,
Serializable {
    private final List<String> fields;
    private final char delimiter;

    public TsvSerializer(List<String> fields, char delimiter) {
        this.fields = fields;
        this.delimiter = delimiter;
    }

    @Override
    public ByteBuffer write(List<Object> data, ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder(512);
        for (int i = 0; i < data.size(); ++i) {
            Object o = data.get(i);
            if (i == 0) {
                sb.append(o);
                continue;
            }
            sb.append(this.delimiter);
            sb.append(o);
        }
        return ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8));
    }
}

