/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.util.Util;

public enum SqlSyntax {
    FUNCTION{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(operator, writer, call);
        }
    }
    ,
    FUNCTION_STAR{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(operator, writer, call);
        }
    }
    ,
    BINARY{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseBinarySyntax(operator, call, writer, leftPrec, rightPrec);
        }
    }
    ,
    PREFIX{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            assert (call.operandCount() == 1);
            writer.keyword(operator.getName());
            ((SqlNode)call.operand(0)).unparse(writer, operator.getLeftPrec(), operator.getRightPrec());
        }
    }
    ,
    POSTFIX{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            assert (call.operandCount() == 1);
            ((SqlNode)call.operand(0)).unparse(writer, operator.getLeftPrec(), operator.getRightPrec());
            writer.keyword(operator.getName());
        }
    }
    ,
    SPECIAL{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            throw Util.needToImplement((Object)this);
        }
    }
    ,
    FUNCTION_ID{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(operator, writer, call);
        }
    }
    ,
    INTERNAL{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            throw Util.newInternal("Internal operator '" + operator + "' cannot be un-parsed");
        }
    };


    public abstract void unparse(SqlWriter var1, SqlOperator var2, SqlCall var3, int var4, int var5);
}

