/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Private
public class AdminACLsManager {
    static Log LOG = LogFactory.getLog(AdminACLsManager.class);
    private final UserGroupInformation owner;
    private final AccessControlList adminAcl;
    private final boolean aclsEnabled;

    public AdminACLsManager(Configuration conf) {
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        try {
            this.owner = UserGroupInformation.getCurrentUser();
            this.adminAcl.addUser(this.owner.getShortUserName());
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not add current user to admin:" + e));
            throw new YarnRuntimeException((Throwable)e);
        }
        this.aclsEnabled = conf.getBoolean("yarn.acl.enable", false);
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    public boolean areACLsEnabled() {
        return this.aclsEnabled;
    }

    public AccessControlList getAdminAcl() {
        return this.adminAcl;
    }

    public boolean isAdmin(UserGroupInformation callerUGI) {
        return this.adminAcl.isUserAllowed(callerUGI);
    }

    public boolean checkAccess(UserGroupInformation callerUGI) {
        if (!this.areACLsEnabled()) {
            return true;
        }
        return this.isAdmin(callerUGI);
    }
}

