/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;

public class AggregateValuesRule
extends RelOptRule {
    public static final AggregateValuesRule INSTANCE = new AggregateValuesRule();

    private AggregateValuesRule() {
        super(AggregateValuesRule.operand(Aggregate.class, null, Predicates.not(Aggregate.IS_NOT_GRAND_TOTAL), AggregateValuesRule.operand(Values.class, null, Values.IS_EMPTY, AggregateValuesRule.none()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Values values = (Values)call.rel(1);
        Util.discard(values);
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        ArrayList<RexLiteral> literals = new ArrayList<RexLiteral>();
        block4: for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            switch (aggregateCall.getAggregation().getKind()) {
                case COUNT: 
                case SUM0: {
                    literals.add((RexLiteral)rexBuilder.makeLiteral((Object)BigDecimal.ZERO, aggregateCall.getType(), false));
                    continue block4;
                }
                case MIN: 
                case MAX: 
                case SUM: {
                    literals.add(rexBuilder.constantNull());
                    continue block4;
                }
            }
            return;
        }
        call.transformTo(relBuilder.values((Iterable<? extends List<RexLiteral>>)ImmutableList.of(literals), aggregate.getRowType()).build());
        call.getPlanner().setImportance(aggregate, 0.0);
    }
}

