/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hive.hcatalog.common.HCatContext;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.HCatRecordObjectInspector;
import org.apache.hive.hcatalog.data.HCatRecordObjectInspectorFactory;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatRecordSerDe
implements SerDe {
    private static final Logger LOG = LoggerFactory.getLogger(HCatRecordSerDe.class);
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private StructTypeInfo rowTypeInfo;
    private HCatRecordObjectInspector cachedObjectInspector;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        LOG.debug("Initializing HCatRecordSerDe");
        LOG.debug("props to serde: {}", tbl.entrySet());
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(","));
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        LOG.debug("columns: {} {}", (Object)columnNameProperty, this.columnNames);
        LOG.debug("types: {} {}", (Object)columnTypeProperty, this.columnTypes);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.columnNames, this.columnTypes);
        this.cachedObjectInspector = HCatRecordObjectInspectorFactory.getHCatRecordObjectInspector(this.rowTypeInfo);
    }

    public void initialize(HCatSchema hsch) throws SerDeException {
        LOG.debug("Initializing HCatRecordSerDe through HCatSchema {}.", (Object)hsch);
        this.rowTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)hsch.getSchemaAsTypeString());
        this.cachedObjectInspector = HCatRecordObjectInspectorFactory.getHCatRecordObjectInspector(this.rowTypeInfo);
    }

    public Object deserialize(Writable data) throws SerDeException {
        if (!(data instanceof HCatRecord)) {
            throw new SerDeException(this.getClass().getName() + ": expects HCatRecord!");
        }
        return (HCatRecord)data;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        return new DefaultHCatRecord(HCatRecordSerDe.serializeStruct(obj, (StructObjectInspector)objInspector));
    }

    private static List<?> serializeStruct(Object obj, StructObjectInspector soi) throws SerDeException {
        List fields = soi.getAllStructFieldRefs();
        List list = soi.getStructFieldsDataAsList(obj);
        if (list == null) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>(fields.size());
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                ObjectInspector foi = ((StructField)fields.get(i)).getFieldObjectInspector();
                Object f = list.get(i);
                Object res = HCatRecordSerDe.serializeField(f, foi);
                l.add(i, res);
            }
        }
        return l;
    }

    public static Object serializeField(Object field, ObjectInspector fieldObjectInspector) throws SerDeException {
        Object res;
        if (fieldObjectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            res = HCatRecordSerDe.serializePrimitiveField(field, fieldObjectInspector);
        } else if (fieldObjectInspector.getCategory() == ObjectInspector.Category.STRUCT) {
            res = HCatRecordSerDe.serializeStruct(field, (StructObjectInspector)fieldObjectInspector);
        } else if (fieldObjectInspector.getCategory() == ObjectInspector.Category.LIST) {
            res = HCatRecordSerDe.serializeList(field, (ListObjectInspector)fieldObjectInspector);
        } else if (fieldObjectInspector.getCategory() == ObjectInspector.Category.MAP) {
            res = HCatRecordSerDe.serializeMap(field, (MapObjectInspector)fieldObjectInspector);
        } else {
            throw new SerDeException(HCatRecordSerDe.class.toString() + " does not know what to do with fields of unknown category: " + fieldObjectInspector.getCategory() + " , type: " + fieldObjectInspector.getTypeName());
        }
        return res;
    }

    private static Map<?, ?> serializeMap(Object f, MapObjectInspector moi) throws SerDeException {
        ObjectInspector koi = moi.getMapKeyObjectInspector();
        ObjectInspector voi = moi.getMapValueObjectInspector();
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        Map readMap = moi.getMap(f);
        if (readMap == null) {
            return null;
        }
        for (Map.Entry entry : readMap.entrySet()) {
            m.put(HCatRecordSerDe.serializeField(entry.getKey(), koi), HCatRecordSerDe.serializeField(entry.getValue(), voi));
        }
        return m;
    }

    private static List<?> serializeList(Object f, ListObjectInspector loi) throws SerDeException {
        List l = loi.getList(f);
        if (l == null) {
            return null;
        }
        ObjectInspector eloi = loi.getListElementObjectInspector();
        if (eloi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            ArrayList<Object> list = new ArrayList<Object>(l.size());
            for (int i = 0; i < l.size(); ++i) {
                list.add(((PrimitiveObjectInspector)eloi).getPrimitiveJavaObject(l.get(i)));
            }
            return list;
        }
        if (eloi.getCategory() == ObjectInspector.Category.STRUCT) {
            ArrayList list = new ArrayList(l.size());
            for (int i = 0; i < l.size(); ++i) {
                list.add(HCatRecordSerDe.serializeStruct(l.get(i), (StructObjectInspector)eloi));
            }
            return list;
        }
        if (eloi.getCategory() == ObjectInspector.Category.LIST) {
            ArrayList list = new ArrayList(l.size());
            for (int i = 0; i < l.size(); ++i) {
                list.add(HCatRecordSerDe.serializeList(l.get(i), (ListObjectInspector)eloi));
            }
            return list;
        }
        if (eloi.getCategory() == ObjectInspector.Category.MAP) {
            ArrayList list = new ArrayList(l.size());
            for (int i = 0; i < l.size(); ++i) {
                list.add(HCatRecordSerDe.serializeMap(l.get(i), (MapObjectInspector)eloi));
            }
            return list;
        }
        throw new SerDeException(HCatRecordSerDe.class.toString() + " does not know what to do with fields of unknown category: " + eloi.getCategory() + " , type: " + eloi.getTypeName());
    }

    private static Object serializePrimitiveField(Object field, ObjectInspector fieldObjectInspector) {
        if (field == null) {
            return null;
        }
        Object f = ((PrimitiveObjectInspector)fieldObjectInspector).getPrimitiveJavaObject(field);
        if (f != null && HCatContext.INSTANCE.getConf().isPresent()) {
            Configuration conf = (Configuration)HCatContext.INSTANCE.getConf().get();
            if (f instanceof Boolean && conf.getBoolean("hcat.data.convert.boolean.to.integer", false)) {
                return (Boolean)f != false ? 1 : 0;
            }
            if (f instanceof Short && conf.getBoolean("hcat.data.tiny.small.int.promotion", false)) {
                return new Integer(((Short)f).shortValue());
            }
            if (f instanceof Byte && conf.getBoolean("hcat.data.tiny.small.int.promotion", false)) {
                return new Integer(((Byte)f).byteValue());
            }
        }
        return f;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return HCatRecord.class;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

