/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.ObjectProviderFactoryImpl;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class ObjectProviderPool {
    private long maxIdle = 100L;
    private long expirationTime;
    private Map<ObjectProvider, Long> recyclableOps;
    private CleanUpThread cleaner;
    private Class opClass;

    public ObjectProviderPool(int maxIdle, boolean reaperThread, Class opClass) {
        this.maxIdle = maxIdle;
        this.expirationTime = 30000L;
        this.recyclableOps = new ConcurrentHashMap<ObjectProvider, Long>();
        this.opClass = opClass;
        if (reaperThread) {
            this.cleaner = new CleanUpThread(this, this.expirationTime * 2L);
            this.cleaner.start();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("Started pool of ObjectProviders (maxPool=" + maxIdle + ", reaperThread=" + reaperThread + ")");
        }
    }

    public void close() {
        if (this.cleaner != null) {
            this.cleaner.interrupt();
        }
    }

    protected ObjectProvider create(ExecutionContext ec, AbstractClassMetaData cmd) {
        return (ObjectProvider)ClassUtils.newInstance(this.opClass, ObjectProviderFactoryImpl.OBJECT_PROVIDER_CTR_ARG_CLASSES, new Object[]{ec, cmd});
    }

    public boolean validate(ObjectProvider op) {
        return true;
    }

    public void expire(ObjectProvider op) {
    }

    public synchronized ObjectProvider checkOut(ExecutionContext ec, AbstractClassMetaData cmd) {
        ObjectProvider op2;
        long now = System.currentTimeMillis();
        if (this.recyclableOps.size() > 0) {
            Set<ObjectProvider> ops = this.recyclableOps.keySet();
            for (ObjectProvider op2 : ops) {
                if (now - this.recyclableOps.get(op2) > this.expirationTime) {
                    this.recyclableOps.remove(op2);
                    this.expire(op2);
                    op2 = null;
                    continue;
                }
                if (this.validate(op2)) {
                    this.recyclableOps.remove(op2);
                    op2.connect(ec, cmd);
                    return op2;
                }
                this.recyclableOps.remove(op2);
                this.expire(op2);
                op2 = null;
            }
        }
        op2 = this.create(ec, cmd);
        return op2;
    }

    public synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        Set<ObjectProvider> ops = this.recyclableOps.keySet();
        for (ObjectProvider op : ops) {
            if (now - this.recyclableOps.get(op) <= this.expirationTime) continue;
            this.recyclableOps.remove(op);
            this.expire(op);
            op = null;
        }
        System.gc();
    }

    public synchronized void checkIn(ObjectProvider op) {
        if ((long)this.recyclableOps.size() < this.maxIdle) {
            this.recyclableOps.put(op, System.currentTimeMillis());
        }
    }

    class CleanUpThread
    extends Thread {
        private ObjectProviderPool pool;
        private long sleepTime;

        CleanUpThread(ObjectProviderPool pool, long sleepTime) {
            this.pool = pool;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            boolean needsStopping = false;
            while (!needsStopping) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    needsStopping = true;
                }
                this.pool.cleanUp();
            }
        }
    }
}

